<?php

declare(strict_types=1);

namespace kirillbdev\WCUkrShipping\Helpers;

use kirillbdev\WCUkrShipping\Enums\CarrierSlug;
use kirillbdev\WCUkrShipping\Foundation\SmartyParcelAddressDeliveryMethod;

final class SmartyParcelHelper
{
    public static function isConnected(): bool
    {
        return get_option(WCUS_OPTION_SMARTY_PARCEL_USER_STATUS) === 'connected';
    }

    public static function canPurchaseLabelForOrder(\WC_Order $order): bool
    {
        $forbiddenMethods = apply_filters('wcus_labels_forbidden_methods', [
            'local_pickup',
        ]);

        foreach ($forbiddenMethods as $method) {
            if ($order->has_shipping_method($method)) {
                return false;
            }
        }

        return true;
    }

    public static function getOrderCarrierSlug(\WC_order $order): ?string
    {
        $orderShipping = WCUSHelper::getOrderShippingMethod($order);
        if ($orderShipping === null) {
            return null;
        }

        switch ($orderShipping->get_method_id()) {
            case WCUS_SHIPPING_METHOD_NOVA_POSHTA:
                return CarrierSlug::NOVA_POSHTA;
            case WCUS_SHIPPING_METHOD_UKRPOSHTA:
                return CarrierSlug::UKRPOSHTA;
            case WCUS_SHIPPING_METHOD_ROZETKA:
                return CarrierSlug::ROZETKA_DELIVERY;
            case WCUS_SHIPPING_METHOD_NOVA_POST:
                return CarrierSlug::NOVA_POST;
            case WCUS_SHIPPING_METHOD_SP_ADDRESS_DELIVERY:
                $shippingMethod = new SmartyParcelAddressDeliveryMethod($orderShipping->get_instance_id());
                return $shippingMethod->get_option('carrier_slug');
        }

        return null;
    }
}
