<?php

namespace kirillbdev\WCUkrShipping\Foundation;

use kirillbdev\WCUkrShipping\Services\SmartyParcel\ManifestService;

if ( ! defined('ABSPATH')) {
    exit;
}

class SmartyParcelAddressDeliveryMethod extends \WC_Shipping_Method
{
    public function __construct($instance_id = 0)
    {
        parent::__construct($instance_id);

        $this->id = WCUS_SHIPPING_METHOD_SP_ADDRESS_DELIVERY;
        $this->method_title = 'SmartyParcel Address Delivery';
        $this->method_description = __('Address delivery shipping method by SmartyParcel', 'wc-ukr-shipping-i18n');

        $this->supports = [
            'shipping-zones',
            'instance-settings',
            'instance-settings-modal',
        ];

        $this->init();
    }

    public function __get($name)
    {
        return $this->$name;
    }

    function init(): void
    {
        $this->init_settings();
        $this->init_form_fields();

        $this->title = $this->get_option('title');

        // @phpstan-ignore-next-line
        add_action('woocommerce_update_options_shipping_' . $this->id, [$this, 'process_admin_options']);
    }

    public function init_form_fields(): void
    {
        /** @var ManifestService $manifestService */
        $manifestService = wcus_container()->make(ManifestService::class);

        $manifest = $manifestService->getManifest();
        $carrierOptions = [];
        foreach ($manifest['carriers'] ?? [] as $slug => $carrier) {
            $carrierOptions[$slug] = $carrier['name'];
        }

        $this->instance_form_fields = [
            'title' => [
                'title' => __('Name', 'woocommerce' ),
                'type' => 'text',
                'description' => '',
                'default' => 'SmartyParcel Address Delivery',
            ],
            'carrier_slug' => [
                'title' => __('Carrier', 'woocommerce' ),
                'type' => 'select',
                'options' => $carrierOptions,
                'description' => '',
                'default' => $carrierOptions[0] ?? '',
            ]
        ];
    }

    public function calculate_shipping($package = []): void
    {
        $this->add_rate([
            'label' => $this->title,
            'cost' => 0,
            'package' => $package,
        ]);
    }

    /**
     * Is this method available?
     * @param array $package
     * @return bool
     */
    public function is_available($package)
    {
        return $this->is_enabled();
    }
}
