<?php

declare(strict_types=1);

namespace kirillbdev\WCUkrShipping\DB\Repositories;

use kirillbdev\WCUkrShipping\Model\Address\Area;

class HardcodedAreaRepository implements AreaRepositoryInterface
{
    /**
     * @var array<string, string[]>
     */
    private array $data = [
        '71508128-9b87-11de-822f-000c2965ae0e' => ['АРК', 'АРК'],
        '71508129-9b87-11de-822f-000c2965ae0e' => ['Вінницька', 'Винницкая'],
        '7150812a-9b87-11de-822f-000c2965ae0e' => ['Волинська', 'Волынская'],
        '7150812b-9b87-11de-822f-000c2965ae0e' => ['Дніпропетровська', 'Днепропетровская'],
        '7150812c-9b87-11de-822f-000c2965ae0e' => ['Донецька', 'Донецкая'],
        '7150812d-9b87-11de-822f-000c2965ae0e' => ['Житомирська', 'Житомирская'],
        '7150812e-9b87-11de-822f-000c2965ae0e' => ['Закарпатська', 'Закарпатская'],
        '7150812f-9b87-11de-822f-000c2965ae0e' => ['Запорізька', 'Запорожская'],
        '71508130-9b87-11de-822f-000c2965ae0e' => ['Івано-Франківська', 'Ивано-Франковская'],
        '71508131-9b87-11de-822f-000c2965ae0e' => ['Київська', 'Киевская'],
        '71508132-9b87-11de-822f-000c2965ae0e' => ['Кіровоградська', 'Кировоградская'],
        '71508133-9b87-11de-822f-000c2965ae0e' => ['Луганська', 'Луганская'],
        '71508134-9b87-11de-822f-000c2965ae0e' => ['Львівська', 'Львовская'],
        '71508135-9b87-11de-822f-000c2965ae0e' => ['Миколаївська', 'Николаевская'],
        '71508136-9b87-11de-822f-000c2965ae0e' => ['Одеська', 'Одесская'],
        '71508137-9b87-11de-822f-000c2965ae0e' => ['Полтавська', 'Полтавская'],
        '71508138-9b87-11de-822f-000c2965ae0e' => ['Рівненська', 'Ровенская'],
        '71508139-9b87-11de-822f-000c2965ae0e' => ['Сумська', 'Сумская'],
        '7150813a-9b87-11de-822f-000c2965ae0e' => ['Тернопільська', 'Тернопольская'],
        '7150813b-9b87-11de-822f-000c2965ae0e' => ['Харківська', 'Харьковская'],
        '7150813c-9b87-11de-822f-000c2965ae0e' => ['Херсонська', 'Херсонская'],
        '7150813d-9b87-11de-822f-000c2965ae0e' => ['Хмельницька', 'Хмельницкая'],
        '7150813e-9b87-11de-822f-000c2965ae0e' => ['Черкаська', 'Черкасская'],
        '7150813f-9b87-11de-822f-000c2965ae0e' => ['Чернівецька', 'Черновицкая'],
        '71508140-9b87-11de-822f-000c2965ae0e' => ['Чернігівська', 'Черниговская'],
    ];

    public function findByRef(string $ref): ?Area
    {
        $row = $this->data[$ref] ?? null;

        return $row !== null
            ? new Area($ref, $row[1], $row[0])
            : null;
    }
}
