<?php

declare(strict_types=1);

namespace kirillbdev\WCUkrShipping\Component\Rates;

use kirillbdev\WCUkrShipping\Contracts\Rates\RatesCalculatorInterface;
use kirillbdev\WCUkrShipping\Dto\Rates\OrderInfoDto;

class FreeShippingRatesCalculator implements RatesCalculatorInterface
{
    private RatesCalculatorInterface $fallbackCalculator;
    private float $minAmount;

    public function __construct(RatesCalculatorInterface $fallbackCalculator, float $minAmount)
    {
        $this->fallbackCalculator = $fallbackCalculator;
        $this->minAmount = $minAmount;
    }

    public function calculateRates(OrderInfoDto $orderInfo): ?float
    {
        if ($this->minAmount <= 0) {
            return null;
        }

        return $orderInfo->subTotal >= $this->minAmount
            ? 0
            : $this->fallbackCalculator->calculateRates($orderInfo);
    }
}
