<?php
namespace Wnsm;
if (!defined('ABSPATH')) exit;


use Automattic\WooCommerce\Utilities\FeaturesUtil;
use WP_Error;

class Hooks
{
    public function __construct(App $app, Settings $settings)
    {
        $this->settings = $settings;
        $this->app = $app;
    }

    public function woocommerceShippingSettings($fields)
    {
        if (is_array($fields)) {
            $fields = array_merge($fields, $this->settings->getFields());
        }

        return $fields;
    }

    public function woocommerceNoShippingAvailableHtml($msgId): callable
    {
        return function($value) use ($msgId) {
            $msg = $this->settings->getMsgHtml($msgId);
            if (isset($msg)) {
                $value = $msg;
            }
            return $value;
        };
    }

    /** @noinspection PhpUnusedParameterInspection */
    public function woocommerceCheckoutAfterValidation($data, $errors)
    {

        /** @var WP_Error $errors */

        if (!isset($errors->errors['shipping'])) {
            return;
        }

        $shippingErrors = &$errors->errors['shipping'];
        if (!$shippingErrors) {
            return;
        }

        // Look for an existings translation for the predefined WooCommerce message.
        // Avoid using the double-underscore function here to prevent it being spotted or re-translated by automatic tools.
        // phpcs:ignore WordPress.WP.I18n.TextDomainMismatch,WordPress.WP.I18n.LowLevelTranslationFunction
        $builtinError = translate('No shipping method has been selected. Please double check your address, or contact us if you need any help.', 'woocommerce');
        $idx = array_search($builtinError, $shippingErrors, true);
        if ($idx === false) {
            return;
        }

        $msg = $this->settings->getMsgHtml(Settings::MSG_CHECKOUT_NOTICE);
        if (!isset($msg)) {
            return;
        }

        $shippingErrors[$idx] = $msg;
    }

    public function pluginActionLinks($links)
    {
        $settingsUrl = admin_url('admin.php?page=wc-settings&tab=shipping&section=options#' . urlencode(Settings::SETTINGS_SECTION_ID.'-description'));
        array_unshift($links, '<a href="'.esc_html($settingsUrl).'">'.__('Edit messages', 'wc-no-shipping-message').'</a>');
        return $links;
    }

    public function adminEnqueueScripts($hookSuffix)
    {
        // phpcs:disable WordPress.Security.NonceVerification.Recommended
        if (!($hookSuffix === 'woocommerce_page_wc-settings' &&
            isset($_GET['tab'], $_GET['section']) &&
            $_GET['tab'] === 'shipping' &&
            $_GET['section'] === 'options')) {
            return;
        }
        // phpcs:enable

        // phpcs:disable WordPress.WP.EnqueuedResourceParameters.NoExplicitVersion,WordPress.WP.EnqueuedResourceParameters.MissingVersion
        wp_enqueue_script('wnsm_admin_js', $this->app->getAssetUrl('admin.js'), [], false, true);
        wp_enqueue_style('wnsm_admin_css', $this->app->getAssetUrl('admin.css'));
        // phpcs:enable
    }

    public static function declareHposCompat(string $pluginFile) {
        add_action('before_woocommerce_init', static function() use($pluginFile) {
            if (class_exists(FeaturesUtil::class)) {
                FeaturesUtil::declare_compatibility('custom_order_tables', $pluginFile, true);
            }
        });
    }

    /** @var Settings */
    private $settings;

    /** @var App */
    private $app;
}
