<?php
if (!function_exists('wcfmmp_has_marketplace')) {
	function wcfmmp_has_marketplace() {
		$active_plugins = (array) get_option('active_plugins', []);
		if (is_multisite()) {
			$active_plugins = array_merge($active_plugins, get_site_option('active_sitewide_plugins', []));
		}

		$has_marketplace = false;

		// WC Vendors Check
		if (!$has_marketplace) {
			$has_marketplace = (
				in_array('wc-vendors/class-wc-vendors.php', $active_plugins)
				|| array_key_exists('wc-vendors/class-wc-vendors.php', $active_plugins)
				|| class_exists('WC_Vendors')
			) ? 'WC Vendors' : false;
		}

		// WC Marketplace Check
		if (!$has_marketplace) {
			$has_marketplace = (
				in_array('dc-woocommerce-multi-vendor/dc_product_vendor.php', $active_plugins)
				|| array_key_exists('dc-woocommerce-multi-vendor/dc_product_vendor.php', $active_plugins)
				|| class_exists('WCMp')
			) ? 'WC Marketplace' : false;
		}

		// WC Product Vendors Check
		if (!$has_marketplace) {
			$has_marketplace = (
				in_array('woocommerce-product-vendors/woocommerce-product-vendors.php', $active_plugins)
				|| array_key_exists('woocommerce-product-vendors/woocommerce-product-vendors.php', $active_plugins)
			) ? 'WC Product Vendors' : false;
		}

		// Dokan Lite Check
		if (!$has_marketplace) {
			$has_marketplace = (
				in_array('dokan-lite/dokan.php', $active_plugins)
				|| array_key_exists('dokan-lite/dokan.php', $active_plugins)
				|| class_exists('WeDevs_Dokan')
			) ? 'Dokan Multivendor' : false;
		}

		return $has_marketplace;
	}
}
