<?php
/**
 * VkNavMenuClassCustom
 *
 * WordPress の wp_nav_menu() や ナビゲーションブロックで出力されるナビゲーションのメニュー項目は、
 * 表示中のページに該当するメニュー項目にはカレントクラスが付与される事になっている。
 * しかしながら、
 *
 * ■ wp_nav_menu() の場合
 * * 投稿トップのメニュー項目は、カスタム投稿タイプを表示中にもカレントクラスが付与されてしまう
 * * カスタム投稿タイプのトップのメニュー項目があっても、カスタム投稿タイプ関連のページを表示中にカレントクラスが付かない
 *
 * ■ ナビゲーションブロックの場合
 * * 投稿トップのメニュー項目は、投稿関連のページを表示中にもカレントクラスが付与されない
 * * カスタム投稿タイプのトップのメニュー項目があっても、カスタム投稿タイプ関連のページを表示中にカレントクラスが付かない
 *
 * という問題があるため、表示中のページに該当するメニュー項目にカレントクラスを付与する処理を追加する。
 *
 * ここでいう関連ページとは、
 * * 投稿タイプアーカイブ
 * * 投稿詳細ページ
 * * 投稿タイプに紐づいたカスタムタクソノミー（ターム）アーカイブ
 * * 投稿タイプの年月日アーカイブ
 * を指します
 *
 * @package vektor-inc/vk-all-in-one-expansion-unit
 */

require_once __DIR__ . '/class-nav-menu-class-custom.php';
if ( class_exists( 'VkNavMenuClassCustom' ) ) {
	VkNavMenuClassCustom::init();
}
