/*!
  Vision - jQuery Interactive Image Plugin
  @name jquery.vision.js
  @description jQuery plugin for creating a responsive interactive images
  @version 1.5.3
  @author Max Lawrence
  @site http://avirtum.com
*/
!function(_,s,a,e){"use strict";var L=function(){return/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)},d=function(){var t,o=a.createElement("fakeelement"),i={animation:"animationend",MSAnimationEnd:"msAnimationEnd",OAnimation:"oAnimationEnd",MozAnimation:"mozAnimationEnd",WebkitAnimation:"webkitAnimationEnd"};for(t in i)if(o.style[t]!==e)return i[t];return null},r=function(t){try{if(t&&"function"==typeof URL){var o=new URL(s.location.href),i="https:";if(o.protocol==i)return(o=new URL(t)).protocol=i,o.href}}catch(t){}return t},n="vision-instance",i=0;!function(){for(var t=null,o=a.getElementsByTagName("script"),i=0;i<o.length;i++)if(/jquery.vision/.test(o[i].src)){t=o[i].src.substring(o[i].src.lastIndexOf("/")),t=o[i].src.replace(t,"");break}}();function h(t,o){i++,this.$container=null,this.config=null,this.controls={},this.imageWidth=0,this.imageHeight=0,this.layers=[],this.bodyClick=!1,this.themeClass=null,this.lightboxThemeClass=null,this.timerIdResize=null,this.timerIdScroll=null,this.elementZindex=[],this.inboxLayer=null,this.lightboxLayer=null,this.ready=!1,this._init(t,o)}h.prototype={VERSION:"1.5.3",defaults:{theme:"default",width:null,height:null,imgSrc:null,delayResize:50,layers:[],fonts:[],className:null,onPreInit:null,onLoad:null},defaultsLayer:{id:null,type:null,x:0,y:0,width:null,height:null,angle:null,autoWidth:!1,autoHeight:!1,url:null,urlNewWindow:!1,urlNoFollow:!1,scaling:!1,noevents:!1,tooltip:null,popover:null,data:null,dataSelector:null,className:null},defaultsTooltip:{active:!0,placement:"top",offset:{top:0,left:0},width:null,widthFromCSS:!1,trigger:"hover",followCursor:!1,scaling:!1,interactive:!0,smart:!1,showOnInit:!1,showAnimation:null,hideAnimation:null,duration:200,data:null,dataSelector:null,className:null},defaultsPopover:{active:!0,type:"tooltip",placement:"top",offset:{x:0,y:0},scaling:!1,interactive:!0,smart:!0,mobileType:"lightbox",trigger:"hover",showAnimation:null,hideAnimation:null,duration:300,className:null},lightbox:{layer:null,theme:null,controls:{}},_init:function(t,o){this.$container=t,this.config=o,this._create()},_create:function(){var o=this;function i(){o._buildDOM(),o._setTheme(o.config.theme),o._bind(),o._initLayers(),o._beforeReady(),o._updateSize(),o._ready()}var e=new Image;e.onload=_.proxy(function(t){o.imageWidth=e.width,o.imageHeight=e.height,setTimeout(i,300)},this),e.onerror=_.proxy(function(t){console.error('Cannot load image "'+o.config.imgSrc+'"')},this),e.src=o.config.imgSrc},_setTheme:function(t){this.$container.removeClass(this.themeClass),this.themeClass=t?"vision-theme-"+t.toLowerCase():null,this.lightboxThemeClass=t?"vision-lightbox-theme-"+t.toLowerCase():null,this.$container.addClass(this.themeClass)},_buildDOM:function(){if(this.controls.$image=_("<div>").addClass("vision-image").css({"background-image":"url("+this.config.imgSrc+")"}),this.controls.$stage=_("<div>").addClass("vision-stage"),this.controls.$layers=_("<div>").addClass("vision-layers"),this.controls.$tooltips=_("<div>").addClass("vision-tooltips"),this.controls.$popovers=_("<div>").addClass("vision-popovers"),this.controls.$lastLayer=_("<div>").addClass("vision-layer-last").attr("tabindex",1),this.controls.$inbox=_("<div>").addClass("vision-inbox").addClass("vision-hide").attr("tabindex",1),this.controls.$inboxInner=_("<div>").addClass("vision-inner"),this.controls.$inboxForm=_("<div>").addClass("vision-form"),this.controls.$inboxFrame=_("<div>").addClass("vision-frame"),this.controls.$inboxClose=_("<div>").addClass("vision-close"),this.controls.$inbox.append(this.controls.$inboxInner.append(this.controls.$inboxForm.append(this.controls.$inboxFrame,this.controls.$inboxClose))),this.lightbox.controls.$lightbox||(this.lightbox.controls.$lightbox=_("<div>").addClass("vision-lightbox").addClass("vision-hide").attr("tabindex",1),this.lightbox.controls.$lightboxInner=_("<div>").addClass("vision-inner"),this.lightbox.controls.$lightboxForm=_("<div>").addClass("vision-form"),this.lightbox.controls.$lightboxFrame=_("<div>").addClass("vision-frame"),this.lightbox.controls.$lightboxClose=_("<div>").addClass("vision-close"),this.lightbox.controls.$lightbox.append(this.lightbox.controls.$lightboxInner.append(this.lightbox.controls.$lightboxForm.append(this.lightbox.controls.$lightboxFrame,this.lightbox.controls.$lightboxClose))),_("body").append(this.lightbox.controls.$lightbox),this.lightbox.controls.$lightboxClose.on("click",_.proxy(this._onLightboxCloseClick,this)),this.lightbox.controls.$lightbox.on("keydown",_.proxy(this._onLightboxKeyboard,this))),this.controls.$stage.append(this.controls.$layers.append(this.controls.$lastLayer),this.controls.$tooltips,this.controls.$popovers),this.controls.$image.append(this.controls.$stage),this.$container.prepend(this.controls.$image,this.controls.$inbox).addClass("vision-map").addClass(this.config.className),null!=this.config.width&&this.$container.css({width:this.config.width}),null!=this.config.height&&this.$container.css({height:this.config.height}),this.config.fonts)for(var t=0;t<this.config.fonts.length;t++){var o,i,e=this.config.fonts[t],s=e.replace(new RegExp("[+]|[:]","g"),"");0==_("#"+s).length&&(o=a.getElementsByTagName("head")[0],(i=a.createElement("link")).setAttribute("id",s),i.setAttribute("rel","stylesheet"),i.setAttribute("href","https://fonts.googleapis.com/css?family="+e),o.appendChild(i))}},_bind:function(){_(s).on("resize",_.proxy(this._onResize,this)),_(s).on("scroll",_.proxy(this._onScroll,this)),_("body").on("click",_.proxy(this._onBodyClickTooltip,this)),this.controls.$lastLayer.on("focus",_.proxy(this._onLastLayerFocus,this)),this.controls.$inboxClose.on("click",_.proxy(this._onInboxCloseClick,this)),this.controls.$inbox.on("keydown",_.proxy(this._onInboxKeyboard,this))},_unbind:function(){_(s).off("resize",_.proxy(this._onResize,this)),_(s).off("scroll",_.proxy(this._onScroll,this)),_("body").off("click",_.proxy(this._onBodyClickTooltip,this)),this.controls.$lastLayer.off("focus",_.proxy(this._onLastLayerFocus,this)),this.controls.$inboxClose.off("click",_.proxy(this._onInboxCloseClick,this)),this.controls.$inbox.off("keydown",_.proxy(this._onInboxKeyboard,this))},_beforeReady:function(){this.$container.addClass("vision-before-ready"),this.$container.get(0).offsetHeight,this.$container.is(":hidden")&&this.$container.css("display","block");for(var t=0;t<this.layers.length;t++){var o,i,e=this.layers[t];e.cfg.tooltip.widthFromCSS||(o=e.$tooltipData.get(0).getBoundingClientRect(),i=e.cfg.tooltip.width||o.width+1,e.$tooltipData.css({width:i})),e.$tooltipPos.css({width:"auto"}),e.cfg.popover.widthFromCSS||(o=e.$popover.get(0).getBoundingClientRect(),i=e.cfg.popover.width||o.width+1,e.$popover.css({width:i})),e.$popoverPos.css({width:"auto"}),!e.cfg.tooltip.showOnInit&&"sticky"!=e.cfg.tooltip.trigger||this._showTooltip(e),e.cfg.popover.showOnInit&&this._showPopover(e)}this.$container.removeClass("vision-before-ready")},_ready:function(){if(this.config.onLoad){var t=null;if("string"==typeof this.config.onLoad)try{t=new Function(this.config.onLoad)}catch(t){console.error("Can not compile onLoad function: "+t.message)}else"function"==typeof this.config.onLoad&&(t=this.config.onLoad);t&&t.call(this)}this.$container.addClass("vision-ready"),this.ready=!0,this.$container.trigger("vision:ready",[this])},_destroy:function(){this._unbind(),this.controls.$image.remove(),this.controls.$inbox.remove(),this.$container.removeClass("vision-ready").removeClass("vision-map").removeClass(this.config.className),this._setTheme(null),0==--i&&(this.lightbox.controls.$lightbox.remove(),_("body").removeClass("vision-lightbox-active"))},_updateSize:function(){var t=this.imageHeight/this.imageWidth,o=this.$container.width(),t=null==this.config.height?t*o:this.$container.height();null==this.config.height&&this.controls.$image.css({height:t});for(var i=o/this.imageWidth,e=t/this.imageHeight,s=0;s<this.layers.length;s++){var a=this.layers[s];a.cfg.scaling&&a.$layerZoom.css({transform:"scale("+i+","+e+")"}),a.cfg.tooltip.scaling&&a.$tooltipZoom.css({transform:"scale("+i+","+e+")"}),a.tooltipVisible&&this._showTooltip(a),a.cfg.popover.scaling&&"tooltip"==a.cfg.popover.type&&(a.$popoverZoom.css({transform:"scale("+i+","+e+")"}),a.popoverVisible&&this._showPopover(a))}},_updatePlacement:function(){for(var t=0;t<this.layers.length;t++){var o=this.layers[t];o.tooltipVisible&&this._showTooltip(o),o.popoverVisible&&this._showPopover(o)}},_initLayers:function(){if(this.config.layers)for(var t=0;t<this.config.layers.length;t++){var o=this.config.layers[t];this._addLayer(o)}this.$container.find(".vision-store").remove(),this.$container.find(".vision-img-placeholder").remove()},_addLayer:function(t){t.tooltip=_.extend(!0,{},this.defaultsTooltip,t.tooltip),t.popover=_.extend(!0,{},this.defaultsPopover,t.popover);var t=_.extend(!0,{},this.defaultsLayer,t),o=_("<div>").addClass("vision-layer").addClass(t.className),i=_("<div>").addClass("vision-pos").css({top:t.y+"%",left:t.x+"%"}),e=_("<div>").addClass("vision-zoom"),s=_("<div>").addClass("vision-offset"),a=_("link"==t.type?"<a>":"<div>").addClass("vision-body");t.id||(t.id=this.uuid()),t.noevents&&o.addClass("vision-noevents"),o.attr("data-layer-id",t.id),o.attr("data-layer-type",t.type),o.attr("data-layer-title",t.title),t.url&&o.addClass("vision-url"),"link"==t.type&&a.addClass("vision-link").attr({href:t.url,rel:t.urlNoFollow?"nofollow":null,target:t.urlNewWindow?"_blank":null}),"focus"!=t.tooltip.trigger&&"focus"!=t.popover.trigger||o.attr("tabindex",1),t.autoWidth||null==t.width||a.css({width:t.width}),t.autoHeight||null==t.height||a.css({height:t.height}),null!=t.angle&&a.css({transform:"rotate("+t.angle+"deg)"}),t.data?a.html(t.data):t.dataSelector?(C=_(t.dataSelector)).length&&(C.detach(),a.append(C)):(C=this.$container.find('.vision-store .vision-layers-data [data-layer-id="'+t.id+'"]')).length&&((w=C.contents()).detach(),a.append(w),C.remove()),o.append(i.append(e.append(s.append(a)))),this.controls.$layers.append(o),this.controls.$lastLayer.detach(),this.controls.$layers.append(this.controls.$lastLayer);var l=_("<div>").addClass("vision-tooltip").addClass("vision-hide").addClass(t.tooltip.className),r=_("<div>").addClass("vision-pos").css({top:t.y+"%",left:t.x+"%"}),n=_("<div>").addClass("vision-zoom"),h=_("<div>").addClass("vision-offset"),p=_("<div>").addClass("vision-form"),c=_("<div>").addClass("vision-arrow"),d=_("<div>").addClass("vision-body"),g=_("<div>").addClass("vision-data");l.attr("data-layer-id",t.id),(t.tooltip.showAnimation||t.tooltip.hideAnimation)&&t.tooltip.duration&&p.css({"animation-duration":t.tooltip.duration+"ms","-webkit-animation-duration":t.tooltip.duration+"ms"}),t.tooltip.data?g.html(t.tooltip.data):t.tooltip.dataSelector?(C=_(t.tooltip.dataSelector)).length&&(C.detach(),g.append(C)):(C=this.$container.find('.vision-store .vision-tooltips-data [data-layer-id="'+t.id+'"]')).length&&((w=C.contents()).detach(),g.append(w),C.remove()),l.append(r.append(n.append(h.append(p.append(d.append(g),c))))),this.controls.$tooltips.append(l);var f=_("<div>").addClass("vision-popover").addClass("vision-hide").addClass(t.popover.className),v=_("<div>").addClass("vision-pos").css({top:t.y+"%",left:t.x+"%"}),b=_("<div>").addClass("vision-zoom"),m=_("<div>").addClass("vision-offset"),y=_("<div>").addClass("vision-form"),u=_("<div>").addClass("vision-arrow"),x=_("<div>").addClass("vision-body"),$=_("<div>").addClass("vision-data");f.attr("data-layer-id",t.id);var C,w,c=L()?t.popover.mobileType:t.popover.type;f.attr("data-type",c),t.popover.data?f.html(t.popover.data):t.popover.dataSelector?(C=_(t.popover.dataSelector)).length&&(C.detach(),f.append(C)):(C=this.$container.find('.vision-store .vision-popovers-data [data-layer-id="'+t.id+'"]')).length&&((w=C.contents()).detach(),$.append(w),C.remove()),f.append(v.append(b.append(m.append(y.append(x.append($),u))))),this.controls.$popovers.append(f);t={$layer:o,$layerPos:i,$layerZoom:e,$layerOffset:s,$layerBody:a,$tooltip:l,$tooltipPos:r,$tooltipZoom:n,$tooltipOffset:h,$tooltipForm:p,$tooltipBody:d,$tooltipData:g,tooltipVisible:!1,$popover:f,$popoverPos:v,$popoverZoom:b,$popoverOffset:m,$popoverForm:y,$popoverBody:x,$popoverData:$,popoverVisible:!1,cfg:t};return this._bindLayer(t),this.layers.push(t),this._updateBodyClick(),t.id},_bindLayer:function(t){switch(t.cfg.url&&"link"!=t.cfg.type&&t.$layer.on("click",_.proxy(this._onLayerClickLink,this,t)),t.cfg.tooltip.trigger){case"hover":t.$layer.on("mouseenter",_.proxy(this._onLayerEnterTooltip,this,t)),t.$layer.on("mouseleave",_.proxy(this._onLayerLeaveTooltip,this,t)),L()&&(t.$layer.on("focus",_.proxy(this._onLayerFocusTooltip,this,t)),t.$layer.on("blur",_.proxy(this._onLayerBlurTooltip,this,t)));break;case"focus":t.$layer.on("focus",_.proxy(this._onLayerFocusTooltip,this,t)),t.$layer.on("blur",_.proxy(this._onLayerBlurTooltip,this,t));break;case"click":case"clickbody":t.$layer.on("click",_.proxy(this._onLayerClickTooltip,this,t))}switch(t.cfg.popover.trigger){case"hover":t.$layer.on("mouseenter",_.proxy(this._onLayerEnterPopover,this,t)),L()&&(t.$layer.on("focus",_.proxy(this._onLayerFocusPopover,this,t)),t.$layer.on("blur",_.proxy(this._onLayerBlurPopover,this,t)));break;case"focus":t.$layer.on("focus",_.proxy(this._onLayerFocusPopover,this,t)),t.$layer.on("blur",_.proxy(this._onLayerBlurPopover,this,t));break;case"click":t.$layer.on("click",_.proxy(this._onLayerClickPopover,this,t));break;case"dblclick":t.$layer.on("dblclick",_.proxy(this._onLayerClickPopover,this,t))}},_deleteLayer:function(t){if(0<=t&&t<this.layers.length){var o=this.layers[t];return o.$layer.remove(),o.$tooltip.remove(),this.layers.splice(t,1),!0}return!1},_updateBodyClick:function(){this.bodyClick=!1;for(var t=0;t<this.layers.length;t++){var o=this.layers[t];if("clickbody"==o.cfg.tooltip.trigger||"focus"==o.cfg.tooltip.trigger){this.bodyClick=!0;break}}},_getViewportOffset:function(t){var o=_(s),i=o.scrollLeft(),e=o.scrollTop(),o=t.get(0).getBoundingClientRect(),t=t.offset();return{left:t.left-i,top:t.top-e,bottom:Math.max(a.documentElement.clientHeight,s.innerHeight||0)-t.top+e-o.height,right:Math.max(a.documentElement.clientWidth,s.innerWidth||0)-t.left+i-o.width}},_showTooltip:function(t,o,i,e){if(t.cfg.tooltip.active){var s=this.imageHeight/this.imageWidth,a=this.$container.width(),s=null==this.config.height?s*a:this.$container.height(),a=a/this.imageWidth,s=s/this.imageHeight,l="hover"==t.cfg.tooltip.trigger&&t.cfg.tooltip.followCursor?5:t.cfg.height*(t.cfg.scaling&&!t.cfg.tooltip.scaling?s:1)/2,r="hover"==t.cfg.tooltip.trigger&&t.cfg.tooltip.followCursor?5:t.cfg.width*(t.cfg.scaling&&!t.cfg.tooltip.scaling?a:1)/2,s=t.cfg.tooltip.offset.top,a=t.cfg.tooltip.offset.left;switch(o=o||!1,i=i||t.cfg.tooltip.placement,e=e||!1,t.$tooltip.removeClass(t.$tooltip.data("placement")),i&&t.$tooltip.addClass("vision-"+i).data("placement","vision-"+i),i){case"top":l=-l,r=0;break;case"right":l=0;break;case"bottom":r=0;break;case"left":l=0,r=-r;break;case"top-left":l=-l,r=-r;break;case"top-right":case"right-top":l=-l;break;case"right-bottom":break;case"bottom-left":r=-r;break;case"bottom-right":break;case"left-top":l=-l,r=-r;break;case"left-bottom":r=-r;break;default:l=r=t.cfg.tooltip.followCursor?5:0}if(t.$tooltipOffset.css({"margin-top":l,"margin-left":r}),t.cfg.tooltip.followCursor&&"hover"==t.cfg.tooltip.trigger&&(t.$layer.on("mousemove",_.proxy(this._onLayerMouseMoveTooltip,this,t)),t.$tooltip.addClass("vision-noevents-hard")),t.$tooltipPos.css({top:t.cfg.y+"%",left:t.cfg.x+"%","margin-top":s,"margin-left":a}),t.tooltipVisible||(t.tooltipVisible=!0,t.$tooltip.addClass("vision-show").removeClass("vision-hide"),a=0<this.elementZindex.length?Math.max.apply(null,this.elementZindex)+1:1,this.elementZindex.push(a),t.$tooltipPos.css("z-index",a),o&&t.cfg.tooltip.showAnimation&&(t.$tooltipForm.removeClass(t.cfg.tooltip.showAnimation).removeClass(t.cfg.tooltip.hideAnimation),t.$tooltipForm.addClass(t.cfg.tooltip.showAnimation),t.$tooltipForm.one(d(),_.proxy(function(t,o){_(o.target).removeClass(t.cfg.tooltip.showAnimation)},this,t)))),!e&&t.cfg.tooltip.smart){var n=this._getViewportOffset(t.$layerOffset),h=this._getViewportOffset(t.$tooltipOffset),p=t.$layerOffset.get(0).getBoundingClientRect(),c=t.$tooltipOffset.get(0).getBoundingClientRect();switch(i){case"top-left":h.right<0&&(i=0<n.left+p.width-c.width?i.replace("-left","-right"):i.replace("-left","")),h.top<0&&(i=i.replace("top","bottom"));break;case"top":h.right<0&&0<n.left+p.width-c.width&&(i+="-right"),h.left<0&&0<n.right+p.width-c.width&&(i+="-left"),h.top<0&&(i=i.replace("top","bottom"));break;case"top-right":h.left<0&&(i=0<n.right+p.width-c.width?i.replace("-right","-left"):i.replace("-right","")),h.top<0&&(i=i.replace("top","bottom"));break;case"right-top":h.top<0&&p.height>c.height&&(i=i.replace("-top","-bottom")),h.right<0&&(i=i.replace("right","left"));break;case"right":h.top<0&&(p.height>c.height?i+="-bottom":i+="-top"),h.bottom<0&&(p.height>c.height?i+="-top":i+="-bottom"),h.right<0&&(i=i.replace("right","left"));break;case"right-bottom":h.bottom<0&&p.height>c.height&&(i=i.replace("-bottom","-top")),h.right<0&&(i=i.replace("right","left"));break;case"bottom-right":h.left<0&&(i=0<n.right+p.width-c.width?i.replace("-right","-left"):i.replace("-right","")),h.bottom<0&&(i=i.replace("bottom","top"));break;case"bottom":h.right<0&&0<n.left+p.width-c.width&&(i+="-right"),h.left<0&&0<n.right+p.width-c.width&&(i+="-left"),h.top<0&&(i=i.replace("bottom","top"));break;case"bottom-left":h.right<0&&(i=0<n.left+p.width-c.width?i.replace("-left","-right"):i.replace("-left","")),h.bottom<0&&(i=i.replace("bottom","top"));break;case"left-bottom":h.bottom<0&&p.height>c.height&&(i=i.replace("-bottom","-top")),h.left<0&&(i=i.replace("left","right"));break;case"left":h.top<0&&(p.height>c.height?i+="-bottom":i+="-top"),h.bottom<0&&(p.height>c.height?i+="-top":i+="-bottom"),h.left<0&&(i=i.replace("left","right"));break;case"left-top":h.top<0&&p.height>c.height&&(i=i.replace("-top","-bottom")),h.left<0&&(i=i.replace("left","right"))}this._showTooltip(t,!1,i,!0)}}},_hideTooltip:function(t){t.$layer.off("mousemove",_.proxy(this._onLayerMouseMoveTooltip,t,this)),t.$tooltip.removeClass("vision-noevents-hard"),t.tooltipVisible&&(t.tooltipVisible=!1,t.cfg.tooltip.hideAnimation?(t.$tooltipForm.removeClass(t.cfg.tooltip.showAnimation).removeClass(t.cfg.tooltip.hideAnimation),t.$tooltipForm.addClass(t.cfg.tooltip.hideAnimation),t.$tooltipForm.one(d(),_.proxy(function(t,o){_(o.target).removeClass(t.cfg.tooltip.hideAnimation),t.tooltipVisible||this.__hideTooltip(t)},this,t))):this.__hideTooltip(t))},__hideTooltip:function(t){t.$tooltip.addClass("vision-hide").removeClass("vision-show"),t.$tooltip.removeClass(t.$tooltip.data("placement"));var o=this.elementZindex.indexOf(parseInt(t.$tooltipPos.css("z-index"),10));-1<o&&this.elementZindex.splice(o,1),t.$tooltipPos.css("z-index",""),t.$tooltipData.detach(),t.$tooltipData.get(0).offsetHeight,t.$tooltipData.appendTo(t.$tooltipBody)},_onLayerClickLink:function(t,o){t.cfg.url&&s.open(t.cfg.url,t.cfg.urlNewWindow?"_blank":"_self")},_onLayerEnterTooltip:function(t,o){this._showTooltip(t,!0)},_onLayerLeaveTooltip:function(t,o){o=o.relatedTarget||o.toElement;t.cfg.tooltip.interactive&&(0!==t.$tooltip.has(o).length||t.$tooltip.is(o))||t.$layer.is(o)?t.$tooltip.one("mouseleave",_.proxy(this._onLayerLeaveTooltip,this,t)):this._hideTooltip(t)},_onLayerMouseMoveTooltip:function(t,o){var i=this.controls.$stage.get(0).getBoundingClientRect(),e=(o.clientY-i.y)/i.height*100,i=(o.clientX-i.x)/i.width*100;t.$tooltipPos.css({top:e+"%",left:i+"%"})},_onLayerFocusTooltip:function(t,o){this._showTooltip(t,!0)},_onLayerBlurTooltip:function(t,o){this._hideTooltip(t)},_onLayerClickTooltip:function(t,o){t.tooltipVisible?this._hideTooltip(t):this._showTooltip(t,!0)},_onBodyClickTooltip:function(t){if(this.bodyClick)for(var o=t.target||t.relatedTarget||t.toElement,i=0;i<this.layers.length;i++){var e=this.layers[i];0<e.$layer.has(o).length||e.$layer.is(o)||e.tooltipVisible&&("clickbody"==e.cfg.tooltip.trigger||"focus"==e.cfg.tooltip.trigger&&!e.$layer.is(":focus"))&&(!e.tooltipVisible||e.cfg.tooltip.interactive&&(0!==e.$tooltip.has(o).length||e.$tooltip.is(o))||this._hideTooltip(e))}},_onLastLayerFocus:function(t){this.layers.length&&this.layers[0].$layer.focus()},_showPopover:function(t,o,i,e){if(t&&t.cfg.popover.active){var s=L()?t.cfg.popover.mobileType:t.cfg.popover.type;if("tooltip"==s){var a=this.imageHeight/this.imageWidth,l=this.$container.width(),a=null==this.config.height?a*l:this.$container.height(),l=l/this.imageWidth,a=a/this.imageHeight,r=t.cfg.height*(t.cfg.scaling&&!t.cfg.popover.scaling?a:1)/2,n=t.cfg.width*(t.cfg.scaling&&!t.cfg.popover.scaling?l:1)/2,a=t.cfg.popover.offset.top,l=t.cfg.popover.offset.left;switch(i=i||t.cfg.popover.placement,e=e||!1,t.$popover.removeClass(t.$popover.data("placement")),i&&t.$popover.addClass("vision-"+i).data("placement","vision-"+i),i){case"top-left":r=-r,n=-n;break;case"top":r=-r,n=0;break;case"top-right":case"right-top":r=-r;break;case"right":r=0;break;case"right-bottom":case"bottom-right":break;case"bottom":n=0;break;case"bottom-left":case"left-bottom":n=-n;break;case"left":r=0,n=-n;break;case"left-top":r=-r,n=-n;break;default:r=n=0}if(t.$popoverOffset.css({"margin-top":r,"margin-left":n}),t.$popoverPos.css({top:t.cfg.y+"%",left:t.cfg.x+"%","margin-top":a,"margin-left":l}),t.popoverVisible||(t.popoverVisible=!0,t.$popover.addClass("vision-show").removeClass("vision-hide"),l=0<this.elementZindex.length?Math.max.apply(null,this.elementZindex)+1:1,this.elementZindex.push(l),t.$popoverPos.css("z-index",l)),!e&&t.cfg.popover.smart){var h=this._getViewportOffset(t.$layerOffset),p=this._getViewportOffset(t.$popoverOffset),c=t.$layerOffset.get(0).getBoundingClientRect(),d=t.$popoverOffset.get(0).getBoundingClientRect();switch(i){case"top-left":p.right<0&&(i=0<h.left+c.width-d.width?i.replace("-left","-right"):i.replace("-left","")),p.top<0&&(i=i.replace("top","bottom"));break;case"top":p.right<0&&0<h.left+c.width-d.width&&(i+="-right"),p.left<0&&0<h.right+c.width-d.width&&(i+="-left"),p.top<0&&(i=i.replace("top","bottom"));break;case"top-right":p.left<0&&(i=0<h.right+c.width-d.width?i.replace("-right","-left"):i.replace("-right","")),p.top<0&&(i=i.replace("top","bottom"));break;case"right-top":p.top<0&&c.height>d.height&&(i=i.replace("-top","-bottom")),p.right<0&&(i=i.replace("right","left"));break;case"right":p.top<0&&(c.height>d.height?i+="-bottom":i+="-top"),p.bottom<0&&(c.height>d.height?i+="-top":i+="-bottom"),p.right<0&&(i=i.replace("right","left"));break;case"right-bottom":p.bottom<0&&c.height>d.height&&(i=i.replace("-bottom","-top")),p.right<0&&(i=i.replace("right","left"));break;case"bottom-right":p.left<0&&(i=0<h.right+c.width-d.width?i.replace("-right","-left"):i.replace("-right","")),p.bottom<0&&(i=i.replace("bottom","top"));break;case"bottom":p.right<0&&0<h.left+c.width-d.width&&(i+="-right"),p.left<0&&0<h.right+c.width-d.width&&(i+="-left"),p.top<0&&(i=i.replace("bottom","top"));break;case"bottom-left":p.right<0&&(i=0<h.left+c.width-d.width?i.replace("-left","-right"):i.replace("-left","")),p.bottom<0&&(i=i.replace("bottom","top"));break;case"left-bottom":p.bottom<0&&c.height>d.height&&(i=i.replace("-bottom","-top")),p.left<0&&(i=i.replace("left","right"));break;case"left":p.top<0&&(c.height>d.height?i+="-bottom":i+="-top"),p.bottom<0&&(c.height>d.height?i+="-top":i+="-bottom"),p.left<0&&(i=i.replace("left","right"));break;case"left-top":p.top<0&&c.height>d.height&&(i=i.replace("-top","-bottom")),p.left<0&&(i=i.replace("left","right"))}this._showPopover(t,!1,i,!0)}}else"inbox"==s?this._showPopoverInbox(t):"lightbox"==s&&this._showPopoverLightbox(t)}},_hidePopover:function(t){if(t)switch(L()?t.cfg.popover.mobileType:t.cfg.popover.type){case"tooltip":this.__hidePopover(t);break;case"inbox":this._hidePopoverInbox();break;case"lightbox":this._hidePopoverLightbox()}},__hidePopover:function(t){var o;t.popoverVisible&&(t.popoverVisible=!1,t.$popover.addClass("vision-hide").removeClass("vision-show"),t.$popover.removeClass(t.$popover.data("placement")),-1<(o=this.elementZindex.indexOf(parseInt(t.$popoverPos.css("z-index"),10)))&&this.elementZindex.splice(o,1),t.$popoverPos.css("z-index",""),t.$popoverData.detach(),t.$popoverData.get(0).offsetHeight,t.$popoverData.appendTo(t.$popoverBody))},_onLayerEnterPopover:function(t,o){this._showPopover(t,!0)},_onLayerLeavePopover:function(t,o){o=o.relatedTarget||o.toElement;t.cfg.popover.interactive&&(0!==t.$popover.has(o).length||t.$popover.is(o))||t.$layer.is(o)?t.$popover.one("mouseleave",_.proxy(this._onLayerLeavePopover,this,t)):this._hidePopover(t)},_onLayerFocusPopover:function(t,o){this._showPopover(t,!0)},_onLayerBlurPopover:function(t,o){this._hidePopover(t)},_onLayerClickPopover:function(t,o){t.popoverVisible?this._hidePopover(t):this._showPopover(t,!0)},_onInboxCloseClick:function(t){this._hidePopoverInbox()},_onInboxKeyboard:function(t){27===t.keyCode&&this._hidePopoverInbox()},_onLightboxCloseClick:function(t){this._hidePopoverLightbox()},_onLightboxKeyboard:function(t){27===t.keyCode&&this._hidePopoverLightbox()},_showPopoverInbox:function(t){this.inboxLayer&&this._hidePopover(this.inboxLayer),this.inboxLayer=t,this.inboxLayer.$popoverData.detach();var o=this.inboxLayer.$popoverData.attr("style");this.inboxLayer.$popoverData.data("style",o),this.inboxLayer.$popoverData.attr("style",""),this.controls.$inbox.addClass(this.inboxLayer.cfg.popover.className),this.controls.$inboxFrame.append(t.$popoverData),this.controls.$inboxFrame.get(0).offsetHeight,this.controls.$inboxFrame.height()>this.controls.$inboxForm.height()&&this.controls.$inboxForm.addClass("vision-inbox-form-overflow"),this.controls.$inbox.addClass("vision-show").removeClass("vision-hide").focus()},_hidePopoverInbox:function(){var t;this.inboxLayer&&(this.inboxLayer.$popoverData.detach(),t=this.inboxLayer.$popoverData.data("style"),this.inboxLayer.$popoverData.attr("style",t),this.inboxLayer.$popoverData.data("style",""),this.controls.$inbox.removeClass(this.inboxLayer.cfg.popover.className),this.inboxLayer.$popoverBody.append(this.inboxLayer.$popoverData),this.inboxLayer=null),this.controls.$inbox.addClass("vision-hide").removeClass("vision-show"),this.controls.$inboxForm.removeClass("vision-inbox-form-overflow")},_showPopoverLightbox:function(t){this._hidePopoverLightbox(),this.lightbox.layer=t,this.lightbox.theme=this.lightboxThemeClass,this.lightbox.layer.$popoverData.detach();t=this.lightbox.layer.$popoverData.attr("style");this.lightbox.layer.$popoverData.data("style",t),this.lightbox.layer.$popoverData.attr("style",""),this.lightbox.controls.$lightbox.addClass(this.lightbox.layer.cfg.popover.className).addClass(this.lightbox.theme),this.lightbox.controls.$lightboxFrame.append(this.lightbox.layer.$popoverData),this.lightbox.controls.$lightboxFrame.get(0).offsetHeight,this.lightbox.controls.$lightboxFrame.height()>this.lightbox.controls.$lightboxForm.height()&&this.lightbox.controls.$lightboxForm.addClass("vision-lightbox-form-overflow"),this.lightbox.controls.$lightbox.addClass("vision-show").removeClass("vision-hide").focus(),_("body").addClass("vision-lightbox-active")},_hidePopoverLightbox:function(){var t;_("body").removeClass("vision-lightbox-active"),this.lightbox.controls.$lightbox.removeClass(this.lightbox.theme).addClass("vision-hide").removeClass("vision-show"),this.lightbox.controls.$lightboxForm.removeClass("vision-lightbox-form-overflow"),this.lightbox.theme=null,this.lightbox.layer&&(this.lightbox.layer.$popoverData.detach(),t=this.lightbox.layer.$popoverData.data("style"),this.lightbox.layer.$popoverData.attr("style",t),this.lightbox.layer.$popoverData.data("style",""),this.lightbox.controls.$lightbox.removeClass(this.lightbox.layer.cfg.popover.className),this.lightbox.layer.$popoverBody.append(this.lightbox.layer.$popoverData),this.lightbox.layer=null)},_onResize:function(){var t;this.ready&&(t=this,clearTimeout(this.timerIdResize),this.timerIdResize=setTimeout(function(){t._updateSize()},this.config.delayResize))},_onScroll:function(){var t;this.ready&&(t=this,clearTimeout(this.timerIdScroll),this.timerIdScroll=setTimeout(function(){t._updatePlacement()},100))},uuid:function(t){var o="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(t){var o=16*Math.random()|0;return("x"==t?o:3&o|8).toString(16)});return 0<t?o.substring(0,t):o},setTheme:function(t){this._setTheme(t)},addLayer:function(t){return this._addLayer(t)},getLayer:function(t){for(var o=0;o<this.layers.length;o++){var i=this.layers[o];if(i.cfg.id==t)return i}return null},deleteLayer:function(t){for(var o=0;o<this.layers.length;o++)if(this.layers[o].cfg.id==t)return this._deleteLayer(o);return!1},showPopover:function(t){t=this.getLayer(t);t&&this._showPopover(t)},hidePopover:function(t){t=this.getLayer(t);t&&this._hidePopover(t)},showTooltip:function(t,o,i,e){t=this.getLayer(t);t&&this._showTooltip(t,o,i,e)},hideTooltip:function(t){t=this.getLayer(t);t&&this._hideTooltip(t)},resize:function(){this._updateSize()}},_.fn.vision=function(l,t){if("instance"!=l)return this.each(function(){var i=_(this),e=i.data(n),t=i.data("json-src"),s=i.data("img-src"),a=_.isPlainObject(l)?l:t?null:{};if("destroy"==l)return e?(i.removeData(n),void e._destroy()):void console.error('Calling "destroy" method on not initialized instance is forbidden');function o(){console.log("VISION "+h.prototype.VERSION);var t=_.extend(!0,{},h.prototype.defaults,a);if(t.baseUrl&&t.baseUrl,null==t.imgSrc&&s&&(t.imgSrc=s),t.onPreInit){var o=null;if("string"==typeof t.onPreInit)try{o=new Function("config",t.onPreInit)}catch(t){console.error('Can not compile "onPreInit" function: '+t.message)}else"function"==typeof t.onPreInit&&(o=t.onPreInit);o&&o.call(this,t)}e=new h(i,t),i.data(n,e)}e&&(i.removeData(n),e._destroy(),e=null),null==a?(t=r(t),_.ajax({url:t,type:"GET",dataType:"json",headers:{"X-WP-Nonce":vision_globals.api.nonce}}).done(function(t){a=_.isPlainObject(t)?t:{}}).fail(function(t){a={}}).always(function(){o()})):o()});var o=_(this).data(n);return o||void console.error('Calling "instance" method on not initialized instance is forbidden')},_(".vision-map").vision()}(jQuery,window,document);