<?php
/**
 * TmsTokenFormats
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * TmsTokenFormats Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TmsTokenFormats implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'tmsTokenFormats';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'customer' => 'string',
        'paymentInstrument' => 'string',
        'instrumentIdentifierCard' => 'string',
        'instrumentIdentifierBankAccount' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'customer' => null,
        'paymentInstrument' => null,
        'instrumentIdentifierCard' => null,
        'instrumentIdentifierBankAccount' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'customer' => 'customer',
        'paymentInstrument' => 'paymentInstrument',
        'instrumentIdentifierCard' => 'instrumentIdentifierCard',
        'instrumentIdentifierBankAccount' => 'instrumentIdentifierBankAccount'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'customer' => 'setCustomer',
        'paymentInstrument' => 'setPaymentInstrument',
        'instrumentIdentifierCard' => 'setInstrumentIdentifierCard',
        'instrumentIdentifierBankAccount' => 'setInstrumentIdentifierBankAccount'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'customer' => 'getCustomer',
        'paymentInstrument' => 'getPaymentInstrument',
        'instrumentIdentifierCard' => 'getInstrumentIdentifierCard',
        'instrumentIdentifierBankAccount' => 'getInstrumentIdentifierBankAccount'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['customer'] = isset($data['customer']) ? $data['customer'] : null;
        $this->container['paymentInstrument'] = isset($data['paymentInstrument']) ? $data['paymentInstrument'] : null;
        $this->container['instrumentIdentifierCard'] = isset($data['instrumentIdentifierCard']) ? $data['instrumentIdentifierCard'] : null;
        $this->container['instrumentIdentifierBankAccount'] = isset($data['instrumentIdentifierBankAccount']) ? $data['instrumentIdentifierBankAccount'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets customer
     * @return string
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     * @param string $customer Format for customer tokens.  Possible Values:   - '16_DIGIT'   - '19_DIGIT'   - '22_DIGIT'   - '32_HEX'
     * @return $this
     */
    public function setCustomer($customer)
    {
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets paymentInstrument
     * @return string
     */
    public function getPaymentInstrument()
    {
        return $this->container['paymentInstrument'];
    }

    /**
     * Sets paymentInstrument
     * @param string $paymentInstrument Format for payment instrument tokens.  Possible Values:   - '16_DIGIT'   - '19_DIGIT'   - '22_DIGIT'   - '32_HEX'
     * @return $this
     */
    public function setPaymentInstrument($paymentInstrument)
    {
        $this->container['paymentInstrument'] = $paymentInstrument;

        return $this;
    }

    /**
     * Gets instrumentIdentifierCard
     * @return string
     */
    public function getInstrumentIdentifierCard()
    {
        return $this->container['instrumentIdentifierCard'];
    }

    /**
     * Sets instrumentIdentifierCard
     * @param string $instrumentIdentifierCard Format for card based instrument identifier tokens.  Possible Values:   - '16_DIGIT'   - '16_DIGIT_LAST_4'   - '19_DIGIT'   - '19_DIGIT_LAST_4'   - '22_DIGIT'   - '32_HEX'
     * @return $this
     */
    public function setInstrumentIdentifierCard($instrumentIdentifierCard)
    {
        $this->container['instrumentIdentifierCard'] = $instrumentIdentifierCard;

        return $this;
    }

    /**
     * Gets instrumentIdentifierBankAccount
     * @return string
     */
    public function getInstrumentIdentifierBankAccount()
    {
        return $this->container['instrumentIdentifierBankAccount'];
    }

    /**
     * Sets instrumentIdentifierBankAccount
     * @param string $instrumentIdentifierBankAccount Format for bank account based instrument identifier tokens.  Possible Values:    - '16_DIGIT'   - '19_DIGIT'   - '22_DIGIT'   - '32_HEX'
     * @return $this
     */
    public function setInstrumentIdentifierBankAccount($instrumentIdentifierBankAccount)
    {
        $this->container['instrumentIdentifierBankAccount'] = $instrumentIdentifierBankAccount;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


