<?php
/**
 * TmsBusinessInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * TmsBusinessInformation Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TmsBusinessInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'tmsBusinessInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'name' => 'string',
        'doingBusinessAs' => 'string',
        'address' => '\CyberSource\Model\TmsBusinessInformationAddress',
        'websiteUrl' => 'string',
        'businessIdentificationType' => 'string',
        'businessIdentificationValue' => 'string',
        'acquirer' => '\CyberSource\Model\TmsBusinessInformationAcquirer'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'name' => null,
        'doingBusinessAs' => null,
        'address' => null,
        'websiteUrl' => null,
        'businessIdentificationType' => null,
        'businessIdentificationValue' => null,
        'acquirer' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'doingBusinessAs' => 'doingBusinessAs',
        'address' => 'address',
        'websiteUrl' => 'websiteUrl',
        'businessIdentificationType' => 'businessIdentificationType',
        'businessIdentificationValue' => 'businessIdentificationValue',
        'acquirer' => 'acquirer'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'doingBusinessAs' => 'setDoingBusinessAs',
        'address' => 'setAddress',
        'websiteUrl' => 'setWebsiteUrl',
        'businessIdentificationType' => 'setBusinessIdentificationType',
        'businessIdentificationValue' => 'setBusinessIdentificationValue',
        'acquirer' => 'setAcquirer'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'doingBusinessAs' => 'getDoingBusinessAs',
        'address' => 'getAddress',
        'websiteUrl' => 'getWebsiteUrl',
        'businessIdentificationType' => 'getBusinessIdentificationType',
        'businessIdentificationValue' => 'getBusinessIdentificationValue',
        'acquirer' => 'getAcquirer'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['doingBusinessAs'] = isset($data['doingBusinessAs']) ? $data['doingBusinessAs'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['websiteUrl'] = isset($data['websiteUrl']) ? $data['websiteUrl'] : null;
        $this->container['businessIdentificationType'] = isset($data['businessIdentificationType']) ? $data['businessIdentificationType'] : null;
        $this->container['businessIdentificationValue'] = isset($data['businessIdentificationValue']) ? $data['businessIdentificationValue'] : null;
        $this->container['acquirer'] = isset($data['acquirer']) ? $data['acquirer'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name Name of the network token merchant.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets doingBusinessAs
     * @return string
     */
    public function getDoingBusinessAs()
    {
        return $this->container['doingBusinessAs'];
    }

    /**
     * Sets doingBusinessAs
     * @param string $doingBusinessAs Name the network token merchant does business as
     * @return $this
     */
    public function setDoingBusinessAs($doingBusinessAs)
    {
        $this->container['doingBusinessAs'] = $doingBusinessAs;

        return $this;
    }

    /**
     * Gets address
     * @return \CyberSource\Model\TmsBusinessInformationAddress
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param \CyberSource\Model\TmsBusinessInformationAddress $address
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets websiteUrl
     * @return string
     */
    public function getWebsiteUrl()
    {
        return $this->container['websiteUrl'];
    }

    /**
     * Sets websiteUrl
     * @param string $websiteUrl Website of network token merchant.
     * @return $this
     */
    public function setWebsiteUrl($websiteUrl)
    {
        $this->container['websiteUrl'] = $websiteUrl;

        return $this;
    }

    /**
     * Gets businessIdentificationType
     * @return string
     */
    public function getBusinessIdentificationType()
    {
        return $this->container['businessIdentificationType'];
    }

    /**
     * Sets businessIdentificationType
     * @param string $businessIdentificationType The Identifier associated with the business type; required unless both acquirerId and acquirerMerchantId are provided.
     * @return $this
     */
    public function setBusinessIdentificationType($businessIdentificationType)
    {
        $this->container['businessIdentificationType'] = $businessIdentificationType;

        return $this;
    }

    /**
     * Gets businessIdentificationValue
     * @return string
     */
    public function getBusinessIdentificationValue()
    {
        return $this->container['businessIdentificationValue'];
    }

    /**
     * Sets businessIdentificationValue
     * @param string $businessIdentificationValue The value associated with the business identifier type; required unless both acquirerId and acquirerMerchantId are provided.
     * @return $this
     */
    public function setBusinessIdentificationValue($businessIdentificationValue)
    {
        $this->container['businessIdentificationValue'] = $businessIdentificationValue;

        return $this;
    }

    /**
     * Gets acquirer
     * @return \CyberSource\Model\TmsBusinessInformationAcquirer
     */
    public function getAcquirer()
    {
        return $this->container['acquirer'];
    }

    /**
     * Sets acquirer
     * @param \CyberSource\Model\TmsBusinessInformationAcquirer $acquirer
     * @return $this
     */
    public function setAcquirer($acquirer)
    {
        $this->container['acquirer'] = $acquirer;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


