<?php
/**
 * Riskv1decisionsConsumerAuthenticationInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Riskv1decisionsConsumerAuthenticationInformation Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Riskv1decisionsConsumerAuthenticationInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'riskv1decisions_consumerAuthenticationInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'strongAuthentication' => '\CyberSource\Model\Riskv1decisionsConsumerAuthenticationInformationStrongAuthentication',
        'acsWindowSize' => 'string',
        'alternateAuthenticationData' => 'string',
        'alternateAuthenticationDate' => 'string',
        'alternateAuthenticationMethod' => 'string',
        'authenticationDate' => 'string',
        'authenticationTransactionId' => 'string',
        'transactionFlowIndicator' => 'int',
        'challengeCode' => 'string',
        'challengeStatus' => 'string',
        'customerCardAlias' => 'string',
        'decoupledAuthenticationIndicator' => 'string',
        'decoupledAuthenticationMaxTime' => 'string',
        'defaultCard' => 'bool',
        'deviceChannel' => 'string',
        'installmentTotalCount' => 'int',
        'merchantFraudRate' => 'string',
        'marketingOptIn' => 'bool',
        'marketingSource' => 'string',
        'mcc' => 'string',
        'merchantScore' => 'int',
        'messageCategory' => 'string',
        'npaCode' => 'string',
        'overridePaymentMethod' => 'string',
        'overrideCountryCode' => 'string',
        'priorAuthenticationData' => 'string',
        'priorAuthenticationMethod' => 'string',
        'priorAuthenticationReferenceId' => 'string',
        'priorAuthenticationTime' => 'string',
        'productCode' => 'string',
        'returnUrl' => 'string',
        'requestorId' => 'string',
        'requestorInitiatedAuthenticationIndicator' => 'string',
        'requestorName' => 'string',
        'referenceId' => 'string',
        'sdkMaxTimeout' => 'string',
        'secureCorporatePaymentIndicator' => 'string',
        'transactionMode' => 'string',
        'whiteListStatus' => 'string',
        'scoreRequest' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'strongAuthentication' => null,
        'acsWindowSize' => null,
        'alternateAuthenticationData' => null,
        'alternateAuthenticationDate' => null,
        'alternateAuthenticationMethod' => null,
        'authenticationDate' => null,
        'authenticationTransactionId' => null,
        'transactionFlowIndicator' => null,
        'challengeCode' => null,
        'challengeStatus' => null,
        'customerCardAlias' => null,
        'decoupledAuthenticationIndicator' => null,
        'decoupledAuthenticationMaxTime' => null,
        'defaultCard' => null,
        'deviceChannel' => null,
        'installmentTotalCount' => null,
        'merchantFraudRate' => null,
        'marketingOptIn' => null,
        'marketingSource' => null,
        'mcc' => null,
        'merchantScore' => null,
        'messageCategory' => null,
        'npaCode' => null,
        'overridePaymentMethod' => null,
        'overrideCountryCode' => null,
        'priorAuthenticationData' => null,
        'priorAuthenticationMethod' => null,
        'priorAuthenticationReferenceId' => null,
        'priorAuthenticationTime' => null,
        'productCode' => null,
        'returnUrl' => null,
        'requestorId' => null,
        'requestorInitiatedAuthenticationIndicator' => null,
        'requestorName' => null,
        'referenceId' => null,
        'sdkMaxTimeout' => null,
        'secureCorporatePaymentIndicator' => null,
        'transactionMode' => null,
        'whiteListStatus' => null,
        'scoreRequest' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'strongAuthentication' => 'strongAuthentication',
        'acsWindowSize' => 'acsWindowSize',
        'alternateAuthenticationData' => 'alternateAuthenticationData',
        'alternateAuthenticationDate' => 'alternateAuthenticationDate',
        'alternateAuthenticationMethod' => 'alternateAuthenticationMethod',
        'authenticationDate' => 'authenticationDate',
        'authenticationTransactionId' => 'authenticationTransactionId',
        'transactionFlowIndicator' => 'transactionFlowIndicator',
        'challengeCode' => 'challengeCode',
        'challengeStatus' => 'challengeStatus',
        'customerCardAlias' => 'customerCardAlias',
        'decoupledAuthenticationIndicator' => 'decoupledAuthenticationIndicator',
        'decoupledAuthenticationMaxTime' => 'decoupledAuthenticationMaxTime',
        'defaultCard' => 'defaultCard',
        'deviceChannel' => 'deviceChannel',
        'installmentTotalCount' => 'installmentTotalCount',
        'merchantFraudRate' => 'merchantFraudRate',
        'marketingOptIn' => 'marketingOptIn',
        'marketingSource' => 'marketingSource',
        'mcc' => 'mcc',
        'merchantScore' => 'merchantScore',
        'messageCategory' => 'messageCategory',
        'npaCode' => 'npaCode',
        'overridePaymentMethod' => 'overridePaymentMethod',
        'overrideCountryCode' => 'overrideCountryCode',
        'priorAuthenticationData' => 'priorAuthenticationData',
        'priorAuthenticationMethod' => 'priorAuthenticationMethod',
        'priorAuthenticationReferenceId' => 'priorAuthenticationReferenceId',
        'priorAuthenticationTime' => 'priorAuthenticationTime',
        'productCode' => 'productCode',
        'returnUrl' => 'returnUrl',
        'requestorId' => 'requestorId',
        'requestorInitiatedAuthenticationIndicator' => 'requestorInitiatedAuthenticationIndicator',
        'requestorName' => 'requestorName',
        'referenceId' => 'referenceId',
        'sdkMaxTimeout' => 'sdkMaxTimeout',
        'secureCorporatePaymentIndicator' => 'secureCorporatePaymentIndicator',
        'transactionMode' => 'transactionMode',
        'whiteListStatus' => 'whiteListStatus',
        'scoreRequest' => 'scoreRequest'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'strongAuthentication' => 'setStrongAuthentication',
        'acsWindowSize' => 'setAcsWindowSize',
        'alternateAuthenticationData' => 'setAlternateAuthenticationData',
        'alternateAuthenticationDate' => 'setAlternateAuthenticationDate',
        'alternateAuthenticationMethod' => 'setAlternateAuthenticationMethod',
        'authenticationDate' => 'setAuthenticationDate',
        'authenticationTransactionId' => 'setAuthenticationTransactionId',
        'transactionFlowIndicator' => 'setTransactionFlowIndicator',
        'challengeCode' => 'setChallengeCode',
        'challengeStatus' => 'setChallengeStatus',
        'customerCardAlias' => 'setCustomerCardAlias',
        'decoupledAuthenticationIndicator' => 'setDecoupledAuthenticationIndicator',
        'decoupledAuthenticationMaxTime' => 'setDecoupledAuthenticationMaxTime',
        'defaultCard' => 'setDefaultCard',
        'deviceChannel' => 'setDeviceChannel',
        'installmentTotalCount' => 'setInstallmentTotalCount',
        'merchantFraudRate' => 'setMerchantFraudRate',
        'marketingOptIn' => 'setMarketingOptIn',
        'marketingSource' => 'setMarketingSource',
        'mcc' => 'setMcc',
        'merchantScore' => 'setMerchantScore',
        'messageCategory' => 'setMessageCategory',
        'npaCode' => 'setNpaCode',
        'overridePaymentMethod' => 'setOverridePaymentMethod',
        'overrideCountryCode' => 'setOverrideCountryCode',
        'priorAuthenticationData' => 'setPriorAuthenticationData',
        'priorAuthenticationMethod' => 'setPriorAuthenticationMethod',
        'priorAuthenticationReferenceId' => 'setPriorAuthenticationReferenceId',
        'priorAuthenticationTime' => 'setPriorAuthenticationTime',
        'productCode' => 'setProductCode',
        'returnUrl' => 'setReturnUrl',
        'requestorId' => 'setRequestorId',
        'requestorInitiatedAuthenticationIndicator' => 'setRequestorInitiatedAuthenticationIndicator',
        'requestorName' => 'setRequestorName',
        'referenceId' => 'setReferenceId',
        'sdkMaxTimeout' => 'setSdkMaxTimeout',
        'secureCorporatePaymentIndicator' => 'setSecureCorporatePaymentIndicator',
        'transactionMode' => 'setTransactionMode',
        'whiteListStatus' => 'setWhiteListStatus',
        'scoreRequest' => 'setScoreRequest'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'strongAuthentication' => 'getStrongAuthentication',
        'acsWindowSize' => 'getAcsWindowSize',
        'alternateAuthenticationData' => 'getAlternateAuthenticationData',
        'alternateAuthenticationDate' => 'getAlternateAuthenticationDate',
        'alternateAuthenticationMethod' => 'getAlternateAuthenticationMethod',
        'authenticationDate' => 'getAuthenticationDate',
        'authenticationTransactionId' => 'getAuthenticationTransactionId',
        'transactionFlowIndicator' => 'getTransactionFlowIndicator',
        'challengeCode' => 'getChallengeCode',
        'challengeStatus' => 'getChallengeStatus',
        'customerCardAlias' => 'getCustomerCardAlias',
        'decoupledAuthenticationIndicator' => 'getDecoupledAuthenticationIndicator',
        'decoupledAuthenticationMaxTime' => 'getDecoupledAuthenticationMaxTime',
        'defaultCard' => 'getDefaultCard',
        'deviceChannel' => 'getDeviceChannel',
        'installmentTotalCount' => 'getInstallmentTotalCount',
        'merchantFraudRate' => 'getMerchantFraudRate',
        'marketingOptIn' => 'getMarketingOptIn',
        'marketingSource' => 'getMarketingSource',
        'mcc' => 'getMcc',
        'merchantScore' => 'getMerchantScore',
        'messageCategory' => 'getMessageCategory',
        'npaCode' => 'getNpaCode',
        'overridePaymentMethod' => 'getOverridePaymentMethod',
        'overrideCountryCode' => 'getOverrideCountryCode',
        'priorAuthenticationData' => 'getPriorAuthenticationData',
        'priorAuthenticationMethod' => 'getPriorAuthenticationMethod',
        'priorAuthenticationReferenceId' => 'getPriorAuthenticationReferenceId',
        'priorAuthenticationTime' => 'getPriorAuthenticationTime',
        'productCode' => 'getProductCode',
        'returnUrl' => 'getReturnUrl',
        'requestorId' => 'getRequestorId',
        'requestorInitiatedAuthenticationIndicator' => 'getRequestorInitiatedAuthenticationIndicator',
        'requestorName' => 'getRequestorName',
        'referenceId' => 'getReferenceId',
        'sdkMaxTimeout' => 'getSdkMaxTimeout',
        'secureCorporatePaymentIndicator' => 'getSecureCorporatePaymentIndicator',
        'transactionMode' => 'getTransactionMode',
        'whiteListStatus' => 'getWhiteListStatus',
        'scoreRequest' => 'getScoreRequest'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['strongAuthentication'] = isset($data['strongAuthentication']) ? $data['strongAuthentication'] : null;
        $this->container['acsWindowSize'] = isset($data['acsWindowSize']) ? $data['acsWindowSize'] : null;
        $this->container['alternateAuthenticationData'] = isset($data['alternateAuthenticationData']) ? $data['alternateAuthenticationData'] : null;
        $this->container['alternateAuthenticationDate'] = isset($data['alternateAuthenticationDate']) ? $data['alternateAuthenticationDate'] : null;
        $this->container['alternateAuthenticationMethod'] = isset($data['alternateAuthenticationMethod']) ? $data['alternateAuthenticationMethod'] : null;
        $this->container['authenticationDate'] = isset($data['authenticationDate']) ? $data['authenticationDate'] : null;
        $this->container['authenticationTransactionId'] = isset($data['authenticationTransactionId']) ? $data['authenticationTransactionId'] : null;
        $this->container['transactionFlowIndicator'] = isset($data['transactionFlowIndicator']) ? $data['transactionFlowIndicator'] : null;
        $this->container['challengeCode'] = isset($data['challengeCode']) ? $data['challengeCode'] : null;
        $this->container['challengeStatus'] = isset($data['challengeStatus']) ? $data['challengeStatus'] : null;
        $this->container['customerCardAlias'] = isset($data['customerCardAlias']) ? $data['customerCardAlias'] : null;
        $this->container['decoupledAuthenticationIndicator'] = isset($data['decoupledAuthenticationIndicator']) ? $data['decoupledAuthenticationIndicator'] : null;
        $this->container['decoupledAuthenticationMaxTime'] = isset($data['decoupledAuthenticationMaxTime']) ? $data['decoupledAuthenticationMaxTime'] : null;
        $this->container['defaultCard'] = isset($data['defaultCard']) ? $data['defaultCard'] : null;
        $this->container['deviceChannel'] = isset($data['deviceChannel']) ? $data['deviceChannel'] : null;
        $this->container['installmentTotalCount'] = isset($data['installmentTotalCount']) ? $data['installmentTotalCount'] : null;
        $this->container['merchantFraudRate'] = isset($data['merchantFraudRate']) ? $data['merchantFraudRate'] : null;
        $this->container['marketingOptIn'] = isset($data['marketingOptIn']) ? $data['marketingOptIn'] : null;
        $this->container['marketingSource'] = isset($data['marketingSource']) ? $data['marketingSource'] : null;
        $this->container['mcc'] = isset($data['mcc']) ? $data['mcc'] : null;
        $this->container['merchantScore'] = isset($data['merchantScore']) ? $data['merchantScore'] : null;
        $this->container['messageCategory'] = isset($data['messageCategory']) ? $data['messageCategory'] : null;
        $this->container['npaCode'] = isset($data['npaCode']) ? $data['npaCode'] : null;
        $this->container['overridePaymentMethod'] = isset($data['overridePaymentMethod']) ? $data['overridePaymentMethod'] : null;
        $this->container['overrideCountryCode'] = isset($data['overrideCountryCode']) ? $data['overrideCountryCode'] : null;
        $this->container['priorAuthenticationData'] = isset($data['priorAuthenticationData']) ? $data['priorAuthenticationData'] : null;
        $this->container['priorAuthenticationMethod'] = isset($data['priorAuthenticationMethod']) ? $data['priorAuthenticationMethod'] : null;
        $this->container['priorAuthenticationReferenceId'] = isset($data['priorAuthenticationReferenceId']) ? $data['priorAuthenticationReferenceId'] : null;
        $this->container['priorAuthenticationTime'] = isset($data['priorAuthenticationTime']) ? $data['priorAuthenticationTime'] : null;
        $this->container['productCode'] = isset($data['productCode']) ? $data['productCode'] : null;
        $this->container['returnUrl'] = isset($data['returnUrl']) ? $data['returnUrl'] : null;
        $this->container['requestorId'] = isset($data['requestorId']) ? $data['requestorId'] : null;
        $this->container['requestorInitiatedAuthenticationIndicator'] = isset($data['requestorInitiatedAuthenticationIndicator']) ? $data['requestorInitiatedAuthenticationIndicator'] : null;
        $this->container['requestorName'] = isset($data['requestorName']) ? $data['requestorName'] : null;
        $this->container['referenceId'] = isset($data['referenceId']) ? $data['referenceId'] : null;
        $this->container['sdkMaxTimeout'] = isset($data['sdkMaxTimeout']) ? $data['sdkMaxTimeout'] : null;
        $this->container['secureCorporatePaymentIndicator'] = isset($data['secureCorporatePaymentIndicator']) ? $data['secureCorporatePaymentIndicator'] : null;
        $this->container['transactionMode'] = isset($data['transactionMode']) ? $data['transactionMode'] : null;
        $this->container['whiteListStatus'] = isset($data['whiteListStatus']) ? $data['whiteListStatus'] : null;
        $this->container['scoreRequest'] = isset($data['scoreRequest']) ? $data['scoreRequest'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['deviceChannel'] === null) {
            $invalid_properties[] = "'deviceChannel' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['deviceChannel'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets strongAuthentication
     * @return \CyberSource\Model\Riskv1decisionsConsumerAuthenticationInformationStrongAuthentication
     */
    public function getStrongAuthentication()
    {
        return $this->container['strongAuthentication'];
    }

    /**
     * Sets strongAuthentication
     * @param \CyberSource\Model\Riskv1decisionsConsumerAuthenticationInformationStrongAuthentication $strongAuthentication
     * @return $this
     */
    public function setStrongAuthentication($strongAuthentication)
    {
        $this->container['strongAuthentication'] = $strongAuthentication;

        return $this;
    }

    /**
     * Gets acsWindowSize
     * @return string
     */
    public function getAcsWindowSize()
    {
        return $this->container['acsWindowSize'];
    }

    /**
     * Sets acsWindowSize
     * @param string $acsWindowSize An override field that a merchant can pass in to set the challenge window size to display to the end cardholder.  The ACS (Active Control Server) will reply with content that is formatted appropriately to this window size to allow for the best user experience.  The sizes are width x height in pixels of the window displayed in the cardholder browser window.  01 - 250x400  02 - 390x400  03 - 500x600  04 - 600x400  05 - Full page
     * @return $this
     */
    public function setAcsWindowSize($acsWindowSize)
    {
        $this->container['acsWindowSize'] = $acsWindowSize;

        return $this;
    }

    /**
     * Gets alternateAuthenticationData
     * @return string
     */
    public function getAlternateAuthenticationData()
    {
        return $this->container['alternateAuthenticationData'];
    }

    /**
     * Sets alternateAuthenticationData
     * @param string $alternateAuthenticationData Data that documents and supports a specific authentication process.
     * @return $this
     */
    public function setAlternateAuthenticationData($alternateAuthenticationData)
    {
        $this->container['alternateAuthenticationData'] = $alternateAuthenticationData;

        return $this;
    }

    /**
     * Gets alternateAuthenticationDate
     * @return string
     */
    public function getAlternateAuthenticationDate()
    {
        return $this->container['alternateAuthenticationDate'];
    }

    /**
     * Sets alternateAuthenticationDate
     * @param string $alternateAuthenticationDate Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM
     * @return $this
     */
    public function setAlternateAuthenticationDate($alternateAuthenticationDate)
    {
        $this->container['alternateAuthenticationDate'] = $alternateAuthenticationDate;

        return $this;
    }

    /**
     * Gets alternateAuthenticationMethod
     * @return string
     */
    public function getAlternateAuthenticationMethod()
    {
        return $this->container['alternateAuthenticationMethod'];
    }

    /**
     * Sets alternateAuthenticationMethod
     * @param string $alternateAuthenticationMethod Mechanism used by the cardholder to authenticate to the 3D Secure requestor. Possible values: - `01`: No authentication occurred - `02`: Login using merchant system credentials - `03`: Login using Federated ID - `04`: Login using issuer credentials - `05`: Login using third-party authenticator - `06`: Login using FIDO Authenticator
     * @return $this
     */
    public function setAlternateAuthenticationMethod($alternateAuthenticationMethod)
    {
        $this->container['alternateAuthenticationMethod'] = $alternateAuthenticationMethod;

        return $this;
    }

    /**
     * Gets authenticationDate
     * @return string
     */
    public function getAuthenticationDate()
    {
        return $this->container['authenticationDate'];
    }

    /**
     * Sets authenticationDate
     * @param string $authenticationDate The date/time of the authentication at the 3DS servers. RISK update authorization service in auth request payload with value returned in `consumerAuthenticationInformation.alternateAuthenticationData` if merchant calls via CYBS or field can be provided by merchant in authorization request if calling an external 3DS provider.  This field is supported for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. Format: YYYYMMDDHHMMSS
     * @return $this
     */
    public function setAuthenticationDate($authenticationDate)
    {
        $this->container['authenticationDate'] = $authenticationDate;

        return $this;
    }

    /**
     * Gets authenticationTransactionId
     * @return string
     */
    public function getAuthenticationTransactionId()
    {
        return $this->container['authenticationTransactionId'];
    }

    /**
     * Sets authenticationTransactionId
     * @param string $authenticationTransactionId Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages.For Rupay,this is passed only in Re-Send OTP usecase. **Note**: Required for Standard integration, Rupay Seamless server to server integration for enroll service. Required for Hybrid integration for validate service.
     * @return $this
     */
    public function setAuthenticationTransactionId($authenticationTransactionId)
    {
        $this->container['authenticationTransactionId'] = $authenticationTransactionId;

        return $this;
    }

    /**
     * Gets transactionFlowIndicator
     * @return int
     */
    public function getTransactionFlowIndicator()
    {
        return $this->container['transactionFlowIndicator'];
    }

    /**
     * Sets transactionFlowIndicator
     * @param int $transactionFlowIndicator This  field is only applicable to Rupay and is optional. Merchant will have to pass a valid value from 01 through 07 which indicates the transaction flow. Below are the possible values. 01:NW- Transaction performed at domestic merchant. 02:TW- Transaction performed at domestic merchant along with Token provisioning. 03:IT- Transaction performed at International merchant. 04:AT- Authentication Transaction Only. 05:AW- Authentication transaction for provisioning. 06:DI- Domestic InApp Transaction. 07:II- International InApp transaction. 08:GC- Guest Checkout 09:ST- SI Authentication Transaction only 10:SW- SI Authorization along with token provisioning
     * @return $this
     */
    public function setTransactionFlowIndicator($transactionFlowIndicator)
    {
        $this->container['transactionFlowIndicator'] = $transactionFlowIndicator;

        return $this;
    }

    /**
     * Gets challengeCode
     * @return string
     */
    public function getChallengeCode()
    {
        return $this->container['challengeCode'];
    }

    /**
     * Sets challengeCode
     * @param string $challengeCode Possible values: - `01`: No preference - `02`: No challenge request - `03`: Challenge requested (3D Secure requestor preference) - `04`: Challenge requested (mandate) - `05`: No challenge requested (transactional risk analysis is already performed) - `06`: No challenge requested (Data share only) - `07`: No challenge requested (strong consumer authentication is already performed) - `08`: No challenge requested (utilize whitelist exemption if no challenge required) - `09`: Challenge requested (whitelist prompt requested if challenge required) **Note** This field will default to `01` on merchant configuration and can be overridden by the merchant. EMV 3D Secure version 2.1.0 supports values `01-04`. Version 2.2.0 supports values `01-09`.
     * @return $this
     */
    public function setChallengeCode($challengeCode)
    {
        $this->container['challengeCode'] = $challengeCode;

        return $this;
    }

    /**
     * Gets challengeStatus
     * @return string
     */
    public function getChallengeStatus()
    {
        return $this->container['challengeStatus'];
    }

    /**
     * Sets challengeStatus
     * @param string $challengeStatus The `consumerAuthenticationInformation.challengeCode` indicates the authentication type/level, or challenge, that was presented to the cardholder at checkout by the merchant when calling the Carte Bancaire 3DS servers via CYBS RISK services. It conveys to the issuer the alternative authentication methods that the consumer used.
     * @return $this
     */
    public function setChallengeStatus($challengeStatus)
    {
        $this->container['challengeStatus'] = $challengeStatus;

        return $this;
    }

    /**
     * Gets customerCardAlias
     * @return string
     */
    public function getCustomerCardAlias()
    {
        return $this->container['customerCardAlias'];
    }

    /**
     * Sets customerCardAlias
     * @param string $customerCardAlias An alias that uniquely identifies the customer's account and credit card on file. Note This field is required if Tokenization is enabled in the merchant profile settings.
     * @return $this
     */
    public function setCustomerCardAlias($customerCardAlias)
    {
        $this->container['customerCardAlias'] = $customerCardAlias;

        return $this;
    }

    /**
     * Gets decoupledAuthenticationIndicator
     * @return string
     */
    public function getDecoupledAuthenticationIndicator()
    {
        return $this->container['decoupledAuthenticationIndicator'];
    }

    /**
     * Sets decoupledAuthenticationIndicator
     * @param string $decoupledAuthenticationIndicator Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N
     * @return $this
     */
    public function setDecoupledAuthenticationIndicator($decoupledAuthenticationIndicator)
    {
        $this->container['decoupledAuthenticationIndicator'] = $decoupledAuthenticationIndicator;

        return $this;
    }

    /**
     * Gets decoupledAuthenticationMaxTime
     * @return string
     */
    public function getDecoupledAuthenticationMaxTime()
    {
        return $this->container['decoupledAuthenticationMaxTime'];
    }

    /**
     * Sets decoupledAuthenticationMaxTime
     * @param string $decoupledAuthenticationMaxTime Indicates the maximum amount of time that the 3DS Requestor will wait for an ACS (Active control server) to provide the results of a Decoupled Authentication transaction (in minutes). Possible Values: Numeric values between 1 and 10080 accepted.
     * @return $this
     */
    public function setDecoupledAuthenticationMaxTime($decoupledAuthenticationMaxTime)
    {
        $this->container['decoupledAuthenticationMaxTime'] = $decoupledAuthenticationMaxTime;

        return $this;
    }

    /**
     * Gets defaultCard
     * @return bool
     */
    public function getDefaultCard()
    {
        return $this->container['defaultCard'];
    }

    /**
     * Sets defaultCard
     * @param bool $defaultCard Indicates that the card being used is the one designated as the primary payment card for purchase. Recommended for Discover ProtectBuy.
     * @return $this
     */
    public function setDefaultCard($defaultCard)
    {
        $this->container['defaultCard'] = $defaultCard;

        return $this;
    }

    /**
     * Gets deviceChannel
     * @return string
     */
    public function getDeviceChannel()
    {
        return $this->container['deviceChannel'];
    }

    /**
     * Sets deviceChannel
     * @param string $deviceChannel Determines the channel that the transaction came through. Possible Values: SDK/Browser/3RI. 3RI - 3DS request initiated.
     * @return $this
     */
    public function setDeviceChannel($deviceChannel)
    {
        $this->container['deviceChannel'] = $deviceChannel;

        return $this;
    }

    /**
     * Gets installmentTotalCount
     * @return int
     */
    public function getInstallmentTotalCount()
    {
        return $this->container['installmentTotalCount'];
    }

    /**
     * Sets installmentTotalCount
     * @param int $installmentTotalCount An integer value greater than 1 indicating the max number of permitted authorizations for installment payments. **Note** This is required if the merchant and cardholder have agreed to installment payments.
     * @return $this
     */
    public function setInstallmentTotalCount($installmentTotalCount)
    {
        $this->container['installmentTotalCount'] = $installmentTotalCount;

        return $this;
    }

    /**
     * Gets merchantFraudRate
     * @return string
     */
    public function getMerchantFraudRate()
    {
        return $this->container['merchantFraudRate'];
    }

    /**
     * Sets merchantFraudRate
     * @param string $merchantFraudRate Calculated by merchants as per PSD2** RTS** (EEA** card fraud divided by all EEA card volumes). Possible Values: 1 = Represents fraud rate <=1  2 = Represents fraud rate >1 and <=6  3 = Represents fraud rate >6 and <=13  4 = Represents fraud rate >13 and <=25  5 = Represents fraud rate >25  EEA** = European Economic Area RTS** = Regulatory Technical Standards PSD2** = Payment Services Directive
     * @return $this
     */
    public function setMerchantFraudRate($merchantFraudRate)
    {
        $this->container['merchantFraudRate'] = $merchantFraudRate;

        return $this;
    }

    /**
     * Gets marketingOptIn
     * @return bool
     */
    public function getMarketingOptIn()
    {
        return $this->container['marketingOptIn'];
    }

    /**
     * Sets marketingOptIn
     * @param bool $marketingOptIn Indicates whether the customer has opted in for marketing offers. Recommended for Discover ProtectBuy.
     * @return $this
     */
    public function setMarketingOptIn($marketingOptIn)
    {
        $this->container['marketingOptIn'] = $marketingOptIn;

        return $this;
    }

    /**
     * Gets marketingSource
     * @return string
     */
    public function getMarketingSource()
    {
        return $this->container['marketingSource'];
    }

    /**
     * Sets marketingSource
     * @param string $marketingSource Indicates origin of the marketing offer. Recommended for Discover ProtectBuy.
     * @return $this
     */
    public function setMarketingSource($marketingSource)
    {
        $this->container['marketingSource'] = $marketingSource;

        return $this;
    }

    /**
     * Gets mcc
     * @return string
     */
    public function getMcc()
    {
        return $this->container['mcc'];
    }

    /**
     * Sets mcc
     * @param string $mcc Merchant category code. **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions.
     * @return $this
     */
    public function setMcc($mcc)
    {
        $this->container['mcc'] = $mcc;

        return $this;
    }

    /**
     * Gets merchantScore
     * @return int
     */
    public function getMerchantScore()
    {
        return $this->container['merchantScore'];
    }

    /**
     * Sets merchantScore
     * @param int $merchantScore Risk Score provided by merchants. This is specific for CB transactions.
     * @return $this
     */
    public function setMerchantScore($merchantScore)
    {
        $this->container['merchantScore'] = $merchantScore;

        return $this;
    }

    /**
     * Gets messageCategory
     * @return string
     */
    public function getMessageCategory()
    {
        return $this->container['messageCategory'];
    }

    /**
     * Sets messageCategory
     * @param string $messageCategory Category of the message for a specific use case. Possible values:  - `01`: PA- payment authentication - `02`: NPA- non-payment authentication - `03-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use
     * @return $this
     */
    public function setMessageCategory($messageCategory)
    {
        $this->container['messageCategory'] = $messageCategory;

        return $this;
    }

    /**
     * Gets npaCode
     * @return string
     */
    public function getNpaCode()
    {
        return $this->container['npaCode'];
    }

    /**
     * Sets npaCode
     * @param string $npaCode Non-Payer Authentication Indicator. Possible values: - `01`: Add card - `02`: Maintain card information - `03`: Cardholder verification for EMV token - `04-80` Reserved for EMVCo - `80-90` Reserved DS
     * @return $this
     */
    public function setNpaCode($npaCode)
    {
        $this->container['npaCode'] = $npaCode;

        return $this;
    }

    /**
     * Gets overridePaymentMethod
     * @return string
     */
    public function getOverridePaymentMethod()
    {
        return $this->container['overridePaymentMethod'];
    }

    /**
     * Sets overridePaymentMethod
     * @param string $overridePaymentMethod Specifies the Brazilian payment account type used for the transaction. This field overrides other payment types that might be specified in the request. Use one of the following values for this field: - `NA`: Not applicable. Do not override other payment types that are specified in the request. - `CR`: Credit card. - `DB`: Debit card. - `VSAVR`: Visa Vale Refeicao - `VSAVA`: Visa Vale Alimentacao **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions.
     * @return $this
     */
    public function setOverridePaymentMethod($overridePaymentMethod)
    {
        $this->container['overridePaymentMethod'] = $overridePaymentMethod;

        return $this;
    }

    /**
     * Gets overrideCountryCode
     * @return string
     */
    public function getOverrideCountryCode()
    {
        return $this->container['overrideCountryCode'];
    }

    /**
     * Sets overrideCountryCode
     * @param string $overrideCountryCode Two-character [ISO Standard Country Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf)..
     * @return $this
     */
    public function setOverrideCountryCode($overrideCountryCode)
    {
        $this->container['overrideCountryCode'] = $overrideCountryCode;

        return $this;
    }

    /**
     * Gets priorAuthenticationData
     * @return string
     */
    public function getPriorAuthenticationData()
    {
        return $this->container['priorAuthenticationData'];
    }

    /**
     * Sets priorAuthenticationData
     * @param string $priorAuthenticationData This field carry data that the ACS can use to verify the authentication process.
     * @return $this
     */
    public function setPriorAuthenticationData($priorAuthenticationData)
    {
        $this->container['priorAuthenticationData'] = $priorAuthenticationData;

        return $this;
    }

    /**
     * Gets priorAuthenticationMethod
     * @return string
     */
    public function getPriorAuthenticationMethod()
    {
        return $this->container['priorAuthenticationMethod'];
    }

    /**
     * Sets priorAuthenticationMethod
     * @param string $priorAuthenticationMethod Mechanism used by the Cardholder to previously authenticate to the 3DS Requestor.  01 - Frictionless authentication occurred by ACS  02 - Cardholder challenge occurred by ACS  03 - AVS verified  04 - Other issuer methods  05-79 - Reserved for EMVCo future use (values invalid until defined by EMVCo)  80-99 - Reserved for DS use
     * @return $this
     */
    public function setPriorAuthenticationMethod($priorAuthenticationMethod)
    {
        $this->container['priorAuthenticationMethod'] = $priorAuthenticationMethod;

        return $this;
    }

    /**
     * Gets priorAuthenticationReferenceId
     * @return string
     */
    public function getPriorAuthenticationReferenceId()
    {
        return $this->container['priorAuthenticationReferenceId'];
    }

    /**
     * Sets priorAuthenticationReferenceId
     * @param string $priorAuthenticationReferenceId This data element contains a ACS Transaction ID for a prior authenticated transaction. For example, the first recurring transaction that was authenticated with the cardholder
     * @return $this
     */
    public function setPriorAuthenticationReferenceId($priorAuthenticationReferenceId)
    {
        $this->container['priorAuthenticationReferenceId'] = $priorAuthenticationReferenceId;

        return $this;
    }

    /**
     * Gets priorAuthenticationTime
     * @return string
     */
    public function getPriorAuthenticationTime()
    {
        return $this->container['priorAuthenticationTime'];
    }

    /**
     * Sets priorAuthenticationTime
     * @param string $priorAuthenticationTime Date and time in UTC of the prior cardholder authentication. Format – YYYYMMDDHHMM
     * @return $this
     */
    public function setPriorAuthenticationTime($priorAuthenticationTime)
    {
        $this->container['priorAuthenticationTime'] = $priorAuthenticationTime;

        return $this;
    }

    /**
     * Gets productCode
     * @return string
     */
    public function getProductCode()
    {
        return $this->container['productCode'];
    }

    /**
     * Sets productCode
     * @param string $productCode Specifies the product code, which designates the type of transaction. Specify one of the following values for this field: - AIR: Airline purchase Important Required for American Express SafeKey (U.S.). - `ACC`: Accommodation Rental - `ACF`: Account funding - `CHA`: Check acceptance - `DIG`: Digital Goods - `DSP`: Cash Dispensing - `GAS`: Fuel - `GEN`: General Retail - `LUX`: Luxury Retail - `PAL`: Prepaid activation and load - `PHY`: Goods or services purchase - `QCT`: Quasi-cash transaction - `REN`: Car Rental - `RES`: Restaurant - `SVC`: Services - `TBD`: Other - `TRA`: Travel **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions.
     * @return $this
     */
    public function setProductCode($productCode)
    {
        $this->container['productCode'] = $productCode;

        return $this;
    }

    /**
     * Gets returnUrl
     * @return string
     */
    public function getReturnUrl()
    {
        return $this->container['returnUrl'];
    }

    /**
     * Sets returnUrl
     * @param string $returnUrl The URL of the merchant's return page. CyberSource adds this return URL to the step-up JWT and returns it in the response of the Payer Authentication enrollment call. The merchant's return URL page serves as a listening URL. Once the bank session completes, the merchant receives a POST to their URL. This response contains the completed bank session's transactionId. The merchant's return page should capture the transaction ID and send it in the Payer Authentication validation call.
     * @return $this
     */
    public function setReturnUrl($returnUrl)
    {
        $this->container['returnUrl'] = $returnUrl;

        return $this;
    }

    /**
     * Gets requestorId
     * @return string
     */
    public function getRequestorId()
    {
        return $this->container['requestorId'];
    }

    /**
     * Sets requestorId
     * @param string $requestorId Cardinal's directory server assigned 3DS Requestor ID value
     * @return $this
     */
    public function setRequestorId($requestorId)
    {
        $this->container['requestorId'] = $requestorId;

        return $this;
    }

    /**
     * Gets requestorInitiatedAuthenticationIndicator
     * @return string
     */
    public function getRequestorInitiatedAuthenticationIndicator()
    {
        return $this->container['requestorInitiatedAuthenticationIndicator'];
    }

    /**
     * Sets requestorInitiatedAuthenticationIndicator
     * @param string $requestorInitiatedAuthenticationIndicator Indicates the type of 3RI request.  Possible Values:  01 - Recurring transaction  02 - Installment transaction  03 - Add card  04 - Maintain card  05 - Account verification  06 - Split/delayed shipment  07 - Top-up  08 - Mail Order  09 - Telephone Order  10 - Whitelist status check  11 - Other payment
     * @return $this
     */
    public function setRequestorInitiatedAuthenticationIndicator($requestorInitiatedAuthenticationIndicator)
    {
        $this->container['requestorInitiatedAuthenticationIndicator'] = $requestorInitiatedAuthenticationIndicator;

        return $this;
    }

    /**
     * Gets requestorName
     * @return string
     */
    public function getRequestorName()
    {
        return $this->container['requestorName'];
    }

    /**
     * Sets requestorName
     * @param string $requestorName Cardinal's directory server assigned 3DS Requestor Name value
     * @return $this
     */
    public function setRequestorName($requestorName)
    {
        $this->container['requestorName'] = $requestorName;

        return $this;
    }

    /**
     * Gets referenceId
     * @return string
     */
    public function getReferenceId()
    {
        return $this->container['referenceId'];
    }

    /**
     * Sets referenceId
     * @param string $referenceId Reference ID that corresponds to the device fingerprinting data that was collected previously. Note Required for Hybrid integration.
     * @return $this
     */
    public function setReferenceId($referenceId)
    {
        $this->container['referenceId'] = $referenceId;

        return $this;
    }

    /**
     * Gets sdkMaxTimeout
     * @return string
     */
    public function getSdkMaxTimeout()
    {
        return $this->container['sdkMaxTimeout'];
    }

    /**
     * Sets sdkMaxTimeout
     * @param string $sdkMaxTimeout This field indicates the maximum amount of time for all 3DS 2.0 messages to be communicated between all components (in minutes).  Possible Values:  Greater than or equal to 05 (05 is the minimum timeout to set)  Cardinal Default is set to 15  NOTE: This field is a required 3DS 2.0 field and Cardinal sends in a default of 15 if nothing is passed
     * @return $this
     */
    public function setSdkMaxTimeout($sdkMaxTimeout)
    {
        $this->container['sdkMaxTimeout'] = $sdkMaxTimeout;

        return $this;
    }

    /**
     * Gets secureCorporatePaymentIndicator
     * @return string
     */
    public function getSecureCorporatePaymentIndicator()
    {
        return $this->container['secureCorporatePaymentIndicator'];
    }

    /**
     * Sets secureCorporatePaymentIndicator
     * @param string $secureCorporatePaymentIndicator Indicates dedicated payment processes and procedures were used, potential secure corporate payment exemption applies. Possible Values : 0/1
     * @return $this
     */
    public function setSecureCorporatePaymentIndicator($secureCorporatePaymentIndicator)
    {
        $this->container['secureCorporatePaymentIndicator'] = $secureCorporatePaymentIndicator;

        return $this;
    }

    /**
     * Gets transactionMode
     * @return string
     */
    public function getTransactionMode()
    {
        return $this->container['transactionMode'];
    }

    /**
     * Sets transactionMode
     * @param string $transactionMode Transaction mode identifier. Identifies the channel from which the transaction originates. Possible values:  - `M`: MOTO (Mail Order Telephone Order) - `R`: Retail - `S`: eCommerce - `P`: Mobile Device - `T`: Tablet
     * @return $this
     */
    public function setTransactionMode($transactionMode)
    {
        $this->container['transactionMode'] = $transactionMode;

        return $this;
    }

    /**
     * Gets whiteListStatus
     * @return string
     */
    public function getWhiteListStatus()
    {
        return $this->container['whiteListStatus'];
    }

    /**
     * Sets whiteListStatus
     * @param string $whiteListStatus Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder
     * @return $this
     */
    public function setWhiteListStatus($whiteListStatus)
    {
        $this->container['whiteListStatus'] = $whiteListStatus;

        return $this;
    }

    /**
     * Gets scoreRequest
     * @return int
     */
    public function getScoreRequest()
    {
        return $this->container['scoreRequest'];
    }

    /**
     * Sets scoreRequest
     * @param int $scoreRequest Risk Assessment from Mastercard. This is to be sent by merchant if they would like to request a score
     * @return $this
     */
    public function setScoreRequest($scoreRequest)
    {
        $this->container['scoreRequest'] = $scoreRequest;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


