<?php
/**
 * RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'riskV1DecisionsPost201Response_consumerAuthenticationInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'accessToken' => 'string',
        'acsRenderingType' => 'string',
        'acsTransactionId' => 'string',
        'acsUrl' => 'string',
        'authenticationPath' => 'string',
        'authorizationPayload' => 'string',
        'authenticationType' => 'string',
        'authenticationTransactionId' => 'string',
        'authenticationTransactionContextId' => 'string',
        'validityPeriod' => 'int',
        'cardholderMessage' => 'string',
        'cavv' => 'string',
        'cavvAlgorithm' => 'string',
        'challengeCancelCode' => 'string',
        'challengeRequired' => 'string',
        'decoupledAuthenticationIndicator' => 'string',
        'directoryServerErrorCode' => 'string',
        'directoryServerErrorDescription' => 'string',
        'ecommerceIndicator' => 'string',
        'eci' => 'string',
        'eciRaw' => 'string',
        'effectiveAuthenticationType' => 'string',
        'exemptionDataRaw' => 'string',
        'ivr' => '\CyberSource\Model\PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr',
        'networkScore' => 'string',
        'pareq' => 'string',
        'paresStatus' => 'string',
        'proofXml' => 'string',
        'proxyPan' => 'string',
        'sdkTransactionId' => 'string',
        'signedParesStatusReason' => 'string',
        'specificationVersion' => 'string',
        'stepUpUrl' => 'string',
        'threeDSServerTransactionId' => 'string',
        'ucafAuthenticationData' => 'string',
        'ucafCollectionIndicator' => 'string',
        'veresEnrolled' => 'string',
        'whiteListStatusSource' => 'string',
        'xid' => 'string',
        'directoryServerTransactionId' => 'string',
        'acsOperatorID' => 'string',
        'acsReferenceNumber' => 'string',
        'idciDecision' => 'string',
        'idciReasonCode1' => 'string',
        'idciReasonCode2' => 'string',
        'idciScore' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'accessToken' => null,
        'acsRenderingType' => null,
        'acsTransactionId' => null,
        'acsUrl' => null,
        'authenticationPath' => null,
        'authorizationPayload' => null,
        'authenticationType' => null,
        'authenticationTransactionId' => null,
        'authenticationTransactionContextId' => null,
        'validityPeriod' => null,
        'cardholderMessage' => null,
        'cavv' => null,
        'cavvAlgorithm' => null,
        'challengeCancelCode' => null,
        'challengeRequired' => null,
        'decoupledAuthenticationIndicator' => null,
        'directoryServerErrorCode' => null,
        'directoryServerErrorDescription' => null,
        'ecommerceIndicator' => null,
        'eci' => null,
        'eciRaw' => null,
        'effectiveAuthenticationType' => null,
        'exemptionDataRaw' => null,
        'ivr' => null,
        'networkScore' => null,
        'pareq' => null,
        'paresStatus' => null,
        'proofXml' => null,
        'proxyPan' => null,
        'sdkTransactionId' => null,
        'signedParesStatusReason' => null,
        'specificationVersion' => null,
        'stepUpUrl' => null,
        'threeDSServerTransactionId' => null,
        'ucafAuthenticationData' => null,
        'ucafCollectionIndicator' => null,
        'veresEnrolled' => null,
        'whiteListStatusSource' => null,
        'xid' => null,
        'directoryServerTransactionId' => null,
        'acsOperatorID' => null,
        'acsReferenceNumber' => null,
        'idciDecision' => null,
        'idciReasonCode1' => null,
        'idciReasonCode2' => null,
        'idciScore' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'accessToken' => 'accessToken',
        'acsRenderingType' => 'acsRenderingType',
        'acsTransactionId' => 'acsTransactionId',
        'acsUrl' => 'acsUrl',
        'authenticationPath' => 'authenticationPath',
        'authorizationPayload' => 'authorizationPayload',
        'authenticationType' => 'authenticationType',
        'authenticationTransactionId' => 'authenticationTransactionId',
        'authenticationTransactionContextId' => 'authenticationTransactionContextId',
        'validityPeriod' => 'validityPeriod',
        'cardholderMessage' => 'cardholderMessage',
        'cavv' => 'cavv',
        'cavvAlgorithm' => 'cavvAlgorithm',
        'challengeCancelCode' => 'challengeCancelCode',
        'challengeRequired' => 'challengeRequired',
        'decoupledAuthenticationIndicator' => 'decoupledAuthenticationIndicator',
        'directoryServerErrorCode' => 'directoryServerErrorCode',
        'directoryServerErrorDescription' => 'directoryServerErrorDescription',
        'ecommerceIndicator' => 'ecommerceIndicator',
        'eci' => 'eci',
        'eciRaw' => 'eciRaw',
        'effectiveAuthenticationType' => 'effectiveAuthenticationType',
        'exemptionDataRaw' => 'exemptionDataRaw',
        'ivr' => 'ivr',
        'networkScore' => 'networkScore',
        'pareq' => 'pareq',
        'paresStatus' => 'paresStatus',
        'proofXml' => 'proofXml',
        'proxyPan' => 'proxyPan',
        'sdkTransactionId' => 'sdkTransactionId',
        'signedParesStatusReason' => 'signedParesStatusReason',
        'specificationVersion' => 'specificationVersion',
        'stepUpUrl' => 'stepUpUrl',
        'threeDSServerTransactionId' => 'threeDSServerTransactionId',
        'ucafAuthenticationData' => 'ucafAuthenticationData',
        'ucafCollectionIndicator' => 'ucafCollectionIndicator',
        'veresEnrolled' => 'veresEnrolled',
        'whiteListStatusSource' => 'whiteListStatusSource',
        'xid' => 'xid',
        'directoryServerTransactionId' => 'directoryServerTransactionId',
        'acsOperatorID' => 'acsOperatorID',
        'acsReferenceNumber' => 'acsReferenceNumber',
        'idciDecision' => 'idciDecision',
        'idciReasonCode1' => 'idciReasonCode1',
        'idciReasonCode2' => 'idciReasonCode2',
        'idciScore' => 'idciScore'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'accessToken' => 'setAccessToken',
        'acsRenderingType' => 'setAcsRenderingType',
        'acsTransactionId' => 'setAcsTransactionId',
        'acsUrl' => 'setAcsUrl',
        'authenticationPath' => 'setAuthenticationPath',
        'authorizationPayload' => 'setAuthorizationPayload',
        'authenticationType' => 'setAuthenticationType',
        'authenticationTransactionId' => 'setAuthenticationTransactionId',
        'authenticationTransactionContextId' => 'setAuthenticationTransactionContextId',
        'validityPeriod' => 'setValidityPeriod',
        'cardholderMessage' => 'setCardholderMessage',
        'cavv' => 'setCavv',
        'cavvAlgorithm' => 'setCavvAlgorithm',
        'challengeCancelCode' => 'setChallengeCancelCode',
        'challengeRequired' => 'setChallengeRequired',
        'decoupledAuthenticationIndicator' => 'setDecoupledAuthenticationIndicator',
        'directoryServerErrorCode' => 'setDirectoryServerErrorCode',
        'directoryServerErrorDescription' => 'setDirectoryServerErrorDescription',
        'ecommerceIndicator' => 'setEcommerceIndicator',
        'eci' => 'setEci',
        'eciRaw' => 'setEciRaw',
        'effectiveAuthenticationType' => 'setEffectiveAuthenticationType',
        'exemptionDataRaw' => 'setExemptionDataRaw',
        'ivr' => 'setIvr',
        'networkScore' => 'setNetworkScore',
        'pareq' => 'setPareq',
        'paresStatus' => 'setParesStatus',
        'proofXml' => 'setProofXml',
        'proxyPan' => 'setProxyPan',
        'sdkTransactionId' => 'setSdkTransactionId',
        'signedParesStatusReason' => 'setSignedParesStatusReason',
        'specificationVersion' => 'setSpecificationVersion',
        'stepUpUrl' => 'setStepUpUrl',
        'threeDSServerTransactionId' => 'setThreeDSServerTransactionId',
        'ucafAuthenticationData' => 'setUcafAuthenticationData',
        'ucafCollectionIndicator' => 'setUcafCollectionIndicator',
        'veresEnrolled' => 'setVeresEnrolled',
        'whiteListStatusSource' => 'setWhiteListStatusSource',
        'xid' => 'setXid',
        'directoryServerTransactionId' => 'setDirectoryServerTransactionId',
        'acsOperatorID' => 'setAcsOperatorID',
        'acsReferenceNumber' => 'setAcsReferenceNumber',
        'idciDecision' => 'setIdciDecision',
        'idciReasonCode1' => 'setIdciReasonCode1',
        'idciReasonCode2' => 'setIdciReasonCode2',
        'idciScore' => 'setIdciScore'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'accessToken' => 'getAccessToken',
        'acsRenderingType' => 'getAcsRenderingType',
        'acsTransactionId' => 'getAcsTransactionId',
        'acsUrl' => 'getAcsUrl',
        'authenticationPath' => 'getAuthenticationPath',
        'authorizationPayload' => 'getAuthorizationPayload',
        'authenticationType' => 'getAuthenticationType',
        'authenticationTransactionId' => 'getAuthenticationTransactionId',
        'authenticationTransactionContextId' => 'getAuthenticationTransactionContextId',
        'validityPeriod' => 'getValidityPeriod',
        'cardholderMessage' => 'getCardholderMessage',
        'cavv' => 'getCavv',
        'cavvAlgorithm' => 'getCavvAlgorithm',
        'challengeCancelCode' => 'getChallengeCancelCode',
        'challengeRequired' => 'getChallengeRequired',
        'decoupledAuthenticationIndicator' => 'getDecoupledAuthenticationIndicator',
        'directoryServerErrorCode' => 'getDirectoryServerErrorCode',
        'directoryServerErrorDescription' => 'getDirectoryServerErrorDescription',
        'ecommerceIndicator' => 'getEcommerceIndicator',
        'eci' => 'getEci',
        'eciRaw' => 'getEciRaw',
        'effectiveAuthenticationType' => 'getEffectiveAuthenticationType',
        'exemptionDataRaw' => 'getExemptionDataRaw',
        'ivr' => 'getIvr',
        'networkScore' => 'getNetworkScore',
        'pareq' => 'getPareq',
        'paresStatus' => 'getParesStatus',
        'proofXml' => 'getProofXml',
        'proxyPan' => 'getProxyPan',
        'sdkTransactionId' => 'getSdkTransactionId',
        'signedParesStatusReason' => 'getSignedParesStatusReason',
        'specificationVersion' => 'getSpecificationVersion',
        'stepUpUrl' => 'getStepUpUrl',
        'threeDSServerTransactionId' => 'getThreeDSServerTransactionId',
        'ucafAuthenticationData' => 'getUcafAuthenticationData',
        'ucafCollectionIndicator' => 'getUcafCollectionIndicator',
        'veresEnrolled' => 'getVeresEnrolled',
        'whiteListStatusSource' => 'getWhiteListStatusSource',
        'xid' => 'getXid',
        'directoryServerTransactionId' => 'getDirectoryServerTransactionId',
        'acsOperatorID' => 'getAcsOperatorID',
        'acsReferenceNumber' => 'getAcsReferenceNumber',
        'idciDecision' => 'getIdciDecision',
        'idciReasonCode1' => 'getIdciReasonCode1',
        'idciReasonCode2' => 'getIdciReasonCode2',
        'idciScore' => 'getIdciScore'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['accessToken'] = isset($data['accessToken']) ? $data['accessToken'] : null;
        $this->container['acsRenderingType'] = isset($data['acsRenderingType']) ? $data['acsRenderingType'] : null;
        $this->container['acsTransactionId'] = isset($data['acsTransactionId']) ? $data['acsTransactionId'] : null;
        $this->container['acsUrl'] = isset($data['acsUrl']) ? $data['acsUrl'] : null;
        $this->container['authenticationPath'] = isset($data['authenticationPath']) ? $data['authenticationPath'] : null;
        $this->container['authorizationPayload'] = isset($data['authorizationPayload']) ? $data['authorizationPayload'] : null;
        $this->container['authenticationType'] = isset($data['authenticationType']) ? $data['authenticationType'] : null;
        $this->container['authenticationTransactionId'] = isset($data['authenticationTransactionId']) ? $data['authenticationTransactionId'] : null;
        $this->container['authenticationTransactionContextId'] = isset($data['authenticationTransactionContextId']) ? $data['authenticationTransactionContextId'] : null;
        $this->container['validityPeriod'] = isset($data['validityPeriod']) ? $data['validityPeriod'] : null;
        $this->container['cardholderMessage'] = isset($data['cardholderMessage']) ? $data['cardholderMessage'] : null;
        $this->container['cavv'] = isset($data['cavv']) ? $data['cavv'] : null;
        $this->container['cavvAlgorithm'] = isset($data['cavvAlgorithm']) ? $data['cavvAlgorithm'] : null;
        $this->container['challengeCancelCode'] = isset($data['challengeCancelCode']) ? $data['challengeCancelCode'] : null;
        $this->container['challengeRequired'] = isset($data['challengeRequired']) ? $data['challengeRequired'] : null;
        $this->container['decoupledAuthenticationIndicator'] = isset($data['decoupledAuthenticationIndicator']) ? $data['decoupledAuthenticationIndicator'] : null;
        $this->container['directoryServerErrorCode'] = isset($data['directoryServerErrorCode']) ? $data['directoryServerErrorCode'] : null;
        $this->container['directoryServerErrorDescription'] = isset($data['directoryServerErrorDescription']) ? $data['directoryServerErrorDescription'] : null;
        $this->container['ecommerceIndicator'] = isset($data['ecommerceIndicator']) ? $data['ecommerceIndicator'] : null;
        $this->container['eci'] = isset($data['eci']) ? $data['eci'] : null;
        $this->container['eciRaw'] = isset($data['eciRaw']) ? $data['eciRaw'] : null;
        $this->container['effectiveAuthenticationType'] = isset($data['effectiveAuthenticationType']) ? $data['effectiveAuthenticationType'] : null;
        $this->container['exemptionDataRaw'] = isset($data['exemptionDataRaw']) ? $data['exemptionDataRaw'] : null;
        $this->container['ivr'] = isset($data['ivr']) ? $data['ivr'] : null;
        $this->container['networkScore'] = isset($data['networkScore']) ? $data['networkScore'] : null;
        $this->container['pareq'] = isset($data['pareq']) ? $data['pareq'] : null;
        $this->container['paresStatus'] = isset($data['paresStatus']) ? $data['paresStatus'] : null;
        $this->container['proofXml'] = isset($data['proofXml']) ? $data['proofXml'] : null;
        $this->container['proxyPan'] = isset($data['proxyPan']) ? $data['proxyPan'] : null;
        $this->container['sdkTransactionId'] = isset($data['sdkTransactionId']) ? $data['sdkTransactionId'] : null;
        $this->container['signedParesStatusReason'] = isset($data['signedParesStatusReason']) ? $data['signedParesStatusReason'] : null;
        $this->container['specificationVersion'] = isset($data['specificationVersion']) ? $data['specificationVersion'] : null;
        $this->container['stepUpUrl'] = isset($data['stepUpUrl']) ? $data['stepUpUrl'] : null;
        $this->container['threeDSServerTransactionId'] = isset($data['threeDSServerTransactionId']) ? $data['threeDSServerTransactionId'] : null;
        $this->container['ucafAuthenticationData'] = isset($data['ucafAuthenticationData']) ? $data['ucafAuthenticationData'] : null;
        $this->container['ucafCollectionIndicator'] = isset($data['ucafCollectionIndicator']) ? $data['ucafCollectionIndicator'] : null;
        $this->container['veresEnrolled'] = isset($data['veresEnrolled']) ? $data['veresEnrolled'] : null;
        $this->container['whiteListStatusSource'] = isset($data['whiteListStatusSource']) ? $data['whiteListStatusSource'] : null;
        $this->container['xid'] = isset($data['xid']) ? $data['xid'] : null;
        $this->container['directoryServerTransactionId'] = isset($data['directoryServerTransactionId']) ? $data['directoryServerTransactionId'] : null;
        $this->container['acsOperatorID'] = isset($data['acsOperatorID']) ? $data['acsOperatorID'] : null;
        $this->container['acsReferenceNumber'] = isset($data['acsReferenceNumber']) ? $data['acsReferenceNumber'] : null;
        $this->container['idciDecision'] = isset($data['idciDecision']) ? $data['idciDecision'] : null;
        $this->container['idciReasonCode1'] = isset($data['idciReasonCode1']) ? $data['idciReasonCode1'] : null;
        $this->container['idciReasonCode2'] = isset($data['idciReasonCode2']) ? $data['idciReasonCode2'] : null;
        $this->container['idciScore'] = isset($data['idciScore']) ? $data['idciScore'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets accessToken
     * @return string
     */
    public function getAccessToken()
    {
        return $this->container['accessToken'];
    }

    /**
     * Sets accessToken
     * @param string $accessToken JSON Web Token (JWT) used to authenticate the consumer with the authentication provider, such as, CardinalCommerce or Rupay. Note - Max Length of this field is 2048 characters.
     * @return $this
     */
    public function setAccessToken($accessToken)
    {
        $this->container['accessToken'] = $accessToken;

        return $this;
    }

    /**
     * Gets acsRenderingType
     * @return string
     */
    public function getAcsRenderingType()
    {
        return $this->container['acsRenderingType'];
    }

    /**
     * Sets acsRenderingType
     * @param string $acsRenderingType Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK.
     * @return $this
     */
    public function setAcsRenderingType($acsRenderingType)
    {
        $this->container['acsRenderingType'] = $acsRenderingType;

        return $this;
    }

    /**
     * Gets acsTransactionId
     * @return string
     */
    public function getAcsTransactionId()
    {
        return $this->container['acsTransactionId'];
    }

    /**
     * Sets acsTransactionId
     * @param string $acsTransactionId Unique transaction identifier assigned by the ACS to identify a single transaction.
     * @return $this
     */
    public function setAcsTransactionId($acsTransactionId)
    {
        $this->container['acsTransactionId'] = $acsTransactionId;

        return $this;
    }

    /**
     * Gets acsUrl
     * @return string
     */
    public function getAcsUrl()
    {
        return $this->container['acsUrl'];
    }

    /**
     * Sets acsUrl
     * @param string $acsUrl URL for the card-issuing bank's authentication form that you receive when the card is enrolled. The value can be very large.
     * @return $this
     */
    public function setAcsUrl($acsUrl)
    {
        $this->container['acsUrl'] = $acsUrl;

        return $this;
    }

    /**
     * Gets authenticationPath
     * @return string
     */
    public function getAuthenticationPath()
    {
        return $this->container['authenticationPath'];
    }

    /**
     * Sets authenticationPath
     * @param string $authenticationPath Indicates what displays to the customer during the authentication process. This field can contain one of these values: - `ADS`: (Card not enrolled) customer prompted to activate the card during the checkout process. - `ATTEMPTS`: (Attempts processing) Processing briefly displays before the checkout process is completed. - `ENROLLED`: (Card enrolled) the card issuer's authentication window displays. - `UNKNOWN`: Card enrollment status cannot be determined. - `NOREDIRECT`: (Card not enrolled, authentication unavailable, or error occurred) nothing displays to the customer.  The following values can be returned if you are using rules-based payer authentication. - `RIBA`: The card-issuing bank supports risk-based authentication, but whether the cardholder is likely to be challenged cannot be determined. - `RIBA_PASS`: The card-issuing bank supports risk-based authentication and it is likely that the cardholder will not be challenged to provide credentials, also known as _silent authentication_.
     * @return $this
     */
    public function setAuthenticationPath($authenticationPath)
    {
        $this->container['authenticationPath'] = $authenticationPath;

        return $this;
    }

    /**
     * Gets authorizationPayload
     * @return string
     */
    public function getAuthorizationPayload()
    {
        return $this->container['authorizationPayload'];
    }

    /**
     * Sets authorizationPayload
     * @param string $authorizationPayload The Base64 encoded JSON Payload of CB specific Authorization Values returned in the challenge Flow
     * @return $this
     */
    public function setAuthorizationPayload($authorizationPayload)
    {
        $this->container['authorizationPayload'] = $authorizationPayload;

        return $this;
    }

    /**
     * Gets authenticationType
     * @return string
     */
    public function getAuthenticationType()
    {
        return $this->container['authenticationType'];
    }

    /**
     * Sets authenticationType
     * @param string $authenticationType Indicates the type of authentication that will be used to challenge the card holder.  Possible Values:  01 - Static  02 - Dynamic  03 - OOB (Out of Band)  04 - Decoupled  20 - OTP hosted at merchant end. (Rupay S2S flow) **NOTE**:  EMV 3-D Secure version 2.1.0 supports values 01-03.  Version 2.2.0 supports values 01-04.  Decoupled authentication is not supported at this time.
     * @return $this
     */
    public function setAuthenticationType($authenticationType)
    {
        $this->container['authenticationType'] = $authenticationType;

        return $this;
    }

    /**
     * Gets authenticationTransactionId
     * @return string
     */
    public function getAuthenticationTransactionId()
    {
        return $this->container['authenticationTransactionId'];
    }

    /**
     * Sets authenticationTransactionId
     * @param string $authenticationTransactionId Payer authentication transaction identifier is used to link the check enrollment and validate authentication messages. For Rupay, this field should be passed as request only for Resend OTP use case.
     * @return $this
     */
    public function setAuthenticationTransactionId($authenticationTransactionId)
    {
        $this->container['authenticationTransactionId'] = $authenticationTransactionId;

        return $this;
    }

    /**
     * Gets authenticationTransactionContextId
     * @return string
     */
    public function getAuthenticationTransactionContextId()
    {
        return $this->container['authenticationTransactionContextId'];
    }

    /**
     * Sets authenticationTransactionContextId
     * @param string $authenticationTransactionContextId Payer authentication transaction identifier passed to link the validation and authorization calls.
     * @return $this
     */
    public function setAuthenticationTransactionContextId($authenticationTransactionContextId)
    {
        $this->container['authenticationTransactionContextId'] = $authenticationTransactionContextId;

        return $this;
    }

    /**
     * Gets validityPeriod
     * @return int
     */
    public function getValidityPeriod()
    {
        return $this->container['validityPeriod'];
    }

    /**
     * Sets validityPeriod
     * @param int $validityPeriod Describes validity of OTP in minutes for incoming transaction.        .
     * @return $this
     */
    public function setValidityPeriod($validityPeriod)
    {
        $this->container['validityPeriod'] = $validityPeriod;

        return $this;
    }

    /**
     * Gets cardholderMessage
     * @return string
     */
    public function getCardholderMessage()
    {
        return $this->container['cardholderMessage'];
    }

    /**
     * Sets cardholderMessage
     * @param string $cardholderMessage Text provided by the ACS/Issuer to Cardholder during a Frictionless or Decoupled transaction.The Issuer can provide information to Cardholder. For example, \"Additional authentication is needed for this transaction, please contact (Issuer Name) at xxx-xxx-xxxx.\". The Issuing Bank can optionally support this value.
     * @return $this
     */
    public function setCardholderMessage($cardholderMessage)
    {
        $this->container['cardholderMessage'] = $cardholderMessage;

        return $this;
    }

    /**
     * Gets cavv
     * @return string
     */
    public function getCavv()
    {
        return $this->container['cavv'];
    }

    /**
     * Sets cavv
     * @param string $cavv Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor.
     * @return $this
     */
    public function setCavv($cavv)
    {
        $this->container['cavv'] = $cavv;

        return $this;
    }

    /**
     * Gets cavvAlgorithm
     * @return string
     */
    public function getCavvAlgorithm()
    {
        return $this->container['cavvAlgorithm'];
    }

    /**
     * Sets cavvAlgorithm
     * @param string $cavvAlgorithm Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the `cavv_algorithm` request field of the authorization service. This field contains one of these values: - `2`: Visa, American Express, JCB, Diners Club, and Discover - `3`: Mastercard
     * @return $this
     */
    public function setCavvAlgorithm($cavvAlgorithm)
    {
        $this->container['cavvAlgorithm'] = $cavvAlgorithm;

        return $this;
    }

    /**
     * Gets challengeCancelCode
     * @return string
     */
    public function getChallengeCancelCode()
    {
        return $this->container['challengeCancelCode'];
    }

    /**
     * Sets challengeCancelCode
     * @param string $challengeCancelCode An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK
     * @return $this
     */
    public function setChallengeCancelCode($challengeCancelCode)
    {
        $this->container['challengeCancelCode'] = $challengeCancelCode;

        return $this;
    }

    /**
     * Gets challengeRequired
     * @return string
     */
    public function getChallengeRequired()
    {
        return $this->container['challengeRequired'];
    }

    /**
     * Sets challengeRequired
     * @param string $challengeRequired Indicates whether a challenge is required in order to complete authentication. **Note** Regional mandates might determine that a challenge is required.  Possible values: - `Y`: Challenge required - `N`: Challenge not required **Note**  Used by the Hybrid integration.
     * @return $this
     */
    public function setChallengeRequired($challengeRequired)
    {
        $this->container['challengeRequired'] = $challengeRequired;

        return $this;
    }

    /**
     * Gets decoupledAuthenticationIndicator
     * @return string
     */
    public function getDecoupledAuthenticationIndicator()
    {
        return $this->container['decoupledAuthenticationIndicator'];
    }

    /**
     * Sets decoupledAuthenticationIndicator
     * @param string $decoupledAuthenticationIndicator Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N
     * @return $this
     */
    public function setDecoupledAuthenticationIndicator($decoupledAuthenticationIndicator)
    {
        $this->container['decoupledAuthenticationIndicator'] = $decoupledAuthenticationIndicator;

        return $this;
    }

    /**
     * Gets directoryServerErrorCode
     * @return string
     */
    public function getDirectoryServerErrorCode()
    {
        return $this->container['directoryServerErrorCode'];
    }

    /**
     * Sets directoryServerErrorCode
     * @param string $directoryServerErrorCode The directory server error code indicating a problem with this transaction. Note - Max Length of this field is typically 3 characters.
     * @return $this
     */
    public function setDirectoryServerErrorCode($directoryServerErrorCode)
    {
        $this->container['directoryServerErrorCode'] = $directoryServerErrorCode;

        return $this;
    }

    /**
     * Gets directoryServerErrorDescription
     * @return string
     */
    public function getDirectoryServerErrorDescription()
    {
        return $this->container['directoryServerErrorDescription'];
    }

    /**
     * Sets directoryServerErrorDescription
     * @param string $directoryServerErrorDescription Directory server text and additional detail about the error for this transaction.
     * @return $this
     */
    public function setDirectoryServerErrorDescription($directoryServerErrorDescription)
    {
        $this->container['directoryServerErrorDescription'] = $directoryServerErrorDescription;

        return $this;
    }

    /**
     * Gets ecommerceIndicator
     * @return string
     */
    public function getEcommerceIndicator()
    {
        return $this->container['ecommerceIndicator'];
    }

    /**
     * Sets ecommerceIndicator
     * @param string $ecommerceIndicator Commerce indicator for cards not enrolled. This field contains one of these values: - `internet`: Card not enrolled, or card type not supported by payer authentication. No liability shift. - `js_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `js_failure`: J/Secure directory service is not available. No liability shift. - `spa`: Mastercard card not enrolled in the SecureCode program. No liability shift. - `vbv_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `vbv_failure`: For payment processor Barclays, Streamline, AIBMS, or FDC Germany, you receive this result if Visa's directory service is not available. No liability shift.
     * @return $this
     */
    public function setEcommerceIndicator($ecommerceIndicator)
    {
        $this->container['ecommerceIndicator'] = $ecommerceIndicator;

        return $this;
    }

    /**
     * Gets eci
     * @return string
     */
    public function getEci()
    {
        return $this->container['eci'];
    }

    /**
     * Sets eci
     * @param string $eci Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \"Interpreting the Reply,\" page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `06`: The card can be enrolled. Liability shift. - `07`: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `05`: Successful authentication - `06`: Authentication attempted - `07`: Failed authentication (No response from the merchant because of a problem.)
     * @return $this
     */
    public function setEci($eci)
    {
        $this->container['eci'] = $eci;

        return $this;
    }

    /**
     * Gets eciRaw
     * @return string
     */
    public function getEciRaw()
    {
        return $this->container['eciRaw'];
    }

    /**
     * Sets eciRaw
     * @param string $eciRaw ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of `eci` or `ucafCollectionIndicator`.  This field can contain one of these values: - `01`: Authentication attempted (Mastercard) - `02`: Successful authentication (Mastercard) - `05`: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - `06`: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover)
     * @return $this
     */
    public function setEciRaw($eciRaw)
    {
        $this->container['eciRaw'] = $eciRaw;

        return $this;
    }

    /**
     * Gets effectiveAuthenticationType
     * @return string
     */
    public function getEffectiveAuthenticationType()
    {
        return $this->container['effectiveAuthenticationType'];
    }

    /**
     * Sets effectiveAuthenticationType
     * @param string $effectiveAuthenticationType This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer).
     * @return $this
     */
    public function setEffectiveAuthenticationType($effectiveAuthenticationType)
    {
        $this->container['effectiveAuthenticationType'] = $effectiveAuthenticationType;

        return $this;
    }

    /**
     * Gets exemptionDataRaw
     * @return string
     */
    public function getExemptionDataRaw()
    {
        return $this->container['exemptionDataRaw'];
    }

    /**
     * Sets exemptionDataRaw
     * @param string $exemptionDataRaw Payer authentication exemption indicator for Carte Bancaire exemptions.  This is used with unbundled authentication and authorizations calls, for example: \"low fraud merchant program\". The value returned in this field should be passed in the authorization request under the field - `consumerAuthenticationInformation.strongAuthentication.issuerInformation.exemptionDataRaw`.
     * @return $this
     */
    public function setExemptionDataRaw($exemptionDataRaw)
    {
        $this->container['exemptionDataRaw'] = $exemptionDataRaw;

        return $this;
    }

    /**
     * Gets ivr
     * @return \CyberSource\Model\PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr
     */
    public function getIvr()
    {
        return $this->container['ivr'];
    }

    /**
     * Sets ivr
     * @param \CyberSource\Model\PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr $ivr
     * @return $this
     */
    public function setIvr($ivr)
    {
        $this->container['ivr'] = $ivr;

        return $this;
    }

    /**
     * Gets networkScore
     * @return string
     */
    public function getNetworkScore()
    {
        return $this->container['networkScore'];
    }

    /**
     * Sets networkScore
     * @param string $networkScore The global score calculated by the CB scoring platform and returned to merchants.
     * @return $this
     */
    public function setNetworkScore($networkScore)
    {
        $this->container['networkScore'] = $networkScore;

        return $this;
    }

    /**
     * Gets pareq
     * @return string
     */
    public function getPareq()
    {
        return $this->container['pareq'];
    }

    /**
     * Sets pareq
     * @param string $pareq Payer authentication request (PAReq) message that you need to forward to the ACS. The value can be very large. The value is in base64.
     * @return $this
     */
    public function setPareq($pareq)
    {
        $this->container['pareq'] = $pareq;

        return $this;
    }

    /**
     * Gets paresStatus
     * @return string
     */
    public function getParesStatus()
    {
        return $this->container['paresStatus'];
    }

    /**
     * Sets paresStatus
     * @param string $paresStatus Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - `A`: Proof of authentication attempt was generated. - `N`: Customer failed or canceled authentication. Transaction denied. - `U`: Authentication not completed regardless of the reason. - `Y`: Customer was successfully authenticated.
     * @return $this
     */
    public function setParesStatus($paresStatus)
    {
        $this->container['paresStatus'] = $paresStatus;

        return $this;
    }

    /**
     * Gets proofXml
     * @return string
     */
    public function getProofXml()
    {
        return $this->container['proofXml'];
    }

    /**
     * Sets proofXml
     * @param string $proofXml Date and time of the enrollment check combined with the VEReq and VERes elements. If you ever need to show proof of enrollment checking, you may need to parse the string for the information required by the payment card company. The value can be very large.  For cards issued in the U.S. or Canada, Visa may require this data for specific merchant category codes.For cards not issued in the U.S. or Canada, your bank may require this data as proof of enrollment checking for any payer authentication transaction that you re-present because of a chargeback.
     * @return $this
     */
    public function setProofXml($proofXml)
    {
        $this->container['proofXml'] = $proofXml;

        return $this;
    }

    /**
     * Gets proxyPan
     * @return string
     */
    public function getProxyPan()
    {
        return $this->container['proxyPan'];
    }

    /**
     * Sets proxyPan
     * @param string $proxyPan Encrypted version of the card number used in the payer authentication request message.
     * @return $this
     */
    public function setProxyPan($proxyPan)
    {
        $this->container['proxyPan'] = $proxyPan;

        return $this;
    }

    /**
     * Gets sdkTransactionId
     * @return string
     */
    public function getSdkTransactionId()
    {
        return $this->container['sdkTransactionId'];
    }

    /**
     * Sets sdkTransactionId
     * @param string $sdkTransactionId SDK unique transaction identifier that is generated on each new transaction.
     * @return $this
     */
    public function setSdkTransactionId($sdkTransactionId)
    {
        $this->container['sdkTransactionId'] = $sdkTransactionId;

        return $this;
    }

    /**
     * Gets signedParesStatusReason
     * @return string
     */
    public function getSignedParesStatusReason()
    {
        return $this->container['signedParesStatusReason'];
    }

    /**
     * Sets signedParesStatusReason
     * @param string $signedParesStatusReason Provides additional information as to why the PAResStatus has a specific value.
     * @return $this
     */
    public function setSignedParesStatusReason($signedParesStatusReason)
    {
        $this->container['signedParesStatusReason'] = $signedParesStatusReason;

        return $this;
    }

    /**
     * Gets specificationVersion
     * @return string
     */
    public function getSpecificationVersion()
    {
        return $this->container['specificationVersion'];
    }

    /**
     * Sets specificationVersion
     * @param string $specificationVersion This field contains the 3D Secure version that was used to process the transaction. For example: 2.2.0
     * @return $this
     */
    public function setSpecificationVersion($specificationVersion)
    {
        $this->container['specificationVersion'] = $specificationVersion;

        return $this;
    }

    /**
     * Gets stepUpUrl
     * @return string
     */
    public function getStepUpUrl()
    {
        return $this->container['stepUpUrl'];
    }

    /**
     * Sets stepUpUrl
     * @param string $stepUpUrl The fully qualified URL that the merchant uses to post a form to the cardholder in order to complete the Consumer Authentication transaction for the Cardinal Cruise API integration.
     * @return $this
     */
    public function setStepUpUrl($stepUpUrl)
    {
        $this->container['stepUpUrl'] = $stepUpUrl;

        return $this;
    }

    /**
     * Gets threeDSServerTransactionId
     * @return string
     */
    public function getThreeDSServerTransactionId()
    {
        return $this->container['threeDSServerTransactionId'];
    }

    /**
     * Sets threeDSServerTransactionId
     * @param string $threeDSServerTransactionId Unique transaction identifier assigned by the 3DS Server to identify a single transaction.
     * @return $this
     */
    public function setThreeDSServerTransactionId($threeDSServerTransactionId)
    {
        $this->container['threeDSServerTransactionId'] = $threeDSServerTransactionId;

        return $this;
    }

    /**
     * Gets ucafAuthenticationData
     * @return string
     */
    public function getUcafAuthenticationData()
    {
        return $this->container['ucafAuthenticationData'];
    }

    /**
     * Sets ucafAuthenticationData
     * @param string $ucafAuthenticationData AAV is a unique identifier generated by the card-issuing bank for Mastercard Identity Check transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request.
     * @return $this
     */
    public function setUcafAuthenticationData($ucafAuthenticationData)
    {
        $this->container['ucafAuthenticationData'] = $ucafAuthenticationData;

        return $this;
    }

    /**
     * Gets ucafCollectionIndicator
     * @return string
     */
    public function getUcafCollectionIndicator()
    {
        return $this->container['ucafCollectionIndicator'];
    }

    /**
     * Sets ucafCollectionIndicator
     * @param string $ucafCollectionIndicator For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard Identity Check transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - `0`: Authentication data not collected, and customer authentication was not completed. - `1`: Authentication data not collected because customer authentication was not completed. - `2`: Authentication data collected because customer completed authentication.
     * @return $this
     */
    public function setUcafCollectionIndicator($ucafCollectionIndicator)
    {
        $this->container['ucafCollectionIndicator'] = $ucafCollectionIndicator;

        return $this;
    }

    /**
     * Gets veresEnrolled
     * @return string
     */
    public function getVeresEnrolled()
    {
        return $this->container['veresEnrolled'];
    }

    /**
     * Sets veresEnrolled
     * @param string $veresEnrolled Result of the enrollment check. This field can contain one of these values: - `Y`: Card enrolled or can be enrolled; you must authenticate. Liability shift. - `N`: Card not enrolled; proceed with authorization. Liability shift. - `U`: Unable to authenticate regardless of the reason. No liability shift.  **Note** This field only applies to the Asia, Middle East, and Africa Gateway. If you are configured for this processor, you must send the value of this field in your authorization request.  The following value can be returned if you are using rules-based Payer Authentication: - `B`: Indicates that authentication was bypassed.
     * @return $this
     */
    public function setVeresEnrolled($veresEnrolled)
    {
        $this->container['veresEnrolled'] = $veresEnrolled;

        return $this;
    }

    /**
     * Gets whiteListStatusSource
     * @return string
     */
    public function getWhiteListStatusSource()
    {
        return $this->container['whiteListStatusSource'];
    }

    /**
     * Sets whiteListStatusSource
     * @param string $whiteListStatusSource This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS
     * @return $this
     */
    public function setWhiteListStatusSource($whiteListStatusSource)
    {
        $this->container['whiteListStatusSource'] = $whiteListStatusSource;

        return $this;
    }

    /**
     * Gets xid
     * @return string
     */
    public function getXid()
    {
        return $this->container['xid'];
    }

    /**
     * Sets xid
     * @param string $xid Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**`=spa`)
     * @return $this
     */
    public function setXid($xid)
    {
        $this->container['xid'] = $xid;

        return $this;
    }

    /**
     * Gets directoryServerTransactionId
     * @return string
     */
    public function getDirectoryServerTransactionId()
    {
        return $this->container['directoryServerTransactionId'];
    }

    /**
     * Sets directoryServerTransactionId
     * @param string $directoryServerTransactionId The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID
     * @return $this
     */
    public function setDirectoryServerTransactionId($directoryServerTransactionId)
    {
        $this->container['directoryServerTransactionId'] = $directoryServerTransactionId;

        return $this;
    }

    /**
     * Gets acsOperatorID
     * @return string
     */
    public function getAcsOperatorID()
    {
        return $this->container['acsOperatorID'];
    }

    /**
     * Sets acsOperatorID
     * @param string $acsOperatorID Directory Server assigned ACS identifier.
     * @return $this
     */
    public function setAcsOperatorID($acsOperatorID)
    {
        $this->container['acsOperatorID'] = $acsOperatorID;

        return $this;
    }

    /**
     * Gets acsReferenceNumber
     * @return string
     */
    public function getAcsReferenceNumber()
    {
        return $this->container['acsReferenceNumber'];
    }

    /**
     * Sets acsReferenceNumber
     * @param string $acsReferenceNumber Unique identifier assigned by the EMVCo Secretariat upon Testing and Approval.
     * @return $this
     */
    public function setAcsReferenceNumber($acsReferenceNumber)
    {
        $this->container['acsReferenceNumber'] = $acsReferenceNumber;

        return $this;
    }

    /**
     * Gets idciDecision
     * @return string
     */
    public function getIdciDecision()
    {
        return $this->container['idciDecision'];
    }

    /**
     * Sets idciDecision
     * @param string $idciDecision Decision on the Risk Assessment from Mastercard.
     * @return $this
     */
    public function setIdciDecision($idciDecision)
    {
        $this->container['idciDecision'] = $idciDecision;

        return $this;
    }

    /**
     * Gets idciReasonCode1
     * @return string
     */
    public function getIdciReasonCode1()
    {
        return $this->container['idciReasonCode1'];
    }

    /**
     * Sets idciReasonCode1
     * @param string $idciReasonCode1 ReasonCode from Mastercard
     * @return $this
     */
    public function setIdciReasonCode1($idciReasonCode1)
    {
        $this->container['idciReasonCode1'] = $idciReasonCode1;

        return $this;
    }

    /**
     * Gets idciReasonCode2
     * @return string
     */
    public function getIdciReasonCode2()
    {
        return $this->container['idciReasonCode2'];
    }

    /**
     * Sets idciReasonCode2
     * @param string $idciReasonCode2 ReasonCode from Mastercard
     * @return $this
     */
    public function setIdciReasonCode2($idciReasonCode2)
    {
        $this->container['idciReasonCode2'] = $idciReasonCode2;

        return $this;
    }

    /**
     * Gets idciScore
     * @return int
     */
    public function getIdciScore()
    {
        return $this->container['idciScore'];
    }

    /**
     * Sets idciScore
     * @param int $idciScore Risk Assessment from Mastercard
     * @return $this
     */
    public function setIdciScore($idciScore)
    {
        $this->container['idciScore'] = $idciScore;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


