<?php
/**
 * PushFunds201ResponseProcessorInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * PushFunds201ResponseProcessorInformation Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PushFunds201ResponseProcessorInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'pushFunds201Response_processorInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'transactionId' => 'int',
        'responseCode' => 'string',
        'systemTraceAuditNumber' => 'string',
        'retrievalReferenceNumber' => 'string',
        'actionCode' => 'string',
        'approvalCode' => 'string',
        'feeProgramIndicator' => 'string',
        'name' => 'string',
        'routing' => '\CyberSource\Model\PushFunds201ResponseProcessorInformationRouting',
        'settlement' => '\CyberSource\Model\PushFunds201ResponseProcessorInformationSettlement'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'transactionId' => null,
        'responseCode' => null,
        'systemTraceAuditNumber' => null,
        'retrievalReferenceNumber' => null,
        'actionCode' => null,
        'approvalCode' => null,
        'feeProgramIndicator' => null,
        'name' => null,
        'routing' => null,
        'settlement' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'transactionId' => 'transactionId',
        'responseCode' => 'responseCode',
        'systemTraceAuditNumber' => 'systemTraceAuditNumber',
        'retrievalReferenceNumber' => 'retrievalReferenceNumber',
        'actionCode' => 'actionCode',
        'approvalCode' => 'approvalCode',
        'feeProgramIndicator' => 'feeProgramIndicator',
        'name' => 'name',
        'routing' => 'routing',
        'settlement' => 'settlement'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'transactionId' => 'setTransactionId',
        'responseCode' => 'setResponseCode',
        'systemTraceAuditNumber' => 'setSystemTraceAuditNumber',
        'retrievalReferenceNumber' => 'setRetrievalReferenceNumber',
        'actionCode' => 'setActionCode',
        'approvalCode' => 'setApprovalCode',
        'feeProgramIndicator' => 'setFeeProgramIndicator',
        'name' => 'setName',
        'routing' => 'setRouting',
        'settlement' => 'setSettlement'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'transactionId' => 'getTransactionId',
        'responseCode' => 'getResponseCode',
        'systemTraceAuditNumber' => 'getSystemTraceAuditNumber',
        'retrievalReferenceNumber' => 'getRetrievalReferenceNumber',
        'actionCode' => 'getActionCode',
        'approvalCode' => 'getApprovalCode',
        'feeProgramIndicator' => 'getFeeProgramIndicator',
        'name' => 'getName',
        'routing' => 'getRouting',
        'settlement' => 'getSettlement'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['transactionId'] = isset($data['transactionId']) ? $data['transactionId'] : null;
        $this->container['responseCode'] = isset($data['responseCode']) ? $data['responseCode'] : null;
        $this->container['systemTraceAuditNumber'] = isset($data['systemTraceAuditNumber']) ? $data['systemTraceAuditNumber'] : null;
        $this->container['retrievalReferenceNumber'] = isset($data['retrievalReferenceNumber']) ? $data['retrievalReferenceNumber'] : null;
        $this->container['actionCode'] = isset($data['actionCode']) ? $data['actionCode'] : null;
        $this->container['approvalCode'] = isset($data['approvalCode']) ? $data['approvalCode'] : null;
        $this->container['feeProgramIndicator'] = isset($data['feeProgramIndicator']) ? $data['feeProgramIndicator'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['routing'] = isset($data['routing']) ? $data['routing'] : null;
        $this->container['settlement'] = isset($data['settlement']) ? $data['settlement'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets transactionId
     * @return int
     */
    public function getTransactionId()
    {
        return $this->container['transactionId'];
    }

    /**
     * Sets transactionId
     * @param int $transactionId Network transaction identifier (TID). This value can be used to identify a specific transaction when you are discussing the transaction with your processor.
     * @return $this
     */
    public function setTransactionId($transactionId)
    {
        $this->container['transactionId'] = $transactionId;

        return $this;
    }

    /**
     * Gets responseCode
     * @return string
     */
    public function getResponseCode()
    {
        return $this->container['responseCode'];
    }

    /**
     * Sets responseCode
     * @param string $responseCode Transaction status from the processor.
     * @return $this
     */
    public function setResponseCode($responseCode)
    {
        $this->container['responseCode'] = $responseCode;

        return $this;
    }

    /**
     * Gets systemTraceAuditNumber
     * @return string
     */
    public function getSystemTraceAuditNumber()
    {
        return $this->container['systemTraceAuditNumber'];
    }

    /**
     * Sets systemTraceAuditNumber
     * @param string $systemTraceAuditNumber This field is returned by authorization and incremental authorization services. System trace number that must be printed on the customer's receipt.
     * @return $this
     */
    public function setSystemTraceAuditNumber($systemTraceAuditNumber)
    {
        $this->container['systemTraceAuditNumber'] = $systemTraceAuditNumber;

        return $this;
    }

    /**
     * Gets retrievalReferenceNumber
     * @return string
     */
    public function getRetrievalReferenceNumber()
    {
        return $this->container['retrievalReferenceNumber'];
    }

    /**
     * Sets retrievalReferenceNumber
     * @param string $retrievalReferenceNumber This field contains a number that is used with other data elements as a key to identify and track all messages related to a given cardholder transaction; that is, to a given transaction set.  Recommended format: ydddhhnnnnnn  Positions 1-4: The yddd equivalent of the date, where y = 0-9 and ddd = 001 – 366. Positions 5-12: A unique identification number generated by the merchant or assigned by Cybersource.
     * @return $this
     */
    public function setRetrievalReferenceNumber($retrievalReferenceNumber)
    {
        $this->container['retrievalReferenceNumber'] = $retrievalReferenceNumber;

        return $this;
    }

    /**
     * Gets actionCode
     * @return string
     */
    public function getActionCode()
    {
        return $this->container['actionCode'];
    }

    /**
     * Sets actionCode
     * @param string $actionCode The results of the transaction request  Note: The VisaNet Response Code for the transaction
     * @return $this
     */
    public function setActionCode($actionCode)
    {
        $this->container['actionCode'] = $actionCode;

        return $this;
    }

    /**
     * Gets approvalCode
     * @return string
     */
    public function getApprovalCode()
    {
        return $this->container['approvalCode'];
    }

    /**
     * Sets approvalCode
     * @param string $approvalCode Issuer-generated approval code for the transaction.
     * @return $this
     */
    public function setApprovalCode($approvalCode)
    {
        $this->container['approvalCode'] = $approvalCode;

        return $this;
    }

    /**
     * Gets feeProgramIndicator
     * @return string
     */
    public function getFeeProgramIndicator()
    {
        return $this->container['feeProgramIndicator'];
    }

    /**
     * Sets feeProgramIndicator
     * @param string $feeProgramIndicator This field identifies the interchange fee program applicable to each financial transaction. Fee program indicator (FPI) values correspond to the fee descriptor and rate for each existing fee program.
     * @return $this
     */
    public function setFeeProgramIndicator($feeProgramIndicator)
    {
        $this->container['feeProgramIndicator'] = $feeProgramIndicator;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name Name of the processor.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets routing
     * @return \CyberSource\Model\PushFunds201ResponseProcessorInformationRouting
     */
    public function getRouting()
    {
        return $this->container['routing'];
    }

    /**
     * Sets routing
     * @param \CyberSource\Model\PushFunds201ResponseProcessorInformationRouting $routing
     * @return $this
     */
    public function setRouting($routing)
    {
        $this->container['routing'] = $routing;

        return $this;
    }

    /**
     * Gets settlement
     * @return \CyberSource\Model\PushFunds201ResponseProcessorInformationSettlement
     */
    public function getSettlement()
    {
        return $this->container['settlement'];
    }

    /**
     * Sets settlement
     * @param \CyberSource\Model\PushFunds201ResponseProcessorInformationSettlement $settlement
     * @return $this
     */
    public function setSettlement($settlement)
    {
        $this->container['settlement'] = $settlement;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


