<?php
/**
 * Ptsv2paymentsInstallmentInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Ptsv2paymentsInstallmentInformation Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Ptsv2paymentsInstallmentInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ptsv2payments_installmentInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'amount' => 'string',
        'frequency' => 'string',
        'planType' => 'string',
        'sequence' => 'int',
        'totalAmount' => 'string',
        'totalCount' => 'int',
        'firstInstallmentDate' => 'string',
        'invoiceData' => 'string',
        'paymentType' => 'string',
        'eligibilityInquiry' => 'string',
        'gracePeriodDuration' => 'string',
        'gracePeriodDurationType' => 'string',
        'firstInstallmentAmount' => 'string',
        'validationIndicator' => 'string',
        'identifier' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'amount' => null,
        'frequency' => null,
        'planType' => null,
        'sequence' => null,
        'totalAmount' => null,
        'totalCount' => null,
        'firstInstallmentDate' => null,
        'invoiceData' => null,
        'paymentType' => null,
        'eligibilityInquiry' => null,
        'gracePeriodDuration' => null,
        'gracePeriodDurationType' => null,
        'firstInstallmentAmount' => null,
        'validationIndicator' => null,
        'identifier' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'amount' => 'amount',
        'frequency' => 'frequency',
        'planType' => 'planType',
        'sequence' => 'sequence',
        'totalAmount' => 'totalAmount',
        'totalCount' => 'totalCount',
        'firstInstallmentDate' => 'firstInstallmentDate',
        'invoiceData' => 'invoiceData',
        'paymentType' => 'paymentType',
        'eligibilityInquiry' => 'eligibilityInquiry',
        'gracePeriodDuration' => 'gracePeriodDuration',
        'gracePeriodDurationType' => 'gracePeriodDurationType',
        'firstInstallmentAmount' => 'firstInstallmentAmount',
        'validationIndicator' => 'validationIndicator',
        'identifier' => 'identifier'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'amount' => 'setAmount',
        'frequency' => 'setFrequency',
        'planType' => 'setPlanType',
        'sequence' => 'setSequence',
        'totalAmount' => 'setTotalAmount',
        'totalCount' => 'setTotalCount',
        'firstInstallmentDate' => 'setFirstInstallmentDate',
        'invoiceData' => 'setInvoiceData',
        'paymentType' => 'setPaymentType',
        'eligibilityInquiry' => 'setEligibilityInquiry',
        'gracePeriodDuration' => 'setGracePeriodDuration',
        'gracePeriodDurationType' => 'setGracePeriodDurationType',
        'firstInstallmentAmount' => 'setFirstInstallmentAmount',
        'validationIndicator' => 'setValidationIndicator',
        'identifier' => 'setIdentifier'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'amount' => 'getAmount',
        'frequency' => 'getFrequency',
        'planType' => 'getPlanType',
        'sequence' => 'getSequence',
        'totalAmount' => 'getTotalAmount',
        'totalCount' => 'getTotalCount',
        'firstInstallmentDate' => 'getFirstInstallmentDate',
        'invoiceData' => 'getInvoiceData',
        'paymentType' => 'getPaymentType',
        'eligibilityInquiry' => 'getEligibilityInquiry',
        'gracePeriodDuration' => 'getGracePeriodDuration',
        'gracePeriodDurationType' => 'getGracePeriodDurationType',
        'firstInstallmentAmount' => 'getFirstInstallmentAmount',
        'validationIndicator' => 'getValidationIndicator',
        'identifier' => 'getIdentifier'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['amount'] = isset($data['amount']) ? $data['amount'] : null;
        $this->container['frequency'] = isset($data['frequency']) ? $data['frequency'] : null;
        $this->container['planType'] = isset($data['planType']) ? $data['planType'] : null;
        $this->container['sequence'] = isset($data['sequence']) ? $data['sequence'] : null;
        $this->container['totalAmount'] = isset($data['totalAmount']) ? $data['totalAmount'] : null;
        $this->container['totalCount'] = isset($data['totalCount']) ? $data['totalCount'] : null;
        $this->container['firstInstallmentDate'] = isset($data['firstInstallmentDate']) ? $data['firstInstallmentDate'] : null;
        $this->container['invoiceData'] = isset($data['invoiceData']) ? $data['invoiceData'] : null;
        $this->container['paymentType'] = isset($data['paymentType']) ? $data['paymentType'] : null;
        $this->container['eligibilityInquiry'] = isset($data['eligibilityInquiry']) ? $data['eligibilityInquiry'] : null;
        $this->container['gracePeriodDuration'] = isset($data['gracePeriodDuration']) ? $data['gracePeriodDuration'] : null;
        $this->container['gracePeriodDurationType'] = isset($data['gracePeriodDurationType']) ? $data['gracePeriodDurationType'] : null;
        $this->container['firstInstallmentAmount'] = isset($data['firstInstallmentAmount']) ? $data['firstInstallmentAmount'] : null;
        $this->container['validationIndicator'] = isset($data['validationIndicator']) ? $data['validationIndicator'] : null;
        $this->container['identifier'] = isset($data['identifier']) ? $data['identifier'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets amount
     * @return string
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     * @param string $amount Amount for the current installment payment.  This field is supported only for CyberSource through VisaNet.
     * @return $this
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets frequency
     * @return string
     */
    public function getFrequency()
    {
        return $this->container['frequency'];
    }

    /**
     * Sets frequency
     * @param string $frequency Frequency of the installment payments. When you do not include this field in a request for a Crediario installment payment, CyberSource sends a space character to the processor.  This field is supported only for CyberSource through VisaNet. Possible values: - `B`: Biweekly - `M`: Monthly - `W`: Weekly  For Crediario installment payments, the value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR9 - Position: 41 - Field: Installment Frequency
     * @return $this
     */
    public function setFrequency($frequency)
    {
        $this->container['frequency'] = $frequency;

        return $this;
    }

    /**
     * Gets planType
     * @return string
     */
    public function getPlanType()
    {
        return $this->container['planType'];
    }

    /**
     * Sets planType
     * @param string $planType #### American Express Direct, Cielo, and CyberSource Latin American Processing Flag that indicates the type of funding for the installment plan associated with the payment.  Possible values: - `1`: Merchant-funded installment plan - `2`: Issuer-funded installment plan If you do not include this field in the request, CyberSource uses the value in your CyberSource account.  To change the value in your CyberSource account, contact CyberSource Customer Service.  #### CyberSource through VisaNet and American Express Defined code that indicates the type of installment plan for this transaction.  Contact American Express for: - Information about the kinds of installment plans that American Express provides - Values for this field  For installment payments with American Express in Brazil, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP07 TCR3 - Position: 5-6 - Field: Plan Type  * The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment card companies.  #### CyberSource through VisaNet with Visa or Mastercard Flag indicating the type of funding for the installment plan associated with the payment. Possible values: - 1 or 01: Merchant-funded installment plan - 2 or 02: Issuer-funded installment plan - 43: Crediario installment plan—only with Visa in Brazil  For installment payments with Visa in Brazil, the value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP07 TCR1 - Position: 5-6 - Field: Installment Type  For all other kinds of installment payments, the value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR5 - Position: 39-40 - Field: Installment Plan Type (Issuer or Merchant)
     * @return $this
     */
    public function setPlanType($planType)
    {
        $this->container['planType'] = $planType;

        return $this;
    }

    /**
     * Gets sequence
     * @return int
     */
    public function getSequence()
    {
        return $this->container['sequence'];
    }

    /**
     * Sets sequence
     * @param int $sequence Installment number when making payments in installments. Used along with `totalCount` to track which payment is being processed.  For example, the second of 5 payments would be passed to CyberSource as `sequence` = 2 and `totalCount` = 5.  #### Chase Paymentech Solutions and FDC Compass This field is optional because this value is required in the merchant descriptors.  #### CyberSource through VisaNet When you do not include this field in a request for a Crediario installment payment, CyberSource sends a value of 0 to the processor.  For Crediario installment payments, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP01 TCR9 - Position: 38-40 - Field: Installment Payment Number  * The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment card companies.
     * @return $this
     */
    public function setSequence($sequence)
    {
        $this->container['sequence'] = $sequence;

        return $this;
    }

    /**
     * Gets totalAmount
     * @return string
     */
    public function getTotalAmount()
    {
        return $this->container['totalAmount'];
    }

    /**
     * Sets totalAmount
     * @param string $totalAmount Total amount of the loan that is being paid in installments. This field is supported only for CyberSource through VisaNet.
     * @return $this
     */
    public function setTotalAmount($totalAmount)
    {
        $this->container['totalAmount'] = $totalAmount;

        return $this;
    }

    /**
     * Gets totalCount
     * @return int
     */
    public function getTotalCount()
    {
        return $this->container['totalCount'];
    }

    /**
     * Sets totalCount
     * @param int $totalCount Total number of installments when making payments in installments.  #### Chase Paymentech Solutions and FDC Compass This field is optional because this value is required in the merchant descriptors.  #### American Express Direct, Cielo, and Comercio Latino This value is the total number of installments you approved.  #### CyberSource Latin American Processing in Brazil This value is the total number of installments that you approved. The default is 1.  #### All Other Processors This value is used along with _sequence_ to track which payment is being processed.  For example, the second of 5 payments would be passed to CyberSource as _sequence_ = 2 and _totalCount_ = 5.  #### CyberSource through VisaNet For Crediario installment payments, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP01 TCR9 - Position: 23-25 - Field: Number of Installments  For installment payments with American Express in Brazil, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP07 TCR3 - Position: 7-8 - Field: Number of Installments  For installment payments with Visa in Brazil, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP07 TCR1 - Position: 7-8 - Field: Number of Installments  For all other kinds of installment payments, the value for this field corresponds to the following data in the TC 33 capture file*: - Record: CP01 TCR5 - Position: 20-22 - Field: Installment Total Count  **Note** The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment card companies.
     * @return $this
     */
    public function setTotalCount($totalCount)
    {
        $this->container['totalCount'] = $totalCount;

        return $this;
    }

    /**
     * Gets firstInstallmentDate
     * @return string
     */
    public function getFirstInstallmentDate()
    {
        return $this->container['firstInstallmentDate'];
    }

    /**
     * Sets firstInstallmentDate
     * @param string $firstInstallmentDate Date of the first installment payment. Format: YYMMDD. When you do not include this field, CyberSource sends a string of six zeros (000000) to the processor.  This field is supported only for Crediario installment payments in Brazil on CyberSource through VisaNet.  The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR9 - Position: 42-47 - Field: Date of First Installment
     * @return $this
     */
    public function setFirstInstallmentDate($firstInstallmentDate)
    {
        $this->container['firstInstallmentDate'] = $firstInstallmentDate;

        return $this;
    }

    /**
     * Gets invoiceData
     * @return string
     */
    public function getInvoiceData()
    {
        return $this->container['invoiceData'];
    }

    /**
     * Sets invoiceData
     * @param string $invoiceData Invoice information that you want to provide to the issuer. This value is similar to a tracking number and is the same for all installment payments for one purchase.  This field is supported only for installment payments with Mastercard on CyberSource through VisaNet in Brazil.  The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP07 TCR4 - Position: 51-70 - Field: Purchase Identification
     * @return $this
     */
    public function setInvoiceData($invoiceData)
    {
        $this->container['invoiceData'] = $invoiceData;

        return $this;
    }

    /**
     * Gets paymentType
     * @return string
     */
    public function getPaymentType()
    {
        return $this->container['paymentType'];
    }

    /**
     * Sets paymentType
     * @param string $paymentType Payment plan for the installments. This field is supported only for installment payments on Visa Platform Connect, RuPay and SPG-KSA seamless flow.  Possible values for a standing-instruction (SI) merchant-initiated transaction (MIT) with Diners Club or Mastercard in India or with an India-issued card: - 1: SI with a fixed amount. - 2: SI with a maximum amount. - 3: Other kind of SI.  Possible values for a type of Installment transaction for on-soil transaction in Kingdom of Saudi Arabia - 1: Registration or first transaction. - 2: Subsequent transaction.  Possible values for other kinds of installment payments: - 0 (default): Regular installment. This value is not allowed for airline transactions. - 1: Installment payment with down payment. - 2: Installment payment without down payment. This value is supported only for airline transactions. - 3: Installment payment; down payment and boarding fee will follow. This value is supported only for airline transactions. - 4: Down payment only; regular installment payment will follow. - 5: Boarding fee only. This value is supported only for airline transactions. - 6: SI de-registration on RuPay for the payer authentication seamless flow.
     * @return $this
     */
    public function setPaymentType($paymentType)
    {
        $this->container['paymentType'] = $paymentType;

        return $this;
    }

    /**
     * Gets eligibilityInquiry
     * @return string
     */
    public function getEligibilityInquiry()
    {
        return $this->container['eligibilityInquiry'];
    }

    /**
     * Sets eligibilityInquiry
     * @param string $eligibilityInquiry Indicates whether the authorization request is a Crediario eligibility inquiry.  Set the value for this field to `Crediario`.  This field is supported only for Crediario installment payments in Brazil on CyberSource through VisaNet.
     * @return $this
     */
    public function setEligibilityInquiry($eligibilityInquiry)
    {
        $this->container['eligibilityInquiry'] = $eligibilityInquiry;

        return $this;
    }

    /**
     * Gets gracePeriodDuration
     * @return string
     */
    public function getGracePeriodDuration()
    {
        return $this->container['gracePeriodDuration'];
    }

    /**
     * Sets gracePeriodDuration
     * @param string $gracePeriodDuration Grace period requested by the customer before the first installment payment is due.  When you include this field in a request, you must also include the grace period duration type field.  The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR5, Position: 100-101, Field: Mastercard Grace Period Details.  This field is supported only for Mastercard installment payments in Brazil and Greece.
     * @return $this
     */
    public function setGracePeriodDuration($gracePeriodDuration)
    {
        $this->container['gracePeriodDuration'] = $gracePeriodDuration;

        return $this;
    }

    /**
     * Gets gracePeriodDurationType
     * @return string
     */
    public function getGracePeriodDurationType()
    {
        return $this->container['gracePeriodDurationType'];
    }

    /**
     * Sets gracePeriodDurationType
     * @param string $gracePeriodDurationType Unit for the requested grace period duration.  Possible values: - `D`: Days - `W`: Weeks - `M`: Months  The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR5, Position: 99, Field: Mastercard Grace Period Details  This field is supported only for Mastercard installment payments in Brazil and Greece on CyberSource through VisaNet.
     * @return $this
     */
    public function setGracePeriodDurationType($gracePeriodDurationType)
    {
        $this->container['gracePeriodDurationType'] = $gracePeriodDurationType;

        return $this;
    }

    /**
     * Gets firstInstallmentAmount
     * @return string
     */
    public function getFirstInstallmentAmount()
    {
        return $this->container['firstInstallmentAmount'];
    }

    /**
     * Sets firstInstallmentAmount
     * @param string $firstInstallmentAmount Amount of the first installment payment. The issuer provides this value when the first installment payment is successful. This field is supported for Mastercard installment payments on CyberSource through VisaNet in all countries except Brazil,Croatia, Georgia, and Greece. The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR5 - Position: 23-34 - Field: Amount of Each Installment
     * @return $this
     */
    public function setFirstInstallmentAmount($firstInstallmentAmount)
    {
        $this->container['firstInstallmentAmount'] = $firstInstallmentAmount;

        return $this;
    }

    /**
     * Gets validationIndicator
     * @return string
     */
    public function getValidationIndicator()
    {
        return $this->container['validationIndicator'];
    }

    /**
     * Sets validationIndicator
     * @param string $validationIndicator Standing Instruction/Installment validation indicator. - '1': Prevalidated - '2': Not Validated
     * @return $this
     */
    public function setValidationIndicator($validationIndicator)
    {
        $this->container['validationIndicator'] = $validationIndicator;

        return $this;
    }

    /**
     * Gets identifier
     * @return string
     */
    public function getIdentifier()
    {
        return $this->container['identifier'];
    }

    /**
     * Sets identifier
     * @param string $identifier Standing Instruction/Installment identifier.
     * @return $this
     */
    public function setIdentifier($identifier)
    {
        $this->container['identifier'] = $identifier;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


