<?php
/**
 * Ptsv2paymentsConsumerAuthenticationInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Ptsv2paymentsConsumerAuthenticationInformation Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Ptsv2paymentsConsumerAuthenticationInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ptsv2payments_consumerAuthenticationInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'cavv' => 'string',
        'transactionFlowIndicator' => 'string',
        'cavvAlgorithm' => 'string',
        'eciRaw' => 'string',
        'paresStatus' => 'string',
        'veresEnrolled' => 'string',
        'xid' => 'string',
        'ucafCollectionIndicator' => 'string',
        'ucafAuthenticationData' => 'string',
        'strongAuthentication' => '\CyberSource\Model\Ptsv2paymentsConsumerAuthenticationInformationStrongAuthentication',
        'directoryServerTransactionId' => 'string',
        'paSpecificationVersion' => 'string',
        'authenticationType' => 'string',
        'responseAccessToken' => 'string',
        'acsTransactionId' => 'string',
        'acsWindowSize' => 'string',
        'alternateAuthenticationData' => 'string',
        'alternateAuthenticationDate' => 'string',
        'alternateAuthenticationMethod' => 'string',
        'authenticationDate' => 'string',
        'authenticationTransactionId' => 'string',
        'challengeCancelCode' => 'string',
        'challengeCode' => 'string',
        'challengeStatus' => 'string',
        'customerCardAlias' => 'string',
        'decoupledAuthenticationIndicator' => 'string',
        'decoupledAuthenticationMaxTime' => 'string',
        'defaultCard' => 'bool',
        'deviceChannel' => 'string',
        'installmentTotalCount' => 'int',
        'merchantFraudRate' => 'string',
        'marketingOptIn' => 'bool',
        'marketingSource' => 'string',
        'mcc' => 'string',
        'merchantScore' => 'int',
        'messageCategory' => 'string',
        'networkScore' => 'string',
        'npaCode' => 'string',
        'overridePaymentMethod' => 'string',
        'overrideCountryCode' => 'string',
        'priorAuthenticationData' => 'string',
        'priorAuthenticationMethod' => 'string',
        'priorAuthenticationReferenceId' => 'string',
        'priorAuthenticationTime' => 'string',
        'productCode' => 'string',
        'returnUrl' => 'string',
        'requestorId' => 'string',
        'requestorInitiatedAuthenticationIndicator' => 'string',
        'requestorName' => 'string',
        'referenceId' => 'string',
        'sdkMaxTimeout' => 'string',
        'secureCorporatePaymentIndicator' => 'string',
        'transactionMode' => 'string',
        'whiteListStatus' => 'string',
        'authenticationBrand' => 'string',
        'effectiveAuthenticationType' => 'string',
        'signedParesStatusReason' => 'string',
        'signedPares' => 'string',
        'acsReferenceNumber' => 'string',
        'dsReferenceNumber' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'cavv' => null,
        'transactionFlowIndicator' => null,
        'cavvAlgorithm' => null,
        'eciRaw' => null,
        'paresStatus' => null,
        'veresEnrolled' => null,
        'xid' => null,
        'ucafCollectionIndicator' => null,
        'ucafAuthenticationData' => null,
        'strongAuthentication' => null,
        'directoryServerTransactionId' => null,
        'paSpecificationVersion' => null,
        'authenticationType' => null,
        'responseAccessToken' => null,
        'acsTransactionId' => null,
        'acsWindowSize' => null,
        'alternateAuthenticationData' => null,
        'alternateAuthenticationDate' => null,
        'alternateAuthenticationMethod' => null,
        'authenticationDate' => null,
        'authenticationTransactionId' => null,
        'challengeCancelCode' => null,
        'challengeCode' => null,
        'challengeStatus' => null,
        'customerCardAlias' => null,
        'decoupledAuthenticationIndicator' => null,
        'decoupledAuthenticationMaxTime' => null,
        'defaultCard' => null,
        'deviceChannel' => null,
        'installmentTotalCount' => null,
        'merchantFraudRate' => null,
        'marketingOptIn' => null,
        'marketingSource' => null,
        'mcc' => null,
        'merchantScore' => null,
        'messageCategory' => null,
        'networkScore' => null,
        'npaCode' => null,
        'overridePaymentMethod' => null,
        'overrideCountryCode' => null,
        'priorAuthenticationData' => null,
        'priorAuthenticationMethod' => null,
        'priorAuthenticationReferenceId' => null,
        'priorAuthenticationTime' => null,
        'productCode' => null,
        'returnUrl' => null,
        'requestorId' => null,
        'requestorInitiatedAuthenticationIndicator' => null,
        'requestorName' => null,
        'referenceId' => null,
        'sdkMaxTimeout' => null,
        'secureCorporatePaymentIndicator' => null,
        'transactionMode' => null,
        'whiteListStatus' => null,
        'authenticationBrand' => null,
        'effectiveAuthenticationType' => null,
        'signedParesStatusReason' => null,
        'signedPares' => null,
        'acsReferenceNumber' => null,
        'dsReferenceNumber' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'cavv' => 'cavv',
        'transactionFlowIndicator' => 'transactionFlowIndicator',
        'cavvAlgorithm' => 'cavvAlgorithm',
        'eciRaw' => 'eciRaw',
        'paresStatus' => 'paresStatus',
        'veresEnrolled' => 'veresEnrolled',
        'xid' => 'xid',
        'ucafCollectionIndicator' => 'ucafCollectionIndicator',
        'ucafAuthenticationData' => 'ucafAuthenticationData',
        'strongAuthentication' => 'strongAuthentication',
        'directoryServerTransactionId' => 'directoryServerTransactionId',
        'paSpecificationVersion' => 'paSpecificationVersion',
        'authenticationType' => 'authenticationType',
        'responseAccessToken' => 'responseAccessToken',
        'acsTransactionId' => 'acsTransactionId',
        'acsWindowSize' => 'acsWindowSize',
        'alternateAuthenticationData' => 'alternateAuthenticationData',
        'alternateAuthenticationDate' => 'alternateAuthenticationDate',
        'alternateAuthenticationMethod' => 'alternateAuthenticationMethod',
        'authenticationDate' => 'authenticationDate',
        'authenticationTransactionId' => 'authenticationTransactionId',
        'challengeCancelCode' => 'challengeCancelCode',
        'challengeCode' => 'challengeCode',
        'challengeStatus' => 'challengeStatus',
        'customerCardAlias' => 'customerCardAlias',
        'decoupledAuthenticationIndicator' => 'decoupledAuthenticationIndicator',
        'decoupledAuthenticationMaxTime' => 'decoupledAuthenticationMaxTime',
        'defaultCard' => 'defaultCard',
        'deviceChannel' => 'deviceChannel',
        'installmentTotalCount' => 'installmentTotalCount',
        'merchantFraudRate' => 'merchantFraudRate',
        'marketingOptIn' => 'marketingOptIn',
        'marketingSource' => 'marketingSource',
        'mcc' => 'mcc',
        'merchantScore' => 'merchantScore',
        'messageCategory' => 'messageCategory',
        'networkScore' => 'networkScore',
        'npaCode' => 'npaCode',
        'overridePaymentMethod' => 'overridePaymentMethod',
        'overrideCountryCode' => 'overrideCountryCode',
        'priorAuthenticationData' => 'priorAuthenticationData',
        'priorAuthenticationMethod' => 'priorAuthenticationMethod',
        'priorAuthenticationReferenceId' => 'priorAuthenticationReferenceId',
        'priorAuthenticationTime' => 'priorAuthenticationTime',
        'productCode' => 'productCode',
        'returnUrl' => 'returnUrl',
        'requestorId' => 'requestorId',
        'requestorInitiatedAuthenticationIndicator' => 'requestorInitiatedAuthenticationIndicator',
        'requestorName' => 'requestorName',
        'referenceId' => 'referenceId',
        'sdkMaxTimeout' => 'sdkMaxTimeout',
        'secureCorporatePaymentIndicator' => 'secureCorporatePaymentIndicator',
        'transactionMode' => 'transactionMode',
        'whiteListStatus' => 'whiteListStatus',
        'authenticationBrand' => 'authenticationBrand',
        'effectiveAuthenticationType' => 'effectiveAuthenticationType',
        'signedParesStatusReason' => 'signedParesStatusReason',
        'signedPares' => 'signedPares',
        'acsReferenceNumber' => 'acsReferenceNumber',
        'dsReferenceNumber' => 'dsReferenceNumber'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'cavv' => 'setCavv',
        'transactionFlowIndicator' => 'setTransactionFlowIndicator',
        'cavvAlgorithm' => 'setCavvAlgorithm',
        'eciRaw' => 'setEciRaw',
        'paresStatus' => 'setParesStatus',
        'veresEnrolled' => 'setVeresEnrolled',
        'xid' => 'setXid',
        'ucafCollectionIndicator' => 'setUcafCollectionIndicator',
        'ucafAuthenticationData' => 'setUcafAuthenticationData',
        'strongAuthentication' => 'setStrongAuthentication',
        'directoryServerTransactionId' => 'setDirectoryServerTransactionId',
        'paSpecificationVersion' => 'setPaSpecificationVersion',
        'authenticationType' => 'setAuthenticationType',
        'responseAccessToken' => 'setResponseAccessToken',
        'acsTransactionId' => 'setAcsTransactionId',
        'acsWindowSize' => 'setAcsWindowSize',
        'alternateAuthenticationData' => 'setAlternateAuthenticationData',
        'alternateAuthenticationDate' => 'setAlternateAuthenticationDate',
        'alternateAuthenticationMethod' => 'setAlternateAuthenticationMethod',
        'authenticationDate' => 'setAuthenticationDate',
        'authenticationTransactionId' => 'setAuthenticationTransactionId',
        'challengeCancelCode' => 'setChallengeCancelCode',
        'challengeCode' => 'setChallengeCode',
        'challengeStatus' => 'setChallengeStatus',
        'customerCardAlias' => 'setCustomerCardAlias',
        'decoupledAuthenticationIndicator' => 'setDecoupledAuthenticationIndicator',
        'decoupledAuthenticationMaxTime' => 'setDecoupledAuthenticationMaxTime',
        'defaultCard' => 'setDefaultCard',
        'deviceChannel' => 'setDeviceChannel',
        'installmentTotalCount' => 'setInstallmentTotalCount',
        'merchantFraudRate' => 'setMerchantFraudRate',
        'marketingOptIn' => 'setMarketingOptIn',
        'marketingSource' => 'setMarketingSource',
        'mcc' => 'setMcc',
        'merchantScore' => 'setMerchantScore',
        'messageCategory' => 'setMessageCategory',
        'networkScore' => 'setNetworkScore',
        'npaCode' => 'setNpaCode',
        'overridePaymentMethod' => 'setOverridePaymentMethod',
        'overrideCountryCode' => 'setOverrideCountryCode',
        'priorAuthenticationData' => 'setPriorAuthenticationData',
        'priorAuthenticationMethod' => 'setPriorAuthenticationMethod',
        'priorAuthenticationReferenceId' => 'setPriorAuthenticationReferenceId',
        'priorAuthenticationTime' => 'setPriorAuthenticationTime',
        'productCode' => 'setProductCode',
        'returnUrl' => 'setReturnUrl',
        'requestorId' => 'setRequestorId',
        'requestorInitiatedAuthenticationIndicator' => 'setRequestorInitiatedAuthenticationIndicator',
        'requestorName' => 'setRequestorName',
        'referenceId' => 'setReferenceId',
        'sdkMaxTimeout' => 'setSdkMaxTimeout',
        'secureCorporatePaymentIndicator' => 'setSecureCorporatePaymentIndicator',
        'transactionMode' => 'setTransactionMode',
        'whiteListStatus' => 'setWhiteListStatus',
        'authenticationBrand' => 'setAuthenticationBrand',
        'effectiveAuthenticationType' => 'setEffectiveAuthenticationType',
        'signedParesStatusReason' => 'setSignedParesStatusReason',
        'signedPares' => 'setSignedPares',
        'acsReferenceNumber' => 'setAcsReferenceNumber',
        'dsReferenceNumber' => 'setDsReferenceNumber'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'cavv' => 'getCavv',
        'transactionFlowIndicator' => 'getTransactionFlowIndicator',
        'cavvAlgorithm' => 'getCavvAlgorithm',
        'eciRaw' => 'getEciRaw',
        'paresStatus' => 'getParesStatus',
        'veresEnrolled' => 'getVeresEnrolled',
        'xid' => 'getXid',
        'ucafCollectionIndicator' => 'getUcafCollectionIndicator',
        'ucafAuthenticationData' => 'getUcafAuthenticationData',
        'strongAuthentication' => 'getStrongAuthentication',
        'directoryServerTransactionId' => 'getDirectoryServerTransactionId',
        'paSpecificationVersion' => 'getPaSpecificationVersion',
        'authenticationType' => 'getAuthenticationType',
        'responseAccessToken' => 'getResponseAccessToken',
        'acsTransactionId' => 'getAcsTransactionId',
        'acsWindowSize' => 'getAcsWindowSize',
        'alternateAuthenticationData' => 'getAlternateAuthenticationData',
        'alternateAuthenticationDate' => 'getAlternateAuthenticationDate',
        'alternateAuthenticationMethod' => 'getAlternateAuthenticationMethod',
        'authenticationDate' => 'getAuthenticationDate',
        'authenticationTransactionId' => 'getAuthenticationTransactionId',
        'challengeCancelCode' => 'getChallengeCancelCode',
        'challengeCode' => 'getChallengeCode',
        'challengeStatus' => 'getChallengeStatus',
        'customerCardAlias' => 'getCustomerCardAlias',
        'decoupledAuthenticationIndicator' => 'getDecoupledAuthenticationIndicator',
        'decoupledAuthenticationMaxTime' => 'getDecoupledAuthenticationMaxTime',
        'defaultCard' => 'getDefaultCard',
        'deviceChannel' => 'getDeviceChannel',
        'installmentTotalCount' => 'getInstallmentTotalCount',
        'merchantFraudRate' => 'getMerchantFraudRate',
        'marketingOptIn' => 'getMarketingOptIn',
        'marketingSource' => 'getMarketingSource',
        'mcc' => 'getMcc',
        'merchantScore' => 'getMerchantScore',
        'messageCategory' => 'getMessageCategory',
        'networkScore' => 'getNetworkScore',
        'npaCode' => 'getNpaCode',
        'overridePaymentMethod' => 'getOverridePaymentMethod',
        'overrideCountryCode' => 'getOverrideCountryCode',
        'priorAuthenticationData' => 'getPriorAuthenticationData',
        'priorAuthenticationMethod' => 'getPriorAuthenticationMethod',
        'priorAuthenticationReferenceId' => 'getPriorAuthenticationReferenceId',
        'priorAuthenticationTime' => 'getPriorAuthenticationTime',
        'productCode' => 'getProductCode',
        'returnUrl' => 'getReturnUrl',
        'requestorId' => 'getRequestorId',
        'requestorInitiatedAuthenticationIndicator' => 'getRequestorInitiatedAuthenticationIndicator',
        'requestorName' => 'getRequestorName',
        'referenceId' => 'getReferenceId',
        'sdkMaxTimeout' => 'getSdkMaxTimeout',
        'secureCorporatePaymentIndicator' => 'getSecureCorporatePaymentIndicator',
        'transactionMode' => 'getTransactionMode',
        'whiteListStatus' => 'getWhiteListStatus',
        'authenticationBrand' => 'getAuthenticationBrand',
        'effectiveAuthenticationType' => 'getEffectiveAuthenticationType',
        'signedParesStatusReason' => 'getSignedParesStatusReason',
        'signedPares' => 'getSignedPares',
        'acsReferenceNumber' => 'getAcsReferenceNumber',
        'dsReferenceNumber' => 'getDsReferenceNumber'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['cavv'] = isset($data['cavv']) ? $data['cavv'] : null;
        $this->container['transactionFlowIndicator'] = isset($data['transactionFlowIndicator']) ? $data['transactionFlowIndicator'] : null;
        $this->container['cavvAlgorithm'] = isset($data['cavvAlgorithm']) ? $data['cavvAlgorithm'] : null;
        $this->container['eciRaw'] = isset($data['eciRaw']) ? $data['eciRaw'] : null;
        $this->container['paresStatus'] = isset($data['paresStatus']) ? $data['paresStatus'] : null;
        $this->container['veresEnrolled'] = isset($data['veresEnrolled']) ? $data['veresEnrolled'] : null;
        $this->container['xid'] = isset($data['xid']) ? $data['xid'] : null;
        $this->container['ucafCollectionIndicator'] = isset($data['ucafCollectionIndicator']) ? $data['ucafCollectionIndicator'] : null;
        $this->container['ucafAuthenticationData'] = isset($data['ucafAuthenticationData']) ? $data['ucafAuthenticationData'] : null;
        $this->container['strongAuthentication'] = isset($data['strongAuthentication']) ? $data['strongAuthentication'] : null;
        $this->container['directoryServerTransactionId'] = isset($data['directoryServerTransactionId']) ? $data['directoryServerTransactionId'] : null;
        $this->container['paSpecificationVersion'] = isset($data['paSpecificationVersion']) ? $data['paSpecificationVersion'] : null;
        $this->container['authenticationType'] = isset($data['authenticationType']) ? $data['authenticationType'] : null;
        $this->container['responseAccessToken'] = isset($data['responseAccessToken']) ? $data['responseAccessToken'] : null;
        $this->container['acsTransactionId'] = isset($data['acsTransactionId']) ? $data['acsTransactionId'] : null;
        $this->container['acsWindowSize'] = isset($data['acsWindowSize']) ? $data['acsWindowSize'] : null;
        $this->container['alternateAuthenticationData'] = isset($data['alternateAuthenticationData']) ? $data['alternateAuthenticationData'] : null;
        $this->container['alternateAuthenticationDate'] = isset($data['alternateAuthenticationDate']) ? $data['alternateAuthenticationDate'] : null;
        $this->container['alternateAuthenticationMethod'] = isset($data['alternateAuthenticationMethod']) ? $data['alternateAuthenticationMethod'] : null;
        $this->container['authenticationDate'] = isset($data['authenticationDate']) ? $data['authenticationDate'] : null;
        $this->container['authenticationTransactionId'] = isset($data['authenticationTransactionId']) ? $data['authenticationTransactionId'] : null;
        $this->container['challengeCancelCode'] = isset($data['challengeCancelCode']) ? $data['challengeCancelCode'] : null;
        $this->container['challengeCode'] = isset($data['challengeCode']) ? $data['challengeCode'] : null;
        $this->container['challengeStatus'] = isset($data['challengeStatus']) ? $data['challengeStatus'] : null;
        $this->container['customerCardAlias'] = isset($data['customerCardAlias']) ? $data['customerCardAlias'] : null;
        $this->container['decoupledAuthenticationIndicator'] = isset($data['decoupledAuthenticationIndicator']) ? $data['decoupledAuthenticationIndicator'] : null;
        $this->container['decoupledAuthenticationMaxTime'] = isset($data['decoupledAuthenticationMaxTime']) ? $data['decoupledAuthenticationMaxTime'] : null;
        $this->container['defaultCard'] = isset($data['defaultCard']) ? $data['defaultCard'] : null;
        $this->container['deviceChannel'] = isset($data['deviceChannel']) ? $data['deviceChannel'] : null;
        $this->container['installmentTotalCount'] = isset($data['installmentTotalCount']) ? $data['installmentTotalCount'] : null;
        $this->container['merchantFraudRate'] = isset($data['merchantFraudRate']) ? $data['merchantFraudRate'] : null;
        $this->container['marketingOptIn'] = isset($data['marketingOptIn']) ? $data['marketingOptIn'] : null;
        $this->container['marketingSource'] = isset($data['marketingSource']) ? $data['marketingSource'] : null;
        $this->container['mcc'] = isset($data['mcc']) ? $data['mcc'] : null;
        $this->container['merchantScore'] = isset($data['merchantScore']) ? $data['merchantScore'] : null;
        $this->container['messageCategory'] = isset($data['messageCategory']) ? $data['messageCategory'] : null;
        $this->container['networkScore'] = isset($data['networkScore']) ? $data['networkScore'] : null;
        $this->container['npaCode'] = isset($data['npaCode']) ? $data['npaCode'] : null;
        $this->container['overridePaymentMethod'] = isset($data['overridePaymentMethod']) ? $data['overridePaymentMethod'] : null;
        $this->container['overrideCountryCode'] = isset($data['overrideCountryCode']) ? $data['overrideCountryCode'] : null;
        $this->container['priorAuthenticationData'] = isset($data['priorAuthenticationData']) ? $data['priorAuthenticationData'] : null;
        $this->container['priorAuthenticationMethod'] = isset($data['priorAuthenticationMethod']) ? $data['priorAuthenticationMethod'] : null;
        $this->container['priorAuthenticationReferenceId'] = isset($data['priorAuthenticationReferenceId']) ? $data['priorAuthenticationReferenceId'] : null;
        $this->container['priorAuthenticationTime'] = isset($data['priorAuthenticationTime']) ? $data['priorAuthenticationTime'] : null;
        $this->container['productCode'] = isset($data['productCode']) ? $data['productCode'] : null;
        $this->container['returnUrl'] = isset($data['returnUrl']) ? $data['returnUrl'] : null;
        $this->container['requestorId'] = isset($data['requestorId']) ? $data['requestorId'] : null;
        $this->container['requestorInitiatedAuthenticationIndicator'] = isset($data['requestorInitiatedAuthenticationIndicator']) ? $data['requestorInitiatedAuthenticationIndicator'] : null;
        $this->container['requestorName'] = isset($data['requestorName']) ? $data['requestorName'] : null;
        $this->container['referenceId'] = isset($data['referenceId']) ? $data['referenceId'] : null;
        $this->container['sdkMaxTimeout'] = isset($data['sdkMaxTimeout']) ? $data['sdkMaxTimeout'] : null;
        $this->container['secureCorporatePaymentIndicator'] = isset($data['secureCorporatePaymentIndicator']) ? $data['secureCorporatePaymentIndicator'] : null;
        $this->container['transactionMode'] = isset($data['transactionMode']) ? $data['transactionMode'] : null;
        $this->container['whiteListStatus'] = isset($data['whiteListStatus']) ? $data['whiteListStatus'] : null;
        $this->container['authenticationBrand'] = isset($data['authenticationBrand']) ? $data['authenticationBrand'] : null;
        $this->container['effectiveAuthenticationType'] = isset($data['effectiveAuthenticationType']) ? $data['effectiveAuthenticationType'] : null;
        $this->container['signedParesStatusReason'] = isset($data['signedParesStatusReason']) ? $data['signedParesStatusReason'] : null;
        $this->container['signedPares'] = isset($data['signedPares']) ? $data['signedPares'] : null;
        $this->container['acsReferenceNumber'] = isset($data['acsReferenceNumber']) ? $data['acsReferenceNumber'] : null;
        $this->container['dsReferenceNumber'] = isset($data['dsReferenceNumber']) ? $data['dsReferenceNumber'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets cavv
     * @return string
     */
    public function getCavv()
    {
        return $this->container['cavv'];
    }

    /**
     * Sets cavv
     * @param string $cavv Cardholder authentication verification value (CAVV).
     * @return $this
     */
    public function setCavv($cavv)
    {
        $this->container['cavv'] = $cavv;

        return $this;
    }

    /**
     * Gets transactionFlowIndicator
     * @return string
     */
    public function getTransactionFlowIndicator()
    {
        return $this->container['transactionFlowIndicator'];
    }

    /**
     * Sets transactionFlowIndicator
     * @param string $transactionFlowIndicator This field details out the type of transaction. Below are the possible values. 08:GC- Guest Checkout.
     * @return $this
     */
    public function setTransactionFlowIndicator($transactionFlowIndicator)
    {
        $this->container['transactionFlowIndicator'] = $transactionFlowIndicator;

        return $this;
    }

    /**
     * Gets cavvAlgorithm
     * @return string
     */
    public function getCavvAlgorithm()
    {
        return $this->container['cavvAlgorithm'];
    }

    /**
     * Sets cavvAlgorithm
     * @param string $cavvAlgorithm Algorithm used to generate the CAVV for Visa Secure or the UCAF authentication data for Mastercard Identity Check.
     * @return $this
     */
    public function setCavvAlgorithm($cavvAlgorithm)
    {
        $this->container['cavvAlgorithm'] = $cavvAlgorithm;

        return $this;
    }

    /**
     * Gets eciRaw
     * @return string
     */
    public function getEciRaw()
    {
        return $this->container['eciRaw'];
    }

    /**
     * Sets eciRaw
     * @param string $eciRaw Raw electronic commerce indicator (ECI).
     * @return $this
     */
    public function setEciRaw($eciRaw)
    {
        $this->container['eciRaw'] = $eciRaw;

        return $this;
    }

    /**
     * Gets paresStatus
     * @return string
     */
    public function getParesStatus()
    {
        return $this->container['paresStatus'];
    }

    /**
     * Sets paresStatus
     * @param string $paresStatus Payer authentication response status.
     * @return $this
     */
    public function setParesStatus($paresStatus)
    {
        $this->container['paresStatus'] = $paresStatus;

        return $this;
    }

    /**
     * Gets veresEnrolled
     * @return string
     */
    public function getVeresEnrolled()
    {
        return $this->container['veresEnrolled'];
    }

    /**
     * Sets veresEnrolled
     * @param string $veresEnrolled Verification response enrollment status.
     * @return $this
     */
    public function setVeresEnrolled($veresEnrolled)
    {
        $this->container['veresEnrolled'] = $veresEnrolled;

        return $this;
    }

    /**
     * Gets xid
     * @return string
     */
    public function getXid()
    {
        return $this->container['xid'];
    }

    /**
     * Sets xid
     * @param string $xid Transaction identifier.
     * @return $this
     */
    public function setXid($xid)
    {
        $this->container['xid'] = $xid;

        return $this;
    }

    /**
     * Gets ucafCollectionIndicator
     * @return string
     */
    public function getUcafCollectionIndicator()
    {
        return $this->container['ucafCollectionIndicator'];
    }

    /**
     * Sets ucafCollectionIndicator
     * @param string $ucafCollectionIndicator Universal cardholder authentication field (UCAF) collection indicator.  #### CyberSource through VisaNet The value for this field corresponds to the following data in the TC 33 capture file5: - Record: CP01 TCR7 - Position: 5 - Field: Mastercard Electronic Commerce Indicators—UCAF Collection Indicator
     * @return $this
     */
    public function setUcafCollectionIndicator($ucafCollectionIndicator)
    {
        $this->container['ucafCollectionIndicator'] = $ucafCollectionIndicator;

        return $this;
    }

    /**
     * Gets ucafAuthenticationData
     * @return string
     */
    public function getUcafAuthenticationData()
    {
        return $this->container['ucafAuthenticationData'];
    }

    /**
     * Sets ucafAuthenticationData
     * @param string $ucafAuthenticationData Universal cardholder authentication field (UCAF) data.
     * @return $this
     */
    public function setUcafAuthenticationData($ucafAuthenticationData)
    {
        $this->container['ucafAuthenticationData'] = $ucafAuthenticationData;

        return $this;
    }

    /**
     * Gets strongAuthentication
     * @return \CyberSource\Model\Ptsv2paymentsConsumerAuthenticationInformationStrongAuthentication
     */
    public function getStrongAuthentication()
    {
        return $this->container['strongAuthentication'];
    }

    /**
     * Sets strongAuthentication
     * @param \CyberSource\Model\Ptsv2paymentsConsumerAuthenticationInformationStrongAuthentication $strongAuthentication
     * @return $this
     */
    public function setStrongAuthentication($strongAuthentication)
    {
        $this->container['strongAuthentication'] = $strongAuthentication;

        return $this;
    }

    /**
     * Gets directoryServerTransactionId
     * @return string
     */
    public function getDirectoryServerTransactionId()
    {
        return $this->container['directoryServerTransactionId'];
    }

    /**
     * Sets directoryServerTransactionId
     * @param string $directoryServerTransactionId The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3:  Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID
     * @return $this
     */
    public function setDirectoryServerTransactionId($directoryServerTransactionId)
    {
        $this->container['directoryServerTransactionId'] = $directoryServerTransactionId;

        return $this;
    }

    /**
     * Gets paSpecificationVersion
     * @return string
     */
    public function getPaSpecificationVersion()
    {
        return $this->container['paSpecificationVersion'];
    }

    /**
     * Sets paSpecificationVersion
     * @param string $paSpecificationVersion This field contains 3DS version that was used for Secured Consumer Authentication (SCA).  The value for this field should be in the format major.minor.patch version.  Valid Values are:  - `2.1.0` (EMV 3D Secure Version 2.1) - `2.2.0` (EMV 3D Secure Version 2.2) - `2.3.0` (EMV 3D Secure Version 2.3) - `2.4.0` (EMV 3D Secure Version 2.4) - `2.5.0` (EMV 3D Secure Version 2.5) - `2.6.0` (EMV 3D Secure Version 2.6) - `2.7.0` (EMV 3D Secure Version 2.7) - `2.8.0` (EMV 3D Secure Version 2.8) - `2.9.0` (EMV 3D Secure Version 2.9)  For Visa Platform Connect:         The value for this field corresponds to the following data in the TC 33 capture file3:  Record: CP01 TCR7, Position: 113 , Field: MC AVV Verification—Program Protocol  It will contain one of the following values: - `1` (3D Secure Version 1.x (3DS 1.0)) - `2` (EMV 3-D Secure (3DS 2.x))
     * @return $this
     */
    public function setPaSpecificationVersion($paSpecificationVersion)
    {
        $this->container['paSpecificationVersion'] = $paSpecificationVersion;

        return $this;
    }

    /**
     * Gets authenticationType
     * @return string
     */
    public function getAuthenticationType()
    {
        return $this->container['authenticationType'];
    }

    /**
     * Sets authenticationType
     * @param string $authenticationType Indicates the type of authentication that will be used to challenge the card holder.  Possible Values:  01 - Static  02 - Dynamic  03 - OOB (Out of Band)  04 - Decoupled  20 - OTP hosted at merchant end. (Rupay S2S flow) **NOTE**:  EMV 3-D Secure version 2.1.0 supports values 01-03.  Version 2.2.0 supports values 01-04.  Decoupled authentication is not supported at this time.
     * @return $this
     */
    public function setAuthenticationType($authenticationType)
    {
        $this->container['authenticationType'] = $authenticationType;

        return $this;
    }

    /**
     * Gets responseAccessToken
     * @return string
     */
    public function getResponseAccessToken()
    {
        return $this->container['responseAccessToken'];
    }

    /**
     * Sets responseAccessToken
     * @param string $responseAccessToken JWT returned by the 3D Secure provider when the authentication is complete. Required for Hybrid integration if you use the Cybersource-generated access token. Note: Max. length of this field is 2048 characters.
     * @return $this
     */
    public function setResponseAccessToken($responseAccessToken)
    {
        $this->container['responseAccessToken'] = $responseAccessToken;

        return $this;
    }

    /**
     * Gets acsTransactionId
     * @return string
     */
    public function getAcsTransactionId()
    {
        return $this->container['acsTransactionId'];
    }

    /**
     * Sets acsTransactionId
     * @param string $acsTransactionId Unique transaction identifier assigned by the ACS to identify a single transaction.  This field is supported for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC.
     * @return $this
     */
    public function setAcsTransactionId($acsTransactionId)
    {
        $this->container['acsTransactionId'] = $acsTransactionId;

        return $this;
    }

    /**
     * Gets acsWindowSize
     * @return string
     */
    public function getAcsWindowSize()
    {
        return $this->container['acsWindowSize'];
    }

    /**
     * Sets acsWindowSize
     * @param string $acsWindowSize An override field that a merchant can pass in to set the challenge window size to display to the end cardholder.  The ACS (Active Control Server) will reply with content that is formatted appropriately to this window size to allow for the best user experience.  The sizes are width x height in pixels of the window displayed in the cardholder browser window.  01 - 250x400  02 - 390x400  03 - 500x600  04 - 600x400  05 - Full page
     * @return $this
     */
    public function setAcsWindowSize($acsWindowSize)
    {
        $this->container['acsWindowSize'] = $acsWindowSize;

        return $this;
    }

    /**
     * Gets alternateAuthenticationData
     * @return string
     */
    public function getAlternateAuthenticationData()
    {
        return $this->container['alternateAuthenticationData'];
    }

    /**
     * Sets alternateAuthenticationData
     * @param string $alternateAuthenticationData Data that documents and supports a specific authentication process.
     * @return $this
     */
    public function setAlternateAuthenticationData($alternateAuthenticationData)
    {
        $this->container['alternateAuthenticationData'] = $alternateAuthenticationData;

        return $this;
    }

    /**
     * Gets alternateAuthenticationDate
     * @return string
     */
    public function getAlternateAuthenticationDate()
    {
        return $this->container['alternateAuthenticationDate'];
    }

    /**
     * Sets alternateAuthenticationDate
     * @param string $alternateAuthenticationDate Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM
     * @return $this
     */
    public function setAlternateAuthenticationDate($alternateAuthenticationDate)
    {
        $this->container['alternateAuthenticationDate'] = $alternateAuthenticationDate;

        return $this;
    }

    /**
     * Gets alternateAuthenticationMethod
     * @return string
     */
    public function getAlternateAuthenticationMethod()
    {
        return $this->container['alternateAuthenticationMethod'];
    }

    /**
     * Sets alternateAuthenticationMethod
     * @param string $alternateAuthenticationMethod Mechanism used by the cardholder to authenticate to the 3D Secure requestor. Possible values: - `01`: No authentication occurred - `02`: Login using merchant system credentials - `03`: Login using Federated ID - `04`: Login using issuer credentials - `05`: Login using third-party authenticator - `06`: Login using FIDO Authenticator
     * @return $this
     */
    public function setAlternateAuthenticationMethod($alternateAuthenticationMethod)
    {
        $this->container['alternateAuthenticationMethod'] = $alternateAuthenticationMethod;

        return $this;
    }

    /**
     * Gets authenticationDate
     * @return string
     */
    public function getAuthenticationDate()
    {
        return $this->container['authenticationDate'];
    }

    /**
     * Sets authenticationDate
     * @param string $authenticationDate The date/time of the authentication at the 3DS servers. RISK update authorization service in auth request payload with value returned in `consumerAuthenticationInformation.alternateAuthenticationData` if merchant calls via CYBS or field can be provided by merchant in authorization request if calling an external 3DS provider.  This field is supported for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC. Format: YYYYMMDDHHMMSS
     * @return $this
     */
    public function setAuthenticationDate($authenticationDate)
    {
        $this->container['authenticationDate'] = $authenticationDate;

        return $this;
    }

    /**
     * Gets authenticationTransactionId
     * @return string
     */
    public function getAuthenticationTransactionId()
    {
        return $this->container['authenticationTransactionId'];
    }

    /**
     * Sets authenticationTransactionId
     * @param string $authenticationTransactionId Payer authentication transaction identifier passed to link the check enrollment and validate authentication messages.For Rupay,this is passed only in Re-Send OTP usecase. **Note**: Required for Standard integration, Rupay Seamless server to server integration for enroll service. Required for Hybrid integration for validate service.
     * @return $this
     */
    public function setAuthenticationTransactionId($authenticationTransactionId)
    {
        $this->container['authenticationTransactionId'] = $authenticationTransactionId;

        return $this;
    }

    /**
     * Gets challengeCancelCode
     * @return string
     */
    public function getChallengeCancelCode()
    {
        return $this->container['challengeCancelCode'];
    }

    /**
     * Sets challengeCancelCode
     * @param string $challengeCancelCode An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK
     * @return $this
     */
    public function setChallengeCancelCode($challengeCancelCode)
    {
        $this->container['challengeCancelCode'] = $challengeCancelCode;

        return $this;
    }

    /**
     * Gets challengeCode
     * @return string
     */
    public function getChallengeCode()
    {
        return $this->container['challengeCode'];
    }

    /**
     * Sets challengeCode
     * @param string $challengeCode Possible values: - `01`: No preference - `02`: No challenge request - `03`: Challenge requested (3D Secure requestor preference) - `04`: Challenge requested (mandate) - `05`: No challenge requested (transactional risk analysis is already performed) - `06`: No challenge requested (Data share only) - `07`: No challenge requested (strong consumer authentication is already performed) - `08`: No challenge requested (utilize whitelist exemption if no challenge required) - `09`: Challenge requested (whitelist prompt requested if challenge required) **Note** This field will default to `01` on merchant configuration and can be overridden by the merchant. EMV 3D Secure version 2.1.0 supports values `01-04`. Version 2.2.0 supports values `01-09`.
     * @return $this
     */
    public function setChallengeCode($challengeCode)
    {
        $this->container['challengeCode'] = $challengeCode;

        return $this;
    }

    /**
     * Gets challengeStatus
     * @return string
     */
    public function getChallengeStatus()
    {
        return $this->container['challengeStatus'];
    }

    /**
     * Sets challengeStatus
     * @param string $challengeStatus The `consumerAuthenticationInformation.challengeCode` indicates the authentication type/level, or challenge, that was presented to the cardholder at checkout by the merchant when calling the Carte Bancaire 3DS servers via CYBS RISK services. It conveys to the issuer the alternative authentication methods that the consumer used.
     * @return $this
     */
    public function setChallengeStatus($challengeStatus)
    {
        $this->container['challengeStatus'] = $challengeStatus;

        return $this;
    }

    /**
     * Gets customerCardAlias
     * @return string
     */
    public function getCustomerCardAlias()
    {
        return $this->container['customerCardAlias'];
    }

    /**
     * Sets customerCardAlias
     * @param string $customerCardAlias An alias that uniquely identifies the customer's account and credit card on file. Note This field is required if Tokenization is enabled in the merchant profile settings.
     * @return $this
     */
    public function setCustomerCardAlias($customerCardAlias)
    {
        $this->container['customerCardAlias'] = $customerCardAlias;

        return $this;
    }

    /**
     * Gets decoupledAuthenticationIndicator
     * @return string
     */
    public function getDecoupledAuthenticationIndicator()
    {
        return $this->container['decoupledAuthenticationIndicator'];
    }

    /**
     * Sets decoupledAuthenticationIndicator
     * @param string $decoupledAuthenticationIndicator Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N
     * @return $this
     */
    public function setDecoupledAuthenticationIndicator($decoupledAuthenticationIndicator)
    {
        $this->container['decoupledAuthenticationIndicator'] = $decoupledAuthenticationIndicator;

        return $this;
    }

    /**
     * Gets decoupledAuthenticationMaxTime
     * @return string
     */
    public function getDecoupledAuthenticationMaxTime()
    {
        return $this->container['decoupledAuthenticationMaxTime'];
    }

    /**
     * Sets decoupledAuthenticationMaxTime
     * @param string $decoupledAuthenticationMaxTime Indicates the maximum amount of time that the 3DS Requestor will wait for an ACS (Active control server) to provide the results of a Decoupled Authentication transaction (in minutes). Possible Values: Numeric values between 1 and 10080 accepted.
     * @return $this
     */
    public function setDecoupledAuthenticationMaxTime($decoupledAuthenticationMaxTime)
    {
        $this->container['decoupledAuthenticationMaxTime'] = $decoupledAuthenticationMaxTime;

        return $this;
    }

    /**
     * Gets defaultCard
     * @return bool
     */
    public function getDefaultCard()
    {
        return $this->container['defaultCard'];
    }

    /**
     * Sets defaultCard
     * @param bool $defaultCard Indicates that the card being used is the one designated as the primary payment card for purchase. Recommended for Discover ProtectBuy.
     * @return $this
     */
    public function setDefaultCard($defaultCard)
    {
        $this->container['defaultCard'] = $defaultCard;

        return $this;
    }

    /**
     * Gets deviceChannel
     * @return string
     */
    public function getDeviceChannel()
    {
        return $this->container['deviceChannel'];
    }

    /**
     * Sets deviceChannel
     * @param string $deviceChannel Determines the channel that the transaction came through. Possible Values: SDK/Browser/3RI. 3RI - 3DS request initiated.
     * @return $this
     */
    public function setDeviceChannel($deviceChannel)
    {
        $this->container['deviceChannel'] = $deviceChannel;

        return $this;
    }

    /**
     * Gets installmentTotalCount
     * @return int
     */
    public function getInstallmentTotalCount()
    {
        return $this->container['installmentTotalCount'];
    }

    /**
     * Sets installmentTotalCount
     * @param int $installmentTotalCount An integer value greater than 1 indicating the max number of permitted authorizations for installment payments. **Note** This is required if the merchant and cardholder have agreed to installment payments.
     * @return $this
     */
    public function setInstallmentTotalCount($installmentTotalCount)
    {
        $this->container['installmentTotalCount'] = $installmentTotalCount;

        return $this;
    }

    /**
     * Gets merchantFraudRate
     * @return string
     */
    public function getMerchantFraudRate()
    {
        return $this->container['merchantFraudRate'];
    }

    /**
     * Sets merchantFraudRate
     * @param string $merchantFraudRate Calculated by merchants as per PSD2** RTS** (EEA** card fraud divided by all EEA card volumes). Possible Values: 1 = Represents fraud rate <=1  2 = Represents fraud rate >1 and <=6  3 = Represents fraud rate >6 and <=13  4 = Represents fraud rate >13 and <=25  5 = Represents fraud rate >25  EEA** = European Economic Area RTS** = Regulatory Technical Standards PSD2** = Payment Services Directive
     * @return $this
     */
    public function setMerchantFraudRate($merchantFraudRate)
    {
        $this->container['merchantFraudRate'] = $merchantFraudRate;

        return $this;
    }

    /**
     * Gets marketingOptIn
     * @return bool
     */
    public function getMarketingOptIn()
    {
        return $this->container['marketingOptIn'];
    }

    /**
     * Sets marketingOptIn
     * @param bool $marketingOptIn Indicates whether the customer has opted in for marketing offers. Recommended for Discover ProtectBuy.
     * @return $this
     */
    public function setMarketingOptIn($marketingOptIn)
    {
        $this->container['marketingOptIn'] = $marketingOptIn;

        return $this;
    }

    /**
     * Gets marketingSource
     * @return string
     */
    public function getMarketingSource()
    {
        return $this->container['marketingSource'];
    }

    /**
     * Sets marketingSource
     * @param string $marketingSource Indicates origin of the marketing offer. Recommended for Discover ProtectBuy.
     * @return $this
     */
    public function setMarketingSource($marketingSource)
    {
        $this->container['marketingSource'] = $marketingSource;

        return $this;
    }

    /**
     * Gets mcc
     * @return string
     */
    public function getMcc()
    {
        return $this->container['mcc'];
    }

    /**
     * Sets mcc
     * @param string $mcc Merchant category code. **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions.
     * @return $this
     */
    public function setMcc($mcc)
    {
        $this->container['mcc'] = $mcc;

        return $this;
    }

    /**
     * Gets merchantScore
     * @return int
     */
    public function getMerchantScore()
    {
        return $this->container['merchantScore'];
    }

    /**
     * Sets merchantScore
     * @param int $merchantScore Risk Score provided by merchants. This is specific for CB transactions.
     * @return $this
     */
    public function setMerchantScore($merchantScore)
    {
        $this->container['merchantScore'] = $merchantScore;

        return $this;
    }

    /**
     * Gets messageCategory
     * @return string
     */
    public function getMessageCategory()
    {
        return $this->container['messageCategory'];
    }

    /**
     * Sets messageCategory
     * @param string $messageCategory Category of the message for a specific use case. Possible values:  - `01`: PA- payment authentication - `02`: NPA- non-payment authentication - `03-79`: Reserved for EMVCo future use (values invalid until defined by EMVCo) - `80-99`: Reserved for DS use
     * @return $this
     */
    public function setMessageCategory($messageCategory)
    {
        $this->container['messageCategory'] = $messageCategory;

        return $this;
    }

    /**
     * Gets networkScore
     * @return string
     */
    public function getNetworkScore()
    {
        return $this->container['networkScore'];
    }

    /**
     * Sets networkScore
     * @param string $networkScore The global score calculated by the CB scoring platform and returned to merchants.  Possible values:  - '00' - '99'  When you request the payer authentication and authorization services separately, get the value for this field from the pa_network_score reply field.         This field is supported only for Cartes Bancaires Fast'R transactions on Credit Mutuel-CIC.
     * @return $this
     */
    public function setNetworkScore($networkScore)
    {
        $this->container['networkScore'] = $networkScore;

        return $this;
    }

    /**
     * Gets npaCode
     * @return string
     */
    public function getNpaCode()
    {
        return $this->container['npaCode'];
    }

    /**
     * Sets npaCode
     * @param string $npaCode Non-Payer Authentication Indicator. Possible values: - `01`: Add card - `02`: Maintain card information - `03`: Cardholder verification for EMV token - `04-80` Reserved for EMVCo - `80-90` Reserved DS
     * @return $this
     */
    public function setNpaCode($npaCode)
    {
        $this->container['npaCode'] = $npaCode;

        return $this;
    }

    /**
     * Gets overridePaymentMethod
     * @return string
     */
    public function getOverridePaymentMethod()
    {
        return $this->container['overridePaymentMethod'];
    }

    /**
     * Sets overridePaymentMethod
     * @param string $overridePaymentMethod Specifies the Brazilian payment account type used for the transaction. This field overrides other payment types that might be specified in the request. Use one of the following values for this field: - `NA`: Not applicable. Do not override other payment types that are specified in the request. - `CR`: Credit card. - `DB`: Debit card. - `VSAVR`: Visa Vale Refeicao - `VSAVA`: Visa Vale Alimentacao **Important** Required only for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions.
     * @return $this
     */
    public function setOverridePaymentMethod($overridePaymentMethod)
    {
        $this->container['overridePaymentMethod'] = $overridePaymentMethod;

        return $this;
    }

    /**
     * Gets overrideCountryCode
     * @return string
     */
    public function getOverrideCountryCode()
    {
        return $this->container['overrideCountryCode'];
    }

    /**
     * Sets overrideCountryCode
     * @param string $overrideCountryCode Two-character [ISO Standard Country Codes](https://developer.cybersource.com/library/documentation/sbc/quickref/countries_alpha_list.pdf)..
     * @return $this
     */
    public function setOverrideCountryCode($overrideCountryCode)
    {
        $this->container['overrideCountryCode'] = $overrideCountryCode;

        return $this;
    }

    /**
     * Gets priorAuthenticationData
     * @return string
     */
    public function getPriorAuthenticationData()
    {
        return $this->container['priorAuthenticationData'];
    }

    /**
     * Sets priorAuthenticationData
     * @param string $priorAuthenticationData This field carry data that the ACS can use to verify the authentication process.
     * @return $this
     */
    public function setPriorAuthenticationData($priorAuthenticationData)
    {
        $this->container['priorAuthenticationData'] = $priorAuthenticationData;

        return $this;
    }

    /**
     * Gets priorAuthenticationMethod
     * @return string
     */
    public function getPriorAuthenticationMethod()
    {
        return $this->container['priorAuthenticationMethod'];
    }

    /**
     * Sets priorAuthenticationMethod
     * @param string $priorAuthenticationMethod Mechanism used by the Cardholder to previously authenticate to the 3DS Requestor.  01 - Frictionless authentication occurred by ACS  02 - Cardholder challenge occurred by ACS  03 - AVS verified  04 - Other issuer methods  05-79 - Reserved for EMVCo future use (values invalid until defined by EMVCo)  80-99 - Reserved for DS use
     * @return $this
     */
    public function setPriorAuthenticationMethod($priorAuthenticationMethod)
    {
        $this->container['priorAuthenticationMethod'] = $priorAuthenticationMethod;

        return $this;
    }

    /**
     * Gets priorAuthenticationReferenceId
     * @return string
     */
    public function getPriorAuthenticationReferenceId()
    {
        return $this->container['priorAuthenticationReferenceId'];
    }

    /**
     * Sets priorAuthenticationReferenceId
     * @param string $priorAuthenticationReferenceId This data element contains a ACS Transaction ID for a prior authenticated transaction. For example, the first recurring transaction that was authenticated with the cardholder
     * @return $this
     */
    public function setPriorAuthenticationReferenceId($priorAuthenticationReferenceId)
    {
        $this->container['priorAuthenticationReferenceId'] = $priorAuthenticationReferenceId;

        return $this;
    }

    /**
     * Gets priorAuthenticationTime
     * @return string
     */
    public function getPriorAuthenticationTime()
    {
        return $this->container['priorAuthenticationTime'];
    }

    /**
     * Sets priorAuthenticationTime
     * @param string $priorAuthenticationTime Date and time in UTC of the prior cardholder authentication. Format – YYYYMMDDHHMM
     * @return $this
     */
    public function setPriorAuthenticationTime($priorAuthenticationTime)
    {
        $this->container['priorAuthenticationTime'] = $priorAuthenticationTime;

        return $this;
    }

    /**
     * Gets productCode
     * @return string
     */
    public function getProductCode()
    {
        return $this->container['productCode'];
    }

    /**
     * Sets productCode
     * @param string $productCode Specifies the product code, which designates the type of transaction. Specify one of the following values for this field: - AIR: Airline purchase Important Required for American Express SafeKey (U.S.). - `ACC`: Accommodation Rental - `ACF`: Account funding - `CHA`: Check acceptance - `DIG`: Digital Goods - `DSP`: Cash Dispensing - `GAS`: Fuel - `GEN`: General Retail - `LUX`: Luxury Retail - `PAL`: Prepaid activation and load - `PHY`: Goods or services purchase - `QCT`: Quasi-cash transaction - `REN`: Car Rental - `RES`: Restaurant - `SVC`: Services - `TBD`: Other - `TRA`: Travel **Important** Required for Visa Secure transactions in Brazil. Do not use this request field for any other types of transactions.
     * @return $this
     */
    public function setProductCode($productCode)
    {
        $this->container['productCode'] = $productCode;

        return $this;
    }

    /**
     * Gets returnUrl
     * @return string
     */
    public function getReturnUrl()
    {
        return $this->container['returnUrl'];
    }

    /**
     * Sets returnUrl
     * @param string $returnUrl The URL of the merchant's return page. CyberSource adds this return URL to the step-up JWT and returns it in the response of the Payer Authentication enrollment call. The merchant's return URL page serves as a listening URL. Once the bank session completes, the merchant receives a POST to their URL. This response contains the completed bank session's transactionId. The merchant's return page should capture the transaction ID and send it in the Payer Authentication validation call.
     * @return $this
     */
    public function setReturnUrl($returnUrl)
    {
        $this->container['returnUrl'] = $returnUrl;

        return $this;
    }

    /**
     * Gets requestorId
     * @return string
     */
    public function getRequestorId()
    {
        return $this->container['requestorId'];
    }

    /**
     * Sets requestorId
     * @param string $requestorId Cardinal's directory server assigned 3DS Requestor ID value
     * @return $this
     */
    public function setRequestorId($requestorId)
    {
        $this->container['requestorId'] = $requestorId;

        return $this;
    }

    /**
     * Gets requestorInitiatedAuthenticationIndicator
     * @return string
     */
    public function getRequestorInitiatedAuthenticationIndicator()
    {
        return $this->container['requestorInitiatedAuthenticationIndicator'];
    }

    /**
     * Sets requestorInitiatedAuthenticationIndicator
     * @param string $requestorInitiatedAuthenticationIndicator Indicates the type of 3RI request.  Possible Values:  01 - Recurring transaction  02 - Installment transaction  03 - Add card  04 - Maintain card  05 - Account verification  06 - Split/delayed shipment  07 - Top-up  08 - Mail Order  09 - Telephone Order  10 - Whitelist status check  11 - Other payment
     * @return $this
     */
    public function setRequestorInitiatedAuthenticationIndicator($requestorInitiatedAuthenticationIndicator)
    {
        $this->container['requestorInitiatedAuthenticationIndicator'] = $requestorInitiatedAuthenticationIndicator;

        return $this;
    }

    /**
     * Gets requestorName
     * @return string
     */
    public function getRequestorName()
    {
        return $this->container['requestorName'];
    }

    /**
     * Sets requestorName
     * @param string $requestorName Cardinal's directory server assigned 3DS Requestor Name value
     * @return $this
     */
    public function setRequestorName($requestorName)
    {
        $this->container['requestorName'] = $requestorName;

        return $this;
    }

    /**
     * Gets referenceId
     * @return string
     */
    public function getReferenceId()
    {
        return $this->container['referenceId'];
    }

    /**
     * Sets referenceId
     * @param string $referenceId Reference ID that corresponds to the device fingerprinting data that was collected previously. Note Required for Hybrid integration.
     * @return $this
     */
    public function setReferenceId($referenceId)
    {
        $this->container['referenceId'] = $referenceId;

        return $this;
    }

    /**
     * Gets sdkMaxTimeout
     * @return string
     */
    public function getSdkMaxTimeout()
    {
        return $this->container['sdkMaxTimeout'];
    }

    /**
     * Sets sdkMaxTimeout
     * @param string $sdkMaxTimeout This field indicates the maximum amount of time for all 3DS 2.0 messages to be communicated between all components (in minutes).  Possible Values:  Greater than or equal to 05 (05 is the minimum timeout to set)  Cardinal Default is set to 15  NOTE: This field is a required 3DS 2.0 field and Cardinal sends in a default of 15 if nothing is passed
     * @return $this
     */
    public function setSdkMaxTimeout($sdkMaxTimeout)
    {
        $this->container['sdkMaxTimeout'] = $sdkMaxTimeout;

        return $this;
    }

    /**
     * Gets secureCorporatePaymentIndicator
     * @return string
     */
    public function getSecureCorporatePaymentIndicator()
    {
        return $this->container['secureCorporatePaymentIndicator'];
    }

    /**
     * Sets secureCorporatePaymentIndicator
     * @param string $secureCorporatePaymentIndicator Indicates dedicated payment processes and procedures were used, potential secure corporate payment exemption applies. Possible Values : 0/1
     * @return $this
     */
    public function setSecureCorporatePaymentIndicator($secureCorporatePaymentIndicator)
    {
        $this->container['secureCorporatePaymentIndicator'] = $secureCorporatePaymentIndicator;

        return $this;
    }

    /**
     * Gets transactionMode
     * @return string
     */
    public function getTransactionMode()
    {
        return $this->container['transactionMode'];
    }

    /**
     * Sets transactionMode
     * @param string $transactionMode Transaction mode identifier. Identifies the channel from which the transaction originates. Possible values:  - `M`: MOTO (Mail Order Telephone Order) - `R`: Retail - `S`: eCommerce - `P`: Mobile Device - `T`: Tablet
     * @return $this
     */
    public function setTransactionMode($transactionMode)
    {
        $this->container['transactionMode'] = $transactionMode;

        return $this;
    }

    /**
     * Gets whiteListStatus
     * @return string
     */
    public function getWhiteListStatus()
    {
        return $this->container['whiteListStatus'];
    }

    /**
     * Sets whiteListStatus
     * @param string $whiteListStatus Enables the communication of trusted beneficiary/whitelist status between the ACS, the DS and the 3DS Requestor.  Possible Values:  Y - 3DS Requestor is whitelisted by cardholder  N - 3DS Requestor is not whitelisted by cardholder
     * @return $this
     */
    public function setWhiteListStatus($whiteListStatus)
    {
        $this->container['whiteListStatus'] = $whiteListStatus;

        return $this;
    }

    /**
     * Gets authenticationBrand
     * @return string
     */
    public function getAuthenticationBrand()
    {
        return $this->container['authenticationBrand'];
    }

    /**
     * Sets authenticationBrand
     * @param string $authenticationBrand Indicates which directory server was used while authentication process, this data is useful in case of scenarios  when domestic scheme directory server is not present and authentication fallbacks to global scheme directory server. Possible values: - VISA - Returned for Mada VISA Co-badged cards, when authentication falls back to VISA Directory Server - MASTERCARD - Returned for Mada MasterCard Co-badged cards, when authentication falls back to MasterCard Directory Server
     * @return $this
     */
    public function setAuthenticationBrand($authenticationBrand)
    {
        $this->container['authenticationBrand'] = $authenticationBrand;

        return $this;
    }

    /**
     * Gets effectiveAuthenticationType
     * @return string
     */
    public function getEffectiveAuthenticationType()
    {
        return $this->container['effectiveAuthenticationType'];
    }

    /**
     * Sets effectiveAuthenticationType
     * @param string $effectiveAuthenticationType This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer).
     * @return $this
     */
    public function setEffectiveAuthenticationType($effectiveAuthenticationType)
    {
        $this->container['effectiveAuthenticationType'] = $effectiveAuthenticationType;

        return $this;
    }

    /**
     * Gets signedParesStatusReason
     * @return string
     */
    public function getSignedParesStatusReason()
    {
        return $this->container['signedParesStatusReason'];
    }

    /**
     * Sets signedParesStatusReason
     * @param string $signedParesStatusReason Provides additional information as to why the PAResStatus has a specific value.
     * @return $this
     */
    public function setSignedParesStatusReason($signedParesStatusReason)
    {
        $this->container['signedParesStatusReason'] = $signedParesStatusReason;

        return $this;
    }

    /**
     * Gets signedPares
     * @return string
     */
    public function getSignedPares()
    {
        return $this->container['signedPares'];
    }

    /**
     * Sets signedPares
     * @param string $signedPares Payer authentication result (PARes) message returned by the card-issuing bank. If you need to show proof of enrollment checking, you may need to decrypt and parse the string for the information required by the payment card company. For more information, see \"Storing Payer Authentication Data,\" page 160. Important The value is in base64. You must remove all carriage returns and line feeds before adding the PARes to the request.
     * @return $this
     */
    public function setSignedPares($signedPares)
    {
        $this->container['signedPares'] = $signedPares;

        return $this;
    }

    /**
     * Gets acsReferenceNumber
     * @return string
     */
    public function getAcsReferenceNumber()
    {
        return $this->container['acsReferenceNumber'];
    }

    /**
     * Sets acsReferenceNumber
     * @param string $acsReferenceNumber Unique identifier assigned by the EMVCo Secretariat upon Testing and Approval.
     * @return $this
     */
    public function setAcsReferenceNumber($acsReferenceNumber)
    {
        $this->container['acsReferenceNumber'] = $acsReferenceNumber;

        return $this;
    }

    /**
     * Gets dsReferenceNumber
     * @return string
     */
    public function getDsReferenceNumber()
    {
        return $this->container['dsReferenceNumber'];
    }

    /**
     * Sets dsReferenceNumber
     * @param string $dsReferenceNumber EMVCo-assigned unique identifier. This field is required in Cardholder Initiated 3DS fully authenticated mada transactions. When you request the payer authentication and authorization services separately, get the value for this field from the payerAuthEnrollReply_dsReferenceNumber or payerAuthValidateReply_dsReferenceNumber response field.
     * @return $this
     */
    public function setDsReferenceNumber($dsReferenceNumber)
    {
        $this->container['dsReferenceNumber'] = $dsReferenceNumber;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


