<?php
/**
 * PaymentsProductsPayoutsConfigurationInformationConfigurationsPullfunds
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * PaymentsProductsPayoutsConfigurationInformationConfigurationsPullfunds Class Doc Comment
 *
 * @category    Class
 * @description Formatted as *{payoutsAcquirerName}. The property name field should be the same as the processor name for which the pull funds or push funds feature is being configured. Here is the list of valid processor names [TBD]
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PaymentsProductsPayoutsConfigurationInformationConfigurationsPullfunds implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'paymentsProducts_payouts_configurationInformation_configurations_pullfunds';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'acquirerOrganizationId' => 'string',
        'acquiringBIN' => 'int',
        'allowCryptoCurrencyPurchase' => 'bool',
        'cardAcceptorId' => 'string',
        'originatorMvv' => 'string',
        'originatorNameAbbreviation' => 'string',
        'cardTerminalId' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'acquirerOrganizationId' => null,
        'acquiringBIN' => null,
        'allowCryptoCurrencyPurchase' => null,
        'cardAcceptorId' => null,
        'originatorMvv' => null,
        'originatorNameAbbreviation' => null,
        'cardTerminalId' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'acquirerOrganizationId' => 'acquirerOrganizationId',
        'acquiringBIN' => 'acquiringBIN',
        'allowCryptoCurrencyPurchase' => 'allowCryptoCurrencyPurchase',
        'cardAcceptorId' => 'cardAcceptorId',
        'originatorMvv' => 'originatorMvv',
        'originatorNameAbbreviation' => 'originatorNameAbbreviation',
        'cardTerminalId' => 'cardTerminalId'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'acquirerOrganizationId' => 'setAcquirerOrganizationId',
        'acquiringBIN' => 'setAcquiringBIN',
        'allowCryptoCurrencyPurchase' => 'setAllowCryptoCurrencyPurchase',
        'cardAcceptorId' => 'setCardAcceptorId',
        'originatorMvv' => 'setOriginatorMvv',
        'originatorNameAbbreviation' => 'setOriginatorNameAbbreviation',
        'cardTerminalId' => 'setCardTerminalId'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'acquirerOrganizationId' => 'getAcquirerOrganizationId',
        'acquiringBIN' => 'getAcquiringBIN',
        'allowCryptoCurrencyPurchase' => 'getAllowCryptoCurrencyPurchase',
        'cardAcceptorId' => 'getCardAcceptorId',
        'originatorMvv' => 'getOriginatorMvv',
        'originatorNameAbbreviation' => 'getOriginatorNameAbbreviation',
        'cardTerminalId' => 'getCardTerminalId'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['acquirerOrganizationId'] = isset($data['acquirerOrganizationId']) ? $data['acquirerOrganizationId'] : null;
        $this->container['acquiringBIN'] = isset($data['acquiringBIN']) ? $data['acquiringBIN'] : null;
        $this->container['allowCryptoCurrencyPurchase'] = isset($data['allowCryptoCurrencyPurchase']) ? $data['allowCryptoCurrencyPurchase'] : null;
        $this->container['cardAcceptorId'] = isset($data['cardAcceptorId']) ? $data['cardAcceptorId'] : null;
        $this->container['originatorMvv'] = isset($data['originatorMvv']) ? $data['originatorMvv'] : null;
        $this->container['originatorNameAbbreviation'] = isset($data['originatorNameAbbreviation']) ? $data['originatorNameAbbreviation'] : null;
        $this->container['cardTerminalId'] = isset($data['cardTerminalId']) ? $data['cardTerminalId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['acquiringBIN'] === null) {
            $invalid_properties[] = "'acquiringBIN' can't be null";
        }
        if ($this->container['cardAcceptorId'] === null) {
            $invalid_properties[] = "'cardAcceptorId' can't be null";
        }
        if ($this->container['cardTerminalId'] === null) {
            $invalid_properties[] = "'cardTerminalId' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['acquiringBIN'] === null) {
            return false;
        }
        if ($this->container['cardAcceptorId'] === null) {
            return false;
        }
        if ($this->container['cardTerminalId'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets acquirerOrganizationId
     * @return string
     */
    public function getAcquirerOrganizationId()
    {
        return $this->container['acquirerOrganizationId'];
    }

    /**
     * Sets acquirerOrganizationId
     * @param string $acquirerOrganizationId Valid organization in OMS with an organizationInformation.type as \"acquirer\".
     * @return $this
     */
    public function setAcquirerOrganizationId($acquirerOrganizationId)
    {
        $this->container['acquirerOrganizationId'] = $acquirerOrganizationId;

        return $this;
    }

    /**
     * Gets acquiringBIN
     * @return int
     */
    public function getAcquiringBIN()
    {
        return $this->container['acquiringBIN'];
    }

    /**
     * Sets acquiringBIN
     * @param int $acquiringBIN This code identifies the financial institution acting as the acquirer of this transaction. The acquirer is the client or system user that signed the originator or installed the unattended cardholder- activated environment. When a processing center operates for multiple acquirers, this code is for the individual client or system user, not a code for the center.
     * @return $this
     */
    public function setAcquiringBIN($acquiringBIN)
    {
        $this->container['acquiringBIN'] = $acquiringBIN;

        return $this;
    }

    /**
     * Gets allowCryptoCurrencyPurchase
     * @return bool
     */
    public function getAllowCryptoCurrencyPurchase()
    {
        return $this->container['allowCryptoCurrencyPurchase'];
    }

    /**
     * Sets allowCryptoCurrencyPurchase
     * @param bool $allowCryptoCurrencyPurchase This configuration allows a transaction to be flagged for cryptocurrency funds transfer.
     * @return $this
     */
    public function setAllowCryptoCurrencyPurchase($allowCryptoCurrencyPurchase)
    {
        $this->container['allowCryptoCurrencyPurchase'] = $allowCryptoCurrencyPurchase;

        return $this;
    }

    /**
     * Gets cardAcceptorId
     * @return string
     */
    public function getCardAcceptorId()
    {
        return $this->container['cardAcceptorId'];
    }

    /**
     * Sets cardAcceptorId
     * @param string $cardAcceptorId A unique identifier number for the originator of transfers that is unique to the processor or acquirer.
     * @return $this
     */
    public function setCardAcceptorId($cardAcceptorId)
    {
        $this->container['cardAcceptorId'] = $cardAcceptorId;

        return $this;
    }

    /**
     * Gets originatorMvv
     * @return string
     */
    public function getOriginatorMvv()
    {
        return $this->container['originatorMvv'];
    }

    /**
     * Sets originatorMvv
     * @param string $originatorMvv Merchant Verification Value (MVV) is used to identify originators that participate in a variety of programs. The MVV is unique to the merchant.
     * @return $this
     */
    public function setOriginatorMvv($originatorMvv)
    {
        $this->container['originatorMvv'] = $originatorMvv;

        return $this;
    }

    /**
     * Gets originatorNameAbbreviation
     * @return string
     */
    public function getOriginatorNameAbbreviation()
    {
        return $this->container['originatorNameAbbreviation'];
    }

    /**
     * Sets originatorNameAbbreviation
     * @param string $originatorNameAbbreviation A 4 character max name abbreviation for the originator.
     * @return $this
     */
    public function setOriginatorNameAbbreviation($originatorNameAbbreviation)
    {
        $this->container['originatorNameAbbreviation'] = $originatorNameAbbreviation;

        return $this;
    }

    /**
     * Gets cardTerminalId
     * @return string
     */
    public function getCardTerminalId()
    {
        return $this->container['cardTerminalId'];
    }

    /**
     * Sets cardTerminalId
     * @param string $cardTerminalId This field contains a code that identifies a terminal at the card acceptor location. This field is used in all messages related to a transaction. If sending transactions from a card not present environment, use the same value for all transactions.
     * @return $this
     */
    public function setCardTerminalId($cardTerminalId)
    {
        $this->container['cardTerminalId'] = $cardTerminalId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


