<?php
/**
 * Invoicingv2invoicesidInvoiceInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Invoicingv2invoicesidInvoiceInformation Class Doc Comment
 *
 * @category    Class
 * @description Contains the updatable invoice information.
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Invoicingv2invoicesidInvoiceInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'invoicingv2invoicesid_invoiceInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'description' => 'string',
        'dueDate' => '\DateTime',
        'expirationDate' => '\DateTime',
        'sendImmediately' => 'bool',
        'allowPartialPayments' => 'bool',
        'deliveryMode' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'description' => null,
        'dueDate' => 'date',
        'expirationDate' => 'date',
        'sendImmediately' => null,
        'allowPartialPayments' => null,
        'deliveryMode' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'description' => 'description',
        'dueDate' => 'dueDate',
        'expirationDate' => 'expirationDate',
        'sendImmediately' => 'sendImmediately',
        'allowPartialPayments' => 'allowPartialPayments',
        'deliveryMode' => 'deliveryMode'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'description' => 'setDescription',
        'dueDate' => 'setDueDate',
        'expirationDate' => 'setExpirationDate',
        'sendImmediately' => 'setSendImmediately',
        'allowPartialPayments' => 'setAllowPartialPayments',
        'deliveryMode' => 'setDeliveryMode'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'description' => 'getDescription',
        'dueDate' => 'getDueDate',
        'expirationDate' => 'getExpirationDate',
        'sendImmediately' => 'getSendImmediately',
        'allowPartialPayments' => 'getAllowPartialPayments',
        'deliveryMode' => 'getDeliveryMode'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['dueDate'] = isset($data['dueDate']) ? $data['dueDate'] : null;
        $this->container['expirationDate'] = isset($data['expirationDate']) ? $data['expirationDate'] : null;
        $this->container['sendImmediately'] = isset($data['sendImmediately']) ? $data['sendImmediately'] : false;
        $this->container['allowPartialPayments'] = isset($data['allowPartialPayments']) ? $data['allowPartialPayments'] : false;
        $this->container['deliveryMode'] = isset($data['deliveryMode']) ? $data['deliveryMode'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['description'] === null) {
            $invalid_properties[] = "'description' can't be null";
        }
        if ($this->container['dueDate'] === null) {
            $invalid_properties[] = "'dueDate' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['description'] === null) {
            return false;
        }
        if ($this->container['dueDate'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description included in the invoice.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets dueDate
     * @return \DateTime
     */
    public function getDueDate()
    {
        return $this->container['dueDate'];
    }

    /**
     * Sets dueDate
     * @param \DateTime $dueDate The invoice due date. This field is required for creating an invoice. Format: `YYYY-MM-DD`, where `YYYY` = year, `MM` = month, and `DD` = day
     * @return $this
     */
    public function setDueDate($dueDate)
    {
        $this->container['dueDate'] = $dueDate;

        return $this;
    }

    /**
     * Gets expirationDate
     * @return \DateTime
     */
    public function getExpirationDate()
    {
        return $this->container['expirationDate'];
    }

    /**
     * Sets expirationDate
     * @param \DateTime $expirationDate Define an expiration date for the link.  Format: `YYYY-MM-DD`, where `YYYY` = year, `MM` = month, and `DD` = day
     * @return $this
     */
    public function setExpirationDate($expirationDate)
    {
        $this->container['expirationDate'] = $expirationDate;

        return $this;
    }

    /**
     * Gets sendImmediately
     * @return bool
     */
    public function getSendImmediately()
    {
        return $this->container['sendImmediately'];
    }

    /**
     * Sets sendImmediately
     * @param bool $sendImmediately If set to `true`, we send the invoice immediately. If set to `false`, the invoice remains in draft mode.
     * @return $this
     */
    public function setSendImmediately($sendImmediately)
    {
        $this->container['sendImmediately'] = $sendImmediately;

        return $this;
    }

    /**
     * Gets allowPartialPayments
     * @return bool
     */
    public function getAllowPartialPayments()
    {
        return $this->container['allowPartialPayments'];
    }

    /**
     * Sets allowPartialPayments
     * @param bool $allowPartialPayments If set to `true`, the payer can make a partial invoice payment.
     * @return $this
     */
    public function setAllowPartialPayments($allowPartialPayments)
    {
        $this->container['allowPartialPayments'] = $allowPartialPayments;

        return $this;
    }

    /**
     * Gets deliveryMode
     * @return string
     */
    public function getDeliveryMode()
    {
        return $this->container['deliveryMode'];
    }

    /**
     * Sets deliveryMode
     * @param string $deliveryMode If this field is set to 'None', an invoice will be generated with the status 'CREATED', but no email will be dispatched.    Possible values:        - `None`   - `Email`
     * @return $this
     */
    public function setDeliveryMode($deliveryMode)
    {
        $this->container['deliveryMode'] = $deliveryMode;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


