<?php
/**
 * InvoicingV2InvoicesPost201ResponseInvoiceInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * InvoicingV2InvoicesPost201ResponseInvoiceInformation Class Doc Comment
 *
 * @category    Class
 * @description Contains all of the invoice-specific fields, such as the invoice number and due date.
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class InvoicingV2InvoicesPost201ResponseInvoiceInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'invoicingV2InvoicesPost201Response_invoiceInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'invoiceNumber' => 'string',
        'description' => 'string',
        'dueDate' => '\DateTime',
        'expirationDate' => '\DateTime',
        'allowPartialPayments' => 'bool',
        'paymentLink' => 'string',
        'deliveryMode' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'invoiceNumber' => null,
        'description' => null,
        'dueDate' => 'date',
        'expirationDate' => 'date',
        'allowPartialPayments' => null,
        'paymentLink' => null,
        'deliveryMode' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'invoiceNumber' => 'invoiceNumber',
        'description' => 'description',
        'dueDate' => 'dueDate',
        'expirationDate' => 'expirationDate',
        'allowPartialPayments' => 'allowPartialPayments',
        'paymentLink' => 'paymentLink',
        'deliveryMode' => 'deliveryMode'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'invoiceNumber' => 'setInvoiceNumber',
        'description' => 'setDescription',
        'dueDate' => 'setDueDate',
        'expirationDate' => 'setExpirationDate',
        'allowPartialPayments' => 'setAllowPartialPayments',
        'paymentLink' => 'setPaymentLink',
        'deliveryMode' => 'setDeliveryMode'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'invoiceNumber' => 'getInvoiceNumber',
        'description' => 'getDescription',
        'dueDate' => 'getDueDate',
        'expirationDate' => 'getExpirationDate',
        'allowPartialPayments' => 'getAllowPartialPayments',
        'paymentLink' => 'getPaymentLink',
        'deliveryMode' => 'getDeliveryMode'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['invoiceNumber'] = isset($data['invoiceNumber']) ? $data['invoiceNumber'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['dueDate'] = isset($data['dueDate']) ? $data['dueDate'] : null;
        $this->container['expirationDate'] = isset($data['expirationDate']) ? $data['expirationDate'] : null;
        $this->container['allowPartialPayments'] = isset($data['allowPartialPayments']) ? $data['allowPartialPayments'] : false;
        $this->container['paymentLink'] = isset($data['paymentLink']) ? $data['paymentLink'] : null;
        $this->container['deliveryMode'] = isset($data['deliveryMode']) ? $data['deliveryMode'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets invoiceNumber
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoiceNumber'];
    }

    /**
     * Sets invoiceNumber
     * @param string $invoiceNumber Invoice Number.
     * @return $this
     */
    public function setInvoiceNumber($invoiceNumber)
    {
        $this->container['invoiceNumber'] = $invoiceNumber;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description included in the invoice.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets dueDate
     * @return \DateTime
     */
    public function getDueDate()
    {
        return $this->container['dueDate'];
    }

    /**
     * Sets dueDate
     * @param \DateTime $dueDate The invoice due date. This field is required for creating an invoice. Format: `YYYY-MM-DD`, where `YYYY` = year, `MM` = month, and `DD` = day
     * @return $this
     */
    public function setDueDate($dueDate)
    {
        $this->container['dueDate'] = $dueDate;

        return $this;
    }

    /**
     * Gets expirationDate
     * @return \DateTime
     */
    public function getExpirationDate()
    {
        return $this->container['expirationDate'];
    }

    /**
     * Sets expirationDate
     * @param \DateTime $expirationDate Define an expiration date for the link.  Format: `YYYY-MM-DD`, where `YYYY` = year, `MM` = month, and `DD` = day
     * @return $this
     */
    public function setExpirationDate($expirationDate)
    {
        $this->container['expirationDate'] = $expirationDate;

        return $this;
    }

    /**
     * Gets allowPartialPayments
     * @return bool
     */
    public function getAllowPartialPayments()
    {
        return $this->container['allowPartialPayments'];
    }

    /**
     * Sets allowPartialPayments
     * @param bool $allowPartialPayments If set to `true`, the payer can make a partial invoice payment.
     * @return $this
     */
    public function setAllowPartialPayments($allowPartialPayments)
    {
        $this->container['allowPartialPayments'] = $allowPartialPayments;

        return $this;
    }

    /**
     * Gets paymentLink
     * @return string
     */
    public function getPaymentLink()
    {
        return $this->container['paymentLink'];
    }

    /**
     * Sets paymentLink
     * @param string $paymentLink Returns the payment link to an invoice when the invoice status is `SENT`, `CREATED`, `PARTIAL`, or `PAID`.
     * @return $this
     */
    public function setPaymentLink($paymentLink)
    {
        $this->container['paymentLink'] = $paymentLink;

        return $this;
    }

    /**
     * Gets deliveryMode
     * @return string
     */
    public function getDeliveryMode()
    {
        return $this->container['deliveryMode'];
    }

    /**
     * Sets deliveryMode
     * @param string $deliveryMode If this field is set to 'None', an invoice will be generated with the status 'CREATED', but no email will be dispatched.    Possible values:        - `None`   - `Email`
     * @return $this
     */
    public function setDeliveryMode($deliveryMode)
    {
        $this->container['deliveryMode'] = $deliveryMode;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


