<?php
/**
 * InlineResponse2015
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * InlineResponse2015 Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class InlineResponse2015 implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'inline_response_201_5';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'eventDate' => 'string',
        'eventType' => 'string',
        'organizationId' => 'string',
        'payloads' => '\CyberSource\Model\InlineResponse2015Payloads',
        'productId' => 'string',
        'requestType' => 'string',
        'retryNumber' => 'int',
        'transactionTraceId' => 'string',
        'webhookId' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'eventDate' => null,
        'eventType' => null,
        'organizationId' => null,
        'payloads' => null,
        'productId' => null,
        'requestType' => null,
        'retryNumber' => null,
        'transactionTraceId' => null,
        'webhookId' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'eventDate' => 'eventDate',
        'eventType' => 'eventType',
        'organizationId' => 'organizationId',
        'payloads' => 'payloads',
        'productId' => 'productId',
        'requestType' => 'requestType',
        'retryNumber' => 'retryNumber',
        'transactionTraceId' => 'transactionTraceId',
        'webhookId' => 'webhookId'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'eventDate' => 'setEventDate',
        'eventType' => 'setEventType',
        'organizationId' => 'setOrganizationId',
        'payloads' => 'setPayloads',
        'productId' => 'setProductId',
        'requestType' => 'setRequestType',
        'retryNumber' => 'setRetryNumber',
        'transactionTraceId' => 'setTransactionTraceId',
        'webhookId' => 'setWebhookId'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'eventDate' => 'getEventDate',
        'eventType' => 'getEventType',
        'organizationId' => 'getOrganizationId',
        'payloads' => 'getPayloads',
        'productId' => 'getProductId',
        'requestType' => 'getRequestType',
        'retryNumber' => 'getRetryNumber',
        'transactionTraceId' => 'getTransactionTraceId',
        'webhookId' => 'getWebhookId'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['eventDate'] = isset($data['eventDate']) ? $data['eventDate'] : null;
        $this->container['eventType'] = isset($data['eventType']) ? $data['eventType'] : null;
        $this->container['organizationId'] = isset($data['organizationId']) ? $data['organizationId'] : null;
        $this->container['payloads'] = isset($data['payloads']) ? $data['payloads'] : null;
        $this->container['productId'] = isset($data['productId']) ? $data['productId'] : null;
        $this->container['requestType'] = isset($data['requestType']) ? $data['requestType'] : null;
        $this->container['retryNumber'] = isset($data['retryNumber']) ? $data['retryNumber'] : null;
        $this->container['transactionTraceId'] = isset($data['transactionTraceId']) ? $data['transactionTraceId'] : null;
        $this->container['webhookId'] = isset($data['webhookId']) ? $data['webhookId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets eventDate
     * @return string
     */
    public function getEventDate()
    {
        return $this->container['eventDate'];
    }

    /**
     * Sets eventDate
     * @param string $eventDate Date that the webhook was delivered
     * @return $this
     */
    public function setEventDate($eventDate)
    {
        $this->container['eventDate'] = $eventDate;

        return $this;
    }

    /**
     * Gets eventType
     * @return string
     */
    public function getEventType()
    {
        return $this->container['eventType'];
    }

    /**
     * Sets eventType
     * @param string $eventType The event name the webhook was delivered for
     * @return $this
     */
    public function setEventType($eventType)
    {
        $this->container['eventType'] = $eventType;

        return $this;
    }

    /**
     * Gets organizationId
     * @return string
     */
    public function getOrganizationId()
    {
        return $this->container['organizationId'];
    }

    /**
     * Sets organizationId
     * @param string $organizationId The Organization Identifier.
     * @return $this
     */
    public function setOrganizationId($organizationId)
    {
        $this->container['organizationId'] = $organizationId;

        return $this;
    }

    /**
     * Gets payloads
     * @return \CyberSource\Model\InlineResponse2015Payloads
     */
    public function getPayloads()
    {
        return $this->container['payloads'];
    }

    /**
     * Sets payloads
     * @param \CyberSource\Model\InlineResponse2015Payloads $payloads
     * @return $this
     */
    public function setPayloads($payloads)
    {
        $this->container['payloads'] = $payloads;

        return $this;
    }

    /**
     * Gets productId
     * @return string
     */
    public function getProductId()
    {
        return $this->container['productId'];
    }

    /**
     * Sets productId
     * @param string $productId The product the webhook was delivered for
     * @return $this
     */
    public function setProductId($productId)
    {
        $this->container['productId'] = $productId;

        return $this;
    }

    /**
     * Gets requestType
     * @return string
     */
    public function getRequestType()
    {
        return $this->container['requestType'];
    }

    /**
     * Sets requestType
     * @param string $requestType Identifies the the type of request
     * @return $this
     */
    public function setRequestType($requestType)
    {
        $this->container['requestType'] = $requestType;

        return $this;
    }

    /**
     * Gets retryNumber
     * @return int
     */
    public function getRetryNumber()
    {
        return $this->container['retryNumber'];
    }

    /**
     * Sets retryNumber
     * @param int $retryNumber The number of retry attempts for a given webhook
     * @return $this
     */
    public function setRetryNumber($retryNumber)
    {
        $this->container['retryNumber'] = $retryNumber;

        return $this;
    }

    /**
     * Gets transactionTraceId
     * @return string
     */
    public function getTransactionTraceId()
    {
        return $this->container['transactionTraceId'];
    }

    /**
     * Sets transactionTraceId
     * @param string $transactionTraceId The identifier for the webhook
     * @return $this
     */
    public function setTransactionTraceId($transactionTraceId)
    {
        $this->container['transactionTraceId'] = $transactionTraceId;

        return $this;
    }

    /**
     * Gets webhookId
     * @return string
     */
    public function getWebhookId()
    {
        return $this->container['webhookId'];
    }

    /**
     * Sets webhookId
     * @param string $webhookId The identifier of the subscription
     * @return $this
     */
    public function setWebhookId($webhookId)
    {
        $this->container['webhookId'] = $webhookId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


