<?php
/**
 * GenerateUnifiedCheckoutCaptureContextRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * GenerateUnifiedCheckoutCaptureContextRequest Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class GenerateUnifiedCheckoutCaptureContextRequest implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'generateUnifiedCheckoutCaptureContextRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'clientVersion' => 'string',
        'targetOrigins' => 'string[]',
        'allowedCardNetworks' => 'string[]',
        'allowedPaymentTypes' => 'string[]',
        'country' => 'string',
        'locale' => 'string',
        'captureMandate' => '\CyberSource\Model\Upv1capturecontextsCaptureMandate',
        'completeMandate' => '\CyberSource\Model\Upv1capturecontextsCompleteMandate',
        'orderInformation' => '\CyberSource\Model\Upv1capturecontextsOrderInformation',
        'transientTokenResponseOptions' => '\CyberSource\Model\Microformv2sessionsTransientTokenResponseOptions'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'clientVersion' => null,
        'targetOrigins' => null,
        'allowedCardNetworks' => null,
        'allowedPaymentTypes' => null,
        'country' => null,
        'locale' => null,
        'captureMandate' => null,
        'completeMandate' => null,
        'orderInformation' => null,
        'transientTokenResponseOptions' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'clientVersion' => 'clientVersion',
        'targetOrigins' => 'targetOrigins',
        'allowedCardNetworks' => 'allowedCardNetworks',
        'allowedPaymentTypes' => 'allowedPaymentTypes',
        'country' => 'country',
        'locale' => 'locale',
        'captureMandate' => 'captureMandate',
        'completeMandate' => 'completeMandate',
        'orderInformation' => 'orderInformation',
        'transientTokenResponseOptions' => 'transientTokenResponseOptions'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'clientVersion' => 'setClientVersion',
        'targetOrigins' => 'setTargetOrigins',
        'allowedCardNetworks' => 'setAllowedCardNetworks',
        'allowedPaymentTypes' => 'setAllowedPaymentTypes',
        'country' => 'setCountry',
        'locale' => 'setLocale',
        'captureMandate' => 'setCaptureMandate',
        'completeMandate' => 'setCompleteMandate',
        'orderInformation' => 'setOrderInformation',
        'transientTokenResponseOptions' => 'setTransientTokenResponseOptions'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'clientVersion' => 'getClientVersion',
        'targetOrigins' => 'getTargetOrigins',
        'allowedCardNetworks' => 'getAllowedCardNetworks',
        'allowedPaymentTypes' => 'getAllowedPaymentTypes',
        'country' => 'getCountry',
        'locale' => 'getLocale',
        'captureMandate' => 'getCaptureMandate',
        'completeMandate' => 'getCompleteMandate',
        'orderInformation' => 'getOrderInformation',
        'transientTokenResponseOptions' => 'getTransientTokenResponseOptions'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['clientVersion'] = isset($data['clientVersion']) ? $data['clientVersion'] : null;
        $this->container['targetOrigins'] = isset($data['targetOrigins']) ? $data['targetOrigins'] : null;
        $this->container['allowedCardNetworks'] = isset($data['allowedCardNetworks']) ? $data['allowedCardNetworks'] : null;
        $this->container['allowedPaymentTypes'] = isset($data['allowedPaymentTypes']) ? $data['allowedPaymentTypes'] : null;
        $this->container['country'] = isset($data['country']) ? $data['country'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['captureMandate'] = isset($data['captureMandate']) ? $data['captureMandate'] : null;
        $this->container['completeMandate'] = isset($data['completeMandate']) ? $data['completeMandate'] : null;
        $this->container['orderInformation'] = isset($data['orderInformation']) ? $data['orderInformation'] : null;
        $this->container['transientTokenResponseOptions'] = isset($data['transientTokenResponseOptions']) ? $data['transientTokenResponseOptions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets clientVersion
     * @return string
     */
    public function getClientVersion()
    {
        return $this->container['clientVersion'];
    }

    /**
     * Sets clientVersion
     * @param string $clientVersion Specify the version of Unified Checkout that you want to use.
     * @return $this
     */
    public function setClientVersion($clientVersion)
    {
        $this->container['clientVersion'] = $clientVersion;

        return $this;
    }

    /**
     * Gets targetOrigins
     * @return string[]
     */
    public function getTargetOrigins()
    {
        return $this->container['targetOrigins'];
    }

    /**
     * Sets targetOrigins
     * @param string[] $targetOrigins The [target origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) of the website on which you will be launching Unified Checkout is defined by the scheme (protocol), hostname (domain) and port number (if used).    You must use https://hostname (unless you use http://localhost) Wildcards are NOT supported.  Ensure that subdomains are included. Any valid top-level domain is supported (e.g. .com, .co.uk, .gov.br etc)  Examples:   - https://example.com   - https://subdomain.example.com   - https://example.com:8080<br><br>  If you are embedding within multiple nested iframes you need to specify the origins of all the browser contexts used, for example:    targetOrigins: [     \"https://example.com\",     \"https://basket.example.com\",     \"https://ecom.example.com\"   ]
     * @return $this
     */
    public function setTargetOrigins($targetOrigins)
    {
        $this->container['targetOrigins'] = $targetOrigins;

        return $this;
    }

    /**
     * Gets allowedCardNetworks
     * @return string[]
     */
    public function getAllowedCardNetworks()
    {
        return $this->container['allowedCardNetworks'];
    }

    /**
     * Sets allowedCardNetworks
     * @param string[] $allowedCardNetworks The list of card networks you want to use for this Unified Checkout transaction.  Unified Checkout currently supports the following card networks:     - VISA     - MASTERCARD     - AMEX     - CARNET     - CARTESBANCAIRES     - CUP     - DINERSCLUB     - DISCOVER     - EFTPOS     - ELO     - JCB     - JCREW     - MADA     - MAESTRO     - MEEZA     - PAYPAK
     * @return $this
     */
    public function setAllowedCardNetworks($allowedCardNetworks)
    {
        $this->container['allowedCardNetworks'] = $allowedCardNetworks;

        return $this;
    }

    /**
     * Gets allowedPaymentTypes
     * @return string[]
     */
    public function getAllowedPaymentTypes()
    {
        return $this->container['allowedPaymentTypes'];
    }

    /**
     * Sets allowedPaymentTypes
     * @param string[] $allowedPaymentTypes The payment types that are allowed for the merchant.    Possible values when launching Unified Checkout:   - APPLEPAY   - CHECK   - CLICKTOPAY   - GOOGLEPAY   - PANENTRY                 - PAZE <br><br>  Unified Checkout also supports the following Alternative Payments:   - AFTERPAY<br><br>  Possible values when launching Click To Pay Drop-In UI: - CLICKTOPAY <br><br>  **Important:**    - CLICKTOPAY only available for Visa, Mastercard and AMEX for saved cards.   - Visa and Mastercard will look to tokenize using network tokenization for all Click to Pay requests.  Click to Pay uses Click to Pay token requester IDs and not the merchant's existing token requester.   - Apple Pay, Google Pay, Check, and Paze can be used independently without requiring PAN entry in the allowedPaymentTypes field.<br><br>  **Managing Google Pay Authentication Types** When you enable Google Pay on Unified Checkout you can specify optional parameters that define the types of card authentication you receive from Google Pay.<br><br>  **Managing Google Pay Authentication Types** Where Click to Pay is the payment type selected by the customer and the customer manually enters their card, the option to enroll their card in Click to Pay will be auto-checked if this field is set to \"true\".   This is only available where the merchant and cardholder are based in the following countries and the billing type is set to \"FULL\" or \"PARTIAL\".   - UAE   - Argentina   - Brazil   - Chile   - Colombia   - Kuwait   - Mexico   - Peru   - Qatar   - Saudi Arabia   - Ukraine   - South Africa<br><br>  If false, this is not present or not supported in the market.  Enrollment in Click to Pay is not checked for the customer when completing manual card entry.
     * @return $this
     */
    public function setAllowedPaymentTypes($allowedPaymentTypes)
    {
        $this->container['allowedPaymentTypes'] = $allowedPaymentTypes;

        return $this;
    }

    /**
     * Gets country
     * @return string
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     * @param string $country Country the purchase is originating from (e.g. country of the merchant).  Use the two-character ISO Standard
     * @return $this
     */
    public function setCountry($country)
    {
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets locale
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     * @param string $locale Localization of the User experience conforming to the ISO 639-1 language standards and two-character ISO Standard Country Code.  Please refer to list of [supported locales through Unified Checkout](https://developer.cybersource.com/docs/cybs/en-us/unified-checkout/developer/all/rest/unified-checkout/uc-appendix-languages.html)
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets captureMandate
     * @return \CyberSource\Model\Upv1capturecontextsCaptureMandate
     */
    public function getCaptureMandate()
    {
        return $this->container['captureMandate'];
    }

    /**
     * Sets captureMandate
     * @param \CyberSource\Model\Upv1capturecontextsCaptureMandate $captureMandate
     * @return $this
     */
    public function setCaptureMandate($captureMandate)
    {
        $this->container['captureMandate'] = $captureMandate;

        return $this;
    }

    /**
     * Gets completeMandate
     * @return \CyberSource\Model\Upv1capturecontextsCompleteMandate
     */
    public function getCompleteMandate()
    {
        return $this->container['completeMandate'];
    }

    /**
     * Sets completeMandate
     * @param \CyberSource\Model\Upv1capturecontextsCompleteMandate $completeMandate
     * @return $this
     */
    public function setCompleteMandate($completeMandate)
    {
        $this->container['completeMandate'] = $completeMandate;

        return $this;
    }

    /**
     * Gets orderInformation
     * @return \CyberSource\Model\Upv1capturecontextsOrderInformation
     */
    public function getOrderInformation()
    {
        return $this->container['orderInformation'];
    }

    /**
     * Sets orderInformation
     * @param \CyberSource\Model\Upv1capturecontextsOrderInformation $orderInformation
     * @return $this
     */
    public function setOrderInformation($orderInformation)
    {
        $this->container['orderInformation'] = $orderInformation;

        return $this;
    }

    /**
     * Gets transientTokenResponseOptions
     * @return \CyberSource\Model\Microformv2sessionsTransientTokenResponseOptions
     */
    public function getTransientTokenResponseOptions()
    {
        return $this->container['transientTokenResponseOptions'];
    }

    /**
     * Sets transientTokenResponseOptions
     * @param \CyberSource\Model\Microformv2sessionsTransientTokenResponseOptions $transientTokenResponseOptions
     * @return $this
     */
    public function setTransientTokenResponseOptions($transientTokenResponseOptions)
    {
        $this->container['transientTokenResponseOptions'] = $transientTokenResponseOptions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


