<?php
// disable direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// sending and saving form submission
if ( $error == false ) {
	// ignore form submission in these cases
	if ( ( isset( $error_class['form_first_random'] ) || isset( $error_class['form_second_random'] ) ) && ( $display_errors != 'yes' ) ) {
		$sent = true;
	} elseif ( isset( $error_class['form_time'] ) && ( $display_errors != 'yes' ) ) {
		$sent = true;
	} elseif ( isset( $banned_words ) && ( $ignore_submission_banned_words == 'yes' ) ) {
		$sent = true;
	} elseif ( isset( $message_has_links ) && ( $ignore_submission_links == 'yes' ) ) {
		$sent = true;
	} elseif ( isset( $message_has_email ) && ( $ignore_submission_email == 'yes' ) ) {
		$sent = true;
	} else {
		// hook to support plugin Contact Form DB
		do_action( 'vscf_before_send_mail', $form_data );
		// email address
		if ( ! empty( $email_address_attribute ) ) {
			$email_address_string = $email_address_attribute;
		} elseif ( ! empty( $email_address_settings_page ) ) {
			$email_address_string = $email_address_settings_page;
		}
		if ( ! empty( $email_address_string ) ) {
			if (strpos( $email_address_string, ',' ) !== false ) {
				$email_list_clean = array();
				$email_list = explode( ',', $email_address_string );
				foreach ( $email_list as $email_single ) {
					$email_clean = sanitize_email( $email_single );
					if ( is_email( $email_clean ) ) {
						$email_list_clean[] = $email_clean;
					}
				}
				if ( count( $email_list_clean ) < 6 ) {
					$to = implode( ',', $email_list_clean );
				}
			} else {
				$email_clean = sanitize_email( $email_address_string );
				if ( is_email( $email_clean ) ) {
					$to = $email_clean;
				}
			}
		}
		if ( empty( $to ) ) {
			$to = $email_address_admin;
		}
		// from email header
		if ( is_email( $from_header_attribute ) ) {
			$from = $from_header_attribute;
		} elseif ( is_email( $from_header ) ) {
			$from = $from_header;
		} elseif ( is_email( $email_address_settings_page ) ) {
			$from = $email_address_settings_page;
		} else {
			$from = $email_address_admin;
		}
		// reply-to email address
		if ( is_email( $email_address_attribute ) ) {
			$reply_to = $email_address_attribute;
		} elseif ( is_email( $email_address_settings_page ) ) {
			$reply_to = $email_address_settings_page;
		} else {
			$reply_to = $email_address_admin;
		}
		// subject for email
		if ( ! empty( $subject_attribute ) ) {
			$subject = $subject_attribute;
		} elseif ( ! empty( $subject_settings_page ) ) {
			$subject = $subject_settings_page;
		} elseif ( $disable_subject != 'yes' ) {
			$subject = $blog_name.' - '.$form_data['form_subject']."\r\n\r\n";
		} else {
			$subject = $blog_name.' - '.__( 'Form submission', 'very-simple-contact-form' );
		}
		// subject for auto-reply email
		if ( ! empty( $subject_auto_reply_attribute ) ) {
			$subject_auto_reply = $subject_auto_reply_attribute;
		} elseif ( ! empty( $subject_auto_reply_settings_page ) ) {
			$subject_auto_reply = $subject_auto_reply_settings_page;
		} elseif ( $disable_subject != 'yes' ) {
			$subject_auto_reply = $blog_name.' - '.$form_data['form_subject']."\r\n\r\n";
		} else {
			$subject_auto_reply = $blog_name.' - '.__( 'Form submission', 'very-simple-contact-form' );
		}
		// subject from sender
		if ( $disable_subject != 'yes' ) {
			$subject_from_sender = $form_data['form_subject']."\r\n\r\n";
		} else {
			$subject_from_sender = '';
		}
		// auto-reply message
		$message_auto_reply = htmlspecialchars_decode( $auto_reply_message, ENT_QUOTES );
		// show or hide privacy consent
		if ( $disable_privacy != 'yes' ) {
			/* translators: %s: privacy consent text. */
			$privacy_consent = "\r\n\r\n".sprintf( __( 'Privacy consent: %s', 'very-simple-contact-form' ), $privacy_label );
		} else {
			$privacy_consent = '';
		}
		// show or hide ip address
		if ( $disable_ip_address == 'yes' ) {
			$ip_address = '';
		} else {
			/* translators: %s: IP-address from sender. */
			$ip_address = "\r\n\r\n".sprintf( __( 'IP: %s', 'very-simple-contact-form' ), vscf_ip_address() );
		}
		// include date in form submission content
		/* translators: %s: form submission date. */
		$submission_date = "\r\n\r\n".sprintf( __( 'Date: %s', 'very-simple-contact-form' ), wp_date( get_option( 'date_format' ), $time_field ) );
		// save form submission in database
		if ( $list_submissions == 'yes' ) {
			$content_for_post = array(
				'post_title' => wp_strip_all_tags( $subject ),
				'post_content' => $form_data['form_name']."\r\n\r\n".$form_data['form_email']."\r\n\r\n".$subject_from_sender.$form_data['form_message'].$privacy_consent.$ip_address.$submission_date,
				'post_type' => 'submission',
				'post_status' => 'pending',
				'meta_input' => array( "name_sub" => $form_data['form_name'], "email_sub" => $form_data['form_email'] ),
			);
			wp_insert_post( $content_for_post );
		}
		// email
		if ( $disable_mail == 'yes' ) {
			$mail_sends = true;
		} else {
			$content = $form_data['form_name']."\r\n\r\n".$form_data['form_email']."\r\n\r\n".$subject_from_sender.$form_data['form_message'].$privacy_consent.$ip_address.$submission_date;
			$headers = "Content-Type: text/plain; charset=UTF-8" . "\r\n";
			$headers .= "From: ".$form_data['form_name']." <".$from.">" . "\r\n";
			$headers .= "Reply-To: <".$form_data['form_email'].">" . "\r\n";
			if ( wp_mail( $to, wp_strip_all_tags( $subject ), $content, $headers ) ) {
				$mail_sends = true;
			} else {
				$mail_fails = true;
			}
		}
		// auto-reply email
		if ( $auto_reply_mail == 'yes' ) {
			$auto_reply_content = $message_auto_reply."\r\n\r\n".$form_data['form_name']."\r\n\r\n".$form_data['form_email']."\r\n\r\n".$subject_from_sender.$form_data['form_message'];
			$auto_reply_headers = "Content-Type: text/plain; charset=UTF-8" . "\r\n";
			$auto_reply_headers .= "From: ".$blog_name." <".$from.">" . "\r\n";
			$auto_reply_headers .= "Reply-To: <".$reply_to.">" . "\r\n";
			if ( wp_mail( $form_data['form_email'], wp_strip_all_tags( $subject_auto_reply ), $auto_reply_content, $auto_reply_headers ) ) {
				$mail_sends = true;
			} else {
				$mail_fails = true;
			}
		}
		// email success or fail
		if ( $mail_fails == true ) {
			$fail = true;
		} elseif ( $mail_sends == true ) {
			$sent = true;
		}
	}
}
