# Simple Settings Library

## What Is This

Depending on the size of a project, you may be able to get away with adding settings to an existing WordPress page (or the customizer). On the other end of the spectrum, you may need (or want) to implement a full-scale control panel like [Redux](http://reduxframework.com). However, what if your project is somewhere in the middle? Alternatively, what if you need a control panel, but don't want the bulk that goes along with most? This need is something that I've struggled with for some time. My standard implementation has historically been a fork of the excellent system used by [Easy Digital Downloads](https://easydigitaldownloads.com). However, this has its own set of issues. For each project, I had to sort through the various required files and update function and variable names to prevent conflicts, and the process of implementing it was arduous. Thus, I finally sat down and converted it into a reusable library which I am now sharing with the general public!

More information can be found on the [wiki](https://gitlab.com/widgitlabs/wordpress/simple-settings/wikis/home).

## Installation

1. You can clone the GitLab repository: `https://gitlab.com/widgitlabs/wordpress/simple-settings.git`
2. Or download it directly as a ZIP file: `https://gitlab.com/widgitlabs/wordpress/simple-settings/-/archive/master/simple-settings-master.zip`

This will download the latest developer copy of the Simple Settings library.

## Bugs

If you find an issue, let us know [here](https://gitlab.com/widgitlabs/wordpress/simple-settings/issues)!

## Contributions

Anyone is welcome to contribute to the library. Please read the [guidelines for contributing](https://github.com/widgitlabs/wordpress/simple-settings/blob/master/CONTRIBUTING.md) to this repository.

There are various ways you can contribute:

1. Raise an [Issue](https://gitlab.com/widgitlabs/wordpress/simple-settings/issues) on GitLab
2. Send us a Pull Request with your bug fixes and/or new features
3. Provide feedback and suggestions on [enhancements](https://gitlab.com/widgitlabs/wordpress/simple-settings/issues?label_name[]=Enhancement)
