<?php

class UserFeedback_Survey_Template_Phone_Lead extends UserFeedback_Survey_Template {

	/**
	 * @inheritdoc
	 */
	protected $template_key = 'phone-lead';

	protected $categories = array(
		'ecommerce'
	);

	/**
	 * @inheritdoc
	 */
	protected $is_pro = false;

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'Phone Lead Form', 'userfeedback-lite' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return array(
			'title' => __( 'Ask your customers for a phone number to receive a call back.', 'userfeedback-lite' )
		);
	}

	/**
	 * @inheritdoc
	 *
	 * @return array
	 */
	public function get_config() {
		return array(
			'questions' => array(
				array(
					'type'  => 'text',
					'title' => __( "Have questions? Provide us your phone number and we'll give you a call!", 'userfeedback-lite' ),
				),
				array(
					'type'  => 'text',
					'title' => __( "What's Your Name?", 'userfeedback-lite' ),
				),
			),
		);
	}
}
