=== User Verification by PickPlugins ===
	Contributors: PickPlugins
	Donate link: http://pickplugins.com
	Tags:  Email Verification, Hide Login, Email OTP, Email Validation, Passwordless login
	Requires at least: 4.1
	Tested up to: 6.9
	Stable tag: 2.0.43
	License: GPLv2 or later
	License URI: http://www.gnu.org/licenses/gpl-2.0.html

	Email verification for user registration to protect spam.

== Description ==



# User Verification - Complete WordPress User Authentication & Security Plugin

### User Verification by [http://www.pickplugins.com](http://www.pickplugins.com)

* [Donate](https://www.pickplugins.com/item/user-verification/?ref=wordpress.org)
* [Support](https://www.pickplugins.com/support/?ref=wordpress.org)
* [Documentation](https://pickplugins.com/documentation/user-verification/?ref=wordpress.org)


## Secure Your WordPress Site with Advanced User Verification & Authentication

**User Verification** is a comprehensive WordPress security plugin that provides multiple layers of user authentication and spam protection to safeguard your website from unauthorized access and malicious registrations.

### 🔐 Key Features

#### **Email Verification System**
- **Mandatory Email Verification**: Ensure all new users verify their email addresses before accessing your site
- **Customizable Verification Pages**: Choose custom redirect pages for successful and failed verifications  
- **Automatic Login**: Seamlessly log users in after successful email verification
- **Role-Based Control**: Exclude specific user roles (like Administrators) from verification requirements
- **Flexible Configuration**: Enable/disable email verification with simple toggle controls

#### **Magic Login (Passwordless Authentication)**
- **🆕 NEW Feature**: Enable secure passwordless login for enhanced user experience
- **Email-Based Authentication**: Users receive login links directly in their inbox
- **Customizable Key Length**: Set secure authentication key length (default: 6 characters)
- **Attempt Limits**: Configure maximum login attempts for security (default: 3 attempts)
- **Custom Redirect Pages**: Set specific pages for successful logins, failures, and magic login forms
- **Email Verification Integration**: Require verified emails for magic login access
- **Easy Implementation**: Simple shortcode `[user_verification_magic_login_form]` for frontend display

#### **OTP (One-Time Password) Login**
- **SMS/Email OTP**: Secure one-time password authentication system
- **Configurable OTP Length**: Customize OTP length (default: 6 digits)
- **Character Flexibility**: Support for numbers, uppercase, lowercase, and special characters
- **Custom Success/Error Messages**: Personalized user feedback for OTP processes
- **Post-Login Redirects**: Direct users to specific pages after successful authentication
- **Easy Integration**: Simple shortcode `[user_verification_otp_login_form]` implementation

#### **Advanced Spam Protection**
- **Domain Blocking**: Block registrations from specific email domains
- **Domain Allowlist**: Allow only approved email domains for registration
- **Username Protection**: Block specific usernames from registration
- **Flexible Domain Management**: Easy-to-use interface for managing blocked/allowed domains

#### **reCAPTCHA Integration**
- **Google reCAPTCHA v2**: Complete bot protection with checkbox verification
- **Multiple Implementation Points**: Add reCAPTCHA to login, registration, password reset, and comment forms
- **WooCommerce Ready**: Full integration with WooCommerce forms
- **Easy Configuration**: Simple setup with site key and secret key

#### **User Management Tools**
- **Unverified User Cleanup**: Automatically delete unverified user accounts
- **Existing User Verification**: Mark existing users as verified with customizable intervals
- **User Status Monitoring**: Track verification status across your user base

#### **Email Customization**
- **Custom Email Templates**: Personalize verification and notification emails
- **WPAutoP Support**: Enable/disable automatic paragraph formatting in emails
- **Branded Communications**: Add your logo and customize email appearance
- **Multiple Email Types**: Templates for registration, verification, OTP, magic login, and activation

#### **WooCommerce Compatibility**
- **E-commerce Ready**: Full integration with WooCommerce login, registration, and password reset forms
- **Customer Protection**: Prevent fake customer registrations and protect customer data
- **Seamless Experience**: Maintain smooth checkout process while ensuring security

### 🎯 Perfect For:
- **Membership Sites**: Protect exclusive content with verified users only
- **E-commerce Stores**: Prevent fake customer accounts and fraudulent orders  
- **Corporate Websites**: Ensure legitimate user registrations for business platforms
- **Community Forums**: Maintain quality user base with verified members
- **Educational Platforms**: Secure student and instructor account creation
- **Any WordPress Site**: Enhance security for blogs, portfolios, and business websites

### ⚡ Easy Setup & Management
- **User-Friendly Interface**: Intuitive admin dashboard for all configurations
- **Shortcode Ready**: Simple shortcodes for frontend form implementation
- **One-Click Configuration**: Enable/disable features with simple toggle switches
- **Comprehensive Documentation**: Detailed setup guides and troubleshooting support

### 🔧 Technical Specifications
- **WordPress Compatibility**: Works with latest WordPress versions
- **PHP 7.4+ Support**: Modern PHP compatibility for optimal performance
- **Mobile Responsive**: All forms and interfaces work perfectly on mobile devices
- **Translation Ready**: Multi-language support for global websites
- **Developer Friendly**: Clean code structure with hooks and filters for customization

### 📧 Default Email Configuration
- **Professional Setup**: Comes with pre-configured professional email settings
- **Custom From Address**: Set your preferred sender email (e.g., public.nurhasan@gmail.com)
- **Branded Sender Name**: Customize sender name (default: wordpress)
- **Template Variety**: Multiple email templates for different verification scenarios

### 🚀 Why Choose User Verification?

1. **Complete Security Solution**: Multiple authentication methods in one plugin
2. **Zero Spam Guarantee**: Advanced filtering eliminates fake registrations
3. **User Experience Focused**: Smooth verification process that doesn't frustrate legitimate users
4. **Highly Customizable**: Adapt every aspect to match your site's needs
5. **Regular Updates**: Continuously updated with new features and security improvements
6. **Professional Support**: Dedicated support for setup and troubleshooting

### Installation & Usage
Simply install the plugin, configure your preferred verification methods, and add the provided shortcodes to your pages. The plugin integrates seamlessly with WordPress default forms and popular plugins like WooCommerce.

**Transform your WordPress site security today with User Verification - the most comprehensive user authentication plugin available.**


== External services ==

## Spam Protection by [https://isspammy.com](http://isspammy.com)

isspammy.com is owned by PickPlugins and it's used to protect spam users from login in, registering, commenting, posting reviews and etc. Once you mark a comment as spam it will send a request to isspammy.com and it will create a record for this mail and marked as spam, so later when the same email is used to post a comment it will block them as a spammer. isspammy.com is commited to keep user email private and only accessible when requested.

* [isspammy.com/privacy-policy/](http://isspammy.com/privacy-policy/)
* [isspammy.com/About Us/](http://isspammy.com/privacy-policy/)


== Screenshots ==

1. Screenshot 1
2. Screenshot 2
3. Screenshot 3
4. Screenshot 4
5. Screenshot 5
6. Screenshot 6
7. Screenshot 7
8. Screenshot 8
9. Screenshot 9
10. Screenshot 10



== Changelog ==


= 2.0.42 =
* 2025-12-12 fix - Latest WP compatibility issue check.
* 2025-12-12 fix - Escaping issue fixed. 

= 2.0.42 =
* 2025-11-24 fix - Login failed conflict with Memberpress plugin issue fixed.
  

= 2.0.41 =
* 2025-11-08 fix - OTP Length bug fixed.

= 2.0.40 =
* 2025-08-26 add - Magic Login nonce issue fixed.
* 2025-08-26 add - Magic Login failed login redirect issue fixed.
* 
= 2.0.39 =
* 2025-08-23 add - Login attempt feature added

= 2.0.38 =
* 2025-08-14 add - OTP Login added with custom shortcodes.

= 2.0.37 =
* 2025-07-05 fix - Magic Login added
* 2025-07-05 fix - OTP login feature down for security issue.

= 2.0.36 =
* 2024-03-29 fix - reCAPTCHA for WooCommerce issue fixed.

= 2.0.35 =
* 2024-03-26 fix - Otions saving issue fixed for WooCommerce

= 2.0.34 =
* 2024-03-17 fix - Email Template HTML Editor issue fixed.
* 2024-03-17 fix - Login Form rCaptcha issue fixed.
* 2024-03-17 fix - Blocked Domain issue fixedd.
* 2024-03-17 fix - Allowed Domain issue fixedd.
* 2024-03-17 fix - Blocked Username issue fixedd.
* 2024-03-17 fix - Block Generic Email domain issue fixedd.


= 2.0.33 =
* 2024-02-17 update - Dashboard Updated.

= 2.0.32 =
* 2024-02-17 fix - Email Template not saving issue fixed.

= 2.0.30 =
* 2024-02-17 update - Update React Based Dashboard
* 2024-02-17 update - Add email validation by isspammy.com on register

= 2.0.29 =
* 2024-01-14 fix - Email sending issue on register user.
