<?php
if (!defined('ABSPATH')) exit;  // if direct access

add_filter('user_verification_settings_tabs', 'user_verification_settings_tabs_woocommerce');

function user_verification_settings_tabs_woocommerce($tabs)
{

    $current_tab = isset($_REQUEST['tab']) ? sanitize_text_field($_REQUEST['tab']) : 'email_verification';


    $tabs[] = array(
        'id' => 'woocommerce',
        /* translators: %s is Icon HTML*/
        'title' => sprintf(__('%s WooCommerce', 'user-verification'), '<i class="fas fa-cart-arrow-down"></i>'),
        'priority' => 15,
        'active' => ($current_tab == 'woocommerce') ? true : false,
    );

    return $tabs;
}


add_action('user_verification_settings_content_woocommerce', 'user_verification_settings_content_woocommerce');

function user_verification_settings_content_woocommerce()
{
    $settings_tabs_field = new settings_tabs_field();

    $user_verification_settings = get_option('user_verification_settings');

    $redirect_after_registration = isset($user_verification_settings['woocommerce']['redirect_after_registration']) ? $user_verification_settings['woocommerce']['redirect_after_registration'] : '';



    $disable_auto_login = isset($user_verification_settings['woocommerce']['disable_auto_login']) ? $user_verification_settings['woocommerce']['disable_auto_login'] : 'no';
    $disable_auto_login_checkout = isset($user_verification_settings['woocommerce']['disable_auto_login_checkout']) ? $user_verification_settings['woocommerce']['disable_auto_login_checkout'] : 'no';
    $message_after_registration = isset($user_verification_settings['woocommerce']['message_after_registration']) ? $user_verification_settings['woocommerce']['message_after_registration'] : __('Registration success, please check mail for details.', 'user-verification');
    $redirect_after_payment = isset($user_verification_settings['woocommerce']['redirect_after_payment']) ? $user_verification_settings['woocommerce']['redirect_after_payment'] : '';




?>
    <div class="section">
        <div class="section-title"><?php echo esc_html_e('WooCommerce', 'user-verification'); ?></div>
        <p class="description section-description"><?php echo esc_html_e('Customize options for WooCommerce.', 'user-verification'); ?></p>

        <?php



        $args = array(
            'id'        => 'redirect_after_registration',
            'parent'        => 'user_verification_settings[woocommerce]',
            'title'        => __('Redirect after registration', 'user-verification'),
            'details'    => __('You can set custom page to redirect after successfully registration.', 'user-verification'),
            'type'        => 'select',
            'value'        => $redirect_after_registration,
            'default'        => '',
            'args'        => user_verification_get_pages_list(),

        );

        $settings_tabs_field->generate_field($args);







        $args = array(
            'id'        => 'disable_auto_login',
            'parent'        => 'user_verification_settings[woocommerce]',
            'title'        => __('Disable auto login on registration', 'user-verification'),
            'details'    => __('You can disable auto login after registration via WooCommerce register form. this also disable login on checkout page.', 'user-verification'),
            'type'        => 'select',
            'value'        => $disable_auto_login,
            'default'        => '',
            'args'        => array('yes' => __('Yes', 'user-verification'), 'no' => __('No', 'user-verification')),
        );

        $settings_tabs_field->generate_field($args);


        $args = array(
            'id'        => 'disable_auto_login_checkout',
            'parent'        => 'user_verification_settings[woocommerce]',
            'title'        => __('Disable auto login on checkout', 'user-verification'),
            'details'    => __('You can disable auto login on checkout page after completed the order.', 'user-verification'),
            'type'        => 'select',
            'value'        => $disable_auto_login_checkout,
            'default'        => '',
            'args'        => array('yes' => __('Yes', 'user-verification'), 'no' => __('No', 'user-verification')),
        );

        $settings_tabs_field->generate_field($args);



        $args = array(
            'id'        => 'message_after_registration',
            'parent'        => 'user_verification_settings[woocommerce]',
            'title'        => __('Display Message after successfully registration', 'user-verification'),
            'details'    => __('You can display custom message on after successfully registration via WooCommerce register form.', 'user-verification'),
            'type'        => 'textarea',
            'value'        => $message_after_registration,
            'default'        => '',
        );

        $settings_tabs_field->generate_field($args);





        $args = array(
            'id'        => 'redirect_after_payment',
            'parent'        => 'user_verification_settings[woocommerce]',
            'title'        => __('Redirect after payment', 'user-verification'),
            'details'    => __('You can set custom page to redirect after successfully payment, and this page should check verification status and take action to stay logged-in or logged-out the user automatically. please use following shortcode <code>[user_verification_message message="Please check email to verify account first"]</code> to check verification status, it will automatically logged-out the unverified user and display the custom message.', 'user-verification'),
            'type'        => 'select',
            'value'        => $redirect_after_payment,
            'default'        => '',
            'args'        => user_verification_get_pages_list(),

        );

        $settings_tabs_field->generate_field($args);




        ?>

    </div>

<?php
}




add_action('user_verification_settings_content_recaptcha', 'user_verification_settings_content_recaptcha_woo', 20);

function user_verification_settings_content_recaptcha_woo()
{


    $settings_tabs_field = new settings_tabs_field();

    $user_verification_settings = get_option('user_verification_settings');



    $wc_login_form = isset($user_verification_settings['recaptcha']['wc_login_form']) ? $user_verification_settings['recaptcha']['wc_login_form'] : 'no';
    $wc_register_form = isset($user_verification_settings['recaptcha']['wc_register_form']) ? $user_verification_settings['recaptcha']['wc_register_form'] : 'no';
    $wc_lostpassword_form = isset($user_verification_settings['recaptcha']['wc_lostpassword_form']) ? $user_verification_settings['recaptcha']['wc_lostpassword_form'] : 'no';




?>
    <div class="section">
        <div class="section-title"><?php echo esc_html_e('WooCommerce reCAPTCHA', 'user-verification'); ?></div>
        <p class="description section-description"><?php echo esc_html_e('Customize options for WooCommerce reCAPTCHA.', 'user-verification'); ?></p>

        <?php


        $args = array(
            'id'        => 'wc_login_form',
            'parent'        => 'user_verification_settings[recaptcha]',
            'title'        => __('WooCommerce login form', 'user-verification'),
            'details'    => __('Enable reCAPTCHA on WooCommerce login form', 'user-verification'),
            'type'        => 'select',
            'value'        => $wc_login_form,
            'default'        => '',
            'args'        => array('yes' => __('Yes', 'user-verification'), 'no' => __('No', 'user-verification')),
        );

        $settings_tabs_field->generate_field($args);


        $args = array(
            'id'        => 'wc_register_form',
            'parent'        => 'user_verification_settings[recaptcha]',
            'title'        => __('WooCommerce register form', 'user-verification'),
            'details'    => __('Enable reCAPTCHA on WooCommerce register form', 'user-verification'),
            'type'        => 'select',
            'value'        => $wc_register_form,
            'default'        => '',
            'args'        => array('yes' => __('Yes', 'user-verification'), 'no' => __('No', 'user-verification')),
        );

        $settings_tabs_field->generate_field($args);

        $args = array(
            'id'        => 'wc_lostpassword_form',
            'parent'        => 'user_verification_settings[recaptcha]',
            'title'        => __('WooCommerce lost password form', 'user-verification'),
            'details'    => __('Enable reCAPTCHA on WooCommerce lost password form', 'user-verification'),
            'type'        => 'select',
            'value'        => $wc_lostpassword_form,
            'default'        => '',
            'args'        => array('yes' => __('Yes', 'user-verification'), 'no' => __('No', 'user-verification')),
        );

        $settings_tabs_field->generate_field($args);




        ?>

    </div>

<?php
}
