<?php
/**
 * FormElement.php
 *
 * The FormElement class file.
 *
 * PHP versions 5
 *
 * @author    Alexander Schneider <alexanderschneider85@gmail.com>
 * @copyright 2008-2017 Alexander Schneider
 * @license   http://www.gnu.org/licenses/gpl-2.0.html  GNU General Public License, version 2
 * @version   SVN: $id$
 * @link      http://wordpress.org/extend/plugins/user-access-manager/
 */

declare(strict_types=1);

namespace UserAccessManager\Form;

/**
 * Class FormElement
 *
 * @package UserAccessManager\Form
 */
abstract class FormElement
{
    use ValueTrait;
    use LabelTrait;

    public function __construct(
        protected string $id,
        mixed $value = null,
        ?string $label = null,
        protected ?string $description = null
    ) {
        $this->value = $value;
        $this->label = $label;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }
}
