(function ($) {
  "use strict";
  $(document).ready(function () {

      const targetElement = document.querySelector(".wps-bump-offer-container");

        if (targetElement) {
          targetElement.scrollIntoView({
            behavior: 'smooth',
            block: 'start'
          });
        }
    
      function togglePopUpSetting() {
        if ($("#wps_Offer_With_Pop_Up_id_pro_1").is(":checked")) {
          $(".wps_target_bump_for_popup").show(800);
        } else {
          $(".wps_target_bump_for_popup").hide(800);
        }
      }

      // Run the function initially based on the current radio button selection.
      togglePopUpSetting();

      // Listen for changes to the radio buttons.
      $('input[name="wps_bump_popup_bump_offer"]').on("change", function () {
        togglePopUpSetting();
      });

      // Event delegation to handle dynamic elements.
      $(document).on("click", ".wps-ob_temp-alpha", function () {
        var $checkbox = $(this).find("#wps-ob_temp-alpha-check");
        if ($checkbox.is(":checked")) {
          $checkbox.prop("checked", false);
          $(this).removeClass("wps-ob_checked");
        } else {
          $checkbox.prop("checked", true);
          $(this).addClass("wps-ob_checked");
        }
      });

    var myDiv = document.getElementById("wps_ubo_lite_save_changes_bump");
    let isHidden = false;

    // Function to check if the user has reached the bottom of the page.
    function isBottomOfPage() {
        const windowHeight =
        window.innerHeight || document.documentElement.clientHeight;
        const documentHeight = Math.max(
        document.body.scrollHeight,
        document.body.offsetHeight,
        document.documentElement.clientHeight,
        document.documentElement.scrollHeight,
        document.documentElement.offsetHeight
      );

      const scrollPosition =
        window.scrollY ||
        window.pageYOffset ||
        document.documentElement.scrollTop;

      return documentHeight - (scrollPosition + windowHeight) < 50;
    }

    // Function to hide the div.
    function hideDiv() {
      if (myDiv && myDiv.style) {
        myDiv.style.display = "none";
        isHidden = true;
      }
    }

    // Function to show the div.
    function showDiv() {
      if (myDiv && myDiv.style) {
        myDiv.style.display = "inline-flex";
        isHidden = false;
      }
    }

    // Listen for the scroll event.
    window.addEventListener("scroll", function () {
      if (isBottomOfPage() && !isHidden) {
        hideDiv();
      } else if (!isBottomOfPage() && isHidden) {
        showDiv();
      }
    });

    var wps_is_pro_active = wps_ubo_lite_banner_offer_section_obj.is_pro_active;
    if (1 == wps_is_pro_active) {
      $(".wps_ubo_premium_strip").hide();
    }

    $(document).on("click", ".wps_product_info", function () {
      $(this).toggleClass("accordian--active");
      $(this).next("p").slideToggle();
    });

    $(document).on("click", ".wps-save-changes-ubo", function () {
      document.getElementById("wps_upsell_bump_creation_setting_save").click();
    });

    // Create new offer bump.
    $(".wps_ubo_lite_bump_create_button").on("click", function (e) {
      var present_offers = $(".wps_ubo_lite_saved_funnel").val();
      if (present_offers >= "1") {
        e.preventDefault();
        $(".wps_ubo_lite_go_pro_popup_wrap").addClass(
          "wps_ubo_lite_go_pro_popup_show"
        );
        $("body").addClass("wps_ubo_lite_go_pro_popup_body");
      }
    });

    $(".wps_ubo_lite_go_pro_popup_close").on("click", function (e) {
      // Hide Go pro popup.
      e.preventDefault();
      $(".wps_ubo_lite_go_pro_popup_wrap").removeClass(
        "wps_ubo_lite_go_pro_popup_show"
      );
      $(".wps_ubo_lite_go_pro_popup_wrap_template").removeClass(
        "wps_ubo_lite_go_pro_popup_show"
      );
      $("body").removeClass("wps_ubo_lite_go_pro_popup_body");
    });
    $(".wps_ubo_lite_skype_setting").on("click", function () {
      $("#wps_ubo_lite_skype_connect_with_us").toggleClass("show");
    });
    // Onclick outside the div close for Go Pro popup.
    $("body").click(function (e) {
      if (
        e.target.className ==
          "wps_ubo_lite_go_pro_popup_wrap wps_ubo_lite_go_pro_popup_show" ||
        e.target.className ==
          "wps_ubo_lite_go_pro_popup_wrap_template wps_ubo_lite_go_pro_popup_show"
      ) {
        $(".wps_ubo_lite_go_pro_popup_wrap").removeClass(
          "wps_ubo_lite_go_pro_popup_show"
        );
        $(".wps_ubo_lite_go_pro_popup_wrap_template").removeClass(
          "wps_ubo_lite_go_pro_popup_show"
        );
        $("body").removeClass("wps_ubo_lite_go_pro_popup_body");
      }
    });

    // Sticky Offer Preview.
    $(".wps_upsell_offer_main_wrapper").stick_in_parent({ offset_top: 50 });

    $(".wps_ubo_colorpicker").wpColorPicker();

    $("#wps_upsell_bump_target_ids").select2();
    $("#wps_upsell_bump_target_ids_search").select2();

    $(".wps_ubo_template").val(0);

    // Reflect the saved in Template selection settings.
    if ($("#wps_bump_template_type_select").val() == "Yes") {
      $(".wps_upsell_template_div").css("display", "block");
      $(".wps_upsell_custom_template_settings").css("display", "none");
    } else {
      $(".wps_upsell_custom_template_settings").css("display", "block");
      $(".wps_upsell_template_div").css("display", "none");
    }

    // Reflect the change in Template selection.
    $("#wps_bump_template_type_select").on("change", function () {
      var v = $(this).val();

      if (v == "Yes") {
        $(".wps_upsell_template_div").css("display", "block");
        $(".wps_upsell_custom_template_settings").css("display", "none");
      } else {
        $(".wps_upsell_custom_template_settings").css("display", "block");
        $(".wps_upsell_template_div").css("display", "none");
      }
    });

    // Reflect the change in horizontal_slider.
    $(".wps_ubo_bottom_vertical_spacing_slider").on("change", function () {
      var v = $(this).val();
      $(".wps_ubo_bottom_spacing_slider_size").html(v + "px");
    });

    // Reflect the change in font.
    $("#primary_section_slider").on("change", function () {
      var v = $(this).val();
      $("#primary_section_slider_html").css("font-size", v + "px");
    });

    // Reflect the change in font.
    $("#secondary_section_slider").on("change", function () {
      var v = $(this).val();
      $("#secondary_section_slider_html").css("font-size", v + "px");
    });

    // Scroll to bump offer section after Saving product.
    if (typeof wps_ubo_lite_offer_section_obj !== "undefined") {
      $("html, body").animate(
        {
          scrollTop:
            $(
              '[data-scroll-id="#' +
                wps_ubo_lite_offer_section_obj.value.value +
                '"]'
            ).offset().top - 50,
        },
        "slow"
      );

      // After scrolling remove offer section parameter from url.
      var after_scroll_href = window.location.href;

      if (after_scroll_href.indexOf("&wps-bump-offer-section=") >= 0) {
        var after_scroll_newUrl = after_scroll_href.substring(
          0,
          after_scroll_href.indexOf("&wps-bump-offer-section=")
        );

        window.history.replaceState({}, "", after_scroll_newUrl);
      }
    }

    // Scroll to respective Template section after clicking Yes for Template change.
    if (typeof wps_ubo_lite_template_section_obj !== "undefined") {
      $("html, body").animate(
        {
          scrollTop:
            $(
              '.wps_ubo_template_link[data_link="' +
                wps_ubo_lite_template_section_obj.value.value +
                '"]'
            ).offset().top - 500,
        },
        "slow"
      );

      // After scrolling remove offer section parameter from url.
      var after_scroll_href = window.location.href;

      if (after_scroll_href.indexOf("&wps-bump-template-section=") >= 0) {
        var after_scroll_newUrl = after_scroll_href.substring(
          0,
          after_scroll_href.indexOf("&wps-bump-template-section=")
        );

        window.history.replaceState({}, "", after_scroll_newUrl);
      }
    }

    // Appearance Section JS - start.
    $(".wps-ubo-appearance-template").on("click", function (e) {
      e.preventDefault();

      $(this).addClass("nav-tab-active");
      $(".wps-ubo-appearance-design").removeClass("nav-tab-active");
      $(".wps-ubo-appearance-text").removeClass("nav-tab-active");

      $(".wps-ubo-template-section").removeClass(
        "wps-ubo-appearance-section-hidden"
      );
      $(".wps_upsell_table_column_wrapper").addClass(
        "wps-ubo-appearance-section-hidden"
      );
      $(".wps-ubo-text-section").addClass("wps-ubo-appearance-section-hidden");
    });

    $(".wps-ubo-appearance-design").on("click", function (e) {
      e.preventDefault();

      $(this).addClass("nav-tab-active");
      $(".wps-ubo-appearance-text").removeClass("nav-tab-active");
      $(".wps-ubo-appearance-template").removeClass("nav-tab-active");

      $(".wps-ubo-template-section").addClass(
        "wps-ubo-appearance-section-hidden"
      );
      $(".wps_upsell_table_column_wrapper").removeClass(
        "wps-ubo-appearance-section-hidden"
      );
      $(".wps-ubo-text-section").addClass("wps-ubo-appearance-section-hidden");
    });

    $(".wps-ubo-appearance-text").on("click", function (e) {
      e.preventDefault();

      $(this).addClass("nav-tab-active");
      $(".wps-ubo-appearance-design").removeClass("nav-tab-active");
      $(".wps-ubo-appearance-template").removeClass("nav-tab-active");

      $(".wps-ubo-template-section").addClass(
        "wps-ubo-appearance-section-hidden"
      );
      $(".wps_upsell_table_column_wrapper").addClass(
        "wps-ubo-appearance-section-hidden"
      );
      $(".wps-ubo-text-section").removeClass(
        "wps-ubo-appearance-section-hidden"
      );
    });
    // Appearance Section JS - End.

    // Available Template preview - Start.

    var temp_id;

    $(".wps_ubo_template_link").on("click", function (e) {
      e.preventDefault();
      temp_id = $(this).attr("data_link");
      $(".wps_ubo_skin_popup_wrapper").css("display", "flex");
    });

    // On yes, reset the css
    $(".wps_ubo_template_layout_yes").on("click", function (e) {
      // Template chnage css and design.

      e.preventDefault();
      $(".wps_ubo_template").val(temp_id);
      $(".wps_ubo_selected_template").val(temp_id);
      $(".wps_ubo_animation_loader").css("display", "flex");

      // For Scroll back.
      var href_bump_current_url = window.location.href;
      href_bump_current_url += "&wps-bump-template-section=" + temp_id;
      window.history.replaceState({}, "", href_bump_current_url);

      $("#wps_upsell_bump_creation_setting_save").click();
      $(".wps_ubo_skin_popup_wrapper").css("display", "none");
    });

    // On No, do nothing.
    $(".wps_ubo_template_layout_no").on("click", function (e) {
      e.preventDefault();
      $(".wps_ubo_skin_popup_wrapper").css("display", "none");
    });

    // Onclick outside the popup close the popup.
    $("body").click(function (e) {
      if (e.target.className == "wps_ubo_skin_popup_wrapper") {
        $(".wps_ubo_skin_popup_wrapper").hide();
      }
    });

    // Available Template preview - Ends.

    // Text Fields Preview.
    $(".wps_upsell_offer_input_type").on("change paste keyup", function () {
      var text_id = $(this).attr("text_id");
      var msg = ""; // Check which field in changed
      var price = $(".offer_shown_discount").val().split("+");

      if (text_id == "fixed") {

        if (price[1] == "fixed") {
          var fixed = "$" + price[0];
          var string = $(this).val();
          if (price[0] == 0) {
            fixed = "$" + $(".bump_price_at_zero").val();
          }

          msg = string.replace("{dc_price}", fixed);
          $(".wps_upsell_offer_discount_section h3").html(msg);
          $(".wps-ubo__temp-prod-offer").html(msg);
          $(".wps-ob-st__m-title").html(msg);
          $(".bump-offer-title").html(msg);
          $(".wps-ob_ta-offer").html(msg);
        }
      }

      if (text_id == "percent") {

        if (price[1] == "%") {
          var percent = price[0] + "%";
          var string = $(this).val();
          msg = string.replace("{dc_%}", percent);
          $(".wps_upsell_offer_discount_section h3").html(msg);
          $(".wps-ubo__temp-prod-offer").html(msg);
          $(".wps-ob-st__m-title").html(msg);
          $(".bump-offer-title").html(msg);

          $(".wps-ob_ta-offer").html(msg);
        }
      }

      if (text_id == "lead") {
        // Lead Title Text.

        msg = $(this).val();
        $(".wps_upsell_offer_primary_section h5").html(msg);
        $(".wps-ubo__temp-head h3").html(msg);
        $(".wps_head_check_ubo span").html(msg);
        $(".wps_accetp_offer_title").html(msg);
        $(".wps-ob_ta-o-title").html(msg);
      }
    });

    // Textarea Fields Preview.
    $(".wps_textarea_class").on("change paste keyup", function () {
      var text_id = $(this).attr("text_id");
      var msg = "";

      if (text_id == "off_desc") {
        // Offer Description.

        msg = $(this).val();
        $(".wps_upsell_offer_secondary_section").show();
        $(".wps_upsell_offer_secondary_section p").html(msg);
        $(".wps-ubo__temp-desc").html(msg);
        $(".wps-ob-st__m-c-p").html(msg);
        $(".wps-ob_ta-o-desc").html(msg);
      }

      if (text_id == "pro_desc") {
        // Product Description.

        msg = $(this).val();
        $(".wps_upsell_offer_product_description").html(msg);
        $(".bump-offer-product-description").html(msg);
        $(".wps-ob_ta-p-desc").html(msg);
      }
    });

    // Live Preview JS start.

    // Border Styling.
    var BumpOfferBox = $(".wps_upsell_offer_parent_wrapper");
    var border_type = "";
    var border_color = "";
    var border_size = "";
    var background_color = "";

    $(".wps_ubo_preview_select_border_type").on("change", function () {
      wps_ubo_apply_border_styling();
    });

    var Bordercolorpicker = $(".wps_ubo_preview_select_border_color");

    Bordercolorpicker.wpColorPicker({
      change: (event, ui) => {
        border_color = ui.color.toString();
        wps_ubo_apply_border_styling(border_color);
      },
    });

    // Background color.
    var Backgroundcolorpicker = $(".wps_ubo_preview_select_background_color");

    Backgroundcolorpicker.wpColorPicker({
      change: (event, ui) => {
        background_color = ui.color.toString();

        wps_ubo_apply_background_color_styling(background_color);
      },
    });

    // Vertical spacing stylings.
    var BumpOfferBoxMain = $(".wps_upsell_offer_main_wrapper");
    var VerticalSpacingTop = "";
    var VerticalSpacingBottom = "";

    $(".wps_ubo_top_vertical_spacing_slider").on("change", function () {
      VerticalSpacingTop = $(this).val();
      BumpOfferBoxMain.css("padding-top", VerticalSpacingTop + "px");

      $(".wps_ubo_top_spacing_slider_size").html(VerticalSpacingTop + "px");
    });

    $(".wps_ubo_bottom_vertical_spacing_slider").on("change", function () {
      VerticalSpacingBottom = $(this).val();
      BumpOfferBoxMain.css("padding-bottom", VerticalSpacingBottom + "px");

      $(".wps_ubo_bottom_spacing_slider_size").html(
        VerticalSpacingBottom + "px"
      );
    });

    // Discount Section stylings.
    var DiscountSection = $(".wps_upsell_offer_discount_section");
    var DiscountSectionH3 = $(".wps_upsell_offer_discount_section h3");
    var discount_bcolor = "";
    var discount_tcolor = "";
    var discount_tsize = "";

    var DiscountBcolorpicker = $(".wps_ubo_select_discount_bcolor");

    DiscountBcolorpicker.wpColorPicker({
      change: (event, ui) => {
        discount_bcolor = ui.color.toString();

        DiscountSection.css("background-color", discount_bcolor);
        $(".wps-ubo__temp-prod-offer").css("background-color", discount_bcolor);
        $(".wps-ob-st__m-title").css("background-color", discount_bcolor);
        $(".bump-offer-title").css("background-color", discount_bcolor);
        $(".wps-ob_ta-offer").css("background-color", discount_bcolor);
      },
    });

    var DiscountTcolorpicker = $(".wps_ubo_select_discount_tcolor");

    DiscountTcolorpicker.wpColorPicker({
      change: (event, ui) => {
        discount_tcolor = ui.color.toString();

        DiscountSectionH3.css("color", discount_tcolor);
        $(".wps-ubo__temp-prod-offer").css("color", discount_tcolor);
        $(".wps-ob-st__m-title").css("color", discount_tcolor);
        $(".bump-offer-title").css("color", discount_tcolor);
        $(".wps-ob_ta-offer").css("color", discount_tcolor);
      },
    });

    $(".wps_ubo_discount_slider").on("change", function () {
      discount_tsize = $(this).val();
      DiscountSectionH3.css("font-size", discount_tsize + "px");
      $(".wps-ob-st__m-title").css("font-size", discount_tsize + "px");
      $(".bump-offer-title").css("font-size", discount_tsize + "px");
      $(".wps_ubo_discount_slider_size").html(discount_tsize + "px");
      $(".bump-offer-title").css("font-size", discount_tsize + "px");
      $(".wps-ob_ta-offer").css("font-size", discount_tsize + "px");
    });

    // Product Section stylings.
    var ProductSectionP = $(
      ".wps_upsell_offer_product_section .wps_upsell_offer_product_description"
    ); // 2.1.7.
    var ProductDesSectionP = $(".upsell-product-info .upsell-product-desc p"); // 2.1.7.
    var ProductPriceColor = $(".wps_upsell_offer_product_price"); // 2.1.7.
    var ProductQty = $(".upsell-offer-template-2 .quantity"); // 2.1.7.
    var ProductpriceP = $(".wps_upsell_offer_product_price p");
    var Productpricedel = $(".wps_upsell_offer_product_price del");
    var Productpriceins = $(".wps_upsell_offer_product_price ins");
    var ProductSectionH4 = $(".wps_upsell_offer_product_section h4");
    var ProductSectionImg = $(".wps_upsell_offer_img");
    var product_tcolor = "";
    var product_tsize = "";
    var product_img_width = "";
    var product_img_height = "";

    var ProductTcolorpicker = $(".wps_ubo_select_product_tcolor");

    var ProductTcolorPricepicker = $(".wps_ubo_select_product_price_tcolor"); // 2.1.7.
    var ProductHeadingH4 = $(".upsell-product-info h4"); // 2.1.7.

    ProductTcolorpicker.wpColorPicker({
      change: (event, ui) => {
        product_tcolor = ui.color.toString();

        ProductSectionP.css("color", product_tcolor);
        ProductSectionH4.css("color", product_tcolor);
        ProductpriceP.css("color", product_tcolor);
        ProductDesSectionP.css("color", product_tcolor); // 2.1.7.
        ProductHeadingH4.css("color", product_tcolor); // 2.1.7.

        $(".wps-ubo__temp-prod-desc").css("color", product_tcolor);
        $(".wps-ob-st__m-c-p").css("color", product_tcolor);
        $(".bump-offer-product-description").css("color", product_tcolor);
        $(".wps-ob_ta-p-desc").css("color", product_tcolor);
      },
    });

    ProductTcolorPricepicker.wpColorPicker({
      // 2.1.7.
      change: (event, ui) => {
        product_tcolor = ui.color.toString();
        ProductPriceColor.css("color", product_tcolor);
        ProductQty.css("color", product_tcolor);
        $(".wps-ubo__temp-prod-price-new").css("color", product_tcolor);
        $(".wps-ob-st__m-c-price").css("color", product_tcolor);
        $(".wps-ob_ta-p-price").css("color", product_tcolor);
      },
    });

    $(".wps_ubo_product_price_slider").on("change", function () {
      // 2.1.7
      product_tsize = $(this).val();
      ProductpriceP.css("font-size", product_tsize + "px");
      Productpricedel.css("font-size", product_tsize + "px");
      Productpriceins.css("font-size", product_tsize + "px");
      ProductQty.css("font-size", product_tsize + "px");
      $(".wps-ob-st__m-c-price").css("font-size", product_tsize + "px");
      $(".bump-offer-product-price").css("font-size", product_tsize + "px");
      $(".wps_ubo_product_price_slider_size").html(product_tsize + "px"); // 2.1.7.
      $(".wps-ob_ta-p-price").css("font-size", product_tsize + "px");
    });

    $(".wps_ubo_product_slider").on("change", function () {
      product_tsize = $(this).val();
      ProductDesSectionP.css("font-size", product_tsize + "px"); // 2.1.7.
      ProductHeadingH4.css("font-size", product_tsize + "px"); // 2.1.7.
      ProductSectionP.css("font-size", product_tsize + "px");
      $(".wps-ob-st__m-c-p").css("font-size", product_tsize + "px");
      $(".bump-offer-product-description").css(
        "font-size",
        product_tsize + "px"
      );
      $(".wps_ubo_product_slider_size").html(product_tsize + "px");
      product_tsize = parseInt(product_tsize) + 10;
      ProductSectionH4.css("font-size", product_tsize + "px");
      $(".wps-ob_ta-p-desc").css("font-size", product_tsize + "px");
    });

    $(".wps_ubo_product_price_slider").on("change", function () {
      // 2.1.7.
      product_tsize = $(this).val();
      $(".wps_ubo_product_price_slider_size").html(product_tsize + "px");
    });

    $(".wps_ubo_product_img_height_slider").on("change", function () {
      product_img_height = $(this).val();
      ProductSectionImg.css("height", product_img_height + "px");
      $(".wps-ob_ta-p-img").css("height", product_img_height + "px");

      $(".wps_ubo_product_slider_height").html(product_img_height + "px");
    });

    $(".wps_ubo_product_img_width_slider").on("change", function () {
      product_img_width = $(this).val();
      ProductSectionImg.css("width", product_img_width + "px");
      $(".wps-ob_ta-p-img").css("width", product_img_width + "px");

      $(".wps_ubo_product_slider_width").html(product_img_width + "px");
    });

    // Accept Offer Section stylings.
    var AcceptOfferSection = $(".wps_upsell_offer_primary_section");
    var AcceptOfferSectionH5 = $(".wps_upsell_offer_primary_section h5");
    var AcceptOfferSectionA = $(".wps_upsell_offer_primary_section svg");
    var AcceptOffer_tcolor = "";
    var AcceptOffer_tsize = "";
    var AcceptOffer_bcolor = "";

    var AcceptOfferBcolorpicker = $(".wps_ubo_select_accept_offer_bcolor");
    var AcceptOfferTcolorpicker = $(".wps_ubo_select_accept_offer_tcolor");
    var AcceptOfferAcolorpicker = $(".wps_ubo_select_accept_offer_acolor");

    AcceptOfferBcolorpicker.wpColorPicker({
      change: (event, ui) => {
        AcceptOffer_bcolor = ui.color.toString();

        AcceptOfferSection.css("background-color", AcceptOffer_bcolor);
        $(".wps-ubo__temp-title").css("background-color", AcceptOffer_bcolor);
        $(".wps-ob-st__head").css("background-color", AcceptOffer_bcolor);
        $(".bump-offer-checkbox").css("background-color", AcceptOffer_bcolor);
        $(".wps-ob_ta-o-title").css("background-color", AcceptOffer_bcolor);
      },
    });

    AcceptOfferTcolorpicker.wpColorPicker({
      change: (event, ui) => {
        AcceptOffer_tcolor = ui.color.toString();

        AcceptOfferSectionH5.css("color", AcceptOffer_tcolor);
        $(".wps-ubo__temp-title").css("color", AcceptOffer_tcolor);
        $(".wps-ob-st__head").css("color", AcceptOffer_tcolor);
        $(".wps_accetp_offer_title").css(
          "color",
          AcceptOffer_tcolor,
          "important"
        );
        $(".wps-ob_ta-o-title").css("color", AcceptOffer_tcolor, "important");
      },
    });

    AcceptOfferAcolorpicker.wpColorPicker({
      change: (event, ui) => {
        AcceptOffer_tcolor = ui.color.toString();

        AcceptOfferSectionA.css("fill", AcceptOffer_tcolor);
        $(".wps_upsell_offer_arrow svg").css("fill", AcceptOffer_tcolor);
      },
    });

    $(".wps_ubo_accept_offer_slider").on("change", function () {
      AcceptOffer_tsize = $(this).val();
      AcceptOfferSectionH5.css("font-size", AcceptOffer_tsize + "px");
      $(".wps-ob-st__head").css("font-size", AcceptOffer_tsize + "px");
      $(".wps-ubo__temp-title").css("font-size", AcceptOffer_tsize + "px");
      $(".wps_ubo_accept_offer_slider_size").html(AcceptOffer_tsize + "px");
      $(".wps_accetp_offer_title").css("font-size", AcceptOffer_tsize + "px");
      $(".wps-ob_ta-o-title").css("font-size", AcceptOffer_tsize + "px");
    });

    // Offer Description Section stylings.
    var OfferDescriptionSection = $(".wps_upsell_offer_secondary_section");
    var OfferDescriptionSectionP = $(".wps_upsell_offer_secondary_section p");
    var OfferDescription_tcolor = "";
    var OfferDescription_tsize = "";
    var OfferDescription_bcolor = "";

    var OfferDescriptionBcolorpicker = $(
      ".wps_ubo_select_offer_description_bcolor"
    );
    var OfferDescriptionTcolorpicker = $(
      ".wps_ubo_select_offer_description_tcolor"
    );

    OfferDescriptionBcolorpicker.wpColorPicker({
      change: (event, ui) => {
        OfferDescription_bcolor = ui.color.toString();

        OfferDescriptionSection.css(
          "background-color",
          OfferDescription_bcolor
        );
        $(".wps-ubo__temp-desc").css(
          "background-color",
          OfferDescription_bcolor
        );
      },
    });

    OfferDescriptionTcolorpicker.wpColorPicker({
      change: (event, ui) => {
        OfferDescription_tcolor = ui.color.toString();

        OfferDescriptionSectionP.css("color", OfferDescription_tcolor);

        $(".wps-ubo__temp-desc").css("color", OfferDescription_tcolor);
        $(".wps-ob_ta-o-desc").css("color", OfferDescription_tcolor);
      },
    });

    $(".wps_ubo_offer_description_slider").on("change", function () {
      OfferDescription_tsize = $(this).val();
      OfferDescriptionSectionP.css("font-size", OfferDescription_tsize + "px");

      $(".wps-ubo__temp-desc").css("font-size", OfferDescription_tsize + "px");
      $(".wps-ob_ta-o-desc").css("font-size", OfferDescription_tsize + "px");

      $(".wps_ubo_offer_description_slider_size").html(
        OfferDescription_tsize + "px"
      );
    });

    /* Local defined functions */

    // Apply Border stylings.
    function wps_ubo_apply_border_styling(border_color = "") {
      border_type = $(".wps_ubo_preview_select_border_type").val();

      if (border_color == "") {
        border_color = $(".wps_ubo_preview_select_border_color").val();
      }

      if ("double" == border_type) {
        border_size = "4px";
      } else {
        border_size = "2px";
      }

      BumpOfferBox.css(
        "border",
        border_type + " " + border_color + " " + border_size
      );
    }

    // Apply Background color stylings.
    function wps_ubo_apply_background_color_styling(background_color = "") {
      background_color = $(".wps_ubo_preview_select_background_color").val();

      $(".wps_upsell_offer_wrapper").css("background-color", background_color);
      $(".wps-ob-st").css("background-color", background_color);
      $(".wps-ob_temp-alpha-wrap").css("background-color", background_color);
    }

    // Live Preview JS end.
  });
})(jQuery);

// Basic JS.
jQuery(document).ready(function ($) {
  // Reflect bump name input value.
  $("#wps_upsell_bump_name").on("change paste keyup", function () {
    $("#wps_upsell_bump_name_heading h2").text($(this).val());
  });

  // Bump status Live <->  Sandbox.
  $("#wps_upsell_bump_status_input").click(function () {
    if (true === this.checked) {
      $(".wps_upsell_bump_status_on").addClass("active");
      $(".wps_upsell_bump_status_off").removeClass("active");
    } else {
      $(".wps_upsell_bump_status_on").removeClass("active");
      $(".wps_upsell_bump_status_off").addClass("active");
    }
  });

  // Save Bump Offer product as soon as Offer product is added.
  $(".wps_upsell_offer_product").on("change", function () {
    // Show loading icon.
    $(".wps_ubo_animation_loader").css("display", "flex");

    /**
     * Append offer section parameter in current url, so after form submit we can scroll back to
     * the current respective offer section.
     */
    var href_bump_current_url = window.location.href;
    href_bump_current_url += "&wps-bump-offer-section=offer-section-1";
    window.history.replaceState({}, "", href_bump_current_url);

    // Click button to save the bump.
    $("#wps_upsell_bump_creation_setting_save").click();
  });

  // Reflect bump name input value.
  $(".wps_upsell_offer_input_type").on("change paste keyup", function () {
    if ("%" == $("#wps_upsell_offer_price_type_id").val()) {
      if ($(this).val() > 100) {
        $(this).val(100);
      }
    }
  });

  /**
   * Scripts after v1.0.2
   */
  $(
    "#wps_ubo_enable_fluentcrm_switch,#wps_ubo_product_offer_strip,#wps_ubo_offer_purchased_earlier,#wps_ubo_enable_popup_exit_intent_switch,#wps_enable_fbt_upsell_feature,#wps_ubo_offer_fbt_location_set,#wps_enable_cart_upsell_location,#wps_ubo_offer_timer,#wps_ubo_offer_product_image_slider,#wps_enable_cart_upsell, #wps_ubo_offer_replace_target, #wps_ubo_offer_global_funnel, #wps_ubo_offer_exclusive_limit, #wps_ubo_offer_meta_forms, #wps_enable_red_arrow_feature,.wps_bump_offer_popup_case ,#wps_ubo_offer_restrict_coupons, #wps_ubo_offer_ab_method,#wps_upsell_bump_priority,#wps_upsell_bump_min_cart, #wps_upsell_bump_min_cart,#wps_ubo_img_width_slider_pop_up,#wps_ubo_img_height_slider_pop_up,#wps_ubo_select_accept_offer_acolor_pop_up"
  ).on("click", function (e) {
    // Add popup to unlock pro features.
    var pro_status = document.getElementById("wps_ubo_pro_status");
    if (null != pro_status) {
      // Add a popup over here.
      $(this).prop("checked", false);
      $(".wps_ubo_lite_go_pro_popup_wrap").addClass(
        "wps_ubo_lite_go_pro_popup_show"
      );
      $("body").addClass("wps_ubo_lite_go_pro_popup_body");
    }
  });

  $(
    "#wps_ubo_premium_popup_4_template,#wps_ubo_premium_popup_3_template,#wps_ubo_premium_popup_5_template,#wps_ubo_premium_popup_6_template,#wps_ubo_premium_popup_7_template,#wps_ubo_premium_popup_8_template,#wps_ubo_premium_popup_9_template"
  ).on("click", function (e) {
    // Add popup to unlock pro features.
    var pro_status = document.getElementById("wps_ubo_pro_status");
    if (null != pro_status) {
      // Add a popup over here.
      $(this).prop("checked", false);
      $(".wps_ubo_lite_go_pro_popup_wrap_template").addClass(
        "wps_ubo_lite_go_pro_popup_show"
      );
      $("body").addClass("wps_ubo_lite_go_pro_popup_body");
    }
  });

  // If org is updated but pro is not.
  jQuery("#wps_ubo_offer_purchased_earlier").on("click", function (e) {
    var is_update_needed = jQuery("#is_pro_update_needed").val();

    if ("true" == is_update_needed) {
      jQuery(this).prop("checked", false);
      jQuery(".wps_ubo_update_popup_wrapper").addClass(
        "wps_ubo_lite_update_popup_show"
      );
      jQuery("body").addClass("wps_ubo_lite_go_pro_popup_body");
    }
  });

  // If org is updated but pro is not.
  jQuery("#wps_ubo_offer_exclusive_limit").on("change", function (e) {
    var show_limit = jQuery(this).prop("checked");

    if (true == show_limit) {
      jQuery(".wps-ubo-offer-exclusive-limit-wrap").removeClass("keep-hidden");
    } else {
      jQuery(".wps-ubo-offer-exclusive-limit-wrap").addClass("keep-hidden");
    }
  });

  // Onclick outside the div close for Update popup.
  jQuery("body").click(function (e) {
    if (
      e.target.className ==
      "wps_ubo_update_popup_wrapper wps_ubo_lite_update_popup_show"
    ) {
      jQuery(".wps_ubo_update_popup_wrapper").removeClass(
        "wps_ubo_lite_update_popup_show"
      );
      jQuery("body").removeClass("wps_ubo_lite_go_pro_popup_body");
    }
  });

  // Close popup on clicking buttons.
  jQuery(".wps_ubo_update_yes, .wps_ubo_update_no").click(function (e) {
    jQuery(".wps_ubo_update_popup_wrapper").removeClass(
      "wps_ubo_lite_update_popup_show"
    );
    jQuery("body").removeClass("wps_ubo_lite_go_pro_popup_body");
  });

  // If org is new and pro is old. Then folder will be unavailable at that time.
  var new_attr = "";
  var template_data_link = "";
  var template_data_link_id = "";

  wps_ubo_change_template_img_src("1");
  wps_ubo_change_template_img_src("2");
  wps_ubo_change_template_img_src("3");

  // For update popup at creation file.
  jQuery(".wps_ubo_skin_popup_head img").attr("src", function (index, attr) {
    new_attr = attr.replace("Icons", "icons");
    return new_attr;
  });

  function wps_ubo_change_template_img_src(template_data_link_id = false) {
    if (false == template_data_link_id) {
      return;
    }

    template_data_link = $(
      "a.wps_ubo_template_link[data_link=" + template_data_link_id + "] img"
    );

    jQuery(template_data_link).attr("src", function (index, attr) {
      if ("1" == template_data_link_id) {
        new_attr = attr.replace(
          "Offer%20templates/Template" + template_data_link_id,
          "offer-templates/template-" + template_data_link_id
        );
      } else {
        new_attr = attr.replace(
          "Offer templates/Template" + template_data_link_id,
          "offer-templates/template-" + template_data_link_id
        );
      }

      return new_attr;
    });
  }

  // No text is present in the container.
  var exisiting_text = "";
  exisiting_text = $(".wps_upsell_offer_secondary_section").text();

  if ("" == exisiting_text) {
    // Hide if no content is present.
    $(".wps_upsell_offer_secondary_section").hide();
  }

  /**
   * Custom Image setup.
   * Wordpress image upload.
   */
  jQuery(function ($) {
    /*
     * Select/Upload image(s) event.
     */
    jQuery("body").on("click", ".wps_ubo_upload_image_button", function (e) {
      e.preventDefault();
      var button = jQuery(this),
        custom_uploader = wp
          .media({
            title: "Insert image",
            library: {
              type: "image",
            },
            button: {
              text: "Use this image",
            },
            multiple: false,
          })
          .on("select", function () {
            var attachment = custom_uploader
              .state()
              .get("selection")
              .first()
              .toJSON();
            jQuery(button)
              .removeClass("button")
              .html(
                '<img class="true_pre_image" src="' +
                  attachment.url +
                  '" style="max-width:150px;display:block;" />'
              )
              .next()
              .val(attachment.id)
              .next()
              .show();
          })
          .open();
    });

    /*
     * Remove image event.
     */
    jQuery("body").on("click", ".wps_ubo_remove_image_button", function (e) {
      e.preventDefault();
      jQuery(this)
        .hide()
        .prev()
        .val("")
        .prev()
        .addClass("button")
        .html("Upload image");
      return false;
    });
  });

  var wps_selected_template_id = $("#wps_templete_select_id").val();
  if (
    6 == wps_selected_template_id ||
    7 == wps_selected_template_id ||
    8 == wps_selected_template_id ||
    9 == wps_selected_template_id
  ) {
    $(".wps_new_template_pro").hide();
  }
  if (6 == wps_selected_template_id) {
    $("#wps_upsell_offer_main_id_").addClass("wps-hybrid");
    $("#wps_upsell_offer_main_id_").removeClass("wps-horizontal-ltr");
    $("#wps_upsell_offer_main_id_").removeClass("wps-horizontal-rtl");
    $("#wps_upsell_offer_main_id_").removeClass("wps-verticle");
  }
  if (7 == wps_selected_template_id) {
    $("#wps_upsell_offer_main_id_").removeClass("hybrid");
    $("#wps_upsell_offer_main_id_").addClass("wps-horizontal-ltr");
    $("#wps_upsell_offer_main_id_").removeClass("wps-horizontal-rtl");
    $("#wps_upsell_offer_main_id_").removeClass("wps-verticle");
  }
  if (8 == wps_selected_template_id) {
    $("#wps_upsell_offer_main_id_").removeClass("hybrid");
    $("#wps_upsell_offer_main_id_").removeClass("wps-horizontal-ltr");
    $("#wps_upsell_offer_main_id_").addClass("wps-horizontal-rtl");
    $("#wps_upsell_offer_main_id_").removeClass("wps-verticle");
  }
  if (9 == wps_selected_template_id) {
    $("#wps_upsell_offer_main_id_").removeClass("hybrid");
    $("#wps_upsell_offer_main_id_").removeClass("wps-horizontal-ltr");
    $("#wps_upsell_offer_main_id_").removeClass("wps-horizontal-rtl");
    $("#wps_upsell_offer_main_id_").addClass("wps-verticle");
  }
  $(".wps_hide_checkbox").hide();
  // End of js.
});
//Banner Image.
jQuery(document).ready(function ($) {
  $(document).on("click", "#dismiss-banner", function (e) {
    e.preventDefault();
    var data = {
      action: "wps_sfw_dismiss_notice_banner",
      wps_nonce: wps_ubo_lite_banner_offer_section_obj.auth_nonce,
    };
    $.ajax({
      url: wps_ubo_lite_banner_offer_section_obj.ajaxurl,
      type: "POST",
      data: data,
      success: function (response) {
        window.location.reload();
      },
    });
  });
});

jQuery(document).ready(function () {
  // Function to validate the form on submission
  function wps_validate_quantity(event) {
    const wps_quantity_setting = document.querySelector(
      "#wps_ubo_enable_switch"
    );

    if (wps_quantity_setting.checked) {
      // Get the select element by its ID
      var wps_select_element = document.getElementById(
        "wps_upsell_offer_quantity_type_id"
      );

      // Get the selected option's value
      var wps_selected_value = wps_select_element.value;

      if ("variable_q" == wps_selected_value) {
        // Get the minimum and maximum input elements by their names.
        const wps_mini_input = document.querySelector(
          'input[name="wps_upsell_bump_offer_min_q"]'
        );
        const wps_max_input = document.querySelector(
          'input[name="wps_upsell_bump_offer_max_q'
        );

        const wps_min_quantity = parseInt(wps_mini_input.value, 10);
        const wps_max_quantity = parseInt(wps_max_input.value, 10);

        if (wps_min_quantity >= wps_max_quantity) {
          event.preventDefault(); // Prevent the form from submitting.
          alert("Minimum quantity must be less than the maximum quantity.");
        }

        if (wps_max_quantity <= wps_min_quantity) {
          event.preventDefault(); // Prevent the form from submitting
          alert("Maximum quantity must be greater than the minimum quantity.");
        }
      }
    }
  }

  setTimeout(function () {
    //For the new template 10 js.
    var wps_ob_con = jQuery(".wps-ob-st");
    if (wps_ob_con.width() < 700) {
    }
  }, 1000);
});

jQuery(document).ready(function () {
  const newdata = wps_ubo_lite_banner_offer_section_obj.wps_all_order_bump_data;
  // Loop with forEach
  Object.entries(newdata).forEach(([key, bump]) => {
    const el = document.getElementById(`myPieChart${key}`);
    if (!el) {
      return; // skip this iteration
    }
    const ctx = el.getContext("2d");
    const wps_conversion_rate = bump.offer_view_count
      ? ((bump.bump_success_count / bump.offer_view_count) * 100).toFixed(2)
      : 0;

    const views = Number(bump.offer_view_count) || 0;
    const success = Number(bump.bump_success_count) || 0;
    const accepts = Number(bump.offer_accept_count) || 0;
    const sales = Number(bump.bump_total_sales) || 0;
    // skip if ALL metrics are zero/falsy.
    if ([views, success, accepts, sales].every((v) => !v)) return;

    // Data to display in the chart
    const chartData = {
      labels: [
        "View Count",
        "Success Count",
        "Offer Accept Count",
        "Offer Remove Count",
        "Conversion Rate",
        "Total Sales",
      ],
      datasets: [
        {
          label: bump.label,
          data: [
            bump.offer_view_count || 0,
            bump.bump_success_count || 0,
            bump.offer_accept_count || 0,
            bump.offer_remove_count || 0,
            wps_conversion_rate,
            bump.bump_total_sales || 0,
          ],
          backgroundColor: [
            "#FF638499",
            "#36A2EB99",
            "#FFCE5699",
            "#4BC0C099",
            "#9966FF99",
            "#8AFF3399",
          ],
          borderColor: [
            "#CC204D",
            "#1E75BB",
            "#E6B800",
            "#008B8B",
            "#5A2D9D",
            "#4CAF00",
          ],
          borderWidth: 2,
          hoverBorderWidth: 3,

          // Pop-out effect: offset the hovered slice.
          offset: (ctx) => (ctx.active ? 12 : 0),
        },
      ],
    };

    // Configuration for Pie chart
    const config = {
      type: "pie",
      data: chartData,
      options: {
        responsive: true,
        animation: {
          duration: 1000,
          easing: "easeOutBounce",
        },
        plugins: {
          legend: {
            position: "top",
            labels: {
              usePointStyle: true,
            },
          },
        },
        onClick: function (evt) {
          const chart = this;
          const activePoints = chart.getElementsAtEventForMode(
            evt,
            "nearest",
            { intersect: true },
            true
          );
          if (activePoints.length) {
            const firstPoint = activePoints[0];
            const label = chart.data.labels[firstPoint.key];
            const value =
              chart.data.datasets[firstPoint.datasetIndex].data[firstPoint.key];
          }
        },
      },
    };

    // Create the Pie chart
    new Chart(ctx, config);

    // Toggle functionality for Show/Hide.
    const toggleButton = document.getElementById("toggleButton" + key);
    const chartContainer = document.getElementById("chartContainer" + key);

    toggleButton.addEventListener("click", function () {
      chartContainer.classList.toggle("collapsed");
      const isCollapsed = chartContainer.classList.contains("collapsed");
      toggleButton.innerText = isCollapsed
        ? "Hide Chart"
        : "Show Chart For " + bump.wps_upsell_bump_name;
    });
  });
});

jQuery(document).ready(function () {
  const newdata = wps_ubo_lite_banner_offer_section_obj.wps_post_funnels_list;

  // Loop with forEach
  Object.entries(newdata).forEach(([key, bump]) => {
    const el = document.getElementById(`wps-post-myPieChart${key}`);
    if (!el) {
      return; // skip this iteration.
    }
    const ctx = el.getContext("2d");

    const views = Number(bump.offers_view_count) || 0;
    const success = Number(bump.funnel_success_count) || 0;
    const accepts = Number(bump.offers_accept_count) || 0;
    const sales = Number(bump.funnel_total_sales) || 0;
    // skip if ALL metrics are zero/falsy.
    if ([views, success, accepts, sales].every((v) => !v)) return;

    const wps_conversion_rate = bump.funnel_triggered_count
      ? (
          (bump.funnel_success_count / bump.funnel_triggered_count) *
          100
        ).toFixed(2)
      : 0;

    const wps_offers_pending_count =
      views - accepts - (bump.offers_reject_count || 0);

    // Data to display in the chart
    const chartData = {
      labels: [
        "Trigger Count",
        "Success Count",
        "Offers Viewed",
        "Offers Accepted",
        "Offers Rejected",
        "Offers Pending",
        "Conversion Rate",
        "Total Sales",
      ],
      datasets: [
        {
          label: bump.label,
          data: [
            bump.funnel_triggered_count || 0,
            bump.funnel_success_count || 0,
            bump.offers_view_count || 0,
            bump.offers_accept_count || 0,
            bump.offers_reject_count || 0,
            wps_offers_pending_count || 0,
            wps_conversion_rate || 0,
            bump.funnel_total_sales || 0,
          ],
          backgroundColor: [
            "#FF638499",
            "#36A2EB99",
            "#FFCE5699",
            "#4BC0C099",
            "#9966FF99",
            "#FF9F4099",
            "#8AFF3399",
            "#FF33F6",
          ],
          borderColor: [
            "#CC204D",
            "#1E75BB",
            "#E6B800",
            "#008B8B",
            "#5A2D9D",
            "#CC5500",
            "#4CAF00",
            "#CC0099",
          ],
          borderWidth: 2,
          hoverBorderWidth: 3,

          // Pop-out effect: offset the hovered slice.
          offset: (ctx) => (ctx.active ? 12 : 0),
        },
      ],
    };

    // Configuration for Pie chart
    const config = {
      type: "pie",
      data: chartData,
      options: {
        responsive: true,
        animation: {
          duration: 1000,
          easing: "easeOutBounce",
        },
        plugins: {
          legend: {
            position: "top",
            labels: {
              usePointStyle: true,
            },
          },
        },
        onClick: function (evt) {
          const chart = this;
          const activePoints = chart.getElementsAtEventForMode(
            evt,
            "nearest",
            { intersect: true },
            true
          );
          if (activePoints.length) {
            const firstPoint = activePoints[0];
            const label = chart.data.labels[firstPoint.key];
            const value =
              chart.data.datasets[firstPoint.datasetIndex].data[firstPoint.key];
          }
        },
      },
    };

    // Create the Pie chart
    new Chart(ctx, config);

    // Toggle functionality for Show/Hide
    const toggleButton = document.getElementById("wps-post-toggleButton" + key);
    const chartContainer = document.getElementById(
      "wps-post-chartContainer" + key
    );
    var wps_funnel_name = "";
    if (wps_ubo_lite_banner_offer_section_obj.is_pro_active) {
      wps_funnel_name = bump.wps_wocuf_pro_funnel_name;
    } else {
      wps_funnel_name = bump.wps_wocuf_funnel_name;
    }

    toggleButton.addEventListener("click", function () {
      chartContainer.classList.toggle("collapsed");
      const isCollapsed = chartContainer.classList.contains("collapsed");
      toggleButton.innerText = isCollapsed
        ? "Hide Chart"
        : "Show Chart For " + wps_funnel_name;
    });
  });
});

// JavaScript to handle popup and AJAX request.
jQuery(document).ready(function($) {
    $('#wps_ubo_open_popup').click(function(e) {
        e.preventDefault();
      $('#wps_ubo_label_popup').addClass('show');
      $('.wps_ubo_popup_wrap').addClass('show');
      $('.wps_ubo_popup_wrap').show();
    });

    // Close the popup when the close button is clicked
    $('#wps_ubo_close_popup').click(function() {
      $('#wps_ubo_label_popup').removeClass('show');
       $('.wps_ubo_popup_wrap').removeClass('show');
    });
  
    $(document).click(function(event) {
        if (!$(event.target).closest('.wps-ubo-popup-content').length && !$(event.target).is('#wps_ubo_open_popup')) {
          $('#wps_ubo_label_popup').removeClass('show'); // Close the popup when clicking outside.
            $('.wps_ubo_popup_wrap').removeClass('show');
        }
    });

// Handle the form submission for creating the label.
$('#wps_ubo_create_label').click(function() {
    var labelName = $('#wps_ubo_label_name').val();
    var labelColor = $('#wps_ubo_label_color').val();

    if (labelName && labelColor) {
        $.ajax({
            url: wps_ubo_lite_banner_offer_section_obj.ajaxurl,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'wps_ubo_create_label',
                wps_ubo_label_name: labelName,
                wps_ubo_label_color: labelColor,
                nonce: wps_ubo_lite_banner_offer_section_obj.nonce
            },
            success: function (response) {
                console.log(response);
                if (response.success) {
                    alert(response.data.message || 'Label created successfully!');
                    $('#wps_ubo_label_popup').removeClass('show');
                    $('.wps_ubo_popup_wrap').hide();
                } else {
                    alert(response.data.message || 'Error creating label. Please try again.');
                }
            },
            error: function () {
                console.log('AJAX error occurred.');
            }
        });
    } else {
        alert('Please provide both label name and color.');
    }
});
  
    const $checkbox = $('#wps_upsell_bump_enable_plugin_span1');
    const $campaignCreate = $('.wps_upsell_bump_campaign_create');

    // Initial check on page load
    if ($checkbox.is(':checked')) {
        $campaignCreate.show();
    } else {
        $campaignCreate.hide();
    }

    // Toggle on change
    $checkbox.on('change', function () {
        if ($(this).is(':checked')) {
            $campaignCreate.show();
        } else {
            $campaignCreate.hide();
        }
    });

});

    jQuery(document).ready(function ($) {
        // Check initial state of the checkbox and toggle button visibility
        toggleDiscountConditionsButton();

        // When checkbox state changes, toggle button visibility
        $('#wps_ubo_condition_show').on('change', function() {
            toggleDiscountConditionsButton();
        });

        // Function to show or hide the button based on checkbox state
        function toggleDiscountConditionsButton() {
            if ($('#wps_ubo_condition_show').prop('checked')) {
                // If checkbox is checked, show the button
                $('#show-discount-conditions').show();
            } else {
                // If checkbox is unchecked, hide the button
                $('#show-discount-conditions').hide();
            }
        }
    });

    jQuery(document).ready(function($) {
    $('.wps_number_validation').on('input', function() {
    let value = $(this).val();

    // Remove alphabets and special chars — keep only digits and one dot
    value = value.replace(/[^0-9.]/g, '');

    // Prevent more than one decimal point
    const parts = value.split('.');
    if (parts.length > 2) {
      value = parts[0] + '.' + parts[1];
    }

    // Prevent negative values
    if (value !== '' && parseFloat(value) < 0) {
      value = '';
    }

    $(this).val(value);
  });
});
