/**
 * Slick Modals - HTML5 and CSS3 Powered Modal Popups
 * ---------------------------------------------------
 * @file      Defines main jQuery plugin
 * @author    Capelle @ Codecanyon
 * @copyright @author
 * @version   5.0
 * @url       https://codecanyon.net/item/slick-modal-css3-powered-popups/12335988
 */
!function(t){"use strict";if(!t||void 0===t)return n("[Slick Modals] No jQuery library detected. Load SlickModals after jQuery has been loaded on the page.");var e={restrict_hideOnUrls:[],restrict_cookieSet:!1,restrict_cookieName:"slickModal-1",restrict_cookieScope:"domain",restrict_cookieDays:"30",restrict_cookieSetClass:"setSmCookie-1",restrict_dateRange:!1,restrict_dateRangeStart:"",restrict_dateRangeEnd:"",restrict_dateRangeServerTime:!0,restrict_dateRangeServerTimeFile:"",restrict_dateRangeServerTimeZone:"Europe/London",restrict_showAfterVisits:1,restrict_showAfterVisitsResetWhenShown:!1,popup_type:"none",popup_delayedTime:"1s",popup_scrollDistance:"400px",popup_scrollHideOnUp:!1,popup_exitShowAlways:!1,popup_autoClose:!1,popup_autoCloseAfter:"5s",popup_openWithHash:!1,popup_redirectOnClose:!1,popup_redirectOnCloseUrl:"",popup_redirectOnCloseTarget:"_blank",popup_redirectOnCloseTriggers:"overlay button",popup_position:"center",popup_animation:"fadeIn",popup_closeButtonEnable:!0,popup_closeButtonStyle:"cancel simple",popup_closeButtonAlign:"right",popup_closeButtonPlace:"outside",popup_closeButtonText:"Close",popup_reopenClass:"open-sm",popup_reopenClassTrigger:"click",popup_reopenStickyButtonEnable:!1,popup_reopenStickyButtonText:"Open popup",popup_enableESC:!0,popup_bodyClass:"",popup_wrapperClass:"",popup_draggableEnable:!1,popup_allowMultipleInstances:!1,popup_css:{width:"480px",height:"auto",background:"#fff",margin:"24px",padding:"24px","animation-duration":"0.4s"},overlay_isVisible:!0,overlay_closesPopup:!0,overlay_animation:"fadeIn",overlay_css:{background:"rgba(0, 0, 0, .8)","animation-duration":"0.4s","animation-delay":"0s"},content_loadViaAjax:!1,content_animate:!1,content_animation:"zoomIn",content_css:{"animation-duration":"0.4s","animation-delay":"0.4s"},page_animate:!1,page_animation:"scale",page_animationDuration:".4s",page_blurRadius:"1px",page_scaleValue:".9",page_moveDistance:"30%",mobile_show:!0,mobile_breakpoint:"480px",mobile_position:"bottomCenter",mobile_css:{width:"100%",height:"auto",background:"#fff",margin:"0",padding:"18px","animation-duration":"0.4s"},callback_beforeInit:t.noop,callback_afterInit:t.noop,callback_beforeOpen:t.noop,callback_afterOpen:t.noop,callback_afterVisible:t.noop,callback_beforeClose:t.noop,callback_afterClose:t.noop,callback_afterHidden:t.noop},s="SlickModals",i="sm-",a="[Slick Modals] ",o=" can be passed into this method.";function n(t){console.log(t)}function p(s,i){this.$el=t(s),this.$wrapper="",this.$overlay="",this.$popup="",this.settings=t.extend(!0,{},e,i),this.autoCloseTimer=null,this.ajaxContentLoaded=0,this._build()}p.prototype={constructor:p,_build:function(){if("true"!==this.$el.attr("data-sm-init"))return this.$el.hide(),n(a+'Element is missing data-sm-init="true" attribute.');this.settings.callback_beforeInit(),this._createParent(),this.settings.overlay_isVisible&&this._createOverlay(),this.settings.popup_reopenStickyButtonEnable&&this._createStickyButton(),this._createPopup(),this.settings.content_animate&&this._contentAnimate(),this._createEvents(),this._checkInitRestrictions()},_createParent:function(){this.$el.wrapAll('<div class="sm-wrapper"></div>'),this.$wrapper=this.$el.parent();var t=this.settings.popup_type,e=0;switch(!0){case"delayed"===t:e=this.settings.popup_delayedTime;break;case"scrolled"===t:e=this.settings.popup_scrollDistance}this.$wrapper.attr({"data-sm-type":t,"data-sm-type-val":e}),this.settings.popup_autoClose&&this.$wrapper.attr({"data-sm-autoClose":"enable","data-sm-autoClose-after":this.settings.popup_autoCloseAfter})},_createOverlay:function(){this.$wrapper.prepend('<div class="sm-overlay"></div>'),this.$overlay=this.$wrapper.children(".sm-overlay"),this.$overlay.attr({"data-sm-animated":!0,"data-sm-close":this.settings.overlay_closesPopup,"data-sm-effect":this.settings.overlay_animation}).css(this.settings.overlay_css)},_createStickyButton:function(){if(""===this.settings.popup_reopenClass)return n(a+'Sticky button must have defined "popup_reopenClass" within the plugin settings.');t("body").append('<div class="sm-sticky-button '+this.settings.popup_reopenClass+'">'+this.settings.popup_reopenStickyButtonText+"</div>")},_createPopup:function(){this.$el.attr("data-sm-init","false").wrapAll('<div class="sm-popup"></div>'),this.$popup=this.$wrapper.children(".sm-popup");var e=t(window).width()<=parseInt(this.settings.mobile_breakpoint),s=null;(s=e?this.settings.mobile_css:this.settings.popup_css)["animation-delay"]=(this.settings.overlay_isVisible?parseFloat(this.settings.overlay_css["animation-duration"])/2:0)+"s",this.$popup.attr({"data-sm-animated":!0,"data-sm-position":e?this.settings.mobile_position:this.settings.popup_position,"data-sm-effect":this.settings.popup_animation}).css(s).prepend(this.settings.popup_closeButtonEnable?'<div class="sm-button" data-sm-button-style="'+this.settings.popup_closeButtonStyle+'" data-sm-button-align="'+this.settings.popup_closeButtonAlign+'" data-sm-button-place="'+this.settings.popup_closeButtonPlace+'" data-sm-button-text="'+this.settings.popup_closeButtonText+'" data-sm-close="true"></div>':"",this.settings.popup_draggableEnable?'<div class="sm-draggable"></div>':""),this._popupPositionCorrect()},_contentAnimate:function(){this.$el.attr({"data-sm-animated":!0,"data-sm-effect":this.settings.content_animation}).css(this.settings.content_css)},_checkInitRestrictions:function(){var e,s,o=this;function p(){return!!o.settings.restrict_cookieSet&&document.cookie.indexOf(o.settings.restrict_cookieName)>-1}function r(){if(!o.settings.restrict_hideOnUrls.length)return!1;for(var t=o.settings.restrict_hideOnUrls,e=0;e<t.length;e++){var s=t[e],i=window.location.pathname;if(s instanceof RegExp&&s.test(i)||"string"==typeof s&&i.indexOf(s)>-1)return!0}return!1}function l(){return!o.settings.mobile_show&&(!o.settings.mobile_show&&t(window).width()<=parseInt(o.settings.mobile_breakpoint))}function c(){var t=parseInt(o.settings.restrict_showAfterVisits);if(t<=1)return!1;var e=i+"visits-"+o.$el.attr("class");if(t>1){var s=localStorage.getItem(e);return null!==s?parseInt(s)===t-1?(o.settings.restrict_showAfterVisitsResetWhenShown&&localStorage.removeItem(e),!1):(localStorage.setItem(e,parseInt(s)+1),!0):(localStorage.setItem(e,"1"),!0)}localStorage.removeItem(e)}function u(t){o.settings.callback_afterInit(),t||o.openPopup()}o.settings.restrict_dateRange?(e=function(t){u(!!(p()||r()||l()||o._activeInstanceExist()||c()||t))},s=function(t){function s(t){var e=new Date(t.split(",")[0]+"T"+t.split(",")[1].replace(" ","")).getTime();return isNaN(e)?n(a+"Invalid date format."):e}var i=s(o.settings.restrict_dateRangeStart),p=s(o.settings.restrict_dateRangeEnd);e(!(t>i&&t<p&&i<p))},o.settings.restrict_dateRangeServerTime&&""!==o.settings.restrict_dateRangeServerTimeFile?t.ajax({url:o.settings.restrict_dateRangeServerTimeFile,type:"POST",data:{timezone:o.settings.restrict_dateRangeServerTimeZone},dataType:"json",success:function(t){s(new Date(t).getTime())},error:function(){n(a+"Ajax request error upon retrieving server time.")}}):s((new Date).getTime())):u(!!(p()||r()||l()||o._activeInstanceExist()||c()))},_activeInstanceExist:function(){return!this.settings.popup_allowMultipleInstances&&t(".sm-wrapper.sm-active").length>0&&(n(a+"Another Slick Modal instance is already active."),!0)},_popupPositionCorrect:function(){var t=this.$popup.attr("data-sm-position");switch(!0){case"center"===t:this.$popup.css("margin","auto");break;case"bottomCenter"===t||"topCenter"===t:this.$popup.css({"margin-left":"auto","margin-right":"auto"});break;case"right"===t||"left"===t:this.$popup.css({"margin-top":"auto","margin-bottom":"auto"})}},_popupCalculateHeight:function(){var e=0;this.$popup.children().not(".sm-button").each(function(){e+=t(this).outerHeight(!0)}),this.$popup.height(e)},_createEvents:function(){var e=this;if(e.$wrapper.find('[data-sm-close="true"]').length>0&&e.$wrapper.find('[data-sm-close="true"]').each(function(){var s=t(this);s.on("click",function(){e.closePopup(),e.settings.popup_redirectOnClose&&e.settings.popup_redirectOnCloseTriggers.indexOf(s.attr("class").replace("sm-",""))>-1&&-1===e.settings.popup_redirectOnCloseTriggers.indexOf("close")&&e._redirectOnClose()})}),""!==e.settings.popup_reopenClass&&t("body").on("click"===e.settings.popup_reopenClassTrigger?"click":"mouseover","."+e.settings.popup_reopenClass,function(s){t(s.target).is("a")&&s.preventDefault(),e.openPopup("instant")}),e.settings.popup_enableESC&&t(window).on("keydown",function(t){27===t.keyCode&&e._wrapperActive()&&e.closePopup()}),e.settings.popup_openWithHash){var s=e.settings.popup_openWithHash,i=!1!==s&&""!==s&&"#"===s.charAt(0);i&&t(window).on("load hashchange",function(){i&&s===window.location.hash&&e.openPopup("instant")})}if(this.settings.popup_draggableEnable){var a,o,n,p,r=r||!1,l=e.$popup,c=isNaN(parseInt(l.css("margin-top")))?0:parseInt(l.css("margin-top")),u=isNaN(parseInt(l.css("margin-left")))?0:parseInt(l.css("margin-left")),d="auto"===l.css("margin"),g=function(t){l.css({top:t.clientY-a+n+"px",left:t.clientX-o+p+"px"})};l.children(".sm-draggable").on("mousedown",function(e){r=!0,a=e.clientY+c,o=e.clientX+u,n=l.offset().top,p=l.offset().left,d&&(l.css("margin","0px"),g(e),d=!1),t(window).on("mousemove",function(t){if(r)return g(t),!1}),t(window).on("mouseup",function(){r=!1})})}},_setCookie:function(){var t=parseInt(this.settings.restrict_cookieDays),e=new Date,s="/";"page"===this.settings.restrict_cookieScope&&(s=window.location.href),e.setTime(e.getTime()+24*t*60*60*1e3),document.cookie=this.settings.restrict_cookieName+"=1; path="+s+"; expires="+(t>0?e.toGMTString():0)},_redirectOnClose:function(){var t=this.settings.popup_redirectOnCloseUrl;""!==t&&t.indexOf("http")>-1?window.open(t,this.settings.popup_redirectOnCloseTarget):n(a+"Redirect URL is empty or not valid.")},_loadContentViaAjax:function(){if(!this.ajaxContentLoaded&&""!==this.settings.content_loadViaAjax){var e=this;t.ajax({url:e.settings.content_loadViaAjax,type:"GET",dataType:"html",success:function(t){e.$el.html(t),e._popupCalculateHeight(),e.ajaxContentLoaded=1},error:function(){n(a+"Ajax request error upon retrieving the content.")}})}},_pageAnimation:function(e){var s=this.settings.page_animation,a=t("body").children().not(".sm-wrapper, .sm-sticky-button, script, style");if("enable"===e){switch(!0){case"blur"===s:a.css({filter:"blur("+this.settings.page_blurRadius+")","transition-duration":this.settings.page_animationDuration});break;case"scale"===s:a.css({transform:"scale("+this.settings.page_scaleValue+")","transition-duration":this.settings.page_animationDuration});break;case s.indexOf("move")>-1:var o="",n="";switch(!0){case"moveUp"===s:o="Y",n="-";break;case"moveDown"===s:o="Y",n="";break;case"moveLeft"===s:o="X",n="-";break;case"moveRight"===s:o="X",n=""}a.css({transform:"translate"+o+"("+n+this.settings.page_moveDistance+")","transition-duration":this.settings.page_animationDuration})}t("body").addClass(i+"pageAnimated")}else a.css({transform:"",filter:""}),t("body").removeClass(i+"pageAnimated")},_wrapperActive:function(){return this.$wrapper.hasClass(i+"active")},_prepareClose:function(){var t=this,e=t.$popup.css("animation-duration"),s=t.settings.overlay_isVisible?t.$overlay.css("animation-delay"):0,i=t.$el.css("animation-delay")||0,a=t.$popup.css("animation-delay")||0;t.settings.overlay_isVisible&&t.$overlay.css("animation-delay",e),t.settings.content_animate&&t.$el.css("animation-delay","0s"),t.$popup.css("animation-delay","0s");var o=1e3*((t.settings.overlay_isVisible?parseFloat(t.$overlay.css("animation-duration")):0)+parseFloat(e));t._togglePopup("disable",o,a,s,i)},_togglePopup:function(e,s,a,o,n){var p=this,r="enable"===e;r?(p.settings.callback_beforeOpen(),p.$wrapper.addClass(i+"active"),""!==p.settings.popup_bodyClass&&t("body").addClass(p.settings.popup_bodyClass),""!==p.settings.popup_wrapperClass&&p.$wrapper.addClass(p.settings.popup_wrapperClass),p.settings.content_loadViaAjax&&p._loadContentViaAjax(),setTimeout(function(){p.settings.callback_afterVisible(),"enable"===p.$wrapper.attr("data-sm-autoClose")&&p.autoClose()},1e3*(parseFloat(p.$popup.css("animation-delay"))+parseFloat(p.$popup.css("animation-duration")))+s)):(p.settings.callback_afterClose(),p.$wrapper.removeClass(i+"active"),p.settings.page_animate&&p._pageAnimation("disable")),setTimeout(function(){r?(p.settings.callback_afterOpen(),p.$wrapper.show(),"auto"===p.$popup[0].style.height&&p._popupCalculateHeight(),p.settings.page_animate&&p._pageAnimation("enable")):(p.settings.overlay_isVisible&&p.$overlay.css("animation-delay",o),p.settings.content_animate&&p.$el.css("animation-delay",n),p.$popup.css("animation-delay",a),p.$wrapper.hide(),p.settings.callback_afterHidden(),""!==p.settings.popup_bodyClass&&t("body").removeClass(p.settings.popup_bodyClass),""!==p.settings.popup_wrapperClass&&p.$wrapper.removeClass(p.settings.popup_wrapperClass),"enable"===p.$wrapper.attr("data-sm-autoClose")&&clearTimeout(p.autoCloseTimer))},s)},_typeController:function(e,s){var i=this,a=e||i.$wrapper.attr("data-sm-type"),o=s||parseFloat(i.$wrapper.attr("data-sm-type-val"));switch(!0){case"delayed"===a:i._togglePopup("enable",1e3*("string"==typeof o?parseFloat(o):o));break;case"scrolled"===a:var n=0,p=0;t(document).on("scroll",function(){var e=t(this).scrollTop();e>o&&!n&&(i._togglePopup("enable",0),n=1),i.settings.popup_scrollHideOnUp&&e<o&&n&&!p&&(i.closePopup(),p=1,t(document).unbind("scroll"))});break;case"exit"===a:var r=0;t(document).on("mouseleave",function(){r||(i.settings.popup_exitShowAlways||(r=1,t(document).unbind("mouseleave")),i._togglePopup("enable",0))});break;case"instant"===a:i._togglePopup("enable",0)}},openPopup:function(t,e){if(this._wrapperActive())return n(a+"This popup instance is already active.");this._activeInstanceExist()||this._typeController(t,e)},closePopup:function(){if(!this._wrapperActive())return n(a+"Popup is already closed.");this.settings.callback_beforeClose(),this._prepareClose(),this.settings.restrict_cookieSet&&this._setCookie(),this.settings.popup_redirectOnClose&&this.settings.popup_redirectOnCloseTriggers.indexOf("close")>-1&&this._redirectOnClose()},styleElement:function(t,e){if("object"!=typeof e)return n(a+"Only object with CSS properties"+o);switch(!0){case"overlay"===t&&this.settings.overlay_isVisible:this.$overlay.css(e),this.$popup.length>0&&e["animation-duration"]&&this.$popup.css("animation-delay",parseFloat(e["animation-duration"])/2+"s");break;case"popup"===t:this.$popup.css(e),this._popupPositionCorrect();break;case"content"===t:this.$el.css(e)}},popupPosition:function(t){if("string"!=typeof t)return n(a+"Only string"+o);this.$popup.attr("data-sm-position",t),this._popupPositionCorrect()},setEffect:function(t,e){if("string"!=typeof t||"string"!=typeof e)return n(a+"Only strings"+o);switch(!0){case"overlay"===t&&this.settings.overlay_isVisible:this.$overlay.attr("data-sm-effect",e);break;case"popup"===t:this.$popup.attr("data-sm-effect",e);break;case"content"===t:this.$el.attr("data-sm-effect",e)}},setType:function(t,e){this.$wrapper.attr({"data-sm-type":t,"data-sm-type-val":e})},autoClose:function(t,e){var s=this;s.$wrapper.attr({"data-sm-autoClose":t,"data-sm-autoClose-after":e}),t=t||s.$wrapper.attr("data-sm-autoClose"),e=e||s.$wrapper.attr("data-sm-autoClose-after"),"enable"===t&&(s.autoCloseTimer=setTimeout(function(){s.closePopup()},1e3*parseFloat(e)))},destroy:function(){t("."+this.settings.popup_reopenClass).on("click"===this.settings.popup_reopenClassTrigger?"click":"mouseover",function(){return!1}),this.$el.remove(),this.$wrapper.remove(),this.$overlay.remove(),this.$popup.remove(),delete this.$el,delete this.$wrapper,delete this.$overlay,delete this.$popup}},t.fn[s]=function(e){var i=Array.prototype.slice.call(arguments,1);return this.each(function(){var o=t(this),r=o.data(s);if(r){if("string"==typeof e)try{r[e].apply(r,i)}catch(t){n(a+"Method does not exist in Slick Modals.")}}else o.data(s,new p(this,e))})}}(jQuery);