// icons.js
window.icons = {
    copy: '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><g clip-path="url(#clip0_1110_347)"><path d="M16.6665 6.66669H8.33317C7.4127 6.66669 6.6665 7.41288 6.6665 8.33335V16.6667C6.6665 17.5872 7.4127 18.3334 8.33317 18.3334H16.6665C17.587 18.3334 18.3332 17.5872 18.3332 16.6667V8.33335C18.3332 7.41288 17.587 6.66669 16.6665 6.66669Z" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M3.33317 13.3334C2.4165 13.3334 1.6665 12.5834 1.6665 11.6667V3.33335C1.6665 2.41669 2.4165 1.66669 3.33317 1.66669H11.6665C12.5832 1.66669 13.3332 2.41669 13.3332 3.33335" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></g><defs><clipPath id="clip0_1110_347"><rect width="20" height="20" fill="white"/></clipPath></defs></svg>',
    csv: '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.0835 1.66669H5.00016C4.55814 1.66669 4.13421 1.84228 3.82165 2.15484C3.50909 2.4674 3.3335 2.89133 3.3335 3.33335V16.6667C3.3335 17.1087 3.50909 17.5326 3.82165 17.8452C4.13421 18.1578 4.55814 18.3334 5.00016 18.3334H15.0002C15.4422 18.3334 15.8661 18.1578 16.1787 17.8452C16.4912 17.5326 16.6668 17.1087 16.6668 16.6667V6.25002L12.0835 1.66669Z" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M11.6665 1.66669V6.66669H16.6665" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M7.19971 14.0771C7.19971 14.0088 7.18913 13.9478 7.16797 13.894C7.14844 13.8387 7.11182 13.7891 7.05811 13.7451C7.00602 13.6995 6.93197 13.6556 6.83594 13.6133C6.74154 13.5693 6.61947 13.5238 6.46973 13.4766C6.30371 13.4245 6.14909 13.3659 6.00586 13.3008C5.86263 13.2357 5.73649 13.16 5.62744 13.0737C5.52002 12.9875 5.4362 12.8882 5.37598 12.7759C5.31576 12.6619 5.28564 12.5301 5.28564 12.3804C5.28564 12.2339 5.31657 12.1004 5.37842 11.98C5.44189 11.8595 5.53141 11.7562 5.64697 11.6699C5.76253 11.582 5.89844 11.5145 6.05469 11.4673C6.21257 11.4201 6.38672 11.3965 6.57715 11.3965C6.84082 11.3965 7.06868 11.4445 7.26074 11.5405C7.45443 11.6366 7.60417 11.7668 7.70996 11.9312C7.81576 12.0955 7.86865 12.2803 7.86865 12.4854H7.19971C7.19971 12.3747 7.17611 12.277 7.12891 12.1924C7.08333 12.1077 7.01335 12.041 6.91895 11.9922C6.82617 11.9434 6.70898 11.9189 6.56738 11.9189C6.43066 11.9189 6.31673 11.9393 6.22559 11.98C6.13607 12.0207 6.06852 12.076 6.02295 12.146C5.979 12.216 5.95703 12.2941 5.95703 12.3804C5.95703 12.4455 5.97249 12.5041 6.00342 12.5562C6.03434 12.6066 6.08073 12.6546 6.14258 12.7002C6.20443 12.7441 6.28092 12.7856 6.37207 12.8247C6.46484 12.8621 6.57227 12.8996 6.69434 12.937C6.88965 12.9956 7.06055 13.0607 7.20703 13.1323C7.35514 13.2039 7.47803 13.2853 7.57568 13.3765C7.67497 13.4676 7.74902 13.5701 7.79785 13.6841C7.84831 13.798 7.87354 13.9274 7.87354 14.0723C7.87354 14.2253 7.84342 14.362 7.7832 14.4824C7.72298 14.6029 7.63672 14.7054 7.52441 14.79C7.41211 14.8747 7.27702 14.939 7.11914 14.9829C6.96289 15.0269 6.78792 15.0488 6.59424 15.0488C6.42171 15.0488 6.25081 15.026 6.08154 14.9805C5.9139 14.9333 5.76172 14.8633 5.625 14.7705C5.48828 14.6761 5.37923 14.5573 5.29785 14.4141C5.21647 14.2692 5.17578 14.0999 5.17578 13.9062H5.84961C5.84961 14.0186 5.86751 14.1146 5.90332 14.1943C5.94076 14.2725 5.99284 14.3368 6.05957 14.3872C6.12793 14.436 6.20768 14.4718 6.29883 14.4946C6.38997 14.5174 6.48844 14.5288 6.59424 14.5288C6.73096 14.5288 6.84326 14.5101 6.93115 14.4727C7.02067 14.4336 7.0874 14.3799 7.13135 14.3115C7.17692 14.2432 7.19971 14.165 7.19971 14.0771ZM9.84111 14.3042L10.7273 11.4453H11.472L10.2171 15H9.72148L9.84111 14.3042ZM9.02324 11.4453L9.90459 14.3042L10.0315 15H9.53105L8.28105 11.4453H9.02324ZM14.7774 13.1616V14.5459C14.7254 14.6126 14.6432 14.6851 14.5309 14.7632C14.4202 14.8413 14.2753 14.9089 14.0963 14.9658C13.9173 15.0212 13.6975 15.0488 13.4371 15.0488C13.2109 15.0488 13.0042 15.0114 12.817 14.9365C12.6298 14.86 12.4687 14.7485 12.3336 14.6021C12.1985 14.4556 12.0943 14.2765 12.0211 14.0649C11.9479 13.8534 11.9112 13.6117 11.9112 13.3398V13.1055C11.9112 12.8337 11.9454 12.592 12.0138 12.3804C12.0838 12.1688 12.183 11.9897 12.3116 11.8433C12.4418 11.6968 12.5973 11.5853 12.7779 11.5088C12.9602 11.4323 13.1637 11.394 13.3883 11.394C13.6894 11.394 13.9368 11.4437 14.1305 11.543C14.3258 11.6423 14.4755 11.779 14.5797 11.9531C14.6839 12.1257 14.749 12.3242 14.775 12.5488H14.1207C14.1028 12.4251 14.067 12.3169 14.0133 12.2241C13.9596 12.1297 13.8831 12.0565 13.7838 12.0044C13.6861 11.9507 13.5592 11.9238 13.4029 11.9238C13.2711 11.9238 13.1547 11.9499 13.0538 12.002C12.9529 12.054 12.8683 12.1297 12.7999 12.229C12.7315 12.3283 12.6795 12.4512 12.6437 12.5977C12.6095 12.7441 12.5924 12.9118 12.5924 13.1006V13.3398C12.5924 13.5303 12.6119 13.6995 12.651 13.8477C12.69 13.9941 12.7462 14.1178 12.8194 14.2188C12.8943 14.318 12.9863 14.3937 13.0953 14.4458C13.206 14.4963 13.3313 14.5215 13.4713 14.5215C13.5982 14.5215 13.7032 14.5109 13.7862 14.4897C13.8709 14.467 13.9384 14.4401 13.9889 14.4092C14.0393 14.3783 14.0784 14.3481 14.1061 14.3188V13.6523H13.4005V13.1616H14.7774Z" fill="#9089A9"/><path d="M7.16797 13.894L6.97925 13.9607L6.98189 13.9673L7.16797 13.894ZM7.05811 13.7451L6.92633 13.8957L6.93146 13.8999L7.05811 13.7451ZM6.83594 13.6133L6.75151 13.7946L6.75529 13.7963L6.83594 13.6133ZM6.46973 13.4766L6.52985 13.2858L6.52959 13.2857L6.46973 13.4766ZM5.62744 13.0737L5.50221 13.2297L5.50336 13.2306L5.62744 13.0737ZM5.37598 12.7759L5.19915 12.8693L5.19972 12.8704L5.37598 12.7759ZM5.37842 11.98L5.20148 11.8867L5.2005 11.8886L5.37842 11.98ZM5.64697 11.6699L5.76662 11.8302L5.76805 11.8291L5.64697 11.6699ZM6.05469 11.4673L5.9974 11.2757L5.99685 11.2758L6.05469 11.4673ZM7.26074 11.5405L7.1713 11.7194L7.1719 11.7197L7.26074 11.5405ZM7.86865 12.4854V12.6854H8.06865V12.4854H7.86865ZM7.19971 12.4854H6.99971V12.6854H7.19971V12.4854ZM7.12891 12.1924L6.95279 12.2872L6.95423 12.2898L7.12891 12.1924ZM6.91895 11.9922L6.82579 12.1692L6.82706 12.1698L6.91895 11.9922ZM6.22559 11.98L6.14405 11.7973L6.14283 11.7979L6.22559 11.98ZM6.02295 12.146L5.85533 12.0368L5.85357 12.0396L6.02295 12.146ZM6.00342 12.5562L5.83143 12.6583L5.8329 12.6607L6.00342 12.5562ZM6.14258 12.7002L6.02392 12.8612L6.02674 12.8632L6.14258 12.7002ZM6.37207 12.8247L6.29327 13.0086L6.29723 13.0102L6.37207 12.8247ZM6.69434 12.937L6.6357 13.1282L6.63687 13.1286L6.69434 12.937ZM7.20703 13.1323L7.11919 13.312L7.11997 13.3124L7.20703 13.1323ZM7.57568 13.3765L7.43922 13.5227L7.44043 13.5238L7.57568 13.3765ZM7.79785 13.6841L7.61401 13.7629L7.61498 13.7651L7.79785 13.6841ZM7.7832 14.4824L7.60432 14.393L7.7832 14.4824ZM7.11914 14.9829L7.06551 14.7902L7.06499 14.7904L7.11914 14.9829ZM6.08154 14.9805L6.02734 15.173L6.02955 15.1736L6.08154 14.9805ZM5.625 14.7705L5.51136 14.9351L5.5127 14.936L5.625 14.7705ZM5.29785 14.4141L5.12348 14.512L5.12396 14.5129L5.29785 14.4141ZM5.17578 13.9062V13.7062H4.97578V13.9062H5.17578ZM5.84961 13.9062H6.04961V13.7062H5.84961V13.9062ZM5.90332 14.1943L5.72081 14.2763L5.72296 14.2808L5.90332 14.1943ZM6.05957 14.3872L5.9389 14.5468L5.94332 14.55L6.05957 14.3872ZM6.29883 14.4946L6.25032 14.6887L6.29883 14.4946ZM6.93115 14.4727L7.00953 14.6567L7.01114 14.656L6.93115 14.4727ZM7.13135 14.3115L6.96491 14.2006L6.96311 14.2034L7.13135 14.3115ZM7.39971 14.0771C7.39971 13.9882 7.38593 13.9017 7.35405 13.8207L6.98189 13.9673C6.99232 13.9938 6.99971 14.0294 6.99971 14.0771H7.39971ZM7.35657 13.8275C7.32278 13.7318 7.26157 13.6532 7.18475 13.5903L6.93146 13.8999C6.96206 13.9249 6.97409 13.9456 6.97937 13.9606L7.35657 13.8275ZM7.18981 13.5946C7.11673 13.5307 7.02264 13.477 6.91659 13.4303L6.75529 13.7963C6.84129 13.8342 6.89531 13.8684 6.9264 13.8956L7.18981 13.5946ZM6.92034 13.432C6.81519 13.383 6.68417 13.3345 6.52985 13.2858L6.4096 13.6673C6.55476 13.7131 6.66789 13.7557 6.75153 13.7946L6.92034 13.432ZM6.52959 13.2857C6.37057 13.2358 6.22367 13.1801 6.08862 13.1187L5.9231 13.4829C6.0745 13.5517 6.23685 13.6131 6.40986 13.6674L6.52959 13.2857ZM6.08862 13.1187C5.95824 13.0594 5.84633 12.9919 5.75152 12.9169L5.50336 13.2306C5.62665 13.3281 5.76702 13.4119 5.9231 13.4829L6.08862 13.1187ZM5.75267 12.9178C5.6645 12.847 5.59875 12.7681 5.55223 12.6814L5.19972 12.8704C5.27365 13.0083 5.37554 13.128 5.50221 13.2297L5.75267 12.9178ZM5.5528 12.6824C5.51009 12.6016 5.48564 12.5028 5.48564 12.3804H5.08564C5.08564 12.5574 5.12142 12.7223 5.19916 12.8693L5.5528 12.6824ZM5.48564 12.3804C5.48564 12.263 5.51017 12.1612 5.55633 12.0713L5.2005 11.8886C5.12297 12.0396 5.08564 12.2048 5.08564 12.3804H5.48564ZM5.55535 12.0732C5.60414 11.9807 5.67345 11.8997 5.76661 11.8302L5.52733 11.5097C5.38937 11.6126 5.27965 11.7384 5.20149 11.8867L5.55535 12.0732ZM5.76805 11.8291C5.86241 11.7573 5.97629 11.6999 6.11252 11.6587L5.99685 11.2758C5.82058 11.3291 5.66265 11.4067 5.5259 11.5107L5.76805 11.8291ZM6.11198 11.6589C6.24864 11.618 6.40317 11.5965 6.57715 11.5965V11.1965C6.37027 11.1965 6.17649 11.2221 5.9974 11.2757L6.11198 11.6589ZM6.57715 11.5965C6.81673 11.5965 7.01263 11.6401 7.1713 11.7194L7.35018 11.3616C7.12474 11.2489 6.86492 11.1965 6.57715 11.1965V11.5965ZM7.1719 11.7197C7.33674 11.8014 7.45756 11.9085 7.54178 12.0394L7.87814 11.8229C7.75077 11.625 7.57211 11.4717 7.34958 11.3613L7.1719 11.7197ZM7.54178 12.0394C7.62575 12.1699 7.66865 12.3167 7.66865 12.4854H8.06865C8.06865 12.2439 8.00576 12.0212 7.87814 11.8229L7.54178 12.0394ZM7.86865 12.2854H7.19971V12.6854H7.86865V12.2854ZM7.39971 12.4854C7.39971 12.3455 7.36963 12.2134 7.30358 12.095L6.95423 12.2898C6.98259 12.3406 6.99971 12.4039 6.99971 12.4854H7.39971ZM7.305 12.0976C7.23834 11.9738 7.13706 11.8798 7.01083 11.8145L6.82706 12.1698C6.88963 12.2022 6.92833 12.2417 6.95281 12.2872L7.305 12.0976ZM7.01209 11.8152C6.88231 11.7469 6.73057 11.7189 6.56738 11.7189V12.1189C6.6874 12.1189 6.77003 12.1398 6.8258 12.1692L7.01209 11.8152ZM6.56738 11.7189C6.41233 11.7189 6.26848 11.7418 6.14406 11.7974L6.30712 12.1626C6.36498 12.1368 6.44899 12.1189 6.56738 12.1189V11.7189ZM6.14283 11.7979C6.02491 11.8515 5.92514 11.9297 5.85535 12.0369L6.19055 12.2551C6.21191 12.2223 6.24723 12.1898 6.30835 12.1621L6.14283 11.7979ZM5.85357 12.0396C5.78872 12.1429 5.75703 12.2582 5.75703 12.3804H6.15703C6.15703 12.33 6.16929 12.289 6.19233 12.2523L5.85357 12.0396ZM5.75703 12.3804C5.75703 12.4786 5.7808 12.573 5.83145 12.6583L6.17539 12.454C6.16418 12.4352 6.15703 12.4123 6.15703 12.3804H5.75703ZM5.8329 12.6607C5.88067 12.7386 5.94722 12.8047 6.02394 12.8612L6.26122 12.5392C6.21424 12.5046 6.18801 12.4746 6.17394 12.4516L5.8329 12.6607ZM6.02674 12.8632C6.10307 12.9175 6.19282 12.9655 6.29329 13.0085L6.45085 12.6409C6.36903 12.6058 6.30579 12.5708 6.25842 12.5372L6.02674 12.8632ZM6.29723 13.0102C6.39653 13.0502 6.50956 13.0895 6.6357 13.1282L6.75297 12.7458C6.63497 12.7096 6.53315 12.674 6.44691 12.6392L6.29723 13.0102ZM6.63687 13.1286C6.82421 13.1848 6.98456 13.2462 7.11919 13.312L7.29487 12.9526C7.13654 12.8752 6.95508 12.8064 6.75181 12.7454L6.63687 13.1286ZM7.11997 13.3124C7.25402 13.3772 7.35918 13.448 7.43922 13.5227L7.71215 13.2303C7.59688 13.1227 7.45626 13.0307 7.29409 12.9523L7.11997 13.3124ZM7.44043 13.5238C7.52069 13.5975 7.5773 13.6772 7.61402 13.7629L7.98168 13.6053C7.92075 13.4631 7.82924 13.3377 7.71094 13.2291L7.44043 13.5238ZM7.61498 13.7651C7.65245 13.8497 7.67354 13.9508 7.67354 14.0723H8.07354C8.07354 13.904 8.04416 13.7463 7.98072 13.6031L7.61498 13.7651ZM7.67354 14.0723C7.67354 14.1985 7.64887 14.3039 7.60432 14.393L7.96209 14.5719C8.03798 14.4201 8.07354 14.2521 8.07354 14.0723H7.67354ZM7.60432 14.393C7.55853 14.4846 7.4928 14.5634 7.40404 14.6303L7.64478 14.9498C7.78063 14.8474 7.88743 14.7212 7.96209 14.5719L7.60432 14.393ZM7.40404 14.6303C7.31474 14.6976 7.2032 14.7519 7.06551 14.7902L7.17277 15.1756C7.35084 15.126 7.50948 15.0517 7.64478 14.9498L7.40404 14.6303ZM7.06499 14.7904C6.92938 14.8285 6.77303 14.8488 6.59424 14.8488V15.2488C6.80281 15.2488 6.99641 15.2252 7.17329 15.1754L7.06499 14.7904ZM6.59424 14.8488C6.43955 14.8488 6.28613 14.8284 6.13354 14.7873L6.02955 15.1736C6.2155 15.2237 6.40387 15.2488 6.59424 15.2488V14.8488ZM6.13575 14.788C5.98767 14.7463 5.85529 14.6851 5.7373 14.605L5.5127 14.936C5.66815 15.0415 5.84013 15.1203 6.02734 15.173L6.13575 14.788ZM5.73864 14.6059C5.62648 14.5285 5.53812 14.4321 5.47174 14.3153L5.12396 14.5129C5.22035 14.6825 5.35008 14.8237 5.51136 14.9351L5.73864 14.6059ZM5.47222 14.3161C5.41024 14.2058 5.37578 14.0714 5.37578 13.9062H4.97578C4.97578 14.1285 5.0227 14.3326 5.12348 14.512L5.47222 14.3161ZM5.17578 14.1063H5.84961V13.7062H5.17578V14.1063ZM5.64961 13.9062C5.64961 14.0391 5.6707 14.1645 5.72087 14.2763L6.08577 14.1124C6.06433 14.0646 6.04961 13.998 6.04961 13.9062H5.64961ZM5.72296 14.2808C5.77368 14.3866 5.84583 14.4763 5.93895 14.5467L6.18019 14.2277C6.13984 14.1972 6.10783 14.1583 6.08368 14.1079L5.72296 14.2808ZM5.94332 14.55C6.03438 14.615 6.1377 14.6605 6.25032 14.6887L6.34734 14.3006C6.27766 14.2832 6.22148 14.2571 6.17582 14.2245L5.94332 14.55ZM6.25032 14.6887C6.35918 14.7159 6.47411 14.7288 6.59424 14.7288V14.3288C6.50278 14.3288 6.42077 14.319 6.34734 14.3006L6.25032 14.6887ZM6.59424 14.7288C6.74717 14.7288 6.8886 14.7082 7.00952 14.6567L6.85278 14.2887C6.79792 14.312 6.71474 14.3288 6.59424 14.3288V14.7288ZM7.01114 14.656C7.12944 14.6043 7.2303 14.5275 7.29958 14.4197L6.96311 14.2034C6.94451 14.2323 6.9119 14.2628 6.85116 14.2893L7.01114 14.656ZM7.29776 14.4225C7.36678 14.3189 7.39971 14.2016 7.39971 14.0771H6.99971C6.99971 14.1284 6.98706 14.1674 6.96494 14.2006L7.29776 14.4225ZM9.84111 14.3042L9.65008 14.245L9.64622 14.2574L9.64401 14.2703L9.84111 14.3042ZM10.7273 11.4453V11.2453H10.58L10.5363 11.3861L10.7273 11.4453ZM11.472 11.4453L11.6606 11.5119L11.7547 11.2453H11.472V11.4453ZM10.2171 15V15.2H10.3586L10.4057 15.0666L10.2171 15ZM9.72148 15L9.52438 14.9661L9.48416 15.2H9.72148V15ZM9.02324 11.4453L9.21437 11.3864L9.17087 11.2453H9.02324V11.4453ZM9.90459 14.3042L10.1013 14.2683L10.0992 14.2566L10.0957 14.2453L9.90459 14.3042ZM10.0315 15V15.2H10.2713L10.2283 14.9641L10.0315 15ZM9.53105 15L9.34238 15.0663L9.38938 15.2H9.53105V15ZM8.28105 11.4453V11.2453H7.99872L8.09238 11.5117L8.28105 11.4453ZM10.0321 14.3634L10.9184 11.5045L10.5363 11.3861L9.65008 14.245L10.0321 14.3634ZM10.7273 11.6453H11.472V11.2453H10.7273V11.6453ZM11.2834 11.3787L10.0285 14.9334L10.4057 15.0666L11.6606 11.5119L11.2834 11.3787ZM10.2171 14.8H9.72148V15.2H10.2171V14.8ZM9.91859 15.0339L10.0382 14.3381L9.64401 14.2703L9.52438 14.9661L9.91859 15.0339ZM8.83212 11.5042L9.71347 14.3631L10.0957 14.2453L9.21437 11.3864L8.83212 11.5042ZM9.70784 14.3401L9.83479 15.0359L10.2283 14.9641L10.1013 14.2683L9.70784 14.3401ZM10.0315 14.8H9.53105V15.2H10.0315V14.8ZM9.71973 14.9337L8.46973 11.379L8.09238 11.5117L9.34238 15.0663L9.71973 14.9337ZM8.28105 11.6453H9.02324V11.2453H8.28105V11.6453ZM14.7774 13.1616H14.9774V12.9616H14.7774V13.1616ZM14.7774 14.5459L14.9351 14.669L14.9774 14.6147V14.5459H14.7774ZM14.5309 14.7632L14.4166 14.599L14.4155 14.5998L14.5309 14.7632ZM14.0963 14.9658L14.1554 15.1569L14.1569 15.1564L14.0963 14.9658ZM12.817 14.9365L12.7413 15.1217L12.7427 15.1222L12.817 14.9365ZM12.0138 12.3804L11.8239 12.3176L11.8235 12.3189L12.0138 12.3804ZM12.3116 11.8433L12.1621 11.7104L12.1613 11.7113L12.3116 11.8433ZM12.7779 11.5088L12.7005 11.3244L12.6999 11.3246L12.7779 11.5088ZM14.1305 11.543L14.0392 11.7209L14.0398 11.7213L14.1305 11.543ZM14.5797 11.9531L14.408 12.0558L14.4085 12.0565L14.5797 11.9531ZM14.775 12.5488V12.7488H14.9995L14.9737 12.5258L14.775 12.5488ZM14.1207 12.5488L13.9228 12.5775L13.9476 12.7488H14.1207V12.5488ZM14.0133 12.2241L13.8394 12.323L13.8402 12.3243L14.0133 12.2241ZM13.7838 12.0044L13.6874 12.1797L13.6909 12.1815L13.7838 12.0044ZM12.6437 12.5977L12.4494 12.5502L12.4489 12.5522L12.6437 12.5977ZM12.651 13.8477L12.4576 13.8987L12.4577 13.8992L12.651 13.8477ZM12.8194 14.2188L12.6575 14.3362L12.6597 14.3392L12.8194 14.2188ZM13.0953 14.4458L13.0091 14.6263L13.0124 14.6278L13.0953 14.4458ZM13.7862 14.4897L13.8356 14.6836L13.8382 14.6829L13.7862 14.4897ZM14.1061 14.3188L14.2515 14.4562L14.3061 14.3984V14.3188H14.1061ZM14.1061 13.6523H14.3061V13.4523H14.1061V13.6523ZM13.4005 13.6523H13.2005V13.8523H13.4005V13.6523ZM13.4005 13.1616V12.9616H13.2005V13.1616H13.4005ZM14.5774 13.1616V14.5459H14.9774V13.1616H14.5774ZM14.6198 14.4228C14.5852 14.4671 14.5213 14.5262 14.4166 14.599L14.6451 14.9274C14.765 14.8439 14.8655 14.7582 14.9351 14.669L14.6198 14.4228ZM14.4155 14.5998C14.3266 14.6625 14.2021 14.7223 14.0356 14.7752L14.1569 15.1564C14.3485 15.0954 14.5137 15.0201 14.6462 14.9266L14.4155 14.5998ZM14.0372 14.7747C13.8831 14.8224 13.6847 14.8488 13.4371 14.8488V15.2488C13.7104 15.2488 13.9514 15.22 14.1554 15.1569L14.0372 14.7747ZM13.4371 14.8488C13.2332 14.8488 13.0521 14.8152 12.8913 14.7508L12.7427 15.1222C12.9562 15.2076 13.1885 15.2488 13.4371 15.2488V14.8488ZM12.8927 14.7514C12.7322 14.6858 12.5955 14.5911 12.4806 14.4665L12.1866 14.7376C12.3418 14.906 12.5274 15.0342 12.7413 15.1217L12.8927 14.7514ZM12.4806 14.4665C12.3664 14.3426 12.2754 14.1883 12.2101 13.9995L11.8321 14.1304C11.9132 14.3648 12.0306 14.5685 12.1866 14.7376L12.4806 14.4665ZM12.2101 13.9995C12.1455 13.8129 12.1112 13.594 12.1112 13.3398H11.7112C11.7112 13.6293 11.7502 13.8938 11.8321 14.1304L12.2101 13.9995ZM12.1112 13.3398V13.1055H11.7112V13.3398H12.1112ZM12.1112 13.1055C12.1112 12.8501 12.1434 12.6297 12.2041 12.4419L11.8235 12.3189C11.7474 12.5542 11.7112 12.8173 11.7112 13.1055H12.1112ZM12.2037 12.4432C12.2664 12.2534 12.3534 12.0988 12.4619 11.9752L12.1613 11.7113C12.0127 11.8807 11.9011 12.0841 11.8239 12.3176L12.2037 12.4432ZM12.4611 11.9761C12.5716 11.8519 12.7026 11.7579 12.8559 11.693L12.6999 11.3246C12.492 11.4127 12.3121 11.5417 12.1621 11.7104L12.4611 11.9761ZM12.8553 11.6932C13.01 11.6283 13.1866 11.594 13.3883 11.594V11.194C13.1407 11.194 12.9105 11.2363 12.7005 11.3244L12.8553 11.6932ZM13.3883 11.594C13.6692 11.594 13.8825 11.6406 14.0392 11.7209L14.2217 11.365C13.9911 11.2468 13.7096 11.194 13.3883 11.194V11.594ZM14.0398 11.7213C14.2043 11.8049 14.3248 11.9166 14.408 12.0558L14.7513 11.8505C14.6263 11.6414 14.4472 11.4796 14.2211 11.3647L14.0398 11.7213ZM14.4085 12.0565C14.4961 12.2017 14.5532 12.3722 14.5763 12.5719L14.9737 12.5258C14.9447 12.2762 14.8716 12.0496 14.7509 11.8498L14.4085 12.0565ZM14.775 12.3488H14.1207V12.7488H14.775V12.3488ZM14.3186 12.5202C14.2977 12.3754 14.2548 12.2421 14.1864 12.1239L13.8402 12.3243C13.8792 12.3917 13.9079 12.4749 13.9228 12.5775L14.3186 12.5202ZM14.1871 12.1252C14.1138 11.9964 14.0087 11.8965 13.8767 11.8273L13.6909 12.1815C13.7574 12.2164 13.8053 12.263 13.8394 12.323L14.1871 12.1252ZM13.8802 11.8292C13.7435 11.754 13.5801 11.7238 13.4029 11.7238V12.1238C13.5383 12.1238 13.6288 12.1474 13.6874 12.1796L13.8802 11.8292ZM13.4029 11.7238C13.2443 11.7238 13.0956 11.7553 12.9621 11.8242L13.1455 12.1797C13.2138 12.1444 13.2979 12.1238 13.4029 12.1238V11.7238ZM12.9621 11.8242C12.8301 11.8923 12.721 11.9909 12.6352 12.1156L12.9646 12.3424C13.0155 12.2685 13.0757 12.2157 13.1455 12.1797L12.9621 11.8242ZM12.6352 12.1156C12.5501 12.2392 12.4896 12.3858 12.4494 12.5502L12.8379 12.6451C12.8694 12.5166 12.913 12.4174 12.9646 12.3424L12.6352 12.1156ZM12.4489 12.5522C12.4105 12.7168 12.3924 12.9002 12.3924 13.1006H12.7924C12.7924 12.9234 12.8085 12.7715 12.8384 12.6431L12.4489 12.5522ZM12.3924 13.1006V13.3398H12.7924V13.1006H12.3924ZM12.3924 13.3398C12.3924 13.5435 12.4132 13.7304 12.4576 13.8987L12.8444 13.7967C12.8106 13.6686 12.7924 13.517 12.7924 13.3398H12.3924ZM12.4577 13.8992C12.5018 14.0644 12.5672 14.2117 12.6576 14.3362L12.9813 14.1013C12.9252 14.024 12.8783 13.9239 12.8442 13.7961L12.4577 13.8992ZM12.6597 14.3392C12.7534 14.4633 12.8702 14.5599 13.0091 14.6263L13.1815 14.2653C13.1023 14.2275 13.0352 14.1728 12.9791 14.0983L12.6597 14.3392ZM13.0124 14.6278C13.1527 14.6918 13.307 14.7215 13.4713 14.7215V14.3215C13.3556 14.3215 13.2593 14.3007 13.1783 14.2638L13.0124 14.6278ZM13.4713 14.7215C13.6077 14.7215 13.7308 14.7103 13.8356 14.6835L13.7368 14.2959C13.6757 14.3115 13.5888 14.3215 13.4713 14.3215V14.7215ZM13.8382 14.6829C13.9334 14.6573 14.0208 14.6242 14.0934 14.5797L13.8844 14.2387C13.856 14.256 13.8084 14.2767 13.7342 14.2966L13.8382 14.6829ZM14.0934 14.5797C14.1525 14.5434 14.2075 14.5027 14.2515 14.4562L13.9607 14.1815C13.9493 14.1935 13.9261 14.2131 13.8844 14.2387L14.0934 14.5797ZM14.3061 14.3188V13.6523H13.9061V14.3188H14.3061ZM14.1061 13.4523H13.4005V13.8523H14.1061V13.4523ZM13.6005 13.6523V13.1616H13.2005V13.6523H13.6005ZM13.4005 13.3616H14.7774V12.9616H13.4005V13.3616Z" fill="#9089A9" mask="url(#path-3-outside-1_1110_510)"/></svg>',
    excel: '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M12.8332 1.40984L2.4527 2.89277L12.8332 1.40984ZM12.8332 1.40984V18.5901L2.4527 17.1072C2.28845 17.0837 2.1665 16.9431 2.1665 16.7773V3.22275C2.1665 3.05687 2.28848 2.91623 2.4527 2.89277L12.8332 1.40984ZM16.6665 3.66667H14.6665V3H17.4998C17.6839 3 17.8332 3.14923 17.8332 3.33333V16.6667C17.8332 16.8508 17.6839 17 17.4998 17H14.6665V16.3334H16.6665H17.1665V15.8334V4.16667V3.66667H16.6665ZM3.26246 3.45052L2.83317 3.51185V3.9455V16.0545V16.4882L3.26246 16.5495L11.5958 17.74L12.1665 17.8215V17.245V2.75502V2.17851L11.5958 2.26004L3.26246 3.45052ZM8.09022 9.71329L7.88951 10L8.09022 10.2868L9.87284 12.8334H9.0935L7.90945 11.1419L7.49984 10.5567L7.09022 11.1419L5.90617 12.8334H5.12683L6.90945 10.2868L7.11016 10L6.90945 9.71329L5.12683 7.16667H5.90617L7.09022 8.85817L7.49984 9.44334L7.90945 8.85817L9.0935 7.16667H9.87285L8.09022 9.71329Z" fill="#5D5676" stroke="#9089A9"/></svg>',
    pdf: '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.0833 1.66669H4.99992C4.55789 1.66669 4.13397 1.84228 3.82141 2.15484C3.50885 2.4674 3.33325 2.89133 3.33325 3.33335V16.6667C3.33325 17.1087 3.50885 17.5326 3.82141 17.8452C4.13397 18.1578 4.55789 18.3334 4.99992 18.3334H14.9999C15.4419 18.3334 15.8659 18.1578 16.1784 17.8452C16.491 17.5326 16.6666 17.1087 16.6666 16.6667V6.25002L12.0833 1.66669Z" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M11.6667 1.66669V6.66669H16.6667" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M6.70654 13.7036H5.79102V13.1763H6.70654C6.85628 13.1763 6.97754 13.1519 7.07031 13.103C7.16471 13.0526 7.23389 12.9842 7.27783 12.8979C7.32178 12.8101 7.34375 12.71 7.34375 12.5977C7.34375 12.4886 7.32178 12.3869 7.27783 12.2925C7.23389 12.1981 7.16471 12.1216 7.07031 12.063C6.97754 12.0044 6.85628 11.9751 6.70654 11.9751H6.01074V15H5.33936V11.4453H6.70654C6.98324 11.4453 7.21924 11.495 7.41455 11.5942C7.61149 11.6919 7.76123 11.8278 7.86377 12.002C7.96794 12.1745 8.02002 12.3714 8.02002 12.5928C8.02002 12.8223 7.96794 13.02 7.86377 13.186C7.76123 13.3521 7.61149 13.4798 7.41455 13.5693C7.21924 13.6589 6.98324 13.7036 6.70654 13.7036ZM10.2094 15H9.44277L9.44766 14.4727H10.2094C10.4161 14.4727 10.5894 14.4271 10.7294 14.3359C10.8694 14.2432 10.9752 14.1105 11.0468 13.938C11.1184 13.7638 11.1542 13.5555 11.1542 13.313V13.1299C11.1542 12.9427 11.1339 12.7775 11.0932 12.6343C11.0525 12.491 10.9923 12.3706 10.9125 12.2729C10.8344 12.1753 10.7375 12.1012 10.622 12.0508C10.5064 12.0003 10.3738 11.9751 10.224 11.9751H9.42812V11.4453H10.224C10.4617 11.4453 10.6781 11.4852 10.8734 11.5649C11.0704 11.6447 11.2405 11.7594 11.3837 11.9092C11.5285 12.0573 11.6392 12.2347 11.7157 12.4414C11.7938 12.6481 11.8329 12.8792 11.8329 13.1348V13.313C11.8329 13.5669 11.7938 13.798 11.7157 14.0063C11.6392 14.2131 11.5285 14.3905 11.3837 14.5386C11.2405 14.6867 11.0696 14.8006 10.871 14.8804C10.6724 14.9601 10.4519 15 10.2094 15ZM9.81875 11.4453V15H9.14736V11.4453H9.81875ZM13.6756 11.4453V15H13.0042V11.4453H13.6756ZM15.1087 12.981V13.5107H13.4998V12.981H15.1087ZM15.2967 11.4453V11.9751H13.4998V11.4453H15.2967Z" fill="#9089A9"/><path d="M5.79102 13.7036H5.59102V13.9036H5.79102V13.7036ZM5.79102 13.1763V12.9763H5.59102V13.1763H5.79102ZM7.07031 13.103L7.16346 13.28L7.16459 13.2794L7.07031 13.103ZM7.27783 12.8979L7.45604 12.9887L7.45672 12.9874L7.27783 12.8979ZM7.07031 12.063L6.96351 12.2321L6.96484 12.2329L7.07031 12.063ZM6.01074 11.9751V11.7751H5.81074V11.9751H6.01074ZM6.01074 15V15.2H6.21074V15H6.01074ZM5.33936 15H5.13936V15.2H5.33936V15ZM5.33936 11.4453V11.2453H5.13936V11.4453H5.33936ZM7.41455 11.5942L7.32392 11.7725L7.3257 11.7734L7.41455 11.5942ZM7.86377 12.002L7.69141 12.1034L7.69256 12.1053L7.86377 12.002ZM7.86377 13.186L7.69435 13.0797L7.69361 13.0809L7.86377 13.186ZM7.41455 13.5693L7.33179 13.3873L7.33122 13.3875L7.41455 13.5693ZM6.70654 13.5036H5.79102V13.9036H6.70654V13.5036ZM5.99102 13.7036V13.1763H5.59102V13.7036H5.99102ZM5.79102 13.3763H6.70654V12.9763H5.79102V13.3763ZM6.70654 13.3763C6.87573 13.3763 7.03232 13.349 7.16346 13.28L6.97716 12.926C6.92276 12.9547 6.83684 12.9763 6.70654 12.9763V13.3763ZM7.16459 13.2794C7.29108 13.2118 7.39158 13.1153 7.45604 12.9887L7.09962 12.8072C7.07619 12.8532 7.03835 12.8933 6.97604 12.9266L7.16459 13.2794ZM7.45672 12.9874C7.51641 12.868 7.54375 12.7366 7.54375 12.5977H7.14375C7.14375 12.6834 7.12714 12.7521 7.09895 12.8085L7.45672 12.9874ZM7.54375 12.5977C7.54375 12.4609 7.51598 12.3302 7.45915 12.2081L7.09652 12.3769C7.12757 12.4436 7.14375 12.5164 7.14375 12.5977H7.54375ZM7.45915 12.2081C7.39766 12.076 7.30093 11.9707 7.17579 11.8931L6.96484 12.2329C7.0285 12.2724 7.07011 12.3202 7.09652 12.3769L7.45915 12.2081ZM7.17711 11.8939C7.04272 11.809 6.88076 11.7751 6.70654 11.7751V12.1751C6.83181 12.1751 6.91236 12.1998 6.96351 12.2321L7.17711 11.8939ZM6.70654 11.7751H6.01074V12.1751H6.70654V11.7751ZM5.81074 11.9751V15H6.21074V11.9751H5.81074ZM6.01074 14.8H5.33936V15.2H6.01074V14.8ZM5.53936 15V11.4453H5.13936V15H5.53936ZM5.33936 11.6453H6.70654V11.2453H5.33936V11.6453ZM6.70654 11.6453C6.95981 11.6453 7.16309 11.6908 7.32392 11.7725L7.50518 11.416C7.27538 11.2991 7.00666 11.2453 6.70654 11.2453V11.6453ZM7.3257 11.7734C7.49104 11.8554 7.61031 11.9657 7.69142 12.1034L8.03611 11.9005C7.91215 11.6899 7.73194 11.5284 7.5034 11.4151L7.3257 11.7734ZM7.69256 12.1053C7.77607 12.2436 7.82002 12.4042 7.82002 12.5928H8.22002C8.22002 12.3387 8.15981 12.1053 8.03498 11.8986L7.69256 12.1053ZM7.82002 12.5928C7.82002 12.7912 7.77533 12.9507 7.69436 13.0797L8.03318 13.2923C8.16054 13.0894 8.22002 12.8533 8.22002 12.5928H7.82002ZM7.69361 13.0809C7.61416 13.2096 7.49669 13.3123 7.33179 13.3873L7.49731 13.7514C7.72629 13.6473 7.9083 13.4945 8.03393 13.2911L7.69361 13.0809ZM7.33122 13.3875C7.16844 13.4621 6.96244 13.5036 6.70654 13.5036V13.9036C7.00403 13.9036 7.27004 13.8556 7.49788 13.7511L7.33122 13.3875ZM9.44277 15L9.24278 14.9981L9.24091 15.2H9.44277V15ZM9.44766 14.4727V14.2727H9.2495L9.24766 14.4708L9.44766 14.4727ZM10.7294 14.3359L10.8385 14.5035L10.8399 14.5026L10.7294 14.3359ZM11.0468 13.938L11.2315 14.0147L11.2317 14.0141L11.0468 13.938ZM11.0932 12.6343L10.9008 12.6889L11.0932 12.6343ZM10.9125 12.2729L10.7563 12.3979L10.7576 12.3995L10.9125 12.2729ZM9.42812 11.9751H9.22813V12.1751H9.42812V11.9751ZM9.42812 11.4453V11.2453H9.22813V11.4453H9.42812ZM10.8734 11.5649L10.7978 11.7501L10.7984 11.7503L10.8734 11.5649ZM11.3837 11.9092L11.2392 12.0474L11.2407 12.049L11.3837 11.9092ZM11.7157 12.4414L11.5282 12.5108L11.5286 12.5121L11.7157 12.4414ZM11.7157 14.0063L11.5285 13.9361L11.5282 13.9369L11.7157 14.0063ZM11.3837 14.5386L11.2407 14.3987L11.2399 14.3995L11.3837 14.5386ZM9.81875 11.4453H10.0187V11.2453H9.81875V11.4453ZM9.81875 15V15.2H10.0187V15H9.81875ZM9.14736 15H8.94736V15.2H9.14736V15ZM9.14736 11.4453V11.2453H8.94736V11.4453H9.14736ZM10.2094 14.8H9.44277V15.2H10.2094V14.8ZM9.64276 15.0019L9.64765 14.4745L9.24766 14.4708L9.24278 14.9981L9.64276 15.0019ZM9.44766 14.6727H10.2094V14.2727H9.44766V14.6727ZM10.2094 14.6727C10.4456 14.6727 10.6591 14.6204 10.8385 14.5035L10.6203 14.1683C10.5197 14.2338 10.3866 14.2727 10.2094 14.2727V14.6727ZM10.8399 14.5026C11.0167 14.3855 11.1464 14.2196 11.2315 14.0147L10.8621 13.8613C10.8039 14.0014 10.7221 14.1009 10.6189 14.1692L10.8399 14.5026ZM11.2317 14.0141C11.3157 13.8099 11.3542 13.5744 11.3542 13.313H10.9542C10.9542 13.5366 10.9211 13.7178 10.8618 13.8619L11.2317 14.0141ZM11.3542 13.313V13.1299H10.9542V13.313H11.3542ZM11.3542 13.1299C11.3542 12.9287 11.3324 12.7445 11.2856 12.5796L10.9008 12.6889C10.9353 12.8105 10.9542 12.9567 10.9542 13.1299H11.3542ZM11.2856 12.5796C11.2387 12.4148 11.1673 12.2687 11.0674 12.1464L10.7576 12.3995C10.8172 12.4725 10.8662 12.5673 10.9008 12.6889L11.2856 12.5796ZM11.0687 12.148C10.9701 12.0248 10.847 11.9308 10.702 11.8675L10.5419 12.2341C10.628 12.2717 10.6986 12.3258 10.7563 12.3979L11.0687 12.148ZM10.702 11.8675C10.5569 11.8041 10.3962 11.7751 10.224 11.7751V12.1751C10.3513 12.1751 10.4559 12.1965 10.5419 12.2341L10.702 11.8675ZM10.224 11.7751H9.42812V12.1751H10.224V11.7751ZM9.62812 11.9751V11.4453H9.22813V11.9751H9.62812ZM9.42812 11.6453H10.224V11.2453H9.42812V11.6453ZM10.224 11.6453C10.439 11.6453 10.6294 11.6813 10.7978 11.7501L10.949 11.3798C10.7269 11.2891 10.4843 11.2453 10.224 11.2453V11.6453ZM10.7984 11.7503C10.9698 11.8197 11.116 11.9187 11.2392 12.0474L11.5282 11.7709C11.3649 11.6002 11.171 11.4697 10.9485 11.3796L10.7984 11.7503ZM11.2407 12.049C11.3647 12.1758 11.4608 12.3287 11.5282 12.5108L11.9033 12.372C11.8177 12.1407 11.6924 11.9388 11.5267 11.7693L11.2407 12.049ZM11.5286 12.5121C11.597 12.693 11.6329 12.8997 11.6329 13.1348H12.0329C12.0329 12.8588 11.9907 12.6032 11.9028 12.3707L11.5286 12.5121ZM11.6329 13.1348V13.313H12.0329V13.1348H11.6329ZM11.6329 13.313C11.6329 13.5463 11.5971 13.7532 11.5285 13.9361L11.903 14.0766C11.9906 13.8429 12.0329 13.5875 12.0329 13.313H11.6329ZM11.5282 13.9369C11.4608 14.119 11.3647 14.272 11.2407 14.3987L11.5267 14.6784C11.6924 14.509 11.8177 14.3071 11.9033 14.0758L11.5282 13.9369ZM11.2399 14.3995C11.117 14.5267 10.97 14.6251 10.7965 14.6948L10.9455 15.066C11.1692 14.9761 11.3639 14.8467 11.5275 14.6776L11.2399 14.3995ZM10.7965 14.6948C10.6245 14.7638 10.4297 14.8 10.2094 14.8V15.2C10.474 15.2 10.7203 15.1564 10.9455 15.066L10.7965 14.6948ZM9.61875 11.4453V15H10.0187V11.4453H9.61875ZM9.81875 14.8H9.14736V15.2H9.81875V14.8ZM9.34736 15V11.4453H8.94736V15H9.34736ZM9.14736 11.6453H9.81875V11.2453H9.14736V11.6453ZM13.6756 11.4453H13.8756V11.2453H13.6756V11.4453ZM13.6756 15V15.2H13.8756V15H13.6756ZM13.0042 15H12.8042V15.2H13.0042V15ZM13.0042 11.4453V11.2453H12.8042V11.4453H13.0042ZM15.1087 12.981H15.3087V12.781H15.1087V12.981ZM15.1087 13.5107V13.7107H15.3087V13.5107H15.1087ZM13.4998 13.5107H13.2998V13.7107H13.4998V13.5107ZM13.4998 12.981V12.781H13.2998V12.981H13.4998ZM15.2967 11.4453H15.4967V11.2453H15.2967V11.4453ZM15.2967 11.9751V12.1751H15.4967V11.9751H15.2967ZM13.4998 11.9751H13.2998V12.1751H13.4998V11.9751ZM13.4998 11.4453V11.2453H13.2998V11.4453H13.4998ZM13.4756 11.4453V15H13.8756V11.4453H13.4756ZM13.6756 14.8H13.0042V15.2H13.6756V14.8ZM13.2042 15V11.4453H12.8042V15H13.2042ZM13.0042 11.6453H13.6756V11.2453H13.0042V11.6453ZM14.9087 12.981V13.5107H15.3087V12.981H14.9087ZM15.1087 13.3107H13.4998V13.7107H15.1087V13.3107ZM13.6998 13.5107V12.981H13.2998V13.5107H13.6998ZM13.4998 13.181H15.1087V12.781H13.4998V13.181ZM15.0967 11.4453V11.9751H15.4967V11.4453H15.0967ZM15.2967 11.7751H13.4998V12.1751H15.2967V11.7751ZM13.6998 11.9751V11.4453H13.2998V11.9751H13.6998ZM13.4998 11.6453H15.2967V11.2453H13.4998V11.6453Z" fill="#9089A9" mask="url(#path-3-outside-1_1110_134)"/></svg>',
    print: '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><g clip-path="url(#clip0_1110_469)"><path d="M5 7.50002V1.66669H15V7.50002" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M5.00008 15H3.33341C2.89139 15 2.46746 14.8244 2.1549 14.5118C1.84234 14.1993 1.66675 13.7754 1.66675 13.3333V9.16667C1.66675 8.72464 1.84234 8.30072 2.1549 7.98816C2.46746 7.6756 2.89139 7.5 3.33341 7.5H16.6667C17.1088 7.5 17.5327 7.6756 17.8453 7.98816C18.1578 8.30072 18.3334 8.72464 18.3334 9.16667V13.3333C18.3334 13.7754 18.1578 14.1993 17.8453 14.5118C17.5327 14.8244 17.1088 15 16.6667 15H15.0001" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M15 11.6667H5V18.3334H15V11.6667Z" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></g></svg>',
    colvis: '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M1.66675 10C1.66675 10 4.16675 4.16669 10.0001 4.16669C15.8334 4.16669 18.3334 10 18.3334 10C18.3334 10 15.8334 15.8334 10.0001 15.8334C4.16675 15.8334 1.66675 10 1.66675 10Z" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M10 12.5C11.3807 12.5 12.5 11.3807 12.5 10C12.5 8.61929 11.3807 7.5 10 7.5C8.61929 7.5 7.5 8.61929 7.5 10C7.5 11.3807 8.61929 12.5 10 12.5Z" stroke="#9089A9" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    viwe: '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M1.66675 10C1.66675 10 4.16675 4.16669 10.0001 4.16669C15.8334 4.16669 18.3334 10 18.3334 10C18.3334 10 15.8334 15.8334 10.0001 15.8334C4.16675 15.8334 1.66675 10 1.66675 10Z" stroke="#5D5676" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M10 12.5C11.3807 12.5 12.5 11.3807 12.5 10C12.5 8.61929 11.3807 7.5 10 7.5C8.61929 7.5 7.5 8.61929 7.5 10C7.5 11.3807 8.61929 12.5 10 12.5Z" stroke="#5D5676" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    singleViwe: '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M5.83325 5.83331H14.1666V14.1666" stroke="#5D5676" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M5.83325 14.1666L14.1666 5.83331" stroke="#5D5676" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    delete: '<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none"><path d="M2.5 5H17.5" stroke="#5D5676" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M15.8334 5V16.6667C15.8334 17.5 15.0001 18.3333 14.1667 18.3333H5.83341C5.00008 18.3333 4.16675 17.5 4.16675 16.6667V5" stroke="#5D5676" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M6.66675 5.00002V3.33335C6.66675 2.50002 7.50008 1.66669 8.33341 1.66669H11.6667C12.5001 1.66669 13.3334 2.50002 13.3334 3.33335V5.00002" stroke="#5D5676" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>',

};