<?php
/*
The MIT License (MIT)

Copyright (c) 2015 Twitter Inc.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

namespace Twitter\WordPress\Shortcodes;

/**
 * Common methods expected to exist in each shortcode handler
 *
 * @since 1.3.0
 */
interface ShortcodeInterface
{
	/**
	 * Register shortcode macro and handler
	 *
	 * @since 1.3.0
	 *
	 * @return void
	 */
	public static function init();

	/**
	 * Describe shortcode for Shortcake UI
	 *
	 * @since 1.3.0
	 *
	 * @see https://github.com/wp-shortcake/shortcake Shortcake UI
	 *
	 * @return void
	 */
	public static function shortcodeUI();

	/**
	 * Handle shortcode macro
	 *
	 * @since 1.3.0
	 *
	 * @param array  $attributes shortcode attributes
	 * @param string $content    shortcode content. no effect
	 *
	 * @return string HTML result or empty string. JavaScript dependencies should be enqueued or loaded in the returned HTML
	 */
	public static function shortcodeHandler( $attributes, $content );

	/**
	 * Process and clean supplied attributes
	 *
	 * @since 2.0.0
	 *
	 * @param array $attributes array of attributes passed by WordPress shortcode API
	 *
	 * @return array processed attriutes prepped
	 */
	public static function getShortcodeAttributes( $attributes );

	/**
	 * Describe the shortcode
	 *
	 * Used by shortcake UI to list available shortcodes.
	 * May be used by a widget or other visuals to describe a feature
	 *
	 * @return string Translated feature name
	 */
	public static function featureName();
}
