<?php
  /*
   * Visual Composer Support
   */
add_action( 'vc_before_init', 'twenty20_shortcode_integrateWithVC' );
function twenty20_shortcode_integrateWithVC() {
  vc_map( array(
    "name"      =>  __( "Twenty20", 'zb_twenty20' ),
    "base"      =>  "twenty20",
    "icon"      =>  "icon-twenty20",
    "category"  =>  __( "Media", 'zb_twenty20'),
    "description" => esc_html__( 'Create interactive before & after image comparison sliders', 'zb_twenty20' ),
    "params"    =>  array(
      array(
        'type'        =>  'attach_image',
        'heading'     =>  __( 'Before Image', 'zb_twenty20' ),
        'param_name'  =>  'img1',
        "description" =>  esc_html__("Choose the 'before' image to display on the left/top side of the slider", 'zb_twenty20'),
      ),
      array(
        'type'        =>  'attach_image',
        'heading'     =>  __( 'After Image', 'zb_twenty20' ),
        'param_name'  =>  'img2',
        "description" =>  esc_html__("Choose the 'after' image to display on the right/bottom side of the slider", 'zb_twenty20'),
      ),
      array(
        'type'        =>  'textfield',
        'heading'     =>  __( 'Before Text', 'zb_twenty20' ),
        'param_name'  =>  'before',
        "description" =>  esc_html__("Add a caption or label for the 'before' image (optional)", 'zb_twenty20'),
      ),
      array(
        'type'        =>  'textfield',
        'heading'     =>  __( 'After Text', 'zb_twenty20' ),
        'param_name'  =>  'after',
        "description" =>  esc_html__("Add a caption or label for the 'after' image (optional)", 'zb_twenty20'),
      ),
      array(
        'type'        =>  'textfield',
        'heading'     =>  __( 'Width', 'zb_twenty20' ),
        'param_name'  =>  'width',
        "description" =>  esc_html__("Set slider width in pixels or percentage (e.g., '500px' or '100%'). Default: 100%", 'zb_twenty20'),
      ),

      array(
        'type'        =>  'dropdown',
        'heading'     =>  __( 'Direction', 'zb_twenty20' ),
        'param_name'  =>  'direction',
        "description" =>  esc_html__("Choose slider movement direction - horizontal (left/right) or vertical (up/down)", 'zb_twenty20'),
        "value"       =>  array(
          'Horizontal'  =>  'default',
          'Vertical'    =>  'vertical'
        )
      ),
      array(
        'type'          =>  'dropdown',
        'heading'       =>  __( 'Offset', 'zb_twenty20' ),
        'param_name'    =>  'offset',
        "description"   =>  esc_html__("Set the initial position of the slider handle (0.1 to 1.0). Default: 0.5 (center)", 'zb_twenty20'),
        "value"         =>  array(
          '0.5' =>  '0.5',
          '0.1' =>  '0.1',
          '0.2' =>  '0.2',
          '0.3' =>  '0.3',
          '0.4' =>  '0.4',
          '0.5' =>  '0.5',
          '0.6' =>  '0.6',
          '0.7' =>  '0.7',
          '0.8' =>  '0.8',
          '0.9' =>  '0.9',
          '1'   =>  '1.0',
        )
      ),
      array(
        'type'        =>  'dropdown',
        'heading'     =>  __( 'Mouseover', 'zb_twenty20' ),
        'param_name'  =>  'hover',
        "description" =>  esc_html__("Enable automatic slider movement when mouse hovers over the image", 'zb_twenty20'),
        "value"       =>  array(
          'No'  =>  'false',
          'Yes'    =>  'true'
        )
      ),
      array(
        'type'          =>  'dropdown',
        'heading'       =>  __( 'Alignment', 'zb_twenty20' ),
        'param_name'    =>  'align',
        "description"   =>  esc_html__("Choose how to align the slider within its container (left, right, or none)", 'zb_twenty20'),
        "value"         =>  array(
          'None'  =>  'none',
          'Right' =>  'right',
          'Left'  =>  'left'
        )
      ),
    ),
  ));
}
if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Twenty20_Shortcode extends WPBakeryShortCode { }
}
