<?php
/**
 * Testimonials block patterns.
 *
 * @package twentig
 * @phpcs:disable Squiz.Strings.DoubleQuoteUsage.NotRequired
 */

 $group_name = esc_html_x( 'Testimonials', 'Block pattern category', 'default' );

twentig_register_block_pattern(
	'twentig/testimonials-list-with-separator',
	array(
		'title'      => __( 'Testimonials: list with separator', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat at blandit at erat."</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"/><!-- /wp:separator --><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"/><!-- /wp:separator --><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet."</p><!-- /wp:paragraph --><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-list-with-large-quote',
	array(
		'title'      => __( 'Testimonials: list with large quote', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"blockGap":"var:preset|spacing|50"}},"layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:quote {"align":"center","style":{"typography":{"lineHeight":"1.3"}},"className":"is-style-plain","fontSize":"large"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain has-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor id feugiat."</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --><!-- wp:quote {"align":"center","style":{"typography":{"lineHeight":"1.3"}},"className":"is-style-plain","fontSize":"large"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain has-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien."</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --><!-- wp:quote {"align":"center","style":{"typography":{"lineHeight":"1.3"}},"className":"is-style-plain","fontSize":"large"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain has-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><!-- /wp:paragraph --><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:group -->',
	)
); 

twentig_register_block_pattern(
	'twentig/testimonial-colored-background',
	array(
		'title'      => __( 'Testimonial: colored background', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:quote {"textAlign":"center","className":"is-style-plain","style":{"typography":{"lineHeight":"1.2"}},"fontSize":"xx-large"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain has-xx-large-font-size" style="line-height:1.2"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor."</p><!-- /wp:paragraph --><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonial-colored-background-with-thumbnail',
	array(
		'title'      => __( 'Testimonial: colored background with thumbnail', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:quote {"textAlign":"center","className":"is-style-plain","style":{"typography":{"lineHeight":"1.2"}},"fontSize":"xx-large"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain has-xx-large-font-size" style="line-height:1.2"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor."</p><!-- /wp:paragraph --></blockquote><!-- /wp:quote --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15"}},"layout":{"type":"flex","justifyContent":"center"}} --><div class="wp-block-group"><!-- wp:image {"width":"48px","height":"48px","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;width:48px;height:48px"/></figure><!-- /wp:image --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonial-cover',
	array(
		'title'      => __( 'Testimonial: cover', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":500,"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull" style="min-height:500px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:quote {"textAlign":"center","className":"is-style-plain","style":{"typography":{"lineHeight":"1.2"}},"fontSize":"xx-large"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain has-xx-large-font-size" style="line-height:1.2"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore."</p><!-- /wp:paragraph --><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonial-image-on-left',
	array(
		'title'      => __( 'Testimonial: image on left', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:columns {"verticalAlignment":null,"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide are-vertically-aligned-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3"}},"className":"is-style-plain","fontSize":"x-large"} --><blockquote class="wp-block-quote is-style-plain has-x-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor feugiat."</p><!-- /wp:paragraph --><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonial-image-on-right',
	array(
		'title'      => __( 'Testimonial: image on right', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:columns {"verticalAlignment":null,"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3"}},"className":"is-style-plain","fontSize":"x-large"} --><blockquote class="wp-block-quote is-style-plain has-x-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor feugiat."</p><!-- /wp:paragraph --><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-overlap-image',
	array(
		'title'      => __( 'Testimonials: overlap image', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:media-text {"align":"wide","mediaType":"image","mediaWidth":56,"className":"is-style-tw-overlap","backgroundColor":"base"} --><div class="wp-block-media-text alignwide is-stacked-on-mobile is-style-tw-overlap has-base-background-color has-background" style="grid-template-columns:56% auto"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3"}},"className":"is-style-plain","fontSize":"large"} --><blockquote class="wp-block-quote is-style-plain has-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor id feugiat."</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:media-text --><!-- wp:media-text {"align":"wide","mediaPosition":"right","mediaType":"image","mediaWidth":56,"className":"is-style-tw-overlap","style":{"spacing":{"margin":{"top":"var:preset|spacing|65"}}},"backgroundColor":"base"} --><div class="wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile is-style-tw-overlap has-base-background-color has-background" style="margin-top:var(--wp--preset--spacing--65);grid-template-columns:auto 56%"><div class="wp-block-media-text__content"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3"}},"className":"is-style-plain","fontSize":"large"} --><blockquote class="wp-block-quote is-style-plain has-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien."</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure></div><!-- /wp:media-text --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-2-columns-x-2',
	array(
		'title'      => __( 'Testimonials 2 columns x 2', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|50"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--50)">' . esc_html_x( 'What our customers are saying about us', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"align":"center","className":"is-style-tw-icon"} --><blockquote class="wp-block-quote has-text-align-center is-style-tw-icon"><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore.</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"align":"center","className":"is-style-tw-icon"} --><blockquote class="wp-block-quote has-text-align-center is-style-tw-icon"><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien.</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50"},"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"align":"center","className":"is-style-tw-icon"} --><blockquote class="wp-block-quote has-text-align-center is-style-tw-icon"><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><!-- /wp:paragraph --><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"align":"center","className":"is-style-tw-icon"} --><blockquote class="wp-block-quote has-text-align-center is-style-tw-icon"><!-- wp:paragraph --><p>Duis enim elit porttitor id feugiat at blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-2-columns-masonry',
	array(
		'title'      => __( 'Testimonials 2 columns: masonry', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}}} --><div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|20","right":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"backgroundColor":"base"} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)"><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor id feugiat. Mauris dui tellus mollis quis varius sit amet ultrices in leo rhoncus."</p><!-- /wp:paragraph --></blockquote><!-- /wp:quote --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15","margin":{"top":"var:preset|spacing|25"}}},"layout":{"type":"flex"}} --><div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--25)"><!-- wp:image {"width":"48px","height":"48px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:48px;height:48px"/></figure><!-- /wp:image --><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"small"} --><p class="has-small-font-size" style="font-style:normal;font-weight:600">David Lin</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group --></div><!-- /wp:group --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|20","right":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"backgroundColor":"base"} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)"><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien."</p><!-- /wp:paragraph --></blockquote><!-- /wp:quote --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15","margin":{"top":"var:preset|spacing|25"}}},"layout":{"type":"flex"}} --><div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--25)"><!-- wp:image {"width":"48px","height":"48px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:48px;height:48px"/></figure><!-- /wp:image --><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"small"} --><p class="has-small-font-size" style="font-style:normal;font-weight:600">Emily Patel</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}}} --><div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|20","right":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"backgroundColor":"base"} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)"><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><!-- /wp:paragraph --></blockquote><!-- /wp:quote --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15","margin":{"top":"var:preset|spacing|25"}}},"layout":{"type":"flex"}} --><div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--25)"><!-- wp:image {"width":"48px","height":"48px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:48px;height:48px"/></figure><!-- /wp:image --><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"small"} --><p class="has-small-font-size" style="font-style:normal;font-weight:600">Richard Garcia</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group --></div><!-- /wp:group --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|20","right":"var:preset|spacing|20","bottom":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"backgroundColor":"base"} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--20)"><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Duis enim elit porttitor id feugiat at blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla purus."</p><!-- /wp:paragraph --></blockquote><!-- /wp:quote --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15","margin":{"top":"var:preset|spacing|25"}}},"layout":{"type":"flex"}} --><div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--25)"><!-- wp:image {"width":"48px","height":"48px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:48px;height:48px"/></figure><!-- /wp:image --><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"small"} --><p class="has-small-font-size" style="font-style:normal;font-weight:600">James Clark</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-2-columns-image',
	array(
		'title'      => __( 'Testimonials 2 columns: image', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|45"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:quote {"style":{"typography":{"lineHeight":"1.4"}},"className":"is-style-plain","fontSize":"medium"} --><blockquote class="wp-block-quote is-style-plain has-medium-font-size" style="line-height:1.4"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat."</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:quote {"style":{"typography":{"lineHeight":1.4}},"className":"is-style-plain","fontSize":"medium"} --><blockquote class="wp-block-quote is-style-plain has-medium-font-size" style="line-height:1.4"><!-- wp:paragraph --><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet."</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-2-columns-cover',
	array(
		'title'      => __( 'Testimonials 2 columns: cover', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"layout":{"type":"constrained"}} --><div class="wp-block-column"><!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '","isUserOverlayColor":true,"customGradient":"linear-gradient(0deg,rgba(0,0,0,0.8) 0%,rgba(0,0,0,0) 80%)","contentPosition":"bottom left"} --><div class="wp-block-cover has-custom-content-position is-position-bottom-left"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim wp-block-cover__gradient-background has-background-gradient" style="background:linear-gradient(0deg,rgba(0,0,0,0.8) 0%,rgba(0,0,0,0) 80%)"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3"}},"textColor":"white","className":"is-style-plain","fontSize":"large"} --><blockquote class="wp-block-quote is-style-plain has-white-color has-text-color has-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut dolore."</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:cover --></div><!-- /wp:column --><!-- wp:column {"layout":{"type":"constrained"}} --><div class="wp-block-column"><!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '","isUserOverlayColor":true,"customGradient":"linear-gradient(0deg,rgba(0,0,0,0.8) 0%,rgba(0,0,0,0) 80%)","contentPosition":"bottom left"} --><div class="wp-block-cover has-custom-content-position is-position-bottom-left"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim wp-block-cover__gradient-background has-background-gradient" style="background:linear-gradient(0deg,rgba(0,0,0,0.8) 0%,rgba(0,0,0,0) 80%)"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3"}},"textColor":"white","className":"is-style-plain","fontSize":"large"} --><blockquote class="wp-block-quote is-style-plain has-white-color has-text-color has-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna congue velit."</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:cover --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-3-columns-x-2',
	array(
		'title'      => __( 'Testimonials 3 columns x 2', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|50"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--50)">' . esc_html_x( 'What our customers are saying about us', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|25"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"className":"is-style-tw-icon"} --><blockquote class="wp-block-quote is-style-tw-icon"><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat.</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"className":"is-style-tw-icon"} --><blockquote class="wp-block-quote is-style-tw-icon"><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"className":"is-style-tw-icon"} --><blockquote class="wp-block-quote is-style-tw-icon"><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet.</p><!-- /wp:paragraph --><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50"},"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|25"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"className":"is-style-tw-icon"} --><blockquote class="wp-block-quote is-style-tw-icon"><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --><cite>Julie Miller, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"className":"is-style-tw-icon"} --><blockquote class="wp-block-quote is-style-tw-icon"><!-- wp:paragraph --><p>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus. Integer sagittis efficitur rhoncus justo vehicula sapien.</p><!-- /wp:paragraph --><cite>Eric Wilson, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"className":"is-style-tw-icon"} --><blockquote class="wp-block-quote is-style-tw-icon"><!-- wp:paragraph --><p>Mauris dui tellus mollis quis varius sit amet ultrices in leo. Cras et purus sit amet velit congue convallis nec id diam.</p><!-- /wp:paragraph --><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-3-columns-card-with-icon',
	array(
		'title'      => __( 'Testimonials 3 columns: card with icon', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'What our customers are saying about us', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --> <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:quote {"className":"is-style-tw-icon"} --><blockquote class="wp-block-quote is-style-tw-icon"><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat.</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:quote {"className":"is-style-tw-icon"} --><blockquote class="wp-block-quote is-style-tw-icon"><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit. Proin varius libero diam laoreet. </p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:quote {"className":"is-style-tw-icon"} --><blockquote class="wp-block-quote is-style-tw-icon"><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet.</p><!-- /wp:paragraph --><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-3-columns-card-with-thumbnail',
	array(
		'title'      => __( 'Testimonials 3 columns: card with thumbnail', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:image {"align":"center","width":"60px","height":"60px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image aligncenter is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:60px;height:60px"/></figure><!-- /wp:image --><!-- wp:quote {"align":"center","className":"is-style-plain"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat."</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:image {"align":"center","width":"60px","height":"60px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image aligncenter is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:60px;height:60px"/></figure><!-- /wp:image --><!-- wp:quote {"align":"center","className":"is-style-plain"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain"><!-- wp:paragraph --><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . ' </cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:image {"align":"center","width":"60px","height":"60px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image aligncenter is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:60px;height:60px"/></figure><!-- /wp:image --><!-- wp:quote {"align":"center","className":"is-style-plain"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain"><!-- wp:paragraph --><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet."</p><!-- /wp:paragraph --><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-3-columns-card-with-image',
	array(
		'title'      => __( 'Testimonials 3 columns: card with image', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat."</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column {"backgroundColor":"base","className":"/"} --><div class="wp-block-column / has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column {"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph --><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet."</p><!-- /wp:paragraph --><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-4-columns-thumbnail',
	array(
		'title'      => __( 'Testimonials 4 columns: thumbnail', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'What our customers are saying about us', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|35"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15"}},"layout":{"type":"flex","flexWrap":"nowrap"}} --><div class="wp-block-group"><!-- wp:image {"width":"48px","height":"48px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:48px;height:48px"/></figure><!-- /wp:image --><!-- wp:group --><div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"small"} --><p class="has-small-font-size" style="font-style:normal;font-weight:600">David Lin</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group --><!-- wp:quote {"className":"is-style-plain","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><blockquote class="wp-block-quote is-style-plain" style="margin-top:var(--wp--preset--spacing--15)"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore."</p><!-- /wp:paragraph --></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15"}},"layout":{"type":"flex","flexWrap":"nowrap"}} --><div class="wp-block-group"><!-- wp:image {"width":"48px","height":"48px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:48px;height:48px"/></figure><!-- /wp:image --><!-- wp:group --><div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"small"} --><p class="has-small-font-size" style="font-style:normal;font-weight:600">Emily Patel</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group --><!-- wp:quote {"className":"is-style-plain","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><blockquote class="wp-block-quote is-style-plain" style="margin-top:var(--wp--preset--spacing--15)"><!-- wp:paragraph --><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><!-- /wp:paragraph --></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15"}},"layout":{"type":"flex","flexWrap":"nowrap"}} --><div class="wp-block-group"><!-- wp:image {"width":"48px","height":"48px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:48px;height:48px"/></figure><!-- /wp:image --><!-- wp:group --><div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"small"} --><p class="has-small-font-size" style="font-style:normal;font-weight:600">Richard Garcia</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group --><!-- wp:quote {"className":"is-style-plain","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><blockquote class="wp-block-quote is-style-plain" style="margin-top:var(--wp--preset--spacing--15)"><!-- wp:paragraph --><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius."</p><!-- /wp:paragraph --></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15"}},"layout":{"type":"flex","flexWrap":"nowrap"}} --><div class="wp-block-group"><!-- wp:image {"width":"48px","height":"48px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:48px;height:48px"/></figure><!-- /wp:image --><!-- wp:group --><div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"600"}},"fontSize":"small"} --><p class="has-small-font-size" style="font-style:normal;font-weight:600">James Clark</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group --><!-- wp:quote {"className":"is-style-plain","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><blockquote class="wp-block-quote is-style-plain" style="margin-top:var(--wp--preset--spacing--15)"><!-- wp:paragraph --><p>"Duis enim elit porttitor id feugiat at blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet."</p><!-- /wp:paragraph --></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-horizontal-cards',
	array(
		'title'      => __( 'Testimonials: horizontal cards', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|50"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--50)">' . esc_html_x( 'What our customers are saying about us', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:media-text {"mediaType":"image","mediaWidth":35,"verticalAlignment":"center","imageFill":true,"backgroundColor":"base"} --><div class="wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center is-image-fill-element has-base-background-color has-background" style="grid-template-columns:35% auto"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="object-position:50% 50%"/></figure><div class="wp-block-media-text__content"><!-- wp:quote {"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain"><!-- wp:paragraph {"style":{"typography":{"lineHeight":1.4}}} --><p style="line-height:1.4">"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore."</p><!-- /wp:paragraph --><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:media-text --><!-- wp:media-text {"mediaType":"image","mediaWidth":35,"verticalAlignment":"center","imageFill":true,"backgroundColor":"base"} --><div class="wp-block-media-text is-stacked-on-mobile is-vertically-aligned-center is-image-fill-element has-base-background-color has-background" style="grid-template-columns:35% auto"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="object-position:50% 50%"/></figure><div class="wp-block-media-text__content"><!-- wp:quote {"style":{"typography":{"lineHeight":1.4}},"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain" style="line-height:1.4"><!-- wp:paragraph --><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><!-- /wp:paragraph --><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:media-text --></div><!-- /wp:group -->',
	)
);

