<?php
/**
 * Team block patterns.
 *
 * @package twentig
 * @phpcs:disable Squiz.Strings.DoubleQuoteUsage.NotRequired
 */

$group_name = esc_html_x( 'Team', 'Block pattern category', 'default' );

twentig_register_block_pattern(
	'twentig/team-2-columns',
	array(
		'title'      => __( 'Team 2 columns', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed ullamcorper at metus.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Duis enim elit porttitor id feugiat at blandit at erat.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-2-columns-centered-content',
	array(
		'title'      => __( 'Team 2 columns: centered content', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"textAlign":"center","level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-text-align-center has-large-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"textAlign":"center","level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-text-align-center has-large-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50"},"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"textAlign":"center","level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-text-align-center has-large-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"textAlign":"center","level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-text-align-center has-large-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);


twentig_register_block_pattern(
	'twentig/team-3-columns',
	array(
		'title'      => __( 'Team 3 columns', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-3-columns-circle-image',
	array(
		'title'      => __( 'Team 3 columns: circle image', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|45"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"align":"center","width":"160px","height":"160px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image aligncenter is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:160px;height:160px"/></figure><!-- /wp:image --><!-- wp:heading {"textAlign":"center","level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-text-align-center has-large-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center  has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore.</p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","size":"has-small-icon-size","className":"is-style-logos-only","layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"align":"center","width":"160px","height":"160px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image aligncenter is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:160px;height:160px"/></figure><!-- /wp:image --><!-- wp:heading {"textAlign":"center","level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-text-align-center has-large-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center  has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","size":"has-small-icon-size","className":"is-style-logos-only","layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"align":"center","width":"160px","height":"160px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image aligncenter is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:160px;height:160px"/></figure><!-- /wp:image --><!-- wp:heading {"textAlign":"center","level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-text-align-center has-large-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center  has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","size":"has-small-icon-size","className":"is-style-logos-only","layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-3-columns-x-2',
	array(
		'title'      => __( 'Team 3 columns x 2', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|25"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50"},"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|25"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Eric Wilson</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-3-columns-top-border',
	array(
		'title'      => __( 'Team 3 columns: top border', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"},"margin":{"top":"var:preset|spacing|50"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Eric Wilson</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Duis enim elit porttitor id feugiat at blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus. Integer sagittis efficitur rhoncus justo.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Mauris dui tellus mollis quis varius sit amet ultrices in leo. Cras et purus sit amet velit congue convallis nec id diam.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-4-columns-x-2',
	array(
		'title'      => __( 'Team 4 columns x 2', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|25"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Eric Wilson</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50"},"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|25"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">James Clark</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Susan Harris</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-4-columns-top-border',
	array(
		'title'      => __( 'Team 4 columns: top border', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|30"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Eric Wilson</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50"},"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|30"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">James Clark</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Susan Harris</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"top":{"width":"1px"},"right":{},"bottom":{},"left":{}},"spacing":{"padding":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-list',
	array(
		'title'      => __( 'Team: list', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns"><!-- wp:column {"width":"120px"} --><div class="wp-block-column" style="flex-basis:120px"><!-- wp:image {"width":"120px","height":"120px","scale":"cover","style":{"border":{"radius":"100%"}},"className":"is-resized"} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:120px;height:120px"/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"width":"80%"} --><div class="wp-block-column" style="flex-basis:80%"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Class aptent taciti sociosqu ad litora torquent per conubia nostra.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/><!-- /wp:separator --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns"><!-- wp:column {"width":"120px"} --><div class="wp-block-column" style="flex-basis:120px"><!-- wp:image {"width":"120px","height":"120px","scale":"cover","style":{"border":{"radius":"100%"}},"className":"is-resized"} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:120px;height:120px"/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"width":"80%"} --><div class="wp-block-column" style="flex-basis:80%"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/><!-- /wp:separator --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns"><!-- wp:column {"width":"120px"} --><div class="wp-block-column" style="flex-basis:120px"><!-- wp:image {"width":"120px","height":"120px","scale":"cover","style":{"border":{"radius":"100%"}},"className":"is-resized"} --><figure class="wp-block-image is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:120px;height:120px"/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"width":"80%"} --><div class="wp-block-column" style="flex-basis:80%"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Mauris dui tellus mollis quis varius, sit amet ultrices.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-image-on-left',
	array(
		'title'      => __( 'Team: image on left', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"blockGap":"var:preset|spacing|60"}},"layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"default"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} --><h3>Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Class aptent taciti sociosqu ad litora torquent per conubia nostra.</p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","size":"has-small-icon-size","className":"is-style-logos-only","twHover":"opacity-down"} --><ul class="wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"default"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} --><h3>David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","size":"has-small-icon-size","className":"is-style-logos-only","twHover":"opacity-down"} --><ul class="wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-alternating-text-and-image',
	array(
		'title'      => __( 'Team: alternating text and image', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"blockGap":"var:preset|spacing|60"}},"layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} --><h3>Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Class aptent taciti sociosqu ad litora torquent per conubia nostra.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3} --><h3>David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"className":"tw-sm-order-first"} --><div class="wp-block-column tw-sm-order-first"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-overlap-image',
	array(
		'title'      => __( 'Team: overlap image', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"},"blockGap":"var:preset|spacing|60"}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:media-text {"mediaType":"image","mediaWidth":56,"style":{"spacing":{"margin":{"top":"var:preset|spacing|50"}}},"backgroundColor":"base","className":"is-style-tw-overlap"} --><div class="wp-block-media-text alignwide is-stacked-on-mobile is-style-tw-overlap has-base-background-color has-background" style="margin-top:var(--wp--preset--spacing--50);grid-template-columns:56% auto"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit iaculis sed ullamcorper metus.</p><!-- /wp:paragraph --></div></div><!-- /wp:media-text --><!-- wp:media-text {"mediaPosition":"right","mediaType":"image","mediaWidth":56,"backgroundColor":"base","className":"is-style-tw-overlap"} --><div class="wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile is-style-tw-overlap has-base-background-color has-background" style="grid-template-columns:auto 56%"><div class="wp-block-media-text__content"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Duis enim elit porttitor id feugiat at blandit at erat.</p><!-- /wp:paragraph --></div><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure></div><!-- /wp:media-text --></div><!-- /wp:group -->',
	)
);
