<?php
/**
 * Single Page Layouts.
 *
 * @package twentig
 * @phpcs:disable Squiz.Strings.DoubleQuoteUsage.NotRequired
 */

twentig_register_block_pattern(
	'twentig/link-in-bio-with-profile-picture',
	array(
		'title'      => __( 'Link in bio with profile picture', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"minHeight":100,"minHeightUnit":"vh","gradient":"blush-light-purple","isDark":false,"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull is-light" style="min-height:100vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient has-blush-light-purple-gradient-background"></span><div class="wp-block-cover__inner-container"><!-- wp:image {"align":"center","width":"88px","height":"88px","scale":"cover","sizeSlug":"large","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image aligncenter size-large is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:88px;height:88px"/></figure><!-- /wp:image --><!-- wp:heading {"textAlign":"center","level":1,"style":{"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"medium"} --><h1 class="has-text-align-center has-medium-font-size" style="margin-top:var(--wp--preset--spacing--20)">David Lin</h1><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"fontSize":"small"} --><p class="has-text-align-center has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Freelance developer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"fontSize":"small"} --><div class="wp-block-buttons has-custom-font-size has-small-font-size" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"><!-- wp:button {"textColor":"black","width":100,"style":{"border":{"radius":"4px"},"color":{"background":"#ffffffcc"}}} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-black-color has-text-color has-background wp-element-button" style="border-radius:4px;background-color:#ffffffcc">Listen to my podcast</a></div><!-- /wp:button --><!-- wp:button {"textColor":"black","width":100,"style":{"border":{"radius":"4px"},"color":{"background":"#ffffffcc"}}} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-black-color has-text-color has-background wp-element-button" style="border-radius:4px;background-color:#ffffffcc">Watch my videos on YouTube</a></div><!-- /wp:button --><!-- wp:button {"textColor":"black","width":100,"style":{"border":{"radius":"4px"},"color":{"background":"#ffffffcc"}}} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-black-color has-text-color has-background wp-element-button" style="border-radius:4px;background-color:#ffffffcc">View my blog</a></div><!-- /wp:button --><!-- wp:button {"textColor":"black","width":100,"style":{"border":{"radius":"4px"},"color":{"background":"#ffffffcc"}}} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-black-color has-text-color has-background wp-element-button" style="border-radius:4px;background-color:#ffffffcc">Check out my reading list</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:social-links {"iconColor":"black","iconColorValue":"#000000","customIconBackgroundColor":"#ffffffcc","iconBackgroundColorValue":"#ffffffcc","layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color has-icon-background-color tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"x"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"spotify"} /--><!-- wp:social-link {"url":"#","service":"youtube"} /--></ul><!-- /wp:social-links --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/link-in-bio-with-background-image',
	array(
		'title'      => __( 'Link in bio with background image', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":100,"minHeightUnit":"vh","align":"full","layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull" style="min-height:100vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","level":1,"fontSize":"x-large"} --><h1 class="has-text-align-center has-x-large-font-size">Julie Miller</h1><!-- /wp:heading --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"},"blockGap":{"top":"var:preset|spacing|20"}}},"layout":{"type":"flex","orientation":"vertical"}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"><!-- wp:button {"textColor":"white","className":"has-custom-width wp-block-button__width-100 is-style-outline"} --><div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-white-color has-text-color wp-element-button">Listen to my podcast</a></div><!-- /wp:button --><!-- wp:button {"textColor":"white","width":100,"className":"is-style-outline"} --><div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-white-color has-text-color wp-element-button">Watch my videos on YouTube</a></div><!-- /wp:button --><!-- wp:button {"textColor":"white","width":100,"className":"is-style-outline"} --><div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-white-color has-text-color wp-element-button">View my blog</a></div><!-- /wp:button --><!-- wp:button {"textColor":"white","width":100,"className":"is-style-outline"} --><div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-white-color has-text-color wp-element-button">Check out my reading list</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:social-links {"iconColor":"white","iconColorValue":"#ffffff","className":"is-style-logos-only","layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color is-style-logos-only tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"x"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"spotify"} /--><!-- wp:social-link {"url":"#","service":"youtube"} /--></ul><!-- /wp:social-links --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/link-in-bio-with-image-on-left',
	array(
		'title'      => __( 'Link in bio with image on left', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:media-text {"align":"full","mediaType":"image","imageFill":true,"backgroundColor":"base-2","className":"tw-height-full","twStackedMd":true,"twMediaBottom":true} --><div class="wp-block-media-text alignfull is-stacked-on-mobile is-image-fill-element tw-height-full has-base-2-background-color has-background tw-stack-md tw-media-bottom"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="object-position:50% 50%"/></figure><div class="wp-block-media-text__content"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"textAlign":"center","level":1,"fontSize":"x-large"} --><h1 class="has-text-align-center has-x-large-font-size">Julie Miller</h1><!-- /wp:heading --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"fontSize":"small"} --><div class="wp-block-buttons has-custom-font-size has-small-font-size" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"><!-- wp:button {"backgroundColor":"base","textColor":"contrast","width":100,"style":{"border":{"radius":"4px"}}} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-contrast-color has-base-background-color has-text-color has-background wp-element-button" style="border-radius:4px">Listen to my podcast</a></div><!-- /wp:button --><!-- wp:button {"backgroundColor":"base","textColor":"contrast","width":100,"style":{"border":{"radius":"4px"}}} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-contrast-color has-base-background-color has-text-color has-background wp-element-button" style="border-radius:4px">Watch my videos on YouTube</a></div><!-- /wp:button --><!-- wp:button {"backgroundColor":"base","textColor":"contrast","width":100,"style":{"border":{"radius":"4px"}}} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-contrast-color has-base-background-color has-text-color has-background wp-element-button" style="border-radius:4px">View my blog</a></div><!-- /wp:button --><!-- wp:button {"backgroundColor":"base","textColor":"contrast","width":100,"style":{"border":{"radius":"4px"}}} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-contrast-color has-base-background-color has-text-color has-background wp-element-button" style="border-radius:4px">Check out my reading list</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","className":"is-style-logos-only","layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color is-style-logos-only tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"x"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"spotify"} /--><!-- wp:social-link {"url":"#","service":"youtube"} /--></ul><!-- /wp:social-links --></div><!-- /wp:group --></div></div><!-- /wp:media-text -->',
	)
);

twentig_register_block_pattern(
	'twentig/bio-with-image-on-left',
	array(
		'title'      => __( 'Bio with image on left', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:media-text {"align":"full","mediaType":"image","imageFill":true,"backgroundColor":"contrast","textColor":"base","className":"tw-height-full","twStackedMd":true,"twMediaBottom":true} --><div class="wp-block-media-text alignfull is-stacked-on-mobile is-image-fill-element tw-height-full has-base-color has-contrast-background-color has-text-color has-background tw-stack-md tw-media-bottom"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="object-position:50% 50%"/></figure><div class="wp-block-media-text__content"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":1,"fontSize":"3-x-large"} --><h1 class="has-3-x-large-font-size">David Lin</h1><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"medium"} --><p class="has-medium-font-size" style="margin-top:var(--wp--preset--spacing--10)">Freelance developer</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|20"}}}} --><p style="margin-top:var(--wp--preset--spacing--20)">Duis finibus venenatis diam id semper. Etiam non nisi sit amet nisl lobortis hendrerit eget scelerisque lacus. Pellentesque vitae fermentum eros. Praesent congue interdum neque ac luctus. Nullam vulputate euismod massa et tincidunt, donec ultrices libero sed elit eleifend. Pellentesque posuere sagittis turpis, ut feugiat mi finibus nec odio dignissim.</p><!-- /wp:paragraph --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button {"className":"is-style-outline"} --><div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Resume', 'Button to download Curriculum Vitae', 'twentig' ) . '</a></div><!-- /wp:button --><!-- wp:button {"backgroundColor":"base","textColor":"contrast"} --><div class="wp-block-button"><a class="wp-block-button__link has-contrast-color has-base-background-color has-text-color has-background wp-element-button" href="mailto:contact@example.com">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --></div></div><!-- /wp:media-text -->',
	)
);

twentig_register_block_pattern(
	'twentig/bio-with-centered-content',
	array(
		'title'      => __( 'Bio with centered content', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"align":"full","style":{"dimensions":{"minHeight":"100vh"},"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60","left":"var:preset|spacing|site-padding","right":"var:preset|spacing|site-padding"}}},"backgroundColor":"base-2","layout":{"type":"flex","orientation":"vertical","justifyContent":"center","verticalAlignment":"center"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="min-height:100vh;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--site-padding);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--site-padding)"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:image {"align":"center","width":"160px","height":"160px","scale":"cover","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image aligncenter is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:160px;height:160px"/></figure><!-- /wp:image --><!-- wp:heading {"textAlign":"center","level":1,"fontSize":"xx-large"} --><h1 class="wp-block-heading has-text-align-center has-xx-large-font-size">Julie Miller</h1><!-- /wp:heading --><!-- wp:paragraph {"align":"center","fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size">Duis finibus venenatis diam id semper. Etiam non nisi sit amet nisl lobortis hendrerit eget scelerisque lacus. Pellentesque vitae fermentum eros. Praesent congue interdum neque ac luctus. Nullam vulputate euismod massa et tincidunt, donec ultrices libero sed elit eleifend. Pellentesque posuere sagittis turpis, ut feugiat mi finibus nec odio dignissim.</p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"black","iconColorValue":"#000000","iconBackgroundColor":"white","iconBackgroundColorValue":"#ffffff","align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}}} --><ul class="wp-block-social-links aligncenter has-icon-color has-icon-background-color" style="margin-top:var(--wp--preset--spacing--40)"><!-- wp:social-link {"url":"#","service":"x"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"mailto:contact@example.com","service":"mail"} /--></ul><!-- /wp:social-links --></div><!-- /wp:group --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/bio-with-wide-text',
	array(
		'title'      => __( 'Bio with wide text', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"minHeight":100,"minHeightUnit":"vh","gradient":"vivid-cyan-blue-to-vivid-purple","isDark":false,"align":"full","style":{"elements":{"link":{"color":{"text":"white"}}},"spacing":{"padding":{"top":"var:preset|spacing|65","bottom":"var:preset|spacing|65"}}},"textColor":"white","layout":{"type":"constrained","wideSize":"1000px"}} --><div class="wp-block-cover alignfull is-light has-white-color has-text-color has-link-color" style="padding-top:var(--wp--preset--spacing--65);padding-bottom:var(--wp--preset--spacing--65);min-height:100vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient has-vivid-cyan-blue-to-vivid-purple-gradient-background"></span><div class="wp-block-cover__inner-container"><!-- wp:group {"align":"wide"} --><div class="wp-block-group alignwide"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|15","margin":{"bottom":"var:preset|spacing|40"}}},"layout":{"type":"flex"}} --><div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--40)"><!-- wp:image {"width":"60px","height":"60px","scale":"cover","sizeSlug":"large","style":{"border":{"radius":"100%"}}} --><figure class="wp-block-image size-large is-resized has-custom-border"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" style="border-radius:100%;object-fit:cover;width:60px;height:60px"/></figure><!-- /wp:image --><!-- wp:heading {"level":1,"fontSize":"large"} --><h1 class="has-large-font-size">Julie Miller</h1><!-- /wp:heading --></div><!-- /wp:group --><!-- wp:paragraph --><p>Nullam a dignissim lacus. Nulla at orci sed arcu luctus tristique at eget mi. Curabitur finibus neque vitae sollicitudin posuere. Maecenas sed diam tellus. Sed magna massa, venenatis vitae congue sed, dignissim ut libero. Nullam lacinia vel est sit amet faucibus quisque vel quam. In turpis iaculis ultricies at ut ante. Maecenas venenatis tincidunt libero, et vitae in <a href="#">Hooli</a>, <a href="#">Initech</a>, and <a href="#">Acme</a>.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia curae. Ut ante purus, cursus eget tincidunt a, malesuada a orci. Donec rhoncus purus in erat faucibus tincidunt. In id lacus lectus. Ut facilisis mauris velit, vel pretium nisi finibus vel.</p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"white","iconColorValue":"#ffffff","customIconBackgroundColor":"#ffffff33","iconBackgroundColorValue":"#ffffff33","style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}}} --><ul class="wp-block-social-links has-icon-color has-icon-background-color" style="margin-top:var(--wp--preset--spacing--40)"><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"mailto:contact@example.com","service":"mail"} /--></ul><!-- /wp:social-links --></div><!-- /wp:group --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/coming-soon-with-call-to-action',
	array(
		'title'      => __( 'Coming soon with call to action', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":100,"minHeightUnit":"vh","align":"full","style":{"spacing":{"padding":{"top":"0","bottom":"0"}}}} --><div class="wp-block-cover alignfull" style="padding-top:0;padding-bottom:0;min-height:100vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"dimensions":{"minHeight":"100vh"},"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|65"}}},"textColor":"white","layout":{"type":"flex","orientation":"vertical","justifyContent":"center","verticalAlignment":"space-between"}} --><div class="wp-block-group has-white-color has-text-color" style="min-height:100vh;padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--65)"><!-- wp:group {"className":"tw-width-100","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}},"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-width-100" style="margin-bottom:var(--wp--preset--spacing--40)"><!-- wp:site-title {"level":0,"isLink":false} /--><!-- wp:social-links {"iconColor":"white","iconColorValue":"#ffffff","size":"has-small-icon-size","className":"is-style-logos-only","twHover":"opacity-down"} --><ul class="wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"x"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul><!-- /wp:social-links --></div><!-- /wp:group --><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="has-text-align-center">' . esc_html_x( 'Coming soon', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":1.4}},"fontSize":"large"} --><p class="has-text-align-center has-large-font-size" style="line-height:1.4">Aliquam eget tellus ligula quisque convallis, turpis a efficitur dictum, augue nunc sodales.</p><!-- /wp:paragraph --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button {"backgroundColor":"white","textColor":"black"} --><div class="wp-block-button"><a class="wp-block-button__link has-black-color has-white-background-color has-text-color has-background wp-element-button">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --><!-- wp:spacer {"height":"0px"} --><div style="height:0px" aria-hidden="true" class="wp-block-spacer"></div><!-- /wp:spacer --></div><!-- /wp:group --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/coming-soon-distributed-vertically',
	array(
		'title'      => __( 'Coming soon distributed vertically', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":100,"minHeightUnit":"vh","contentPosition":"center center","align":"full","style":{"spacing":{"padding":{"top":"0","bottom":"0"}}}} --><div class="wp-block-cover alignfull" style="padding-top:0;padding-bottom:0;min-height:100vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"dimensions":{"minHeight":"100vh"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|60"},"blockGap":"var:preset|spacing|50"}},"textColor":"white","layout":{"type":"flex","orientation":"vertical","justifyContent":"center","verticalAlignment":"space-between"}} --><div class="wp-block-group has-white-color has-text-color" style="min-height:100vh;padding-top:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:site-title {"level":0,"isLink":false} /--><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="has-text-align-center">' . esc_html_x( 'Coming soon', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":1.4}},"fontSize":"large"} --><p class="has-text-align-center has-large-font-size" style="line-height:1.4">Aliquam eget tellus ligula quisque convallis, turpis a efficitur dictum, augue nunc sodales.</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:social-links {"iconColor":"black","iconColorValue":"#000000","iconBackgroundColor":"white","iconBackgroundColorValue":"#ffffff","twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color has-icon-background-color tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"x"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul><!-- /wp:social-links --></div><!-- /wp:group --></div></div><!-- /wp:cover -->',
	)
);


twentig_register_block_pattern(
	'twentig/info-card',
	array(
		'title'      => __( 'Info card', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":0,"isUserOverlayColor":true,"minHeight":100,"minHeightUnit":"vh","contentPosition":"center center","align":"full","layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull" style="min-height:100vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-0 has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|35","left":"var:preset|spacing|35","top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}},"backgroundColor":"base","textColor":"contrast"} --><div class="wp-block-group has-contrast-color has-base-background-color has-text-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:heading {"textAlign":"center","level":1,"fontSize":"xx-large"} --><h1 class="wp-block-heading has-text-align-center has-xx-large-font-size">' . esc_html_x( 'Page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">Suspendisse tristique ipsum nisi, venenatis efficitur magna lacinia non. Donec congue erat eu lacus hendrerit gravida. Phasellus finibus nisl ut dui feugiat egestas. Vivamus eget neque dolor. Morbi vulputate dolor quis purus ullamcorper rhoncus, cras ut tempor diam luctus.</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-inline has-text-align-center"} --><ul class="wp-block-list is-style-tw-inline has-text-align-center"><!-- wp:list-item --><li><a href="#">Instagram</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">YouTube</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="mailto:contact@example.com">' . esc_html_x( 'Email', 'Block pattern content', 'twentig' ) . '</a></li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:group --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/info-2-columns',
	array(
		'title'      => __( 'Info 2 columns', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":100,"minHeightUnit":"vh","align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|65","bottom":"var:preset|spacing|65"}}},"layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull" style="padding-top:var(--wp--preset--spacing--65);padding-bottom:var(--wp--preset--spacing--65);min-height:100vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"level":1,"align":"wide"} --><h1 class="alignwide">Page title</h1><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|55"},"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"><!-- wp:column {"width":"66.66%"} --><div class="wp-block-column" style="flex-basis:66.66%"><!-- wp:paragraph {"fontSize":"medium"} --><p class="has-medium-font-size">Donec sit amet augue consequat, dictum diam nec, laoreet magna. Aenean nec sagittis nibh. Phasellus sit amet commodo tortor elit libero tincidunt turpis, in nisi scelerisque congue donec. Dapibus faucibus nulla eu dignissim. Curabitur at condimentum massa. Aliquam lobortis sit amet ipsum ut tincidunt. Proin mollis ipsum ornare ultrices sit amet ut dolor metus a sem. Nulla pulvinar elementum arcu et tincidunt ligula lobortis.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"width":"33.33%"} --><div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:paragraph --><p><strong>' . esc_html_x( 'Date', 'Block pattern content', 'twentig' ) . '</strong><br>' . esc_html_x( 'Monday, October 24', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><strong>' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</strong><br>16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:buttons {"align":"wide"} --><div class="wp-block-buttons alignwide"><!-- wp:button {"backgroundColor":"white","textColor":"black"} --><div class="wp-block-button"><a class="wp-block-button__link has-black-color has-white-background-color has-text-color has-background wp-element-button">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/info-3-columns',
	array(
		'title'      => __( 'Info 3 columns', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":100,"minHeightUnit":"vh","align":"full","style":{"spacing":{"padding":{"top":"0","bottom":"0"}}}} --><div class="wp-block-cover alignfull" style="padding-top:0;padding-bottom:0;min-height:100vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"dimensions":{"minHeight":"100vh"},"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|65"}}},"textColor":"white","layout":{"type":"flex","orientation":"vertical","justifyContent":"center","verticalAlignment":"space-between"}} --><div class="wp-block-group has-white-color has-text-color" style="min-height:100vh;padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--65)"><!-- wp:group {"className":"tw-width-100","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|50"}}},"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-width-100" style="margin-bottom:var(--wp--preset--spacing--50)"><!-- wp:site-title {"level":0,"isLink":false} /--><!-- wp:social-links {"iconColor":"white","iconColorValue":"#ffffff","className":"is-style-logos-only","twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color is-style-logos-only tw-hover-opacity-down"><!-- wp:social-link {"url":"#","service":"x"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul><!-- /wp:social-links --></div><!-- /wp:group --><!-- wp:group {"className":"tw-width-100","layout":{"type":"constrained"}} --><div class="wp-block-group tw-width-100"><!-- wp:heading {"textAlign":"center","level":1,"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|50"}}}} --><h1 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--50)">' . esc_html_x( 'Page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"style":{"border":{"style":"solid","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"borderColor":"tertiary"} --><div class="wp-block-column has-border-color has-tertiary-border-color" style="border-style:solid;border-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"textAlign":"center","fontSize":"medium"} --><h2 class="has-text-align-center has-medium-font-size">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--15)">16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"style":"solid","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"borderColor":"tertiary"} --><div class="wp-block-column has-border-color has-tertiary-border-color" style="border-style:solid;border-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"textAlign":"center","fontSize":"medium"} --><h2 class="has-text-align-center has-medium-font-size">Opening hours</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--15)">' . esc_html_x( 'Monday - Friday: 9am - 7pm', 'Block pattern content', 'twentig' ) . '<br>' . esc_html_x( 'Saturday: 9am - 10pm', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"border":{"style":"solid","width":"1px"},"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"borderColor":"tertiary"} --><div class="wp-block-column has-border-color has-tertiary-border-color" style="border-style:solid;border-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"textAlign":"center","fontSize":"medium"} --><h2 class="has-text-align-center has-medium-font-size">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--15)">(123) 456-7890<br>contact@example.com</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:spacer {"height":"0px"} --><div style="height:0px" aria-hidden="true" class="wp-block-spacer"></div><!-- /wp:spacer --></div><!-- /wp:group --></div></div><!-- /wp:cover -->',
	)
);
