<?php
/**
 * Pricing block patterns.
 *
 * @package twentig
 * @phpcs:disable Squiz.Strings.DoubleQuoteUsage.NotRequired
 */

$group_name = esc_html_x( 'Pricing', 'Block pattern category', 'twentig' );

twentig_register_block_pattern(
	'twentig/single-pricing',
	array(
		'title'      => __( 'Single pricing', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading --><h2>' . esc_html_x( 'Simple pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}},"typography":{"lineHeight":"1.2"}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--15);line-height:1.2">$19.99</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Lorem ipsum dolor sit amet, commodo erat adipiscing elit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Venenatis nec convallis aliquam tempus mi nulla porta luctus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed do eiusmod ut tempor incididunt ut labore et dolore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit nenatis nec convallis ali</li><!-- /wp:list-item --><!-- wp:list-item --><li>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/single-pricing-card',
	array(
		'title'      => __( 'Single pricing: card', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|35","right":"var:preset|spacing|35"}}},"backgroundColor":"base"} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Simple pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}},"typography":{"lineHeight":"1.2"}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--15);line-height:1.2">$19.99</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Lorem ipsum dolor sit amet, commodo erat adipiscing elit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Venenatis nec convallis aliquam tempus mi nulla porta luctus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed do eiusmod ut tempor incididunt ut labore et dolore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit nenatis nec convallis ali</li><!-- /wp:list-item --><!-- wp:list-item --><li>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-with-heading-on-left',
	array(
		'title'      => __( 'Pricing with heading on left', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide are-vertically-aligned-center tw-cols-stack-md"><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Simple pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"medium"} --><p class="has-medium-font-size">Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|35","right":"var:preset|spacing|35"}}},"backgroundColor":"base"} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis vehicula eros at dictum</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore est sollicitudin ipsum</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit id vel tellus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla nterdum est convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed non neque at lectus non mollis lacus sagittis</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-columns',
	array(
		'title'      => __( 'Pricing 2 columns', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|50"}}}} --><div class="wp-block-columns"><!-- wp:column {"className":"tw-stack"} --><div class="wp-block-column tw-stack"><!-- wp:heading {"level":3} --><h3>' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.2"}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:list {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}},"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium" style="margin-bottom:var(--wp--preset--spacing--auto)"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline"} --><div class="wp-block-button is-style-outline"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack"} --><div class="wp-block-column tw-stack"><!-- wp:heading {"level":3} --><h3>' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.2"}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:list {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}},"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium" style="margin-bottom:var(--wp--preset--spacing--auto)"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed non neque at lectus</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-column-cards',
	array(
		'title'      => __( 'Pricing 2 column cards', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --> <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"className":"tw-stack","style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|35","bottom":"var:preset|spacing|40","left":"var:preset|spacing|35"}}},"backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><p style="margin-bottom:var(--wp--preset--spacing--auto)">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur placerat non quam ac blandit. Morbi eleifend sollicitudin ipsum, eget pulvinar est placerat eu.</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack","style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|35","bottom":"var:preset|spacing|40","left":"var:preset|spacing|35"}}},"backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><p style="margin-bottom:var(--wp--preset--spacing--auto)">Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Duis enim elit, porttitor id feugiat, blandit at erat. Proin varius libero sit amet.</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-column-cards-full-width-button',
	array(
		'title'      => __( 'Pricing 2 column cards: full width button', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --> <!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} --><div class="wp-block-columns"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"textAlign":"center","level":3} --><h3 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-text-align-center has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"textAlign":"center","level":3} --><h3 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-text-align-center has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Morbi fringilla sapien libero</li><!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim porttitor id feugiat</li><!-- /wp:list-item --><!-- wp:list-item --><li>Proin varius libero amet</li><!-- /wp:list-item --><!-- wp:list-item --><li>Fusce sed magna eu ligula</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-column-cards-middle-alignment',
	array(
		'title'      => __( 'Pricing 2 column cards: middle alignment', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"verticalAlignment":"center","className":"has-text-align-center","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns are-vertically-aligned-center has-text-align-center"><!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column is-vertically-aligned-center has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:list {"style":{"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"className":"is-style-tw-no-bullet tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-no-bullet tw-list-spacing-medium" style="margin-top:var(--wp--preset--spacing--20)"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column is-vertically-aligned-center has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:list {"style":{"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"className":"is-style-tw-no-bullet tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-no-bullet tw-list-spacing-medium" style="margin-top:var(--wp--preset--spacing--20)"><!-- wp:list-item --><li>Sed non neque at lectus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Morbi fringilla sapien libero</li><!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim elit porttitor</li><!-- /wp:list-item --><!-- wp:list-item --><li>Proin varius libero amet tortor</li><!-- /wp:list-item --><!-- wp:list-item --><li>Fusce sed magna eu ligula</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer sagittis efficitur</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-column-cards-image',
	array(
		'title'      => __( 'Pricing 2 column cards: image', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"className":"tw-stack","backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:group --><!-- wp:group {"style":{"spacing":{"padding":{"top":"0","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"var:preset|spacing|auto"}}},"layout":{"type":"constrained"}} --><div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--auto);padding-top:0;padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack","backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.2"}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Aliquam tempus mi nulla</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed neque lectus bibendum</li><!-- /wp:list-item --><!-- wp:list-item --><li>Morbi fringilla sapien libero</li><!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim elit porttitor id</li><!-- /wp:list-item --><!-- wp:list-item --><li>Fusce magna eu ligula</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:group --><!-- wp:group {"style":{"spacing":{"padding":{"top":"0","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"var:preset|spacing|auto"}}},"layout":{"type":"constrained"}} --><div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--auto);padding-top:0;padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-columns',
	array(
		'title'      => __( 'Pricing 3 columns', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|45"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"className":"tw-stack"} --><div class="wp-block-column tw-stack"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$120</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><p class="has-secondary-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--auto)">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack"} --><div class="wp-block-column tw-stack"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.2"}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$200</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><p class="has-secondary-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--auto)">Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit.</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack"} --><div class="wp-block-column tw-stack"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Business', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.2"}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$380</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><p class="has-secondary-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--auto)">Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-column-cards',
	array(
		'title'      => __( 'Pricing 3 column cards', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Sed non neque at lectus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Morbi fringilla sapien</li><!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim elit porttitor</li><!-- /wp:list-item --><!-- wp:list-item --><li>Proin varius libero sit</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Business', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$89</p><!-- /wp:paragraph --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Fusce magna eu ligula</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer sagittis efficitur</li><!-- /wp:list-item --><!-- wp:list-item --><li>Mauris dui tellus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Class aptent taciti</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-column-cards-checkmarked-list',
	array(
		'title'      => __( 'Pricing 3 column cards: checkmarked list', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"className":"tw-stack","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><ul style="margin-bottom:var(--wp--preset--spacing--auto)" class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|35"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--35)"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><ul style="margin-bottom:var(--wp--preset--spacing--auto)" class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla porta luctus</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|35"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--35)"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Business', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$89</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><ul style="margin-bottom:var(--wp--preset--spacing--auto)" class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla porta luctus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Lectus bibendum blandit</li><!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|35"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--35)"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-column-cards-full-width-button',
	array(
		'title'      => __( 'Pricing 3 column cards: full width button', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"tw-list-spacing-medium is-style-tw-border-inner"} --><ul class="wp-block-list tw-list-spacing-medium is-style-tw-border-inner"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"tw-list-spacing-medium is-style-tw-border-inner"} --><ul class="wp-block-list tw-list-spacing-medium is-style-tw-border-inner"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla porta luctus</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Business', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"xx-large"} --><p class="has-xx-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$89</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"tw-list-spacing-medium is-style-tw-border-inner"} --><ul class="wp-block-list tw-list-spacing-medium is-style-tw-border-inner"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla porta luctus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Lectus bibendum blandit</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-column-cards-image',
	array(
		'title'      => __( 'Pricing 3 column cards: image', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --> <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --> <div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"className":"tw-stack","backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --> <!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.2"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$120</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary"} --><p class="has-secondary-color has-text-color">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"style":{"spacing":{"padding":{"top":"0","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"var:preset|spacing|auto"}}},"layout":{"type":"constrained"}} --><div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--auto);padding-top:0;padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack","backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.2"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$200</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary"} --><p class="has-secondary-color has-text-color">Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"style":{"spacing":{"padding":{"top":"0","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"var:preset|spacing|auto"}}},"layout":{"type":"constrained"}} --><div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--auto);padding-top:0;padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack","backgroundColor":"base"} --><div class="wp-block-column tw-stack has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Business', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.2"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$380</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary"} --><p class="has-secondary-color has-text-color">Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"style":{"spacing":{"padding":{"top":"0","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"},"margin":{"top":"var:preset|spacing|auto"}}},"layout":{"type":"constrained"}} --><div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--auto);padding-top:0;padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-columns-image',
	array(
		'title'      => __( 'Pricing 3 columns: image', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --> <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|65","left":"var:preset|spacing|30"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eius tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eius tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Business', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$89</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eius tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed non neque at bibendum</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-4-columns',
	array(
		'title'      => __( 'Pricing 4 columns', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|65","left":"var:preset|spacing|30"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"className":"tw-stack"} --><div class="wp-block-column tw-stack"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"x-large"} --><p class="has-x-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><p class="has-secondary-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--auto)">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor.</p><!-- /wp:paragraph --><!-- wp:buttons {"layout":{"type":"flex"}} --><div class="wp-block-buttons"><!-- wp:button {"fontSize":"small"} --><div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack"} --><div class="wp-block-column tw-stack"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"x-large"} --><p class="has-x-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><p class="has-secondary-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--auto)">Integer enim risus suscipit eu iaculis, ullamcorper at metus. Venenatis nec convallis magna.</p><!-- /wp:paragraph --><!-- wp:buttons {"layout":{"type":"flex"}} --><div class="wp-block-buttons"><!-- wp:button {"fontSize":"small"} --><div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack"} --><div class="wp-block-column tw-stack"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Business', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"x-large"} --><p class="has-x-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$89</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><p class="has-secondary-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--auto)">Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit libero.</p><!-- /wp:paragraph --><!-- wp:buttons {"layout":{"type":"flex"}} --><div class="wp-block-buttons"><!-- wp:button {"fontSize":"small"} --><div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"className":"tw-stack"} --><div class="wp-block-column tw-stack"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Enterprise', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"x-large"} --><p class="has-x-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$250</p><!-- /wp:paragraph --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|auto"}}}} --><p class="has-secondary-color has-text-color" style="margin-bottom:var(--wp--preset--spacing--auto)">Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet.</p><!-- /wp:paragraph --><!-- wp:buttons {"layout":{"type":"flex"}} --><div class="wp-block-buttons"><!-- wp:button {"fontSize":"small"} --><div class="wp-block-button has-custom-font-size has-small-font-size"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-card',
	array(
		'title'      => __( 'Price list: card', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide are-vertically-aligned-center tw-cols-stack-md"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"style":{"typography":{"lineHeight":"1.4"},"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|35","right":"var:preset|spacing|35"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35);line-height:1.4"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:paragraph --><p>Integer enim risus</p><!-- /wp:paragraph --><!-- wp:paragraph {"className":"tw-whitespace-nowrap"} --><p class="tw-whitespace-nowrap">$18</p><!-- /wp:paragraph --></div><!-- /wp:group --> <!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:paragraph --><p>Sed ullamcorper</p><!-- /wp:paragraph --><!-- wp:paragraph {"className":"tw-whitespace-nowrap"} --><p class="tw-whitespace-nowrap">$16</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:paragraph --><p>Aliquam tempus mi nulla</p><!-- /wp:paragraph --><!-- wp:paragraph {"className":"tw-whitespace-nowrap"} --><p class="tw-whitespace-nowrap">$20</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:paragraph --><p>At lectus bibendum</p><!-- /wp:paragraph --><!-- wp:paragraph {"className":"tw-whitespace-nowrap"} --><p class="tw-whitespace-nowrap">$13</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:paragraph --><p>Duis enim elit</p><!-- /wp:paragraph --><!-- wp:paragraph {"className":"tw-whitespace-nowrap"} --><p class="tw-whitespace-nowrap">$15</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-short-description',
	array(
		'title'      => __( 'Price list: short description', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":1.4}}} --><p class="has-secondary-color has-text-color" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">Sed do eiusmod ut tempor incididunt ut labore et dolore</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap"} --><p class="tw-whitespace-nowrap">$16</p><!-- /wp:paragraph --></div><!-- /wp:group --> <!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":1.4}}} --><p class="has-secondary-color has-text-color" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">Venenatis nec convallis magna eu congue velit</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap"} --><p class="tw-whitespace-nowrap">$18</p><!-- /wp:paragraph --></div><!-- /wp:group --> <!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":1.4}}} --><p class="has-secondary-color has-text-color" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">Fusce sed magna eu ligula commodo hendrerit fringilla</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap"} --><p class="tw-whitespace-nowrap">$15</p><!-- /wp:paragraph --></div><!-- /wp:group --> <!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p class="has-secondary-color has-text-color" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">Duis enim elit porttitor id feugiat at blandit at erat</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap"} --><p class="tw-whitespace-nowrap">$24</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-centered-text',
	array(
		'title'      => __( 'Price list: centered text', 'twentig' ),
		'categories' => array( 'pricing' ), 
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-text-align-center has-medium-font-size" style="margin-top:var(--wp--preset--spacing--40)">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","align":"center","style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}}} --><p class="has-secondary-color has-text-color has-text-align-center" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Lorem ipsum dolor sit amet commodo erat adipiscing elit</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10)">$18</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-text-align-center has-medium-font-size" style="margin-top:var(--wp--preset--spacing--40)">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","align":"center","style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}}} --><p class="has-secondary-color has-text-color has-text-align-center " style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Integer enim risus suscipit eu iaculis sed ullamcorper at metus</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10)">$16</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-text-align-center has-medium-font-size" style="margin-top:var(--wp--preset--spacing--40)">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","align":"center","style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}}} --><p class="has-secondary-color has-text-color has-text-align-center" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Aliquam tempus mi nulla porta luctus non neque at lectus bibendum blandit</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10)">$20</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-text-align-center has-medium-font-size" style="margin-top:var(--wp--preset--spacing--40)">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","align":"center","style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}}} --><p class="has-secondary-color has-text-color has-text-align-center" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Duis enim elit porttitor id feugiat at blandit at erat varius libero amet</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10)">$13</p><!-- /wp:paragraph --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-description',
	array(
		'title'      => __( 'Price list: description', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","className":"tw-whitespace-nowrap"} --><p class="has-secondary-color has-text-color tw-whitespace-nowrap">$120</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis consectetur consectetur est.</p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"/><!-- /wp:separator --><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","className":"tw-whitespace-nowrap"} --><p class="has-secondary-color has-text-color tw-whitespace-nowrap">$240</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna eu congue velit. Suspendisse vel nulla at lectus fermentum faucibus vitae at mi.</p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"/><!-- /wp:separator --><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","className":"tw-whitespace-nowrap"} --><p class="has-secondary-color has-text-color tw-whitespace-nowrap">$260</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Vestibulum consectetur sodales nisl et ultrices.</p><!-- /wp:paragraph --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-2-column-cards',
	array(
		'title'      => __( 'Price list: 2 column cards', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"},"blockGap":"var:preset|spacing|20"}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|35","bottom":"var:preset|spacing|40","left":"var:preset|spacing|35"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","className":"tw-whitespace-nowrap"} --><p class="has-secondary-color has-text-color tw-whitespace-nowrap">$18</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis consectetur consectetur est. Nunc vestibulum id lectus eu vestibulum.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|35","bottom":"var:preset|spacing|40","left":"var:preset|spacing|35"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","className":"tw-whitespace-nowrap"} --><p class="has-secondary-color has-text-color tw-whitespace-nowrap">$16</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit. Suspendisse vel nulla at lectus fermentum faucibus vitae at mi neque ac suscipit porta.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|35","bottom":"var:preset|spacing|40","left":"var:preset|spacing|35"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","className":"tw-whitespace-nowrap"} --><p class="has-secondary-color has-text-color tw-whitespace-nowrap">$13</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Vestibulum consectetur sodales nisl et ultrices. Quisque sed ligula lectus.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|35","bottom":"var:preset|spacing|40","left":"var:preset|spacing|35"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"textColor":"secondary","className":"tw-whitespace-nowrap"} --><p class="has-secondary-color has-text-color tw-whitespace-nowrap">$15</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Integer malesuada risus blandit dignissim convallis.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-3-columns',
	array(
		'title'      => __( 'Price list: 3 columns', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|45"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Lorem ipsum dolor sit amet commodo</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$18</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Integer enim risus suscipit eu iaculis</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$16</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Aliquam tempus mi nulla porta luctus</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$20</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|45"},"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Duis enim elit porttitor id feugiat</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$13</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Fifth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Fusce sed magna eu ligula hendrerit</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$15</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Sixth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Mauris dui tellus mollis quis varius</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$24</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-3-columns-with-centered-text',
	array(
		'title'      => __( 'Price list: 3 columns with centered text', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|45"}}},"className":"has-text-align-center"} --><div class="wp-block-columns alignwide has-text-align-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Lorem ipsum dolor sit amet commodo erat adipiscing elit</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"small"} --><p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">$18</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Integer enim risus suscipit eu iaculis sed ullamcorper at metus</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"small"} --><p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">$16</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Aliquam tempus mi nulla porta luctus non neque at lectus bibendum blandit</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"small"} --><p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">$20</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","className":"has-text-align-center","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|45"},"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-columns alignwide has-text-align-center" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Duis enim elit porttitor id feugiat at blandit at erat varius libero amet</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"small"} --><p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">$13</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Fifth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Fusce sed magna eu ligula commodo hendrerit fringilla ac purus</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"small"} --><p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">$15</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Sixth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Mauris dui tellus mollis quis varius sit amet ultrices in leo</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"small"} --><p class="has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">$24</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-3-columns-with-image',
	array(
		'title'      => __( 'Price list: 3 columns with image', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|25"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Lorem ipsum dolor sit amet commodo</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$18</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Integer enim risus suscipit eu iaculis</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$16</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Aliquam tempus mi nulla porta luctus</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$20</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|25"},"margin":{"top":"var:preset|spacing|60"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Duis enim elit porttitor id feugiat</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$13</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Fifth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Fusce sed magna eu ligula hendrerit</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$15</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Sixth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Mauris dui tellus mollis quis varius</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$24</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-4-columns-with-image',
	array(
		'title'      => __( 'Price list: 4 columns with image', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">$12</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">$15</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">$12</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape4.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">$16</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|60"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape5.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Fifth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">$16</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape6.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Sixth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">$14</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape7.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Seventh item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">$20</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape8.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Eighth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">$15</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-image-on-left',
	array(
		'title'      => __( 'Price list: image on left', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'square1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|30"}}}} --><h2 class="wp-block-heading" style="margin-bottom:var(--wp--preset--spacing--30)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:group {"className":"tw-align-baseline","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":1.4}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">Sed do eiusmod ut tempor incididunt ut labore et dolore</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$16</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":1.4}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">Venenatis nec convallis magna eu congue velit</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$18</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":1.4}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">Fusce sed magna eu ligula commodo hendrerit fringilla</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$15</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"className":"tw-align-baseline","style":{"spacing":{"padding":{"top":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}},"border":{"top":{"color":"var:preset|color|tertiary","width":"1px"},"right":{},"bottom":{},"left":{}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} --><div class="wp-block-group tw-align-baseline" style="border-top-color:var(--wp--preset--color--tertiary);border-top-width:1px;margin-top:var(--wp--preset--spacing--20);padding-top:var(--wp--preset--spacing--20)"><!-- wp:group {"layout":{"type":"constrained"}} --><div class="wp-block-group"><!-- wp:heading {"level":3,"fontSize":"normal"} --><h3 class="wp-block-heading has-normal-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">Duis enim elit porttitor id feugiat at blandit at erat</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:paragraph {"className":"tw-whitespace-nowrap","fontSize":"small"} --><p class="tw-whitespace-nowrap has-small-font-size">$24</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-image-on-left-and-centered-text',
	array(
		'title'      => __( 'Price list: image on left and centered text', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background"><!-- wp:columns {""align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"layout":{"type":"constrained"}} --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'square1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|30"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--30)">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"normal"} --><h3 class="wp-block-heading has-text-align-center has-normal-font-size" style="margin-top:var(--wp--preset--spacing--20)">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Lorem ipsum dolor sit amet commodo erat adipiscing</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"small"} --><p class="has-text-align-center has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">$18</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"normal"} --><h3 class="wp-block-heading has-text-align-center has-normal-font-size" style="margin-top:var(--wp--preset--spacing--20)">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Integer enim risus suscipit eu iaculis sed ullamcorper</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"small"} --><p class="has-text-align-center has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">$16</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"normal"} --><h3 class="wp-block-heading has-text-align-center has-normal-font-size" style="margin-top:var(--wp--preset--spacing--20)">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":1.4},"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-text-align-center has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">Aliquam tempus mi nulla porta luctus non neque</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"small"} --><p class="has-text-align-center has-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">$20</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);
