<?php
/**
 * Page Layouts.
 *
 * @package twentig
 * @phpcs:disable Squiz.Strings.DoubleQuoteUsage.NotRequired
 */

twentig_register_block_pattern(
	'twentig/page-home-1',
	array(
		'title'      => _x( 'Page - Home', 'Block pattern category', 'twentig' ) . ' 1',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Hero', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","align":"center","style":{"typography":{"lineHeight":"1.35"}}} --><p class="has-text-align-center has-large-font-size" style="line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus.</p><!-- /wp:paragraph --><!-- wp:image {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}}} --><figure class="wp-block-image alignwide" style="margin-top:var(--wp--preset--spacing--60)"><img src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Text and Image', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"},"blockGap":"var:preset|spacing|65"}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained","justifyContent":"left"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed ullamcorper.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">Learn more</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"className":"tw-md-order-first"} --><div class="wp-block-column tw-md-order-first"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained","justifyContent":"left"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit. Proin varius libero sit amet tortor volutpat diam tincidunt.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">Learn more</a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained","justifyContent":"left"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">Learn more</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"className":"tw-md-order-first","layout":{"type":"default"}} --><div class="wp-block-column tw-md-order-first"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape4.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Call to Action', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a call to action heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"layout":{"type":"flex","justifyContent":"center"}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-home-2',
	array(
		'title'      => _x( 'Page - Home', 'Block pattern category', 'twentig' ) . ' 2',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":70,"minHeightUnit":"vh","align":"full","layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull" style="min-height:70vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="has-text-align-center">' . esc_html_x( 'Write a page title that captivates your audience', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button {"backgroundColor":"white","textColor":"black"} --><div class="wp-block-button"><a class="wp-block-button__link has-black-color has-white-background-color has-text-color has-background wp-element-button">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div></div><!-- /wp:cover --><!-- wp:group {"metadata":{"name":"' . esc_html__( '2 columns', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:paragraph {"fontSize":"large","align":"center","style":{"typography":{"lineHeight":"1.35"},"spacing":{"margin":{"bottom":"var:preset|spacing|65"}}}} --><p class="has-text-align-center has-large-font-size" style="line-height:1.35;margin-bottom:var(--wp--preset--spacing--65)">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed.</p><!-- /wp:paragraph --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|35"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|60"},"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|35"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--60)"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape4.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Call to Action', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Write a call to action heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-home-3',
	array(
		'title'      => _x( 'Page - Home', 'Block pattern category', 'twentig' ) . ' 3',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Hero', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":1} --><h1 class="wp-block-heading">' . esc_html_x( 'Write the page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","style":{"typography":{"lineHeight":"1.35"}}} --><p class="has-large-font-size" style="line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore.</p><!-- /wp:paragraph --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Text and Image', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:image {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}}}} --><figure class="wp-block-image alignwide" style="margin-top:var(--wp--preset--spacing--60);margin-bottom:var(--wp--preset--spacing--60)"><img src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna, eu congue velit. Proin varius libero sit amet tortor volutpat.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Testimonials', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3"}},"className":"is-style-plain","fontSize":"x-large"} --><blockquote class="wp-block-quote is-style-plain has-x-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor feugiat."</p><!-- /wp:paragraph --><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Latest posts', 'Block pattern content', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"align":"wide","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|50"}}},"fontSize":"x-large"} --><h2 class="wp-block-heading alignwide has-x-large-font-size" style="margin-bottom:var(--wp--preset--spacing--50)">' . esc_html_x( 'Latest posts', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:query {"query":{"perPage":"3","offset":"","postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false},"align":"wide"} --><div class="wp-block-query alignwide"><!-- wp:post-template {"style":{"spacing":{"blockGap":"var:preset|spacing|25"}},"layout":{"type":"grid","columnCount":3}} --><!-- wp:group {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|20"}}},"twStretchedLink":true} --><div class="wp-block-group tw-stretched-link" style="margin-bottom:var(--wp--preset--spacing--20)"><!-- wp:post-featured-image {"aspectRatio":"16/9","sizeSlug":"large"} /--><!-- wp:post-title {"isLink":true,"fontSize":"medium"} /--><!-- wp:group {"style":{"spacing":{"blockGap":"6px","margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.3"}},"textColor":"secondary","fontSize":"x-small","layout":{"type":"flex","flexWrap":"wrap"}} --><div class="wp-block-group has-secondary-color has-text-color has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.3"><!-- wp:post-terms {"term":"category"} /--><!-- wp:paragraph --><p>·</p><!-- /wp:paragraph --><!-- wp:post-date /--></div><!-- /wp:group --></div><!-- /wp:group --><!-- /wp:post-template --></div><!-- /wp:query --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-home-4',
	array(
		'title'      => _x( 'Page - Home', 'Block pattern category', 'twentig' ) . ' 4',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:pattern {"slug":"twentig/hero-with-title-on-left-and-image-at-the-bottom"} /--><!-- wp:pattern {"slug":"twentig/horizontal-cards-unstretched-image"} /--><!-- wp:group {"metadata":{"name":"' . esc_html__( '2 columns with cover', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'square1.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":500,"twStretchedLink":true} --><div class="wp-block-cover tw-stretched-link" style="min-height:500px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'square1.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","level":3} --><h3 class="has-text-align-center">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.4"}},"fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size" style="line-height:1.4">Lorem ipsum dolor sit amet.</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center"><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div></div><!-- /wp:cover --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'square2.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":500,"twStretchedLink":true} --><div class="wp-block-cover tw-stretched-link" style="min-height:500px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'square2.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","level":3} --><h3 class="has-text-align-center">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.4"}},"fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size" style="line-height:1.4">Sed do eiusmod ut tempor.</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center"><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div></div><!-- /wp:cover --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:pattern {"slug":"twentig/testimonials-2-columns-masonry"} /--><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Call to Action', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":500,"align":"wide","layout":{"type":"constrained"}} --><div class="wp-block-cover alignwide" style="min-height:500px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center","fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size">Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore.</p><!-- /wp:paragraph --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button {"backgroundColor":"white","textColor":"black"} --><div class="wp-block-button"><a class="wp-block-button__link has-black-color has-white-background-color has-text-color has-background wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div></div><!-- /wp:cover --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-about-1',
	array(
		'title'      => _x( 'Page - About', 'Block pattern category', 'twentig' ) . ' 1',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Hero', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a page title that captivates your audience', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --> <!-- wp:image {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}}}} --><figure class="wp-block-image alignwide" style="margin-top:var(--wp--preset--spacing--60);margin-bottom:var(--wp--preset--spacing--60)"><img src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:paragraph {"fontSize":"large","style":{"typography":{"lineHeight":"1.35"}}} --><p class="has-large-font-size" style="line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit porta.</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Text and Image', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus. Aliquam tempus mi nulla porta luctus sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --><!-- wp:image {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}}} --><figure class="wp-block-image" style="margin-top:var(--wp--preset--spacing--60)"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Text and Image', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Write another heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Mauris dui tellus mollis quis varius, sit amet ultrices in leo. Cras et purus sit amet velit congue convallis nec id diam. Sed gravida enim sed convallis porttitor.</p><!-- /wp:paragraph --><!-- wp:image {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}}} --><figure class="wp-block-image" style="margin-top:var(--wp--preset--spacing--60)"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Text and Image', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Class aptent taciti sociosqu ad litora torquent per conubia.</p><!-- /wp:paragraph --><!-- wp:image {"style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}}} --><figure class="wp-block-image" style="margin-top:var(--wp--preset--spacing--60)"><img src="' . twentig_get_pattern_asset( 'landscape4.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-about-2',
	array(
		'title'      => _x( 'Page - About', 'Block pattern category', 'twentig' ) . ' 2',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":70,"minHeightUnit":"vh","align":"full","layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull" style="min-height:70vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a page title that captivates your audience', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --></div></div><!-- /wp:cover --><!-- wp:group {"metadata":{"name":"' . esc_html__( '3 columns', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.35"},"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}},"fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size" style="margin-bottom:var(--wp--preset--spacing--60);line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">01. ' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">02. ' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">03. ' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"},"margin":{"top":"var:preset|spacing|50"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">04. ' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">05. ' . esc_html_x( 'Fifth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus. Integer sagittis efficitur rhoncus justo.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">06. ' . esc_html_x( 'Sixth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Mauris dui tellus mollis quis varius, sit amet ultrices in leo. Cras et purus sit amet velit congue convallis nec id diam.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Team', 'Block pattern category', 'default' )  . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.35"},"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}},"fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size" style="margin-bottom:var(--wp--preset--spacing--60);line-height:1.35">Commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed.</p><!-- /wp:paragraph --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|25"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|50"},"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|25"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Eric Wilson</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--5)">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Call to Action', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a call to action heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-about-3',
	array(
		'title'      => _x( 'Page - About', 'Block pattern category', 'twentig' ) . ' 3',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Hero', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":1} --><h1 class="wp-block-heading">' . esc_html_x( 'Write the page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","style":{"typography":{"lineHeight":"1.35"}}} --><p class="has-large-font-size" style="line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"layout":{"type":"constrained"}} --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html__( 'Headings and text', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Duis enim elit, porttitor id feugiat at blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aenean at ligula pellentesque, auctor metus posuere tempus lectus. Nulla et metus vitae enim facilisis sodales interdum nec ligula. Sed dui eros maximus at tristique ac, ornare nec nunc. Sed vel ipsum justo.</p><!-- /wp:paragraph --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"},"margin":{"top":"var:preset|spacing|50"}}}} --><div class="wp-block-columns" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list {"className":"is-style-tw-border-inner"} --><ul class="wp-block-list is-style-tw-border-inner"><!-- wp:list-item --><li>Ligula commodo</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list {"className":"is-style-tw-border-inner"} --><ul class="wp-block-list is-style-tw-border-inner"><!-- wp:list-item --><li>Morbi fringilla</li><!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim elit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Proin varius libero</li><!-- /wp:list-item --><!-- wp:list-item --><li>Fusce magna</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Clients', 'Block pattern content', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|30"}}}} --><h2 class="wp-block-heading" style="margin-bottom:var(--wp--preset--spacing--30)">' . esc_html_x( 'Clients', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:list {"className":"is-style-tw-inline tw-list-spacing-medium","fontSize":"large"} --><ul class="wp-block-list is-style-tw-inline tw-list-spacing-medium has-large-font-size"><!-- wp:list-item --><li>Airbnb</li><!-- /wp:list-item --><!-- wp:list-item --><li>Apple</li><!-- /wp:list-item --><!-- wp:list-item --><li>Dropbox</li><!-- /wp:list-item --><!-- wp:list-item --><li>Figma</li><!-- /wp:list-item --><!-- wp:list-item --><li>Github</li><!-- /wp:list-item --><!-- wp:list-item --><li>Google</li><!-- /wp:list-item --><!-- wp:list-item --><li>LinkedIn</li><!-- /wp:list-item --><!-- wp:list-item --><li>Microsoft</li><!-- /wp:list-item --><!-- wp:list-item --><li>Netflix</li><!-- /wp:list-item --><!-- wp:list-item --><li>Slack</li><!-- /wp:list-item --><!-- wp:list-item --><li>Spotify</li><!-- /wp:list-item --><!-- wp:list-item --><li>Zoom</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Experience', 'Block pattern content', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} --><h2 class="wp-block-heading" style="margin-bottom:var(--wp--preset--spacing--40)">' . esc_html_x( 'Experience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . ', Initech</strong> — Paris, 2017-2022</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Quisque dignissim convallis felis vel commodo nunc pharetra sed. Vivamus nec massa nisl. Nulla egestas tortor ac lacinia gravida. Ut at viverra felis.</p><!-- /wp:paragraph --> <!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"/><!-- /wp:separator --><!-- wp:paragraph --><p><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . ', Hooli</strong> — Tokyo, 2016-2017</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Vestibulum diam quam, commodo a varius sed, congue in libero. Curabitur porta pellentesque tortor, id blandit urna. Nunc velit lectus tincidunt.</p><!-- /wp:paragraph --> <!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"/><!-- /wp:separator --><!-- wp:paragraph --><p><strong>' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . ', Acme</strong> — London, 2014-2016</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Integer et bibendum elit. Integer magna urna cursus eu ornare sit amet, dictum sit amet sapien. Donec ut sollicitudin justo tincidunt dui non augue.</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Education', 'Block pattern content', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} --><h2 class="wp-block-heading" style="margin-bottom:var(--wp--preset--spacing--40)">' . esc_html_x( 'Education', 'Block pattern content - In the context of a resume', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong>School of Design</strong> — London, 2015</p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20)"/><!-- /wp:separator --><!-- wp:paragraph --><p><strong>College of Art</strong> — Paris, 2012</p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--20);margin-bottom:var(--wp--preset--spacing--20)"/><!-- /wp:separator --><!-- wp:paragraph --><p><strong>Institute of Technology</strong> — London, 2010</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:quote {"className":"is-style-plain","style":{"typography":{"lineHeight":"1.3"}},"fontSize":"x-large"} --><blockquote class="wp-block-quote is-style-plain has-x-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor."</p><!-- /wp:paragraph --><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-about-4',
	array(
		'title'      => _x( 'Page - About', 'Block pattern category', 'twentig' ) . ' 4',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Hero', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a page title that captivates your audience', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","align":"center","style":{"typography":{"lineHeight":"1.35"},"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><p class="has-text-align-center has-large-font-size" style="line-height:1.35;margin-bottom:var(--wp--preset--spacing--60)">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt et labore.</p><!-- /wp:paragraph --><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center","width":"60%"} --><div class="wp-block-column is-vertically-aligned-center" style="flex-basis:60%"><!-- wp:image {"aspectRatio":"1","scale":"cover","sizeSlug":"large","linkDestination":"none"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'square1.jpg' ) . '" alt="" style="aspect-ratio:1;object-fit:cover"/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","width":"40%"} --><div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40%"><!-- wp:image {"aspectRatio":"4/3","scale":"cover","sizeSlug":"large","linkDestination":"none"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'square2.jpg' ) . '" alt="" style="aspect-ratio:4/3;object-fit:cover"/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:pattern {"slug":"twentig/horizontal-cards"} /--><!-- wp:group {"metadata":{"name":"' . esc_html__( 'Headings and text', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|50"}}},"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size" style="margin-top:var(--wp--preset--spacing--50)">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit. Fusce sed magna eu ligula commodo hendrerit fringilla.</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|50"}}},"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size" style="margin-top:var(--wp--preset--spacing--50)">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus.</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|50"}}},"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size" style="margin-top:var(--wp--preset--spacing--50)">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula diam commodo hendrerit phasellus. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Text and Image', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write another heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|15","left":"var:preset|spacing|15"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size" style="line-height:1.1">12x</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">lorem ipsum dolor sit amet commodo</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size" style="line-height:1.1">480</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">integer enim risus suscipit iaculis ullam</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size" style="line-height:1.1">245+</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">duis enim elit portitor id feugiat blandit</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html__( 'Gallery', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:gallery {"linkTo":"none","align":"wide"} --><figure class="wp-block-gallery alignwide has-nested-images columns-default is-cropped"><!-- wp:image {"sizeSlug":"large","linkDestination":"none"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:image {"sizeSlug":"large","linkDestination":"none"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:image {"sizeSlug":"large","linkDestination":"none"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:image {"sizeSlug":"large","linkDestination":"none"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape4.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:image {"sizeSlug":"large","linkDestination":"none"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape5.jpg' ) . '" alt=""/></figure><!-- /wp:image --></figure><!-- /wp:gallery --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-services-1',
	array(
		'title'      => _x( 'Page - Services', 'Block pattern category', 'twentig' ) . ' 1',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Hero', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write the page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","align":"center","style":{"typography":{"lineHeight":"1.35"}}} --><p class="has-text-align-center has-large-font-size" style="line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus.</p><!-- /wp:paragraph --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"layout":{"type":"flex","justifyContent":"center"}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:image {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}}} --><figure class="wp-block-image alignwide" style="margin-top:var(--wp--preset--spacing--60)"><img src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Text and Image', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'square1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained","justifyContent":"left"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}},"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size" style="margin-top:var(--wp--preset--spacing--40)">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit.</p><!-- /wp:paragraph --> <!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}},"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size" style="margin-top:var(--wp--preset--spacing--40)">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html__( '4 columns', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list --><ul><!-- wp:list-item --><li>Venenatis convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus </li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list --><ul><!-- wp:list-item --><li>Sed non neque</li><!-- /wp:list-item --><!-- wp:list-item --><li>Morbi fringilla</li><!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim elit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Proin varius libero </li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list --><ul><!-- wp:list-item --><li>Fusce magna</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer sagittis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Mauris dui tellus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Class aptent </li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape4.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list --><ul><!-- wp:list-item --><li>Rhoncus justo </li><!-- /wp:list-item --><!-- wp:list-item --><li>Amet velit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Erat vitae</li><!-- /wp:list-item --><!-- wp:list-item --><li>Maecenas convallis </li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-services-2',
	array(
		'title'      => _x( 'Page - Services', 'Block pattern category', 'twentig' ) . ' 2',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":70,"minHeightUnit":"vh","align":"full","layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull" style="min-height:70vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a page title that captivates your audience', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button {"backgroundColor":"white","textColor":"black"} --><div class="wp-block-button"><a class="wp-block-button__link has-black-color has-white-background-color has-text-color has-background wp-element-button">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div></div><!-- /wp:cover --><!-- wp:group {"metadata":{"name":"' . esc_html__( '3 columns', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.35"},"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}},"fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size" style="margin-bottom:var(--wp--preset--spacing--60);line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore.</p><!-- /wp:paragraph --><!-- wp:columns {"align":"wide","twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:pattern {"slug":"twentig/text-and-image-alternating-colored-backgrounds"} /--><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Call to Action', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Write a call to action heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-services-3',
	array(
		'title'      => _x( 'Page - Services', 'Block pattern category', 'twentig' ) . ' 3',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:pattern {"slug":"twentig/hero-with-button-and-image-on-right"} /--><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Text and Image', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"},"blockGap":"var:preset|spacing|65"}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --><!-- wp:list {"className":"tw-list-spacing-medium"} --><ul class="wp-block-list tw-list-spacing-medium"><!-- wp:list-item --><li>Proin varius libero sit amet tortor volutpat diam</li><!-- /wp:list-item --><!-- wp:list-item --><li>Venenatis nec convallis magna eu congue velit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim elit porttitor id feugiat blandit</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><!-- /wp:paragraph --><!-- wp:list {"className":"tw-list-spacing-medium"} --><ul class="wp-block-list tw-list-spacing-medium"><!-- wp:list-item --><li>Aliquam tempus mi eu nulla porta luctus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Fusce sed magna eu ligula commodo</li><!-- /wp:list-item --><!-- wp:list-item --><li>Mauris dui tellus mollis quis varius amet ultrices</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column {"className":"tw-md-order-first"} --><div class="wp-block-column tw-md-order-first"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column  --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula diam commodo hendrerit phasellus.</p><!-- /wp:paragraph --><!-- wp:list {"className":"tw-list-spacing-medium"} --><ul class="wp-block-list tw-list-spacing-medium"><!-- wp:list-item --><li>Integer enim risus suscipit eu iaculis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Quisque lorem sapien egestas sed venenatis</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:pattern {"slug":"twentig/cta-colored-background"} /-->',
	)
);

twentig_register_block_pattern(
	'twentig/page-services-4',
	array(
		'title'      => _x( 'Page - Services', 'Block pattern category', 'twentig' ) . ' 4',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Hero', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained","justifyContent":"left"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":1} --><h1 class="wp-block-heading">' . esc_html_x( 'Write the page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","style":{"typography":{"lineHeight":"1.35"}}} --><p class="has-large-font-size" style="line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore.</p><!-- /wp:paragraph --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:pattern {"slug":"twentig/3-column-cards"} /--><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Text and Image', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'square1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained","justifyContent":"left"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2 class="wp-block-heading">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --><!-- wp:list {"className":"tw-list-spacing-medium"} --><ul class="wp-block-list tw-list-spacing-medium"><!-- wp:list-item --><li>Integer enim risus suscipit eu iaculis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Quisque lorem sapien, egestas sed venenatis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla porta luctus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed non neque at lectus bibendum blandit</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:pattern {"slug":"twentig/3-column-cards"} /--><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Testimonials', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3"}},"className":"is-style-plain","fontSize":"x-large"} --><blockquote class="wp-block-quote is-style-plain has-x-large-font-size" style="line-height:1.3"><!-- wp:paragraph --><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor feugiat."</p><!-- /wp:paragraph --><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Pricing', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.35"}},"fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size" style="line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus.</p><!-- /wp:paragraph --><!-- wp:buttons {"style":{"spacing":{"margin":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|60"}}},"layout":{"type":"flex","justifyContent":"center"}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li><!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Sed non neque at lectus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Morbi fringilla sapien</li><!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim elit porttitor</li><!-- /wp:list-item --><!-- wp:list-item --><li>Proin varius libero sit</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3} --><h3 class="wp-block-heading">' . esc_html_x( 'Business', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.2"},"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><p class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10);line-height:1.2">$89</p><!-- /wp:paragraph --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="wp-block-list is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Fusce magna eu ligula</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer sagittis efficitur</li><!-- /wp:list-item --><!-- wp:list-item --><li>Mauris dui tellus</li><!-- /wp:list-item --><!-- wp:list-item --><li>Class aptent taciti</li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'FAQ', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"},"blockGap":"var:preset|spacing|15"}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'FAQs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'How does it work?', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Class aptent taciti sociosqu ad litora torquent per conubia nostra.</p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/><!-- /wp:separator --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'What payment methods do you accept?', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. </p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/><!-- /wp:separator --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'How can I contact you?', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Duis enim elit porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus.</p><!-- /wp:paragraph --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-contact-1',
	array(
		'title'      => _x( 'Page - Contact', 'Block pattern category', 'twentig' ) . ' 1',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Contact', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","align":"center","style":{"typography":{"lineHeight":"1.35"},"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} --><p class="has-text-align-center has-large-font-size" style="line-height:1.35;margin-bottom:var(--wp--preset--spacing--40)">' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|40"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--40)">16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">(123) 456-7890<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","className":"is-style-logos-only","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color is-style-logos-only tw-hover-opacity-down" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:social-link {"url":"#","service":"facebook"} /--><!-- wp:social-link {"url":"#","service":"youtube"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --><!-- wp:image {"align":"wide","className":"","style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}}} --><figure class="wp-block-image alignwide" style="margin-top:var(--wp--preset--spacing--60)"><img src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-contact-2',
	array(
		'title'      => _x( 'Page - Contact', 'Block pattern category', 'twentig' ) . ' 2',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":70,"minHeightUnit":"vh","align":"full","layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull" style="min-height:70vh"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --></div></div><!-- /wp:cover --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Contact', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:paragraph {"fontSize":"large","style":{"typography":{"lineHeight":"1.35"}}} --><p class="has-large-font-size" style="line-height:1.35">' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:columns {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50"},"blockGap":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-columns" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-link-hover-underline"} --><p class="tw-link-hover-underline"><a href="mailto:contact@example.com">contact@example.com</a><br>(123) 456-7890</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-link-hover-underline"} --><p class="tw-link-hover-underline">16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'Follow us', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list {"className":"is-style-tw-arrow tw-link-hover-underline"} --><ul class="is-style-tw-arrow tw-link-hover-underline"><!-- wp:list-item --><li><a href="#">Twitter</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">Instagram</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">LinkedIn</a></li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-contact-3',
	array(
		'title'      => _x( 'Page - Contact', 'Block pattern category', 'twentig' ) . ' 3',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Hero', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"verticalAlignment":null,"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column {"verticalAlignment":"center","layout":{"type":"constrained","justifyContent":"left"}} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":1} --><h1 class="wp-block-heading">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","style":{"typography":{"lineHeight":"1.35"}}} --><p class="has-large-font-size" style="line-height:1.35">Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Contact', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|55"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'square1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","className":"tw-md-order-first","layout":{"type":"constrained","justifyContent":"left"}} --><div class="wp-block-column is-vertically-aligned-center tw-md-order-first"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-link-hover-underline"} --><p class="tw-link-hover-underline">(123) 456-7890<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Social', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list {"className":"tw-link-hover-underline is-style-tw-no-bullet"} --><ul class="tw-link-hover-underline is-style-tw-no-bullet"><!-- wp:list-item --><li><a href="#">Instagram</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">YouTube</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">LinkedIn</a></li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/page-contact-4',
	array(
		'title'      => _x( 'Page - Contact', 'Block pattern category', 'twentig' ) . ' 4',
		'categories' => array( 'page' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Hero', 'Block pattern category', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","level":1} --><h1 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","align":"center","style":{"typography":{"lineHeight":"1.35"}}} --><p class="has-text-align-center has-large-font-size" style="line-height:1.35">' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group --><!-- wp:group {"metadata":{"name":"' . esc_html_x( 'Contact', 'Block pattern category', 'default' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|35"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium","textAlign":"center"} --><h3 class="wp-block-heading has-medium-font-size has-text-align-center">' . esc_html_x( 'Email', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","className":"tw-link-hover-underline"} --><p class="has-text-align-center tw-link-hover-underline"><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium","textAlign":"center"} --><h3 class="wp-block-heading has-medium-font-size has-text-align-center">' . esc_html_x( 'Phone', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","className":"tw-link-hover-underline"} --><p class="has-text-align-center tw-link-hover-underline">(123) 456-7890</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium","textAlign":"center"} --><h3 class="wp-block-heading has-medium-font-size has-text-align-center">' . esc_html_x( 'Social', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"#1c1c1e","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"className":"is-style-logos-only","layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color is-style-logos-only tw-hover-opacity-down" style="margin-top:var(--wp--preset--spacing--15)"><!-- wp:social-link {"url":"#","service":"x"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"#","service":"facebook"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:image {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|60"}}}} --><figure class="wp-block-image alignwide" style="margin-top:var(--wp--preset--spacing--60)"><img src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:group -->',
	)
);
