<?php
/**
 * Numbers block patterns.
 *
 * @package twentig
 */

$group_name = esc_html__( 'Numbers', 'twentig' );

twentig_register_block_pattern(
	'twentig/stats-3-columns',
	array(
		'title'      => __( 'Stats: 3 columns', 'twentig' ),
		'categories' => array( 'numbers' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|45"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size has-text-align-center" style="line-height:1.1">12x</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">dolor sit amet commodo erat</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size has-text-align-center" style="line-height:1.1">480</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">integer enim risus eu iaculis</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size has-text-align-center" style="line-height:1.1">245+</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">aliquam tempus mi nulla luctus</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/stats-3-column-cards',
	array(
		'title'      => __( 'Stats: 3 column cards', 'twentig' ),
		'categories' => array( 'numbers' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|15","left":"var:preset|spacing|15"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size" style="line-height:1.1">12x</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">lorem ipsum dolor sit amet commodo</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size" style="line-height:1.1">480</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">integer enim risus suscipit iaculis ullam</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size" style="line-height:1.1">245+</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|5"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--5);line-height:1.4">duis enim elit portitor id feugiat blandit</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/stats-4-column-cards',
	array(
		'title'      => __( 'Stats: 4 column cards', 'twentig' ),
		'categories' => array( 'numbers' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|15","left":"var:preset|spacing|15"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-text-align-center has-3-x-large-font-size" style="line-height:1.1">12x</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">lorem ipsum dolor sit amet</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-text-align-center has-3-x-large-font-size" style="line-height:1.1">480</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">integer enim risus suscipit</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-text-align-center has-3-x-large-font-size" style="line-height:1.1">245+</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">duis feugiat portitor elit blandit</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","right":"var:preset|spacing|25","bottom":"var:preset|spacing|40","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-text-align-center has-3-x-large-font-size" style="line-height:1.1">26</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">aliquam tempus porta luctus</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/stats-4-columns-x-2',
	array(
		'title'      => __( 'Stats: 4 columns x 2', 'twentig' ),
		'categories' => array( 'numbers' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --> <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|30"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">2016</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">lorem ipsum dolor sit amet</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">98%</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">integer enim risus suscipit</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">10k</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">duis elit portitor id blandit</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">2m</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">aliquam tempus mi porta</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"margin":{"top":"var:preset|spacing|40"},"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|30"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2" style="margin-top:var(--wp--preset--spacing--40)"><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">12x</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">cras et velit congue</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">480</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">sagittis efficitur rhoncus</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">245+</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">libero sit amet tortor volutpat</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">26</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}},"typography":{"lineHeight":"1.4"}}} --><p style="margin-top:var(--wp--preset--spacing--10);line-height:1.4">fusce sed magna eu ligula</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->
',
	)
);

twentig_register_block_pattern(
	'twentig/numbers-list-with-headings',
	array(
		'title'      => __( 'Numbers: list with headings', 'twentig' ),
		'categories' => array( 'numbers' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">01. Lorem ipsum dolor sit amet</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Class aptent taciti sociosqu ad litora.</p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"/><!-- /wp:separator --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">02. Morbi fringilla sapien erat</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Cras eget mi tellus. Sed hendrerit purus quam, vel finibus dui eleifend at.</p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)"/><!-- /wp:separator --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">03. Mauris commodo accumsan</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">Duis enim elit porttitor id feugiat at blandit at erat. Proin varius libero sit amet, tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus.</p><!-- /wp:paragraph --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/numbers-3-columns',
	array(
		'title'      => __( 'Numbers: 3 columns', 'twentig' ),
		'categories' => array( 'numbers' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size has-text-align-center" style="line-height:1.1">01</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"fontSize":"large"} --><h3 class="has-large-font-size has-text-align-center" style="margin-top:var(--wp--preset--spacing--15)">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">Lorem ipsum dolor sit amet, commodo erat adipiscing elit.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size has-text-align-center" style="line-height:1.1">02</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"fontSize":"large"} --><h3 class="has-large-font-size has-text-align-center" style="margin-top:var(--wp--preset--spacing--15)">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">Integer enim risus suscipit eu iaculis sed ullamcorper at metus.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"align":"center","style":{"typography":{"lineHeight":"1.1"}},"fontSize":"4-x-large"} --><p class="has-4-x-large-font-size has-text-align-center" style="line-height:1.1">03</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"fontSize":"large"} --><h3 class="has-large-font-size has-text-align-center" style="margin-top:var(--wp--preset--spacing--15)">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">Aliquam tempus mi nulla luctus. Sed neque at lectus blandit.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/numbers-2-columns-x-2',
	array(
		'title'      => __( 'Numbers: 2 columns x 2', 'twentig' ),
		'categories' => array( 'numbers' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">01</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"fontSize":"large"} --><h3 class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--15)">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">02</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"fontSize":"large"} --><h3 class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--15)">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"},"margin":{"top":"var:preset|spacing|50"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">03</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"fontSize":"large"} --><h3 class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--15)">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"style":{"typography":{"lineHeight":"1.1"}},"fontSize":"3-x-large"} --><p class="has-3-x-large-font-size" style="line-height:1.1">04</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"fontSize":"large"} --><h3 class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--15)">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus. Integer sagittis efficitur rhoncus justo.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/numbers-3-columns-with-top-border',
	array(
		'title'      => __( 'Numbers: 3 columns with top border', 'twentig' ),
		'categories' => array( 'numbers' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Write a heading that captivates your audience', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">01. ' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">02. ' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">03. ' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|45"},"margin":{"top":"var:preset|spacing|50"}}}} --><div class="wp-block-columns alignwide" style="margin-top:var(--wp--preset--spacing--50)"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">04. ' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">05. ' . esc_html_x( 'Fifth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus. Integer sagittis efficitur rhoncus justo.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30"}},"border":{"top":{"width":"1px"}}}} --><div class="wp-block-column" style="border-top-width:1px;padding-top:var(--wp--preset--spacing--30)"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">06. ' . esc_html_x( 'Sixth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Mauris dui tellus mollis quis varius, sit amet ultrices in leo. Cras et purus sit amet velit congue convallis nec id diam.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);
