<?php
/**
  * Event & schedule block patterns.
  *
  * @package twentig
  */

twentig_register_block_pattern(
	'twentig/events-list',
	array(
		'title'      => __( 'Events: list', 'twentig' ),
		'categories' => array( 'events' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html__( 'Events', 'twentig' ) . '"},"align":"full","style":{"spacing":{"blockGap":"var:preset|spacing|15"}},"layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our events', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'First event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Friday, September 18', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed ullamcorper.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/><!-- /wp:separator --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Second event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Monday, October 24', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --><!-- wp:separator {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}}} --><hr class="wp-block-separator has-alpha-channel-opacity" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)"/><!-- /wp:separator --><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Third event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Saturday, December 12', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/events-list-with-image-on-left',
	array(
		'title'      => __( 'Events: list with image on left', 'twentig' ),
		'categories' => array( 'events' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html__( 'Events', 'twentig' ) . '"},"align":"full","style":{"spacing":{"blockGap":"var:preset|spacing|60"}},"layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our events', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'First event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Friday, September 18', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Second event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Monday, October 24', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3,"fontSize":"large"} --><h3 class="wp-block-heading has-large-font-size">' . esc_html_x( 'Third event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Saturday, December 12', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#">' . esc_html_x( 'Learn more', 'Block pattern content', 'twentig' ) . '</a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/events-column-cards',
	array(
		'title'      => __( 'Events: column cards', 'twentig' ),
		'categories' => array( 'events' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html__( 'Events', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"},"blockGap":"var:preset|spacing|20"}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Our events', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|25","right":"var:preset|spacing|25","bottom":"var:preset|spacing|25","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--25);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--25);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size">' . esc_html_x( 'Friday, September 18', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><h3 class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'First event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column {"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|25","right":"var:preset|spacing|25","bottom":"var:preset|spacing|25","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--25);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--25);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size">' . esc_html_x( 'Monday, October 24', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><h3 class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Second event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|25","right":"var:preset|spacing|25","bottom":"var:preset|spacing|25","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--25);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--25);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size">' . esc_html_x( 'Saturday, December 12', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><h3 class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Third event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --><!-- wp:column {"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape4.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|25","right":"var:preset|spacing|25","bottom":"var:preset|spacing|25","left":"var:preset|spacing|25"},"margin":{"top":"0px"}}}} --><div class="wp-block-group" style="margin-top:0px;padding-top:var(--wp--preset--spacing--25);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--25);padding-left:var(--wp--preset--spacing--25)"><!-- wp:paragraph {"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size">' . esc_html_x( 'Tuesday, January 5', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|10"}}},"fontSize":"large"} --><h3 class="has-large-font-size" style="margin-top:var(--wp--preset--spacing--10)">' . esc_html_x( 'Fourth event', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/schedule-table',
	array(
		'title'      => __( 'Schedule: table', 'twentig' ),
		'categories' => array( 'events' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html__( 'Schedule', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Schedule', 'Block pattern content (noun)', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|35","right":"var:preset|spacing|35"}}},"backgroundColor":"base","layout":{"type":"default"}} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--35)"><!-- wp:table {"hasFixedLayout":false,"className":"tw-row-valign-top is-style-tw-border-h-inner"} --><figure class="wp-block-table tw-row-valign-top is-style-tw-border-h-inner"><table><tbody><tr><td>08:00</td><td>Lorem ipsum dolor sit amet</td></tr><tr><td>10:00</td><td>Class aptent taciti sociosqu ad litora torquent ligula</td></tr><tr><td>10:30</td><td>Integer enim risus suscipit</td></tr><tr><td>12:00</td><td>Venenatis nec convallis magna</td></tr><tr><td>14:30</td><td>Proin varius libero sit amet tortor volutpat</td></tr><tr><td>16:00</td><td>Commodo erat adipiscing elit</td></tr></tbody></table></figure><!-- /wp:table --></div><!-- /wp:group --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/schedule-list-with-description',
	array(
		'title'      => __( 'Schedule: list with description', 'twentig' ),
		'categories' => array( 'events' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html__( 'Schedule', 'twentig' ) . '"},"align":"full","style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Schedule', 'Block pattern content (noun)', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|10","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns"><!-- wp:column {"width":"180px"} --><div class="wp-block-column" style="flex-basis:180px"><!-- wp:paragraph {"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size">09:00 – 10:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"width":""} --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|10","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns"><!-- wp:column {"width":"180px"} --><div class="wp-block-column" style="flex-basis:180px"><!-- wp:paragraph {"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size">10:00 – 11:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"width":""} --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|10","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns"><!-- wp:column {"width":"180px"} --><div class="wp-block-column" style="flex-basis:180px"><!-- wp:paragraph {"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size">11:00 – 12:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"width":""} --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|10","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns"><!-- wp:column {"width":"180px"} --><div class="wp-block-column" style="flex-basis:180px"><!-- wp:paragraph {"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size">14:00 – 16:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"width":"px"} --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:separator --><hr class="wp-block-separator has-alpha-channel-opacity"/><!-- /wp:separator --><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"var:preset|spacing|10","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns"><!-- wp:column {"width":"180px"} --><div class="wp-block-column" style="flex-basis:180px"><!-- wp:paragraph {"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size">16:00 – 17:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"width":""} --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Fifth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/schedule-weekly',
	array(
		'title'      => __( 'Schedule: weekly', 'twentig' ),
		'categories' => array( 'events' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . esc_html__( 'Schedule', 'twentig' ) . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Schedule', 'Block pattern content (noun)', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"style":{"border":{"bottom":{"color":"var:preset|color|tertiary","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|20"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size" style="border-bottom-color:var(--wp--preset--color--tertiary);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--20)">' . esc_html_x( 'Monday', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Lorem Ipsum</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">08:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">09:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer Enim</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">10:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Sed Neque</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">18:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Morbi</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">19:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Proin Varius</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">20:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"style":{"border":{"bottom":{"color":"var:preset|color|tertiary","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|20"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size" style="border-bottom-color:var(--wp--preset--color--tertiary);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--20)">' . esc_html_x( 'Tuesday', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Libero</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">08:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Fusce Magna</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">09:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">10:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Mauris</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">18:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">19:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Amet Velit</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">20:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"style":{"border":{"bottom":{"color":"var:preset|color|tertiary","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|20"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size" style="border-bottom-color:var(--wp--preset--color--tertiary);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--20)">' . esc_html_x( 'Wednesday', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Porta luctus</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">08:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Amet Velit</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">09:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Libero</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">10:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Morbi</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">18:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Tempus</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">19:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">20:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"style":{"border":{"bottom":{"color":"var:preset|color|tertiary","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|20"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size" style="border-bottom-color:var(--wp--preset--color--tertiary);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--20)">' . esc_html_x( 'Thursday', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Sed Neque</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">08:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Enim Elit</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">09:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">10:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Tellus</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">18:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">19:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Sapien</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">20:00</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"},"margin":{"top":"var:preset|spacing|20"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2" style="margin-top:var(--wp--preset--spacing--20)"><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"style":{"border":{"bottom":{"color":"var:preset|color|tertiary","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|20"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size" style="border-bottom-color:var(--wp--preset--color--tertiary);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--20)">' . esc_html_x( 'Friday', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Enim Elit</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">08:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Sapien</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">09:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Libero</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">10:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Tempus</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">18:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Proin Varius</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">19:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Morbi</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">20:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"style":{"border":{"bottom":{"color":"var:preset|color|tertiary","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|20"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size" style="border-bottom-color:var(--wp--preset--color--tertiary);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--20)">' . esc_html_x( 'Saturday', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Commodo</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">08:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Sed Neque</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">09:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Hendrerit</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">10:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">18:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Sapien</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">19:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Amet Velit</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">20:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","right":"var:preset|spacing|25","bottom":"var:preset|spacing|30","left":"var:preset|spacing|25"}}},"backgroundColor":"base"} --><div class="wp-block-column has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--25);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--25)"><!-- wp:heading {"level":3,"style":{"border":{"bottom":{"color":"var:preset|color|tertiary","width":"1px"}},"spacing":{"padding":{"bottom":"var:preset|spacing|20"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-medium-font-size" style="border-bottom-color:var(--wp--preset--color--tertiary);border-bottom-width:1px;padding-bottom:var(--wp--preset--spacing--20)">' . esc_html_x( 'Sunday', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>Libero</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">08:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Mauris</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:0">09:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Enim Elit</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"small"} --><p class="has-secondary-color has-text-color has-small-font-size" style="margin-top:0">10:00</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Morbi</p><!-- /wp:paragraph --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"0"}}},"textColor":"secondary","fontSize":"x-small"} --><p class="has-secondary-color has-text-color has-x-small-font-size" style="margin-top:0">11:00</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"style":{"spacing":{"padding":{"top":"0","right":"var:preset|spacing|30","bottom":"0","left":"var:preset|spacing|30"}}}} --><div class="wp-block-column" style="padding-top:0;padding-right:var(--wp--preset--spacing--30);padding-bottom:0;padding-left:var(--wp--preset--spacing--30)"></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);
