<?php
/**
 * Contact block patterns.
 *
 * @package twentig
 * @phpcs:disable Squiz.Strings.DoubleQuoteUsage.NotRequired
 */

$group_name = esc_html_x( 'Contact', 'Block pattern category', 'default' );

twentig_register_block_pattern(
	'twentig/contact-stack-with-call-to-action',
	array(
		'title'      => __( 'Contact: stack with call to action', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"},"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><div class="wp-block-buttons" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link wp-element-button">' . esc_html_x( 'Contact us', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-stack-with-social-icons',
	array(
		'title'      => __( 'Contact: stack with social icons', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center"><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --><!-- wp:social-links {"size":"has-small-icon-size","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"layout":{"type":"flex","justifyContent":"center"}} --><ul class="wp-block-social-links has-small-icon-size" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul><!-- /wp:social-links --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-stack-with-info',
	array(
		'title'      => __( 'Contact: stack with info', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">(123) 456-7890<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","className":"is-style-logos-only","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color is-style-logos-only tw-hover-opacity-down" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul><!-- /wp:social-links --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-stack-with-headings-and-info',
	array(
		'title'      => __( 'Contact: stack with headings and info', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-text-align-center has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--15)">16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-text-align-center has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Opening hours', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--15)">' . esc_html_x( 'Monday - Friday: 9am - 7pm', 'Block pattern content', 'twentig' ) . '<br>' . esc_html_x( 'Saturday: 9am - 10pm', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"fontSize":"medium"} --><h3 class="wp-block-heading has-text-align-center has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p class="has-text-align-center" style="margin-top:var(--wp--preset--spacing--15)">(123) 456-7890<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","className":"aligncenter is-style-logos-only","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"layout":{"type":"flex","justifyContent":"center"},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color aligncenter is-style-logos-only tw-hover-opacity-down" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"#","service":"facebook"} /--></ul><!-- /wp:social-links --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-2-columns',
	array(
		'title'      => __( 'Contact: 2 columns', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading --><h2>' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:columns {"style":{"spacing":{"margin":{"top":"var:preset|spacing|40"},"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}}} --><div class="wp-block-columns" style="margin-top:var(--wp--preset--spacing--40)"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-link-hover-underline"} --><p class="tw-link-hover-underline"><a href="mailto:contact@example.com">contact@example.com</a><br>(123) 456-7890</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Follow us', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list {"className":"is-style-tw-arrow tw-link-hover-underline"} --><ul class="wp-block-list is-style-tw-arrow tw-link-hover-underline"><!-- wp:list-item --><li><a href="#">Twitter</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">Instagram</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">LinkedIn</a></li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-emphasized-info',
	array(
		'title'      => __( 'Contact: emphasized info', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|50","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2>' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|35","left":"var:preset|spacing|35","top":"var:preset|spacing|40","bottom":"var:preset|spacing|40"}}},"backgroundColor":"base"} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--35)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}}} --><p style="margin-top:var(--wp--preset--spacing--15)">16 Thompson Street <br>San Francisco, CA 94102</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Phone', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"className":"tw-link-hover-underline"} --><p style="margin-top:var(--wp--preset--spacing--15)">(123) 456-7890</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Email', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"className":"tw-link-hover-underline"} --><p class="tw-link-hover-underline" style="margin-top:var(--wp--preset--spacing--15)"><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-heading-on-left',
	array(
		'title'      => __( 'Contact: heading on left', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading --><h2>' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph --><p>' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>(123) 456-7890<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","className":"is-style-logos-only","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-icon-color is-style-logos-only tw-hover-opacity-down" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"#","service":"facebook"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-image-on-right',
	array(
		'title'      => __( 'Contact: image on right', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2>' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-link-hover-underline"} --><p class="tw-link-hover-underline">(123) 456-7890<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Social', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:list {"className":"tw-link-hover-underline is-style-tw-no-bullet"} --><ul class="wp-block-list tw-link-hover-underline is-style-tw-no-bullet"><!-- wp:list-item --><li><a href="#">Twitter</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">Instagram</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">LinkedIn</a></li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"sizeSlug":"large"} --><figure class="wp-block-image size-large"><img src="' . twentig_get_pattern_asset( 'square1.jpg' ) . '" alt=""/></figure><!-- /wp:image --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-3-columns',
	array(
		'title'      => __( 'Contact: 3 columns', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --> <!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}},"twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium","textAlign":"center"} --><h3 class="wp-block-heading has-medium-font-size has-text-align-center">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium","textAlign":"center"} --><h3 class="wp-block-heading has-medium-font-size has-text-align-center">' . esc_html_x( 'Opening hours', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">' . esc_html_x( 'Monday - Friday: 9am - 7pm', 'Block pattern content', 'twentig' ) . '<br>' . esc_html_x( 'Saturday: 9am - 10pm', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium","textAlign":"center"} --><h3 class="wp-block-heading has-medium-font-size has-text-align-center">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">(123) 456-7890<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-4-columns',
	array(
		'title'      => __( 'Contact: 4 columns', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|60"}}}} --><h2 class="wp-block-heading has-text-align-center" style="margin-bottom:var(--wp--preset--spacing--60)">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}},"twStack":"md-2"} --><div class="wp-block-columns alignwide tw-cols-stack-md-2"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'General', 'Block pattern contact content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-link-hover-underline"} --><p class="tw-link-hover-underline"><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Careers', 'Block pattern contact content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-link-hover-underline"} --><p class="tw-link-hover-underline"><a href="mailto:careers@example.com">careers@example.com</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Press', 'Block pattern contact content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-link-hover-underline"} --><p class="tw-link-hover-underline"><a href="mailto:press@example.com">press@example.com</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Social', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:social-links {"iconColor":"contrast","iconColorValue":"var(--wp--preset--color--contrast)","size":"has-small-icon-size","className":"is-style-logos-only","style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"twHover":"opacity-down"} --><ul class="wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only tw-hover-opacity-down" style="margin-top:var(--wp--preset--spacing--15)"><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"#","service":"facebook"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-cover',
	array(
		'title'      => __( 'Contact: cover', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":50,"isUserOverlayColor":true,"minHeight":500,"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-cover alignfull" style="min-height:500px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center"} --><h2 class="wp-block-heading has-text-align-center">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"align":"center","fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size">16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center","fontSize":"medium"} --><p class="has-text-align-center has-medium-font-size">(123) 456-7890<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --><!-- wp:social-links {"iconColor":"black","iconColorValue":"#000000","iconBackgroundColor":"white","iconBackgroundColorValue":"#ffffff","size":"has-small-icon-size","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}},"layout":{"type":"flex","justifyContent":"center"}} --><ul class="wp-block-social-links has-small-icon-size has-icon-color has-icon-background-color" style="margin-top:var(--wp--preset--spacing--30)"><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--></ul><!-- /wp:social-links --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-opening-hours',
	array(
		'title'      => __( 'Contact: opening hours', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|70","bottom":"var:preset|spacing|70"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70)"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading --><h2>' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>' . esc_html_x( 'If you have any questions or just want to say hello, please don’t hesitate to contact us. We’ll get back to you soon.', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>(123) 456-7890<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|30","left":"var:preset|spacing|35","right":"var:preset|spacing|35"}}},"backgroundColor":"base"} --><div class="wp-block-group has-base-background-color has-background" style="padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--35);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--35)"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Opening hours', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:table {"style":{"spacing":{"margin":{"top":"var:preset|spacing|15"}}},"className":"is-style-tw-border-h-inner tw-row-valign-top","fontSize":"small"} --><figure class="wp-block-table is-style-tw-border-h-inner tw-row-valign-top has-small-font-size" style="margin-top:var(--wp--preset--spacing--15)"><table><tbody><tr><td>' . esc_html_x( 'Monday', 'Block pattern content', 'twentig' ) . '</td><td class="has-text-align-right" data-align="right">' . esc_html_x( '9am - 7pm', 'Block pattern content', 'twentig' ) . '</td></tr><tr><td>' . esc_html_x( 'Tuesday', 'Block pattern content', 'twentig' ) . '</td><td class="has-text-align-right" data-align="right">' . esc_html_x( '9am - 7pm', 'Block pattern content', 'twentig' ) . '</td></tr><tr><td>' . esc_html_x( 'Wednesday', 'Block pattern content', 'twentig' ) . '</td><td class="has-text-align-right" data-align="right">' . esc_html_x( '9am - 4pm', 'Block pattern content', 'twentig' ) . '</td></tr><tr><td>' . esc_html_x( 'Thursday', 'Block pattern content', 'twentig' ) . '</td><td class="has-text-align-right" data-align="right">' . esc_html_x( '9am - 7pm', 'Block pattern content', 'twentig' ) . '</td></tr><tr><td>' . esc_html_x( 'Friday', 'Block pattern content', 'twentig' ) . '</td><td class="has-text-align-right" data-align="right">' . esc_html_x( '9am - 7pm', 'Block pattern content', 'twentig' ) . '</td></tr><tr><td>' . esc_html_x( 'Saturday', 'Block pattern content', 'twentig' ) . '</td><td class="has-text-align-right" data-align="right">' . esc_html_x( '9am - 4pm', 'Block pattern content', 'twentig' ) . '</td></tr><tr><td>' . esc_html_x( 'Sunday', 'Block pattern content', 'twentig' ) . '</td><td class="has-text-align-right" data-align="right">Closed</td></tr></tbody></table></figure><!-- /wp:table --></div><!-- /wp:group --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/contact-map',
	array(
		'title'      => __( 'Contact: map', 'twentig' ),
		'categories' => array( 'contact' ),
		'content'    => '<!-- wp:group {"metadata":{"name":"' . $group_name . '"},"align":"full","layout":{"type":"constrained"}} --><div class="wp-block-group alignfull"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|60","left":"var:preset|spacing|55"}}}} --><div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center","width":"40%"} --><div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40%"><!-- wp:heading --><h2>' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>123 Rue des Beaux Arts<br>Paris, 75006</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Opening hours', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>' . esc_html_x( 'Monday - Friday: 9am - 7pm', 'Block pattern content', 'twentig' ) . '<br>' . esc_html_x( 'Saturday: 9am - 10pm', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:heading {"level":3,"fontSize":"medium","style":{"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} --><h3 class="wp-block-heading has-medium-font-size" style="margin-top:var(--wp--preset--spacing--30)">' . esc_html_x( 'Contact us', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p>(123)-456-789<br><a href="mailto:contact@example.com">contact@example.com</a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"width":"60%"} --><div class="wp-block-column" style="flex-basis:60%"><!-- wp:html --><figure><iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d5250.189337985955!2d2.331219332765149!3d48.856405129510996!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x8676ec06852e5163!2zNDjCsDUxJzIzLjEiTiAywrAyMCcwOC4yIkU!5e0!3m2!1sen!2sfr!4v1670593656952!5m2!1sen!2sfr" width="1000" height="500" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe></figure><!-- /wp:html --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);
