<?php
/**
 * Testimonials block patterns.
 *
 * @package twentig
 */

twentig_register_block_pattern(
	'twentig/testimonials-list-with-separator',
	array(
		'title'      => __( 'Testimonials: list with separator', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","className":"tw-mb-7"} --><h2 class="has-text-align-center tw-mb-7">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:quote {"className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote is-style-tw-minimal"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat at blandit at erat."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --><!-- wp:separator {"className":"tw-mb-6 tw-mt-6"} --><hr class="wp-block-separator tw-mb-6 tw-mt-6"/><!-- /wp:separator --><!-- wp:quote {"className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote is-style-tw-minimal"><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --><!-- wp:separator {"className":"tw-mb-6 tw-mt-6"} --><hr class="wp-block-separator tw-mb-6 tw-mt-6"/><!-- /wp:separator --><!-- wp:quote {"className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote is-style-tw-minimal"><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet."</p><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-list-with-large-quote',
	array(
		'title'      => __( 'Testimonials: list with large quote', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center","className":"tw-mb-7"} --><h2 class="has-text-align-center tw-mb-7">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:quote {"align":"center","style":{"typography":{"lineHeight":"1.3","fontSize":"28px"}},"className":"is-style-plain"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain" style="font-size:28px;line-height:1.3"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor id feugiat."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --><!-- wp:quote {"align":"center","style":{"typography":{"lineHeight":"1.3","fontSize":"28px"}},"className":"is-style-plain tw-mt-6"} --><blockquote class="wp-block-quote has-text-align-center tw-mt-6 is-style-plain" style="font-size:28px;line-height:1.3"><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien."</p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --><!-- wp:quote {"align":"center","style":{"typography":{"lineHeight":"1.3","fontSize":"28px"}},"className":"is-style-plain tw-mt-6"} --><blockquote class="wp-block-quote has-text-align-center tw-mt-6 is-style-plain" style="font-size:28px;line-height:1.3"><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonial-colored-background',
	array(
		'title'      => __( 'Testimonial: colored background', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"backgroundColor":"subtle","align":"full"} --><div class="wp-block-group alignfull has-subtle-background-color has-background"><!-- wp:quote {"align":"center","style":{"typography":{"lineHeight":"1.3","fontSize":"28px"}},"className":"is-style-plain"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain" style="font-size:28px;line-height:1.3"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor id feugiat."</p></blockquote><!-- /wp:quote --><!-- wp:image {"align":"center","width":48,"height":48,"className":"tw-mt-0 tw-mb-3 is-style-rounded"} --><div class="wp-block-image tw-mt-0 tw-mb-3 is-style-rounded"><figure class="aligncenter is-resized"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="48" height="48"/></figure></div><!-- /wp:image --><!-- wp:paragraph {"align":"center","fontSize":"extra-small"} --><p class="has-text-align-center has-extra-small-font-size">David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonial-cover',
	array(
		'title'      => __( 'Testimonial: cover', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","minHeight":500,"align":"full"} --><div class="wp-block-cover alignfull has-background-dim" style="min-height:500px"><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:quote {"align":"center","style":{"typography":{"lineHeight":"1.3","fontSize":"32px"}},"className":"is-style-plain"} --><blockquote class="wp-block-quote has-text-align-center is-style-plain" style="font-size:32px;line-height:1.3"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor id feugiat."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonial-image-on-left',
	array(
		'title'      => __( 'Testimonial: image on left', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:media-text {"mediaType":"image","twStackedMd":true} --><div class="wp-block-media-text alignwide is-stacked-on-mobile tw-stack-md"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3","fontSize":"28px"}},"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain" style="font-size:28px;line-height:1.3"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor feugiat."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:media-text --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonial-image-on-right',
	array(
		'title'      => __( 'Testimonial: image on right', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:media-text {"mediaPosition":"right","mediaType":"image","twStackedMd":true} --><div class="wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile tw-stack-md"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3","fontSize":"28px"}},"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain" style="font-size:28px;line-height:1.3"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor feugiat."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:media-text --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-overlap-image',
	array(
		'title'      => __( 'Testimonials: overlap image', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:media-text {"backgroundColor":"subtle","mediaType":"image","mediaWidth":56,"className":"is-style-tw-overlap","twStackedMd":true} --><div class="wp-block-media-text alignwide has-background has-subtle-background-color is-stacked-on-mobile is-style-tw-overlap tw-stack-md" style="grid-template-columns:56% auto"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3","fontSize":"28px"}},"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain" style="font-size:28px;line-height:1.3"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore. Duis enim elit porttitor id feugiat."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:media-text --><!-- wp:media-text {"backgroundColor":"subtle","mediaPosition":"right","mediaType":"image","mediaWidth":56,"className":"is-style-tw-overlap","twStackedMd":true} --><div class="wp-block-media-text alignwide has-media-on-the-right has-background has-subtle-background-color is-stacked-on-mobile is-style-tw-overlap tw-stack-md" style="grid-template-columns:auto 56%"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3","fontSize":"28px"}},"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain" style="font-size:28px;line-height:1.3"><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien."</p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:media-text --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-2-columns-x-2',
	array(
		'title'      => __( 'Testimonials 2 columns x 2', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'What our customers are saying about us', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twGutter":"large"} --><div class="wp-block-columns alignwide tw-gutter-large"><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"align":"center"} --><blockquote class="wp-block-quote has-text-align-center"><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut labore dolore.</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"align":"center"} --><blockquote class="wp-block-quote has-text-align-center"><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien.</p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","twGutter":"large"} --><div class="wp-block-columns alignwide tw-gutter-large"><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"align":"center"} --><blockquote class="wp-block-quote has-text-align-center"><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote {"align":"center"} --><blockquote class="wp-block-quote has-text-align-center"><p>Duis enim elit porttitor id feugiat at blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-2-columns-image',
	array(
		'title'      => __( 'Testimonials 2 columns: image', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twStretchedMedia":true} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:quote {"className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote is-style-tw-minimal"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:quote {"className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote is-style-tw-minimal"><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet."</p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-2-columns-cover',
	array(
		'title'      => __( 'Testimonials 2 columns: cover', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:columns {"align":"wide","twStack":"md"} --><div class="wp-block-columns alignwide tw-cols-stack-md"><!-- wp:column --><div class="wp-block-column"><!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '","contentPosition":"bottom left"} --><div class="wp-block-cover has-background-dim has-custom-content-position is-position-bottom-left"><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3","fontSize":"24px"}},"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain" style="font-size:24px;line-height:1.3"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod tempor incididunt ut dolore."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:cover --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '","contentPosition":"bottom left"} --><div class="wp-block-cover has-background-dim has-custom-content-position is-position-bottom-left"><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:quote {"style":{"typography":{"lineHeight":"1.3","fontSize":"24px"}},"className":"is-style-plain"} --><blockquote class="wp-block-quote is-style-plain" style="font-size:24px;line-height:1.3"><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna congue velit."</p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div></div><!-- /wp:cover --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-3-columns-x-2',
	array(
		'title'      => __( 'Testimonials 3 columns x 2', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'What our customers are saying about us', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twStack":"sm"} --><div class="wp-block-columns alignwide tw-cols-stack-sm"><!-- wp:column --><div class="wp-block-column"><!-- wp:quote --><blockquote class="wp-block-quote"><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat.</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote --><blockquote class="wp-block-quote"><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote --><blockquote class="wp-block-quote"><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet.</p><cite>James Clark, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","twStack":"sm"} --><div class="wp-block-columns alignwide tw-cols-stack-sm"><!-- wp:column --><div class="wp-block-column"><!-- wp:quote --><blockquote class="wp-block-quote"><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><cite>Julie Miller, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote --><blockquote class="wp-block-quote"><p>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus. Integer sagittis efficitur rhoncus justo vehicula sapien.</p><cite>Eric Wilson, ' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote --><blockquote class="wp-block-quote"><p>Mauris dui tellus mollis quis varius sit amet ultrices in leo. Cras et purus sit amet velit congue convallis nec id diam.</p><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-3-columns-card-with-icon',
	array(
		'title'      => __( 'Testimonials 3 columns: card with icon', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'What our customers are saying about us', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twColumnStyle":"card-border"} --><div class="wp-block-columns alignwide tw-cols-card tw-cols-card-border"><!-- wp:column --><div class="wp-block-column"><!-- wp:quote --><blockquote class="wp-block-quote"><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat.</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote --><blockquote class="wp-block-quote"><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit. Proin varius libero diam laoreet. </p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:quote --><blockquote class="wp-block-quote"><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet.</p><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-3-columns-card-with-thumbnail',
	array(
		'title'      => __( 'Testimonials 3 columns: card with thumbnail', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","className":"tw-justify-center","twColumnStyle":"card-shadow"} --><div class="wp-block-columns alignwide tw-justify-center tw-cols-card tw-cols-card-shadow"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"align":"center","width":60,"height":60,"className":"is-style-rounded"} --><div class="wp-block-image is-style-rounded"><figure class="aligncenter is-resized"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="60" height="60"/></figure></div><!-- /wp:image --><!-- wp:quote {"align":"center","className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote has-text-align-center is-style-tw-minimal"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"align":"center","width":60,"height":60,"className":"is-style-rounded"} --><div class="wp-block-image is-style-rounded"><figure class="aligncenter is-resized"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="60" height="60"/></figure></div><!-- /wp:image --><!-- wp:quote {"align":"center","className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote has-text-align-center is-style-tw-minimal"><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . ' </cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"align":"center","width":60,"height":60,"className":"is-style-rounded"} --><div class="wp-block-image is-style-rounded"><figure class="aligncenter is-resized"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="60" height="60"/></figure></div><!-- /wp:image --><!-- wp:quote {"align":"center","className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote has-text-align-center is-style-tw-minimal"><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet."</p><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-3-columns-card-with-image',
	array(
		'title'      => __( 'Testimonials 3 columns: card with image', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Testimonials', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twColumnStyle":"card-shadow","twStretchedMedia":true} --><div class="wp-block-columns alignwide tw-cols-card tw-cols-card-shadow tw-stretched-media"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:quote {"className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote is-style-tw-minimal"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis enim elit porttitor id feugiat."</p><cite>David Lin, ' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:quote {"className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote is-style-tw-minimal"><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><cite>Emily Patel, ' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:quote {"className":"is-style-tw-minimal"} --><blockquote class="wp-block-quote is-style-tw-minimal"><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius libero sit amet."</p><cite>Richard Garcia, ' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/testimonials-4-columns-thumbnail',
	array(
		'title'      => __( 'Testimonials 4 columns: thumbnail', 'twentig' ),
		'categories' => array( 'testimonials' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'What our customers are saying about us', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"width":60,"height":60,"className":"is-style-rounded"} --><figure class="wp-block-image is-resized is-style-rounded"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="60" height="60"/></figure><!-- /wp:image --><!-- wp:quote {"className":"tw-mb-3 is-style-tw-minimal"} --><blockquote class="wp-block-quote tw-mb-3 is-style-tw-minimal"><p>"Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore."</p><cite><strong>David Lin</strong><br>' . esc_html_x( 'Teacher', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"width":60,"height":60,"className":"is-style-rounded"} --><figure class="wp-block-image is-resized is-style-rounded"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="60" height="60"/></figure><!-- /wp:image --><!-- wp:quote {"className":"tw-mb-3 is-style-tw-minimal"} --><blockquote class="wp-block-quote tw-mb-3 is-style-tw-minimal"><p>"Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit."</p><cite><strong>Emily Patel</strong><br>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"width":60,"height":60,"className":"is-style-rounded"} --><figure class="wp-block-image is-resized is-style-rounded"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="60" height="60"/></figure><!-- /wp:image --><!-- wp:quote {"className":"tw-mb-3 is-style-tw-minimal"} --><blockquote class="wp-block-quote tw-mb-3 is-style-tw-minimal"><p>"Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero varius."</p><cite><strong>Richard Garcia</strong><br>' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"width":60,"height":60,"className":"is-style-rounded"} --><figure class="wp-block-image is-resized is-style-rounded"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="60" height="60"/></figure><!-- /wp:image --><!-- wp:quote {"className":"tw-mb-3 is-style-tw-minimal"} --><blockquote class="wp-block-quote tw-mb-3 is-style-tw-minimal"><p>"Duis enim elit porttitor id feugiat at blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet."</p><cite><strong>James Clark</strong><br>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</cite></blockquote><!-- /wp:quote --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);
