<?php
/**
 * Team block patterns.
 *
 * @package twentig
 */

twentig_register_block_pattern(
	'twentig/team-2-columns',
	array(
		'title'      => __( 'Team 2 columns', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed ullamcorper at metus.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Duis enim elit porttitor id feugiat at blandit at erat.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-2-columns-centered-content',
	array(
		'title'      => __( 'Team 2 columns: centered content', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twStretchedMedia":true,"twTextAlign":"center"} --><div class="wp-block-columns alignwide has-text-align-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-1"} --><h3 class="has-large-font-size tw-mb-1">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-1"} --><h3 class="has-large-font-size tw-mb-1">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","twStretchedMedia":true,"twTextAlign":"center"} --><div class="wp-block-columns alignwide has-text-align-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-1"} --><h3 class="has-large-font-size tw-mb-1">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-1"} --><h3 class="has-large-font-size tw-mb-1">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-3-columns',
	array(
		'title'      => __( 'Team 3 columns', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-3-columns-circle-image',
	array(
		'title'      => __( 'Team 3 columns: circle image', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","className":"tw-justify-center","twGutter":"large","twTextAlign":"center"} --><div class="wp-block-columns alignwide tw-justify-center tw-gutter-large has-text-align-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"align":"center","width":160,"height":160,"className":"is-style-rounded"} --><div class="wp-block-image is-style-rounded"><figure class="aligncenter is-resized"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="160" height="160"/></figure></div><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore.</p><!-- /wp:paragraph --><!-- wp:social-links {"size":"has-small-icon-size","align":"center","className":"tw-mt-3 is-style-logos-only","customIconColor":"#000000","iconColorValue":"#000000","twHover":"opacity"} --><ul class="wp-block-social-links aligncenter tw-mt-3 has-small-icon-size is-style-logos-only has-icon-color tw-hover-opacity"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"align":"center","width":160,"height":160,"className":"is-style-rounded"} --><div class="wp-block-image is-style-rounded"><figure class="aligncenter is-resized"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="160" height="160"/></figure></div><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><!-- /wp:paragraph --><!-- wp:social-links {"size":"has-small-icon-size","align":"center","className":"tw-mt-3 is-style-logos-only","customIconColor":"#000000","iconColorValue":"#000000","twHover":"opacity"} --><ul class="wp-block-social-links aligncenter tw-mt-3 has-small-icon-size is-style-logos-only has-icon-color tw-hover-opacity"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image {"align":"center","width":160,"height":160,"className":"is-style-rounded"} --><div class="wp-block-image is-style-rounded"><figure class="aligncenter is-resized"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="160" height="160"/></figure></div><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --><!-- wp:social-links {"size":"has-small-icon-size","align":"center","className":"tw-mt-3 is-style-logos-only","customIconColor":"#000000","iconColorValue":"#000000","twHover":"opacity"} --><ul class="wp-block-social-links aligncenter tw-mt-3 has-small-icon-size is-style-logos-only has-icon-color tw-hover-opacity"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-3-columns-x-2',
	array(
		'title'      => __( 'Team 3 columns x 2', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twStack":"sm"} --><div class="wp-block-columns alignwide tw-cols-stack-sm"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","twStack":"sm"} --><div class="wp-block-columns alignwide tw-cols-stack-sm"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Eric Wilson</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-3-columns-gallery',
	array(
		'title'      => __( 'Team 3 columns: gallery', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:gallery {"ids":[null,null,null,null,null,null],"columns":3,"align":"wide","className":"tw-mt-8 tw-caption-large","twFixedWidthCols":true,"twGutter":"medium","twStackedSm":true} --><figure class="wp-block-gallery alignwide columns-3 is-cropped tw-mt-8 tw-caption-large tw-fixed-cols tw-gutter-medium tw-stack-sm"><ul class="blocks-gallery-grid"><li class="blocks-gallery-item"><figure><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" data-id=""/><figcaption class="blocks-gallery-item__caption"><strong>Julie Miller</strong><br>' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</figcaption></figure></li><li class="blocks-gallery-item"><figure><img src="' . twentig_get_pattern_asset( 'profile-square.jpg?v=2' ) . '" alt="" data-id=""/><figcaption class="blocks-gallery-item__caption"><strong>David Lin</strong><br>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</figcaption></figure></li><li class="blocks-gallery-item"><figure><img src="' . twentig_get_pattern_asset( 'profile-square.jpg?v=3' ) . '" alt="" data-id=""/><figcaption class="blocks-gallery-item__caption"><strong>Emily Patel</strong><br>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</figcaption></figure></li><li class="blocks-gallery-item"><figure><img src="' . twentig_get_pattern_asset( 'profile-square.jpg?v=4' ) . '" alt="" data-id=""/><figcaption class="blocks-gallery-item__caption"><strong>Eric Wilson</strong><br>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</figcaption></figure></li><li class="blocks-gallery-item"><figure><img src="' . twentig_get_pattern_asset( 'profile-square.jpg?v=5' ) . '" alt="" data-id=""/><figcaption class="blocks-gallery-item__caption"><strong>Laura Adams</strong><br>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</figcaption></figure></li><li class="blocks-gallery-item"><figure><img src="' . twentig_get_pattern_asset( 'profile-square.jpg?v=6' ) . '" alt="" data-id=""/><figcaption class="blocks-gallery-item__caption"><strong>Richard Garcia</strong><br>' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</figcaption></figure></li></ul></figure><!-- /wp:gallery --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-3-columns-top-border',
	array(
		'title'      => __( 'Team 3 columns: top border', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twGutter":"large","twStack":"sm","twColumnStyle":"border-top"} --><div class="wp-block-columns alignwide tw-gutter-large tw-cols-stack-sm tw-cols-border-top"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna eu congue velit.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","twGutter":"large","twStack":"sm","twColumnStyle":"border-top"} --><div class="wp-block-columns alignwide tw-gutter-large tw-cols-stack-sm tw-cols-border-top"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">Eric Wilson</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Duis enim elit porttitor id feugiat at blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus. Integer sagittis efficitur rhoncus justo.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Mauris dui tellus mollis quis varius sit amet ultrices in leo. Cras et purus sit amet velit congue convallis nec id diam.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-4-columns',
	array(
		'title'      => __( 'Team 4 columns', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididun.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus. Venenatis nec convallis magna.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. </p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Duis enim elit porttitor id feugiat at blandit at erat. Proin varius libero sit amet tortor volutpat diam.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-4-columns-x-2',
	array(
		'title'      => __( 'Team 4 columns x 2', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Eric Wilson</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">James Clark</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Susan Harris</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-4-columns-top-border',
	array(
		'title'      => __( 'Team 4 columns: top border', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center"><strong>' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</strong></h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twColumnStyle":"border-top"} --><div class="wp-block-columns alignwide tw-cols-border-top"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Eric Wilson</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","twColumnStyle":"border-top"} --><div class="wp-block-columns alignwide tw-cols-border-top"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">James Clark</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Susan Harris</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">Richard Garcia</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">' . esc_html_x( 'Photographer', 'Block pattern content - Referring to a man', 'twentig' ) . '</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-list',
	array(
		'title'      => __( 'Team: list', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading --><h2>' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"twStack":"sm"} --><div class="wp-block-columns tw-cols-stack-sm"><!-- wp:column {"width":"20%"} --><div class="wp-block-column" style="flex-basis:20%"><!-- wp:image {"width":140,"height":140,"className":"is-style-rounded"} --><figure class="wp-block-image is-resized is-style-rounded"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="140" height="140"/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"width":"80%"} --><div class="wp-block-column" style="flex-basis:80%"><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">Julie Miller</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Founder', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Class aptent taciti sociosqu ad litora torquent per conubia nostra.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:separator {"className":"tw-mt-6 tw-mb-7"} --><hr class="wp-block-separator tw-mt-6 tw-mb-7"/><!-- /wp:separator --><!-- wp:columns {"twStack":"sm"} --><div class="wp-block-columns tw-cols-stack-sm"><!-- wp:column {"width":"20%"} --><div class="wp-block-column" style="flex-basis:20%"><!-- wp:image {"width":140,"height":140,"className":"is-style-rounded"} --><figure class="wp-block-image is-resized is-style-rounded"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="140" height="140"/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"width":"80%"} --><div class="wp-block-column" style="flex-basis:80%"><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2 ">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:separator {"className":"tw-mt-6 tw-mb-7"} --><hr class="wp-block-separator tw-mt-6 tw-mb-7"/><!-- /wp:separator --><!-- wp:columns {"twStack":"sm"} --><div class="wp-block-columns tw-cols-stack-sm"><!-- wp:column {"width":"20%"} --><div class="wp-block-column" style="flex-basis:20%"><!-- wp:image {"width":140,"height":140,"className":"is-style-rounded"} --><figure class="wp-block-image is-resized is-style-rounded"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="140" height="140"/></figure><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"width":"80%"} --><div class="wp-block-column" style="flex-basis:80%"><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">Emily Patel</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Mauris dui tellus mollis quis varius, sit amet ultrices.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-image-on-left',
	array(
		'title'      => __( 'Team: image on left', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:media-text {"mediaType":"image","imageFill":false,"twStackedMd":true} --><div class="wp-block-media-text alignwide is-stacked-on-mobile tw-stack-md"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small","className":"tw-mb-4"} --><p class="has-small-font-size tw-mb-4"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Class aptent taciti sociosqu ad litora torquent per conubia nostra.</p><!-- /wp:paragraph --><!-- wp:social-links {"size":"has-small-icon-size","className":"is-style-logos-only","customIconColor":"#000000","iconColorValue":"#000000","twHover":"opacity"} --><ul class="wp-block-social-links has-small-icon-size is-style-logos-only has-icon-color tw-hover-opacity"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div></div><!-- /wp:media-text --><!-- wp:media-text {"mediaType":"image","imageFill":false,"twStackedMd":true} --><div class="wp-block-media-text alignwide is-stacked-on-mobile tw-stack-md"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small","className":"tw-mb-4"} --><p class="has-small-font-size tw-mb-4"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet.</p><!-- /wp:paragraph --><!-- wp:social-links {"size":"has-small-icon-size","className":"is-style-logos-only","customIconColor":"#000000","iconColorValue":"#000000","twHover":"opacity"} --><ul class="wp-block-social-links has-small-icon-size is-style-logos-only has-icon-color tw-hover-opacity"><!-- wp:social-link {"url":"#","service":"mail"} /--><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--></ul><!-- /wp:social-links --></div></div><!-- /wp:media-text --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-alternating-text-and-image',
	array(
		'title'      => __( 'Team: alternating text and image', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:media-text {"mediaType":"image","mediaWidth":49,"twStackedMd":true} --><div class="wp-block-media-text alignwide is-stacked-on-mobile tw-stack-md" style="grid-template-columns:49% auto"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small","className":"tw-mb-4"} --><p class="has-small-font-size tw-mb-4"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Class aptent taciti sociosqu ad litora torquent per conubia nostra.</p><!-- /wp:paragraph --></div></div><!-- /wp:media-text --><!-- wp:media-text {"mediaPosition":"right","mediaType":"image","mediaWidth":49,"twStackedMd":true} --><div class="wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile tw-stack-md" style="grid-template-columns:auto 49%"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small","className":"tw-mb-4"} --><p class="has-small-font-size tw-mb-4"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Venenatis nec convallis magna, eu congue velit. Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Fusce sed magna eu ligula commodo hendrerit fringilla ac purus.</p><!-- /wp:paragraph --></div></div><!-- /wp:media-text --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/team-overlap-image',
	array(
		'title'      => __( 'Team: overlap image', 'twentig' ),
		'categories' => array( 'team' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Our team', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:media-text {"backgroundColor":"subtle","mediaType":"image","mediaWidth":56,"className":"is-style-tw-overlap","twStackedMd":true} --><div class="wp-block-media-text alignwide has-background has-subtle-background-color is-stacked-on-mobile is-style-tw-overlap tw-stack-md" style="grid-template-columns:56% auto"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">Laura Adams</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small","className":"tw-mb-4"} --><p class="has-small-font-size tw-mb-4"><strong>' . esc_html_x( 'Developer', 'Block pattern content - Referring to a woman', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Integer enim risus suscipit iaculis sed ullamcorper metus.</p><!-- /wp:paragraph --></div></div><!-- /wp:media-text --><!-- wp:media-text {"backgroundColor":"subtle","mediaPosition":"right","mediaType":"image","mediaWidth":56,"className":"is-style-tw-overlap","twStackedMd":true} --><div class="wp-block-media-text alignwide has-media-on-the-right has-background has-subtle-background-color is-stacked-on-mobile is-style-tw-overlap tw-stack-md" style="grid-template-columns:auto 56%"><figure class="wp-block-media-text__media"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">David Lin</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small","className":"tw-mb-4"} --><p class="has-small-font-size tw-mb-4"><strong>' . esc_html_x( 'Designer', 'Block pattern content - Referring to a man', 'twentig' ) . '</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Duis enim elit porttitor id feugiat at blandit at erat.</p><!-- /wp:paragraph --></div></div><!-- /wp:media-text --></div><!-- /wp:group -->',
	)
);
