<?php
/**
 * Single Page Layouts.
 *
 * @package twentig
 */

twentig_register_block_pattern(
	'twentig/link-in-bio-with-background-image',
	array(
		'title'      => __( 'Link in bio with background image', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","minHeight":100,"minHeightUnit":"vh","align":"full"} --><div class="wp-block-cover alignfull has-background-dim" style="min-height:100vh"><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"level":1,"fontSize":"extra-large","textAlign":"center","className":"tw-mb-5"} --><h1 class="has-extra-large-font-size has-text-align-center tw-mb-5">Julie Miller</h1><!-- /wp:heading --><!-- wp:buttons {"orientation":"vertical"} --><div class="wp-block-buttons is-vertical"><!-- wp:button {"textColor":"white","className":"has-custom-width wp-block-button__width-100 is-style-outline"} --><div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-white-color has-text-color">Listen to my podcast</a></div><!-- /wp:button --><!-- wp:button {"textColor":"white","width":100,"className":"is-style-outline"} --><div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-white-color has-text-color">Watch my videos on YouTube</a></div><!-- /wp:button --><!-- wp:button {"textColor":"white","width":100,"className":"is-style-outline"} --><div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-white-color has-text-color">View my blog</a></div><!-- /wp:button --><!-- wp:button {"textColor":"white","width":100,"className":"is-style-outline"} --><div class="wp-block-button has-custom-width wp-block-button__width-100 is-style-outline"><a class="wp-block-button__link has-white-color has-text-color">Check out my reading list</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:social-links {"iconColor":"white","iconColorValue":"#ffffff","align":"center","className":"tw-mt-5 is-style-logos-only","twHover":"opacity"} --><ul class="wp-block-social-links aligncenter has-icon-color tw-mt-5 is-style-logos-only tw-hover-opacity"><!-- wp:social-link {"url":"#","service":"facebook"} /--><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"spotify"} /--><!-- wp:social-link {"url":"#","service":"youtube"} /--></ul><!-- /wp:social-links --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/bio-with-image-on-left',
	array(
		'title'      => __( 'Bio with image on left', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:media-text {"align":"full","mediaType":"image","imageFill":true,"style":{"color":{"background":"#28303d","text":"#ffffff"}},"className":"tw-height-full","twStackedMd":true,"twMediaBottom":true} --><div class="wp-block-media-text alignfull is-stacked-on-mobile is-image-fill tw-height-full has-text-color has-background tw-stack-md tw-media-bottom" style="background-color:#28303d;color:#ffffff"><figure class="wp-block-media-text__media" style="background-image:url(' . twentig_get_pattern_asset( 'profile-square.jpg' ) . ');background-position:50% 50%"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt=""/></figure><div class="wp-block-media-text__content"><!-- wp:heading {"level":1,"className":"tw-eyebrow"} --><h1 class="tw-eyebrow">David Lin</h1><!-- /wp:heading --><!-- wp:heading {"fontSize":"extra-large","className":"tw-mb-5"} --><h2 class="has-extra-large-font-size tw-mb-5">' . esc_html_x( 'Freelance developer', 'Block pattern content - Referring to a man', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Duis finibus venenatis diam id semper. Etiam non nisi sit amet nisl lobortis hendrerit eget scelerisque lacus. Pellentesque vitae fermentum eros. Praesent congue interdum neque ac luctus. Nullam vulputate euismod massa et tincidunt, donec ultrices libero sed elit eleifend. Pellentesque posuere sagittis turpis, ut feugiat mi finibus nec odio dignissim. </p><!-- /wp:paragraph --><!-- wp:buttons {"className":"tw-mt-6"} --><div class="wp-block-buttons tw-mt-6"><!-- wp:button {"textColor":"white","style":{"border":{"radius":50}},"className":"is-style-outline"} --><div class="wp-block-button is-style-outline"><a class="wp-block-button__link has-white-color has-text-color" style="border-radius:50px">' . esc_html_x( 'Resume', 'Button to download Curriculum Vitae', 'twentig' ) . '</a></div><!-- /wp:button --><!-- wp:button {"backgroundColor":"white","style":{"border":{"radius":50}}} --><div class="wp-block-button"><a class="wp-block-button__link has-white-background-color has-background" href="mailto:contact@example.com" style="border-radius:50px">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div></div><!-- /wp:media-text -->',
	)
);

twentig_register_block_pattern(
	'twentig/bio-with-wide-text',
	array(
		'title'      => __( 'Bio with wide text', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"minHeight":100,"minHeightUnit":"vh","customGradient":"linear-gradient(45deg,rgb(29,32,72) 0%,rgb(41,92,132) 100%)","align":"full"} --><div class="wp-block-cover alignfull has-background-dim has-background-gradient" style="background:linear-gradient(45deg,rgb(29,32,72) 0%,rgb(41,92,132) 100%);min-height:100vh"><div class="wp-block-cover__inner-container"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false,"align":"wide","className":"tw-mb-6","twGutter":"no"} --><div class="wp-block-columns alignwide are-vertically-aligned-center is-not-stacked-on-mobile tw-mb-6 tw-gutter-no"><!-- wp:column {"verticalAlignment":"center","width":"68px"} --><div class="wp-block-column is-vertically-aligned-center" style="flex-basis:68px"><!-- wp:image {"width":60,"height":60,"className":"is-style-rounded"} --><figure class="wp-block-image is-resized is-style-rounded"><img src="' . twentig_get_pattern_asset( 'profile-square.jpg' ) . '" alt="" width="60" height="60"/></figure-><!-- /wp:image --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"padding":{"left":"12px"}}}} --><div class="wp-block-column is-vertically-aligned-center" style="padding-left:12px"><!-- wp:heading {"level":1,"align":"wide","style":{"typography":{"fontSize":"28px"}}} --><h1 class="alignwide" style="font-size:28px">Julie Miller</h1><!-- /wp:heading --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:paragraph {"className":"tw-text-wide","style":{"typography":{"fontSize":"22px"}}} --><p class="tw-text-wide" style="font-size:22px">Nullam a dignissim lacus. Nulla at orci sed arcu luctus tristique at eget mi. Curabitur finibus neque vitae sollicitudin posuere. Maecenas sed diam tellus. Sed magna massa, venenatis vitae congue sed, dignissim ut libero. Nullam lacinia vel est sit amet faucibus quisque vel quam. In turpis iaculis ultricies at ut ante. Maecenas venenatis tincidunt libero, et vitae in <a href="#">Hooli</a>, <a href="#">Initech</a>, and <a href="#">Acme</a>.</p><!-- /wp:paragraph --><!-- wp:paragraph {"className":"tw-text-wide","style":{"typography":{"fontSize":"22px"}}} --><p class="tw-text-wide" style="font-size:22px">Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia curae. Ut ante purus, cursus eget tincidunt a, malesuada a orci. Donec rhoncus purus in erat faucibus tincidunt. In id lacus lectus. Ut facilisis mauris velit, vel pretium nisi finibus vel.</p><!-- /wp:paragraph --><!-- wp:columns {"align":"wide","className":"tw-mt-6"} --><div class="wp-block-columns alignwide tw-mt-6"><!-- wp:column {"width":"100%"} --><div class="wp-block-column" style="flex-basis:100%"><!-- wp:social-links {"iconColor":"white","iconColorValue":"#FFFFFF","className":"is-style-logos-only"} --><ul class="wp-block-social-links has-icon-color is-style-logos-only"-><!-- wp:social-link {"url":"#","service":"instagram"} /--><!-- wp:social-link {"url":"#","service":"twitter"} /--><!-- wp:social-link {"url":"#","service":"linkedin"} /--><!-- wp:social-link {"url":"mailto:contact@example.com","service":"mail"} /--></ul-><!-- /wp:social-links --></div><!-- /wp:column --></div><!-- /wp:columns --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/coming-soon-with-call-to-action',
	array(
		'title'      => __( 'Coming soon with call to action', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","minHeight":100,"minHeightUnit":"vh","align":"full"} --><div class="wp-block-cover alignfull has-background-dim alignfull" style="min-height:100vh"><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","level":1,"align":"wide","className":"tw-mb-5"} --><h1 class="alignwide has-text-align-center tw-mb-5">' . esc_html_x( 'Coming soon', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"align":"center","fontSize":"large","style":{"typography":{"lineHeight":"1.4"}}} --><p class="has-text-align-center has-large-font-size" style="line-height:1.4">Aliquam eget tellus ligula quisque convallis, turpis a efficitur dictum, augue nunc sodales.</p><!-- /wp:paragraph --><!-- wp:buttons {"align":"center","className":"tw-mt-6"} --><div class="wp-block-buttons aligncenter tw-mt-6"><!-- wp:button {"backgroundColor":"white"} --><div class="wp-block-button"><a class="wp-block-button__link has-white-background-color has-background">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/info-card',
	array(
		'title'        => __( 'Info card', 'twentig' ),
		'categories'   => array( 'page-single' ),
		'pageTemplate' => 'tw-no-header-footer.php',
		'content'      => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","dimRatio":0,"minHeight":100,"minHeightUnit":"vh","contentPosition":"center center","align":"full"} --><div class="wp-block-cover alignfull" style="min-height:100vh"><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"border":{"radius":"6px"}},"backgroundColor":"white"} --><div class="wp-block-group has-white-background-color has-background" style="border-radius:6px"><!-- wp:heading {"level":1,"fontSize":"extra-large","textAlign":"center","className":"tw-mb-4"} --><h1 class="has-extra-large-font-size has-text-align-center tw-mb-4">' . esc_html_x( 'Page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:paragraph {"align":"center","className":"tw-mb-2"} --><p class="has-text-align-center tw-mb-2">Suspendisse tristique ipsum nisi, venenatis efficitur magna lacinia non. Donec congue erat eu lacus hendrerit gravida. Phasellus finibus nisl ut dui feugiat egestas. Vivamus eget neque dolor. Morbi vulputate dolor quis purus ullamcorper rhoncus, cras ut tempor diam luctus.</p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-inline has-text-align-center"} --><ul class="is-style-tw-inline has-text-align-center"><!-- wp:list-item --><li><a href="#">Instagram</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="#">YouTube</a></li><!-- /wp:list-item --><!-- wp:list-item --><li><a href="mailto:contact@example.com">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</a></li><!-- /wp:list-item --></ul><!-- /wp:list --></div><!-- /wp:group --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/info-2-columns',
	array(
		'title'      => __( 'Info 2 columns', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","minHeight":100,"minHeightUnit":"vh","align":"full"} --><div class="wp-block-cover alignfull has-background-dim" style="min-height:100vh"><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"level":1,"align":"wide"} --><h1 class="alignwide">' . esc_html_x( 'Page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:columns {"align":"wide","className":"tw-mb-6 tw-mt-6","twGutter":"large","twStack":"sm"} --><div class="wp-block-columns alignwide tw-mb-6 tw-mt-6 tw-gutter-large tw-cols-stack-sm"><!-- wp:column {"width":"66.66%"} --><div class="wp-block-column" style="flex-basis:66.66%"><!-- wp:paragraph {"style":{"typography":{"fontSize":"22px"}}} --><p style="font-size:22px">Donec sit amet augue consequat, dictum diam nec, laoreet magna. Aenean nec sagittis nibh. Phasellus sit amet commodo tortor elit libero tincidunt turpis, in nisi scelerisque congue donec. Dapibus faucibus nulla eu dignissim. Curabitur at condimentum massa. Aliquam lobortis sit amet ipsum ut tincidunt. Proin mollis ipsum ornare ultrices sit amet ut dolor metus a sem. Nulla pulvinar elementum arcu et tincidunt ligula lobortis. </p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column {"width":"33.33%"} --><div class="wp-block-column" style="flex-basis:33.33%"><!-- wp:paragraph --><p><strong>' . esc_html_x( 'Date', 'Block pattern content', 'twentig' ) . '</strong><br>' . esc_html_x( 'Monday, October 24', 'Block pattern content', 'twentig' ) . '</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><strong>' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</strong><br>16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:buttons {"align":"wide","className":"tw-mt-6"} --><div class="wp-block-buttons alignwide tw-mt-6"><!-- wp:button {"backgroundColor":"white"} --><div class="wp-block-button"><a class="wp-block-button__link has-white-background-color has-background">' . esc_html_x( 'Get in touch', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div></div><!-- /wp:cover -->',
	)
);

twentig_register_block_pattern(
	'twentig/info-3-columns',
	array(
		'title'      => __( 'Info 3 columns', 'twentig' ),
		'categories' => array( 'page-single' ),
		'postTypes'  => array( 'page' ),
		'content'    => '<!-- wp:cover {"url":"' . twentig_get_pattern_asset( 'wide.jpg' ) . '","minHeight":100,"minHeightUnit":"vh","align":"full"} --><div class="wp-block-cover alignfull has-background-dim" style="min-height:100vh"><img class="wp-block-cover__image-background" alt="" src="' . twentig_get_pattern_asset( 'wide.jpg' ) . '" data-object-fit="cover"/><div class="wp-block-cover__inner-container"><!-- wp:heading {"textAlign":"center","level":1,"align":"wide"} --><h1 class="alignwide has-text-align-center">' . esc_html_x( 'Page title', 'Block pattern content', 'twentig' ) . '</h1><!-- /wp:heading --><!-- wp:columns {"align":"wide","className":"tw-cols-rounded tw-justify-center","twColumnStyle":"card-border","twTextAlign":"center"} --><div class="wp-block-columns alignwide tw-cols-rounded tw-justify-center tw-cols-card tw-cols-card-border has-text-align-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"fontSize":"large"} --><h2 class="has-large-font-size">' . esc_html_x( 'Address', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>16 Thompson Street<br>San Francisco, CA 94102</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"fontSize":"large"} --><h2 class="has-large-font-size">' . esc_html_x( 'Opening hours', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>Monday - Friday: 9am - 7pm<br>Saturday: 9am - 10pm</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"fontSize":"large"} --><h2 class="has-large-font-size">' . esc_html_x( 'Contact', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph --><p>(123) 456-7890<br>contact@example.com</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div></div><!-- /wp:cover -->',
	)
);
