<?php
/**
 * Pricing block patterns.
 *
 * @package twentig
 */

twentig_register_block_pattern(
	'twentig/single-pricing',
	array(
		'title'      => __( 'Single pricing', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"className":"tw-mb-3"} --><h2 class="tw-mb-3">' . esc_html_x( 'Simple pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large","className":"tw-mb-4"} --><p class="has-large-font-size tw-mb-4"><strong>$19.99</strong></p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Lorem ipsum dolor sit amet, commodo erat adipiscing elit</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Venenatis nec convallis aliquam tempus mi nulla porta luctus</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed do eiusmod ut tempor incididunt ut labore et dolore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit nenatis nec convallis ali</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus</li> <!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/single-pricing-card',
	array(
		'title'      => __( 'Single pricing: card', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:group {"backgroundColor":"white","twDecoration":"shadow"} --><div class="wp-block-group has-white-background-color has-background tw-shadow"><!-- wp:heading {"fontSize":"extra-large","className":"tw-mb-3"} --><h2 class="has-extra-large-font-size tw-mb-3">' . esc_html_x( 'Simple pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large"} --><p class="has-large-font-size"><strong>$49</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p><strong>Lorem ipsum dolor sit amet, consectetur adipiscing elit sed do eiusmod tempor incididunt ut labore.</strong></p><!-- /wp:paragraph --><!-- wp:list {"className":"tw-list-spacing-medium"} --><ul class="tw-list-spacing-medium"><!-- wp:list-item --><li>Lorem ipsum dolor sit amet commodo erat</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Venenatis nec convallis aliquam tempus mi nulla</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed do eiusmod ut tempor incididunt ut labore et dolore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit nenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Fusce sed magna eu ligula commodo hendrerit</li> <!-- /wp:list-item --></ul> <!-- /wp:list --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:group --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-columns',
	array(
		'title'      => __( 'Pricing 2 columns', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"twGutter":"large"} --><div class="wp-block-columns tw-gutter-large"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-3"} --><h3 class="tw-mb-3">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large"} --><p class="has-large-font-size"><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --></ul> <!-- /wp:list --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"className":"is-style-outline"} --><div class="wp-block-button is-style-outline"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-3"} --><h3 class="tw-mb-3">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large"} --><p class="has-large-font-size"><strong>$49</strong></p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed non neque at lectus</li> <!-- /wp:list-item --></ul> <!-- /wp:list --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-column-cards',
	array(
		'title'      => __( 'Pricing 2 column cards', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"twColumnStyle":"card-shadow"} --><div class="wp-block-columns tw-cols-card tw-cols-card-shadow"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-4","style":{"typography":{"fontSize":"42px","lineHeight":"1.2"}}} --><p class="tw-mb-4" style="font-size:42px;line-height:1.2"><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet commodo erat adipiscing.</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-4","style":{"typography":{"fontSize":"42px","lineHeight":"1.2"}}} --><p class="tw-mb-4" style="font-size:42px;line-height:1.2"><strong>$49</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper.</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-column-cards-full-width-button',
	array(
		'title'      => __( 'Pricing 2 column cards: full width button', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"align":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"twColumnStyle":"card-shadow"} --><div class="wp-block-columns tw-cols-card tw-cols-card-shadow"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"align":"center","level":3,"className":"tw-mb-2"} --><h3 class="has-text-align-center tw-mb-2">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","fontSize":"large"} --><p class="has-text-align-center has-large-font-size"><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"align":"center","level":3,"className":"tw-mb-2"} --><h3 class="has-text-align-center tw-mb-2">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","fontSize":"large"} --><p class="has-text-align-center has-large-font-size"><strong>$49</strong></p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Morbi fringilla sapien libero</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim porttitor id feugiat</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Proin varius libero amet</li><!-- /wp:list-item --><!-- wp:list-item --><li>Fusce sed magna eu ligula</li><!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-column-cards-middle-alignment',
	array(
		'title'      => __( 'Pricing 2 column cards: middle alignment', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"verticalAlignment":"center","twColumnStyle":"card-shadow","twTextAlign":"center"} --><div class="wp-block-columns are-vertically-aligned-center tw-cols-card tw-cols-card-shadow has-text-align-center"><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-4","style":{"typography":{"fontSize":"42px","lineHeight":"1.2"}}} --><p class="tw-mb-4" style="font-size:42px;line-height:1.2"><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-no-bullet tw-list-spacing-medium"} --><ul class="is-style-tw-no-bullet tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li><!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li><!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --></ul><!-- /wp:list --><!-- wp:buttons {"align":"center","className":"tw-mt-5"} --><div class="wp-block-buttons aligncenter tw-mt-5"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column {"verticalAlignment":"center"} --><div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-4","style":{"typography":{"fontSize":"42px","lineHeight":"1.2"}}} --><p class="tw-mb-4" style="font-size:42px;line-height:1.2"><strong>$49</strong></p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-no-bullet tw-list-spacing-medium"} --><ul class="is-style-tw-no-bullet tw-list-spacing-medium"><!-- wp:list-item --><li>Sed non neque at lectus</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Morbi fringilla sapien libero</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim elit porttitor</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Fusce sed magna eu ligula</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer sagittis efficitur</li> <!-- /wp:list-item --></ul> <!-- /wp:list --><!-- wp:buttons {"align":"center","className":"tw-mt-5"} --><div class="wp-block-buttons aligncenter tw-mt-5"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-2-column-cards-image',
	array(
		'title'      => __( 'Pricing 2 column cards: image', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"twColumnStyle":"card-shadow","twStretchedMedia":true,"twStretchedLink":true} --><div class="wp-block-columns tw-cols-card tw-cols-card-shadow tw-stretched-media tw-stretched-link"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner"} --><ul class="is-style-tw-border-inner"><!-- wp:list-item --><li>Venenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li> <!-- /wp:list-item --></ul> <!-- /wp:list --><!-- wp:paragraph --><p><a href="#"><strong>' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</strong></a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$49</strong></p><!-- /wp:paragraph --><!-- wp:list {"className":"is-style-tw-border-inner"} --><ul class="is-style-tw-border-inner"><!-- wp:list-item --><li>Aliquam tempus mi nulla</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed neque lectus bibendum</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Morbi fringilla sapien libero</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Duis enim elit porttitor id</li> <!-- /wp:list-item --></ul> <!-- /wp:list --><!-- wp:paragraph --><p><a href="#"><strong>' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</strong></a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-column-cards',
	array(
		'title'      => __( 'Pricing 3 column cards', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","className":"tw-justify-center","twColumnStyle":"card-shadow","twTextAlign":"center"} --><div class="wp-block-columns alignwide tw-justify-center tw-cols-card tw-cols-card-shadow has-text-align-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large"} --><p class="has-large-font-size"><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:buttons {"align":"center","className":"tw-mb-4"} --><div class="wp-block-buttons aligncenter tw-mb-4"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-border-inner"} --> <ul class="is-style-tw-border-inner"><!-- wp:list-item --> <li>Venenatis nec convallis</li> <!-- /wp:list-item --> <!-- wp:list-item --> <li>Sed eiusmod ut tempor</li> <!-- /wp:list-item --> <!-- wp:list-item --> <li>Integer enim risus suscipit</li> <!-- /wp:list-item --> <!-- wp:list-item --> <li>Aliquam tempus mi nulla</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large"} --><p class="has-large-font-size"><strong>$49</strong></p><!-- /wp:paragraph --><!-- wp:buttons {"align":"center","className":"tw-mb-4"} --><div class="wp-block-buttons aligncenter tw-mb-4"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-border-inner"} --> <ul class="is-style-tw-border-inner"><!-- wp:list-item --> <li>Sed non neque at lectus</li> <!-- /wp:list-item --> <!-- wp:list-item --> <li>Morbi fringilla sapien</li> <!-- /wp:list-item --> <!-- wp:list-item --> <li>Duis enim elit porttitor</li> <!-- /wp:list-item --> <!-- wp:list-item --> <li>Proin varius libero sit</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">' . esc_html_x( 'Business', 'Block pattern content (refers to a pricing plan, smaller than Enterprise)', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large"} --><p class="has-large-font-size"><strong>$89</strong></p><!-- /wp:paragraph --><!-- wp:buttons {"align":"center","className":"tw-mb-4"} --><div class="wp-block-buttons aligncenter tw-mb-4"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-border-inner"} --> <ul class="is-style-tw-border-inner"><!-- wp:list-item --> <li>Fusce magna eu ligula</li> <!-- /wp:list-item --> <!-- wp:list-item --> <li>Integer sagittis efficitur</li> <!-- /wp:list-item --> <!-- wp:list-item --> <li>Mauris dui tellus</li> <!-- /wp:list-item --> <!-- wp:list-item --> <li>Class aptent taciti</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-column-cards-checkmarked-list',
	array(
		'title'      => __( 'Pricing 3 column cards: checkmarked list', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twColumnStyle":"card-border"} --><div class="wp-block-columns alignwide tw-cols-card tw-cols-card-border"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-4","style":{"typography":{"fontSize":"42px","lineHeight":"1.2"}}} --><p class="tw-mb-4" style="font-size:42px;line-height:1.2"><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:buttons {"className":"tw-mt-4 tw-mb-5"} --><div class="wp-block-buttons tw-mt-4 tw-mb-5"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-4","style":{"typography":{"fontSize":"42px","lineHeight":"1.2"}}} --><p class="tw-mb-4" style="font-size:42px;line-height:1.2"><strong>$49</strong></p><!-- /wp:paragraph --><!-- wp:buttons {"className":"tw-mt-4 tw-mb-5"} --><div class="wp-block-buttons tw-mt-4 tw-mb-5"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla porta luctus</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Business', 'Block pattern content (refers to a pricing plan, smaller than Enterprise)', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-4","style":{"typography":{"fontSize":"42px","lineHeight":"1.2"}}} --><p class="tw-mb-4" style="font-size:42px;line-height:1.2"><strong>$89</strong></p><!-- /wp:paragraph --><!-- wp:buttons {"className":"tw-mt-4 tw-mb-5"} --><div class="wp-block-buttons tw-mt-4 tw-mb-5"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-checkmark tw-list-spacing-medium"} --><ul class="is-style-tw-checkmark tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed eiusmod ut tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla porta luctus</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Lectus bibendum blandit</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-column-cards-image',
	array(
		'title'      => __( 'Pricing 3 column cards: image', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twColumnStyle":"card-shadow","twStretchedMedia":true,"twStretchedLink":true} --><div class="wp-block-columns alignwide tw-cols-card tw-cols-card-shadow tw-stretched-media tw-stretched-link"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$120</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#"><strong>' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</strong></a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$200</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#"><strong>' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</strong></a></p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">' . esc_html_x( 'Business', 'Block pattern content (refers to a pricing plan, smaller than Enterprise)', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$380</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p><a href="#"><strong>' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</strong></a></p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-3-columns-image',
	array(
		'title'      => __( 'Pricing 3 columns: image', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large"} --><p class="has-large-font-size"><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:buttons {"className":"tw-mb-3"} --><div class="wp-block-buttons tw-mb-3"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed eius tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large"} --><p class="has-large-font-size"><strong>$49</strong></p><!-- /wp:paragraph --><!-- wp:buttons {"className":"tw-mb-3"} --><div class="wp-block-buttons tw-mb-3"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed eius tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-2"} --><h3 class="tw-mb-2">' . esc_html_x( 'Business', 'Block pattern content (refers to a pricing plan, smaller than Enterprise)', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"large"} --><p class="has-large-font-size"><strong>$89</strong></p><!-- /wp:paragraph --><!-- wp:buttons {"className":"tw-mb-3"} --><div class="wp-block-buttons tw-mb-3"><!-- wp:button --><div class="wp-block-button"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --><!-- wp:list {"className":"is-style-tw-border-inner tw-list-spacing-medium"} --><ul class="is-style-tw-border-inner tw-list-spacing-medium"><!-- wp:list-item --><li>Venenatis nec convallis</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed eius tempor labore</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Integer enim risus suscipit</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Aliquam tempus mi nulla</li> <!-- /wp:list-item --><!-- wp:list-item --><li>Sed non neque at bibendum</li> <!-- /wp:list-item --></ul> <!-- /wp:list --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/pricing-4-column-cards',
	array(
		'title'      => __( 'Pricing 4 column cards', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twColumnStyle":"card-shadow","twTextAlign":"center"} --><div class="wp-block-columns alignwide tw-cols-card tw-cols-card-shadow has-text-align-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Standard', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"fontSize":"28px","lineHeight":"1.2"}}} --><p style="font-size:28px;line-height:1.2">$16</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Premium', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"fontSize":"28px","lineHeight":"1.2"}}} --><p style="font-size:28px;line-height:1.2">$49</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Business', 'Block pattern content (refers to a pricing plan, smaller than Enterprise)', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"fontSize":"28px","lineHeight":"1.2"}}} --><p style="font-size:28px;line-height:1.2">$89</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"medium"} --><h3 class="has-medium-font-size">' . esc_html_x( 'Enterprise', 'Block pattern pricing content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"style":{"typography":{"fontSize":"28px","lineHeight":"1.2"}}} --><p style="font-size:28px;line-height:1.2">$250</p><!-- /wp:paragraph --><!-- wp:buttons --><div class="wp-block-buttons"><!-- wp:button {"width":100} --><div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link">' . esc_html_x( 'Get started', 'Block pattern content', 'twentig' ) . '</a></div><!-- /wp:button --></div><!-- /wp:buttons --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-table',
	array(
		'title'      => __( 'Price list: table', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:table {"className":"is-style-tw-border-h-inner tw-row-valign-top"} --><figure class="wp-block-table is-style-tw-border-h-inner tw-row-valign-top"><table><tbody><tr><td>Venenatis convallis</td><td class="has-text-align-right" data-align="right">$18</td></tr><tr><td>Aliquam tempus</td><td class="has-text-align-right" data-align="right">$16</td></tr><tr><td>Integer sagittis</td><td class="has-text-align-right" data-align="right">$20</td></tr><tr><td>Efficitur rhoncus</td><td class="has-text-align-right" data-align="right">$13</td></tr><tr><td>Porttitor feugiat</td><td class="has-text-align-right" data-align="right">$15</td></tr></tbody></table></figure><!-- /wp:table --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-table-with-description',
	array(
		'title'      => __( 'Price list: table with description', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:table {"className":"is-style-tw-border-h-inner tw-row-valign-top"} --><figure class="wp-block-table is-style-tw-border-h-inner tw-row-valign-top"><table><tbody><tr><td><strong>' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</strong><br><em>Sed do eiusmod ut tempor incididunt ut labore et dolore</em></td><td class="has-text-align-right" data-align="right">$16</td></tr><tr><td><strong>' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</strong><br><em>Venenatis nec convallis magna eu congue velit</em></td><td class="has-text-align-right" data-align="right">$18</td></tr><tr><td><strong>' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</strong><br><em>Fusce sed magna eu ligula commodo hendrerit fringilla</em></td><td class="has-text-align-right" data-align="right">$15</td></tr><tr><td><strong>' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</strong><br><em>Duis enim elit porttitor id feugiat at blandit at erat</em></td><td class="has-text-align-right" data-align="right">$24</td></tr></tbody></table></figure><!-- /wp:table --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-stack',
	array(
		'title'      => __( 'Price List: stack', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:heading {"textAlign":"center","level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="has-text-align-center tw-mb-1 has-medium-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","className":"tw-mb-1"} --><p class="has-text-align-center tw-mb-1"><em>Lorem ipsum dolor sit amet commodo erat adipiscing elit</em></p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">$18</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="has-text-align-center tw-mt-5 tw-mb-1 has-medium-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","className":"tw-mb-1"} --><p class="has-text-align-center tw-mb-1"><em>Integer enim risus suscipit eu iaculis sed ullamcorper at metus</em></p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">$16</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="has-text-align-center tw-mt-5 tw-mb-1 has-medium-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","className":"tw-mb-1"} --><p class="has-text-align-center tw-mb-1"><em>Aliquam tempus mi nulla porta luctus non neque at lectus bibendum blandit</em></p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">$20</p><!-- /wp:paragraph --><!-- wp:heading {"textAlign":"center","level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="has-text-align-center tw-mt-5 tw-mb-1 has-medium-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"align":"center","className":"tw-mb-1"} --><p class="has-text-align-center tw-mb-1"><em>Duis enim elit porttitor id feugiat at blandit at erat varius libero amet</em></p><!-- /wp:paragraph --><!-- wp:paragraph {"align":"center"} --><p class="has-text-align-center">$13</p><!-- /wp:paragraph --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-stack-with-separator',
	array(
		'title'      => __( 'Price list: stack with separator', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-3"} --><h3 class="has-large-font-size tw-mb-3">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$120</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis consectetur consectetur est.</p><!-- /wp:paragraph --><!-- wp:separator {"className":"tw-mt-7 tw-mb-7"} --><hr class="wp-block-separator tw-mt-7 tw-mb-7"/><!-- /wp:separator --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-3"} --><h3 class="has-large-font-size tw-mb-3">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$240</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna eu congue velit. Suspendisse vel nulla at lectus fermentum faucibus vitae at mi.</p><!-- /wp:paragraph --><!-- wp:separator {"className":"tw-mt-7 tw-mb-7"} --><hr class="wp-block-separator tw-mt-7 tw-mb-7"/><!-- /wp:separator --><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-3"} --><h3 class="has-large-font-size tw-mb-3">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$260</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Vestibulum consectetur sodales nisl et ultrices.</p><!-- /wp:paragraph --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-2-column-cards',
	array(
		'title'      => __( 'Price list: 2 column cards', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"twColumnStyle":"card-border"} --><div class="wp-block-columns tw-cols-card tw-cols-card-border"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>$12</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus suscipit eu iaculis sed ullamcorper at metus</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"twColumnStyle":"card-border"} --><div class="wp-block-columns tw-cols-card tw-cols-card-border"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>$20</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus non neque at lectus bibendum blandit</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-2","fontSize":"medium"} --><h3 class="tw-mb-2 has-medium-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size"><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Duis enim elit porttitor id feugiat at blandit at erat varius libero sit amet</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-2-columns-with-top-border',
	array(
		'title'      => __( 'Price list: 2 columns with top border', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Choose the right solution that fits your needs', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twGutter":"large","twColumnStyle":"border-top"} --><div class="wp-block-columns alignwide tw-gutter-large tw-cols-border-top"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$18</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Lorem ipsum dolor sit amet, commodo erat adipiscing elit. Sed do eiusmod ut tempor incididunt ut labore et dolore. Duis consectetur consectetur est. Nunc vestibulum id lectus eu vestibulum.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$16</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Integer enim risus, suscipit eu iaculis sed, ullamcorper at metus. Venenatis nec convallis magna, eu congue velit. Suspendisse vel nulla at lectus fermentum faucibus vitae at mi neque ac suscipit porta.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","twGutter":"large","twColumnStyle":"border-top"} --><div class="wp-block-columns alignwide tw-gutter-large tw-cols-border-top"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$13</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Aliquam tempus mi nulla porta luctus. Sed non neque at lectus bibendum blandit. Morbi fringilla sapien libero. Vestibulum consectetur sodales nisl et ultrices. Quisque sed ligula lectus.</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"fontSize":"large","className":"tw-mb-2"} --><h3 class="has-large-font-size tw-mb-2">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph --><p><strong>$15</strong></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>Duis enim elit, porttitor id feugiat at, blandit at erat. Proin varius libero sit amet tortor volutpat diam laoreet. Integer malesuada risus blandit dignissim convallis.</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-3-columns',
	array(
		'title'      => __( 'Price list: 3 columns', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twGutter":"large","twStack":"sm"} --><div class="wp-block-columns alignwide tw-gutter-large tw-cols-stack-sm"><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"className":"tw-mb-2"} --><p class="tw-mb-2">Lorem ipsum dolor sit amet commodo erat adipiscing elit</p><!-- /wp:paragraph --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">$18</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"className":"tw-mb-2"} --><p class="tw-mb-2">Integer enim risus suscipit eu iaculis sed ullamcorper at metus</p><!-- /wp:paragraph --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">$16</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"className":"tw-mb-2"} --><p class="tw-mb-2">Aliquam tempus mi nulla porta luctus non neque at lectus bibendum blandit</p><!-- /wp:paragraph --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">$20</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","twGutter":"large","twStack":"sm"} --><div class="wp-block-columns alignwide tw-gutter-large tw-cols-stack-sm"><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"className":"tw-mb-2"} --><p class="tw-mb-2">Duis enim elit porttitor id feugiat at blandit at erat varius libero amet</p><!-- /wp:paragraph --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">$13</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"className":"tw-mb-2"} --><p class="tw-mb-2">Fusce sed magna eu ligula commodo hendrerit fringilla ac purus</p><!-- /wp:paragraph --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">$15</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:paragraph {"className":"tw-mb-2"} --><p class="tw-mb-2">Mauris dui tellus mollis quis varius sit amet ultrices in leo</p><!-- /wp:paragraph --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">$24</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-3-columns-with-centered-text',
	array(
		'title'      => __( 'Price list: 3 columns with centered text', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide","twGutter":"large","twStack":"sm","twTextAlign":"center"} --><div class="wp-block-columns alignwide tw-gutter-large tw-cols-stack-sm has-text-align-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-1"} --><p class="tw-mb-1"><em>Lorem ipsum dolor sit amet commodo erat adipiscing elit</em></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>$18</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-1"} --><p class="tw-mb-1"><em>Integer enim risus suscipit eu iaculis sed ullamcorper at metus</em></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>$16</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-1"} --><p class="tw-mb-1"><em>Aliquam tempus mi nulla porta luctus non neque at lectus bibendum blandit</em></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>$20</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide","twGutter":"large","twStack":"sm","twTextAlign":"center"} --><div class="wp-block-columns alignwide tw-gutter-large tw-cols-stack-sm has-text-align-center"><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-1"} --><p class="tw-mb-1"><em>Duis enim elit porttitor id feugiat at blandit at erat varius libero amet</em></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>$13</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">' . esc_html_x( 'Fifth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-1"} --><p class="tw-mb-1"><em>Fusce sed magna eu ligula commodo hendrerit fringilla ac purus</em></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>$15</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"medium"} --><h3 class="tw-mb-1 has-medium-font-size">' . esc_html_x( 'Sixth item', 'Block pattern content', 'twentig' ) . '</h3><!-- /wp:heading --><!-- wp:paragraph {"className":"tw-mb-1"} --><p class="tw-mb-1"><em>Mauris dui tellus mollis quis varius sit amet ultrices in leo</em></p><!-- /wp:paragraph --><!-- wp:paragraph --><p>$24</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

twentig_register_block_pattern(
	'twentig/price-list-4-columns-with-image',
	array(
		'title'      => __( 'Price list: 4 columns with image', 'twentig' ),
		'categories' => array( 'pricing' ),
		'content'    => '<!-- wp:group {"align":"full"} --><div class="wp-block-group alignfull"><!-- wp:heading {"textAlign":"center"} --><h2 class="has-text-align-center">' . esc_html_x( 'Pricing', 'Block pattern content', 'twentig' ) . '</h2><!-- /wp:heading --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape1.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"normal"} --><h3 class="tw-mb-1 has-normal-font-size">' . esc_html_x( 'First item', 'Block pattern content', 'twentig' ) . ' — $18</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">Lorem ipsum dolor sit amet</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape2.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"normal"} --><h3 class="tw-mb-1 has-normal-font-size">' . esc_html_x( 'Second item', 'Block pattern content', 'twentig' ) . ' — $15</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">Sed do eiusmod ut tempor incididunt</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape3.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"normal"} --><h3 class="tw-mb-1 has-normal-font-size">' . esc_html_x( 'Third item', 'Block pattern content', 'twentig' ) . ' — $12</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">Integer enim risus suscipit eu iaculis sed</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape4.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"normal"} --><h3 class="tw-mb-1 has-normal-font-size">' . esc_html_x( 'Fourth item', 'Block pattern content', 'twentig' ) . ' — $16</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">Venenatis nec convallis magna</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --><!-- wp:columns {"align":"wide"} --><div class="wp-block-columns alignwide"><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape5.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"normal"} --><h3 class="tw-mb-1 has-normal-font-size">' . esc_html_x( 'Fifth item', 'Block pattern content', 'twentig' ) . ' — $12</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">Aliquam tempus mi eu nulla porta luctus</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape6.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"normal"} --><h3 class="tw-mb-1 has-normal-font-size">' . esc_html_x( 'Sixth item', 'Block pattern content', 'twentig' ) . ' — $14</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">Sed non neque at lectus bibendum blandit</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape7.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"normal"} --><h3 class="tw-mb-1 has-normal-font-size">' . esc_html_x( 'Seventh item', 'Block pattern content', 'twentig' ) . ' — $20</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">Duis enim elit porttitor id feugiat at blandit</p><!-- /wp:paragraph --></div><!-- /wp:column --><!-- wp:column --><div class="wp-block-column"><!-- wp:image --><figure class="wp-block-image"><img src="' . twentig_get_pattern_asset( 'landscape8.jpg' ) . '" alt=""/></figure><!-- /wp:image --><!-- wp:heading {"level":3,"className":"tw-mb-1","fontSize":"normal"} --><h3 class="tw-mb-1 has-normal-font-size">' . esc_html_x( 'Eighth item', 'Block pattern content', 'twentig' ) . ' — $15</h3><!-- /wp:heading --><!-- wp:paragraph {"fontSize":"small"} --><p class="has-small-font-size">Proin varius libero sit amet tortor volutpat</p><!-- /wp:paragraph --></div><!-- /wp:column --></div><!-- /wp:columns --></div><!-- /wp:group -->',
	)
);

