<?php
function tp_product_image_flipper_register_settings() {
    register_setting( 'tp_product_image_flipper_settings', 'remove_duplicate_images' );
    register_setting( 'tp_product_image_flipper_settings', 'images_from_gallery_only' );
    register_setting( 'tp_product_image_flipper_settings', 'add_product_link_to_image' );
}

add_action( 'admin_init', 'tp_product_image_flipper_register_settings' );

function tp_product_image_flipper_settings_page() {
?>
    <div class="wrap">
        <h1><?php echo TP_PRODUCT_IMAGE_FLIPPER_NAME; ?></h1>
        <form method="post" action="options.php">
            <?php settings_fields( 'tp_product_image_flipper_settings' ); ?>
            <?php do_settings_sections( 'tp_product_image_flipper_settings' ); ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Remove Duplicate Images</th>
                    <td><input type="checkbox" name="remove_duplicate_images" value="1" <?php checked(1, get_option('remove_duplicate_images'), true); ?> /></td>
                    <td><?php echo __('If checked, this option will remove any additional images of a product in the shop/category pages, showing only the ones generated by the plugin.', 'tp-product-image-flipper-for-woocommerce'); ?></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Images From Gallery Only</th>
                    <td><input type="checkbox" name="images_from_gallery_only" value="1" <?php checked(1, get_option('images_from_gallery_only'), true); ?> /></td>
                    <td><?php echo __('If checked, this option will use only images from the product gallery for the image flipper. If there are less than two images in the gallery, it will show the product main image.', 'tp-product-image-flipper-for-woocommerce'); ?></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Add Product Link to Images</th>
                    <td><input type="checkbox" name="add_product_link_to_image" value="1" <?php checked(1, get_option('add_product_link_to_image'), true); ?> /></td>
                    <td><?php echo __('If checked, this option will add the product link to the image. In some themes the product link is removed from the image for a certain reason, if this happens to you, activate this option.', 'tp-product-image-flipper-for-woocommerce'); ?></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
<?php
}

function tp_product_image_flipper_menu() {
    add_options_page(
        'TP Product Image Flipper Settings',
        'TP Product Image Flipper',
        'manage_options',
        'tp-product-image-flipper',
        'tp_product_image_flipper_settings_page'
    );
}

add_action( 'admin_menu', 'tp_product_image_flipper_menu' );
