<?php // Don't load directly
defined( 'ABSPATH' ) || exit;
?>
<!--Highlights Start -->
<div class="tf-overview-wrapper">
    <div class="tf-highlights-wrapper">
        <div class="tf-highlights-icon">
            <?php if ( ! empty( $meta['hightlights_thumbnail'] ) ): ?>
                <img src="<?php echo esc_url( $meta['hightlights_thumbnail'] ); ?>" alt="<?php esc_html_e( 'Highlights Icon', 'tourfic' ); ?>" />
            <?php else: ?>
                <svg width="119" height="189" viewBox="0 0 119 189" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <mask id="path-1-outside-1_3906_8185" maskUnits="userSpaceOnUse" x="0.0390625" y="-0.453125" width="119" height="189" fill="black">
                    <rect fill="white" x="0.0390625" y="-0.453125" width="119" height="189"/>
                    <path d="M117.681 62.0771C117.055 55.8862 115.822 49.721 114.474 43.5525C114.135 42.0128 113.793 40.4667 113.452 38.9205C113.11 37.3776 112.774 35.8219 112.391 34.2758C111.634 31.1836 110.762 28.1137 109.781 25.0694C108.797 22.0283 107.702 19.0128 106.449 16.0547C105.191 13.103 103.772 10.2025 102.054 7.47124C101.191 6.10721 100.252 4.78791 99.1756 3.57082L98.7667 3.11721C98.6325 2.96388 98.4824 2.82652 98.3418 2.67957C98.0575 2.38888 97.77 2.10457 97.457 1.83624C97.1471 1.56791 96.8149 1.31235 96.4507 1.09832C96.0866 0.884293 95.6873 0.711794 95.2624 0.615961C94.8311 0.523322 94.3839 0.526515 93.9622 0.609571C93.5374 0.692626 93.1349 0.849156 92.7611 1.05041C92.0136 1.4561 91.3907 2.04707 90.8988 2.72429C90.6496 3.0629 90.4484 3.43346 90.2791 3.81041C90.1098 4.19054 89.9692 4.58346 89.8606 4.97957C89.8446 5.03388 89.8318 5.08499 89.8191 5.13929C89.5284 5.44915 89.2377 5.76221 88.9406 6.08166C88.487 6.55443 88.011 7.02082 87.535 7.49999C87.2954 7.73957 87.0559 7.97915 86.8163 8.22193C86.5671 8.45832 86.3179 8.69471 86.0656 8.93429C85.5609 9.41027 85.0498 9.89582 84.5323 10.3878C84.002 10.8669 83.4653 11.3525 82.9223 11.8444C82.6475 12.0872 82.3792 12.3428 82.0981 12.5823C81.817 12.8251 81.5359 13.0711 81.2516 13.3171C80.6798 13.8058 80.1111 14.3137 79.517 14.8057C78.3286 15.7896 77.118 16.8118 75.8434 17.8117C74.5848 18.8339 73.2591 19.8337 71.911 20.8719C69.1893 22.9132 66.2984 24.9896 63.2061 27.0596C60.1043 29.1136 56.8077 31.1676 53.265 33.113C52.821 33.3558 52.377 33.5986 51.9298 33.8446C51.4761 34.081 51.0193 34.3078 50.5593 34.541C50.0993 34.7742 49.6361 35.0074 49.173 35.2405C48.7034 35.4674 48.2306 35.6973 47.7578 35.9273C45.8635 36.8537 43.9309 37.7961 41.9599 38.7576C38.018 40.6679 33.9131 42.6325 29.5654 44.4565C29.0192 44.6801 28.473 44.9037 27.9235 45.1305C27.3709 45.3478 26.815 45.565 26.256 45.7854C25.6938 45.993 25.1316 46.2071 24.5629 46.4115C24.2786 46.5105 23.9911 46.6096 23.7068 46.7118L23.5375 46.7693C23.5375 46.7693 23.5375 46.7661 23.5375 46.7597V46.7469L23.5343 46.6192C23.5343 46.5329 23.5248 46.4498 23.5152 46.3668C23.496 46.1975 23.4609 46.0346 23.4129 45.8717C23.3171 45.549 23.1638 45.2392 22.9625 44.9676C22.7613 44.6929 22.5089 44.4533 22.2118 44.268C21.918 44.086 21.5793 43.9614 21.2343 43.9198C20.5443 43.8368 19.832 44.0221 19.2698 44.4373C18.9886 44.6418 18.7459 44.9133 18.5702 45.2104C18.3913 45.5075 18.2731 45.8237 18.1709 46.1304C17.9664 46.7437 17.8195 47.3507 17.4841 47.8139C17.1518 48.2835 16.6311 48.6093 16.0689 48.868C15.7846 48.9958 15.4907 49.1108 15.1873 49.2258C14.8838 49.3408 14.5803 49.4526 14.2768 49.5676C13.6699 49.7976 13.0598 50.0276 12.4464 50.2576C11.2198 50.724 9.9867 51.1776 8.73767 51.6632C7.49503 52.1583 6.23322 52.7397 5.14711 53.631C4.70309 53.9951 4.291 54.4168 3.9492 54.8928L3.81503 55.0685L3.69684 55.2537C3.61698 55.3783 3.54031 55.5029 3.46045 55.6275C3.39336 55.7585 3.32628 55.8894 3.256 56.0204L3.15378 56.2185C3.12184 56.2855 3.09628 56.3558 3.06753 56.4229C3.01003 56.5603 2.95573 56.6976 2.89823 56.835C2.84712 56.9755 2.80559 57.1161 2.75767 57.2598C2.65545 57.541 2.60114 57.8348 2.52448 58.1223C2.40628 58.7069 2.31045 59.3011 2.26892 59.9017C2.16989 61.1028 2.21142 62.323 2.30087 63.5465C2.34559 64.1598 2.39989 64.77 2.47017 65.3897C2.53726 66.0094 2.6235 66.6323 2.72892 67.2553C2.93975 68.5011 3.21767 69.7501 3.57864 70.996C3.93962 72.2418 4.38364 73.4812 4.93948 74.6919C5.49531 75.8994 6.16295 77.0846 7.00628 78.1707C7.43434 78.7074 7.89114 79.228 8.41184 79.6944C8.92934 80.1608 9.50114 80.5889 10.1336 80.9147C10.7661 81.2437 11.4466 81.4833 12.1461 81.6303C12.8457 81.7804 13.5613 81.8411 14.2705 81.8571C15.6952 81.8922 17.1071 81.7421 18.5223 81.6782C19.9438 81.6047 21.3813 81.5472 22.8348 81.4162C24.285 81.2821 25.7513 81.084 27.1952 80.6815C27.3932 80.6208 27.4827 80.6112 27.9043 80.4643L28.4282 80.2886L28.6902 80.1992L28.8211 80.1544C28.8435 80.1385 28.9649 80.1257 28.8818 80.1065L28.3803 79.8957L28.1279 79.7903L28.0034 79.736L27.866 79.6817C27.8181 79.6657 27.7766 79.6433 27.735 79.6242L27.62 79.5698L27.4986 79.5124C27.4188 79.474 27.3389 79.4357 27.2623 79.3878C26.6393 79.0428 26.0611 78.5987 25.5309 78.1036C24.4703 77.1037 23.5918 75.8962 22.8284 74.6153C21.311 72.0373 20.2153 69.1751 19.3368 66.2298C18.9088 64.754 18.5127 63.2558 18.2667 61.7321C18.0175 60.2051 17.8802 58.6526 17.8961 57.0969C17.9089 55.5412 18.0814 53.9792 18.4807 52.4714L18.6341 51.906L18.8225 51.3533C18.9375 50.9796 19.1068 50.6282 19.257 50.2704C19.3273 50.0883 19.4295 49.9222 19.5157 49.7465C19.6084 49.574 19.6946 49.3983 19.7905 49.2322L20.1067 48.7403L20.2632 48.4943C20.2856 48.4655 20.3048 48.4432 20.3271 48.4208C20.3527 48.4048 20.3686 48.3793 20.3974 48.3697C20.4421 48.3346 20.4996 48.3314 20.5539 48.3218C20.6114 48.3218 20.6689 48.3346 20.7232 48.3569C20.8318 48.4112 20.9181 48.5039 20.9373 48.6189C20.9404 48.6317 20.9436 48.6476 20.9468 48.6604C20.9468 48.6764 20.9468 48.6892 20.9468 48.7051C20.9532 48.7339 20.9373 48.769 20.9373 48.801C20.9373 48.8137 20.9277 48.8425 20.9245 48.8648L20.9085 48.9383L20.8734 49.0853L20.736 49.673C20.5571 50.4589 20.3942 51.2511 20.26 52.0497C19.9885 53.6469 19.8256 55.2761 19.8671 56.9148C19.8959 57.7326 19.9534 58.5504 20.0748 59.3618C20.1227 59.7675 20.2057 60.17 20.2728 60.5757C20.3591 60.975 20.4325 61.3807 20.5348 61.7768C20.9117 63.3708 21.426 64.9265 21.9882 66.463C22.56 67.9964 23.1798 69.5042 23.8027 71.0151C24.4352 72.5229 25.106 74.0339 25.9909 75.4426C26.4349 76.1454 26.93 76.8194 27.5018 77.4328C28.0704 78.0461 28.7189 78.5987 29.4409 79.0396C30.1564 79.4772 30.9678 79.835 31.8559 79.8925C32.2967 79.9148 32.7599 79.8573 33.1784 79.6753C33.5968 79.4964 33.9482 79.2281 34.2645 78.9533C34.5839 78.6786 34.865 78.3879 35.1813 78.1387L35.6413 77.7522C35.718 77.6883 35.7946 77.6212 35.8745 77.5605L36.1205 77.3848L36.6124 77.0335C36.6954 76.976 36.7753 76.9153 36.8584 76.861L37.1171 76.7044L37.6314 76.3914C37.7177 76.3403 37.8007 76.2828 37.8902 76.238L38.1585 76.1007C39.5768 75.3404 41.1006 74.7782 42.6563 74.3565C45.3396 73.6346 48.1124 73.3119 50.882 73.0947C50.4348 73.2289 49.9875 73.363 49.5403 73.4972C47.9942 73.9636 46.4545 74.4268 44.9179 74.8868C44.1513 75.1168 43.3814 75.35 42.618 75.58C41.8513 75.8132 41.0878 76.0336 40.3211 76.2828C39.5545 76.5351 38.7878 76.8354 38.085 77.2794C37.7336 77.4998 37.4046 77.7618 37.1107 78.0621C37.0341 78.1355 36.967 78.2122 36.8967 78.2953L36.7945 78.4166L36.6923 78.5572C36.5645 78.7521 36.4814 78.9661 36.4271 79.1801C36.3153 79.6114 36.3185 80.0426 36.3664 80.4579C36.392 80.6655 36.4335 80.87 36.4814 81.0712L36.5453 81.3012V81.3044L36.5549 81.3332L36.5709 81.3907C36.5836 81.429 36.5932 81.4673 36.606 81.5025C36.6539 81.6494 36.7082 81.7868 36.7593 81.9114C36.8616 82.1605 36.967 82.3586 37.0341 82.4832C37.2449 82.8601 37.4653 83.1285 37.7145 83.3425C37.8934 83.4958 38.0914 83.6236 38.3214 83.7194C37.8486 84.0517 37.3823 84.3967 36.9318 84.764C36.0374 85.4923 35.1877 86.2878 34.4242 87.163C33.6575 88.0351 32.9739 88.9871 32.4117 90.0093C31.8431 91.0315 31.4246 92.1304 31.0892 93.2389C30.4248 95.4654 30.0798 97.7399 29.4728 99.9312C28.3036 104.34 26.5179 108.559 24.3617 112.517C22.2022 116.478 19.6755 120.187 16.9857 123.676C14.296 127.164 11.4466 130.438 8.58434 133.562C7.15323 135.124 5.71573 136.648 4.291 138.14C3.7735 138.68 3.2624 139.21 2.76087 139.734C2.71615 139.782 2.67142 139.83 2.6267 139.875C2.4542 140.053 2.31364 140.2 2.2242 140.293C1.65559 140.89 1.39365 141.29 1.03906 141.906C1.64281 141.529 3.10267 140.159 3.15059 140.111C3.65211 139.587 4.16323 139.054 4.68392 138.514C6.11184 137.019 7.54934 135.492 8.98684 133.927C11.8554 130.796 14.7145 127.509 17.417 124.005C20.1163 120.5 22.6623 116.769 24.8377 112.776C27.0131 108.786 28.8148 104.525 29.9967 100.069C30.61 97.8453 30.9582 95.5644 31.6099 93.3922C31.9389 92.3061 32.3414 91.2519 32.8877 90.268C33.4307 89.2842 34.092 88.3642 34.8331 87.5176C35.5742 86.6711 36.3984 85.8949 37.2736 85.1825C38.1521 84.4733 39.0817 83.8312 40.04 83.2339C40.9984 82.6397 41.9854 82.0935 42.9917 81.5855C43.9979 81.0808 45.0234 80.608 46.052 80.1576C48.9717 78.883 51.9521 77.8097 54.9198 76.8067C54.8079 76.9185 54.7025 77.0367 54.6035 77.158C54.431 77.3753 54.2745 77.6053 54.1435 77.8576C54.0125 78.11 53.9071 78.3815 53.8656 78.6882C53.8464 78.8415 53.8432 79.0012 53.8752 79.1673C53.9071 79.3303 53.9742 79.4964 54.0764 79.6369C54.102 79.6689 54.1307 79.704 54.1563 79.736L54.2457 79.8254L54.3448 79.9021C54.3895 79.934 54.4534 79.9724 54.5077 80.0075C54.5332 80.0298 54.562 80.0426 54.5971 80.0299L54.6929 80.0139L54.8239 79.9915L55.022 79.9564C55.5523 79.8573 56.0761 79.7232 56.5936 79.5539C57.6286 79.2216 58.6189 78.7457 59.5453 78.1579C60.0085 77.864 60.4525 77.535 60.8742 77.1772C60.8966 77.158 60.9221 77.1389 60.9445 77.1165C60.9317 77.1517 60.9221 77.1868 60.9093 77.2219C60.756 77.6819 60.5675 78.1547 60.4334 78.6467C60.181 79.5411 59.606 80.3205 58.9863 81.0425C58.357 81.7676 57.7053 82.4768 57.0473 83.1476C56.386 83.8217 55.7024 84.4574 54.9868 85.0324C54.2713 85.6074 53.5206 86.1217 52.7316 86.5242C51.9425 86.9267 51.1088 87.2174 50.2623 87.3419C49.8374 87.4026 49.4125 87.4218 48.9941 87.3962L48.8535 87.3898L48.6842 87.3707L48.352 87.3355L48.0198 87.3004L47.8632 87.2844C47.8888 87.3292 47.9367 87.3835 47.9718 87.4314L48.2082 87.7508L48.3296 87.9137C48.3647 87.968 48.3935 88.016 48.4159 88.0671L48.4542 88.1661C48.4638 88.1853 48.4702 88.2076 48.4734 88.23C48.4829 88.2747 48.4989 88.3162 48.5053 88.361C48.5692 88.7187 48.4925 89.1117 48.3392 89.4662C48.2625 89.6451 48.1635 89.8144 48.0549 89.9742C47.9431 90.1307 47.8153 90.2712 47.6684 90.415C47.0934 90.974 46.3682 91.3989 45.7389 91.9899C45.2086 92.4882 44.7902 93.1111 44.5378 93.7915C44.2854 94.4719 44.1928 95.1907 44.196 95.8935C44.212 97.3054 44.5825 98.6535 45.0457 99.9217C45.2789 100.557 45.5473 101.18 45.8316 101.781C46.1127 102.385 46.3842 102.988 46.6749 103.582C46.9592 104.18 47.2435 104.771 47.5406 105.359C47.6875 105.652 47.8345 105.946 47.9782 106.237C48.1284 106.528 48.2785 106.815 48.4286 107.106C50.8245 111.728 53.4471 116.05 56.2263 120.066C57.2964 121.612 58.3921 123.113 59.5038 124.57C59.1779 124.509 58.8425 124.522 58.5327 124.573C58.0631 124.656 57.6286 124.819 57.2198 125.011C55.5906 125.797 54.3 126.979 52.9328 127.87C52.2492 128.323 51.5464 128.726 50.8341 129.074C50.1249 129.422 49.4061 129.719 48.6874 129.959C47.2467 130.432 45.8124 130.675 44.4611 130.7C43.1099 130.729 41.8513 130.531 40.7556 130.192C40.3179 130.058 39.9123 129.902 39.5289 129.726C39.3181 129.454 39.0721 129.196 38.791 128.953C38.5323 128.726 38.1138 128.403 37.51 128.097C37.3567 128.026 37.2002 127.94 37.0245 127.873C36.9734 127.854 36.9223 127.832 36.8711 127.809C36.8839 127.79 36.8871 127.784 36.868 127.809C36.8296 127.793 36.7945 127.78 36.7561 127.764L36.7466 127.761C36.162 128.627 36.5868 128.004 36.4591 128.202L36.4718 128.215L36.4974 128.24L36.5485 128.295C36.5836 128.33 36.6188 128.368 36.6539 128.407C36.9478 128.697 37.28 129.001 37.6761 129.279C38.1138 129.595 38.6185 129.895 39.1807 130.16C39.4906 130.579 39.7174 131.016 39.8643 131.444C40.1167 132.157 40.1678 132.828 40.1454 133.406C40.1231 133.987 40.0113 134.479 39.8899 134.888C39.7685 135.297 39.628 135.626 39.4938 135.891C39.2286 136.421 39.021 136.706 38.906 136.872C38.8485 136.955 38.807 137.003 38.7846 137.035C38.7623 137.067 38.7527 137.076 38.7527 137.076C38.7527 137.076 38.7175 137.121 38.6473 137.21C38.5738 137.303 38.462 137.437 38.3182 137.613C38.0339 137.967 37.6123 138.491 37.0756 139.162C36.0086 140.507 34.4849 142.443 32.6736 144.832C29.048 149.605 24.2627 156.173 19.6499 163.328C17.3499 166.909 15.0882 170.631 13.0693 174.352C12.9416 174.585 12.817 174.815 12.6892 175.049C12.5678 175.282 12.4432 175.515 12.3218 175.748C12.0791 176.215 11.8363 176.678 11.5967 177.138C11.1367 178.071 10.6639 178.984 10.2391 179.911C10.1304 180.141 10.0218 180.371 9.91642 180.597C9.80781 180.824 9.7024 181.054 9.60337 181.284C9.40212 181.741 9.20087 182.198 9.00281 182.648C8.80475 183.099 8.62906 183.555 8.44698 183.999C8.35753 184.223 8.26489 184.447 8.17545 184.667C8.10517 184.852 8.03809 185.038 7.96781 185.223C7.77934 185.737 7.62281 186.159 7.54614 186.37C7.28101 187.156 7.22989 187.638 7.17878 188.341C7.55892 187.737 7.66753 187.322 7.93906 186.545C8.01573 186.338 8.6099 185.044 8.68017 184.859C8.76962 184.638 8.85906 184.418 8.94851 184.197C9.13059 183.753 9.30628 183.303 9.50114 182.856C9.6992 182.409 9.89725 181.958 10.0953 181.501C10.1943 181.275 10.2966 181.048 10.4052 180.821C10.5106 180.594 10.6192 180.367 10.7278 180.137C11.1495 179.221 11.6191 178.31 12.0759 177.381C12.3154 176.921 12.555 176.461 12.7978 175.997C12.9192 175.767 13.0406 175.534 13.162 175.301C13.2866 175.071 13.4143 174.841 13.5389 174.608C15.5482 170.902 17.8067 167.19 20.1003 163.619C24.7035 156.482 29.4792 149.924 33.0985 145.158C34.9066 142.772 36.4271 140.839 37.4941 139.498C38.0307 138.83 38.4492 138.309 38.7335 137.952C38.8773 137.776 38.9859 137.642 39.0593 137.549C39.1328 137.453 39.1711 137.402 39.1711 137.402C39.1711 137.402 39.1807 137.389 39.2063 137.357C39.2318 137.322 39.2766 137.271 39.3373 137.182C39.4618 137.003 39.6855 136.696 39.9698 136.124C40.1135 135.84 40.2636 135.482 40.3978 135.038C40.5288 134.594 40.6502 134.061 40.6757 133.425C40.7013 132.792 40.6438 132.051 40.3659 131.262C40.2796 131.016 40.171 130.767 40.0368 130.518C40.2157 130.585 40.3978 130.646 40.5863 130.703C41.7363 131.058 43.0524 131.266 44.4611 131.234C45.8667 131.208 47.3585 130.956 48.8471 130.467C49.5914 130.218 50.3325 129.914 51.0641 129.553C51.7956 129.196 52.5175 128.783 53.2203 128.317C53.9327 127.857 54.5939 127.327 55.2839 126.835C55.9707 126.34 56.6799 125.857 57.4402 125.496C57.8203 125.317 58.2132 125.171 58.6125 125.103C59.0086 125.036 59.4111 125.052 59.7593 125.209C59.9223 125.282 60.0756 125.385 60.2257 125.512C60.3152 125.627 60.4046 125.746 60.4941 125.861C60.6793 126.094 60.8806 126.33 61.1074 126.544C61.2927 126.713 61.4971 126.873 61.7303 126.995C61.9156 127.126 62.1328 127.237 62.3756 127.288C62.5225 127.324 62.6088 127.327 62.7206 127.346C62.826 127.362 62.9346 127.381 63.0432 127.403C63.2605 127.442 63.4904 127.496 63.7556 127.499C64.0175 127.509 64.2954 127.432 64.5254 127.324C64.583 127.295 64.6373 127.263 64.6916 127.234L64.8481 127.135L65.1292 126.947L65.685 126.57C65.8384 126.467 65.9885 126.365 66.1418 126.26C66.4485 126.132 66.7488 125.998 67.0491 125.857C68.0872 125.365 69.0839 124.806 70.0295 124.19C70.9686 123.564 71.8791 122.909 72.6872 122.126C73.0898 121.737 73.4667 121.318 73.7957 120.861C74.1216 120.404 74.3995 119.906 74.6007 119.379C74.6518 119.248 74.6902 119.111 74.7381 118.98C74.7732 118.842 74.8116 118.702 74.8371 118.564C74.8882 118.283 74.9202 118.002 74.9202 117.721C74.9234 117.156 74.8307 116.597 74.6423 116.066C74.4474 115.539 74.1471 115.047 73.7446 114.648C73.6488 114.543 73.5306 114.46 73.422 114.37C73.3677 114.322 73.307 114.287 73.2463 114.249L73.1568 114.191C73.1536 114.188 73.1504 114.188 73.1473 114.185L73.2974 114.083C73.3549 114.047 73.4028 114.003 73.4539 113.961L73.7606 113.706L73.9139 113.578L74.0545 113.437L74.3388 113.159C74.4378 113.07 74.5145 112.965 74.6039 112.866L74.8627 112.565C75.0192 112.354 75.1757 112.144 75.3259 111.93C75.7635 111.265 76.1149 110.55 76.3705 109.812C76.3768 109.805 76.3832 109.796 76.3896 109.789C76.6548 109.476 76.872 109.138 77.0445 108.789C77.217 108.441 77.3384 108.083 77.415 107.729C77.4917 107.374 77.5364 107.02 77.5204 106.675C77.5045 105.988 77.3032 105.343 76.9646 104.844C76.8464 104.656 76.7091 104.496 76.5717 104.349C76.5685 104.34 76.5621 104.33 76.5589 104.32C76.5398 104.276 76.5174 104.25 76.495 104.215C76.4503 104.145 76.4024 104.1 76.3577 104.042C76.3098 103.995 76.2618 103.943 76.2107 103.902C76.0798 103.787 75.9456 103.685 75.8082 103.595C75.5335 103.314 75.3163 103.052 75.2013 102.79C74.9298 102.209 75.1214 101.707 75.2492 101.397C75.3195 101.241 75.3802 101.123 75.4217 101.043C75.4632 100.963 75.4856 100.925 75.4856 100.925C75.4856 100.925 75.5175 100.87 75.5814 100.759C75.6485 100.647 75.7443 100.481 75.8753 100.26C75.9424 100.148 76.0127 100.021 76.0861 99.8674C76.1213 99.7907 76.166 99.714 76.198 99.6278C76.2299 99.5415 76.265 99.4521 76.3002 99.3594C76.4312 98.9825 76.5461 98.5321 76.5845 98.0114C76.6228 97.4907 76.5941 96.8965 76.4024 96.2704C76.3513 96.1139 76.3034 95.9542 76.2267 95.8008C76.1884 95.7242 76.1596 95.6411 76.1149 95.5644C76.0702 95.4878 76.0223 95.4111 75.9775 95.3344C75.936 95.2546 75.8753 95.1843 75.8178 95.1108C75.7571 95.0406 75.7092 94.9607 75.6389 94.8936C75.5718 94.8265 75.5016 94.7594 75.4313 94.6924C75.3642 94.6221 75.2779 94.571 75.1981 94.5103C75.1182 94.4496 75.0384 94.3889 74.9457 94.3474C74.8563 94.2994 74.7668 94.2515 74.6742 94.2036C74.5816 94.1653 74.4889 94.1269 74.3931 94.0918C74.3356 94.0726 74.2781 94.0535 74.2206 94.0343C74.1823 93.9768 74.1439 93.9161 74.1088 93.8554C73.8628 93.4433 73.6999 92.9801 73.6009 92.4978C73.4028 91.5299 73.4539 90.498 73.505 89.4599C73.5306 88.9392 73.5625 88.4121 73.5466 87.869C73.5306 87.3292 73.4699 86.7893 73.3485 86.2526C73.2271 85.7192 73.045 85.1889 72.7543 84.7001C72.4668 84.2146 72.0643 83.7737 71.5596 83.4767C71.0613 83.1732 70.4607 83.039 69.8825 83.0582C69.5918 83.071 69.3075 83.1189 69.0296 83.1924C68.9817 83.2083 68.9306 83.2211 68.8827 83.2371C68.723 82.8282 68.6175 82.3937 68.5568 81.9497C68.477 81.3907 68.4514 80.8189 68.4323 80.2407C68.4163 79.6625 68.4099 79.0779 68.3747 78.4869L68.3396 78.0429C68.3236 77.8928 68.3045 77.7394 68.2789 77.5925C68.2278 77.2922 68.1543 76.9983 68.0585 76.7108C67.87 76.1358 67.6081 75.58 67.2503 75.0816C66.8925 74.5865 66.4357 74.1329 65.848 73.8614C65.5573 73.7272 65.241 73.6378 64.9152 73.6186C64.8353 73.6122 64.7523 73.609 64.6724 73.6154C64.6309 73.6186 64.5925 73.6154 64.551 73.6186L64.3657 73.6378C64.2954 73.6505 64.206 73.6314 64.1868 73.7208L64.1645 73.7592C63.7843 73.6953 63.4106 73.6505 62.8931 73.6314C62.7813 73.6282 62.6152 73.6218 62.4107 73.609C62.3085 73.6026 62.1935 73.5962 62.0753 73.5899H62.0625L61.676 73.5611C61.5195 73.5515 61.363 73.5387 61.2064 73.5228C60.5771 73.4717 59.9478 73.395 59.3185 73.3119C59.1045 73.2832 58.8936 73.2512 58.6796 73.2161L58.7531 73.2129C58.801 73.2097 58.8489 73.1969 58.8936 73.1905L59.0342 73.1618L59.1524 73.1299C59.7913 72.9637 60.427 72.7912 61.0723 72.6315C61.7175 72.4782 62.3596 72.3089 63.0113 72.1651C63.3371 72.0917 63.663 72.015 63.9888 71.9415C64.3146 71.8712 64.6436 71.8042 64.9727 71.7339C65.6275 71.5901 66.292 71.4751 66.9564 71.3473C68.2853 71.1142 69.6302 70.9129 70.991 70.7564C73.7095 70.4433 76.4823 70.3283 79.2934 70.2165C82.1045 70.1047 84.9443 69.9833 87.8098 69.9865C90.6752 69.9897 93.5693 70.1111 96.4443 70.5647C97.8818 70.7883 99.3161 71.0758 100.738 71.4496C101.095 71.539 101.447 71.6444 101.801 71.7403C102.156 71.8361 102.511 71.9447 102.862 72.0533C103.213 72.1619 103.578 72.2641 103.907 72.3855C104.242 72.5133 104.568 72.6635 104.887 72.836C105.491 73.1618 106.06 73.5515 106.619 73.97C106.845 74.2255 107.079 74.4715 107.315 74.7111C107.852 75.251 108.414 75.7557 108.986 76.2412L109.203 76.4233C109.273 76.484 109.347 76.5447 109.427 76.6022C109.506 76.6597 109.583 76.7236 109.663 76.7779L109.912 76.9376C110.251 77.1357 110.605 77.3114 110.982 77.4264C111.727 77.6692 112.535 77.7458 113.317 77.5829C113.33 77.5797 113.346 77.5765 113.359 77.5733C113.499 77.5829 113.637 77.5893 113.781 77.5893C114.177 77.5893 114.592 77.5446 114.991 77.4072C115.189 77.3369 115.384 77.2443 115.56 77.1197C115.646 77.059 115.723 76.9983 115.806 76.9376C115.883 76.8705 115.962 76.8066 116.036 76.7396C116.333 76.468 116.595 76.1582 116.815 75.8228C117.259 75.1583 117.563 74.4108 117.754 73.6473C117.949 72.8839 118.042 72.1012 118.071 71.3186C118.154 68.2615 117.994 65.1725 117.681 62.0771ZM76.888 106.141C76.888 106.081 76.8816 106.02 76.8784 105.959C76.9423 106.196 76.9838 106.451 76.9902 106.719C77.0029 107.017 76.9646 107.33 76.8975 107.643C76.8784 107.726 76.8592 107.812 76.8336 107.895C76.9039 107.31 76.9263 106.723 76.888 106.141ZM90.7678 4.0436C90.9275 3.69221 91.1096 3.35679 91.3364 3.05013C91.7836 2.43679 92.3555 1.89374 93.0167 1.53596C93.6748 1.17499 94.435 0.999293 95.1474 1.15582C95.8661 1.31235 96.5178 1.74999 97.1056 2.25791C97.4027 2.51027 97.6838 2.79138 97.9617 3.07249C98.0991 3.21624 98.246 3.34721 98.3738 3.49735L98.7699 3.93818C99.8209 5.12332 100.747 6.42346 101.597 7.76832C103.293 10.4644 104.699 13.3426 105.951 16.2751C107.197 19.214 108.286 22.2136 109.267 25.2419C110.244 28.2735 111.11 31.3337 111.867 34.41C112.247 35.9497 112.583 37.4926 112.924 39.0419C113.266 40.588 113.605 42.131 113.947 43.6707C115.065 48.7978 116.106 53.9153 116.78 59.036C116.525 57.6496 116.199 56.2855 115.825 54.9439C115.448 53.5862 115.03 52.251 114.598 50.9285C114.448 50.4717 114.301 50.018 114.154 49.5644C114.068 49.2162 113.985 48.8712 113.902 48.5358C113.765 48.0055 113.653 47.5743 113.599 47.3571C113.423 46.6926 113.247 46.2837 112.995 45.811C111.564 40.9746 110.327 36.1989 108.899 31.6117C108.519 30.369 108.114 29.1455 107.695 27.9349C107.27 26.7242 106.829 25.539 106.389 24.3603C105.507 22.006 104.593 19.7028 103.593 17.4858C102.594 15.2689 101.511 13.1286 100.211 11.1576C100.041 10.9149 99.8752 10.6721 99.7091 10.4325C99.5398 10.1929 99.3577 9.95652 99.1564 9.72971C98.9552 9.5061 98.7348 9.28568 98.4792 9.1036C98.2236 8.91832 97.9298 8.77457 97.6103 8.6979C97.2909 8.62124 96.9523 8.62763 96.6424 8.7011C96.3293 8.77457 96.0386 8.90874 95.7799 9.07804C95.2624 9.41985 94.8599 9.9054 94.6043 10.4548C94.3488 10.9979 94.221 11.5761 94.1603 12.1447C94.0996 12.7133 94.0996 13.2787 94.1124 13.8282C94.1379 14.3776 94.1507 14.9271 94.1954 15.4669C94.2178 15.7385 94.2306 16.01 94.2561 16.2783C94.2817 16.5467 94.3073 16.815 94.3328 17.0801C94.3775 17.5305 94.4318 17.9746 94.4861 18.4186C94.0421 16.6137 93.5661 14.6747 93.055 12.6015C92.5343 10.4804 91.9753 8.21554 91.3843 5.80374C91.3077 5.49388 91.231 5.18402 91.1543 4.87096C91.0777 4.56749 91.0042 4.25443 90.9275 3.95415C90.8509 4.03402 90.7742 4.11707 90.7007 4.19693C90.7231 4.14902 90.7454 4.09471 90.7678 4.0436ZM103.079 53.27C103.073 53.2572 103.066 53.2412 103.057 53.2285C103.06 53.139 103.066 53.0464 103.07 52.9569C103.156 52.2158 103.558 51.561 104.034 50.9987C104.507 50.4301 105.047 49.9254 105.536 49.3951C105.612 49.3121 105.689 49.229 105.763 49.1428C105.817 49.1428 105.868 49.1396 105.922 49.1364C106.229 49.1172 106.545 49.0597 106.858 48.9192L106.973 48.8617L107.05 48.8265C107.123 48.7946 107.194 48.7658 107.27 48.7211C107.309 48.7019 107.347 48.6828 107.382 48.6604L107.491 48.5869C107.564 48.539 107.628 48.4815 107.692 48.4208C107.948 48.178 108.136 47.8746 108.251 47.5583C108.28 47.4785 108.312 47.3986 108.344 47.3187C108.366 47.2389 108.385 47.1558 108.404 47.076C108.424 46.9929 108.446 46.913 108.465 46.83C108.484 46.7469 108.491 46.6639 108.503 46.5808C108.692 45.2519 108.523 43.8783 108.283 42.4664C108.213 42.115 108.142 41.7604 108.069 41.4026C108.037 41.2237 107.992 41.0448 107.948 40.866C107.903 40.6871 107.861 40.505 107.817 40.3229C107.654 39.601 107.443 38.8439 107.143 38.1092C106.839 37.3744 106.456 36.6493 105.925 35.9912C105.66 35.6654 105.357 35.3587 105.005 35.0936C104.654 34.8348 104.255 34.6112 103.811 34.493C103.37 34.3653 102.894 34.3461 102.437 34.426C102.207 34.4675 101.984 34.5282 101.769 34.6144C101.552 34.6943 101.357 34.7933 101.166 34.87C100.977 34.9467 100.795 35.0074 100.626 35.0105C100.457 35.0169 100.3 34.9722 100.15 34.8828C99.8464 34.6975 99.6036 34.3397 99.3928 33.966C98.5367 32.4167 97.8723 30.6853 97.2909 28.874C96.7127 27.0596 96.2303 25.1525 95.8246 23.1751C95.4221 21.1978 95.0835 19.1469 94.8727 17.0322C94.8471 16.7671 94.8216 16.5019 94.796 16.2368C94.7705 15.9717 94.7577 15.7033 94.7353 15.435C94.6906 14.8983 94.6778 14.3617 94.6523 13.8186C94.6363 13.2787 94.6395 12.7389 94.697 12.2086C94.7545 11.6783 94.8727 11.1608 95.0931 10.688C95.3103 10.2248 95.6521 9.81277 96.0802 9.53165C96.5018 9.25054 97.0161 9.10999 97.4921 9.22499C97.9713 9.33679 98.3961 9.6786 98.7571 10.0907C98.9392 10.2983 99.1117 10.5187 99.2778 10.7519C99.4407 10.9883 99.6037 11.2247 99.7698 11.4611C101.044 13.3873 102.118 15.5085 103.111 17.7094C104.101 19.9136 105.012 22.204 105.89 24.5519C106.331 25.7275 106.769 26.9158 107.19 28.1137C107.606 29.318 108.008 30.5351 108.388 31.7714C109.925 36.7164 111.244 41.8946 112.832 47.1494C113.087 47.9928 113.356 48.8425 113.63 49.689C113.634 49.705 113.64 49.721 113.643 49.7369C113.739 50.1139 113.825 50.4972 113.915 50.8901C114.1 51.6696 114.269 52.4746 114.445 53.2923C114.784 54.9279 115.078 56.621 115.308 58.2853C115.359 58.7005 115.423 59.1126 115.464 59.5247C115.509 59.9368 115.55 60.3425 115.592 60.745C115.653 61.55 115.726 62.3358 115.748 63.0929C115.793 63.85 115.79 64.5751 115.799 65.2587C115.803 65.6005 115.787 65.9328 115.78 66.2522C115.768 66.5717 115.774 66.8815 115.748 67.1754C115.729 67.4693 115.713 67.7504 115.694 68.0187C115.678 68.2871 115.665 68.5394 115.637 68.7726C115.589 69.2454 115.544 69.6543 115.509 69.9897C115.461 70.3187 115.426 70.5743 115.384 70.7436C115.349 70.9129 115.33 71.0055 115.33 71.0055C115.33 71.0055 115.304 71.0918 115.256 71.2579C115.244 71.2994 115.234 71.3474 115.215 71.3953C115.196 71.4432 115.177 71.4975 115.154 71.555C115.116 71.6732 115.052 71.7978 114.985 71.9383C114.841 72.2098 114.621 72.5133 114.26 72.673C114.17 72.7146 114.068 72.7433 113.959 72.7689C113.899 72.7817 113.838 72.7944 113.774 72.804C113.742 72.8104 113.704 72.8168 113.666 72.8264L113.583 72.8455C113.423 72.8775 113.177 72.804 112.915 72.6858C112.391 72.4718 111.858 72.1523 111.353 71.7211C110.845 71.2962 110.382 70.7564 109.96 70.143C109.535 69.5329 109.161 68.8493 108.82 68.1242C108.478 67.399 108.168 66.6324 107.877 65.8465C107.293 64.2749 106.785 62.6265 106.187 61.0485C106.04 60.6523 105.878 60.2626 105.718 59.8825C105.558 59.5055 105.402 59.1318 105.251 58.7612C104.951 58.0201 104.67 57.2918 104.405 56.5954C104.082 55.7521 103.785 54.9854 103.539 54.3401C103.463 54.1453 103.402 53.9887 103.36 53.8865C103.264 53.6533 103.175 53.4521 103.082 53.27C103.185 53.2604 103.22 53.254 103.079 53.27ZM97.7828 31.8225C98.1246 32.653 98.4984 33.458 98.9232 34.2279C99.0382 34.4292 99.1628 34.6304 99.313 34.8221C99.4631 35.0137 99.642 35.1958 99.8688 35.3364C100.096 35.4769 100.377 35.5568 100.648 35.544C100.92 35.5312 101.156 35.4482 101.37 35.3619C101.584 35.2757 101.776 35.1767 101.961 35.1096C102.146 35.0361 102.338 34.985 102.53 34.9498C102.913 34.886 103.303 34.9019 103.67 35.0074C104.038 35.1064 104.379 35.2949 104.689 35.5217C104.996 35.7549 105.271 36.0296 105.513 36.3267C105.999 36.9272 106.363 37.614 106.651 38.3104C106.938 39.01 107.136 39.7224 107.302 40.4475C107.347 40.6264 107.389 40.8053 107.43 40.981C107.475 41.1567 107.516 41.3355 107.548 41.5112C107.618 41.8626 107.689 42.214 107.759 42.5558C107.813 42.9008 107.864 43.2426 107.916 43.5812C107.96 43.9198 107.986 44.2553 108.021 44.5843C108.034 44.7504 108.034 44.9133 108.04 45.0762C108.043 45.1561 108.047 45.2392 108.05 45.319C108.053 45.3989 108.056 45.4819 108.05 45.5586C108.043 45.7183 108.037 45.8748 108.031 46.0314C108.031 46.1112 108.021 46.1879 108.008 46.2646C107.999 46.3412 107.989 46.4179 107.976 46.4914C107.964 46.568 107.96 46.6447 107.944 46.7182C107.925 46.7917 107.909 46.8619 107.89 46.9354C107.871 47.0057 107.855 47.0792 107.836 47.1494C107.81 47.2165 107.785 47.2836 107.759 47.3475C107.663 47.6158 107.513 47.8426 107.331 48.0183C107.286 48.063 107.242 48.1078 107.187 48.1397L107.111 48.194C107.085 48.21 107.053 48.2228 107.028 48.2387C106.973 48.2707 106.909 48.2962 106.845 48.325L106.721 48.3825L106.638 48.424C106.516 48.4783 106.385 48.5167 106.248 48.5454C106.347 48.408 106.44 48.2611 106.532 48.1205C106.615 47.964 106.699 47.8075 106.775 47.651C107.059 47.0153 107.2 46.3572 107.254 45.7279C107.312 45.0986 107.283 44.4948 107.213 43.923C107.143 43.3512 107.034 42.8146 106.903 42.3067C106.769 41.7987 106.615 41.3228 106.456 40.8724C106.293 40.4283 106.133 40.0035 105.967 39.6042C105.635 38.8055 105.29 38.0932 104.903 37.483C104.712 37.1764 104.507 36.8985 104.277 36.6525C104.223 36.5886 104.162 36.5311 104.101 36.4768L104.012 36.3937C103.983 36.365 103.926 36.3267 103.884 36.2979C103.693 36.1861 103.504 36.1637 103.338 36.1605C103.006 36.1605 102.728 36.234 102.479 36.3171C102.229 36.4033 102.006 36.5023 101.805 36.6078C101.402 36.8186 101.083 37.0454 100.824 37.2722C100.568 37.499 100.37 37.7258 100.239 37.959C100.105 38.1858 100.051 38.4542 100.099 38.6714L100.105 38.7097L100.112 38.7353C100.115 38.7512 100.121 38.7672 100.124 38.7832C100.134 38.8151 100.14 38.8439 100.147 38.8694C100.163 38.9237 100.172 38.9685 100.185 39.01C100.227 39.1665 100.239 39.2176 100.239 39.2176C100.239 39.2176 100.332 39.5658 100.514 40.243C100.693 40.9203 100.958 41.9265 101.278 43.2458C101.437 43.9071 101.61 44.645 101.782 45.4628C101.869 45.8717 101.955 46.2997 102.035 46.7469C102.054 46.8587 102.073 46.9705 102.095 47.0855C102.124 47.2229 102.162 47.3667 102.229 47.4944C102.354 47.7532 102.543 47.964 102.75 48.1429C103.169 48.5007 103.67 48.7371 104.204 48.9032C104.485 48.9894 104.775 49.0533 105.079 49.0948C104.622 49.5836 104.111 50.066 103.629 50.6442C103.376 50.9476 103.13 51.2735 102.935 51.6504C102.872 51.7718 102.814 51.8996 102.76 52.0305C102.683 51.7207 102.606 51.4076 102.527 51.0882C102.316 50.2353 102.102 49.3568 101.875 48.4464C100.98 44.8047 99.9678 40.6935 98.8274 36.0519C98.5878 35.0904 98.2428 33.6849 97.7828 31.8225ZM106.066 47.8554C105.977 47.9864 105.897 48.1237 105.801 48.2547C105.711 48.3729 105.619 48.4911 105.52 48.6061C105.12 48.5901 104.724 48.5135 104.357 48.4017C103.878 48.2547 103.431 48.0343 103.095 47.7468C102.929 47.603 102.788 47.4401 102.705 47.2708C102.661 47.1846 102.638 47.0983 102.619 47.0089C102.6 46.8939 102.578 46.7789 102.559 46.6639C102.479 46.2103 102.389 45.7758 102.303 45.3637C102.13 44.5396 101.955 43.7953 101.795 43.134C101.472 41.8083 101.207 40.7989 101.028 40.1185C100.846 39.4412 100.754 39.0899 100.754 39.0899C100.754 39.0899 100.741 39.0419 100.699 38.8822C100.69 38.8439 100.677 38.796 100.661 38.7417C100.655 38.7161 100.645 38.6874 100.639 38.6554C100.635 38.6394 100.629 38.6235 100.626 38.6075L100.619 38.5851V38.5723C100.607 38.5053 100.61 38.3903 100.706 38.2305C100.881 37.9111 101.329 37.4767 102.051 37.0965C102.233 37.0007 102.431 36.9112 102.648 36.8378C102.862 36.7643 103.102 36.7068 103.325 36.7068C103.437 36.7068 103.542 36.7292 103.606 36.7675C103.613 36.7739 103.619 36.7803 103.629 36.7835C103.635 36.7899 103.641 36.7898 103.657 36.8058L103.731 36.8761C103.782 36.924 103.833 36.9719 103.881 37.0262C104.079 37.2371 104.268 37.4926 104.446 37.7801C104.811 38.3487 105.143 39.0355 105.469 39.8182C105.632 40.2079 105.791 40.6232 105.951 41.064C106.108 41.5017 106.254 41.9617 106.382 42.4472C106.507 42.936 106.612 43.4503 106.676 43.9933C106.743 44.5332 106.769 45.105 106.714 45.6864C106.663 46.2678 106.532 46.8651 106.28 47.4337C106.213 47.5775 106.143 47.7149 106.066 47.8554ZM60.8167 76.5223C60.7177 76.6118 60.6218 76.7012 60.5196 76.7843C60.1171 77.1261 59.6923 77.4392 59.2482 77.7203C58.3602 78.2825 57.4114 78.7393 56.4211 79.0587C55.926 79.2185 55.4245 79.3462 54.9166 79.4421C54.8303 79.458 54.6961 79.4804 54.661 79.4868C54.661 79.4868 54.661 79.4868 54.6578 79.4836L54.6003 79.4389L54.5492 79.3878L54.5045 79.3335C54.3959 79.1897 54.3639 78.9916 54.3927 78.7744C54.4214 78.5604 54.5045 78.3336 54.6163 78.1228C54.7249 77.9087 54.8623 77.7043 55.0156 77.5158C55.1689 77.3242 55.3382 77.1453 55.5203 76.9887C55.7024 76.8322 55.9036 76.6917 56.1177 76.5607C56.3125 76.4393 56.5138 76.3275 56.7214 76.2221C57.3348 76.0176 57.9513 75.8164 58.5614 75.6183L58.9511 75.4905L59.146 75.4267C59.2099 75.4075 59.2642 75.3915 59.3249 75.3755C59.5645 75.3148 59.82 75.2861 60.0692 75.2893C60.3056 75.2925 60.542 75.3212 60.7496 75.3915C60.8007 75.4139 60.8486 75.4362 60.887 75.465C61.0371 75.564 61.117 75.7046 61.1457 75.9026C61.1553 75.9729 61.1553 76.0528 61.1521 76.1294C61.1298 76.1805 61.101 76.2285 61.0659 76.2764C61.0339 76.3179 61.002 76.3562 60.9604 76.3914L60.8167 76.5223ZM70.8664 122.404C70.5374 122.672 70.1828 122.918 69.8186 123.164C69.4545 123.41 69.0871 123.66 68.7198 123.906C67.985 124.401 67.2439 124.899 66.5028 125.401C66.2984 125.538 66.0907 125.678 65.8863 125.816C65.6818 125.902 65.4774 125.985 65.2698 126.068C65.0046 126.174 64.7395 126.269 64.468 126.362C64.1996 126.455 63.9281 126.547 63.6629 126.618C63.1327 126.758 62.5864 126.816 62.1264 126.614C62.0881 126.598 62.0529 126.579 62.0178 126.56C62.0114 126.557 62.005 126.554 62.0018 126.547C61.6824 126.305 61.3981 125.969 61.0946 125.637C60.9477 125.477 60.7911 125.314 60.6218 125.161C59.277 123.433 57.9513 121.641 56.6639 119.778C53.8943 115.782 51.2877 111.479 48.9014 106.876C48.7513 106.588 48.6043 106.301 48.4542 106.01C48.3104 105.72 48.1635 105.429 48.0166 105.135C47.7227 104.554 47.4384 103.963 47.1541 103.368C46.8666 102.777 46.595 102.174 46.3171 101.573C46.036 100.973 45.7773 100.369 45.5473 99.7492C45.0936 98.5129 44.7423 97.216 44.7295 95.9031C44.7263 95.2514 44.8125 94.5965 45.0361 93.9928C45.2598 93.389 45.6271 92.8428 46.0999 92.3955C46.6653 91.8589 47.3936 91.434 48.0357 90.8143C48.1923 90.661 48.352 90.4885 48.4861 90.3C48.6171 90.1115 48.7321 89.9071 48.828 89.693C48.9206 89.479 48.9877 89.249 49.0292 89.0126C49.0675 88.7762 49.0771 88.5271 49.0292 88.2779C49.0196 88.214 49.0005 88.1533 48.9845 88.0926C48.9749 88.0607 48.9685 88.0319 48.9557 88L48.9366 87.9553C48.9366 87.9521 48.9334 87.9489 48.9334 87.9489C48.9366 87.9489 48.943 87.9489 48.9557 87.9489C49.4125 87.9744 49.8757 87.9553 50.3325 87.8882C51.2493 87.754 52.1374 87.441 52.9711 87.0193C53.8049 86.5944 54.5843 86.061 55.3223 85.4668C56.0602 84.8726 56.7566 84.2242 57.4274 83.5373C57.6829 83.2786 57.9321 83.0135 58.1813 82.7483C57.8427 83.1668 57.5009 83.5789 57.1559 83.9878C56.4116 84.8503 55.6481 85.6904 54.8591 86.505L54.2585 87.1055C54.0605 87.3068 53.8528 87.4985 53.6484 87.6933C53.4471 87.8914 53.2363 88.0798 53.0286 88.2683L52.706 88.5622C52.6453 88.6005 52.6102 88.6868 52.5942 88.7219L52.5463 88.8178L52.4505 89.0094C52.1981 89.5269 51.9649 90.054 51.7796 90.6099C51.687 90.8878 51.6103 91.1753 51.5624 91.4755C51.5145 91.7726 51.5017 92.0921 51.572 92.4179C51.6103 92.5808 51.6742 92.7405 51.7605 92.8875C51.8467 93.0344 51.9585 93.1622 52.0799 93.274C52.3227 93.4912 52.5878 93.635 52.8338 93.7756L53.2043 93.9832C53.3864 94.0854 53.5749 94.0982 53.7442 94.1014C54.0828 94.0886 54.3767 93.9928 54.6546 93.8842C55.0156 93.7372 55.351 93.5519 55.6704 93.3507C55.8302 93.2708 55.9867 93.191 56.1464 93.1111C56.6352 92.8779 57.1016 92.5968 57.5743 92.3349C57.8139 92.2071 58.0343 92.0537 58.2643 91.91C58.4911 91.7631 58.7243 91.6257 58.9448 91.4755C59.7849 90.9069 60.5899 90.2904 61.3598 89.6387C61.2064 89.7793 61.0499 89.9199 60.8966 90.0604C59.2674 91.5362 57.6159 93.0089 55.9324 94.4656C55.0891 95.1939 54.2425 95.9158 53.3705 96.6154C52.4984 97.3022 51.5688 98.0657 50.997 99.1294C50.8532 99.3946 50.7414 99.6789 50.6616 99.9728C50.62 100.12 50.5945 100.27 50.5721 100.423L50.553 100.66C50.5466 100.739 50.5561 100.816 50.5561 100.896C50.5913 101.525 50.8436 102.119 51.2366 102.605C51.4378 102.845 51.6838 103.055 51.9681 103.209C52.2492 103.362 52.5814 103.461 52.9168 103.448C52.9999 103.455 53.0861 103.432 53.1692 103.426C53.2107 103.42 53.2554 103.416 53.2938 103.407L53.4056 103.375C53.4184 103.372 53.4311 103.365 53.4439 103.362C53.6292 103.458 53.8177 103.544 54.0157 103.621C54.1595 103.675 54.3096 103.723 54.4693 103.758C54.6291 103.793 54.7984 103.812 54.9645 103.803C55.2584 103.793 55.5363 103.72 55.7918 103.618C55.6385 103.72 55.4852 103.828 55.335 103.937C55.1945 104.042 55.0507 104.148 54.907 104.257C54.7664 104.365 54.6163 104.467 54.4821 104.586C54.3448 104.701 54.2074 104.819 54.0668 104.934L53.8592 105.109C53.8305 105.135 53.8017 105.161 53.7761 105.186C53.7698 105.189 53.7634 105.196 53.757 105.199C53.3992 105.464 53.0606 105.777 52.7923 106.17C52.7763 106.192 52.7635 106.218 52.7475 106.243C52.6677 106.352 52.591 106.467 52.5271 106.595C52.4313 106.787 52.3674 107.01 52.361 107.234C52.3482 107.687 52.5239 108.103 52.7667 108.435C53.0095 108.773 53.3289 109.048 53.6835 109.259C54.3959 109.677 55.2552 109.834 56.0857 109.697H56.0889C56.4563 109.709 56.8236 109.697 57.1878 109.662C58.1078 109.575 59.0118 109.371 59.8999 109.099C60.1267 109.029 60.3535 108.956 60.5771 108.879C60.5675 108.885 60.5579 108.892 60.5484 108.901C60.2066 109.157 59.8871 109.432 59.59 109.732C59.4431 109.882 59.2993 110.038 59.1652 110.208C59.0981 110.294 59.0342 110.38 58.9735 110.479L58.9288 110.553L58.8873 110.633L58.8457 110.716L58.817 110.802L58.7627 110.974C58.7499 111.035 58.7435 111.096 58.7371 111.157L58.7243 111.246L58.7275 111.339C58.7307 111.399 58.7307 111.46 58.7371 111.521C58.7786 111.76 58.8649 111.987 58.9927 112.179C59.2354 112.552 59.5868 112.818 59.967 112.993L59.9702 112.997C60.0404 113.054 60.1139 113.096 60.1874 113.147C60.4845 113.329 60.7975 113.46 61.1106 113.549C61.2671 113.6 61.4268 113.629 61.5834 113.667C61.7399 113.699 61.8964 113.722 62.053 113.747C62.6791 113.83 63.2892 113.843 63.8866 113.827C65.0813 113.795 66.2153 113.645 67.295 113.46C68.1224 113.319 68.9146 113.15 69.6781 112.968C69.4896 113.316 69.4098 113.702 69.4034 114.083C69.397 114.511 69.4768 114.936 69.6334 115.338C69.7132 115.539 69.8091 115.734 69.9305 115.916C69.9911 116.009 70.055 116.098 70.1189 116.178C70.1828 116.261 70.2467 116.344 70.3106 116.421C70.8313 117.063 71.4127 117.644 71.8535 118.312C72.0707 118.644 72.2496 118.996 72.3359 119.369C72.4221 119.74 72.4253 120.13 72.3167 120.497C72.2113 120.868 72.0132 121.216 71.7577 121.532C71.5021 121.852 71.1954 122.139 70.8664 122.404ZM52.7571 91.7055C52.7635 91.4755 52.8338 91.2392 52.9296 91.0124C53.0286 90.7856 53.1564 90.5619 53.3066 90.3543C53.6068 89.9326 53.9774 89.5493 54.3767 89.1947C54.776 88.8433 55.2073 88.5207 55.6577 88.2332C55.7695 88.1629 55.8845 88.0926 55.9995 88.0287C56.0282 88.0128 56.057 87.9968 56.0857 87.9808C56.0985 87.9744 56.1049 87.9712 56.1049 87.9712L56.1975 87.9872C56.4531 88.0383 56.7023 88.1118 56.9386 88.2076C57.4146 88.4025 57.8459 88.6964 58.1302 89.0989C58.1653 89.1468 58.2005 89.1979 58.2292 89.2522C58.2611 89.3033 58.2899 89.3576 58.3123 89.4151C58.3378 89.4694 58.3634 89.5269 58.3793 89.5844L58.4017 89.6515C58.4017 89.6579 58.4017 89.6419 58.3985 89.6707C58.4017 89.7154 58.3793 89.7729 58.3698 89.824C58.3474 89.8783 58.3346 89.9326 58.3091 89.9901C58.2611 90.1019 58.2005 90.2137 58.1302 90.3224C57.8555 90.7632 57.4849 91.1689 57.0984 91.5458C56.7086 91.9228 56.287 92.2742 55.843 92.5936C55.7024 92.6926 55.5586 92.7917 55.4117 92.8843C55.335 92.9226 55.2552 92.961 55.1785 92.9993C54.9357 93.1079 54.6898 93.2165 54.447 93.3251L54.1786 93.4433C54.1467 93.4274 54.0253 93.3699 53.9454 93.3315C53.8368 93.2644 53.725 93.2069 53.6196 93.1367C53.5206 93.0632 53.412 92.9961 53.3257 92.913C52.9584 92.5936 52.7348 92.1655 52.7571 91.7055ZM51.671 101.113C51.5432 100.893 51.457 100.653 51.4761 100.449C51.4793 100.398 51.4921 100.35 51.5049 100.302C51.5273 100.247 51.5464 100.193 51.5752 100.139C51.6327 100.027 51.703 99.9185 51.7828 99.8099C52.1023 99.3818 52.5207 99.0017 52.968 98.679C53.4184 98.3596 53.9071 98.0944 54.4214 97.9315C54.9357 97.7686 55.4756 97.7079 55.9803 97.8165C56.2327 97.8708 56.4691 97.9698 56.6895 98.104L56.8141 98.1903C56.8141 98.1903 56.8141 98.1903 56.8173 98.1935L56.8556 98.2797C56.8779 98.3372 56.8939 98.3979 56.9163 98.4586C56.9323 98.5193 56.945 98.58 56.9578 98.6407C57.0473 99.1358 56.9291 99.6629 56.6895 100.132C56.4499 100.605 56.1049 101.037 55.7056 101.407C55.3063 101.781 54.8591 102.107 54.3799 102.369C54.1403 102.5 53.8943 102.618 53.642 102.717C53.5973 102.736 53.5493 102.752 53.5046 102.768C53.2554 102.624 53.0127 102.461 52.7827 102.286C52.345 101.957 51.9361 101.56 51.671 101.113ZM52.69 102.899C52.3003 102.835 51.933 102.589 51.6614 102.266C51.4474 102.001 51.2845 101.688 51.1886 101.359C51.195 101.369 51.1982 101.378 51.2046 101.388C51.5336 101.937 51.9777 102.353 52.4505 102.726C52.5271 102.784 52.607 102.841 52.69 102.899ZM56.255 104.755C56.4403 104.742 56.6224 104.748 56.7725 104.793L56.8779 104.835L56.993 104.902C57.0313 104.924 57.0728 104.943 57.1079 104.972L57.2134 105.055C57.4913 105.282 57.7021 105.589 57.8331 105.93C58.0982 106.614 58.0535 107.422 57.7085 108.039C57.5392 108.345 57.2868 108.601 56.9898 108.793C56.7086 108.975 56.386 109.093 56.0538 109.154C55.5555 109.131 55.0667 109.058 54.5971 108.927C54.4949 108.904 54.3959 108.866 54.2968 108.831C54.1978 108.796 54.0988 108.761 54.0029 108.722L53.7218 108.588L53.6036 108.531L53.5174 108.451C53.4823 108.416 53.4439 108.384 53.4088 108.349L53.3129 108.24C53.2427 108.17 53.2011 108.087 53.1436 108.01C53.0542 107.847 52.9743 107.681 52.9584 107.505C52.9392 107.33 52.9488 107.154 52.9999 106.978C53.0478 106.828 53.1149 106.681 53.2011 106.541C53.2267 106.505 53.2554 106.47 53.2842 106.438C53.3928 106.311 53.5206 106.186 53.6484 106.061C53.7761 105.937 53.9039 105.815 54.0285 105.694C54.0573 105.668 54.086 105.64 54.1148 105.611C54.431 105.387 54.7696 105.199 55.1242 105.049C55.4948 104.902 55.8813 104.784 56.255 104.755ZM59.7849 111.888L59.7913 111.834C59.8009 111.763 59.8009 111.693 59.82 111.623L59.8743 111.415C59.9702 111.141 60.1107 110.875 60.2992 110.636C60.3407 110.572 60.3982 110.521 60.4493 110.46C60.5004 110.403 60.5516 110.345 60.6091 110.294L60.7784 110.134L60.9636 109.987C61.216 109.799 61.4907 109.63 61.7878 109.505C61.9316 109.435 62.0881 109.39 62.2382 109.336C62.3149 109.313 62.3948 109.297 62.4714 109.275C62.5098 109.265 62.5481 109.256 62.5896 109.246L62.7078 109.227C62.7877 109.217 62.8675 109.198 62.9474 109.195L63.187 109.182C63.2668 109.179 63.3467 109.189 63.4266 109.192C63.4649 109.195 63.5064 109.195 63.5448 109.198L63.6502 109.217C63.9345 109.278 64.1932 109.444 64.3689 109.681C64.4552 109.799 64.5223 109.933 64.5606 110.074C64.5957 110.214 64.6053 110.361 64.5861 110.505C64.5702 110.649 64.5095 110.786 64.436 110.914L64.3753 111.006C64.3561 111.038 64.3242 111.067 64.2986 111.096C64.2507 111.157 64.1868 111.211 64.1261 111.268C63.8738 111.492 63.5703 111.68 63.2509 111.85C62.9314 112.019 62.596 112.169 62.251 112.303C61.906 112.434 61.545 112.559 61.1968 112.632C60.887 112.693 60.5516 112.655 60.2417 112.533L60.1299 112.437L59.9957 112.284C59.9478 112.236 59.9223 112.172 59.8807 112.115C59.8392 112.061 59.82 111.993 59.7913 111.933L59.7721 111.891C59.7881 111.891 59.7849 111.885 59.7849 111.888ZM73.3804 114.939C73.735 115.36 74.0066 115.849 74.1727 116.376C74.1759 116.383 74.1759 116.386 74.1759 116.392C74.4697 117.296 74.4634 118.315 74.1024 119.222C73.9203 119.702 73.668 120.155 73.3645 120.58C73.0578 121.005 72.7032 121.401 72.3199 121.772C72.2432 121.848 72.1634 121.919 72.0835 121.992C72.1186 121.954 72.1538 121.915 72.1857 121.874C72.4764 121.516 72.716 121.104 72.847 120.647C72.9811 120.19 72.9811 119.698 72.8725 119.248C72.7639 118.794 72.5531 118.382 72.3135 118.018C71.8279 117.287 71.2338 116.699 70.7386 116.086C70.6173 115.932 70.4895 115.776 70.3936 115.629C70.2946 115.475 70.2116 115.312 70.1477 115.146C70.0167 114.808 69.9464 114.45 69.9528 114.099C69.9592 113.75 70.0423 113.409 70.2116 113.143C70.2978 113.009 70.4032 112.901 70.5278 112.814C70.5598 112.792 70.5885 112.773 70.6236 112.757C70.6524 112.738 70.6843 112.725 70.7163 112.712C70.7866 112.693 70.8536 112.677 70.9239 112.658L70.9335 112.683C70.9559 112.728 70.975 112.773 70.9942 112.814C71.0773 112.981 71.1539 113.112 71.2146 113.201C71.4606 113.575 71.7321 113.811 72.0068 113.98C72.1091 114.044 72.2113 114.095 72.3167 114.143C72.3071 114.15 72.2975 114.156 72.2911 114.162C72.4604 114.223 72.6298 114.284 72.7831 114.392C73.0035 114.543 73.2048 114.728 73.3804 114.939ZM74.8786 111.661C74.7381 111.862 74.5911 112.061 74.4442 112.259L74.2014 112.54C74.1184 112.632 74.0449 112.731 73.9523 112.814L73.6871 113.076L73.553 113.207L73.4092 113.326L73.1217 113.565C73.0738 113.603 73.0259 113.645 72.9748 113.68L72.8055 113.798C72.716 113.859 72.6266 113.923 72.5371 113.984C72.4381 113.878 72.3455 113.776 72.2528 113.674C72.058 113.45 71.8631 113.227 71.6586 112.907C71.6075 112.83 71.5436 112.719 71.4702 112.575C71.4606 112.556 71.451 112.533 71.4414 112.514C72.0292 112.348 72.5978 112.172 73.1409 111.962C73.9746 111.642 74.7477 111.243 75.4057 110.744C75.2524 111.057 75.0767 111.364 74.8786 111.661ZM75.3195 103.943C75.3706 103.975 75.4249 104.007 75.476 104.039C75.4952 104.058 75.5143 104.078 75.5335 104.097C75.7188 104.282 75.9168 104.464 76.1085 104.662L76.1373 104.793C76.1852 105.02 76.2523 105.244 76.2746 105.477C76.3066 105.71 76.3481 105.94 76.3513 106.176C76.4248 107.304 76.2682 108.467 75.8977 109.569C75.6805 109.815 75.4345 110.045 75.1598 110.259C74.5368 110.744 73.7861 111.134 72.9556 111.457C72.3391 111.693 71.6746 111.894 70.9782 112.086C70.9367 112.092 70.892 112.099 70.8504 112.105L70.745 112.131C70.7195 112.137 70.6939 112.147 70.6684 112.153C70.6173 112.169 70.563 112.185 70.515 112.211C70.515 112.211 70.515 112.211 70.5118 112.211C70.4256 112.233 70.3361 112.259 70.2467 112.281C69.2852 112.524 68.2725 112.751 67.2088 112.933C66.1482 113.115 65.0334 113.258 63.877 113.29C63.2988 113.306 62.7142 113.29 62.1296 113.214C61.9859 113.191 61.8389 113.169 61.6952 113.14C61.6441 113.127 61.5929 113.118 61.5386 113.105C61.8581 113.022 62.1552 112.917 62.4554 112.805C62.8196 112.664 63.1742 112.508 63.516 112.326C63.8578 112.144 64.19 111.939 64.4935 111.671C64.567 111.601 64.6437 111.537 64.7107 111.454C64.7459 111.412 64.781 111.377 64.8129 111.332L64.9056 111.195C65.0174 111.006 65.1005 110.802 65.1292 110.582C65.158 110.364 65.1452 110.144 65.0909 109.933C65.0334 109.725 64.9343 109.531 64.8098 109.361C64.5574 109.019 64.1805 108.78 63.7716 108.694L63.6182 108.665C63.5671 108.658 63.5224 108.658 63.4745 108.655C63.3786 108.652 63.2828 108.639 63.187 108.642L62.9027 108.655C62.8068 108.658 62.7174 108.681 62.6248 108.694L62.4874 108.716C62.4427 108.726 62.398 108.738 62.3532 108.748C62.2638 108.77 62.1743 108.789 62.0849 108.818C61.9124 108.879 61.7367 108.933 61.5706 109.01C61.2352 109.15 60.9253 109.342 60.6378 109.556L60.427 109.722L60.2321 109.904C60.165 109.962 60.1043 110.029 60.0468 110.099C59.9893 110.166 59.9254 110.23 59.8743 110.304C59.6539 110.585 59.4814 110.907 59.3632 111.249L59.2929 111.511C59.2929 111.517 59.293 111.521 59.2898 111.527C59.2834 111.502 59.277 111.473 59.2706 111.447C59.2674 111.409 59.2674 111.371 59.2642 111.332L59.261 111.275L59.2706 111.217C59.277 111.179 59.2802 111.141 59.2866 111.102L59.3249 110.99C59.3728 110.843 59.475 110.7 59.59 110.55C59.7082 110.403 59.8392 110.259 59.9766 110.118C60.2513 109.84 60.5548 109.578 60.871 109.342C61.0307 109.227 61.1936 109.115 61.3598 109.023C61.4428 108.978 61.5227 108.936 61.6089 108.908L61.8964 108.789C62.2829 108.633 62.6727 108.473 63.0624 108.313C64.6277 107.675 66.2313 107.017 67.8764 106.346C69.5216 105.675 71.2018 104.985 72.9236 104.282C73.3549 104.106 73.7861 103.931 74.2206 103.752L74.3835 103.685L74.4666 103.653C74.4857 103.646 74.4825 103.656 74.4921 103.65C74.54 103.65 74.6359 103.656 74.7317 103.688C74.9266 103.736 75.131 103.835 75.3195 103.943ZM74.7189 103.039C74.7317 103.068 74.7477 103.1 74.7636 103.129L74.6806 103.113L74.6263 103.103L74.5656 103.1L74.5017 103.097C74.4825 103.097 74.4602 103.097 74.4314 103.1C74.3835 103.107 74.3196 103.119 74.2813 103.132L74.1982 103.164L74.0353 103.231C73.6009 103.41 73.1664 103.586 72.7384 103.761C71.0166 104.464 69.3331 105.154 67.6911 105.825C66.7616 106.205 65.8479 106.579 64.9439 106.949C64.9854 106.927 65.027 106.908 65.0717 106.886C66.7552 106.01 68.4099 105.036 70.087 104.055C70.5054 103.812 70.9271 103.567 71.3488 103.324C71.7705 103.078 72.1985 102.848 72.6298 102.583C73.4795 102.059 74.2972 101.458 75.0032 100.711C74.9904 100.733 74.9745 100.765 74.9521 100.807C74.9074 100.89 74.8403 101.021 74.7605 101.203C74.6838 101.385 74.5911 101.624 74.5496 101.941C74.5081 102.26 74.5336 102.659 74.7189 103.039ZM73.8948 94.523C74.128 94.8425 74.3899 95.1268 74.6391 95.4015C74.9809 95.7785 75.3099 96.1458 75.5335 96.5579C75.7571 96.9636 75.8689 97.4236 75.8561 97.8772C75.8402 98.334 75.6932 98.7812 75.4728 99.1965C75.2492 99.6118 74.9521 99.9919 74.6231 100.343C73.9618 101.043 73.1728 101.627 72.3486 102.135C71.9398 102.388 71.5053 102.621 71.0804 102.867C70.6556 103.113 70.2339 103.359 69.8154 103.602C68.1384 104.582 66.4868 105.55 64.8225 106.419C63.1582 107.285 61.4748 108.064 59.7529 108.591C59.0118 108.818 58.2611 108.994 57.5105 109.09C57.7788 108.876 58.0152 108.614 58.1845 108.307C58.6125 107.528 58.6605 106.579 58.341 105.742C58.1813 105.327 57.9193 104.934 57.5552 104.64L57.4178 104.531C57.3699 104.496 57.3188 104.471 57.2677 104.439L57.1143 104.352C57.0568 104.327 56.993 104.301 56.9291 104.279C56.6799 104.205 56.4435 104.202 56.2135 104.218C56.073 104.228 55.9324 104.25 55.7982 104.279C56.8748 103.522 57.996 102.889 59.0949 102.298C60.2449 101.685 61.3789 101.113 62.4554 100.529C63.532 99.9408 64.5542 99.3371 65.4934 98.6822C65.7234 98.5129 65.9502 98.3436 66.1738 98.1743L66.3399 98.0497L66.4996 97.9156C66.605 97.8261 66.7105 97.7367 66.8159 97.6504C66.9213 97.561 67.0267 97.4747 67.1289 97.3853C67.2279 97.299 67.327 97.2096 67.426 97.1233C67.6241 96.9508 67.8221 96.7879 68.0202 96.6282C68.8124 95.9893 69.6174 95.4462 70.4288 95.0501C70.8345 94.8521 71.2434 94.6924 71.6491 94.5805C72.0547 94.4719 72.4573 94.408 72.847 94.3985C73.2143 94.3921 73.5657 94.4368 73.8948 94.523ZM73.5146 93.9001C73.2942 93.8714 73.0706 93.8554 72.8406 93.8586C72.3998 93.8682 71.9525 93.9385 71.5085 94.0599C71.0645 94.1844 70.6268 94.3537 70.1956 94.5646C69.3331 94.9862 68.4993 95.5517 67.6848 96.2065C67.4803 96.3694 67.2791 96.5387 67.0778 96.7144C66.9788 96.8039 66.8766 96.8901 66.7743 96.9796C66.6753 97.0626 66.5731 97.1489 66.4709 97.2351C66.3686 97.3214 66.2664 97.4076 66.1642 97.4939L66.0109 97.6249L65.848 97.7462C65.6307 97.9092 65.4103 98.0721 65.1867 98.2382C64.2731 98.8771 63.27 99.4712 62.2031 100.049C61.1361 100.631 60.0053 101.199 58.8457 101.819C58.4624 102.024 58.0791 102.234 57.6893 102.455C59.5134 101.19 61.3406 99.9249 63.171 98.6567C65.0845 97.331 67.0043 96.0021 68.921 94.6732C69.8825 94.0215 70.86 93.3155 71.6778 92.4339C72.0867 91.993 72.4604 91.5075 72.7384 90.9548C72.8118 90.8079 72.8789 90.6514 72.9364 90.4949C72.9205 91.2008 72.9396 91.9164 73.0834 92.6287C73.1696 93.0664 73.3102 93.4976 73.5146 93.9001ZM69.183 83.7386C69.4225 83.6747 69.6685 83.6332 69.9113 83.6236C70.4 83.6108 70.8824 83.7194 71.2945 83.9686C71.7098 84.2146 72.0452 84.5787 72.2975 85.0004C72.5499 85.4253 72.716 85.9044 72.831 86.3964C72.9428 86.8915 73.0003 87.3994 73.0163 87.9074C73.0227 88.0607 73.0195 88.2172 73.0195 88.3737C73.0003 88.3162 72.9843 88.2587 72.962 88.2044C72.863 87.901 72.7032 87.6262 72.5339 87.3643C72.1761 86.8532 71.7321 86.4347 71.2913 86.045C70.8473 85.6585 70.3968 85.2911 69.9975 84.895C69.643 84.55 69.3459 84.1762 69.1191 83.7546C69.1414 83.7514 69.1606 83.745 69.183 83.7386ZM68.4802 84.0069C68.5217 83.9846 68.5664 83.9654 68.6079 83.9462C68.8667 84.4478 69.2213 84.9014 69.6142 85.2815C70.0423 85.7032 70.4991 86.0769 70.9335 86.4539C71.3648 86.834 71.7737 87.2237 72.0867 87.671C72.2337 87.8978 72.371 88.131 72.4509 88.3865C72.5467 88.6357 72.5946 88.9008 72.6106 89.1628C72.6393 89.693 72.4988 90.2265 72.2496 90.7153C72.0036 91.2072 71.6586 91.6544 71.2753 92.0697C70.8888 92.485 70.4607 92.8619 70.0135 93.2197C69.5663 93.5775 69.0903 93.9001 68.6079 94.2324C66.6913 95.5612 64.7714 96.8901 62.8579 98.2158C60.9445 99.5415 59.031 100.867 57.1207 102.19C56.6384 102.519 56.1784 102.867 55.6896 103.081C55.4468 103.186 55.1945 103.257 54.9485 103.263C54.7057 103.273 54.4598 103.212 54.2042 103.116C54.185 103.11 54.1659 103.1 54.1467 103.094C54.3128 103.02 54.4757 102.94 54.6355 102.851C55.153 102.563 55.6353 102.215 56.0698 101.81C56.501 101.404 56.8875 100.931 57.1654 100.382C57.4402 99.8386 57.5999 99.1901 57.4817 98.5512C57.4625 98.4714 57.4498 98.3947 57.4274 98.3148C57.4018 98.2382 57.3795 98.1615 57.3507 98.0881L57.3028 97.9762C57.2677 97.9251 57.2709 97.8293 57.1974 97.8037L56.9674 97.6472C56.6991 97.4811 56.3988 97.3597 56.0889 97.2926C55.466 97.1553 54.8271 97.2351 54.2489 97.4204C53.6675 97.6057 53.1341 97.8964 52.6453 98.2446C52.2652 98.5193 51.9074 98.826 51.5911 99.1837C51.8275 98.8004 52.1214 98.4458 52.4505 98.12C52.6421 97.9283 52.8466 97.7462 53.0574 97.5705C53.1628 97.4811 53.2714 97.3949 53.3768 97.3118L53.7059 97.0467C54.5843 96.3407 55.4373 95.6155 56.2806 94.884C57.9673 93.4242 59.622 91.9483 61.2543 90.4693C62.8835 88.9903 64.4935 87.5176 66.0684 86.0194L66.6562 85.454C66.851 85.2624 67.0491 85.0579 67.2248 84.8822C67.6049 84.534 68.0234 84.2273 68.4802 84.0069ZM68.3907 83.4543C68.3428 83.4767 68.2917 83.499 68.2438 83.5246C67.7327 83.7706 67.2727 84.1092 66.8606 84.4957L66.2856 85.0739L65.7042 85.6329C64.7523 86.5401 63.7811 87.4378 62.8004 88.3386C63.1391 88.0064 63.4681 87.6646 63.7875 87.3164C63.96 87.1183 64.1357 86.9171 64.3082 86.719L64.567 86.4219L64.8129 86.1121C64.9759 85.9044 65.1388 85.7 65.3017 85.4924C65.4614 85.2847 65.6084 85.0675 65.7617 84.8567L65.9885 84.5372C66.0652 84.4318 66.1386 84.3232 66.2089 84.2146C66.3495 83.9942 66.49 83.7769 66.6306 83.5565C66.7009 83.4479 66.7743 83.3393 66.8382 83.2275L67.0331 82.8889L67.1417 82.7004C67.2759 82.4608 67.4068 82.2468 67.5027 82.0583C67.5985 81.8699 67.6752 81.7197 67.7263 81.6175C67.8093 81.4514 67.8828 81.298 67.9435 81.1543C67.9882 81.9242 68.1032 82.6972 68.3907 83.4543ZM64.468 74.3853L64.5734 74.1936C64.5734 74.1904 64.5734 74.1904 64.5766 74.1904C64.5798 74.1904 64.5893 74.1904 64.6053 74.1872C64.6373 74.184 64.6692 74.184 64.7011 74.184C64.765 74.1808 64.8289 74.184 64.8928 74.1872C65.1484 74.2 65.3975 74.2703 65.6339 74.3789C66.1067 74.5961 66.506 74.9826 66.8223 75.4235C67.1417 75.8675 67.3813 76.3754 67.5538 76.9025C67.8924 77.9503 67.8732 79.0939 67.902 80.263C67.8541 80.3333 67.8061 80.4036 67.7582 80.4739C67.5985 80.7358 67.4292 81.0073 67.2407 81.3715C67.1896 81.4705 67.1161 81.6175 67.0203 81.7996C66.9277 81.9817 66.7967 82.1925 66.6657 82.4289L66.5603 82.6142L66.3718 82.9464C66.3079 83.055 66.2345 83.1604 66.1674 83.269C66.03 83.483 65.8927 83.6971 65.7553 83.9143C65.6882 84.0229 65.6148 84.1283 65.5413 84.2305L65.3177 84.5436C65.1675 84.7512 65.0238 84.9653 64.8673 85.1665C64.7075 85.3678 64.5478 85.569 64.3881 85.7703L64.1485 86.0737L63.8929 86.3644C63.7236 86.5593 63.5543 86.7542 63.3818 86.949C61.9859 88.4792 60.3886 89.8496 58.6413 91.0347C58.4241 91.1849 58.1973 91.319 57.9736 91.4628C57.9385 91.4819 57.9066 91.5043 57.8746 91.5267C58.1366 91.2424 58.3825 90.9453 58.5934 90.6067C58.6732 90.4821 58.7435 90.3479 58.8074 90.2042C58.8393 90.1339 58.8649 90.054 58.8905 89.9773C58.9096 89.8911 58.9352 89.8176 58.9384 89.7218C58.932 89.6835 58.9671 89.5972 58.932 89.5365L58.8873 89.4056C58.8649 89.3321 58.833 89.2586 58.801 89.1883C58.7723 89.1149 58.7339 89.0478 58.6924 88.9807C58.6541 88.9104 58.6125 88.8465 58.5678 88.7858C58.2068 88.2779 57.6829 87.9297 57.1399 87.7061C56.8652 87.5943 56.5841 87.5112 56.2998 87.4537L56.1879 87.4346C56.1209 87.4314 56.0506 87.3931 55.9867 87.4154L55.8238 87.5017C55.7918 87.5176 55.7599 87.5336 55.7279 87.5528C55.6034 87.623 55.482 87.6965 55.3606 87.77C54.8814 88.0735 54.431 88.4121 54.0093 88.7858C53.5877 89.1596 53.1916 89.5685 52.8561 90.038C52.6868 90.2712 52.5399 90.5268 52.4217 90.7983C52.3035 91.0699 52.2173 91.3669 52.2045 91.6832C52.1917 91.9962 52.2588 92.3221 52.3993 92.6032C52.4984 92.8044 52.6293 92.9833 52.7795 93.1398C52.6517 93.06 52.5335 92.9801 52.4313 92.8875C52.2524 92.7278 52.1406 92.5393 52.0863 92.3125C52.0384 92.0857 52.0416 91.8301 52.0831 91.5714C52.1246 91.3126 52.1917 91.0507 52.278 90.7919C52.4505 90.2744 52.6741 89.7633 52.92 89.2586L53.0127 89.0701L53.0606 88.9775C53.067 88.9647 53.067 88.9615 53.0702 88.9615L53.3768 88.6836C53.5877 88.4919 53.8017 88.3003 54.0061 88.099C54.2106 87.901 54.4214 87.7061 54.6227 87.5017L55.2296 86.8915C56.0282 86.0705 56.8013 85.2208 57.552 84.3487C58.2963 83.4703 59.0214 82.579 59.721 81.659C60.4142 80.7358 61.0978 79.803 61.7367 78.8383C62.0657 78.3624 62.3724 77.8704 62.6886 77.3848L63.1454 76.6437L63.3723 76.2732L63.5927 75.8962L64.0335 75.1423L64.468 74.3853ZM105.159 72.3887C104.82 72.2066 104.472 72.0469 104.111 71.9096C103.744 71.7754 103.392 71.6764 103.034 71.5646C102.677 71.456 102.322 71.3441 101.964 71.2483C101.607 71.1493 101.249 71.0439 100.888 70.9544C99.4503 70.5775 97.9968 70.2836 96.5402 70.06C93.6268 69.6032 90.7007 69.4818 87.8225 69.4754C84.9411 69.4722 82.0949 69.5936 79.2838 69.7054C76.4727 69.8204 73.6839 69.9322 70.9431 70.2485C69.5727 70.405 68.215 70.6062 66.8766 70.8426C66.2089 70.9704 65.5381 71.0886 64.88 71.2323C64.551 71.3026 64.2188 71.3729 63.8898 71.44C63.5607 71.5135 63.2349 71.5901 62.9059 71.6636C62.251 71.8074 61.6025 71.9767 60.9573 72.1332C60.312 72.2929 59.6699 72.4686 59.031 72.6315L58.9128 72.6635L58.8106 72.6826C58.7755 72.689 58.7435 72.6986 58.7084 72.7018L58.6029 72.7082C58.4624 72.7178 58.3154 72.7018 58.1653 72.6794C57.865 72.6315 57.5616 72.5389 57.2421 72.4462C56.9227 72.36 56.5873 72.2642 56.2135 72.2546C56.0634 72.2546 55.91 72.2642 55.7599 72.3025C55.6609 72.3696 55.5586 72.4271 55.466 72.5005C55.4628 72.5037 55.4404 72.5197 55.4404 72.5229C55.4277 72.5357 55.4117 72.5485 55.3989 72.5612C55.3957 72.5644 55.367 72.5996 55.3638 72.5996C55.3574 72.6124 55.3478 72.6219 55.3414 72.6347C55.3382 72.6411 55.3286 72.6666 55.3286 72.6666C55.3254 72.6794 55.3223 72.6954 55.3191 72.7018C55.3191 72.7114 55.3159 72.7497 55.3159 72.7561C55.3159 72.7625 55.3159 72.7657 55.3159 72.7657C55.3159 72.7689 55.3191 72.7721 55.3191 72.7753C55.3382 72.8583 55.3574 72.8967 55.4213 72.9829C55.4373 73.0053 55.4309 72.9957 55.45 73.0212C55.4564 73.0308 55.466 73.0404 55.4756 73.05C56.0953 73.264 56.7182 73.4205 57.3443 73.5483C57.9832 73.6793 58.6221 73.7879 59.261 73.8742C59.8999 73.9604 60.5388 74.0371 61.1745 74.0882C61.3342 74.1042 61.4939 74.1169 61.6536 74.1265L62.0466 74.1553H62.0593C62.1839 74.1617 62.2957 74.168 62.4011 74.1744C62.612 74.1872 62.7781 74.1936 62.8931 74.1936C63.3275 74.2032 63.6693 74.184 63.992 74.1329L63.5799 74.874L63.1454 75.6183L62.9282 75.9921L62.7014 76.3594L62.2478 77.0942C61.9316 77.5733 61.6313 78.0621 61.3055 78.5348C61.1361 78.7904 60.9605 79.046 60.7848 79.2983C60.8486 79.1418 60.9061 78.9789 60.9541 78.8128C61.0786 78.3496 61.2607 77.896 61.4204 77.4136C61.5003 77.174 61.577 76.9249 61.6345 76.6661C61.6632 76.5287 61.6856 76.3882 61.6984 76.2412C61.7111 76.2061 61.7207 76.171 61.7303 76.1358C61.7686 75.9697 61.7814 75.7812 61.7239 75.5928C61.6696 75.4043 61.5482 75.2414 61.4109 75.1296C61.2735 75.0146 61.1234 74.9411 60.9732 74.8868C60.9604 74.8836 60.9477 74.8804 60.9349 74.874C60.8838 74.8517 60.8295 74.8357 60.7784 74.8197C60.6378 74.775 60.4973 74.7526 60.3599 74.7367C59.8041 74.6824 59.2706 74.7622 58.7563 74.8836C58.242 75.005 57.7436 75.1743 57.2581 75.3787C57.0089 75.4842 56.7598 75.596 56.517 75.7205C52.9584 76.8961 49.3614 78.1419 45.8316 79.6785C44.7934 80.1321 43.7648 80.608 42.7457 81.1192C41.7299 81.6335 40.7268 82.1861 39.7525 82.793C39.3053 83.071 38.8613 83.3649 38.4268 83.6651C38.2575 83.4767 38.1361 83.2914 38.0116 83.0965C37.855 82.8506 37.6953 82.5854 37.51 82.2436C37.4525 82.1318 37.3567 81.9497 37.2641 81.7229C37.2161 81.6079 37.1714 81.4833 37.1267 81.3492C37.1139 81.3172 37.1043 81.2821 37.0948 81.2469L37.0788 81.1958L37.0724 81.1703L37.0149 80.9562C36.9702 80.7742 36.935 80.5921 36.9127 80.4068C36.8679 80.0394 36.8711 79.6689 36.9606 79.3303C37.0053 79.161 37.0692 79.0044 37.1586 78.8671L37.2289 78.768L37.3184 78.6626C37.3791 78.5924 37.4398 78.5221 37.5068 78.4582C37.7688 78.193 38.0659 77.9599 38.3853 77.7554C39.0274 77.3497 39.7557 77.0622 40.5 76.8162C41.2475 76.5735 42.0206 76.353 42.7841 76.1198C43.5507 75.8898 44.3174 75.6599 45.0841 75.4267C46.6206 74.9635 48.1603 74.5003 49.7064 74.0371C50.4795 73.8039 51.2525 73.5707 52.0256 73.3375L53.1884 72.9893L53.2427 72.9733C53.2427 72.9765 53.2427 72.9765 53.2459 72.9797C53.2746 72.9574 53.3002 72.9318 53.3257 72.9094C53.3257 72.9062 53.3289 72.903 53.3289 72.903C53.3321 72.8967 53.3385 72.8807 53.3385 72.8775C53.3225 72.7817 53.2874 72.6155 53.2523 72.4846C53.2491 72.4814 53.2395 72.4686 53.2363 72.4654C53.2235 72.4526 53.2139 72.4398 53.2011 72.4271C53.1979 72.4239 53.1916 72.4175 53.1884 72.4143L53.1277 72.4175L52.8242 72.4367L52.2173 72.475C48.9845 72.6922 45.707 72.9925 42.5221 73.8518C40.9345 74.283 39.3724 74.858 37.9093 75.6407L37.6346 75.7844C37.542 75.8323 37.4557 75.8898 37.3663 75.9442L36.8328 76.2668L36.5677 76.4297C36.4814 76.484 36.3984 76.5479 36.3121 76.6086L35.8042 76.9696L35.5518 77.1516C35.4688 77.2123 35.3921 77.2826 35.3123 77.3497L34.8331 77.749C34.5073 78.0078 34.2166 78.308 33.9163 78.5636C33.616 78.8223 33.3093 79.0555 32.9707 79.1961C32.6353 79.343 32.2648 79.391 31.8942 79.3718C31.5205 79.3494 31.1435 79.26 30.7825 79.1226C30.6004 79.0555 30.4216 78.9757 30.2491 78.8894L29.7316 78.5987C28.3771 77.7746 27.3102 76.5319 26.4573 75.1743C25.6011 73.8103 24.9399 72.3249 24.3106 70.8267C23.6877 69.3221 23.0679 67.8143 22.5025 66.2937C21.9435 64.7732 21.4356 63.2367 21.0682 61.6714C20.9692 61.2817 20.8957 60.8855 20.8127 60.4958C20.7456 60.0997 20.6657 59.7068 20.6178 59.3107C20.4996 58.5185 20.4453 57.723 20.4166 56.9244C20.3782 55.3304 20.5348 53.7364 20.7999 52.1647C20.9309 51.3789 21.0938 50.5962 21.2695 49.82L21.4068 49.2386L21.442 49.0917L21.458 49.0182C21.4643 48.9926 21.4707 48.9735 21.4739 48.9383C21.4835 48.8712 21.4995 48.8074 21.4963 48.7339L21.4931 48.6285C21.4899 48.5933 21.4803 48.5582 21.4739 48.523C21.4164 48.2419 21.2088 48.0055 20.9564 47.8873C20.8286 47.8298 20.6881 47.8011 20.5443 47.8043C20.4006 47.8139 20.2536 47.8458 20.1323 47.9257C20.0652 47.9576 20.0173 48.0087 19.9629 48.0535C19.915 48.1014 19.8703 48.1589 19.832 48.2068L19.6659 48.4655L19.3336 48.983C19.2314 49.1587 19.142 49.344 19.0429 49.5229C18.9503 49.705 18.8449 49.8807 18.7714 50.0692C18.6149 50.4429 18.4392 50.8135 18.3178 51.2L18.1198 51.775L17.9632 52.3596C17.5511 53.9217 17.3723 55.5253 17.3595 57.1193C17.3435 58.7133 17.4841 60.2946 17.7396 61.8471C17.7971 62.2368 17.8834 62.6201 17.9536 63.0067C18.0367 63.39 18.1229 63.7733 18.2124 64.1535C18.4009 64.9105 18.6021 65.6644 18.8225 66.4087C19.7074 69.3828 20.8159 72.2801 22.3652 74.9155C23.1478 76.2253 24.0518 77.4711 25.1635 78.5221C25.7193 79.046 26.3327 79.5123 27.0035 79.8861C27.0866 79.9372 27.1728 79.9787 27.2591 80.0203L27.39 80.0842C27.3932 80.0873 27.3932 80.0873 27.3964 80.0873C27.3741 80.0937 27.2942 80.1161 27.0546 80.1832C25.6618 80.5729 24.2211 80.7678 22.79 80.8987C21.3557 81.0265 19.9246 81.0872 18.4999 81.1607C17.0688 81.2278 15.6664 81.3747 14.2896 81.3396C13.6028 81.3236 12.9224 81.2629 12.2643 81.1223C11.6063 80.985 10.977 80.7614 10.3892 80.4547C9.21364 79.8414 8.25212 78.8862 7.43753 77.8544C6.62615 76.813 5.97767 75.663 5.43462 74.4843C4.89156 73.3023 4.45712 72.0853 4.10253 70.8618C3.74795 69.6383 3.47003 68.4085 3.26559 67.1818C3.16336 66.5685 3.07712 65.9583 3.01003 65.3482C2.93976 64.738 2.88545 64.1279 2.84073 63.5242C2.75448 62.3167 2.71295 61.1251 2.80878 59.9623C2.84712 59.381 2.93976 58.8123 3.05476 58.2533C3.12823 57.9786 3.17934 57.7007 3.27517 57.4355C3.3199 57.3014 3.35823 57.1672 3.40614 57.0362C3.46045 56.9085 3.51156 56.7775 3.56586 56.6497C3.59142 56.5858 3.61698 56.5219 3.64573 56.458L3.74156 56.2728C3.80545 56.1514 3.86614 56.0268 3.93003 55.9054C4.0035 55.7904 4.07698 55.6754 4.15045 55.5604L4.25906 55.3879L4.38364 55.225C4.69989 54.7842 5.08003 54.3976 5.49211 54.0558C6.50475 53.2221 7.71545 52.6598 8.93892 52.1743C10.172 51.6951 11.4178 51.2351 12.6381 50.7719C13.2514 50.5419 13.8616 50.3119 14.4685 50.0819C14.772 49.9669 15.0755 49.8519 15.3789 49.7401C15.6824 49.6251 15.9891 49.5069 16.2925 49.3696C16.596 49.229 16.8963 49.0725 17.1742 48.8712C17.4553 48.6732 17.7141 48.4272 17.9185 48.1397C18.1293 47.8522 18.2667 47.5328 18.3817 47.2229C18.4935 46.913 18.583 46.6032 18.682 46.3125C18.781 46.0218 18.8864 45.7407 19.0334 45.4979C19.1803 45.2551 19.3656 45.0507 19.5892 44.8814C20.0364 44.5492 20.621 44.399 21.1673 44.4661C21.7135 44.53 22.1991 44.8494 22.5281 45.2967C22.6942 45.5203 22.8188 45.7726 22.8955 46.0378C22.9338 46.1719 22.9657 46.3061 22.9785 46.4403C22.9881 46.5073 22.9945 46.5776 22.9945 46.6447L22.9977 46.7469L22.9721 46.9705C22.9625 47.0472 22.9561 47.1175 22.9466 47.1973L22.9114 47.4337L22.8923 47.5519C22.8667 47.6158 22.9466 47.5487 22.9689 47.5519L23.1861 47.4753C23.4193 47.3954 23.6493 47.3123 23.8825 47.2325C24.17 47.1335 24.4575 47.0312 24.745 46.9322C25.3168 46.7246 25.8822 46.5105 26.4477 46.3029C27.0099 46.0825 27.5657 45.8653 28.1216 45.6448C28.6742 45.418 29.2236 45.1912 29.7699 44.9676C34.1335 43.134 38.2448 41.1694 42.1899 39.256C44.1609 38.2944 46.0935 37.3521 47.9878 36.4257C48.4606 36.1957 48.9334 35.9657 49.403 35.7389C49.8693 35.5025 50.3357 35.2661 50.7989 35.0329C51.2621 34.7965 51.7221 34.5697 52.1789 34.3301C52.6293 34.0842 53.0766 33.8382 53.5206 33.5954C57.0824 31.6404 60.3886 29.5768 63.5 27.5164C66.6018 25.44 69.5024 23.3572 72.2304 21.3096C73.5817 20.2682 74.9106 19.2651 76.1756 18.2397C77.4566 17.2367 78.6673 16.2112 79.862 15.2242C80.4561 14.729 81.0279 14.2211 81.6029 13.7292C81.8873 13.4832 82.1716 13.2372 82.4527 12.9944C82.737 12.7517 83.0053 12.4993 83.28 12.2533C83.8263 11.7614 84.3629 11.2726 84.8964 10.7935C85.4171 10.3015 85.9314 9.81277 86.4361 9.3336C86.6885 9.09402 86.9409 8.85443 87.19 8.61804C87.4328 8.37527 87.6756 8.13249 87.9152 7.8929C88.3911 7.41054 88.8703 6.94415 89.3271 6.46499C89.423 6.36277 89.5156 6.26054 89.6114 6.15832C89.5475 6.5736 89.5028 6.99207 89.4709 7.40735C89.4389 7.80985 89.4166 8.21235 89.3974 8.61166L89.3559 9.81596L89.3367 10.4165V11.0171L89.3335 12.2214C89.3654 13.825 89.423 15.4286 89.5571 17.0226C89.736 19.3418 90.0107 21.6514 90.3589 23.9418C90.097 22.9643 89.8255 21.9453 89.5475 20.8975C89.391 20.3353 89.2377 19.773 89.0588 19.2076C89.0364 19.1374 89.0141 19.0671 88.9885 18.9936L88.9054 18.7604C88.8575 18.6294 88.7905 18.4985 88.7329 18.3675L88.6882 18.2685L88.6659 18.2205L88.6531 18.195C88.6499 18.1822 88.6435 18.1822 88.6371 18.1886L88.4582 18.3036C88.158 18.508 87.8577 18.7125 87.5542 18.9169C86.5799 19.5846 85.6024 20.2554 84.6185 20.9294C82.6603 22.2711 80.683 23.6255 78.712 24.9736L78.827 24.8746C80.1495 23.7437 81.4624 22.6321 82.7306 21.5332C83.9924 20.4247 85.1743 19.2811 86.1454 18.0608C86.8227 17.2047 87.4168 16.2847 87.8449 15.2912C87.896 15.1762 87.9439 15.058 87.9886 14.9398C88.0877 14.7514 88.1803 14.5597 88.2634 14.3617C88.3624 14.1189 88.4454 13.8697 88.5029 13.611C88.5636 13.3522 88.6052 13.0871 88.6148 12.8187C88.6243 12.5504 88.618 12.2789 88.5732 12.0105C88.5668 11.9435 88.5509 11.8764 88.5381 11.8093L88.5221 11.7294C88.5253 11.7294 88.5253 11.7262 88.5221 11.7262L88.5189 11.7103L88.5125 11.6847C88.7905 11.6368 88.5189 11.6719 88.2698 11.7103C88.2793 11.6943 88.2889 11.6815 88.2953 11.6687C88.2634 11.6879 88.2378 11.7039 88.2059 11.7198C88.0557 11.7422 87.9311 11.7646 87.9759 11.7614V11.7997C87.8545 11.8189 87.8034 11.8285 87.9759 11.8093C87.9759 11.8253 87.9759 11.8412 87.9759 11.854C87.5255 12.1255 87.1677 12.3779 86.6693 12.8283C86.5863 12.9018 86.4617 13.0168 86.3084 13.1542C86.2317 13.2244 86.1454 13.3011 86.056 13.381C85.6056 13.7835 85.1488 14.1923 84.6824 14.6076C84.1489 15.0868 83.6059 15.5724 83.066 16.0803C82.5229 16.585 81.9927 17.1153 81.456 17.6455C80.9161 18.1758 80.3699 18.7093 79.8109 19.246C77.5843 21.3894 75.1981 23.568 72.5084 25.5039C69.8186 27.4429 66.8702 29.1743 63.845 30.8801C57.8075 34.3046 51.4474 37.5693 45.1032 40.4794C38.7591 43.396 32.4405 45.9867 26.5148 48.1493C25.7768 48.4272 25.0389 48.686 24.3138 48.9447C24.0774 49.0278 23.841 49.114 23.6046 49.1971C23.4225 49.261 23.2436 49.3248 23.0616 49.3919C22.8891 49.4558 22.7166 49.5197 22.5409 49.5836L22.2853 49.6794L22.1575 49.7273L22.0936 49.7497C22.0617 49.7593 22.0553 49.7657 22.0936 49.7689C22.2757 49.804 22.461 49.8392 22.6431 49.8711C23.0073 49.9414 23.3714 50.0085 23.7356 50.0787C23.8218 50.0979 23.9145 50.1107 24.0071 50.1203L24.17 50.1394L24.4543 50.1746C24.5502 50.1842 24.6428 50.2001 24.7386 50.2065L25.0229 50.2225C25.2114 50.2321 25.4031 50.2448 25.5916 50.248C25.78 50.2448 25.9685 50.2448 26.1538 50.2416C26.2464 50.2385 26.3423 50.2417 26.4349 50.2385L26.7128 50.2193C26.8981 50.2065 27.0834 50.1937 27.2655 50.181C27.4475 50.1586 27.6296 50.1362 27.8117 50.1171L28.0832 50.0851L28.3516 50.0404C29.7827 49.8104 31.1371 49.4367 32.4085 49.0022C33.6831 48.5678 34.881 48.0822 36.0182 47.603C40.5575 45.6768 44.2184 43.9198 46.7516 42.6772C48.0134 42.0447 49.0068 41.5655 49.6713 41.211C50.3389 40.866 50.6903 40.6807 50.6903 40.6807C50.6903 40.6807 50.981 40.5305 51.5496 40.2335C52.1214 39.946 52.9552 39.486 54.0573 38.8918C55.1625 38.3072 56.5074 37.5374 58.1046 36.6397C59.6891 35.7229 61.5195 34.6592 63.5511 33.4101C63.8067 33.2568 64.0654 33.0971 64.3274 32.9373C64.5861 32.7744 64.8513 32.6083 65.1164 32.4422C65.6499 32.1068 66.1961 31.7618 66.7552 31.4072C67.3174 31.059 67.886 30.6821 68.4674 30.3019C69.0488 29.9218 69.6429 29.5321 70.2531 29.1328C72.6617 27.5036 75.278 25.7211 78.0156 23.6958C78.3574 23.4435 78.7056 23.1911 79.0538 22.9355C79.3988 22.6736 79.747 22.4117 80.0984 22.1465C80.4498 21.8814 80.8043 21.613 81.1621 21.3447C81.5199 21.0764 81.8809 20.8048 82.2355 20.5205C82.951 19.9583 83.6793 19.3897 84.4204 18.8115C84.8836 18.4473 85.3436 18.064 85.7909 17.6519C85.7685 17.6807 85.7493 17.7094 85.727 17.735C83.8486 20.1117 81.095 22.188 78.482 24.4753C77.217 25.555 75.9488 26.6379 74.6806 27.7208C74.6806 27.74 74.6806 27.7592 74.6838 27.7783C74.6838 27.7943 74.687 27.8103 74.687 27.8262C74.687 27.8294 74.6902 27.8454 74.6902 27.855C74.6966 27.8901 74.7029 27.9253 74.7157 27.9572C74.7221 27.9764 74.7285 27.9955 74.7349 28.0147C74.7381 28.0211 74.7477 28.0435 74.7477 28.0499C74.7605 28.0722 74.77 28.0946 74.7828 28.1169C74.7892 28.1265 74.7988 28.1329 74.8052 28.1425C74.8052 28.1425 74.8084 28.1457 74.8116 28.1489C74.818 28.1521 74.8307 28.1617 74.8339 28.1648C74.8467 28.1712 74.8595 28.1776 74.8691 28.184C74.8691 28.184 74.8691 28.184 74.8723 28.184C74.8946 28.1904 74.9138 28.2 74.9361 28.2032C74.9457 28.2064 74.9521 28.2064 74.9617 28.2096C76.3257 27.2736 77.677 26.3504 79.0027 25.4432C80.98 24.0887 82.9606 22.7311 84.9284 21.383C85.9123 20.709 86.8898 20.0382 87.8641 19.3705C88.0493 19.2428 88.2314 19.1182 88.4167 18.9936L88.4806 19.1757C88.5061 19.2428 88.5253 19.3098 88.5477 19.3801C88.7234 19.9296 88.8735 20.4918 89.03 21.0508C89.4549 22.6417 89.8638 24.1718 90.2375 25.5837C90.3334 25.9351 90.4132 26.2226 90.4611 26.3887C90.5761 26.788 90.688 27.0915 90.8221 27.3758C90.8796 27.494 90.9371 27.609 91.0042 27.724C92.0999 33.573 93.5917 39.3071 95.2911 44.9197C97.112 50.9125 99.1756 56.7711 101.361 62.4955C102.456 65.3578 103.581 68.1848 104.728 70.9832C104.801 71.1589 104.865 71.3314 104.948 71.5103L105.069 71.7786L105.207 72.0373C105.319 72.2386 105.437 72.4366 105.561 72.6251C105.427 72.5389 105.296 72.459 105.159 72.3887ZM84.0818 18.3803C83.3439 18.9585 82.6188 19.5271 81.9032 20.0861C81.5486 20.3672 81.1877 20.6387 80.8331 20.9071C80.4753 21.1754 80.1239 21.4437 79.7725 21.7089C79.4212 21.974 79.0761 22.236 78.7311 22.4979C78.3829 22.7535 78.038 23.0058 77.6961 23.255C74.9681 25.2771 72.3582 27.0532 69.956 28.6792C69.3491 29.0753 68.7549 29.465 68.1767 29.8451C67.5953 30.2253 67.0331 30.599 66.4709 30.9472C65.9118 31.2986 65.3656 31.6436 64.8353 31.979C64.5702 32.1451 64.3082 32.3112 64.0495 32.4742C63.7875 32.6339 63.532 32.7904 63.2764 32.9437C61.2511 34.1896 59.4239 35.2501 57.8427 36.1669C56.2486 37.0614 54.907 37.828 53.8049 38.4126C52.706 39.0036 51.8755 39.4636 51.3036 39.7511C50.7382 40.045 50.4475 40.1951 50.4475 40.1951C50.4475 40.1951 50.0961 40.3772 49.4317 40.7222C48.7705 41.0736 47.7802 41.5528 46.5216 42.1853C43.9948 43.4247 40.3435 45.1785 35.817 47.0983C34.6861 47.5775 33.4978 48.0567 32.2456 48.4847C30.9934 48.9128 29.6677 49.2769 28.2781 49.5005L28.0161 49.5421L27.7542 49.574C27.5785 49.5964 27.4028 49.6155 27.2239 49.6379C27.045 49.6507 26.8693 49.6635 26.6904 49.673L26.4221 49.6922C26.3327 49.6954 26.2432 49.6954 26.1538 49.6954C25.9749 49.6986 25.7928 49.6986 25.6107 49.7018C25.4286 49.6954 25.2498 49.6826 25.0677 49.6762L24.7929 49.6635C24.7003 49.6571 24.6109 49.6443 24.5214 49.6347C24.3904 49.6187 24.2627 49.6028 24.1317 49.59L24.2371 49.5517L24.5086 49.4558C25.237 49.1971 25.9749 48.9383 26.716 48.6604C32.6545 46.4946 38.9859 43.8975 45.346 40.9746C51.7061 38.0548 58.0791 34.7837 64.1293 31.3529C67.1577 29.6439 70.1253 27.9029 72.8406 25.9447C75.5623 23.9865 77.9677 21.7855 80.2006 19.6357C80.7596 19.099 81.3091 18.5624 81.8489 18.0321C82.392 17.5018 82.9159 16.9747 83.4525 16.4764C83.986 15.9748 84.5259 15.4893 85.0561 15.0133C85.5225 14.598 85.9793 14.1892 86.4298 13.7835C86.5192 13.7004 86.6055 13.6237 86.6821 13.5535C86.8355 13.4129 86.96 13.2979 87.0431 13.2244C87.4743 12.8251 87.7395 12.5089 87.9918 12.1447C87.9918 12.1543 87.9918 12.1639 87.9918 12.1735C87.9886 13.0328 87.813 13.8953 87.4999 14.7226C87.1485 15.3711 86.6853 15.9621 86.1838 16.4987C85.5257 17.1887 84.8166 17.8053 84.0818 18.3803ZM114.557 76.3978L114.467 76.484C114.435 76.5096 114.4 76.5351 114.365 76.5607C114.295 76.6086 114.234 76.6661 114.161 76.7076C113.908 76.8674 113.624 76.976 113.33 77.0526C113.123 77.0367 112.915 77.0111 112.714 76.9823C112.001 76.861 111.318 76.6022 110.676 76.2508C110.034 75.8994 109.427 75.4746 108.836 75.021C108.222 74.5546 107.619 74.0594 106.992 73.5899C106.737 73.2992 106.491 73.0021 106.264 72.689C106.047 72.3951 105.849 72.0853 105.673 71.769L105.545 71.5294L105.434 71.2835C105.36 71.1205 105.29 70.9385 105.216 70.766C104.073 67.974 102.948 65.1469 101.856 62.2911C99.6739 56.5762 97.6167 50.7304 95.7991 44.7536C93.9878 38.7768 92.4161 32.6594 91.3077 26.4239C90.7518 23.3061 90.3334 20.1564 90.0874 16.9875C89.9564 15.403 89.8989 13.8122 89.867 12.2214L89.8702 11.0267V10.4293L89.8893 9.83193L89.9309 8.6404C89.95 8.2411 89.9724 7.84499 90.0043 7.45207C90.0586 6.76207 90.1449 6.07527 90.3046 5.41402C90.4164 5.29263 90.5314 5.17124 90.6432 5.05304C90.7167 5.35013 90.7902 5.64721 90.8605 5.9411C91.4546 8.34971 92.0105 10.6146 92.5312 12.7389C93.5757 16.9843 94.4798 20.6579 95.2496 23.7885C96.7893 30.0464 97.7924 34.1193 98.3003 36.1925C99.4439 40.834 100.453 44.9485 101.348 48.5869C101.571 49.4973 101.789 50.379 101.999 51.2287C102.105 51.6536 102.207 52.0753 102.309 52.4874C102.36 52.6918 102.412 52.8962 102.459 53.1007L102.498 53.2508L102.507 53.2828C102.341 53.3083 102.389 53.3051 102.511 53.2892L102.52 53.3243L102.523 53.3435C102.498 53.3498 102.536 53.3467 102.603 53.3371C102.667 53.5639 102.75 53.8067 102.862 54.0878C103.054 54.5861 103.437 55.5796 103.903 56.7935C104.172 57.493 104.453 58.2214 104.756 58.9689C104.906 59.3426 105.066 59.7196 105.226 60.0997C105.386 60.4767 105.542 60.8536 105.689 61.2465C106.28 62.8022 106.788 64.4505 107.379 66.0414C107.673 66.8368 107.986 67.6162 108.34 68.3605C108.692 69.1049 109.078 69.8172 109.526 70.4561C109.97 71.0982 110.465 71.6764 111.011 72.1364C111.557 72.5996 112.142 72.9542 112.717 73.1873C112.857 73.2512 113.001 73.3055 113.161 73.3471C113.321 73.3886 113.503 73.411 113.688 73.379C113.71 73.3758 113.733 73.3694 113.755 73.363L113.8 73.3535C113.825 73.3471 113.851 73.3407 113.886 73.3343C113.953 73.3215 114.017 73.3087 114.081 73.296C114.218 73.264 114.356 73.2257 114.483 73.1682C114.742 73.0564 114.953 72.8871 115.109 72.7114C115.183 72.6219 115.253 72.5357 115.314 72.4462C115.368 72.3568 115.423 72.2737 115.467 72.1907C115.547 72.0246 115.621 71.8776 115.662 71.7467C115.688 71.6796 115.71 71.6221 115.729 71.5646C115.748 71.5103 115.761 71.4592 115.774 71.4112C115.825 71.2291 115.854 71.1333 115.854 71.1333C115.854 71.1333 115.873 71.0375 115.914 70.8522C115.959 70.6701 115.998 70.3986 116.045 70.0536C116.081 69.7118 116.125 69.2965 116.176 68.8205C116.205 68.581 116.218 68.3254 116.237 68.0539C116.253 67.7823 116.272 67.498 116.291 67.201C116.314 66.9039 116.311 66.5908 116.323 66.2682C116.33 65.9455 116.346 65.6069 116.343 65.2619C116.333 64.5687 116.336 63.834 116.291 63.0705C116.269 62.3039 116.196 61.5117 116.132 60.6971C116.09 60.2914 116.045 59.8793 116.004 59.464C115.962 59.0487 115.899 58.6335 115.844 58.2118C115.72 57.3078 115.576 56.3942 115.416 55.4901C115.745 56.7072 116.036 57.9371 116.263 59.1861C116.509 60.5725 116.684 61.978 116.761 63.3996C116.841 64.8211 116.838 66.2522 116.748 67.6865C116.652 69.1208 116.474 70.5551 116.205 71.9798C116.065 72.689 115.911 73.4046 115.729 74.1041C115.544 74.7973 115.311 75.4778 114.902 76.024C114.796 76.1646 114.681 76.286 114.557 76.3978ZM117.547 71.3282C117.521 72.0789 117.432 72.8232 117.25 73.5419C117.071 74.2607 116.787 74.9475 116.387 75.548C116.189 75.8483 115.953 76.1262 115.691 76.3658C115.624 76.4265 115.557 76.4808 115.49 76.5383C115.419 76.5926 115.349 76.6469 115.279 76.6948C115.145 76.7907 114.991 76.861 114.835 76.9185C114.812 76.9248 114.787 76.9312 114.764 76.9376C114.784 76.9248 114.803 76.9089 114.822 76.8961L114.931 76.7907C115.078 76.6533 115.218 76.5064 115.333 76.3467C115.812 75.7046 116.058 74.9603 116.25 74.2415C116.435 73.5196 116.592 72.8008 116.732 72.0789C117.004 70.6318 117.189 69.1751 117.285 67.7185C117.358 66.5876 117.374 65.46 117.339 64.3387C117.515 66.6771 117.595 69.0154 117.547 71.3282Z"/>
                    </mask>
                    <path d="M117.681 62.0771C117.055 55.8862 115.822 49.721 114.474 43.5525C114.135 42.0128 113.793 40.4667 113.452 38.9205C113.11 37.3776 112.774 35.8219 112.391 34.2758C111.634 31.1836 110.762 28.1137 109.781 25.0694C108.797 22.0283 107.702 19.0128 106.449 16.0547C105.191 13.103 103.772 10.2025 102.054 7.47124C101.191 6.10721 100.252 4.78791 99.1756 3.57082L98.7667 3.11721C98.6325 2.96388 98.4824 2.82652 98.3418 2.67957C98.0575 2.38888 97.77 2.10457 97.457 1.83624C97.1471 1.56791 96.8149 1.31235 96.4507 1.09832C96.0866 0.884293 95.6873 0.711794 95.2624 0.615961C94.8311 0.523322 94.3839 0.526515 93.9622 0.609571C93.5374 0.692626 93.1349 0.849156 92.7611 1.05041C92.0136 1.4561 91.3907 2.04707 90.8988 2.72429C90.6496 3.0629 90.4484 3.43346 90.2791 3.81041C90.1098 4.19054 89.9692 4.58346 89.8606 4.97957C89.8446 5.03388 89.8318 5.08499 89.8191 5.13929C89.5284 5.44915 89.2377 5.76221 88.9406 6.08166C88.487 6.55443 88.011 7.02082 87.535 7.49999C87.2954 7.73957 87.0559 7.97915 86.8163 8.22193C86.5671 8.45832 86.3179 8.69471 86.0656 8.93429C85.5609 9.41027 85.0498 9.89582 84.5323 10.3878C84.002 10.8669 83.4653 11.3525 82.9223 11.8444C82.6475 12.0872 82.3792 12.3428 82.0981 12.5823C81.817 12.8251 81.5359 13.0711 81.2516 13.3171C80.6798 13.8058 80.1111 14.3137 79.517 14.8057C78.3286 15.7896 77.118 16.8118 75.8434 17.8117C74.5848 18.8339 73.2591 19.8337 71.911 20.8719C69.1893 22.9132 66.2984 24.9896 63.2061 27.0596C60.1043 29.1136 56.8077 31.1676 53.265 33.113C52.821 33.3558 52.377 33.5986 51.9298 33.8446C51.4761 34.081 51.0193 34.3078 50.5593 34.541C50.0993 34.7742 49.6361 35.0074 49.173 35.2405C48.7034 35.4674 48.2306 35.6973 47.7578 35.9273C45.8635 36.8537 43.9309 37.7961 41.9599 38.7576C38.018 40.6679 33.9131 42.6325 29.5654 44.4565C29.0192 44.6801 28.473 44.9037 27.9235 45.1305C27.3709 45.3478 26.815 45.565 26.256 45.7854C25.6938 45.993 25.1316 46.2071 24.5629 46.4115C24.2786 46.5105 23.9911 46.6096 23.7068 46.7118L23.5375 46.7693C23.5375 46.7693 23.5375 46.7661 23.5375 46.7597V46.7469L23.5343 46.6192C23.5343 46.5329 23.5248 46.4498 23.5152 46.3668C23.496 46.1975 23.4609 46.0346 23.4129 45.8717C23.3171 45.549 23.1638 45.2392 22.9625 44.9676C22.7613 44.6929 22.5089 44.4533 22.2118 44.268C21.918 44.086 21.5793 43.9614 21.2343 43.9198C20.5443 43.8368 19.832 44.0221 19.2698 44.4373C18.9886 44.6418 18.7459 44.9133 18.5702 45.2104C18.3913 45.5075 18.2731 45.8237 18.1709 46.1304C17.9664 46.7437 17.8195 47.3507 17.4841 47.8139C17.1518 48.2835 16.6311 48.6093 16.0689 48.868C15.7846 48.9958 15.4907 49.1108 15.1873 49.2258C14.8838 49.3408 14.5803 49.4526 14.2768 49.5676C13.6699 49.7976 13.0598 50.0276 12.4464 50.2576C11.2198 50.724 9.9867 51.1776 8.73767 51.6632C7.49503 52.1583 6.23322 52.7397 5.14711 53.631C4.70309 53.9951 4.291 54.4168 3.9492 54.8928L3.81503 55.0685L3.69684 55.2537C3.61698 55.3783 3.54031 55.5029 3.46045 55.6275C3.39336 55.7585 3.32628 55.8894 3.256 56.0204L3.15378 56.2185C3.12184 56.2855 3.09628 56.3558 3.06753 56.4229C3.01003 56.5603 2.95573 56.6976 2.89823 56.835C2.84712 56.9755 2.80559 57.1161 2.75767 57.2598C2.65545 57.541 2.60114 57.8348 2.52448 58.1223C2.40628 58.7069 2.31045 59.3011 2.26892 59.9017C2.16989 61.1028 2.21142 62.323 2.30087 63.5465C2.34559 64.1598 2.39989 64.77 2.47017 65.3897C2.53726 66.0094 2.6235 66.6323 2.72892 67.2553C2.93975 68.5011 3.21767 69.7501 3.57864 70.996C3.93962 72.2418 4.38364 73.4812 4.93948 74.6919C5.49531 75.8994 6.16295 77.0846 7.00628 78.1707C7.43434 78.7074 7.89114 79.228 8.41184 79.6944C8.92934 80.1608 9.50114 80.5889 10.1336 80.9147C10.7661 81.2437 11.4466 81.4833 12.1461 81.6303C12.8457 81.7804 13.5613 81.8411 14.2705 81.8571C15.6952 81.8922 17.1071 81.7421 18.5223 81.6782C19.9438 81.6047 21.3813 81.5472 22.8348 81.4162C24.285 81.2821 25.7513 81.084 27.1952 80.6815C27.3932 80.6208 27.4827 80.6112 27.9043 80.4643L28.4282 80.2886L28.6902 80.1992L28.8211 80.1544C28.8435 80.1385 28.9649 80.1257 28.8818 80.1065L28.3803 79.8957L28.1279 79.7903L28.0034 79.736L27.866 79.6817C27.8181 79.6657 27.7766 79.6433 27.735 79.6242L27.62 79.5698L27.4986 79.5124C27.4188 79.474 27.3389 79.4357 27.2623 79.3878C26.6393 79.0428 26.0611 78.5987 25.5309 78.1036C24.4703 77.1037 23.5918 75.8962 22.8284 74.6153C21.311 72.0373 20.2153 69.1751 19.3368 66.2298C18.9088 64.754 18.5127 63.2558 18.2667 61.7321C18.0175 60.2051 17.8802 58.6526 17.8961 57.0969C17.9089 55.5412 18.0814 53.9792 18.4807 52.4714L18.6341 51.906L18.8225 51.3533C18.9375 50.9796 19.1068 50.6282 19.257 50.2704C19.3273 50.0883 19.4295 49.9222 19.5157 49.7465C19.6084 49.574 19.6946 49.3983 19.7905 49.2322L20.1067 48.7403L20.2632 48.4943C20.2856 48.4655 20.3048 48.4432 20.3271 48.4208C20.3527 48.4048 20.3686 48.3793 20.3974 48.3697C20.4421 48.3346 20.4996 48.3314 20.5539 48.3218C20.6114 48.3218 20.6689 48.3346 20.7232 48.3569C20.8318 48.4112 20.9181 48.5039 20.9373 48.6189C20.9404 48.6317 20.9436 48.6476 20.9468 48.6604C20.9468 48.6764 20.9468 48.6892 20.9468 48.7051C20.9532 48.7339 20.9373 48.769 20.9373 48.801C20.9373 48.8137 20.9277 48.8425 20.9245 48.8648L20.9085 48.9383L20.8734 49.0853L20.736 49.673C20.5571 50.4589 20.3942 51.2511 20.26 52.0497C19.9885 53.6469 19.8256 55.2761 19.8671 56.9148C19.8959 57.7326 19.9534 58.5504 20.0748 59.3618C20.1227 59.7675 20.2057 60.17 20.2728 60.5757C20.3591 60.975 20.4325 61.3807 20.5348 61.7768C20.9117 63.3708 21.426 64.9265 21.9882 66.463C22.56 67.9964 23.1798 69.5042 23.8027 71.0151C24.4352 72.5229 25.106 74.0339 25.9909 75.4426C26.4349 76.1454 26.93 76.8194 27.5018 77.4328C28.0704 78.0461 28.7189 78.5987 29.4409 79.0396C30.1564 79.4772 30.9678 79.835 31.8559 79.8925C32.2967 79.9148 32.7599 79.8573 33.1784 79.6753C33.5968 79.4964 33.9482 79.2281 34.2645 78.9533C34.5839 78.6786 34.865 78.3879 35.1813 78.1387L35.6413 77.7522C35.718 77.6883 35.7946 77.6212 35.8745 77.5605L36.1205 77.3848L36.6124 77.0335C36.6954 76.976 36.7753 76.9153 36.8584 76.861L37.1171 76.7044L37.6314 76.3914C37.7177 76.3403 37.8007 76.2828 37.8902 76.238L38.1585 76.1007C39.5768 75.3404 41.1006 74.7782 42.6563 74.3565C45.3396 73.6346 48.1124 73.3119 50.882 73.0947C50.4348 73.2289 49.9875 73.363 49.5403 73.4972C47.9942 73.9636 46.4545 74.4268 44.9179 74.8868C44.1513 75.1168 43.3814 75.35 42.618 75.58C41.8513 75.8132 41.0878 76.0336 40.3211 76.2828C39.5545 76.5351 38.7878 76.8354 38.085 77.2794C37.7336 77.4998 37.4046 77.7618 37.1107 78.0621C37.0341 78.1355 36.967 78.2122 36.8967 78.2953L36.7945 78.4166L36.6923 78.5572C36.5645 78.7521 36.4814 78.9661 36.4271 79.1801C36.3153 79.6114 36.3185 80.0426 36.3664 80.4579C36.392 80.6655 36.4335 80.87 36.4814 81.0712L36.5453 81.3012V81.3044L36.5549 81.3332L36.5709 81.3907C36.5836 81.429 36.5932 81.4673 36.606 81.5025C36.6539 81.6494 36.7082 81.7868 36.7593 81.9114C36.8616 82.1605 36.967 82.3586 37.0341 82.4832C37.2449 82.8601 37.4653 83.1285 37.7145 83.3425C37.8934 83.4958 38.0914 83.6236 38.3214 83.7194C37.8486 84.0517 37.3823 84.3967 36.9318 84.764C36.0374 85.4923 35.1877 86.2878 34.4242 87.163C33.6575 88.0351 32.9739 88.9871 32.4117 90.0093C31.8431 91.0315 31.4246 92.1304 31.0892 93.2389C30.4248 95.4654 30.0798 97.7399 29.4728 99.9312C28.3036 104.34 26.5179 108.559 24.3617 112.517C22.2022 116.478 19.6755 120.187 16.9857 123.676C14.296 127.164 11.4466 130.438 8.58434 133.562C7.15323 135.124 5.71573 136.648 4.291 138.14C3.7735 138.68 3.2624 139.21 2.76087 139.734C2.71615 139.782 2.67142 139.83 2.6267 139.875C2.4542 140.053 2.31364 140.2 2.2242 140.293C1.65559 140.89 1.39365 141.29 1.03906 141.906C1.64281 141.529 3.10267 140.159 3.15059 140.111C3.65211 139.587 4.16323 139.054 4.68392 138.514C6.11184 137.019 7.54934 135.492 8.98684 133.927C11.8554 130.796 14.7145 127.509 17.417 124.005C20.1163 120.5 22.6623 116.769 24.8377 112.776C27.0131 108.786 28.8148 104.525 29.9967 100.069C30.61 97.8453 30.9582 95.5644 31.6099 93.3922C31.9389 92.3061 32.3414 91.2519 32.8877 90.268C33.4307 89.2842 34.092 88.3642 34.8331 87.5176C35.5742 86.6711 36.3984 85.8949 37.2736 85.1825C38.1521 84.4733 39.0817 83.8312 40.04 83.2339C40.9984 82.6397 41.9854 82.0935 42.9917 81.5855C43.9979 81.0808 45.0234 80.608 46.052 80.1576C48.9717 78.883 51.9521 77.8097 54.9198 76.8067C54.8079 76.9185 54.7025 77.0367 54.6035 77.158C54.431 77.3753 54.2745 77.6053 54.1435 77.8576C54.0125 78.11 53.9071 78.3815 53.8656 78.6882C53.8464 78.8415 53.8432 79.0012 53.8752 79.1673C53.9071 79.3303 53.9742 79.4964 54.0764 79.6369C54.102 79.6689 54.1307 79.704 54.1563 79.736L54.2457 79.8254L54.3448 79.9021C54.3895 79.934 54.4534 79.9724 54.5077 80.0075C54.5332 80.0298 54.562 80.0426 54.5971 80.0299L54.6929 80.0139L54.8239 79.9915L55.022 79.9564C55.5523 79.8573 56.0761 79.7232 56.5936 79.5539C57.6286 79.2216 58.6189 78.7457 59.5453 78.1579C60.0085 77.864 60.4525 77.535 60.8742 77.1772C60.8966 77.158 60.9221 77.1389 60.9445 77.1165C60.9317 77.1517 60.9221 77.1868 60.9093 77.2219C60.756 77.6819 60.5675 78.1547 60.4334 78.6467C60.181 79.5411 59.606 80.3205 58.9863 81.0425C58.357 81.7676 57.7053 82.4768 57.0473 83.1476C56.386 83.8217 55.7024 84.4574 54.9868 85.0324C54.2713 85.6074 53.5206 86.1217 52.7316 86.5242C51.9425 86.9267 51.1088 87.2174 50.2623 87.3419C49.8374 87.4026 49.4125 87.4218 48.9941 87.3962L48.8535 87.3898L48.6842 87.3707L48.352 87.3355L48.0198 87.3004L47.8632 87.2844C47.8888 87.3292 47.9367 87.3835 47.9718 87.4314L48.2082 87.7508L48.3296 87.9137C48.3647 87.968 48.3935 88.016 48.4159 88.0671L48.4542 88.1661C48.4638 88.1853 48.4702 88.2076 48.4734 88.23C48.4829 88.2747 48.4989 88.3162 48.5053 88.361C48.5692 88.7187 48.4925 89.1117 48.3392 89.4662C48.2625 89.6451 48.1635 89.8144 48.0549 89.9742C47.9431 90.1307 47.8153 90.2712 47.6684 90.415C47.0934 90.974 46.3682 91.3989 45.7389 91.9899C45.2086 92.4882 44.7902 93.1111 44.5378 93.7915C44.2854 94.4719 44.1928 95.1907 44.196 95.8935C44.212 97.3054 44.5825 98.6535 45.0457 99.9217C45.2789 100.557 45.5473 101.18 45.8316 101.781C46.1127 102.385 46.3842 102.988 46.6749 103.582C46.9592 104.18 47.2435 104.771 47.5406 105.359C47.6875 105.652 47.8345 105.946 47.9782 106.237C48.1284 106.528 48.2785 106.815 48.4286 107.106C50.8245 111.728 53.4471 116.05 56.2263 120.066C57.2964 121.612 58.3921 123.113 59.5038 124.57C59.1779 124.509 58.8425 124.522 58.5327 124.573C58.0631 124.656 57.6286 124.819 57.2198 125.011C55.5906 125.797 54.3 126.979 52.9328 127.87C52.2492 128.323 51.5464 128.726 50.8341 129.074C50.1249 129.422 49.4061 129.719 48.6874 129.959C47.2467 130.432 45.8124 130.675 44.4611 130.7C43.1099 130.729 41.8513 130.531 40.7556 130.192C40.3179 130.058 39.9123 129.902 39.5289 129.726C39.3181 129.454 39.0721 129.196 38.791 128.953C38.5323 128.726 38.1138 128.403 37.51 128.097C37.3567 128.026 37.2002 127.94 37.0245 127.873C36.9734 127.854 36.9223 127.832 36.8711 127.809C36.8839 127.79 36.8871 127.784 36.868 127.809C36.8296 127.793 36.7945 127.78 36.7561 127.764L36.7466 127.761C36.162 128.627 36.5868 128.004 36.4591 128.202L36.4718 128.215L36.4974 128.24L36.5485 128.295C36.5836 128.33 36.6188 128.368 36.6539 128.407C36.9478 128.697 37.28 129.001 37.6761 129.279C38.1138 129.595 38.6185 129.895 39.1807 130.16C39.4906 130.579 39.7174 131.016 39.8643 131.444C40.1167 132.157 40.1678 132.828 40.1454 133.406C40.1231 133.987 40.0113 134.479 39.8899 134.888C39.7685 135.297 39.628 135.626 39.4938 135.891C39.2286 136.421 39.021 136.706 38.906 136.872C38.8485 136.955 38.807 137.003 38.7846 137.035C38.7623 137.067 38.7527 137.076 38.7527 137.076C38.7527 137.076 38.7175 137.121 38.6473 137.21C38.5738 137.303 38.462 137.437 38.3182 137.613C38.0339 137.967 37.6123 138.491 37.0756 139.162C36.0086 140.507 34.4849 142.443 32.6736 144.832C29.048 149.605 24.2627 156.173 19.6499 163.328C17.3499 166.909 15.0882 170.631 13.0693 174.352C12.9416 174.585 12.817 174.815 12.6892 175.049C12.5678 175.282 12.4432 175.515 12.3218 175.748C12.0791 176.215 11.8363 176.678 11.5967 177.138C11.1367 178.071 10.6639 178.984 10.2391 179.911C10.1304 180.141 10.0218 180.371 9.91642 180.597C9.80781 180.824 9.7024 181.054 9.60337 181.284C9.40212 181.741 9.20087 182.198 9.00281 182.648C8.80475 183.099 8.62906 183.555 8.44698 183.999C8.35753 184.223 8.26489 184.447 8.17545 184.667C8.10517 184.852 8.03809 185.038 7.96781 185.223C7.77934 185.737 7.62281 186.159 7.54614 186.37C7.28101 187.156 7.22989 187.638 7.17878 188.341C7.55892 187.737 7.66753 187.322 7.93906 186.545C8.01573 186.338 8.6099 185.044 8.68017 184.859C8.76962 184.638 8.85906 184.418 8.94851 184.197C9.13059 183.753 9.30628 183.303 9.50114 182.856C9.6992 182.409 9.89725 181.958 10.0953 181.501C10.1943 181.275 10.2966 181.048 10.4052 180.821C10.5106 180.594 10.6192 180.367 10.7278 180.137C11.1495 179.221 11.6191 178.31 12.0759 177.381C12.3154 176.921 12.555 176.461 12.7978 175.997C12.9192 175.767 13.0406 175.534 13.162 175.301C13.2866 175.071 13.4143 174.841 13.5389 174.608C15.5482 170.902 17.8067 167.19 20.1003 163.619C24.7035 156.482 29.4792 149.924 33.0985 145.158C34.9066 142.772 36.4271 140.839 37.4941 139.498C38.0307 138.83 38.4492 138.309 38.7335 137.952C38.8773 137.776 38.9859 137.642 39.0593 137.549C39.1328 137.453 39.1711 137.402 39.1711 137.402C39.1711 137.402 39.1807 137.389 39.2063 137.357C39.2318 137.322 39.2766 137.271 39.3373 137.182C39.4618 137.003 39.6855 136.696 39.9698 136.124C40.1135 135.84 40.2636 135.482 40.3978 135.038C40.5288 134.594 40.6502 134.061 40.6757 133.425C40.7013 132.792 40.6438 132.051 40.3659 131.262C40.2796 131.016 40.171 130.767 40.0368 130.518C40.2157 130.585 40.3978 130.646 40.5863 130.703C41.7363 131.058 43.0524 131.266 44.4611 131.234C45.8667 131.208 47.3585 130.956 48.8471 130.467C49.5914 130.218 50.3325 129.914 51.0641 129.553C51.7956 129.196 52.5175 128.783 53.2203 128.317C53.9327 127.857 54.5939 127.327 55.2839 126.835C55.9707 126.34 56.6799 125.857 57.4402 125.496C57.8203 125.317 58.2132 125.171 58.6125 125.103C59.0086 125.036 59.4111 125.052 59.7593 125.209C59.9223 125.282 60.0756 125.385 60.2257 125.512C60.3152 125.627 60.4046 125.746 60.4941 125.861C60.6793 126.094 60.8806 126.33 61.1074 126.544C61.2927 126.713 61.4971 126.873 61.7303 126.995C61.9156 127.126 62.1328 127.237 62.3756 127.288C62.5225 127.324 62.6088 127.327 62.7206 127.346C62.826 127.362 62.9346 127.381 63.0432 127.403C63.2605 127.442 63.4904 127.496 63.7556 127.499C64.0175 127.509 64.2954 127.432 64.5254 127.324C64.583 127.295 64.6373 127.263 64.6916 127.234L64.8481 127.135L65.1292 126.947L65.685 126.57C65.8384 126.467 65.9885 126.365 66.1418 126.26C66.4485 126.132 66.7488 125.998 67.0491 125.857C68.0872 125.365 69.0839 124.806 70.0295 124.19C70.9686 123.564 71.8791 122.909 72.6872 122.126C73.0898 121.737 73.4667 121.318 73.7957 120.861C74.1216 120.404 74.3995 119.906 74.6007 119.379C74.6518 119.248 74.6902 119.111 74.7381 118.98C74.7732 118.842 74.8116 118.702 74.8371 118.564C74.8882 118.283 74.9202 118.002 74.9202 117.721C74.9234 117.156 74.8307 116.597 74.6423 116.066C74.4474 115.539 74.1471 115.047 73.7446 114.648C73.6488 114.543 73.5306 114.46 73.422 114.37C73.3677 114.322 73.307 114.287 73.2463 114.249L73.1568 114.191C73.1536 114.188 73.1504 114.188 73.1473 114.185L73.2974 114.083C73.3549 114.047 73.4028 114.003 73.4539 113.961L73.7606 113.706L73.9139 113.578L74.0545 113.437L74.3388 113.159C74.4378 113.07 74.5145 112.965 74.6039 112.866L74.8627 112.565C75.0192 112.354 75.1757 112.144 75.3259 111.93C75.7635 111.265 76.1149 110.55 76.3705 109.812C76.3768 109.805 76.3832 109.796 76.3896 109.789C76.6548 109.476 76.872 109.138 77.0445 108.789C77.217 108.441 77.3384 108.083 77.415 107.729C77.4917 107.374 77.5364 107.02 77.5204 106.675C77.5045 105.988 77.3032 105.343 76.9646 104.844C76.8464 104.656 76.7091 104.496 76.5717 104.349C76.5685 104.34 76.5621 104.33 76.5589 104.32C76.5398 104.276 76.5174 104.25 76.495 104.215C76.4503 104.145 76.4024 104.1 76.3577 104.042C76.3098 103.995 76.2618 103.943 76.2107 103.902C76.0798 103.787 75.9456 103.685 75.8082 103.595C75.5335 103.314 75.3163 103.052 75.2013 102.79C74.9298 102.209 75.1214 101.707 75.2492 101.397C75.3195 101.241 75.3802 101.123 75.4217 101.043C75.4632 100.963 75.4856 100.925 75.4856 100.925C75.4856 100.925 75.5175 100.87 75.5814 100.759C75.6485 100.647 75.7443 100.481 75.8753 100.26C75.9424 100.148 76.0127 100.021 76.0861 99.8674C76.1213 99.7907 76.166 99.714 76.198 99.6278C76.2299 99.5415 76.265 99.4521 76.3002 99.3594C76.4312 98.9825 76.5461 98.5321 76.5845 98.0114C76.6228 97.4907 76.5941 96.8965 76.4024 96.2704C76.3513 96.1139 76.3034 95.9542 76.2267 95.8008C76.1884 95.7242 76.1596 95.6411 76.1149 95.5644C76.0702 95.4878 76.0223 95.4111 75.9775 95.3344C75.936 95.2546 75.8753 95.1843 75.8178 95.1108C75.7571 95.0406 75.7092 94.9607 75.6389 94.8936C75.5718 94.8265 75.5016 94.7594 75.4313 94.6924C75.3642 94.6221 75.2779 94.571 75.1981 94.5103C75.1182 94.4496 75.0384 94.3889 74.9457 94.3474C74.8563 94.2994 74.7668 94.2515 74.6742 94.2036C74.5816 94.1653 74.4889 94.1269 74.3931 94.0918C74.3356 94.0726 74.2781 94.0535 74.2206 94.0343C74.1823 93.9768 74.1439 93.9161 74.1088 93.8554C73.8628 93.4433 73.6999 92.9801 73.6009 92.4978C73.4028 91.5299 73.4539 90.498 73.505 89.4599C73.5306 88.9392 73.5625 88.4121 73.5466 87.869C73.5306 87.3292 73.4699 86.7893 73.3485 86.2526C73.2271 85.7192 73.045 85.1889 72.7543 84.7001C72.4668 84.2146 72.0643 83.7737 71.5596 83.4767C71.0613 83.1732 70.4607 83.039 69.8825 83.0582C69.5918 83.071 69.3075 83.1189 69.0296 83.1924C68.9817 83.2083 68.9306 83.2211 68.8827 83.2371C68.723 82.8282 68.6175 82.3937 68.5568 81.9497C68.477 81.3907 68.4514 80.8189 68.4323 80.2407C68.4163 79.6625 68.4099 79.0779 68.3747 78.4869L68.3396 78.0429C68.3236 77.8928 68.3045 77.7394 68.2789 77.5925C68.2278 77.2922 68.1543 76.9983 68.0585 76.7108C67.87 76.1358 67.6081 75.58 67.2503 75.0816C66.8925 74.5865 66.4357 74.1329 65.848 73.8614C65.5573 73.7272 65.241 73.6378 64.9152 73.6186C64.8353 73.6122 64.7523 73.609 64.6724 73.6154C64.6309 73.6186 64.5925 73.6154 64.551 73.6186L64.3657 73.6378C64.2954 73.6505 64.206 73.6314 64.1868 73.7208L64.1645 73.7592C63.7843 73.6953 63.4106 73.6505 62.8931 73.6314C62.7813 73.6282 62.6152 73.6218 62.4107 73.609C62.3085 73.6026 62.1935 73.5962 62.0753 73.5899H62.0625L61.676 73.5611C61.5195 73.5515 61.363 73.5387 61.2064 73.5228C60.5771 73.4717 59.9478 73.395 59.3185 73.3119C59.1045 73.2832 58.8936 73.2512 58.6796 73.2161L58.7531 73.2129C58.801 73.2097 58.8489 73.1969 58.8936 73.1905L59.0342 73.1618L59.1524 73.1299C59.7913 72.9637 60.427 72.7912 61.0723 72.6315C61.7175 72.4782 62.3596 72.3089 63.0113 72.1651C63.3371 72.0917 63.663 72.015 63.9888 71.9415C64.3146 71.8712 64.6436 71.8042 64.9727 71.7339C65.6275 71.5901 66.292 71.4751 66.9564 71.3473C68.2853 71.1142 69.6302 70.9129 70.991 70.7564C73.7095 70.4433 76.4823 70.3283 79.2934 70.2165C82.1045 70.1047 84.9443 69.9833 87.8098 69.9865C90.6752 69.9897 93.5693 70.1111 96.4443 70.5647C97.8818 70.7883 99.3161 71.0758 100.738 71.4496C101.095 71.539 101.447 71.6444 101.801 71.7403C102.156 71.8361 102.511 71.9447 102.862 72.0533C103.213 72.1619 103.578 72.2641 103.907 72.3855C104.242 72.5133 104.568 72.6635 104.887 72.836C105.491 73.1618 106.06 73.5515 106.619 73.97C106.845 74.2255 107.079 74.4715 107.315 74.7111C107.852 75.251 108.414 75.7557 108.986 76.2412L109.203 76.4233C109.273 76.484 109.347 76.5447 109.427 76.6022C109.506 76.6597 109.583 76.7236 109.663 76.7779L109.912 76.9376C110.251 77.1357 110.605 77.3114 110.982 77.4264C111.727 77.6692 112.535 77.7458 113.317 77.5829C113.33 77.5797 113.346 77.5765 113.359 77.5733C113.499 77.5829 113.637 77.5893 113.781 77.5893C114.177 77.5893 114.592 77.5446 114.991 77.4072C115.189 77.3369 115.384 77.2443 115.56 77.1197C115.646 77.059 115.723 76.9983 115.806 76.9376C115.883 76.8705 115.962 76.8066 116.036 76.7396C116.333 76.468 116.595 76.1582 116.815 75.8228C117.259 75.1583 117.563 74.4108 117.754 73.6473C117.949 72.8839 118.042 72.1012 118.071 71.3186C118.154 68.2615 117.994 65.1725 117.681 62.0771ZM76.888 106.141C76.888 106.081 76.8816 106.02 76.8784 105.959C76.9423 106.196 76.9838 106.451 76.9902 106.719C77.0029 107.017 76.9646 107.33 76.8975 107.643C76.8784 107.726 76.8592 107.812 76.8336 107.895C76.9039 107.31 76.9263 106.723 76.888 106.141ZM90.7678 4.0436C90.9275 3.69221 91.1096 3.35679 91.3364 3.05013C91.7836 2.43679 92.3555 1.89374 93.0167 1.53596C93.6748 1.17499 94.435 0.999293 95.1474 1.15582C95.8661 1.31235 96.5178 1.74999 97.1056 2.25791C97.4027 2.51027 97.6838 2.79138 97.9617 3.07249C98.0991 3.21624 98.246 3.34721 98.3738 3.49735L98.7699 3.93818C99.8209 5.12332 100.747 6.42346 101.597 7.76832C103.293 10.4644 104.699 13.3426 105.951 16.2751C107.197 19.214 108.286 22.2136 109.267 25.2419C110.244 28.2735 111.11 31.3337 111.867 34.41C112.247 35.9497 112.583 37.4926 112.924 39.0419C113.266 40.588 113.605 42.131 113.947 43.6707C115.065 48.7978 116.106 53.9153 116.78 59.036C116.525 57.6496 116.199 56.2855 115.825 54.9439C115.448 53.5862 115.03 52.251 114.598 50.9285C114.448 50.4717 114.301 50.018 114.154 49.5644C114.068 49.2162 113.985 48.8712 113.902 48.5358C113.765 48.0055 113.653 47.5743 113.599 47.3571C113.423 46.6926 113.247 46.2837 112.995 45.811C111.564 40.9746 110.327 36.1989 108.899 31.6117C108.519 30.369 108.114 29.1455 107.695 27.9349C107.27 26.7242 106.829 25.539 106.389 24.3603C105.507 22.006 104.593 19.7028 103.593 17.4858C102.594 15.2689 101.511 13.1286 100.211 11.1576C100.041 10.9149 99.8752 10.6721 99.7091 10.4325C99.5398 10.1929 99.3577 9.95652 99.1564 9.72971C98.9552 9.5061 98.7348 9.28568 98.4792 9.1036C98.2236 8.91832 97.9298 8.77457 97.6103 8.6979C97.2909 8.62124 96.9523 8.62763 96.6424 8.7011C96.3293 8.77457 96.0386 8.90874 95.7799 9.07804C95.2624 9.41985 94.8599 9.9054 94.6043 10.4548C94.3488 10.9979 94.221 11.5761 94.1603 12.1447C94.0996 12.7133 94.0996 13.2787 94.1124 13.8282C94.1379 14.3776 94.1507 14.9271 94.1954 15.4669C94.2178 15.7385 94.2306 16.01 94.2561 16.2783C94.2817 16.5467 94.3073 16.815 94.3328 17.0801C94.3775 17.5305 94.4318 17.9746 94.4861 18.4186C94.0421 16.6137 93.5661 14.6747 93.055 12.6015C92.5343 10.4804 91.9753 8.21554 91.3843 5.80374C91.3077 5.49388 91.231 5.18402 91.1543 4.87096C91.0777 4.56749 91.0042 4.25443 90.9275 3.95415C90.8509 4.03402 90.7742 4.11707 90.7007 4.19693C90.7231 4.14902 90.7454 4.09471 90.7678 4.0436ZM103.079 53.27C103.073 53.2572 103.066 53.2412 103.057 53.2285C103.06 53.139 103.066 53.0464 103.07 52.9569C103.156 52.2158 103.558 51.561 104.034 50.9987C104.507 50.4301 105.047 49.9254 105.536 49.3951C105.612 49.3121 105.689 49.229 105.763 49.1428C105.817 49.1428 105.868 49.1396 105.922 49.1364C106.229 49.1172 106.545 49.0597 106.858 48.9192L106.973 48.8617L107.05 48.8265C107.123 48.7946 107.194 48.7658 107.27 48.7211C107.309 48.7019 107.347 48.6828 107.382 48.6604L107.491 48.5869C107.564 48.539 107.628 48.4815 107.692 48.4208C107.948 48.178 108.136 47.8746 108.251 47.5583C108.28 47.4785 108.312 47.3986 108.344 47.3187C108.366 47.2389 108.385 47.1558 108.404 47.076C108.424 46.9929 108.446 46.913 108.465 46.83C108.484 46.7469 108.491 46.6639 108.503 46.5808C108.692 45.2519 108.523 43.8783 108.283 42.4664C108.213 42.115 108.142 41.7604 108.069 41.4026C108.037 41.2237 107.992 41.0448 107.948 40.866C107.903 40.6871 107.861 40.505 107.817 40.3229C107.654 39.601 107.443 38.8439 107.143 38.1092C106.839 37.3744 106.456 36.6493 105.925 35.9912C105.66 35.6654 105.357 35.3587 105.005 35.0936C104.654 34.8348 104.255 34.6112 103.811 34.493C103.37 34.3653 102.894 34.3461 102.437 34.426C102.207 34.4675 101.984 34.5282 101.769 34.6144C101.552 34.6943 101.357 34.7933 101.166 34.87C100.977 34.9467 100.795 35.0074 100.626 35.0105C100.457 35.0169 100.3 34.9722 100.15 34.8828C99.8464 34.6975 99.6036 34.3397 99.3928 33.966C98.5367 32.4167 97.8723 30.6853 97.2909 28.874C96.7127 27.0596 96.2303 25.1525 95.8246 23.1751C95.4221 21.1978 95.0835 19.1469 94.8727 17.0322C94.8471 16.7671 94.8216 16.5019 94.796 16.2368C94.7705 15.9717 94.7577 15.7033 94.7353 15.435C94.6906 14.8983 94.6778 14.3617 94.6523 13.8186C94.6363 13.2787 94.6395 12.7389 94.697 12.2086C94.7545 11.6783 94.8727 11.1608 95.0931 10.688C95.3103 10.2248 95.6521 9.81277 96.0802 9.53165C96.5018 9.25054 97.0161 9.10999 97.4921 9.22499C97.9713 9.33679 98.3961 9.6786 98.7571 10.0907C98.9392 10.2983 99.1117 10.5187 99.2778 10.7519C99.4407 10.9883 99.6037 11.2247 99.7698 11.4611C101.044 13.3873 102.118 15.5085 103.111 17.7094C104.101 19.9136 105.012 22.204 105.89 24.5519C106.331 25.7275 106.769 26.9158 107.19 28.1137C107.606 29.318 108.008 30.5351 108.388 31.7714C109.925 36.7164 111.244 41.8946 112.832 47.1494C113.087 47.9928 113.356 48.8425 113.63 49.689C113.634 49.705 113.64 49.721 113.643 49.7369C113.739 50.1139 113.825 50.4972 113.915 50.8901C114.1 51.6696 114.269 52.4746 114.445 53.2923C114.784 54.9279 115.078 56.621 115.308 58.2853C115.359 58.7005 115.423 59.1126 115.464 59.5247C115.509 59.9368 115.55 60.3425 115.592 60.745C115.653 61.55 115.726 62.3358 115.748 63.0929C115.793 63.85 115.79 64.5751 115.799 65.2587C115.803 65.6005 115.787 65.9328 115.78 66.2522C115.768 66.5717 115.774 66.8815 115.748 67.1754C115.729 67.4693 115.713 67.7504 115.694 68.0187C115.678 68.2871 115.665 68.5394 115.637 68.7726C115.589 69.2454 115.544 69.6543 115.509 69.9897C115.461 70.3187 115.426 70.5743 115.384 70.7436C115.349 70.9129 115.33 71.0055 115.33 71.0055C115.33 71.0055 115.304 71.0918 115.256 71.2579C115.244 71.2994 115.234 71.3474 115.215 71.3953C115.196 71.4432 115.177 71.4975 115.154 71.555C115.116 71.6732 115.052 71.7978 114.985 71.9383C114.841 72.2098 114.621 72.5133 114.26 72.673C114.17 72.7146 114.068 72.7433 113.959 72.7689C113.899 72.7817 113.838 72.7944 113.774 72.804C113.742 72.8104 113.704 72.8168 113.666 72.8264L113.583 72.8455C113.423 72.8775 113.177 72.804 112.915 72.6858C112.391 72.4718 111.858 72.1523 111.353 71.7211C110.845 71.2962 110.382 70.7564 109.96 70.143C109.535 69.5329 109.161 68.8493 108.82 68.1242C108.478 67.399 108.168 66.6324 107.877 65.8465C107.293 64.2749 106.785 62.6265 106.187 61.0485C106.04 60.6523 105.878 60.2626 105.718 59.8825C105.558 59.5055 105.402 59.1318 105.251 58.7612C104.951 58.0201 104.67 57.2918 104.405 56.5954C104.082 55.7521 103.785 54.9854 103.539 54.3401C103.463 54.1453 103.402 53.9887 103.36 53.8865C103.264 53.6533 103.175 53.4521 103.082 53.27C103.185 53.2604 103.22 53.254 103.079 53.27ZM97.7828 31.8225C98.1246 32.653 98.4984 33.458 98.9232 34.2279C99.0382 34.4292 99.1628 34.6304 99.313 34.8221C99.4631 35.0137 99.642 35.1958 99.8688 35.3364C100.096 35.4769 100.377 35.5568 100.648 35.544C100.92 35.5312 101.156 35.4482 101.37 35.3619C101.584 35.2757 101.776 35.1767 101.961 35.1096C102.146 35.0361 102.338 34.985 102.53 34.9498C102.913 34.886 103.303 34.9019 103.67 35.0074C104.038 35.1064 104.379 35.2949 104.689 35.5217C104.996 35.7549 105.271 36.0296 105.513 36.3267C105.999 36.9272 106.363 37.614 106.651 38.3104C106.938 39.01 107.136 39.7224 107.302 40.4475C107.347 40.6264 107.389 40.8053 107.43 40.981C107.475 41.1567 107.516 41.3355 107.548 41.5112C107.618 41.8626 107.689 42.214 107.759 42.5558C107.813 42.9008 107.864 43.2426 107.916 43.5812C107.96 43.9198 107.986 44.2553 108.021 44.5843C108.034 44.7504 108.034 44.9133 108.04 45.0762C108.043 45.1561 108.047 45.2392 108.05 45.319C108.053 45.3989 108.056 45.4819 108.05 45.5586C108.043 45.7183 108.037 45.8748 108.031 46.0314C108.031 46.1112 108.021 46.1879 108.008 46.2646C107.999 46.3412 107.989 46.4179 107.976 46.4914C107.964 46.568 107.96 46.6447 107.944 46.7182C107.925 46.7917 107.909 46.8619 107.89 46.9354C107.871 47.0057 107.855 47.0792 107.836 47.1494C107.81 47.2165 107.785 47.2836 107.759 47.3475C107.663 47.6158 107.513 47.8426 107.331 48.0183C107.286 48.063 107.242 48.1078 107.187 48.1397L107.111 48.194C107.085 48.21 107.053 48.2228 107.028 48.2387C106.973 48.2707 106.909 48.2962 106.845 48.325L106.721 48.3825L106.638 48.424C106.516 48.4783 106.385 48.5167 106.248 48.5454C106.347 48.408 106.44 48.2611 106.532 48.1205C106.615 47.964 106.699 47.8075 106.775 47.651C107.059 47.0153 107.2 46.3572 107.254 45.7279C107.312 45.0986 107.283 44.4948 107.213 43.923C107.143 43.3512 107.034 42.8146 106.903 42.3067C106.769 41.7987 106.615 41.3228 106.456 40.8724C106.293 40.4283 106.133 40.0035 105.967 39.6042C105.635 38.8055 105.29 38.0932 104.903 37.483C104.712 37.1764 104.507 36.8985 104.277 36.6525C104.223 36.5886 104.162 36.5311 104.101 36.4768L104.012 36.3937C103.983 36.365 103.926 36.3267 103.884 36.2979C103.693 36.1861 103.504 36.1637 103.338 36.1605C103.006 36.1605 102.728 36.234 102.479 36.3171C102.229 36.4033 102.006 36.5023 101.805 36.6078C101.402 36.8186 101.083 37.0454 100.824 37.2722C100.568 37.499 100.37 37.7258 100.239 37.959C100.105 38.1858 100.051 38.4542 100.099 38.6714L100.105 38.7097L100.112 38.7353C100.115 38.7512 100.121 38.7672 100.124 38.7832C100.134 38.8151 100.14 38.8439 100.147 38.8694C100.163 38.9237 100.172 38.9685 100.185 39.01C100.227 39.1665 100.239 39.2176 100.239 39.2176C100.239 39.2176 100.332 39.5658 100.514 40.243C100.693 40.9203 100.958 41.9265 101.278 43.2458C101.437 43.9071 101.61 44.645 101.782 45.4628C101.869 45.8717 101.955 46.2997 102.035 46.7469C102.054 46.8587 102.073 46.9705 102.095 47.0855C102.124 47.2229 102.162 47.3667 102.229 47.4944C102.354 47.7532 102.543 47.964 102.75 48.1429C103.169 48.5007 103.67 48.7371 104.204 48.9032C104.485 48.9894 104.775 49.0533 105.079 49.0948C104.622 49.5836 104.111 50.066 103.629 50.6442C103.376 50.9476 103.13 51.2735 102.935 51.6504C102.872 51.7718 102.814 51.8996 102.76 52.0305C102.683 51.7207 102.606 51.4076 102.527 51.0882C102.316 50.2353 102.102 49.3568 101.875 48.4464C100.98 44.8047 99.9678 40.6935 98.8274 36.0519C98.5878 35.0904 98.2428 33.6849 97.7828 31.8225ZM106.066 47.8554C105.977 47.9864 105.897 48.1237 105.801 48.2547C105.711 48.3729 105.619 48.4911 105.52 48.6061C105.12 48.5901 104.724 48.5135 104.357 48.4017C103.878 48.2547 103.431 48.0343 103.095 47.7468C102.929 47.603 102.788 47.4401 102.705 47.2708C102.661 47.1846 102.638 47.0983 102.619 47.0089C102.6 46.8939 102.578 46.7789 102.559 46.6639C102.479 46.2103 102.389 45.7758 102.303 45.3637C102.13 44.5396 101.955 43.7953 101.795 43.134C101.472 41.8083 101.207 40.7989 101.028 40.1185C100.846 39.4412 100.754 39.0899 100.754 39.0899C100.754 39.0899 100.741 39.0419 100.699 38.8822C100.69 38.8439 100.677 38.796 100.661 38.7417C100.655 38.7161 100.645 38.6874 100.639 38.6554C100.635 38.6394 100.629 38.6235 100.626 38.6075L100.619 38.5851V38.5723C100.607 38.5053 100.61 38.3903 100.706 38.2305C100.881 37.9111 101.329 37.4767 102.051 37.0965C102.233 37.0007 102.431 36.9112 102.648 36.8378C102.862 36.7643 103.102 36.7068 103.325 36.7068C103.437 36.7068 103.542 36.7292 103.606 36.7675C103.613 36.7739 103.619 36.7803 103.629 36.7835C103.635 36.7899 103.641 36.7898 103.657 36.8058L103.731 36.8761C103.782 36.924 103.833 36.9719 103.881 37.0262C104.079 37.2371 104.268 37.4926 104.446 37.7801C104.811 38.3487 105.143 39.0355 105.469 39.8182C105.632 40.2079 105.791 40.6232 105.951 41.064C106.108 41.5017 106.254 41.9617 106.382 42.4472C106.507 42.936 106.612 43.4503 106.676 43.9933C106.743 44.5332 106.769 45.105 106.714 45.6864C106.663 46.2678 106.532 46.8651 106.28 47.4337C106.213 47.5775 106.143 47.7149 106.066 47.8554ZM60.8167 76.5223C60.7177 76.6118 60.6218 76.7012 60.5196 76.7843C60.1171 77.1261 59.6923 77.4392 59.2482 77.7203C58.3602 78.2825 57.4114 78.7393 56.4211 79.0587C55.926 79.2185 55.4245 79.3462 54.9166 79.4421C54.8303 79.458 54.6961 79.4804 54.661 79.4868C54.661 79.4868 54.661 79.4868 54.6578 79.4836L54.6003 79.4389L54.5492 79.3878L54.5045 79.3335C54.3959 79.1897 54.3639 78.9916 54.3927 78.7744C54.4214 78.5604 54.5045 78.3336 54.6163 78.1228C54.7249 77.9087 54.8623 77.7043 55.0156 77.5158C55.1689 77.3242 55.3382 77.1453 55.5203 76.9887C55.7024 76.8322 55.9036 76.6917 56.1177 76.5607C56.3125 76.4393 56.5138 76.3275 56.7214 76.2221C57.3348 76.0176 57.9513 75.8164 58.5614 75.6183L58.9511 75.4905L59.146 75.4267C59.2099 75.4075 59.2642 75.3915 59.3249 75.3755C59.5645 75.3148 59.82 75.2861 60.0692 75.2893C60.3056 75.2925 60.542 75.3212 60.7496 75.3915C60.8007 75.4139 60.8486 75.4362 60.887 75.465C61.0371 75.564 61.117 75.7046 61.1457 75.9026C61.1553 75.9729 61.1553 76.0528 61.1521 76.1294C61.1298 76.1805 61.101 76.2285 61.0659 76.2764C61.0339 76.3179 61.002 76.3562 60.9604 76.3914L60.8167 76.5223ZM70.8664 122.404C70.5374 122.672 70.1828 122.918 69.8186 123.164C69.4545 123.41 69.0871 123.66 68.7198 123.906C67.985 124.401 67.2439 124.899 66.5028 125.401C66.2984 125.538 66.0907 125.678 65.8863 125.816C65.6818 125.902 65.4774 125.985 65.2698 126.068C65.0046 126.174 64.7395 126.269 64.468 126.362C64.1996 126.455 63.9281 126.547 63.6629 126.618C63.1327 126.758 62.5864 126.816 62.1264 126.614C62.0881 126.598 62.0529 126.579 62.0178 126.56C62.0114 126.557 62.005 126.554 62.0018 126.547C61.6824 126.305 61.3981 125.969 61.0946 125.637C60.9477 125.477 60.7911 125.314 60.6218 125.161C59.277 123.433 57.9513 121.641 56.6639 119.778C53.8943 115.782 51.2877 111.479 48.9014 106.876C48.7513 106.588 48.6043 106.301 48.4542 106.01C48.3104 105.72 48.1635 105.429 48.0166 105.135C47.7227 104.554 47.4384 103.963 47.1541 103.368C46.8666 102.777 46.595 102.174 46.3171 101.573C46.036 100.973 45.7773 100.369 45.5473 99.7492C45.0936 98.5129 44.7423 97.216 44.7295 95.9031C44.7263 95.2514 44.8125 94.5965 45.0361 93.9928C45.2598 93.389 45.6271 92.8428 46.0999 92.3955C46.6653 91.8589 47.3936 91.434 48.0357 90.8143C48.1923 90.661 48.352 90.4885 48.4861 90.3C48.6171 90.1115 48.7321 89.9071 48.828 89.693C48.9206 89.479 48.9877 89.249 49.0292 89.0126C49.0675 88.7762 49.0771 88.5271 49.0292 88.2779C49.0196 88.214 49.0005 88.1533 48.9845 88.0926C48.9749 88.0607 48.9685 88.0319 48.9557 88L48.9366 87.9553C48.9366 87.9521 48.9334 87.9489 48.9334 87.9489C48.9366 87.9489 48.943 87.9489 48.9557 87.9489C49.4125 87.9744 49.8757 87.9553 50.3325 87.8882C51.2493 87.754 52.1374 87.441 52.9711 87.0193C53.8049 86.5944 54.5843 86.061 55.3223 85.4668C56.0602 84.8726 56.7566 84.2242 57.4274 83.5373C57.6829 83.2786 57.9321 83.0135 58.1813 82.7483C57.8427 83.1668 57.5009 83.5789 57.1559 83.9878C56.4116 84.8503 55.6481 85.6904 54.8591 86.505L54.2585 87.1055C54.0605 87.3068 53.8528 87.4985 53.6484 87.6933C53.4471 87.8914 53.2363 88.0798 53.0286 88.2683L52.706 88.5622C52.6453 88.6005 52.6102 88.6868 52.5942 88.7219L52.5463 88.8178L52.4505 89.0094C52.1981 89.5269 51.9649 90.054 51.7796 90.6099C51.687 90.8878 51.6103 91.1753 51.5624 91.4755C51.5145 91.7726 51.5017 92.0921 51.572 92.4179C51.6103 92.5808 51.6742 92.7405 51.7605 92.8875C51.8467 93.0344 51.9585 93.1622 52.0799 93.274C52.3227 93.4912 52.5878 93.635 52.8338 93.7756L53.2043 93.9832C53.3864 94.0854 53.5749 94.0982 53.7442 94.1014C54.0828 94.0886 54.3767 93.9928 54.6546 93.8842C55.0156 93.7372 55.351 93.5519 55.6704 93.3507C55.8302 93.2708 55.9867 93.191 56.1464 93.1111C56.6352 92.8779 57.1016 92.5968 57.5743 92.3349C57.8139 92.2071 58.0343 92.0537 58.2643 91.91C58.4911 91.7631 58.7243 91.6257 58.9448 91.4755C59.7849 90.9069 60.5899 90.2904 61.3598 89.6387C61.2064 89.7793 61.0499 89.9199 60.8966 90.0604C59.2674 91.5362 57.6159 93.0089 55.9324 94.4656C55.0891 95.1939 54.2425 95.9158 53.3705 96.6154C52.4984 97.3022 51.5688 98.0657 50.997 99.1294C50.8532 99.3946 50.7414 99.6789 50.6616 99.9728C50.62 100.12 50.5945 100.27 50.5721 100.423L50.553 100.66C50.5466 100.739 50.5561 100.816 50.5561 100.896C50.5913 101.525 50.8436 102.119 51.2366 102.605C51.4378 102.845 51.6838 103.055 51.9681 103.209C52.2492 103.362 52.5814 103.461 52.9168 103.448C52.9999 103.455 53.0861 103.432 53.1692 103.426C53.2107 103.42 53.2554 103.416 53.2938 103.407L53.4056 103.375C53.4184 103.372 53.4311 103.365 53.4439 103.362C53.6292 103.458 53.8177 103.544 54.0157 103.621C54.1595 103.675 54.3096 103.723 54.4693 103.758C54.6291 103.793 54.7984 103.812 54.9645 103.803C55.2584 103.793 55.5363 103.72 55.7918 103.618C55.6385 103.72 55.4852 103.828 55.335 103.937C55.1945 104.042 55.0507 104.148 54.907 104.257C54.7664 104.365 54.6163 104.467 54.4821 104.586C54.3448 104.701 54.2074 104.819 54.0668 104.934L53.8592 105.109C53.8305 105.135 53.8017 105.161 53.7761 105.186C53.7698 105.189 53.7634 105.196 53.757 105.199C53.3992 105.464 53.0606 105.777 52.7923 106.17C52.7763 106.192 52.7635 106.218 52.7475 106.243C52.6677 106.352 52.591 106.467 52.5271 106.595C52.4313 106.787 52.3674 107.01 52.361 107.234C52.3482 107.687 52.5239 108.103 52.7667 108.435C53.0095 108.773 53.3289 109.048 53.6835 109.259C54.3959 109.677 55.2552 109.834 56.0857 109.697H56.0889C56.4563 109.709 56.8236 109.697 57.1878 109.662C58.1078 109.575 59.0118 109.371 59.8999 109.099C60.1267 109.029 60.3535 108.956 60.5771 108.879C60.5675 108.885 60.5579 108.892 60.5484 108.901C60.2066 109.157 59.8871 109.432 59.59 109.732C59.4431 109.882 59.2993 110.038 59.1652 110.208C59.0981 110.294 59.0342 110.38 58.9735 110.479L58.9288 110.553L58.8873 110.633L58.8457 110.716L58.817 110.802L58.7627 110.974C58.7499 111.035 58.7435 111.096 58.7371 111.157L58.7243 111.246L58.7275 111.339C58.7307 111.399 58.7307 111.46 58.7371 111.521C58.7786 111.76 58.8649 111.987 58.9927 112.179C59.2354 112.552 59.5868 112.818 59.967 112.993L59.9702 112.997C60.0404 113.054 60.1139 113.096 60.1874 113.147C60.4845 113.329 60.7975 113.46 61.1106 113.549C61.2671 113.6 61.4268 113.629 61.5834 113.667C61.7399 113.699 61.8964 113.722 62.053 113.747C62.6791 113.83 63.2892 113.843 63.8866 113.827C65.0813 113.795 66.2153 113.645 67.295 113.46C68.1224 113.319 68.9146 113.15 69.6781 112.968C69.4896 113.316 69.4098 113.702 69.4034 114.083C69.397 114.511 69.4768 114.936 69.6334 115.338C69.7132 115.539 69.8091 115.734 69.9305 115.916C69.9911 116.009 70.055 116.098 70.1189 116.178C70.1828 116.261 70.2467 116.344 70.3106 116.421C70.8313 117.063 71.4127 117.644 71.8535 118.312C72.0707 118.644 72.2496 118.996 72.3359 119.369C72.4221 119.74 72.4253 120.13 72.3167 120.497C72.2113 120.868 72.0132 121.216 71.7577 121.532C71.5021 121.852 71.1954 122.139 70.8664 122.404ZM52.7571 91.7055C52.7635 91.4755 52.8338 91.2392 52.9296 91.0124C53.0286 90.7856 53.1564 90.5619 53.3066 90.3543C53.6068 89.9326 53.9774 89.5493 54.3767 89.1947C54.776 88.8433 55.2073 88.5207 55.6577 88.2332C55.7695 88.1629 55.8845 88.0926 55.9995 88.0287C56.0282 88.0128 56.057 87.9968 56.0857 87.9808C56.0985 87.9744 56.1049 87.9712 56.1049 87.9712L56.1975 87.9872C56.4531 88.0383 56.7023 88.1118 56.9386 88.2076C57.4146 88.4025 57.8459 88.6964 58.1302 89.0989C58.1653 89.1468 58.2005 89.1979 58.2292 89.2522C58.2611 89.3033 58.2899 89.3576 58.3123 89.4151C58.3378 89.4694 58.3634 89.5269 58.3793 89.5844L58.4017 89.6515C58.4017 89.6579 58.4017 89.6419 58.3985 89.6707C58.4017 89.7154 58.3793 89.7729 58.3698 89.824C58.3474 89.8783 58.3346 89.9326 58.3091 89.9901C58.2611 90.1019 58.2005 90.2137 58.1302 90.3224C57.8555 90.7632 57.4849 91.1689 57.0984 91.5458C56.7086 91.9228 56.287 92.2742 55.843 92.5936C55.7024 92.6926 55.5586 92.7917 55.4117 92.8843C55.335 92.9226 55.2552 92.961 55.1785 92.9993C54.9357 93.1079 54.6898 93.2165 54.447 93.3251L54.1786 93.4433C54.1467 93.4274 54.0253 93.3699 53.9454 93.3315C53.8368 93.2644 53.725 93.2069 53.6196 93.1367C53.5206 93.0632 53.412 92.9961 53.3257 92.913C52.9584 92.5936 52.7348 92.1655 52.7571 91.7055ZM51.671 101.113C51.5432 100.893 51.457 100.653 51.4761 100.449C51.4793 100.398 51.4921 100.35 51.5049 100.302C51.5273 100.247 51.5464 100.193 51.5752 100.139C51.6327 100.027 51.703 99.9185 51.7828 99.8099C52.1023 99.3818 52.5207 99.0017 52.968 98.679C53.4184 98.3596 53.9071 98.0944 54.4214 97.9315C54.9357 97.7686 55.4756 97.7079 55.9803 97.8165C56.2327 97.8708 56.4691 97.9698 56.6895 98.104L56.8141 98.1903C56.8141 98.1903 56.8141 98.1903 56.8173 98.1935L56.8556 98.2797C56.8779 98.3372 56.8939 98.3979 56.9163 98.4586C56.9323 98.5193 56.945 98.58 56.9578 98.6407C57.0473 99.1358 56.9291 99.6629 56.6895 100.132C56.4499 100.605 56.1049 101.037 55.7056 101.407C55.3063 101.781 54.8591 102.107 54.3799 102.369C54.1403 102.5 53.8943 102.618 53.642 102.717C53.5973 102.736 53.5493 102.752 53.5046 102.768C53.2554 102.624 53.0127 102.461 52.7827 102.286C52.345 101.957 51.9361 101.56 51.671 101.113ZM52.69 102.899C52.3003 102.835 51.933 102.589 51.6614 102.266C51.4474 102.001 51.2845 101.688 51.1886 101.359C51.195 101.369 51.1982 101.378 51.2046 101.388C51.5336 101.937 51.9777 102.353 52.4505 102.726C52.5271 102.784 52.607 102.841 52.69 102.899ZM56.255 104.755C56.4403 104.742 56.6224 104.748 56.7725 104.793L56.8779 104.835L56.993 104.902C57.0313 104.924 57.0728 104.943 57.1079 104.972L57.2134 105.055C57.4913 105.282 57.7021 105.589 57.8331 105.93C58.0982 106.614 58.0535 107.422 57.7085 108.039C57.5392 108.345 57.2868 108.601 56.9898 108.793C56.7086 108.975 56.386 109.093 56.0538 109.154C55.5555 109.131 55.0667 109.058 54.5971 108.927C54.4949 108.904 54.3959 108.866 54.2968 108.831C54.1978 108.796 54.0988 108.761 54.0029 108.722L53.7218 108.588L53.6036 108.531L53.5174 108.451C53.4823 108.416 53.4439 108.384 53.4088 108.349L53.3129 108.24C53.2427 108.17 53.2011 108.087 53.1436 108.01C53.0542 107.847 52.9743 107.681 52.9584 107.505C52.9392 107.33 52.9488 107.154 52.9999 106.978C53.0478 106.828 53.1149 106.681 53.2011 106.541C53.2267 106.505 53.2554 106.47 53.2842 106.438C53.3928 106.311 53.5206 106.186 53.6484 106.061C53.7761 105.937 53.9039 105.815 54.0285 105.694C54.0573 105.668 54.086 105.64 54.1148 105.611C54.431 105.387 54.7696 105.199 55.1242 105.049C55.4948 104.902 55.8813 104.784 56.255 104.755ZM59.7849 111.888L59.7913 111.834C59.8009 111.763 59.8009 111.693 59.82 111.623L59.8743 111.415C59.9702 111.141 60.1107 110.875 60.2992 110.636C60.3407 110.572 60.3982 110.521 60.4493 110.46C60.5004 110.403 60.5516 110.345 60.6091 110.294L60.7784 110.134L60.9636 109.987C61.216 109.799 61.4907 109.63 61.7878 109.505C61.9316 109.435 62.0881 109.39 62.2382 109.336C62.3149 109.313 62.3948 109.297 62.4714 109.275C62.5098 109.265 62.5481 109.256 62.5896 109.246L62.7078 109.227C62.7877 109.217 62.8675 109.198 62.9474 109.195L63.187 109.182C63.2668 109.179 63.3467 109.189 63.4266 109.192C63.4649 109.195 63.5064 109.195 63.5448 109.198L63.6502 109.217C63.9345 109.278 64.1932 109.444 64.3689 109.681C64.4552 109.799 64.5223 109.933 64.5606 110.074C64.5957 110.214 64.6053 110.361 64.5861 110.505C64.5702 110.649 64.5095 110.786 64.436 110.914L64.3753 111.006C64.3561 111.038 64.3242 111.067 64.2986 111.096C64.2507 111.157 64.1868 111.211 64.1261 111.268C63.8738 111.492 63.5703 111.68 63.2509 111.85C62.9314 112.019 62.596 112.169 62.251 112.303C61.906 112.434 61.545 112.559 61.1968 112.632C60.887 112.693 60.5516 112.655 60.2417 112.533L60.1299 112.437L59.9957 112.284C59.9478 112.236 59.9223 112.172 59.8807 112.115C59.8392 112.061 59.82 111.993 59.7913 111.933L59.7721 111.891C59.7881 111.891 59.7849 111.885 59.7849 111.888ZM73.3804 114.939C73.735 115.36 74.0066 115.849 74.1727 116.376C74.1759 116.383 74.1759 116.386 74.1759 116.392C74.4697 117.296 74.4634 118.315 74.1024 119.222C73.9203 119.702 73.668 120.155 73.3645 120.58C73.0578 121.005 72.7032 121.401 72.3199 121.772C72.2432 121.848 72.1634 121.919 72.0835 121.992C72.1186 121.954 72.1538 121.915 72.1857 121.874C72.4764 121.516 72.716 121.104 72.847 120.647C72.9811 120.19 72.9811 119.698 72.8725 119.248C72.7639 118.794 72.5531 118.382 72.3135 118.018C71.8279 117.287 71.2338 116.699 70.7386 116.086C70.6173 115.932 70.4895 115.776 70.3936 115.629C70.2946 115.475 70.2116 115.312 70.1477 115.146C70.0167 114.808 69.9464 114.45 69.9528 114.099C69.9592 113.75 70.0423 113.409 70.2116 113.143C70.2978 113.009 70.4032 112.901 70.5278 112.814C70.5598 112.792 70.5885 112.773 70.6236 112.757C70.6524 112.738 70.6843 112.725 70.7163 112.712C70.7866 112.693 70.8536 112.677 70.9239 112.658L70.9335 112.683C70.9559 112.728 70.975 112.773 70.9942 112.814C71.0773 112.981 71.1539 113.112 71.2146 113.201C71.4606 113.575 71.7321 113.811 72.0068 113.98C72.1091 114.044 72.2113 114.095 72.3167 114.143C72.3071 114.15 72.2975 114.156 72.2911 114.162C72.4604 114.223 72.6298 114.284 72.7831 114.392C73.0035 114.543 73.2048 114.728 73.3804 114.939ZM74.8786 111.661C74.7381 111.862 74.5911 112.061 74.4442 112.259L74.2014 112.54C74.1184 112.632 74.0449 112.731 73.9523 112.814L73.6871 113.076L73.553 113.207L73.4092 113.326L73.1217 113.565C73.0738 113.603 73.0259 113.645 72.9748 113.68L72.8055 113.798C72.716 113.859 72.6266 113.923 72.5371 113.984C72.4381 113.878 72.3455 113.776 72.2528 113.674C72.058 113.45 71.8631 113.227 71.6586 112.907C71.6075 112.83 71.5436 112.719 71.4702 112.575C71.4606 112.556 71.451 112.533 71.4414 112.514C72.0292 112.348 72.5978 112.172 73.1409 111.962C73.9746 111.642 74.7477 111.243 75.4057 110.744C75.2524 111.057 75.0767 111.364 74.8786 111.661ZM75.3195 103.943C75.3706 103.975 75.4249 104.007 75.476 104.039C75.4952 104.058 75.5143 104.078 75.5335 104.097C75.7188 104.282 75.9168 104.464 76.1085 104.662L76.1373 104.793C76.1852 105.02 76.2523 105.244 76.2746 105.477C76.3066 105.71 76.3481 105.94 76.3513 106.176C76.4248 107.304 76.2682 108.467 75.8977 109.569C75.6805 109.815 75.4345 110.045 75.1598 110.259C74.5368 110.744 73.7861 111.134 72.9556 111.457C72.3391 111.693 71.6746 111.894 70.9782 112.086C70.9367 112.092 70.892 112.099 70.8504 112.105L70.745 112.131C70.7195 112.137 70.6939 112.147 70.6684 112.153C70.6173 112.169 70.563 112.185 70.515 112.211C70.515 112.211 70.515 112.211 70.5118 112.211C70.4256 112.233 70.3361 112.259 70.2467 112.281C69.2852 112.524 68.2725 112.751 67.2088 112.933C66.1482 113.115 65.0334 113.258 63.877 113.29C63.2988 113.306 62.7142 113.29 62.1296 113.214C61.9859 113.191 61.8389 113.169 61.6952 113.14C61.6441 113.127 61.5929 113.118 61.5386 113.105C61.8581 113.022 62.1552 112.917 62.4554 112.805C62.8196 112.664 63.1742 112.508 63.516 112.326C63.8578 112.144 64.19 111.939 64.4935 111.671C64.567 111.601 64.6437 111.537 64.7107 111.454C64.7459 111.412 64.781 111.377 64.8129 111.332L64.9056 111.195C65.0174 111.006 65.1005 110.802 65.1292 110.582C65.158 110.364 65.1452 110.144 65.0909 109.933C65.0334 109.725 64.9343 109.531 64.8098 109.361C64.5574 109.019 64.1805 108.78 63.7716 108.694L63.6182 108.665C63.5671 108.658 63.5224 108.658 63.4745 108.655C63.3786 108.652 63.2828 108.639 63.187 108.642L62.9027 108.655C62.8068 108.658 62.7174 108.681 62.6248 108.694L62.4874 108.716C62.4427 108.726 62.398 108.738 62.3532 108.748C62.2638 108.77 62.1743 108.789 62.0849 108.818C61.9124 108.879 61.7367 108.933 61.5706 109.01C61.2352 109.15 60.9253 109.342 60.6378 109.556L60.427 109.722L60.2321 109.904C60.165 109.962 60.1043 110.029 60.0468 110.099C59.9893 110.166 59.9254 110.23 59.8743 110.304C59.6539 110.585 59.4814 110.907 59.3632 111.249L59.2929 111.511C59.2929 111.517 59.293 111.521 59.2898 111.527C59.2834 111.502 59.277 111.473 59.2706 111.447C59.2674 111.409 59.2674 111.371 59.2642 111.332L59.261 111.275L59.2706 111.217C59.277 111.179 59.2802 111.141 59.2866 111.102L59.3249 110.99C59.3728 110.843 59.475 110.7 59.59 110.55C59.7082 110.403 59.8392 110.259 59.9766 110.118C60.2513 109.84 60.5548 109.578 60.871 109.342C61.0307 109.227 61.1936 109.115 61.3598 109.023C61.4428 108.978 61.5227 108.936 61.6089 108.908L61.8964 108.789C62.2829 108.633 62.6727 108.473 63.0624 108.313C64.6277 107.675 66.2313 107.017 67.8764 106.346C69.5216 105.675 71.2018 104.985 72.9236 104.282C73.3549 104.106 73.7861 103.931 74.2206 103.752L74.3835 103.685L74.4666 103.653C74.4857 103.646 74.4825 103.656 74.4921 103.65C74.54 103.65 74.6359 103.656 74.7317 103.688C74.9266 103.736 75.131 103.835 75.3195 103.943ZM74.7189 103.039C74.7317 103.068 74.7477 103.1 74.7636 103.129L74.6806 103.113L74.6263 103.103L74.5656 103.1L74.5017 103.097C74.4825 103.097 74.4602 103.097 74.4314 103.1C74.3835 103.107 74.3196 103.119 74.2813 103.132L74.1982 103.164L74.0353 103.231C73.6009 103.41 73.1664 103.586 72.7384 103.761C71.0166 104.464 69.3331 105.154 67.6911 105.825C66.7616 106.205 65.8479 106.579 64.9439 106.949C64.9854 106.927 65.027 106.908 65.0717 106.886C66.7552 106.01 68.4099 105.036 70.087 104.055C70.5054 103.812 70.9271 103.567 71.3488 103.324C71.7705 103.078 72.1985 102.848 72.6298 102.583C73.4795 102.059 74.2972 101.458 75.0032 100.711C74.9904 100.733 74.9745 100.765 74.9521 100.807C74.9074 100.89 74.8403 101.021 74.7605 101.203C74.6838 101.385 74.5911 101.624 74.5496 101.941C74.5081 102.26 74.5336 102.659 74.7189 103.039ZM73.8948 94.523C74.128 94.8425 74.3899 95.1268 74.6391 95.4015C74.9809 95.7785 75.3099 96.1458 75.5335 96.5579C75.7571 96.9636 75.8689 97.4236 75.8561 97.8772C75.8402 98.334 75.6932 98.7812 75.4728 99.1965C75.2492 99.6118 74.9521 99.9919 74.6231 100.343C73.9618 101.043 73.1728 101.627 72.3486 102.135C71.9398 102.388 71.5053 102.621 71.0804 102.867C70.6556 103.113 70.2339 103.359 69.8154 103.602C68.1384 104.582 66.4868 105.55 64.8225 106.419C63.1582 107.285 61.4748 108.064 59.7529 108.591C59.0118 108.818 58.2611 108.994 57.5105 109.09C57.7788 108.876 58.0152 108.614 58.1845 108.307C58.6125 107.528 58.6605 106.579 58.341 105.742C58.1813 105.327 57.9193 104.934 57.5552 104.64L57.4178 104.531C57.3699 104.496 57.3188 104.471 57.2677 104.439L57.1143 104.352C57.0568 104.327 56.993 104.301 56.9291 104.279C56.6799 104.205 56.4435 104.202 56.2135 104.218C56.073 104.228 55.9324 104.25 55.7982 104.279C56.8748 103.522 57.996 102.889 59.0949 102.298C60.2449 101.685 61.3789 101.113 62.4554 100.529C63.532 99.9408 64.5542 99.3371 65.4934 98.6822C65.7234 98.5129 65.9502 98.3436 66.1738 98.1743L66.3399 98.0497L66.4996 97.9156C66.605 97.8261 66.7105 97.7367 66.8159 97.6504C66.9213 97.561 67.0267 97.4747 67.1289 97.3853C67.2279 97.299 67.327 97.2096 67.426 97.1233C67.6241 96.9508 67.8221 96.7879 68.0202 96.6282C68.8124 95.9893 69.6174 95.4462 70.4288 95.0501C70.8345 94.8521 71.2434 94.6924 71.6491 94.5805C72.0547 94.4719 72.4573 94.408 72.847 94.3985C73.2143 94.3921 73.5657 94.4368 73.8948 94.523ZM73.5146 93.9001C73.2942 93.8714 73.0706 93.8554 72.8406 93.8586C72.3998 93.8682 71.9525 93.9385 71.5085 94.0599C71.0645 94.1844 70.6268 94.3537 70.1956 94.5646C69.3331 94.9862 68.4993 95.5517 67.6848 96.2065C67.4803 96.3694 67.2791 96.5387 67.0778 96.7144C66.9788 96.8039 66.8766 96.8901 66.7743 96.9796C66.6753 97.0626 66.5731 97.1489 66.4709 97.2351C66.3686 97.3214 66.2664 97.4076 66.1642 97.4939L66.0109 97.6249L65.848 97.7462C65.6307 97.9092 65.4103 98.0721 65.1867 98.2382C64.2731 98.8771 63.27 99.4712 62.2031 100.049C61.1361 100.631 60.0053 101.199 58.8457 101.819C58.4624 102.024 58.0791 102.234 57.6893 102.455C59.5134 101.19 61.3406 99.9249 63.171 98.6567C65.0845 97.331 67.0043 96.0021 68.921 94.6732C69.8825 94.0215 70.86 93.3155 71.6778 92.4339C72.0867 91.993 72.4604 91.5075 72.7384 90.9548C72.8118 90.8079 72.8789 90.6514 72.9364 90.4949C72.9205 91.2008 72.9396 91.9164 73.0834 92.6287C73.1696 93.0664 73.3102 93.4976 73.5146 93.9001ZM69.183 83.7386C69.4225 83.6747 69.6685 83.6332 69.9113 83.6236C70.4 83.6108 70.8824 83.7194 71.2945 83.9686C71.7098 84.2146 72.0452 84.5787 72.2975 85.0004C72.5499 85.4253 72.716 85.9044 72.831 86.3964C72.9428 86.8915 73.0003 87.3994 73.0163 87.9074C73.0227 88.0607 73.0195 88.2172 73.0195 88.3737C73.0003 88.3162 72.9843 88.2587 72.962 88.2044C72.863 87.901 72.7032 87.6262 72.5339 87.3643C72.1761 86.8532 71.7321 86.4347 71.2913 86.045C70.8473 85.6585 70.3968 85.2911 69.9975 84.895C69.643 84.55 69.3459 84.1762 69.1191 83.7546C69.1414 83.7514 69.1606 83.745 69.183 83.7386ZM68.4802 84.0069C68.5217 83.9846 68.5664 83.9654 68.6079 83.9462C68.8667 84.4478 69.2213 84.9014 69.6142 85.2815C70.0423 85.7032 70.4991 86.0769 70.9335 86.4539C71.3648 86.834 71.7737 87.2237 72.0867 87.671C72.2337 87.8978 72.371 88.131 72.4509 88.3865C72.5467 88.6357 72.5946 88.9008 72.6106 89.1628C72.6393 89.693 72.4988 90.2265 72.2496 90.7153C72.0036 91.2072 71.6586 91.6544 71.2753 92.0697C70.8888 92.485 70.4607 92.8619 70.0135 93.2197C69.5663 93.5775 69.0903 93.9001 68.6079 94.2324C66.6913 95.5612 64.7714 96.8901 62.8579 98.2158C60.9445 99.5415 59.031 100.867 57.1207 102.19C56.6384 102.519 56.1784 102.867 55.6896 103.081C55.4468 103.186 55.1945 103.257 54.9485 103.263C54.7057 103.273 54.4598 103.212 54.2042 103.116C54.185 103.11 54.1659 103.1 54.1467 103.094C54.3128 103.02 54.4757 102.94 54.6355 102.851C55.153 102.563 55.6353 102.215 56.0698 101.81C56.501 101.404 56.8875 100.931 57.1654 100.382C57.4402 99.8386 57.5999 99.1901 57.4817 98.5512C57.4625 98.4714 57.4498 98.3947 57.4274 98.3148C57.4018 98.2382 57.3795 98.1615 57.3507 98.0881L57.3028 97.9762C57.2677 97.9251 57.2709 97.8293 57.1974 97.8037L56.9674 97.6472C56.6991 97.4811 56.3988 97.3597 56.0889 97.2926C55.466 97.1553 54.8271 97.2351 54.2489 97.4204C53.6675 97.6057 53.1341 97.8964 52.6453 98.2446C52.2652 98.5193 51.9074 98.826 51.5911 99.1837C51.8275 98.8004 52.1214 98.4458 52.4505 98.12C52.6421 97.9283 52.8466 97.7462 53.0574 97.5705C53.1628 97.4811 53.2714 97.3949 53.3768 97.3118L53.7059 97.0467C54.5843 96.3407 55.4373 95.6155 56.2806 94.884C57.9673 93.4242 59.622 91.9483 61.2543 90.4693C62.8835 88.9903 64.4935 87.5176 66.0684 86.0194L66.6562 85.454C66.851 85.2624 67.0491 85.0579 67.2248 84.8822C67.6049 84.534 68.0234 84.2273 68.4802 84.0069ZM68.3907 83.4543C68.3428 83.4767 68.2917 83.499 68.2438 83.5246C67.7327 83.7706 67.2727 84.1092 66.8606 84.4957L66.2856 85.0739L65.7042 85.6329C64.7523 86.5401 63.7811 87.4378 62.8004 88.3386C63.1391 88.0064 63.4681 87.6646 63.7875 87.3164C63.96 87.1183 64.1357 86.9171 64.3082 86.719L64.567 86.4219L64.8129 86.1121C64.9759 85.9044 65.1388 85.7 65.3017 85.4924C65.4614 85.2847 65.6084 85.0675 65.7617 84.8567L65.9885 84.5372C66.0652 84.4318 66.1386 84.3232 66.2089 84.2146C66.3495 83.9942 66.49 83.7769 66.6306 83.5565C66.7009 83.4479 66.7743 83.3393 66.8382 83.2275L67.0331 82.8889L67.1417 82.7004C67.2759 82.4608 67.4068 82.2468 67.5027 82.0583C67.5985 81.8699 67.6752 81.7197 67.7263 81.6175C67.8093 81.4514 67.8828 81.298 67.9435 81.1543C67.9882 81.9242 68.1032 82.6972 68.3907 83.4543ZM64.468 74.3853L64.5734 74.1936C64.5734 74.1904 64.5734 74.1904 64.5766 74.1904C64.5798 74.1904 64.5893 74.1904 64.6053 74.1872C64.6373 74.184 64.6692 74.184 64.7011 74.184C64.765 74.1808 64.8289 74.184 64.8928 74.1872C65.1484 74.2 65.3975 74.2703 65.6339 74.3789C66.1067 74.5961 66.506 74.9826 66.8223 75.4235C67.1417 75.8675 67.3813 76.3754 67.5538 76.9025C67.8924 77.9503 67.8732 79.0939 67.902 80.263C67.8541 80.3333 67.8061 80.4036 67.7582 80.4739C67.5985 80.7358 67.4292 81.0073 67.2407 81.3715C67.1896 81.4705 67.1161 81.6175 67.0203 81.7996C66.9277 81.9817 66.7967 82.1925 66.6657 82.4289L66.5603 82.6142L66.3718 82.9464C66.3079 83.055 66.2345 83.1604 66.1674 83.269C66.03 83.483 65.8927 83.6971 65.7553 83.9143C65.6882 84.0229 65.6148 84.1283 65.5413 84.2305L65.3177 84.5436C65.1675 84.7512 65.0238 84.9653 64.8673 85.1665C64.7075 85.3678 64.5478 85.569 64.3881 85.7703L64.1485 86.0737L63.8929 86.3644C63.7236 86.5593 63.5543 86.7542 63.3818 86.949C61.9859 88.4792 60.3886 89.8496 58.6413 91.0347C58.4241 91.1849 58.1973 91.319 57.9736 91.4628C57.9385 91.4819 57.9066 91.5043 57.8746 91.5267C58.1366 91.2424 58.3825 90.9453 58.5934 90.6067C58.6732 90.4821 58.7435 90.3479 58.8074 90.2042C58.8393 90.1339 58.8649 90.054 58.8905 89.9773C58.9096 89.8911 58.9352 89.8176 58.9384 89.7218C58.932 89.6835 58.9671 89.5972 58.932 89.5365L58.8873 89.4056C58.8649 89.3321 58.833 89.2586 58.801 89.1883C58.7723 89.1149 58.7339 89.0478 58.6924 88.9807C58.6541 88.9104 58.6125 88.8465 58.5678 88.7858C58.2068 88.2779 57.6829 87.9297 57.1399 87.7061C56.8652 87.5943 56.5841 87.5112 56.2998 87.4537L56.1879 87.4346C56.1209 87.4314 56.0506 87.3931 55.9867 87.4154L55.8238 87.5017C55.7918 87.5176 55.7599 87.5336 55.7279 87.5528C55.6034 87.623 55.482 87.6965 55.3606 87.77C54.8814 88.0735 54.431 88.4121 54.0093 88.7858C53.5877 89.1596 53.1916 89.5685 52.8561 90.038C52.6868 90.2712 52.5399 90.5268 52.4217 90.7983C52.3035 91.0699 52.2173 91.3669 52.2045 91.6832C52.1917 91.9962 52.2588 92.3221 52.3993 92.6032C52.4984 92.8044 52.6293 92.9833 52.7795 93.1398C52.6517 93.06 52.5335 92.9801 52.4313 92.8875C52.2524 92.7278 52.1406 92.5393 52.0863 92.3125C52.0384 92.0857 52.0416 91.8301 52.0831 91.5714C52.1246 91.3126 52.1917 91.0507 52.278 90.7919C52.4505 90.2744 52.6741 89.7633 52.92 89.2586L53.0127 89.0701L53.0606 88.9775C53.067 88.9647 53.067 88.9615 53.0702 88.9615L53.3768 88.6836C53.5877 88.4919 53.8017 88.3003 54.0061 88.099C54.2106 87.901 54.4214 87.7061 54.6227 87.5017L55.2296 86.8915C56.0282 86.0705 56.8013 85.2208 57.552 84.3487C58.2963 83.4703 59.0214 82.579 59.721 81.659C60.4142 80.7358 61.0978 79.803 61.7367 78.8383C62.0657 78.3624 62.3724 77.8704 62.6886 77.3848L63.1454 76.6437L63.3723 76.2732L63.5927 75.8962L64.0335 75.1423L64.468 74.3853ZM105.159 72.3887C104.82 72.2066 104.472 72.0469 104.111 71.9096C103.744 71.7754 103.392 71.6764 103.034 71.5646C102.677 71.456 102.322 71.3441 101.964 71.2483C101.607 71.1493 101.249 71.0439 100.888 70.9544C99.4503 70.5775 97.9968 70.2836 96.5402 70.06C93.6268 69.6032 90.7007 69.4818 87.8225 69.4754C84.9411 69.4722 82.0949 69.5936 79.2838 69.7054C76.4727 69.8204 73.6839 69.9322 70.9431 70.2485C69.5727 70.405 68.215 70.6062 66.8766 70.8426C66.2089 70.9704 65.5381 71.0886 64.88 71.2323C64.551 71.3026 64.2188 71.3729 63.8898 71.44C63.5607 71.5135 63.2349 71.5901 62.9059 71.6636C62.251 71.8074 61.6025 71.9767 60.9573 72.1332C60.312 72.2929 59.6699 72.4686 59.031 72.6315L58.9128 72.6635L58.8106 72.6826C58.7755 72.689 58.7435 72.6986 58.7084 72.7018L58.6029 72.7082C58.4624 72.7178 58.3154 72.7018 58.1653 72.6794C57.865 72.6315 57.5616 72.5389 57.2421 72.4462C56.9227 72.36 56.5873 72.2642 56.2135 72.2546C56.0634 72.2546 55.91 72.2642 55.7599 72.3025C55.6609 72.3696 55.5586 72.4271 55.466 72.5005C55.4628 72.5037 55.4404 72.5197 55.4404 72.5229C55.4277 72.5357 55.4117 72.5485 55.3989 72.5612C55.3957 72.5644 55.367 72.5996 55.3638 72.5996C55.3574 72.6124 55.3478 72.6219 55.3414 72.6347C55.3382 72.6411 55.3286 72.6666 55.3286 72.6666C55.3254 72.6794 55.3223 72.6954 55.3191 72.7018C55.3191 72.7114 55.3159 72.7497 55.3159 72.7561C55.3159 72.7625 55.3159 72.7657 55.3159 72.7657C55.3159 72.7689 55.3191 72.7721 55.3191 72.7753C55.3382 72.8583 55.3574 72.8967 55.4213 72.9829C55.4373 73.0053 55.4309 72.9957 55.45 73.0212C55.4564 73.0308 55.466 73.0404 55.4756 73.05C56.0953 73.264 56.7182 73.4205 57.3443 73.5483C57.9832 73.6793 58.6221 73.7879 59.261 73.8742C59.8999 73.9604 60.5388 74.0371 61.1745 74.0882C61.3342 74.1042 61.4939 74.1169 61.6536 74.1265L62.0466 74.1553H62.0593C62.1839 74.1617 62.2957 74.168 62.4011 74.1744C62.612 74.1872 62.7781 74.1936 62.8931 74.1936C63.3275 74.2032 63.6693 74.184 63.992 74.1329L63.5799 74.874L63.1454 75.6183L62.9282 75.9921L62.7014 76.3594L62.2478 77.0942C61.9316 77.5733 61.6313 78.0621 61.3055 78.5348C61.1361 78.7904 60.9605 79.046 60.7848 79.2983C60.8486 79.1418 60.9061 78.9789 60.9541 78.8128C61.0786 78.3496 61.2607 77.896 61.4204 77.4136C61.5003 77.174 61.577 76.9249 61.6345 76.6661C61.6632 76.5287 61.6856 76.3882 61.6984 76.2412C61.7111 76.2061 61.7207 76.171 61.7303 76.1358C61.7686 75.9697 61.7814 75.7812 61.7239 75.5928C61.6696 75.4043 61.5482 75.2414 61.4109 75.1296C61.2735 75.0146 61.1234 74.9411 60.9732 74.8868C60.9604 74.8836 60.9477 74.8804 60.9349 74.874C60.8838 74.8517 60.8295 74.8357 60.7784 74.8197C60.6378 74.775 60.4973 74.7526 60.3599 74.7367C59.8041 74.6824 59.2706 74.7622 58.7563 74.8836C58.242 75.005 57.7436 75.1743 57.2581 75.3787C57.0089 75.4842 56.7598 75.596 56.517 75.7205C52.9584 76.8961 49.3614 78.1419 45.8316 79.6785C44.7934 80.1321 43.7648 80.608 42.7457 81.1192C41.7299 81.6335 40.7268 82.1861 39.7525 82.793C39.3053 83.071 38.8613 83.3649 38.4268 83.6651C38.2575 83.4767 38.1361 83.2914 38.0116 83.0965C37.855 82.8506 37.6953 82.5854 37.51 82.2436C37.4525 82.1318 37.3567 81.9497 37.2641 81.7229C37.2161 81.6079 37.1714 81.4833 37.1267 81.3492C37.1139 81.3172 37.1043 81.2821 37.0948 81.2469L37.0788 81.1958L37.0724 81.1703L37.0149 80.9562C36.9702 80.7742 36.935 80.5921 36.9127 80.4068C36.8679 80.0394 36.8711 79.6689 36.9606 79.3303C37.0053 79.161 37.0692 79.0044 37.1586 78.8671L37.2289 78.768L37.3184 78.6626C37.3791 78.5924 37.4398 78.5221 37.5068 78.4582C37.7688 78.193 38.0659 77.9599 38.3853 77.7554C39.0274 77.3497 39.7557 77.0622 40.5 76.8162C41.2475 76.5735 42.0206 76.353 42.7841 76.1198C43.5507 75.8898 44.3174 75.6599 45.0841 75.4267C46.6206 74.9635 48.1603 74.5003 49.7064 74.0371C50.4795 73.8039 51.2525 73.5707 52.0256 73.3375L53.1884 72.9893L53.2427 72.9733C53.2427 72.9765 53.2427 72.9765 53.2459 72.9797C53.2746 72.9574 53.3002 72.9318 53.3257 72.9094C53.3257 72.9062 53.3289 72.903 53.3289 72.903C53.3321 72.8967 53.3385 72.8807 53.3385 72.8775C53.3225 72.7817 53.2874 72.6155 53.2523 72.4846C53.2491 72.4814 53.2395 72.4686 53.2363 72.4654C53.2235 72.4526 53.2139 72.4398 53.2011 72.4271C53.1979 72.4239 53.1916 72.4175 53.1884 72.4143L53.1277 72.4175L52.8242 72.4367L52.2173 72.475C48.9845 72.6922 45.707 72.9925 42.5221 73.8518C40.9345 74.283 39.3724 74.858 37.9093 75.6407L37.6346 75.7844C37.542 75.8323 37.4557 75.8898 37.3663 75.9442L36.8328 76.2668L36.5677 76.4297C36.4814 76.484 36.3984 76.5479 36.3121 76.6086L35.8042 76.9696L35.5518 77.1516C35.4688 77.2123 35.3921 77.2826 35.3123 77.3497L34.8331 77.749C34.5073 78.0078 34.2166 78.308 33.9163 78.5636C33.616 78.8223 33.3093 79.0555 32.9707 79.1961C32.6353 79.343 32.2648 79.391 31.8942 79.3718C31.5205 79.3494 31.1435 79.26 30.7825 79.1226C30.6004 79.0555 30.4216 78.9757 30.2491 78.8894L29.7316 78.5987C28.3771 77.7746 27.3102 76.5319 26.4573 75.1743C25.6011 73.8103 24.9399 72.3249 24.3106 70.8267C23.6877 69.3221 23.0679 67.8143 22.5025 66.2937C21.9435 64.7732 21.4356 63.2367 21.0682 61.6714C20.9692 61.2817 20.8957 60.8855 20.8127 60.4958C20.7456 60.0997 20.6657 59.7068 20.6178 59.3107C20.4996 58.5185 20.4453 57.723 20.4166 56.9244C20.3782 55.3304 20.5348 53.7364 20.7999 52.1647C20.9309 51.3789 21.0938 50.5962 21.2695 49.82L21.4068 49.2386L21.442 49.0917L21.458 49.0182C21.4643 48.9926 21.4707 48.9735 21.4739 48.9383C21.4835 48.8712 21.4995 48.8074 21.4963 48.7339L21.4931 48.6285C21.4899 48.5933 21.4803 48.5582 21.4739 48.523C21.4164 48.2419 21.2088 48.0055 20.9564 47.8873C20.8286 47.8298 20.6881 47.8011 20.5443 47.8043C20.4006 47.8139 20.2536 47.8458 20.1323 47.9257C20.0652 47.9576 20.0173 48.0087 19.9629 48.0535C19.915 48.1014 19.8703 48.1589 19.832 48.2068L19.6659 48.4655L19.3336 48.983C19.2314 49.1587 19.142 49.344 19.0429 49.5229C18.9503 49.705 18.8449 49.8807 18.7714 50.0692C18.6149 50.4429 18.4392 50.8135 18.3178 51.2L18.1198 51.775L17.9632 52.3596C17.5511 53.9217 17.3723 55.5253 17.3595 57.1193C17.3435 58.7133 17.4841 60.2946 17.7396 61.8471C17.7971 62.2368 17.8834 62.6201 17.9536 63.0067C18.0367 63.39 18.1229 63.7733 18.2124 64.1535C18.4009 64.9105 18.6021 65.6644 18.8225 66.4087C19.7074 69.3828 20.8159 72.2801 22.3652 74.9155C23.1478 76.2253 24.0518 77.4711 25.1635 78.5221C25.7193 79.046 26.3327 79.5123 27.0035 79.8861C27.0866 79.9372 27.1728 79.9787 27.2591 80.0203L27.39 80.0842C27.3932 80.0873 27.3932 80.0873 27.3964 80.0873C27.3741 80.0937 27.2942 80.1161 27.0546 80.1832C25.6618 80.5729 24.2211 80.7678 22.79 80.8987C21.3557 81.0265 19.9246 81.0872 18.4999 81.1607C17.0688 81.2278 15.6664 81.3747 14.2896 81.3396C13.6028 81.3236 12.9224 81.2629 12.2643 81.1223C11.6063 80.985 10.977 80.7614 10.3892 80.4547C9.21364 79.8414 8.25212 78.8862 7.43753 77.8544C6.62615 76.813 5.97767 75.663 5.43462 74.4843C4.89156 73.3023 4.45712 72.0853 4.10253 70.8618C3.74795 69.6383 3.47003 68.4085 3.26559 67.1818C3.16336 66.5685 3.07712 65.9583 3.01003 65.3482C2.93976 64.738 2.88545 64.1279 2.84073 63.5242C2.75448 62.3167 2.71295 61.1251 2.80878 59.9623C2.84712 59.381 2.93976 58.8123 3.05476 58.2533C3.12823 57.9786 3.17934 57.7007 3.27517 57.4355C3.3199 57.3014 3.35823 57.1672 3.40614 57.0362C3.46045 56.9085 3.51156 56.7775 3.56586 56.6497C3.59142 56.5858 3.61698 56.5219 3.64573 56.458L3.74156 56.2728C3.80545 56.1514 3.86614 56.0268 3.93003 55.9054C4.0035 55.7904 4.07698 55.6754 4.15045 55.5604L4.25906 55.3879L4.38364 55.225C4.69989 54.7842 5.08003 54.3976 5.49211 54.0558C6.50475 53.2221 7.71545 52.6598 8.93892 52.1743C10.172 51.6951 11.4178 51.2351 12.6381 50.7719C13.2514 50.5419 13.8616 50.3119 14.4685 50.0819C14.772 49.9669 15.0755 49.8519 15.3789 49.7401C15.6824 49.6251 15.9891 49.5069 16.2925 49.3696C16.596 49.229 16.8963 49.0725 17.1742 48.8712C17.4553 48.6732 17.7141 48.4272 17.9185 48.1397C18.1293 47.8522 18.2667 47.5328 18.3817 47.2229C18.4935 46.913 18.583 46.6032 18.682 46.3125C18.781 46.0218 18.8864 45.7407 19.0334 45.4979C19.1803 45.2551 19.3656 45.0507 19.5892 44.8814C20.0364 44.5492 20.621 44.399 21.1673 44.4661C21.7135 44.53 22.1991 44.8494 22.5281 45.2967C22.6942 45.5203 22.8188 45.7726 22.8955 46.0378C22.9338 46.1719 22.9657 46.3061 22.9785 46.4403C22.9881 46.5073 22.9945 46.5776 22.9945 46.6447L22.9977 46.7469L22.9721 46.9705C22.9625 47.0472 22.9561 47.1175 22.9466 47.1973L22.9114 47.4337L22.8923 47.5519C22.8667 47.6158 22.9466 47.5487 22.9689 47.5519L23.1861 47.4753C23.4193 47.3954 23.6493 47.3123 23.8825 47.2325C24.17 47.1335 24.4575 47.0312 24.745 46.9322C25.3168 46.7246 25.8822 46.5105 26.4477 46.3029C27.0099 46.0825 27.5657 45.8653 28.1216 45.6448C28.6742 45.418 29.2236 45.1912 29.7699 44.9676C34.1335 43.134 38.2448 41.1694 42.1899 39.256C44.1609 38.2944 46.0935 37.3521 47.9878 36.4257C48.4606 36.1957 48.9334 35.9657 49.403 35.7389C49.8693 35.5025 50.3357 35.2661 50.7989 35.0329C51.2621 34.7965 51.7221 34.5697 52.1789 34.3301C52.6293 34.0842 53.0766 33.8382 53.5206 33.5954C57.0824 31.6404 60.3886 29.5768 63.5 27.5164C66.6018 25.44 69.5024 23.3572 72.2304 21.3096C73.5817 20.2682 74.9106 19.2651 76.1756 18.2397C77.4566 17.2367 78.6673 16.2112 79.862 15.2242C80.4561 14.729 81.0279 14.2211 81.6029 13.7292C81.8873 13.4832 82.1716 13.2372 82.4527 12.9944C82.737 12.7517 83.0053 12.4993 83.28 12.2533C83.8263 11.7614 84.3629 11.2726 84.8964 10.7935C85.4171 10.3015 85.9314 9.81277 86.4361 9.3336C86.6885 9.09402 86.9409 8.85443 87.19 8.61804C87.4328 8.37527 87.6756 8.13249 87.9152 7.8929C88.3911 7.41054 88.8703 6.94415 89.3271 6.46499C89.423 6.36277 89.5156 6.26054 89.6114 6.15832C89.5475 6.5736 89.5028 6.99207 89.4709 7.40735C89.4389 7.80985 89.4166 8.21235 89.3974 8.61166L89.3559 9.81596L89.3367 10.4165V11.0171L89.3335 12.2214C89.3654 13.825 89.423 15.4286 89.5571 17.0226C89.736 19.3418 90.0107 21.6514 90.3589 23.9418C90.097 22.9643 89.8255 21.9453 89.5475 20.8975C89.391 20.3353 89.2377 19.773 89.0588 19.2076C89.0364 19.1374 89.0141 19.0671 88.9885 18.9936L88.9054 18.7604C88.8575 18.6294 88.7905 18.4985 88.7329 18.3675L88.6882 18.2685L88.6659 18.2205L88.6531 18.195C88.6499 18.1822 88.6435 18.1822 88.6371 18.1886L88.4582 18.3036C88.158 18.508 87.8577 18.7125 87.5542 18.9169C86.5799 19.5846 85.6024 20.2554 84.6185 20.9294C82.6603 22.2711 80.683 23.6255 78.712 24.9736L78.827 24.8746C80.1495 23.7437 81.4624 22.6321 82.7306 21.5332C83.9924 20.4247 85.1743 19.2811 86.1454 18.0608C86.8227 17.2047 87.4168 16.2847 87.8449 15.2912C87.896 15.1762 87.9439 15.058 87.9886 14.9398C88.0877 14.7514 88.1803 14.5597 88.2634 14.3617C88.3624 14.1189 88.4454 13.8697 88.5029 13.611C88.5636 13.3522 88.6052 13.0871 88.6148 12.8187C88.6243 12.5504 88.618 12.2789 88.5732 12.0105C88.5668 11.9435 88.5509 11.8764 88.5381 11.8093L88.5221 11.7294C88.5253 11.7294 88.5253 11.7262 88.5221 11.7262L88.5189 11.7103L88.5125 11.6847C88.7905 11.6368 88.5189 11.6719 88.2698 11.7103C88.2793 11.6943 88.2889 11.6815 88.2953 11.6687C88.2634 11.6879 88.2378 11.7039 88.2059 11.7198C88.0557 11.7422 87.9311 11.7646 87.9759 11.7614V11.7997C87.8545 11.8189 87.8034 11.8285 87.9759 11.8093C87.9759 11.8253 87.9759 11.8412 87.9759 11.854C87.5255 12.1255 87.1677 12.3779 86.6693 12.8283C86.5863 12.9018 86.4617 13.0168 86.3084 13.1542C86.2317 13.2244 86.1454 13.3011 86.056 13.381C85.6056 13.7835 85.1488 14.1923 84.6824 14.6076C84.1489 15.0868 83.6059 15.5724 83.066 16.0803C82.5229 16.585 81.9927 17.1153 81.456 17.6455C80.9161 18.1758 80.3699 18.7093 79.8109 19.246C77.5843 21.3894 75.1981 23.568 72.5084 25.5039C69.8186 27.4429 66.8702 29.1743 63.845 30.8801C57.8075 34.3046 51.4474 37.5693 45.1032 40.4794C38.7591 43.396 32.4405 45.9867 26.5148 48.1493C25.7768 48.4272 25.0389 48.686 24.3138 48.9447C24.0774 49.0278 23.841 49.114 23.6046 49.1971C23.4225 49.261 23.2436 49.3248 23.0616 49.3919C22.8891 49.4558 22.7166 49.5197 22.5409 49.5836L22.2853 49.6794L22.1575 49.7273L22.0936 49.7497C22.0617 49.7593 22.0553 49.7657 22.0936 49.7689C22.2757 49.804 22.461 49.8392 22.6431 49.8711C23.0073 49.9414 23.3714 50.0085 23.7356 50.0787C23.8218 50.0979 23.9145 50.1107 24.0071 50.1203L24.17 50.1394L24.4543 50.1746C24.5502 50.1842 24.6428 50.2001 24.7386 50.2065L25.0229 50.2225C25.2114 50.2321 25.4031 50.2448 25.5916 50.248C25.78 50.2448 25.9685 50.2448 26.1538 50.2416C26.2464 50.2385 26.3423 50.2417 26.4349 50.2385L26.7128 50.2193C26.8981 50.2065 27.0834 50.1937 27.2655 50.181C27.4475 50.1586 27.6296 50.1362 27.8117 50.1171L28.0832 50.0851L28.3516 50.0404C29.7827 49.8104 31.1371 49.4367 32.4085 49.0022C33.6831 48.5678 34.881 48.0822 36.0182 47.603C40.5575 45.6768 44.2184 43.9198 46.7516 42.6772C48.0134 42.0447 49.0068 41.5655 49.6713 41.211C50.3389 40.866 50.6903 40.6807 50.6903 40.6807C50.6903 40.6807 50.981 40.5305 51.5496 40.2335C52.1214 39.946 52.9552 39.486 54.0573 38.8918C55.1625 38.3072 56.5074 37.5374 58.1046 36.6397C59.6891 35.7229 61.5195 34.6592 63.5511 33.4101C63.8067 33.2568 64.0654 33.0971 64.3274 32.9373C64.5861 32.7744 64.8513 32.6083 65.1164 32.4422C65.6499 32.1068 66.1961 31.7618 66.7552 31.4072C67.3174 31.059 67.886 30.6821 68.4674 30.3019C69.0488 29.9218 69.6429 29.5321 70.2531 29.1328C72.6617 27.5036 75.278 25.7211 78.0156 23.6958C78.3574 23.4435 78.7056 23.1911 79.0538 22.9355C79.3988 22.6736 79.747 22.4117 80.0984 22.1465C80.4498 21.8814 80.8043 21.613 81.1621 21.3447C81.5199 21.0764 81.8809 20.8048 82.2355 20.5205C82.951 19.9583 83.6793 19.3897 84.4204 18.8115C84.8836 18.4473 85.3436 18.064 85.7909 17.6519C85.7685 17.6807 85.7493 17.7094 85.727 17.735C83.8486 20.1117 81.095 22.188 78.482 24.4753C77.217 25.555 75.9488 26.6379 74.6806 27.7208C74.6806 27.74 74.6806 27.7592 74.6838 27.7783C74.6838 27.7943 74.687 27.8103 74.687 27.8262C74.687 27.8294 74.6902 27.8454 74.6902 27.855C74.6966 27.8901 74.7029 27.9253 74.7157 27.9572C74.7221 27.9764 74.7285 27.9955 74.7349 28.0147C74.7381 28.0211 74.7477 28.0435 74.7477 28.0499C74.7605 28.0722 74.77 28.0946 74.7828 28.1169C74.7892 28.1265 74.7988 28.1329 74.8052 28.1425C74.8052 28.1425 74.8084 28.1457 74.8116 28.1489C74.818 28.1521 74.8307 28.1617 74.8339 28.1648C74.8467 28.1712 74.8595 28.1776 74.8691 28.184C74.8691 28.184 74.8691 28.184 74.8723 28.184C74.8946 28.1904 74.9138 28.2 74.9361 28.2032C74.9457 28.2064 74.9521 28.2064 74.9617 28.2096C76.3257 27.2736 77.677 26.3504 79.0027 25.4432C80.98 24.0887 82.9606 22.7311 84.9284 21.383C85.9123 20.709 86.8898 20.0382 87.8641 19.3705C88.0493 19.2428 88.2314 19.1182 88.4167 18.9936L88.4806 19.1757C88.5061 19.2428 88.5253 19.3098 88.5477 19.3801C88.7234 19.9296 88.8735 20.4918 89.03 21.0508C89.4549 22.6417 89.8638 24.1718 90.2375 25.5837C90.3334 25.9351 90.4132 26.2226 90.4611 26.3887C90.5761 26.788 90.688 27.0915 90.8221 27.3758C90.8796 27.494 90.9371 27.609 91.0042 27.724C92.0999 33.573 93.5917 39.3071 95.2911 44.9197C97.112 50.9125 99.1756 56.7711 101.361 62.4955C102.456 65.3578 103.581 68.1848 104.728 70.9832C104.801 71.1589 104.865 71.3314 104.948 71.5103L105.069 71.7786L105.207 72.0373C105.319 72.2386 105.437 72.4366 105.561 72.6251C105.427 72.5389 105.296 72.459 105.159 72.3887ZM84.0818 18.3803C83.3439 18.9585 82.6188 19.5271 81.9032 20.0861C81.5486 20.3672 81.1877 20.6387 80.8331 20.9071C80.4753 21.1754 80.1239 21.4437 79.7725 21.7089C79.4212 21.974 79.0761 22.236 78.7311 22.4979C78.3829 22.7535 78.038 23.0058 77.6961 23.255C74.9681 25.2771 72.3582 27.0532 69.956 28.6792C69.3491 29.0753 68.7549 29.465 68.1767 29.8451C67.5953 30.2253 67.0331 30.599 66.4709 30.9472C65.9118 31.2986 65.3656 31.6436 64.8353 31.979C64.5702 32.1451 64.3082 32.3112 64.0495 32.4742C63.7875 32.6339 63.532 32.7904 63.2764 32.9437C61.2511 34.1896 59.4239 35.2501 57.8427 36.1669C56.2486 37.0614 54.907 37.828 53.8049 38.4126C52.706 39.0036 51.8755 39.4636 51.3036 39.7511C50.7382 40.045 50.4475 40.1951 50.4475 40.1951C50.4475 40.1951 50.0961 40.3772 49.4317 40.7222C48.7705 41.0736 47.7802 41.5528 46.5216 42.1853C43.9948 43.4247 40.3435 45.1785 35.817 47.0983C34.6861 47.5775 33.4978 48.0567 32.2456 48.4847C30.9934 48.9128 29.6677 49.2769 28.2781 49.5005L28.0161 49.5421L27.7542 49.574C27.5785 49.5964 27.4028 49.6155 27.2239 49.6379C27.045 49.6507 26.8693 49.6635 26.6904 49.673L26.4221 49.6922C26.3327 49.6954 26.2432 49.6954 26.1538 49.6954C25.9749 49.6986 25.7928 49.6986 25.6107 49.7018C25.4286 49.6954 25.2498 49.6826 25.0677 49.6762L24.7929 49.6635C24.7003 49.6571 24.6109 49.6443 24.5214 49.6347C24.3904 49.6187 24.2627 49.6028 24.1317 49.59L24.2371 49.5517L24.5086 49.4558C25.237 49.1971 25.9749 48.9383 26.716 48.6604C32.6545 46.4946 38.9859 43.8975 45.346 40.9746C51.7061 38.0548 58.0791 34.7837 64.1293 31.3529C67.1577 29.6439 70.1253 27.9029 72.8406 25.9447C75.5623 23.9865 77.9677 21.7855 80.2006 19.6357C80.7596 19.099 81.3091 18.5624 81.8489 18.0321C82.392 17.5018 82.9159 16.9747 83.4525 16.4764C83.986 15.9748 84.5259 15.4893 85.0561 15.0133C85.5225 14.598 85.9793 14.1892 86.4298 13.7835C86.5192 13.7004 86.6055 13.6237 86.6821 13.5535C86.8355 13.4129 86.96 13.2979 87.0431 13.2244C87.4743 12.8251 87.7395 12.5089 87.9918 12.1447C87.9918 12.1543 87.9918 12.1639 87.9918 12.1735C87.9886 13.0328 87.813 13.8953 87.4999 14.7226C87.1485 15.3711 86.6853 15.9621 86.1838 16.4987C85.5257 17.1887 84.8166 17.8053 84.0818 18.3803ZM114.557 76.3978L114.467 76.484C114.435 76.5096 114.4 76.5351 114.365 76.5607C114.295 76.6086 114.234 76.6661 114.161 76.7076C113.908 76.8674 113.624 76.976 113.33 77.0526C113.123 77.0367 112.915 77.0111 112.714 76.9823C112.001 76.861 111.318 76.6022 110.676 76.2508C110.034 75.8994 109.427 75.4746 108.836 75.021C108.222 74.5546 107.619 74.0594 106.992 73.5899C106.737 73.2992 106.491 73.0021 106.264 72.689C106.047 72.3951 105.849 72.0853 105.673 71.769L105.545 71.5294L105.434 71.2835C105.36 71.1205 105.29 70.9385 105.216 70.766C104.073 67.974 102.948 65.1469 101.856 62.2911C99.6739 56.5762 97.6167 50.7304 95.7991 44.7536C93.9878 38.7768 92.4161 32.6594 91.3077 26.4239C90.7518 23.3061 90.3334 20.1564 90.0874 16.9875C89.9564 15.403 89.8989 13.8122 89.867 12.2214L89.8702 11.0267V10.4293L89.8893 9.83193L89.9309 8.6404C89.95 8.2411 89.9724 7.84499 90.0043 7.45207C90.0586 6.76207 90.1449 6.07527 90.3046 5.41402C90.4164 5.29263 90.5314 5.17124 90.6432 5.05304C90.7167 5.35013 90.7902 5.64721 90.8605 5.9411C91.4546 8.34971 92.0105 10.6146 92.5312 12.7389C93.5757 16.9843 94.4798 20.6579 95.2496 23.7885C96.7893 30.0464 97.7924 34.1193 98.3003 36.1925C99.4439 40.834 100.453 44.9485 101.348 48.5869C101.571 49.4973 101.789 50.379 101.999 51.2287C102.105 51.6536 102.207 52.0753 102.309 52.4874C102.36 52.6918 102.412 52.8962 102.459 53.1007L102.498 53.2508L102.507 53.2828C102.341 53.3083 102.389 53.3051 102.511 53.2892L102.52 53.3243L102.523 53.3435C102.498 53.3498 102.536 53.3467 102.603 53.3371C102.667 53.5639 102.75 53.8067 102.862 54.0878C103.054 54.5861 103.437 55.5796 103.903 56.7935C104.172 57.493 104.453 58.2214 104.756 58.9689C104.906 59.3426 105.066 59.7196 105.226 60.0997C105.386 60.4767 105.542 60.8536 105.689 61.2465C106.28 62.8022 106.788 64.4505 107.379 66.0414C107.673 66.8368 107.986 67.6162 108.34 68.3605C108.692 69.1049 109.078 69.8172 109.526 70.4561C109.97 71.0982 110.465 71.6764 111.011 72.1364C111.557 72.5996 112.142 72.9542 112.717 73.1873C112.857 73.2512 113.001 73.3055 113.161 73.3471C113.321 73.3886 113.503 73.411 113.688 73.379C113.71 73.3758 113.733 73.3694 113.755 73.363L113.8 73.3535C113.825 73.3471 113.851 73.3407 113.886 73.3343C113.953 73.3215 114.017 73.3087 114.081 73.296C114.218 73.264 114.356 73.2257 114.483 73.1682C114.742 73.0564 114.953 72.8871 115.109 72.7114C115.183 72.6219 115.253 72.5357 115.314 72.4462C115.368 72.3568 115.423 72.2737 115.467 72.1907C115.547 72.0246 115.621 71.8776 115.662 71.7467C115.688 71.6796 115.71 71.6221 115.729 71.5646C115.748 71.5103 115.761 71.4592 115.774 71.4112C115.825 71.2291 115.854 71.1333 115.854 71.1333C115.854 71.1333 115.873 71.0375 115.914 70.8522C115.959 70.6701 115.998 70.3986 116.045 70.0536C116.081 69.7118 116.125 69.2965 116.176 68.8205C116.205 68.581 116.218 68.3254 116.237 68.0539C116.253 67.7823 116.272 67.498 116.291 67.201C116.314 66.9039 116.311 66.5908 116.323 66.2682C116.33 65.9455 116.346 65.6069 116.343 65.2619C116.333 64.5687 116.336 63.834 116.291 63.0705C116.269 62.3039 116.196 61.5117 116.132 60.6971C116.09 60.2914 116.045 59.8793 116.004 59.464C115.962 59.0487 115.899 58.6335 115.844 58.2118C115.72 57.3078 115.576 56.3942 115.416 55.4901C115.745 56.7072 116.036 57.9371 116.263 59.1861C116.509 60.5725 116.684 61.978 116.761 63.3996C116.841 64.8211 116.838 66.2522 116.748 67.6865C116.652 69.1208 116.474 70.5551 116.205 71.9798C116.065 72.689 115.911 73.4046 115.729 74.1041C115.544 74.7973 115.311 75.4778 114.902 76.024C114.796 76.1646 114.681 76.286 114.557 76.3978ZM117.547 71.3282C117.521 72.0789 117.432 72.8232 117.25 73.5419C117.071 74.2607 116.787 74.9475 116.387 75.548C116.189 75.8483 115.953 76.1262 115.691 76.3658C115.624 76.4265 115.557 76.4808 115.49 76.5383C115.419 76.5926 115.349 76.6469 115.279 76.6948C115.145 76.7907 114.991 76.861 114.835 76.9185C114.812 76.9248 114.787 76.9312 114.764 76.9376C114.784 76.9248 114.803 76.9089 114.822 76.8961L114.931 76.7907C115.078 76.6533 115.218 76.5064 115.333 76.3467C115.812 75.7046 116.058 74.9603 116.25 74.2415C116.435 73.5196 116.592 72.8008 116.732 72.0789C117.004 70.6318 117.189 69.1751 117.285 67.7185C117.358 66.5876 117.374 65.46 117.339 64.3387C117.515 66.6771 117.595 69.0154 117.547 71.3282Z" fill="#003061"/>
                    <path d="M117.681 62.0771C117.055 55.8862 115.822 49.721 114.474 43.5525C114.135 42.0128 113.793 40.4667 113.452 38.9205C113.11 37.3776 112.774 35.8219 112.391 34.2758C111.634 31.1836 110.762 28.1137 109.781 25.0694C108.797 22.0283 107.702 19.0128 106.449 16.0547C105.191 13.103 103.772 10.2025 102.054 7.47124C101.191 6.10721 100.252 4.78791 99.1756 3.57082L98.7667 3.11721C98.6325 2.96388 98.4824 2.82652 98.3418 2.67957C98.0575 2.38888 97.77 2.10457 97.457 1.83624C97.1471 1.56791 96.8149 1.31235 96.4507 1.09832C96.0866 0.884293 95.6873 0.711794 95.2624 0.615961C94.8311 0.523322 94.3839 0.526515 93.9622 0.609571C93.5374 0.692626 93.1349 0.849156 92.7611 1.05041C92.0136 1.4561 91.3907 2.04707 90.8988 2.72429C90.6496 3.0629 90.4484 3.43346 90.2791 3.81041C90.1098 4.19054 89.9692 4.58346 89.8606 4.97957C89.8446 5.03388 89.8318 5.08499 89.8191 5.13929C89.5284 5.44915 89.2377 5.76221 88.9406 6.08166C88.487 6.55443 88.011 7.02082 87.535 7.49999C87.2954 7.73957 87.0559 7.97915 86.8163 8.22193C86.5671 8.45832 86.3179 8.69471 86.0656 8.93429C85.5609 9.41027 85.0498 9.89582 84.5323 10.3878C84.002 10.8669 83.4653 11.3525 82.9223 11.8444C82.6475 12.0872 82.3792 12.3428 82.0981 12.5823C81.817 12.8251 81.5359 13.0711 81.2516 13.3171C80.6798 13.8058 80.1111 14.3137 79.517 14.8057C78.3286 15.7896 77.118 16.8118 75.8434 17.8117C74.5848 18.8339 73.2591 19.8337 71.911 20.8719C69.1893 22.9132 66.2984 24.9896 63.2061 27.0596C60.1043 29.1136 56.8077 31.1676 53.265 33.113C52.821 33.3558 52.377 33.5986 51.9298 33.8446C51.4761 34.081 51.0193 34.3078 50.5593 34.541C50.0993 34.7742 49.6361 35.0074 49.173 35.2405C48.7034 35.4674 48.2306 35.6973 47.7578 35.9273C45.8635 36.8537 43.9309 37.7961 41.9599 38.7576C38.018 40.6679 33.9131 42.6325 29.5654 44.4565C29.0192 44.6801 28.473 44.9037 27.9235 45.1305C27.3709 45.3478 26.815 45.565 26.256 45.7854C25.6938 45.993 25.1316 46.2071 24.5629 46.4115C24.2786 46.5105 23.9911 46.6096 23.7068 46.7118L23.5375 46.7693C23.5375 46.7693 23.5375 46.7661 23.5375 46.7597V46.7469L23.5343 46.6192C23.5343 46.5329 23.5248 46.4498 23.5152 46.3668C23.496 46.1975 23.4609 46.0346 23.4129 45.8717C23.3171 45.549 23.1638 45.2392 22.9625 44.9676C22.7613 44.6929 22.5089 44.4533 22.2118 44.268C21.918 44.086 21.5793 43.9614 21.2343 43.9198C20.5443 43.8368 19.832 44.0221 19.2698 44.4373C18.9886 44.6418 18.7459 44.9133 18.5702 45.2104C18.3913 45.5075 18.2731 45.8237 18.1709 46.1304C17.9664 46.7437 17.8195 47.3507 17.4841 47.8139C17.1518 48.2835 16.6311 48.6093 16.0689 48.868C15.7846 48.9958 15.4907 49.1108 15.1873 49.2258C14.8838 49.3408 14.5803 49.4526 14.2768 49.5676C13.6699 49.7976 13.0598 50.0276 12.4464 50.2576C11.2198 50.724 9.9867 51.1776 8.73767 51.6632C7.49503 52.1583 6.23322 52.7397 5.14711 53.631C4.70309 53.9951 4.291 54.4168 3.9492 54.8928L3.81503 55.0685L3.69684 55.2537C3.61698 55.3783 3.54031 55.5029 3.46045 55.6275C3.39336 55.7585 3.32628 55.8894 3.256 56.0204L3.15378 56.2185C3.12184 56.2855 3.09628 56.3558 3.06753 56.4229C3.01003 56.5603 2.95573 56.6976 2.89823 56.835C2.84712 56.9755 2.80559 57.1161 2.75767 57.2598C2.65545 57.541 2.60114 57.8348 2.52448 58.1223C2.40628 58.7069 2.31045 59.3011 2.26892 59.9017C2.16989 61.1028 2.21142 62.323 2.30087 63.5465C2.34559 64.1598 2.39989 64.77 2.47017 65.3897C2.53726 66.0094 2.6235 66.6323 2.72892 67.2553C2.93975 68.5011 3.21767 69.7501 3.57864 70.996C3.93962 72.2418 4.38364 73.4812 4.93948 74.6919C5.49531 75.8994 6.16295 77.0846 7.00628 78.1707C7.43434 78.7074 7.89114 79.228 8.41184 79.6944C8.92934 80.1608 9.50114 80.5889 10.1336 80.9147C10.7661 81.2437 11.4466 81.4833 12.1461 81.6303C12.8457 81.7804 13.5613 81.8411 14.2705 81.8571C15.6952 81.8922 17.1071 81.7421 18.5223 81.6782C19.9438 81.6047 21.3813 81.5472 22.8348 81.4162C24.285 81.2821 25.7513 81.084 27.1952 80.6815C27.3932 80.6208 27.4827 80.6112 27.9043 80.4643L28.4282 80.2886L28.6902 80.1992L28.8211 80.1544C28.8435 80.1385 28.9649 80.1257 28.8818 80.1065L28.3803 79.8957L28.1279 79.7903L28.0034 79.736L27.866 79.6817C27.8181 79.6657 27.7766 79.6433 27.735 79.6242L27.62 79.5698L27.4986 79.5124C27.4188 79.474 27.3389 79.4357 27.2623 79.3878C26.6393 79.0428 26.0611 78.5987 25.5309 78.1036C24.4703 77.1037 23.5918 75.8962 22.8284 74.6153C21.311 72.0373 20.2153 69.1751 19.3368 66.2298C18.9088 64.754 18.5127 63.2558 18.2667 61.7321C18.0175 60.2051 17.8802 58.6526 17.8961 57.0969C17.9089 55.5412 18.0814 53.9792 18.4807 52.4714L18.6341 51.906L18.8225 51.3533C18.9375 50.9796 19.1068 50.6282 19.257 50.2704C19.3273 50.0883 19.4295 49.9222 19.5157 49.7465C19.6084 49.574 19.6946 49.3983 19.7905 49.2322L20.1067 48.7403L20.2632 48.4943C20.2856 48.4655 20.3048 48.4432 20.3271 48.4208C20.3527 48.4048 20.3686 48.3793 20.3974 48.3697C20.4421 48.3346 20.4996 48.3314 20.5539 48.3218C20.6114 48.3218 20.6689 48.3346 20.7232 48.3569C20.8318 48.4112 20.9181 48.5039 20.9373 48.6189C20.9404 48.6317 20.9436 48.6476 20.9468 48.6604C20.9468 48.6764 20.9468 48.6892 20.9468 48.7051C20.9532 48.7339 20.9373 48.769 20.9373 48.801C20.9373 48.8137 20.9277 48.8425 20.9245 48.8648L20.9085 48.9383L20.8734 49.0853L20.736 49.673C20.5571 50.4589 20.3942 51.2511 20.26 52.0497C19.9885 53.6469 19.8256 55.2761 19.8671 56.9148C19.8959 57.7326 19.9534 58.5504 20.0748 59.3618C20.1227 59.7675 20.2057 60.17 20.2728 60.5757C20.3591 60.975 20.4325 61.3807 20.5348 61.7768C20.9117 63.3708 21.426 64.9265 21.9882 66.463C22.56 67.9964 23.1798 69.5042 23.8027 71.0151C24.4352 72.5229 25.106 74.0339 25.9909 75.4426C26.4349 76.1454 26.93 76.8194 27.5018 77.4328C28.0704 78.0461 28.7189 78.5987 29.4409 79.0396C30.1564 79.4772 30.9678 79.835 31.8559 79.8925C32.2967 79.9148 32.7599 79.8573 33.1784 79.6753C33.5968 79.4964 33.9482 79.2281 34.2645 78.9533C34.5839 78.6786 34.865 78.3879 35.1813 78.1387L35.6413 77.7522C35.718 77.6883 35.7946 77.6212 35.8745 77.5605L36.1205 77.3848L36.6124 77.0335C36.6954 76.976 36.7753 76.9153 36.8584 76.861L37.1171 76.7044L37.6314 76.3914C37.7177 76.3403 37.8007 76.2828 37.8902 76.238L38.1585 76.1007C39.5768 75.3404 41.1006 74.7782 42.6563 74.3565C45.3396 73.6346 48.1124 73.3119 50.882 73.0947C50.4348 73.2289 49.9875 73.363 49.5403 73.4972C47.9942 73.9636 46.4545 74.4268 44.9179 74.8868C44.1513 75.1168 43.3814 75.35 42.618 75.58C41.8513 75.8132 41.0878 76.0336 40.3211 76.2828C39.5545 76.5351 38.7878 76.8354 38.085 77.2794C37.7336 77.4998 37.4046 77.7618 37.1107 78.0621C37.0341 78.1355 36.967 78.2122 36.8967 78.2953L36.7945 78.4166L36.6923 78.5572C36.5645 78.7521 36.4814 78.9661 36.4271 79.1801C36.3153 79.6114 36.3185 80.0426 36.3664 80.4579C36.392 80.6655 36.4335 80.87 36.4814 81.0712L36.5453 81.3012V81.3044L36.5549 81.3332L36.5709 81.3907C36.5836 81.429 36.5932 81.4673 36.606 81.5025C36.6539 81.6494 36.7082 81.7868 36.7593 81.9114C36.8616 82.1605 36.967 82.3586 37.0341 82.4832C37.2449 82.8601 37.4653 83.1285 37.7145 83.3425C37.8934 83.4958 38.0914 83.6236 38.3214 83.7194C37.8486 84.0517 37.3823 84.3967 36.9318 84.764C36.0374 85.4923 35.1877 86.2878 34.4242 87.163C33.6575 88.0351 32.9739 88.9871 32.4117 90.0093C31.8431 91.0315 31.4246 92.1304 31.0892 93.2389C30.4248 95.4654 30.0798 97.7399 29.4728 99.9312C28.3036 104.34 26.5179 108.559 24.3617 112.517C22.2022 116.478 19.6755 120.187 16.9857 123.676C14.296 127.164 11.4466 130.438 8.58434 133.562C7.15323 135.124 5.71573 136.648 4.291 138.14C3.7735 138.68 3.2624 139.21 2.76087 139.734C2.71615 139.782 2.67142 139.83 2.6267 139.875C2.4542 140.053 2.31364 140.2 2.2242 140.293C1.65559 140.89 1.39365 141.29 1.03906 141.906C1.64281 141.529 3.10267 140.159 3.15059 140.111C3.65211 139.587 4.16323 139.054 4.68392 138.514C6.11184 137.019 7.54934 135.492 8.98684 133.927C11.8554 130.796 14.7145 127.509 17.417 124.005C20.1163 120.5 22.6623 116.769 24.8377 112.776C27.0131 108.786 28.8148 104.525 29.9967 100.069C30.61 97.8453 30.9582 95.5644 31.6099 93.3922C31.9389 92.3061 32.3414 91.2519 32.8877 90.268C33.4307 89.2842 34.092 88.3642 34.8331 87.5176C35.5742 86.6711 36.3984 85.8949 37.2736 85.1825C38.1521 84.4733 39.0817 83.8312 40.04 83.2339C40.9984 82.6397 41.9854 82.0935 42.9917 81.5855C43.9979 81.0808 45.0234 80.608 46.052 80.1576C48.9717 78.883 51.9521 77.8097 54.9198 76.8067C54.8079 76.9185 54.7025 77.0367 54.6035 77.158C54.431 77.3753 54.2745 77.6053 54.1435 77.8576C54.0125 78.11 53.9071 78.3815 53.8656 78.6882C53.8464 78.8415 53.8432 79.0012 53.8752 79.1673C53.9071 79.3303 53.9742 79.4964 54.0764 79.6369C54.102 79.6689 54.1307 79.704 54.1563 79.736L54.2457 79.8254L54.3448 79.9021C54.3895 79.934 54.4534 79.9724 54.5077 80.0075C54.5332 80.0298 54.562 80.0426 54.5971 80.0299L54.6929 80.0139L54.8239 79.9915L55.022 79.9564C55.5523 79.8573 56.0761 79.7232 56.5936 79.5539C57.6286 79.2216 58.6189 78.7457 59.5453 78.1579C60.0085 77.864 60.4525 77.535 60.8742 77.1772C60.8966 77.158 60.9221 77.1389 60.9445 77.1165C60.9317 77.1517 60.9221 77.1868 60.9093 77.2219C60.756 77.6819 60.5675 78.1547 60.4334 78.6467C60.181 79.5411 59.606 80.3205 58.9863 81.0425C58.357 81.7676 57.7053 82.4768 57.0473 83.1476C56.386 83.8217 55.7024 84.4574 54.9868 85.0324C54.2713 85.6074 53.5206 86.1217 52.7316 86.5242C51.9425 86.9267 51.1088 87.2174 50.2623 87.3419C49.8374 87.4026 49.4125 87.4218 48.9941 87.3962L48.8535 87.3898L48.6842 87.3707L48.352 87.3355L48.0198 87.3004L47.8632 87.2844C47.8888 87.3292 47.9367 87.3835 47.9718 87.4314L48.2082 87.7508L48.3296 87.9137C48.3647 87.968 48.3935 88.016 48.4159 88.0671L48.4542 88.1661C48.4638 88.1853 48.4702 88.2076 48.4734 88.23C48.4829 88.2747 48.4989 88.3162 48.5053 88.361C48.5692 88.7187 48.4925 89.1117 48.3392 89.4662C48.2625 89.6451 48.1635 89.8144 48.0549 89.9742C47.9431 90.1307 47.8153 90.2712 47.6684 90.415C47.0934 90.974 46.3682 91.3989 45.7389 91.9899C45.2086 92.4882 44.7902 93.1111 44.5378 93.7915C44.2854 94.4719 44.1928 95.1907 44.196 95.8935C44.212 97.3054 44.5825 98.6535 45.0457 99.9217C45.2789 100.557 45.5473 101.18 45.8316 101.781C46.1127 102.385 46.3842 102.988 46.6749 103.582C46.9592 104.18 47.2435 104.771 47.5406 105.359C47.6875 105.652 47.8345 105.946 47.9782 106.237C48.1284 106.528 48.2785 106.815 48.4286 107.106C50.8245 111.728 53.4471 116.05 56.2263 120.066C57.2964 121.612 58.3921 123.113 59.5038 124.57C59.1779 124.509 58.8425 124.522 58.5327 124.573C58.0631 124.656 57.6286 124.819 57.2198 125.011C55.5906 125.797 54.3 126.979 52.9328 127.87C52.2492 128.323 51.5464 128.726 50.8341 129.074C50.1249 129.422 49.4061 129.719 48.6874 129.959C47.2467 130.432 45.8124 130.675 44.4611 130.7C43.1099 130.729 41.8513 130.531 40.7556 130.192C40.3179 130.058 39.9123 129.902 39.5289 129.726C39.3181 129.454 39.0721 129.196 38.791 128.953C38.5323 128.726 38.1138 128.403 37.51 128.097C37.3567 128.026 37.2002 127.94 37.0245 127.873C36.9734 127.854 36.9223 127.832 36.8711 127.809C36.8839 127.79 36.8871 127.784 36.868 127.809C36.8296 127.793 36.7945 127.78 36.7561 127.764L36.7466 127.761C36.162 128.627 36.5868 128.004 36.4591 128.202L36.4718 128.215L36.4974 128.24L36.5485 128.295C36.5836 128.33 36.6188 128.368 36.6539 128.407C36.9478 128.697 37.28 129.001 37.6761 129.279C38.1138 129.595 38.6185 129.895 39.1807 130.16C39.4906 130.579 39.7174 131.016 39.8643 131.444C40.1167 132.157 40.1678 132.828 40.1454 133.406C40.1231 133.987 40.0113 134.479 39.8899 134.888C39.7685 135.297 39.628 135.626 39.4938 135.891C39.2286 136.421 39.021 136.706 38.906 136.872C38.8485 136.955 38.807 137.003 38.7846 137.035C38.7623 137.067 38.7527 137.076 38.7527 137.076C38.7527 137.076 38.7175 137.121 38.6473 137.21C38.5738 137.303 38.462 137.437 38.3182 137.613C38.0339 137.967 37.6123 138.491 37.0756 139.162C36.0086 140.507 34.4849 142.443 32.6736 144.832C29.048 149.605 24.2627 156.173 19.6499 163.328C17.3499 166.909 15.0882 170.631 13.0693 174.352C12.9416 174.585 12.817 174.815 12.6892 175.049C12.5678 175.282 12.4432 175.515 12.3218 175.748C12.0791 176.215 11.8363 176.678 11.5967 177.138C11.1367 178.071 10.6639 178.984 10.2391 179.911C10.1304 180.141 10.0218 180.371 9.91642 180.597C9.80781 180.824 9.7024 181.054 9.60337 181.284C9.40212 181.741 9.20087 182.198 9.00281 182.648C8.80475 183.099 8.62906 183.555 8.44698 183.999C8.35753 184.223 8.26489 184.447 8.17545 184.667C8.10517 184.852 8.03809 185.038 7.96781 185.223C7.77934 185.737 7.62281 186.159 7.54614 186.37C7.28101 187.156 7.22989 187.638 7.17878 188.341C7.55892 187.737 7.66753 187.322 7.93906 186.545C8.01573 186.338 8.6099 185.044 8.68017 184.859C8.76962 184.638 8.85906 184.418 8.94851 184.197C9.13059 183.753 9.30628 183.303 9.50114 182.856C9.6992 182.409 9.89725 181.958 10.0953 181.501C10.1943 181.275 10.2966 181.048 10.4052 180.821C10.5106 180.594 10.6192 180.367 10.7278 180.137C11.1495 179.221 11.6191 178.31 12.0759 177.381C12.3154 176.921 12.555 176.461 12.7978 175.997C12.9192 175.767 13.0406 175.534 13.162 175.301C13.2866 175.071 13.4143 174.841 13.5389 174.608C15.5482 170.902 17.8067 167.19 20.1003 163.619C24.7035 156.482 29.4792 149.924 33.0985 145.158C34.9066 142.772 36.4271 140.839 37.4941 139.498C38.0307 138.83 38.4492 138.309 38.7335 137.952C38.8773 137.776 38.9859 137.642 39.0593 137.549C39.1328 137.453 39.1711 137.402 39.1711 137.402C39.1711 137.402 39.1807 137.389 39.2063 137.357C39.2318 137.322 39.2766 137.271 39.3373 137.182C39.4618 137.003 39.6855 136.696 39.9698 136.124C40.1135 135.84 40.2636 135.482 40.3978 135.038C40.5288 134.594 40.6502 134.061 40.6757 133.425C40.7013 132.792 40.6438 132.051 40.3659 131.262C40.2796 131.016 40.171 130.767 40.0368 130.518C40.2157 130.585 40.3978 130.646 40.5863 130.703C41.7363 131.058 43.0524 131.266 44.4611 131.234C45.8667 131.208 47.3585 130.956 48.8471 130.467C49.5914 130.218 50.3325 129.914 51.0641 129.553C51.7956 129.196 52.5175 128.783 53.2203 128.317C53.9327 127.857 54.5939 127.327 55.2839 126.835C55.9707 126.34 56.6799 125.857 57.4402 125.496C57.8203 125.317 58.2132 125.171 58.6125 125.103C59.0086 125.036 59.4111 125.052 59.7593 125.209C59.9223 125.282 60.0756 125.385 60.2257 125.512C60.3152 125.627 60.4046 125.746 60.4941 125.861C60.6793 126.094 60.8806 126.33 61.1074 126.544C61.2927 126.713 61.4971 126.873 61.7303 126.995C61.9156 127.126 62.1328 127.237 62.3756 127.288C62.5225 127.324 62.6088 127.327 62.7206 127.346C62.826 127.362 62.9346 127.381 63.0432 127.403C63.2605 127.442 63.4904 127.496 63.7556 127.499C64.0175 127.509 64.2954 127.432 64.5254 127.324C64.583 127.295 64.6373 127.263 64.6916 127.234L64.8481 127.135L65.1292 126.947L65.685 126.57C65.8384 126.467 65.9885 126.365 66.1418 126.26C66.4485 126.132 66.7488 125.998 67.0491 125.857C68.0872 125.365 69.0839 124.806 70.0295 124.19C70.9686 123.564 71.8791 122.909 72.6872 122.126C73.0898 121.737 73.4667 121.318 73.7957 120.861C74.1216 120.404 74.3995 119.906 74.6007 119.379C74.6518 119.248 74.6902 119.111 74.7381 118.98C74.7732 118.842 74.8116 118.702 74.8371 118.564C74.8882 118.283 74.9202 118.002 74.9202 117.721C74.9234 117.156 74.8307 116.597 74.6423 116.066C74.4474 115.539 74.1471 115.047 73.7446 114.648C73.6488 114.543 73.5306 114.46 73.422 114.37C73.3677 114.322 73.307 114.287 73.2463 114.249L73.1568 114.191C73.1536 114.188 73.1504 114.188 73.1473 114.185L73.2974 114.083C73.3549 114.047 73.4028 114.003 73.4539 113.961L73.7606 113.706L73.9139 113.578L74.0545 113.437L74.3388 113.159C74.4378 113.07 74.5145 112.965 74.6039 112.866L74.8627 112.565C75.0192 112.354 75.1757 112.144 75.3259 111.93C75.7635 111.265 76.1149 110.55 76.3705 109.812C76.3768 109.805 76.3832 109.796 76.3896 109.789C76.6548 109.476 76.872 109.138 77.0445 108.789C77.217 108.441 77.3384 108.083 77.415 107.729C77.4917 107.374 77.5364 107.02 77.5204 106.675C77.5045 105.988 77.3032 105.343 76.9646 104.844C76.8464 104.656 76.7091 104.496 76.5717 104.349C76.5685 104.34 76.5621 104.33 76.5589 104.32C76.5398 104.276 76.5174 104.25 76.495 104.215C76.4503 104.145 76.4024 104.1 76.3577 104.042C76.3098 103.995 76.2618 103.943 76.2107 103.902C76.0798 103.787 75.9456 103.685 75.8082 103.595C75.5335 103.314 75.3163 103.052 75.2013 102.79C74.9298 102.209 75.1214 101.707 75.2492 101.397C75.3195 101.241 75.3802 101.123 75.4217 101.043C75.4632 100.963 75.4856 100.925 75.4856 100.925C75.4856 100.925 75.5175 100.87 75.5814 100.759C75.6485 100.647 75.7443 100.481 75.8753 100.26C75.9424 100.148 76.0127 100.021 76.0861 99.8674C76.1213 99.7907 76.166 99.714 76.198 99.6278C76.2299 99.5415 76.265 99.4521 76.3002 99.3594C76.4312 98.9825 76.5461 98.5321 76.5845 98.0114C76.6228 97.4907 76.5941 96.8965 76.4024 96.2704C76.3513 96.1139 76.3034 95.9542 76.2267 95.8008C76.1884 95.7242 76.1596 95.6411 76.1149 95.5644C76.0702 95.4878 76.0223 95.4111 75.9775 95.3344C75.936 95.2546 75.8753 95.1843 75.8178 95.1108C75.7571 95.0406 75.7092 94.9607 75.6389 94.8936C75.5718 94.8265 75.5016 94.7594 75.4313 94.6924C75.3642 94.6221 75.2779 94.571 75.1981 94.5103C75.1182 94.4496 75.0384 94.3889 74.9457 94.3474C74.8563 94.2994 74.7668 94.2515 74.6742 94.2036C74.5816 94.1653 74.4889 94.1269 74.3931 94.0918C74.3356 94.0726 74.2781 94.0535 74.2206 94.0343C74.1823 93.9768 74.1439 93.9161 74.1088 93.8554C73.8628 93.4433 73.6999 92.9801 73.6009 92.4978C73.4028 91.5299 73.4539 90.498 73.505 89.4599C73.5306 88.9392 73.5625 88.4121 73.5466 87.869C73.5306 87.3292 73.4699 86.7893 73.3485 86.2526C73.2271 85.7192 73.045 85.1889 72.7543 84.7001C72.4668 84.2146 72.0643 83.7737 71.5596 83.4767C71.0613 83.1732 70.4607 83.039 69.8825 83.0582C69.5918 83.071 69.3075 83.1189 69.0296 83.1924C68.9817 83.2083 68.9306 83.2211 68.8827 83.2371C68.723 82.8282 68.6175 82.3937 68.5568 81.9497C68.477 81.3907 68.4514 80.8189 68.4323 80.2407C68.4163 79.6625 68.4099 79.0779 68.3747 78.4869L68.3396 78.0429C68.3236 77.8928 68.3045 77.7394 68.2789 77.5925C68.2278 77.2922 68.1543 76.9983 68.0585 76.7108C67.87 76.1358 67.6081 75.58 67.2503 75.0816C66.8925 74.5865 66.4357 74.1329 65.848 73.8614C65.5573 73.7272 65.241 73.6378 64.9152 73.6186C64.8353 73.6122 64.7523 73.609 64.6724 73.6154C64.6309 73.6186 64.5925 73.6154 64.551 73.6186L64.3657 73.6378C64.2954 73.6505 64.206 73.6314 64.1868 73.7208L64.1645 73.7592C63.7843 73.6953 63.4106 73.6505 62.8931 73.6314C62.7813 73.6282 62.6152 73.6218 62.4107 73.609C62.3085 73.6026 62.1935 73.5962 62.0753 73.5899H62.0625L61.676 73.5611C61.5195 73.5515 61.363 73.5387 61.2064 73.5228C60.5771 73.4717 59.9478 73.395 59.3185 73.3119C59.1045 73.2832 58.8936 73.2512 58.6796 73.2161L58.7531 73.2129C58.801 73.2097 58.8489 73.1969 58.8936 73.1905L59.0342 73.1618L59.1524 73.1299C59.7913 72.9637 60.427 72.7912 61.0723 72.6315C61.7175 72.4782 62.3596 72.3089 63.0113 72.1651C63.3371 72.0917 63.663 72.015 63.9888 71.9415C64.3146 71.8712 64.6436 71.8042 64.9727 71.7339C65.6275 71.5901 66.292 71.4751 66.9564 71.3473C68.2853 71.1142 69.6302 70.9129 70.991 70.7564C73.7095 70.4433 76.4823 70.3283 79.2934 70.2165C82.1045 70.1047 84.9443 69.9833 87.8098 69.9865C90.6752 69.9897 93.5693 70.1111 96.4443 70.5647C97.8818 70.7883 99.3161 71.0758 100.738 71.4496C101.095 71.539 101.447 71.6444 101.801 71.7403C102.156 71.8361 102.511 71.9447 102.862 72.0533C103.213 72.1619 103.578 72.2641 103.907 72.3855C104.242 72.5133 104.568 72.6635 104.887 72.836C105.491 73.1618 106.06 73.5515 106.619 73.97C106.845 74.2255 107.079 74.4715 107.315 74.7111C107.852 75.251 108.414 75.7557 108.986 76.2412L109.203 76.4233C109.273 76.484 109.347 76.5447 109.427 76.6022C109.506 76.6597 109.583 76.7236 109.663 76.7779L109.912 76.9376C110.251 77.1357 110.605 77.3114 110.982 77.4264C111.727 77.6692 112.535 77.7458 113.317 77.5829C113.33 77.5797 113.346 77.5765 113.359 77.5733C113.499 77.5829 113.637 77.5893 113.781 77.5893C114.177 77.5893 114.592 77.5446 114.991 77.4072C115.189 77.3369 115.384 77.2443 115.56 77.1197C115.646 77.059 115.723 76.9983 115.806 76.9376C115.883 76.8705 115.962 76.8066 116.036 76.7396C116.333 76.468 116.595 76.1582 116.815 75.8228C117.259 75.1583 117.563 74.4108 117.754 73.6473C117.949 72.8839 118.042 72.1012 118.071 71.3186C118.154 68.2615 117.994 65.1725 117.681 62.0771ZM76.888 106.141C76.888 106.081 76.8816 106.02 76.8784 105.959C76.9423 106.196 76.9838 106.451 76.9902 106.719C77.0029 107.017 76.9646 107.33 76.8975 107.643C76.8784 107.726 76.8592 107.812 76.8336 107.895C76.9039 107.31 76.9263 106.723 76.888 106.141ZM90.7678 4.0436C90.9275 3.69221 91.1096 3.35679 91.3364 3.05013C91.7836 2.43679 92.3555 1.89374 93.0167 1.53596C93.6748 1.17499 94.435 0.999293 95.1474 1.15582C95.8661 1.31235 96.5178 1.74999 97.1056 2.25791C97.4027 2.51027 97.6838 2.79138 97.9617 3.07249C98.0991 3.21624 98.246 3.34721 98.3738 3.49735L98.7699 3.93818C99.8209 5.12332 100.747 6.42346 101.597 7.76832C103.293 10.4644 104.699 13.3426 105.951 16.2751C107.197 19.214 108.286 22.2136 109.267 25.2419C110.244 28.2735 111.11 31.3337 111.867 34.41C112.247 35.9497 112.583 37.4926 112.924 39.0419C113.266 40.588 113.605 42.131 113.947 43.6707C115.065 48.7978 116.106 53.9153 116.78 59.036C116.525 57.6496 116.199 56.2855 115.825 54.9439C115.448 53.5862 115.03 52.251 114.598 50.9285C114.448 50.4717 114.301 50.018 114.154 49.5644C114.068 49.2162 113.985 48.8712 113.902 48.5358C113.765 48.0055 113.653 47.5743 113.599 47.3571C113.423 46.6926 113.247 46.2837 112.995 45.811C111.564 40.9746 110.327 36.1989 108.899 31.6117C108.519 30.369 108.114 29.1455 107.695 27.9349C107.27 26.7242 106.829 25.539 106.389 24.3603C105.507 22.006 104.593 19.7028 103.593 17.4858C102.594 15.2689 101.511 13.1286 100.211 11.1576C100.041 10.9149 99.8752 10.6721 99.7091 10.4325C99.5398 10.1929 99.3577 9.95652 99.1564 9.72971C98.9552 9.5061 98.7348 9.28568 98.4792 9.1036C98.2236 8.91832 97.9298 8.77457 97.6103 8.6979C97.2909 8.62124 96.9523 8.62763 96.6424 8.7011C96.3293 8.77457 96.0386 8.90874 95.7799 9.07804C95.2624 9.41985 94.8599 9.9054 94.6043 10.4548C94.3488 10.9979 94.221 11.5761 94.1603 12.1447C94.0996 12.7133 94.0996 13.2787 94.1124 13.8282C94.1379 14.3776 94.1507 14.9271 94.1954 15.4669C94.2178 15.7385 94.2306 16.01 94.2561 16.2783C94.2817 16.5467 94.3073 16.815 94.3328 17.0801C94.3775 17.5305 94.4318 17.9746 94.4861 18.4186C94.0421 16.6137 93.5661 14.6747 93.055 12.6015C92.5343 10.4804 91.9753 8.21554 91.3843 5.80374C91.3077 5.49388 91.231 5.18402 91.1543 4.87096C91.0777 4.56749 91.0042 4.25443 90.9275 3.95415C90.8509 4.03402 90.7742 4.11707 90.7007 4.19693C90.7231 4.14902 90.7454 4.09471 90.7678 4.0436ZM103.079 53.27C103.073 53.2572 103.066 53.2412 103.057 53.2285C103.06 53.139 103.066 53.0464 103.07 52.9569C103.156 52.2158 103.558 51.561 104.034 50.9987C104.507 50.4301 105.047 49.9254 105.536 49.3951C105.612 49.3121 105.689 49.229 105.763 49.1428C105.817 49.1428 105.868 49.1396 105.922 49.1364C106.229 49.1172 106.545 49.0597 106.858 48.9192L106.973 48.8617L107.05 48.8265C107.123 48.7946 107.194 48.7658 107.27 48.7211C107.309 48.7019 107.347 48.6828 107.382 48.6604L107.491 48.5869C107.564 48.539 107.628 48.4815 107.692 48.4208C107.948 48.178 108.136 47.8746 108.251 47.5583C108.28 47.4785 108.312 47.3986 108.344 47.3187C108.366 47.2389 108.385 47.1558 108.404 47.076C108.424 46.9929 108.446 46.913 108.465 46.83C108.484 46.7469 108.491 46.6639 108.503 46.5808C108.692 45.2519 108.523 43.8783 108.283 42.4664C108.213 42.115 108.142 41.7604 108.069 41.4026C108.037 41.2237 107.992 41.0448 107.948 40.866C107.903 40.6871 107.861 40.505 107.817 40.3229C107.654 39.601 107.443 38.8439 107.143 38.1092C106.839 37.3744 106.456 36.6493 105.925 35.9912C105.66 35.6654 105.357 35.3587 105.005 35.0936C104.654 34.8348 104.255 34.6112 103.811 34.493C103.37 34.3653 102.894 34.3461 102.437 34.426C102.207 34.4675 101.984 34.5282 101.769 34.6144C101.552 34.6943 101.357 34.7933 101.166 34.87C100.977 34.9467 100.795 35.0074 100.626 35.0105C100.457 35.0169 100.3 34.9722 100.15 34.8828C99.8464 34.6975 99.6036 34.3397 99.3928 33.966C98.5367 32.4167 97.8723 30.6853 97.2909 28.874C96.7127 27.0596 96.2303 25.1525 95.8246 23.1751C95.4221 21.1978 95.0835 19.1469 94.8727 17.0322C94.8471 16.7671 94.8216 16.5019 94.796 16.2368C94.7705 15.9717 94.7577 15.7033 94.7353 15.435C94.6906 14.8983 94.6778 14.3617 94.6523 13.8186C94.6363 13.2787 94.6395 12.7389 94.697 12.2086C94.7545 11.6783 94.8727 11.1608 95.0931 10.688C95.3103 10.2248 95.6521 9.81277 96.0802 9.53165C96.5018 9.25054 97.0161 9.10999 97.4921 9.22499C97.9713 9.33679 98.3961 9.6786 98.7571 10.0907C98.9392 10.2983 99.1117 10.5187 99.2778 10.7519C99.4407 10.9883 99.6037 11.2247 99.7698 11.4611C101.044 13.3873 102.118 15.5085 103.111 17.7094C104.101 19.9136 105.012 22.204 105.89 24.5519C106.331 25.7275 106.769 26.9158 107.19 28.1137C107.606 29.318 108.008 30.5351 108.388 31.7714C109.925 36.7164 111.244 41.8946 112.832 47.1494C113.087 47.9928 113.356 48.8425 113.63 49.689C113.634 49.705 113.64 49.721 113.643 49.7369C113.739 50.1139 113.825 50.4972 113.915 50.8901C114.1 51.6696 114.269 52.4746 114.445 53.2923C114.784 54.9279 115.078 56.621 115.308 58.2853C115.359 58.7005 115.423 59.1126 115.464 59.5247C115.509 59.9368 115.55 60.3425 115.592 60.745C115.653 61.55 115.726 62.3358 115.748 63.0929C115.793 63.85 115.79 64.5751 115.799 65.2587C115.803 65.6005 115.787 65.9328 115.78 66.2522C115.768 66.5717 115.774 66.8815 115.748 67.1754C115.729 67.4693 115.713 67.7504 115.694 68.0187C115.678 68.2871 115.665 68.5394 115.637 68.7726C115.589 69.2454 115.544 69.6543 115.509 69.9897C115.461 70.3187 115.426 70.5743 115.384 70.7436C115.349 70.9129 115.33 71.0055 115.33 71.0055C115.33 71.0055 115.304 71.0918 115.256 71.2579C115.244 71.2994 115.234 71.3474 115.215 71.3953C115.196 71.4432 115.177 71.4975 115.154 71.555C115.116 71.6732 115.052 71.7978 114.985 71.9383C114.841 72.2098 114.621 72.5133 114.26 72.673C114.17 72.7146 114.068 72.7433 113.959 72.7689C113.899 72.7817 113.838 72.7944 113.774 72.804C113.742 72.8104 113.704 72.8168 113.666 72.8264L113.583 72.8455C113.423 72.8775 113.177 72.804 112.915 72.6858C112.391 72.4718 111.858 72.1523 111.353 71.7211C110.845 71.2962 110.382 70.7564 109.96 70.143C109.535 69.5329 109.161 68.8493 108.82 68.1242C108.478 67.399 108.168 66.6324 107.877 65.8465C107.293 64.2749 106.785 62.6265 106.187 61.0485C106.04 60.6523 105.878 60.2626 105.718 59.8825C105.558 59.5055 105.402 59.1318 105.251 58.7612C104.951 58.0201 104.67 57.2918 104.405 56.5954C104.082 55.7521 103.785 54.9854 103.539 54.3401C103.463 54.1453 103.402 53.9887 103.36 53.8865C103.264 53.6533 103.175 53.4521 103.082 53.27C103.185 53.2604 103.22 53.254 103.079 53.27ZM97.7828 31.8225C98.1246 32.653 98.4984 33.458 98.9232 34.2279C99.0382 34.4292 99.1628 34.6304 99.313 34.8221C99.4631 35.0137 99.642 35.1958 99.8688 35.3364C100.096 35.4769 100.377 35.5568 100.648 35.544C100.92 35.5312 101.156 35.4482 101.37 35.3619C101.584 35.2757 101.776 35.1767 101.961 35.1096C102.146 35.0361 102.338 34.985 102.53 34.9498C102.913 34.886 103.303 34.9019 103.67 35.0074C104.038 35.1064 104.379 35.2949 104.689 35.5217C104.996 35.7549 105.271 36.0296 105.513 36.3267C105.999 36.9272 106.363 37.614 106.651 38.3104C106.938 39.01 107.136 39.7224 107.302 40.4475C107.347 40.6264 107.389 40.8053 107.43 40.981C107.475 41.1567 107.516 41.3355 107.548 41.5112C107.618 41.8626 107.689 42.214 107.759 42.5558C107.813 42.9008 107.864 43.2426 107.916 43.5812C107.96 43.9198 107.986 44.2553 108.021 44.5843C108.034 44.7504 108.034 44.9133 108.04 45.0762C108.043 45.1561 108.047 45.2392 108.05 45.319C108.053 45.3989 108.056 45.4819 108.05 45.5586C108.043 45.7183 108.037 45.8748 108.031 46.0314C108.031 46.1112 108.021 46.1879 108.008 46.2646C107.999 46.3412 107.989 46.4179 107.976 46.4914C107.964 46.568 107.96 46.6447 107.944 46.7182C107.925 46.7917 107.909 46.8619 107.89 46.9354C107.871 47.0057 107.855 47.0792 107.836 47.1494C107.81 47.2165 107.785 47.2836 107.759 47.3475C107.663 47.6158 107.513 47.8426 107.331 48.0183C107.286 48.063 107.242 48.1078 107.187 48.1397L107.111 48.194C107.085 48.21 107.053 48.2228 107.028 48.2387C106.973 48.2707 106.909 48.2962 106.845 48.325L106.721 48.3825L106.638 48.424C106.516 48.4783 106.385 48.5167 106.248 48.5454C106.347 48.408 106.44 48.2611 106.532 48.1205C106.615 47.964 106.699 47.8075 106.775 47.651C107.059 47.0153 107.2 46.3572 107.254 45.7279C107.312 45.0986 107.283 44.4948 107.213 43.923C107.143 43.3512 107.034 42.8146 106.903 42.3067C106.769 41.7987 106.615 41.3228 106.456 40.8724C106.293 40.4283 106.133 40.0035 105.967 39.6042C105.635 38.8055 105.29 38.0932 104.903 37.483C104.712 37.1764 104.507 36.8985 104.277 36.6525C104.223 36.5886 104.162 36.5311 104.101 36.4768L104.012 36.3937C103.983 36.365 103.926 36.3267 103.884 36.2979C103.693 36.1861 103.504 36.1637 103.338 36.1605C103.006 36.1605 102.728 36.234 102.479 36.3171C102.229 36.4033 102.006 36.5023 101.805 36.6078C101.402 36.8186 101.083 37.0454 100.824 37.2722C100.568 37.499 100.37 37.7258 100.239 37.959C100.105 38.1858 100.051 38.4542 100.099 38.6714L100.105 38.7097L100.112 38.7353C100.115 38.7512 100.121 38.7672 100.124 38.7832C100.134 38.8151 100.14 38.8439 100.147 38.8694C100.163 38.9237 100.172 38.9685 100.185 39.01C100.227 39.1665 100.239 39.2176 100.239 39.2176C100.239 39.2176 100.332 39.5658 100.514 40.243C100.693 40.9203 100.958 41.9265 101.278 43.2458C101.437 43.9071 101.61 44.645 101.782 45.4628C101.869 45.8717 101.955 46.2997 102.035 46.7469C102.054 46.8587 102.073 46.9705 102.095 47.0855C102.124 47.2229 102.162 47.3667 102.229 47.4944C102.354 47.7532 102.543 47.964 102.75 48.1429C103.169 48.5007 103.67 48.7371 104.204 48.9032C104.485 48.9894 104.775 49.0533 105.079 49.0948C104.622 49.5836 104.111 50.066 103.629 50.6442C103.376 50.9476 103.13 51.2735 102.935 51.6504C102.872 51.7718 102.814 51.8996 102.76 52.0305C102.683 51.7207 102.606 51.4076 102.527 51.0882C102.316 50.2353 102.102 49.3568 101.875 48.4464C100.98 44.8047 99.9678 40.6935 98.8274 36.0519C98.5878 35.0904 98.2428 33.6849 97.7828 31.8225ZM106.066 47.8554C105.977 47.9864 105.897 48.1237 105.801 48.2547C105.711 48.3729 105.619 48.4911 105.52 48.6061C105.12 48.5901 104.724 48.5135 104.357 48.4017C103.878 48.2547 103.431 48.0343 103.095 47.7468C102.929 47.603 102.788 47.4401 102.705 47.2708C102.661 47.1846 102.638 47.0983 102.619 47.0089C102.6 46.8939 102.578 46.7789 102.559 46.6639C102.479 46.2103 102.389 45.7758 102.303 45.3637C102.13 44.5396 101.955 43.7953 101.795 43.134C101.472 41.8083 101.207 40.7989 101.028 40.1185C100.846 39.4412 100.754 39.0899 100.754 39.0899C100.754 39.0899 100.741 39.0419 100.699 38.8822C100.69 38.8439 100.677 38.796 100.661 38.7417C100.655 38.7161 100.645 38.6874 100.639 38.6554C100.635 38.6394 100.629 38.6235 100.626 38.6075L100.619 38.5851V38.5723C100.607 38.5053 100.61 38.3903 100.706 38.2305C100.881 37.9111 101.329 37.4767 102.051 37.0965C102.233 37.0007 102.431 36.9112 102.648 36.8378C102.862 36.7643 103.102 36.7068 103.325 36.7068C103.437 36.7068 103.542 36.7292 103.606 36.7675C103.613 36.7739 103.619 36.7803 103.629 36.7835C103.635 36.7899 103.641 36.7898 103.657 36.8058L103.731 36.8761C103.782 36.924 103.833 36.9719 103.881 37.0262C104.079 37.2371 104.268 37.4926 104.446 37.7801C104.811 38.3487 105.143 39.0355 105.469 39.8182C105.632 40.2079 105.791 40.6232 105.951 41.064C106.108 41.5017 106.254 41.9617 106.382 42.4472C106.507 42.936 106.612 43.4503 106.676 43.9933C106.743 44.5332 106.769 45.105 106.714 45.6864C106.663 46.2678 106.532 46.8651 106.28 47.4337C106.213 47.5775 106.143 47.7149 106.066 47.8554ZM60.8167 76.5223C60.7177 76.6118 60.6218 76.7012 60.5196 76.7843C60.1171 77.1261 59.6923 77.4392 59.2482 77.7203C58.3602 78.2825 57.4114 78.7393 56.4211 79.0587C55.926 79.2185 55.4245 79.3462 54.9166 79.4421C54.8303 79.458 54.6961 79.4804 54.661 79.4868C54.661 79.4868 54.661 79.4868 54.6578 79.4836L54.6003 79.4389L54.5492 79.3878L54.5045 79.3335C54.3959 79.1897 54.3639 78.9916 54.3927 78.7744C54.4214 78.5604 54.5045 78.3336 54.6163 78.1228C54.7249 77.9087 54.8623 77.7043 55.0156 77.5158C55.1689 77.3242 55.3382 77.1453 55.5203 76.9887C55.7024 76.8322 55.9036 76.6917 56.1177 76.5607C56.3125 76.4393 56.5138 76.3275 56.7214 76.2221C57.3348 76.0176 57.9513 75.8164 58.5614 75.6183L58.9511 75.4905L59.146 75.4267C59.2099 75.4075 59.2642 75.3915 59.3249 75.3755C59.5645 75.3148 59.82 75.2861 60.0692 75.2893C60.3056 75.2925 60.542 75.3212 60.7496 75.3915C60.8007 75.4139 60.8486 75.4362 60.887 75.465C61.0371 75.564 61.117 75.7046 61.1457 75.9026C61.1553 75.9729 61.1553 76.0528 61.1521 76.1294C61.1298 76.1805 61.101 76.2285 61.0659 76.2764C61.0339 76.3179 61.002 76.3562 60.9604 76.3914L60.8167 76.5223ZM70.8664 122.404C70.5374 122.672 70.1828 122.918 69.8186 123.164C69.4545 123.41 69.0871 123.66 68.7198 123.906C67.985 124.401 67.2439 124.899 66.5028 125.401C66.2984 125.538 66.0907 125.678 65.8863 125.816C65.6818 125.902 65.4774 125.985 65.2698 126.068C65.0046 126.174 64.7395 126.269 64.468 126.362C64.1996 126.455 63.9281 126.547 63.6629 126.618C63.1327 126.758 62.5864 126.816 62.1264 126.614C62.0881 126.598 62.0529 126.579 62.0178 126.56C62.0114 126.557 62.005 126.554 62.0018 126.547C61.6824 126.305 61.3981 125.969 61.0946 125.637C60.9477 125.477 60.7911 125.314 60.6218 125.161C59.277 123.433 57.9513 121.641 56.6639 119.778C53.8943 115.782 51.2877 111.479 48.9014 106.876C48.7513 106.588 48.6043 106.301 48.4542 106.01C48.3104 105.72 48.1635 105.429 48.0166 105.135C47.7227 104.554 47.4384 103.963 47.1541 103.368C46.8666 102.777 46.595 102.174 46.3171 101.573C46.036 100.973 45.7773 100.369 45.5473 99.7492C45.0936 98.5129 44.7423 97.216 44.7295 95.9031C44.7263 95.2514 44.8125 94.5965 45.0361 93.9928C45.2598 93.389 45.6271 92.8428 46.0999 92.3955C46.6653 91.8589 47.3936 91.434 48.0357 90.8143C48.1923 90.661 48.352 90.4885 48.4861 90.3C48.6171 90.1115 48.7321 89.9071 48.828 89.693C48.9206 89.479 48.9877 89.249 49.0292 89.0126C49.0675 88.7762 49.0771 88.5271 49.0292 88.2779C49.0196 88.214 49.0005 88.1533 48.9845 88.0926C48.9749 88.0607 48.9685 88.0319 48.9557 88L48.9366 87.9553C48.9366 87.9521 48.9334 87.9489 48.9334 87.9489C48.9366 87.9489 48.943 87.9489 48.9557 87.9489C49.4125 87.9744 49.8757 87.9553 50.3325 87.8882C51.2493 87.754 52.1374 87.441 52.9711 87.0193C53.8049 86.5944 54.5843 86.061 55.3223 85.4668C56.0602 84.8726 56.7566 84.2242 57.4274 83.5373C57.6829 83.2786 57.9321 83.0135 58.1813 82.7483C57.8427 83.1668 57.5009 83.5789 57.1559 83.9878C56.4116 84.8503 55.6481 85.6904 54.8591 86.505L54.2585 87.1055C54.0605 87.3068 53.8528 87.4985 53.6484 87.6933C53.4471 87.8914 53.2363 88.0798 53.0286 88.2683L52.706 88.5622C52.6453 88.6005 52.6102 88.6868 52.5942 88.7219L52.5463 88.8178L52.4505 89.0094C52.1981 89.5269 51.9649 90.054 51.7796 90.6099C51.687 90.8878 51.6103 91.1753 51.5624 91.4755C51.5145 91.7726 51.5017 92.0921 51.572 92.4179C51.6103 92.5808 51.6742 92.7405 51.7605 92.8875C51.8467 93.0344 51.9585 93.1622 52.0799 93.274C52.3227 93.4912 52.5878 93.635 52.8338 93.7756L53.2043 93.9832C53.3864 94.0854 53.5749 94.0982 53.7442 94.1014C54.0828 94.0886 54.3767 93.9928 54.6546 93.8842C55.0156 93.7372 55.351 93.5519 55.6704 93.3507C55.8302 93.2708 55.9867 93.191 56.1464 93.1111C56.6352 92.8779 57.1016 92.5968 57.5743 92.3349C57.8139 92.2071 58.0343 92.0537 58.2643 91.91C58.4911 91.7631 58.7243 91.6257 58.9448 91.4755C59.7849 90.9069 60.5899 90.2904 61.3598 89.6387C61.2064 89.7793 61.0499 89.9199 60.8966 90.0604C59.2674 91.5362 57.6159 93.0089 55.9324 94.4656C55.0891 95.1939 54.2425 95.9158 53.3705 96.6154C52.4984 97.3022 51.5688 98.0657 50.997 99.1294C50.8532 99.3946 50.7414 99.6789 50.6616 99.9728C50.62 100.12 50.5945 100.27 50.5721 100.423L50.553 100.66C50.5466 100.739 50.5561 100.816 50.5561 100.896C50.5913 101.525 50.8436 102.119 51.2366 102.605C51.4378 102.845 51.6838 103.055 51.9681 103.209C52.2492 103.362 52.5814 103.461 52.9168 103.448C52.9999 103.455 53.0861 103.432 53.1692 103.426C53.2107 103.42 53.2554 103.416 53.2938 103.407L53.4056 103.375C53.4184 103.372 53.4311 103.365 53.4439 103.362C53.6292 103.458 53.8177 103.544 54.0157 103.621C54.1595 103.675 54.3096 103.723 54.4693 103.758C54.6291 103.793 54.7984 103.812 54.9645 103.803C55.2584 103.793 55.5363 103.72 55.7918 103.618C55.6385 103.72 55.4852 103.828 55.335 103.937C55.1945 104.042 55.0507 104.148 54.907 104.257C54.7664 104.365 54.6163 104.467 54.4821 104.586C54.3448 104.701 54.2074 104.819 54.0668 104.934L53.8592 105.109C53.8305 105.135 53.8017 105.161 53.7761 105.186C53.7698 105.189 53.7634 105.196 53.757 105.199C53.3992 105.464 53.0606 105.777 52.7923 106.17C52.7763 106.192 52.7635 106.218 52.7475 106.243C52.6677 106.352 52.591 106.467 52.5271 106.595C52.4313 106.787 52.3674 107.01 52.361 107.234C52.3482 107.687 52.5239 108.103 52.7667 108.435C53.0095 108.773 53.3289 109.048 53.6835 109.259C54.3959 109.677 55.2552 109.834 56.0857 109.697H56.0889C56.4563 109.709 56.8236 109.697 57.1878 109.662C58.1078 109.575 59.0118 109.371 59.8999 109.099C60.1267 109.029 60.3535 108.956 60.5771 108.879C60.5675 108.885 60.5579 108.892 60.5484 108.901C60.2066 109.157 59.8871 109.432 59.59 109.732C59.4431 109.882 59.2993 110.038 59.1652 110.208C59.0981 110.294 59.0342 110.38 58.9735 110.479L58.9288 110.553L58.8873 110.633L58.8457 110.716L58.817 110.802L58.7627 110.974C58.7499 111.035 58.7435 111.096 58.7371 111.157L58.7243 111.246L58.7275 111.339C58.7307 111.399 58.7307 111.46 58.7371 111.521C58.7786 111.76 58.8649 111.987 58.9927 112.179C59.2354 112.552 59.5868 112.818 59.967 112.993L59.9702 112.997C60.0404 113.054 60.1139 113.096 60.1874 113.147C60.4845 113.329 60.7975 113.46 61.1106 113.549C61.2671 113.6 61.4268 113.629 61.5834 113.667C61.7399 113.699 61.8964 113.722 62.053 113.747C62.6791 113.83 63.2892 113.843 63.8866 113.827C65.0813 113.795 66.2153 113.645 67.295 113.46C68.1224 113.319 68.9146 113.15 69.6781 112.968C69.4896 113.316 69.4098 113.702 69.4034 114.083C69.397 114.511 69.4768 114.936 69.6334 115.338C69.7132 115.539 69.8091 115.734 69.9305 115.916C69.9911 116.009 70.055 116.098 70.1189 116.178C70.1828 116.261 70.2467 116.344 70.3106 116.421C70.8313 117.063 71.4127 117.644 71.8535 118.312C72.0707 118.644 72.2496 118.996 72.3359 119.369C72.4221 119.74 72.4253 120.13 72.3167 120.497C72.2113 120.868 72.0132 121.216 71.7577 121.532C71.5021 121.852 71.1954 122.139 70.8664 122.404ZM52.7571 91.7055C52.7635 91.4755 52.8338 91.2392 52.9296 91.0124C53.0286 90.7856 53.1564 90.5619 53.3066 90.3543C53.6068 89.9326 53.9774 89.5493 54.3767 89.1947C54.776 88.8433 55.2073 88.5207 55.6577 88.2332C55.7695 88.1629 55.8845 88.0926 55.9995 88.0287C56.0282 88.0128 56.057 87.9968 56.0857 87.9808C56.0985 87.9744 56.1049 87.9712 56.1049 87.9712L56.1975 87.9872C56.4531 88.0383 56.7023 88.1118 56.9386 88.2076C57.4146 88.4025 57.8459 88.6964 58.1302 89.0989C58.1653 89.1468 58.2005 89.1979 58.2292 89.2522C58.2611 89.3033 58.2899 89.3576 58.3123 89.4151C58.3378 89.4694 58.3634 89.5269 58.3793 89.5844L58.4017 89.6515C58.4017 89.6579 58.4017 89.6419 58.3985 89.6707C58.4017 89.7154 58.3793 89.7729 58.3698 89.824C58.3474 89.8783 58.3346 89.9326 58.3091 89.9901C58.2611 90.1019 58.2005 90.2137 58.1302 90.3224C57.8555 90.7632 57.4849 91.1689 57.0984 91.5458C56.7086 91.9228 56.287 92.2742 55.843 92.5936C55.7024 92.6926 55.5586 92.7917 55.4117 92.8843C55.335 92.9226 55.2552 92.961 55.1785 92.9993C54.9357 93.1079 54.6898 93.2165 54.447 93.3251L54.1786 93.4433C54.1467 93.4274 54.0253 93.3699 53.9454 93.3315C53.8368 93.2644 53.725 93.2069 53.6196 93.1367C53.5206 93.0632 53.412 92.9961 53.3257 92.913C52.9584 92.5936 52.7348 92.1655 52.7571 91.7055ZM51.671 101.113C51.5432 100.893 51.457 100.653 51.4761 100.449C51.4793 100.398 51.4921 100.35 51.5049 100.302C51.5273 100.247 51.5464 100.193 51.5752 100.139C51.6327 100.027 51.703 99.9185 51.7828 99.8099C52.1023 99.3818 52.5207 99.0017 52.968 98.679C53.4184 98.3596 53.9071 98.0944 54.4214 97.9315C54.9357 97.7686 55.4756 97.7079 55.9803 97.8165C56.2327 97.8708 56.4691 97.9698 56.6895 98.104L56.8141 98.1903C56.8141 98.1903 56.8141 98.1903 56.8173 98.1935L56.8556 98.2797C56.8779 98.3372 56.8939 98.3979 56.9163 98.4586C56.9323 98.5193 56.945 98.58 56.9578 98.6407C57.0473 99.1358 56.9291 99.6629 56.6895 100.132C56.4499 100.605 56.1049 101.037 55.7056 101.407C55.3063 101.781 54.8591 102.107 54.3799 102.369C54.1403 102.5 53.8943 102.618 53.642 102.717C53.5973 102.736 53.5493 102.752 53.5046 102.768C53.2554 102.624 53.0127 102.461 52.7827 102.286C52.345 101.957 51.9361 101.56 51.671 101.113ZM52.69 102.899C52.3003 102.835 51.933 102.589 51.6614 102.266C51.4474 102.001 51.2845 101.688 51.1886 101.359C51.195 101.369 51.1982 101.378 51.2046 101.388C51.5336 101.937 51.9777 102.353 52.4505 102.726C52.5271 102.784 52.607 102.841 52.69 102.899ZM56.255 104.755C56.4403 104.742 56.6224 104.748 56.7725 104.793L56.8779 104.835L56.993 104.902C57.0313 104.924 57.0728 104.943 57.1079 104.972L57.2134 105.055C57.4913 105.282 57.7021 105.589 57.8331 105.93C58.0982 106.614 58.0535 107.422 57.7085 108.039C57.5392 108.345 57.2868 108.601 56.9898 108.793C56.7086 108.975 56.386 109.093 56.0538 109.154C55.5555 109.131 55.0667 109.058 54.5971 108.927C54.4949 108.904 54.3959 108.866 54.2968 108.831C54.1978 108.796 54.0988 108.761 54.0029 108.722L53.7218 108.588L53.6036 108.531L53.5174 108.451C53.4823 108.416 53.4439 108.384 53.4088 108.349L53.3129 108.24C53.2427 108.17 53.2011 108.087 53.1436 108.01C53.0542 107.847 52.9743 107.681 52.9584 107.505C52.9392 107.33 52.9488 107.154 52.9999 106.978C53.0478 106.828 53.1149 106.681 53.2011 106.541C53.2267 106.505 53.2554 106.47 53.2842 106.438C53.3928 106.311 53.5206 106.186 53.6484 106.061C53.7761 105.937 53.9039 105.815 54.0285 105.694C54.0573 105.668 54.086 105.64 54.1148 105.611C54.431 105.387 54.7696 105.199 55.1242 105.049C55.4948 104.902 55.8813 104.784 56.255 104.755ZM59.7849 111.888L59.7913 111.834C59.8009 111.763 59.8009 111.693 59.82 111.623L59.8743 111.415C59.9702 111.141 60.1107 110.875 60.2992 110.636C60.3407 110.572 60.3982 110.521 60.4493 110.46C60.5004 110.403 60.5516 110.345 60.6091 110.294L60.7784 110.134L60.9636 109.987C61.216 109.799 61.4907 109.63 61.7878 109.505C61.9316 109.435 62.0881 109.39 62.2382 109.336C62.3149 109.313 62.3948 109.297 62.4714 109.275C62.5098 109.265 62.5481 109.256 62.5896 109.246L62.7078 109.227C62.7877 109.217 62.8675 109.198 62.9474 109.195L63.187 109.182C63.2668 109.179 63.3467 109.189 63.4266 109.192C63.4649 109.195 63.5064 109.195 63.5448 109.198L63.6502 109.217C63.9345 109.278 64.1932 109.444 64.3689 109.681C64.4552 109.799 64.5223 109.933 64.5606 110.074C64.5957 110.214 64.6053 110.361 64.5861 110.505C64.5702 110.649 64.5095 110.786 64.436 110.914L64.3753 111.006C64.3561 111.038 64.3242 111.067 64.2986 111.096C64.2507 111.157 64.1868 111.211 64.1261 111.268C63.8738 111.492 63.5703 111.68 63.2509 111.85C62.9314 112.019 62.596 112.169 62.251 112.303C61.906 112.434 61.545 112.559 61.1968 112.632C60.887 112.693 60.5516 112.655 60.2417 112.533L60.1299 112.437L59.9957 112.284C59.9478 112.236 59.9223 112.172 59.8807 112.115C59.8392 112.061 59.82 111.993 59.7913 111.933L59.7721 111.891C59.7881 111.891 59.7849 111.885 59.7849 111.888ZM73.3804 114.939C73.735 115.36 74.0066 115.849 74.1727 116.376C74.1759 116.383 74.1759 116.386 74.1759 116.392C74.4697 117.296 74.4634 118.315 74.1024 119.222C73.9203 119.702 73.668 120.155 73.3645 120.58C73.0578 121.005 72.7032 121.401 72.3199 121.772C72.2432 121.848 72.1634 121.919 72.0835 121.992C72.1186 121.954 72.1538 121.915 72.1857 121.874C72.4764 121.516 72.716 121.104 72.847 120.647C72.9811 120.19 72.9811 119.698 72.8725 119.248C72.7639 118.794 72.5531 118.382 72.3135 118.018C71.8279 117.287 71.2338 116.699 70.7386 116.086C70.6173 115.932 70.4895 115.776 70.3936 115.629C70.2946 115.475 70.2116 115.312 70.1477 115.146C70.0167 114.808 69.9464 114.45 69.9528 114.099C69.9592 113.75 70.0423 113.409 70.2116 113.143C70.2978 113.009 70.4032 112.901 70.5278 112.814C70.5598 112.792 70.5885 112.773 70.6236 112.757C70.6524 112.738 70.6843 112.725 70.7163 112.712C70.7866 112.693 70.8536 112.677 70.9239 112.658L70.9335 112.683C70.9559 112.728 70.975 112.773 70.9942 112.814C71.0773 112.981 71.1539 113.112 71.2146 113.201C71.4606 113.575 71.7321 113.811 72.0068 113.98C72.1091 114.044 72.2113 114.095 72.3167 114.143C72.3071 114.15 72.2975 114.156 72.2911 114.162C72.4604 114.223 72.6298 114.284 72.7831 114.392C73.0035 114.543 73.2048 114.728 73.3804 114.939ZM74.8786 111.661C74.7381 111.862 74.5911 112.061 74.4442 112.259L74.2014 112.54C74.1184 112.632 74.0449 112.731 73.9523 112.814L73.6871 113.076L73.553 113.207L73.4092 113.326L73.1217 113.565C73.0738 113.603 73.0259 113.645 72.9748 113.68L72.8055 113.798C72.716 113.859 72.6266 113.923 72.5371 113.984C72.4381 113.878 72.3455 113.776 72.2528 113.674C72.058 113.45 71.8631 113.227 71.6586 112.907C71.6075 112.83 71.5436 112.719 71.4702 112.575C71.4606 112.556 71.451 112.533 71.4414 112.514C72.0292 112.348 72.5978 112.172 73.1409 111.962C73.9746 111.642 74.7477 111.243 75.4057 110.744C75.2524 111.057 75.0767 111.364 74.8786 111.661ZM75.3195 103.943C75.3706 103.975 75.4249 104.007 75.476 104.039C75.4952 104.058 75.5143 104.078 75.5335 104.097C75.7188 104.282 75.9168 104.464 76.1085 104.662L76.1373 104.793C76.1852 105.02 76.2523 105.244 76.2746 105.477C76.3066 105.71 76.3481 105.94 76.3513 106.176C76.4248 107.304 76.2682 108.467 75.8977 109.569C75.6805 109.815 75.4345 110.045 75.1598 110.259C74.5368 110.744 73.7861 111.134 72.9556 111.457C72.3391 111.693 71.6746 111.894 70.9782 112.086C70.9367 112.092 70.892 112.099 70.8504 112.105L70.745 112.131C70.7195 112.137 70.6939 112.147 70.6684 112.153C70.6173 112.169 70.563 112.185 70.515 112.211C70.515 112.211 70.515 112.211 70.5118 112.211C70.4256 112.233 70.3361 112.259 70.2467 112.281C69.2852 112.524 68.2725 112.751 67.2088 112.933C66.1482 113.115 65.0334 113.258 63.877 113.29C63.2988 113.306 62.7142 113.29 62.1296 113.214C61.9859 113.191 61.8389 113.169 61.6952 113.14C61.6441 113.127 61.5929 113.118 61.5386 113.105C61.8581 113.022 62.1552 112.917 62.4554 112.805C62.8196 112.664 63.1742 112.508 63.516 112.326C63.8578 112.144 64.19 111.939 64.4935 111.671C64.567 111.601 64.6437 111.537 64.7107 111.454C64.7459 111.412 64.781 111.377 64.8129 111.332L64.9056 111.195C65.0174 111.006 65.1005 110.802 65.1292 110.582C65.158 110.364 65.1452 110.144 65.0909 109.933C65.0334 109.725 64.9343 109.531 64.8098 109.361C64.5574 109.019 64.1805 108.78 63.7716 108.694L63.6182 108.665C63.5671 108.658 63.5224 108.658 63.4745 108.655C63.3786 108.652 63.2828 108.639 63.187 108.642L62.9027 108.655C62.8068 108.658 62.7174 108.681 62.6248 108.694L62.4874 108.716C62.4427 108.726 62.398 108.738 62.3532 108.748C62.2638 108.77 62.1743 108.789 62.0849 108.818C61.9124 108.879 61.7367 108.933 61.5706 109.01C61.2352 109.15 60.9253 109.342 60.6378 109.556L60.427 109.722L60.2321 109.904C60.165 109.962 60.1043 110.029 60.0468 110.099C59.9893 110.166 59.9254 110.23 59.8743 110.304C59.6539 110.585 59.4814 110.907 59.3632 111.249L59.2929 111.511C59.2929 111.517 59.293 111.521 59.2898 111.527C59.2834 111.502 59.277 111.473 59.2706 111.447C59.2674 111.409 59.2674 111.371 59.2642 111.332L59.261 111.275L59.2706 111.217C59.277 111.179 59.2802 111.141 59.2866 111.102L59.3249 110.99C59.3728 110.843 59.475 110.7 59.59 110.55C59.7082 110.403 59.8392 110.259 59.9766 110.118C60.2513 109.84 60.5548 109.578 60.871 109.342C61.0307 109.227 61.1936 109.115 61.3598 109.023C61.4428 108.978 61.5227 108.936 61.6089 108.908L61.8964 108.789C62.2829 108.633 62.6727 108.473 63.0624 108.313C64.6277 107.675 66.2313 107.017 67.8764 106.346C69.5216 105.675 71.2018 104.985 72.9236 104.282C73.3549 104.106 73.7861 103.931 74.2206 103.752L74.3835 103.685L74.4666 103.653C74.4857 103.646 74.4825 103.656 74.4921 103.65C74.54 103.65 74.6359 103.656 74.7317 103.688C74.9266 103.736 75.131 103.835 75.3195 103.943ZM74.7189 103.039C74.7317 103.068 74.7477 103.1 74.7636 103.129L74.6806 103.113L74.6263 103.103L74.5656 103.1L74.5017 103.097C74.4825 103.097 74.4602 103.097 74.4314 103.1C74.3835 103.107 74.3196 103.119 74.2813 103.132L74.1982 103.164L74.0353 103.231C73.6009 103.41 73.1664 103.586 72.7384 103.761C71.0166 104.464 69.3331 105.154 67.6911 105.825C66.7616 106.205 65.8479 106.579 64.9439 106.949C64.9854 106.927 65.027 106.908 65.0717 106.886C66.7552 106.01 68.4099 105.036 70.087 104.055C70.5054 103.812 70.9271 103.567 71.3488 103.324C71.7705 103.078 72.1985 102.848 72.6298 102.583C73.4795 102.059 74.2972 101.458 75.0032 100.711C74.9904 100.733 74.9745 100.765 74.9521 100.807C74.9074 100.89 74.8403 101.021 74.7605 101.203C74.6838 101.385 74.5911 101.624 74.5496 101.941C74.5081 102.26 74.5336 102.659 74.7189 103.039ZM73.8948 94.523C74.128 94.8425 74.3899 95.1268 74.6391 95.4015C74.9809 95.7785 75.3099 96.1458 75.5335 96.5579C75.7571 96.9636 75.8689 97.4236 75.8561 97.8772C75.8402 98.334 75.6932 98.7812 75.4728 99.1965C75.2492 99.6118 74.9521 99.9919 74.6231 100.343C73.9618 101.043 73.1728 101.627 72.3486 102.135C71.9398 102.388 71.5053 102.621 71.0804 102.867C70.6556 103.113 70.2339 103.359 69.8154 103.602C68.1384 104.582 66.4868 105.55 64.8225 106.419C63.1582 107.285 61.4748 108.064 59.7529 108.591C59.0118 108.818 58.2611 108.994 57.5105 109.09C57.7788 108.876 58.0152 108.614 58.1845 108.307C58.6125 107.528 58.6605 106.579 58.341 105.742C58.1813 105.327 57.9193 104.934 57.5552 104.64L57.4178 104.531C57.3699 104.496 57.3188 104.471 57.2677 104.439L57.1143 104.352C57.0568 104.327 56.993 104.301 56.9291 104.279C56.6799 104.205 56.4435 104.202 56.2135 104.218C56.073 104.228 55.9324 104.25 55.7982 104.279C56.8748 103.522 57.996 102.889 59.0949 102.298C60.2449 101.685 61.3789 101.113 62.4554 100.529C63.532 99.9408 64.5542 99.3371 65.4934 98.6822C65.7234 98.5129 65.9502 98.3436 66.1738 98.1743L66.3399 98.0497L66.4996 97.9156C66.605 97.8261 66.7105 97.7367 66.8159 97.6504C66.9213 97.561 67.0267 97.4747 67.1289 97.3853C67.2279 97.299 67.327 97.2096 67.426 97.1233C67.6241 96.9508 67.8221 96.7879 68.0202 96.6282C68.8124 95.9893 69.6174 95.4462 70.4288 95.0501C70.8345 94.8521 71.2434 94.6924 71.6491 94.5805C72.0547 94.4719 72.4573 94.408 72.847 94.3985C73.2143 94.3921 73.5657 94.4368 73.8948 94.523ZM73.5146 93.9001C73.2942 93.8714 73.0706 93.8554 72.8406 93.8586C72.3998 93.8682 71.9525 93.9385 71.5085 94.0599C71.0645 94.1844 70.6268 94.3537 70.1956 94.5646C69.3331 94.9862 68.4993 95.5517 67.6848 96.2065C67.4803 96.3694 67.2791 96.5387 67.0778 96.7144C66.9788 96.8039 66.8766 96.8901 66.7743 96.9796C66.6753 97.0626 66.5731 97.1489 66.4709 97.2351C66.3686 97.3214 66.2664 97.4076 66.1642 97.4939L66.0109 97.6249L65.848 97.7462C65.6307 97.9092 65.4103 98.0721 65.1867 98.2382C64.2731 98.8771 63.27 99.4712 62.2031 100.049C61.1361 100.631 60.0053 101.199 58.8457 101.819C58.4624 102.024 58.0791 102.234 57.6893 102.455C59.5134 101.19 61.3406 99.9249 63.171 98.6567C65.0845 97.331 67.0043 96.0021 68.921 94.6732C69.8825 94.0215 70.86 93.3155 71.6778 92.4339C72.0867 91.993 72.4604 91.5075 72.7384 90.9548C72.8118 90.8079 72.8789 90.6514 72.9364 90.4949C72.9205 91.2008 72.9396 91.9164 73.0834 92.6287C73.1696 93.0664 73.3102 93.4976 73.5146 93.9001ZM69.183 83.7386C69.4225 83.6747 69.6685 83.6332 69.9113 83.6236C70.4 83.6108 70.8824 83.7194 71.2945 83.9686C71.7098 84.2146 72.0452 84.5787 72.2975 85.0004C72.5499 85.4253 72.716 85.9044 72.831 86.3964C72.9428 86.8915 73.0003 87.3994 73.0163 87.9074C73.0227 88.0607 73.0195 88.2172 73.0195 88.3737C73.0003 88.3162 72.9843 88.2587 72.962 88.2044C72.863 87.901 72.7032 87.6262 72.5339 87.3643C72.1761 86.8532 71.7321 86.4347 71.2913 86.045C70.8473 85.6585 70.3968 85.2911 69.9975 84.895C69.643 84.55 69.3459 84.1762 69.1191 83.7546C69.1414 83.7514 69.1606 83.745 69.183 83.7386ZM68.4802 84.0069C68.5217 83.9846 68.5664 83.9654 68.6079 83.9462C68.8667 84.4478 69.2213 84.9014 69.6142 85.2815C70.0423 85.7032 70.4991 86.0769 70.9335 86.4539C71.3648 86.834 71.7737 87.2237 72.0867 87.671C72.2337 87.8978 72.371 88.131 72.4509 88.3865C72.5467 88.6357 72.5946 88.9008 72.6106 89.1628C72.6393 89.693 72.4988 90.2265 72.2496 90.7153C72.0036 91.2072 71.6586 91.6544 71.2753 92.0697C70.8888 92.485 70.4607 92.8619 70.0135 93.2197C69.5663 93.5775 69.0903 93.9001 68.6079 94.2324C66.6913 95.5612 64.7714 96.8901 62.8579 98.2158C60.9445 99.5415 59.031 100.867 57.1207 102.19C56.6384 102.519 56.1784 102.867 55.6896 103.081C55.4468 103.186 55.1945 103.257 54.9485 103.263C54.7057 103.273 54.4598 103.212 54.2042 103.116C54.185 103.11 54.1659 103.1 54.1467 103.094C54.3128 103.02 54.4757 102.94 54.6355 102.851C55.153 102.563 55.6353 102.215 56.0698 101.81C56.501 101.404 56.8875 100.931 57.1654 100.382C57.4402 99.8386 57.5999 99.1901 57.4817 98.5512C57.4625 98.4714 57.4498 98.3947 57.4274 98.3148C57.4018 98.2382 57.3795 98.1615 57.3507 98.0881L57.3028 97.9762C57.2677 97.9251 57.2709 97.8293 57.1974 97.8037L56.9674 97.6472C56.6991 97.4811 56.3988 97.3597 56.0889 97.2926C55.466 97.1553 54.8271 97.2351 54.2489 97.4204C53.6675 97.6057 53.1341 97.8964 52.6453 98.2446C52.2652 98.5193 51.9074 98.826 51.5911 99.1837C51.8275 98.8004 52.1214 98.4458 52.4505 98.12C52.6421 97.9283 52.8466 97.7462 53.0574 97.5705C53.1628 97.4811 53.2714 97.3949 53.3768 97.3118L53.7059 97.0467C54.5843 96.3407 55.4373 95.6155 56.2806 94.884C57.9673 93.4242 59.622 91.9483 61.2543 90.4693C62.8835 88.9903 64.4935 87.5176 66.0684 86.0194L66.6562 85.454C66.851 85.2624 67.0491 85.0579 67.2248 84.8822C67.6049 84.534 68.0234 84.2273 68.4802 84.0069ZM68.3907 83.4543C68.3428 83.4767 68.2917 83.499 68.2438 83.5246C67.7327 83.7706 67.2727 84.1092 66.8606 84.4957L66.2856 85.0739L65.7042 85.6329C64.7523 86.5401 63.7811 87.4378 62.8004 88.3386C63.1391 88.0064 63.4681 87.6646 63.7875 87.3164C63.96 87.1183 64.1357 86.9171 64.3082 86.719L64.567 86.4219L64.8129 86.1121C64.9759 85.9044 65.1388 85.7 65.3017 85.4924C65.4614 85.2847 65.6084 85.0675 65.7617 84.8567L65.9885 84.5372C66.0652 84.4318 66.1386 84.3232 66.2089 84.2146C66.3495 83.9942 66.49 83.7769 66.6306 83.5565C66.7009 83.4479 66.7743 83.3393 66.8382 83.2275L67.0331 82.8889L67.1417 82.7004C67.2759 82.4608 67.4068 82.2468 67.5027 82.0583C67.5985 81.8699 67.6752 81.7197 67.7263 81.6175C67.8093 81.4514 67.8828 81.298 67.9435 81.1543C67.9882 81.9242 68.1032 82.6972 68.3907 83.4543ZM64.468 74.3853L64.5734 74.1936C64.5734 74.1904 64.5734 74.1904 64.5766 74.1904C64.5798 74.1904 64.5893 74.1904 64.6053 74.1872C64.6373 74.184 64.6692 74.184 64.7011 74.184C64.765 74.1808 64.8289 74.184 64.8928 74.1872C65.1484 74.2 65.3975 74.2703 65.6339 74.3789C66.1067 74.5961 66.506 74.9826 66.8223 75.4235C67.1417 75.8675 67.3813 76.3754 67.5538 76.9025C67.8924 77.9503 67.8732 79.0939 67.902 80.263C67.8541 80.3333 67.8061 80.4036 67.7582 80.4739C67.5985 80.7358 67.4292 81.0073 67.2407 81.3715C67.1896 81.4705 67.1161 81.6175 67.0203 81.7996C66.9277 81.9817 66.7967 82.1925 66.6657 82.4289L66.5603 82.6142L66.3718 82.9464C66.3079 83.055 66.2345 83.1604 66.1674 83.269C66.03 83.483 65.8927 83.6971 65.7553 83.9143C65.6882 84.0229 65.6148 84.1283 65.5413 84.2305L65.3177 84.5436C65.1675 84.7512 65.0238 84.9653 64.8673 85.1665C64.7075 85.3678 64.5478 85.569 64.3881 85.7703L64.1485 86.0737L63.8929 86.3644C63.7236 86.5593 63.5543 86.7542 63.3818 86.949C61.9859 88.4792 60.3886 89.8496 58.6413 91.0347C58.4241 91.1849 58.1973 91.319 57.9736 91.4628C57.9385 91.4819 57.9066 91.5043 57.8746 91.5267C58.1366 91.2424 58.3825 90.9453 58.5934 90.6067C58.6732 90.4821 58.7435 90.3479 58.8074 90.2042C58.8393 90.1339 58.8649 90.054 58.8905 89.9773C58.9096 89.8911 58.9352 89.8176 58.9384 89.7218C58.932 89.6835 58.9671 89.5972 58.932 89.5365L58.8873 89.4056C58.8649 89.3321 58.833 89.2586 58.801 89.1883C58.7723 89.1149 58.7339 89.0478 58.6924 88.9807C58.6541 88.9104 58.6125 88.8465 58.5678 88.7858C58.2068 88.2779 57.6829 87.9297 57.1399 87.7061C56.8652 87.5943 56.5841 87.5112 56.2998 87.4537L56.1879 87.4346C56.1209 87.4314 56.0506 87.3931 55.9867 87.4154L55.8238 87.5017C55.7918 87.5176 55.7599 87.5336 55.7279 87.5528C55.6034 87.623 55.482 87.6965 55.3606 87.77C54.8814 88.0735 54.431 88.4121 54.0093 88.7858C53.5877 89.1596 53.1916 89.5685 52.8561 90.038C52.6868 90.2712 52.5399 90.5268 52.4217 90.7983C52.3035 91.0699 52.2173 91.3669 52.2045 91.6832C52.1917 91.9962 52.2588 92.3221 52.3993 92.6032C52.4984 92.8044 52.6293 92.9833 52.7795 93.1398C52.6517 93.06 52.5335 92.9801 52.4313 92.8875C52.2524 92.7278 52.1406 92.5393 52.0863 92.3125C52.0384 92.0857 52.0416 91.8301 52.0831 91.5714C52.1246 91.3126 52.1917 91.0507 52.278 90.7919C52.4505 90.2744 52.6741 89.7633 52.92 89.2586L53.0127 89.0701L53.0606 88.9775C53.067 88.9647 53.067 88.9615 53.0702 88.9615L53.3768 88.6836C53.5877 88.4919 53.8017 88.3003 54.0061 88.099C54.2106 87.901 54.4214 87.7061 54.6227 87.5017L55.2296 86.8915C56.0282 86.0705 56.8013 85.2208 57.552 84.3487C58.2963 83.4703 59.0214 82.579 59.721 81.659C60.4142 80.7358 61.0978 79.803 61.7367 78.8383C62.0657 78.3624 62.3724 77.8704 62.6886 77.3848L63.1454 76.6437L63.3723 76.2732L63.5927 75.8962L64.0335 75.1423L64.468 74.3853ZM105.159 72.3887C104.82 72.2066 104.472 72.0469 104.111 71.9096C103.744 71.7754 103.392 71.6764 103.034 71.5646C102.677 71.456 102.322 71.3441 101.964 71.2483C101.607 71.1493 101.249 71.0439 100.888 70.9544C99.4503 70.5775 97.9968 70.2836 96.5402 70.06C93.6268 69.6032 90.7007 69.4818 87.8225 69.4754C84.9411 69.4722 82.0949 69.5936 79.2838 69.7054C76.4727 69.8204 73.6839 69.9322 70.9431 70.2485C69.5727 70.405 68.215 70.6062 66.8766 70.8426C66.2089 70.9704 65.5381 71.0886 64.88 71.2323C64.551 71.3026 64.2188 71.3729 63.8898 71.44C63.5607 71.5135 63.2349 71.5901 62.9059 71.6636C62.251 71.8074 61.6025 71.9767 60.9573 72.1332C60.312 72.2929 59.6699 72.4686 59.031 72.6315L58.9128 72.6635L58.8106 72.6826C58.7755 72.689 58.7435 72.6986 58.7084 72.7018L58.6029 72.7082C58.4624 72.7178 58.3154 72.7018 58.1653 72.6794C57.865 72.6315 57.5616 72.5389 57.2421 72.4462C56.9227 72.36 56.5873 72.2642 56.2135 72.2546C56.0634 72.2546 55.91 72.2642 55.7599 72.3025C55.6609 72.3696 55.5586 72.4271 55.466 72.5005C55.4628 72.5037 55.4404 72.5197 55.4404 72.5229C55.4277 72.5357 55.4117 72.5485 55.3989 72.5612C55.3957 72.5644 55.367 72.5996 55.3638 72.5996C55.3574 72.6124 55.3478 72.6219 55.3414 72.6347C55.3382 72.6411 55.3286 72.6666 55.3286 72.6666C55.3254 72.6794 55.3223 72.6954 55.3191 72.7018C55.3191 72.7114 55.3159 72.7497 55.3159 72.7561C55.3159 72.7625 55.3159 72.7657 55.3159 72.7657C55.3159 72.7689 55.3191 72.7721 55.3191 72.7753C55.3382 72.8583 55.3574 72.8967 55.4213 72.9829C55.4373 73.0053 55.4309 72.9957 55.45 73.0212C55.4564 73.0308 55.466 73.0404 55.4756 73.05C56.0953 73.264 56.7182 73.4205 57.3443 73.5483C57.9832 73.6793 58.6221 73.7879 59.261 73.8742C59.8999 73.9604 60.5388 74.0371 61.1745 74.0882C61.3342 74.1042 61.4939 74.1169 61.6536 74.1265L62.0466 74.1553H62.0593C62.1839 74.1617 62.2957 74.168 62.4011 74.1744C62.612 74.1872 62.7781 74.1936 62.8931 74.1936C63.3275 74.2032 63.6693 74.184 63.992 74.1329L63.5799 74.874L63.1454 75.6183L62.9282 75.9921L62.7014 76.3594L62.2478 77.0942C61.9316 77.5733 61.6313 78.0621 61.3055 78.5348C61.1361 78.7904 60.9605 79.046 60.7848 79.2983C60.8486 79.1418 60.9061 78.9789 60.9541 78.8128C61.0786 78.3496 61.2607 77.896 61.4204 77.4136C61.5003 77.174 61.577 76.9249 61.6345 76.6661C61.6632 76.5287 61.6856 76.3882 61.6984 76.2412C61.7111 76.2061 61.7207 76.171 61.7303 76.1358C61.7686 75.9697 61.7814 75.7812 61.7239 75.5928C61.6696 75.4043 61.5482 75.2414 61.4109 75.1296C61.2735 75.0146 61.1234 74.9411 60.9732 74.8868C60.9604 74.8836 60.9477 74.8804 60.9349 74.874C60.8838 74.8517 60.8295 74.8357 60.7784 74.8197C60.6378 74.775 60.4973 74.7526 60.3599 74.7367C59.8041 74.6824 59.2706 74.7622 58.7563 74.8836C58.242 75.005 57.7436 75.1743 57.2581 75.3787C57.0089 75.4842 56.7598 75.596 56.517 75.7205C52.9584 76.8961 49.3614 78.1419 45.8316 79.6785C44.7934 80.1321 43.7648 80.608 42.7457 81.1192C41.7299 81.6335 40.7268 82.1861 39.7525 82.793C39.3053 83.071 38.8613 83.3649 38.4268 83.6651C38.2575 83.4767 38.1361 83.2914 38.0116 83.0965C37.855 82.8506 37.6953 82.5854 37.51 82.2436C37.4525 82.1318 37.3567 81.9497 37.2641 81.7229C37.2161 81.6079 37.1714 81.4833 37.1267 81.3492C37.1139 81.3172 37.1043 81.2821 37.0948 81.2469L37.0788 81.1958L37.0724 81.1703L37.0149 80.9562C36.9702 80.7742 36.935 80.5921 36.9127 80.4068C36.8679 80.0394 36.8711 79.6689 36.9606 79.3303C37.0053 79.161 37.0692 79.0044 37.1586 78.8671L37.2289 78.768L37.3184 78.6626C37.3791 78.5924 37.4398 78.5221 37.5068 78.4582C37.7688 78.193 38.0659 77.9599 38.3853 77.7554C39.0274 77.3497 39.7557 77.0622 40.5 76.8162C41.2475 76.5735 42.0206 76.353 42.7841 76.1198C43.5507 75.8898 44.3174 75.6599 45.0841 75.4267C46.6206 74.9635 48.1603 74.5003 49.7064 74.0371C50.4795 73.8039 51.2525 73.5707 52.0256 73.3375L53.1884 72.9893L53.2427 72.9733C53.2427 72.9765 53.2427 72.9765 53.2459 72.9797C53.2746 72.9574 53.3002 72.9318 53.3257 72.9094C53.3257 72.9062 53.3289 72.903 53.3289 72.903C53.3321 72.8967 53.3385 72.8807 53.3385 72.8775C53.3225 72.7817 53.2874 72.6155 53.2523 72.4846C53.2491 72.4814 53.2395 72.4686 53.2363 72.4654C53.2235 72.4526 53.2139 72.4398 53.2011 72.4271C53.1979 72.4239 53.1916 72.4175 53.1884 72.4143L53.1277 72.4175L52.8242 72.4367L52.2173 72.475C48.9845 72.6922 45.707 72.9925 42.5221 73.8518C40.9345 74.283 39.3724 74.858 37.9093 75.6407L37.6346 75.7844C37.542 75.8323 37.4557 75.8898 37.3663 75.9442L36.8328 76.2668L36.5677 76.4297C36.4814 76.484 36.3984 76.5479 36.3121 76.6086L35.8042 76.9696L35.5518 77.1516C35.4688 77.2123 35.3921 77.2826 35.3123 77.3497L34.8331 77.749C34.5073 78.0078 34.2166 78.308 33.9163 78.5636C33.616 78.8223 33.3093 79.0555 32.9707 79.1961C32.6353 79.343 32.2648 79.391 31.8942 79.3718C31.5205 79.3494 31.1435 79.26 30.7825 79.1226C30.6004 79.0555 30.4216 78.9757 30.2491 78.8894L29.7316 78.5987C28.3771 77.7746 27.3102 76.5319 26.4573 75.1743C25.6011 73.8103 24.9399 72.3249 24.3106 70.8267C23.6877 69.3221 23.0679 67.8143 22.5025 66.2937C21.9435 64.7732 21.4356 63.2367 21.0682 61.6714C20.9692 61.2817 20.8957 60.8855 20.8127 60.4958C20.7456 60.0997 20.6657 59.7068 20.6178 59.3107C20.4996 58.5185 20.4453 57.723 20.4166 56.9244C20.3782 55.3304 20.5348 53.7364 20.7999 52.1647C20.9309 51.3789 21.0938 50.5962 21.2695 49.82L21.4068 49.2386L21.442 49.0917L21.458 49.0182C21.4643 48.9926 21.4707 48.9735 21.4739 48.9383C21.4835 48.8712 21.4995 48.8074 21.4963 48.7339L21.4931 48.6285C21.4899 48.5933 21.4803 48.5582 21.4739 48.523C21.4164 48.2419 21.2088 48.0055 20.9564 47.8873C20.8286 47.8298 20.6881 47.8011 20.5443 47.8043C20.4006 47.8139 20.2536 47.8458 20.1323 47.9257C20.0652 47.9576 20.0173 48.0087 19.9629 48.0535C19.915 48.1014 19.8703 48.1589 19.832 48.2068L19.6659 48.4655L19.3336 48.983C19.2314 49.1587 19.142 49.344 19.0429 49.5229C18.9503 49.705 18.8449 49.8807 18.7714 50.0692C18.6149 50.4429 18.4392 50.8135 18.3178 51.2L18.1198 51.775L17.9632 52.3596C17.5511 53.9217 17.3723 55.5253 17.3595 57.1193C17.3435 58.7133 17.4841 60.2946 17.7396 61.8471C17.7971 62.2368 17.8834 62.6201 17.9536 63.0067C18.0367 63.39 18.1229 63.7733 18.2124 64.1535C18.4009 64.9105 18.6021 65.6644 18.8225 66.4087C19.7074 69.3828 20.8159 72.2801 22.3652 74.9155C23.1478 76.2253 24.0518 77.4711 25.1635 78.5221C25.7193 79.046 26.3327 79.5123 27.0035 79.8861C27.0866 79.9372 27.1728 79.9787 27.2591 80.0203L27.39 80.0842C27.3932 80.0873 27.3932 80.0873 27.3964 80.0873C27.3741 80.0937 27.2942 80.1161 27.0546 80.1832C25.6618 80.5729 24.2211 80.7678 22.79 80.8987C21.3557 81.0265 19.9246 81.0872 18.4999 81.1607C17.0688 81.2278 15.6664 81.3747 14.2896 81.3396C13.6028 81.3236 12.9224 81.2629 12.2643 81.1223C11.6063 80.985 10.977 80.7614 10.3892 80.4547C9.21364 79.8414 8.25212 78.8862 7.43753 77.8544C6.62615 76.813 5.97767 75.663 5.43462 74.4843C4.89156 73.3023 4.45712 72.0853 4.10253 70.8618C3.74795 69.6383 3.47003 68.4085 3.26559 67.1818C3.16336 66.5685 3.07712 65.9583 3.01003 65.3482C2.93976 64.738 2.88545 64.1279 2.84073 63.5242C2.75448 62.3167 2.71295 61.1251 2.80878 59.9623C2.84712 59.381 2.93976 58.8123 3.05476 58.2533C3.12823 57.9786 3.17934 57.7007 3.27517 57.4355C3.3199 57.3014 3.35823 57.1672 3.40614 57.0362C3.46045 56.9085 3.51156 56.7775 3.56586 56.6497C3.59142 56.5858 3.61698 56.5219 3.64573 56.458L3.74156 56.2728C3.80545 56.1514 3.86614 56.0268 3.93003 55.9054C4.0035 55.7904 4.07698 55.6754 4.15045 55.5604L4.25906 55.3879L4.38364 55.225C4.69989 54.7842 5.08003 54.3976 5.49211 54.0558C6.50475 53.2221 7.71545 52.6598 8.93892 52.1743C10.172 51.6951 11.4178 51.2351 12.6381 50.7719C13.2514 50.5419 13.8616 50.3119 14.4685 50.0819C14.772 49.9669 15.0755 49.8519 15.3789 49.7401C15.6824 49.6251 15.9891 49.5069 16.2925 49.3696C16.596 49.229 16.8963 49.0725 17.1742 48.8712C17.4553 48.6732 17.7141 48.4272 17.9185 48.1397C18.1293 47.8522 18.2667 47.5328 18.3817 47.2229C18.4935 46.913 18.583 46.6032 18.682 46.3125C18.781 46.0218 18.8864 45.7407 19.0334 45.4979C19.1803 45.2551 19.3656 45.0507 19.5892 44.8814C20.0364 44.5492 20.621 44.399 21.1673 44.4661C21.7135 44.53 22.1991 44.8494 22.5281 45.2967C22.6942 45.5203 22.8188 45.7726 22.8955 46.0378C22.9338 46.1719 22.9657 46.3061 22.9785 46.4403C22.9881 46.5073 22.9945 46.5776 22.9945 46.6447L22.9977 46.7469L22.9721 46.9705C22.9625 47.0472 22.9561 47.1175 22.9466 47.1973L22.9114 47.4337L22.8923 47.5519C22.8667 47.6158 22.9466 47.5487 22.9689 47.5519L23.1861 47.4753C23.4193 47.3954 23.6493 47.3123 23.8825 47.2325C24.17 47.1335 24.4575 47.0312 24.745 46.9322C25.3168 46.7246 25.8822 46.5105 26.4477 46.3029C27.0099 46.0825 27.5657 45.8653 28.1216 45.6448C28.6742 45.418 29.2236 45.1912 29.7699 44.9676C34.1335 43.134 38.2448 41.1694 42.1899 39.256C44.1609 38.2944 46.0935 37.3521 47.9878 36.4257C48.4606 36.1957 48.9334 35.9657 49.403 35.7389C49.8693 35.5025 50.3357 35.2661 50.7989 35.0329C51.2621 34.7965 51.7221 34.5697 52.1789 34.3301C52.6293 34.0842 53.0766 33.8382 53.5206 33.5954C57.0824 31.6404 60.3886 29.5768 63.5 27.5164C66.6018 25.44 69.5024 23.3572 72.2304 21.3096C73.5817 20.2682 74.9106 19.2651 76.1756 18.2397C77.4566 17.2367 78.6673 16.2112 79.862 15.2242C80.4561 14.729 81.0279 14.2211 81.6029 13.7292C81.8873 13.4832 82.1716 13.2372 82.4527 12.9944C82.737 12.7517 83.0053 12.4993 83.28 12.2533C83.8263 11.7614 84.3629 11.2726 84.8964 10.7935C85.4171 10.3015 85.9314 9.81277 86.4361 9.3336C86.6885 9.09402 86.9409 8.85443 87.19 8.61804C87.4328 8.37527 87.6756 8.13249 87.9152 7.8929C88.3911 7.41054 88.8703 6.94415 89.3271 6.46499C89.423 6.36277 89.5156 6.26054 89.6114 6.15832C89.5475 6.5736 89.5028 6.99207 89.4709 7.40735C89.4389 7.80985 89.4166 8.21235 89.3974 8.61166L89.3559 9.81596L89.3367 10.4165V11.0171L89.3335 12.2214C89.3654 13.825 89.423 15.4286 89.5571 17.0226C89.736 19.3418 90.0107 21.6514 90.3589 23.9418C90.097 22.9643 89.8255 21.9453 89.5475 20.8975C89.391 20.3353 89.2377 19.773 89.0588 19.2076C89.0364 19.1374 89.0141 19.0671 88.9885 18.9936L88.9054 18.7604C88.8575 18.6294 88.7905 18.4985 88.7329 18.3675L88.6882 18.2685L88.6659 18.2205L88.6531 18.195C88.6499 18.1822 88.6435 18.1822 88.6371 18.1886L88.4582 18.3036C88.158 18.508 87.8577 18.7125 87.5542 18.9169C86.5799 19.5846 85.6024 20.2554 84.6185 20.9294C82.6603 22.2711 80.683 23.6255 78.712 24.9736L78.827 24.8746C80.1495 23.7437 81.4624 22.6321 82.7306 21.5332C83.9924 20.4247 85.1743 19.2811 86.1454 18.0608C86.8227 17.2047 87.4168 16.2847 87.8449 15.2912C87.896 15.1762 87.9439 15.058 87.9886 14.9398C88.0877 14.7514 88.1803 14.5597 88.2634 14.3617C88.3624 14.1189 88.4454 13.8697 88.5029 13.611C88.5636 13.3522 88.6052 13.0871 88.6148 12.8187C88.6243 12.5504 88.618 12.2789 88.5732 12.0105C88.5668 11.9435 88.5509 11.8764 88.5381 11.8093L88.5221 11.7294C88.5253 11.7294 88.5253 11.7262 88.5221 11.7262L88.5189 11.7103L88.5125 11.6847C88.7905 11.6368 88.5189 11.6719 88.2698 11.7103C88.2793 11.6943 88.2889 11.6815 88.2953 11.6687C88.2634 11.6879 88.2378 11.7039 88.2059 11.7198C88.0557 11.7422 87.9311 11.7646 87.9759 11.7614V11.7997C87.8545 11.8189 87.8034 11.8285 87.9759 11.8093C87.9759 11.8253 87.9759 11.8412 87.9759 11.854C87.5255 12.1255 87.1677 12.3779 86.6693 12.8283C86.5863 12.9018 86.4617 13.0168 86.3084 13.1542C86.2317 13.2244 86.1454 13.3011 86.056 13.381C85.6056 13.7835 85.1488 14.1923 84.6824 14.6076C84.1489 15.0868 83.6059 15.5724 83.066 16.0803C82.5229 16.585 81.9927 17.1153 81.456 17.6455C80.9161 18.1758 80.3699 18.7093 79.8109 19.246C77.5843 21.3894 75.1981 23.568 72.5084 25.5039C69.8186 27.4429 66.8702 29.1743 63.845 30.8801C57.8075 34.3046 51.4474 37.5693 45.1032 40.4794C38.7591 43.396 32.4405 45.9867 26.5148 48.1493C25.7768 48.4272 25.0389 48.686 24.3138 48.9447C24.0774 49.0278 23.841 49.114 23.6046 49.1971C23.4225 49.261 23.2436 49.3248 23.0616 49.3919C22.8891 49.4558 22.7166 49.5197 22.5409 49.5836L22.2853 49.6794L22.1575 49.7273L22.0936 49.7497C22.0617 49.7593 22.0553 49.7657 22.0936 49.7689C22.2757 49.804 22.461 49.8392 22.6431 49.8711C23.0073 49.9414 23.3714 50.0085 23.7356 50.0787C23.8218 50.0979 23.9145 50.1107 24.0071 50.1203L24.17 50.1394L24.4543 50.1746C24.5502 50.1842 24.6428 50.2001 24.7386 50.2065L25.0229 50.2225C25.2114 50.2321 25.4031 50.2448 25.5916 50.248C25.78 50.2448 25.9685 50.2448 26.1538 50.2416C26.2464 50.2385 26.3423 50.2417 26.4349 50.2385L26.7128 50.2193C26.8981 50.2065 27.0834 50.1937 27.2655 50.181C27.4475 50.1586 27.6296 50.1362 27.8117 50.1171L28.0832 50.0851L28.3516 50.0404C29.7827 49.8104 31.1371 49.4367 32.4085 49.0022C33.6831 48.5678 34.881 48.0822 36.0182 47.603C40.5575 45.6768 44.2184 43.9198 46.7516 42.6772C48.0134 42.0447 49.0068 41.5655 49.6713 41.211C50.3389 40.866 50.6903 40.6807 50.6903 40.6807C50.6903 40.6807 50.981 40.5305 51.5496 40.2335C52.1214 39.946 52.9552 39.486 54.0573 38.8918C55.1625 38.3072 56.5074 37.5374 58.1046 36.6397C59.6891 35.7229 61.5195 34.6592 63.5511 33.4101C63.8067 33.2568 64.0654 33.0971 64.3274 32.9373C64.5861 32.7744 64.8513 32.6083 65.1164 32.4422C65.6499 32.1068 66.1961 31.7618 66.7552 31.4072C67.3174 31.059 67.886 30.6821 68.4674 30.3019C69.0488 29.9218 69.6429 29.5321 70.2531 29.1328C72.6617 27.5036 75.278 25.7211 78.0156 23.6958C78.3574 23.4435 78.7056 23.1911 79.0538 22.9355C79.3988 22.6736 79.747 22.4117 80.0984 22.1465C80.4498 21.8814 80.8043 21.613 81.1621 21.3447C81.5199 21.0764 81.8809 20.8048 82.2355 20.5205C82.951 19.9583 83.6793 19.3897 84.4204 18.8115C84.8836 18.4473 85.3436 18.064 85.7909 17.6519C85.7685 17.6807 85.7493 17.7094 85.727 17.735C83.8486 20.1117 81.095 22.188 78.482 24.4753C77.217 25.555 75.9488 26.6379 74.6806 27.7208C74.6806 27.74 74.6806 27.7592 74.6838 27.7783C74.6838 27.7943 74.687 27.8103 74.687 27.8262C74.687 27.8294 74.6902 27.8454 74.6902 27.855C74.6966 27.8901 74.7029 27.9253 74.7157 27.9572C74.7221 27.9764 74.7285 27.9955 74.7349 28.0147C74.7381 28.0211 74.7477 28.0435 74.7477 28.0499C74.7605 28.0722 74.77 28.0946 74.7828 28.1169C74.7892 28.1265 74.7988 28.1329 74.8052 28.1425C74.8052 28.1425 74.8084 28.1457 74.8116 28.1489C74.818 28.1521 74.8307 28.1617 74.8339 28.1648C74.8467 28.1712 74.8595 28.1776 74.8691 28.184C74.8691 28.184 74.8691 28.184 74.8723 28.184C74.8946 28.1904 74.9138 28.2 74.9361 28.2032C74.9457 28.2064 74.9521 28.2064 74.9617 28.2096C76.3257 27.2736 77.677 26.3504 79.0027 25.4432C80.98 24.0887 82.9606 22.7311 84.9284 21.383C85.9123 20.709 86.8898 20.0382 87.8641 19.3705C88.0493 19.2428 88.2314 19.1182 88.4167 18.9936L88.4806 19.1757C88.5061 19.2428 88.5253 19.3098 88.5477 19.3801C88.7234 19.9296 88.8735 20.4918 89.03 21.0508C89.4549 22.6417 89.8638 24.1718 90.2375 25.5837C90.3334 25.9351 90.4132 26.2226 90.4611 26.3887C90.5761 26.788 90.688 27.0915 90.8221 27.3758C90.8796 27.494 90.9371 27.609 91.0042 27.724C92.0999 33.573 93.5917 39.3071 95.2911 44.9197C97.112 50.9125 99.1756 56.7711 101.361 62.4955C102.456 65.3578 103.581 68.1848 104.728 70.9832C104.801 71.1589 104.865 71.3314 104.948 71.5103L105.069 71.7786L105.207 72.0373C105.319 72.2386 105.437 72.4366 105.561 72.6251C105.427 72.5389 105.296 72.459 105.159 72.3887ZM84.0818 18.3803C83.3439 18.9585 82.6188 19.5271 81.9032 20.0861C81.5486 20.3672 81.1877 20.6387 80.8331 20.9071C80.4753 21.1754 80.1239 21.4437 79.7725 21.7089C79.4212 21.974 79.0761 22.236 78.7311 22.4979C78.3829 22.7535 78.038 23.0058 77.6961 23.255C74.9681 25.2771 72.3582 27.0532 69.956 28.6792C69.3491 29.0753 68.7549 29.465 68.1767 29.8451C67.5953 30.2253 67.0331 30.599 66.4709 30.9472C65.9118 31.2986 65.3656 31.6436 64.8353 31.979C64.5702 32.1451 64.3082 32.3112 64.0495 32.4742C63.7875 32.6339 63.532 32.7904 63.2764 32.9437C61.2511 34.1896 59.4239 35.2501 57.8427 36.1669C56.2486 37.0614 54.907 37.828 53.8049 38.4126C52.706 39.0036 51.8755 39.4636 51.3036 39.7511C50.7382 40.045 50.4475 40.1951 50.4475 40.1951C50.4475 40.1951 50.0961 40.3772 49.4317 40.7222C48.7705 41.0736 47.7802 41.5528 46.5216 42.1853C43.9948 43.4247 40.3435 45.1785 35.817 47.0983C34.6861 47.5775 33.4978 48.0567 32.2456 48.4847C30.9934 48.9128 29.6677 49.2769 28.2781 49.5005L28.0161 49.5421L27.7542 49.574C27.5785 49.5964 27.4028 49.6155 27.2239 49.6379C27.045 49.6507 26.8693 49.6635 26.6904 49.673L26.4221 49.6922C26.3327 49.6954 26.2432 49.6954 26.1538 49.6954C25.9749 49.6986 25.7928 49.6986 25.6107 49.7018C25.4286 49.6954 25.2498 49.6826 25.0677 49.6762L24.7929 49.6635C24.7003 49.6571 24.6109 49.6443 24.5214 49.6347C24.3904 49.6187 24.2627 49.6028 24.1317 49.59L24.2371 49.5517L24.5086 49.4558C25.237 49.1971 25.9749 48.9383 26.716 48.6604C32.6545 46.4946 38.9859 43.8975 45.346 40.9746C51.7061 38.0548 58.0791 34.7837 64.1293 31.3529C67.1577 29.6439 70.1253 27.9029 72.8406 25.9447C75.5623 23.9865 77.9677 21.7855 80.2006 19.6357C80.7596 19.099 81.3091 18.5624 81.8489 18.0321C82.392 17.5018 82.9159 16.9747 83.4525 16.4764C83.986 15.9748 84.5259 15.4893 85.0561 15.0133C85.5225 14.598 85.9793 14.1892 86.4298 13.7835C86.5192 13.7004 86.6055 13.6237 86.6821 13.5535C86.8355 13.4129 86.96 13.2979 87.0431 13.2244C87.4743 12.8251 87.7395 12.5089 87.9918 12.1447C87.9918 12.1543 87.9918 12.1639 87.9918 12.1735C87.9886 13.0328 87.813 13.8953 87.4999 14.7226C87.1485 15.3711 86.6853 15.9621 86.1838 16.4987C85.5257 17.1887 84.8166 17.8053 84.0818 18.3803ZM114.557 76.3978L114.467 76.484C114.435 76.5096 114.4 76.5351 114.365 76.5607C114.295 76.6086 114.234 76.6661 114.161 76.7076C113.908 76.8674 113.624 76.976 113.33 77.0526C113.123 77.0367 112.915 77.0111 112.714 76.9823C112.001 76.861 111.318 76.6022 110.676 76.2508C110.034 75.8994 109.427 75.4746 108.836 75.021C108.222 74.5546 107.619 74.0594 106.992 73.5899C106.737 73.2992 106.491 73.0021 106.264 72.689C106.047 72.3951 105.849 72.0853 105.673 71.769L105.545 71.5294L105.434 71.2835C105.36 71.1205 105.29 70.9385 105.216 70.766C104.073 67.974 102.948 65.1469 101.856 62.2911C99.6739 56.5762 97.6167 50.7304 95.7991 44.7536C93.9878 38.7768 92.4161 32.6594 91.3077 26.4239C90.7518 23.3061 90.3334 20.1564 90.0874 16.9875C89.9564 15.403 89.8989 13.8122 89.867 12.2214L89.8702 11.0267V10.4293L89.8893 9.83193L89.9309 8.6404C89.95 8.2411 89.9724 7.84499 90.0043 7.45207C90.0586 6.76207 90.1449 6.07527 90.3046 5.41402C90.4164 5.29263 90.5314 5.17124 90.6432 5.05304C90.7167 5.35013 90.7902 5.64721 90.8605 5.9411C91.4546 8.34971 92.0105 10.6146 92.5312 12.7389C93.5757 16.9843 94.4798 20.6579 95.2496 23.7885C96.7893 30.0464 97.7924 34.1193 98.3003 36.1925C99.4439 40.834 100.453 44.9485 101.348 48.5869C101.571 49.4973 101.789 50.379 101.999 51.2287C102.105 51.6536 102.207 52.0753 102.309 52.4874C102.36 52.6918 102.412 52.8962 102.459 53.1007L102.498 53.2508L102.507 53.2828C102.341 53.3083 102.389 53.3051 102.511 53.2892L102.52 53.3243L102.523 53.3435C102.498 53.3498 102.536 53.3467 102.603 53.3371C102.667 53.5639 102.75 53.8067 102.862 54.0878C103.054 54.5861 103.437 55.5796 103.903 56.7935C104.172 57.493 104.453 58.2214 104.756 58.9689C104.906 59.3426 105.066 59.7196 105.226 60.0997C105.386 60.4767 105.542 60.8536 105.689 61.2465C106.28 62.8022 106.788 64.4505 107.379 66.0414C107.673 66.8368 107.986 67.6162 108.34 68.3605C108.692 69.1049 109.078 69.8172 109.526 70.4561C109.97 71.0982 110.465 71.6764 111.011 72.1364C111.557 72.5996 112.142 72.9542 112.717 73.1873C112.857 73.2512 113.001 73.3055 113.161 73.3471C113.321 73.3886 113.503 73.411 113.688 73.379C113.71 73.3758 113.733 73.3694 113.755 73.363L113.8 73.3535C113.825 73.3471 113.851 73.3407 113.886 73.3343C113.953 73.3215 114.017 73.3087 114.081 73.296C114.218 73.264 114.356 73.2257 114.483 73.1682C114.742 73.0564 114.953 72.8871 115.109 72.7114C115.183 72.6219 115.253 72.5357 115.314 72.4462C115.368 72.3568 115.423 72.2737 115.467 72.1907C115.547 72.0246 115.621 71.8776 115.662 71.7467C115.688 71.6796 115.71 71.6221 115.729 71.5646C115.748 71.5103 115.761 71.4592 115.774 71.4112C115.825 71.2291 115.854 71.1333 115.854 71.1333C115.854 71.1333 115.873 71.0375 115.914 70.8522C115.959 70.6701 115.998 70.3986 116.045 70.0536C116.081 69.7118 116.125 69.2965 116.176 68.8205C116.205 68.581 116.218 68.3254 116.237 68.0539C116.253 67.7823 116.272 67.498 116.291 67.201C116.314 66.9039 116.311 66.5908 116.323 66.2682C116.33 65.9455 116.346 65.6069 116.343 65.2619C116.333 64.5687 116.336 63.834 116.291 63.0705C116.269 62.3039 116.196 61.5117 116.132 60.6971C116.09 60.2914 116.045 59.8793 116.004 59.464C115.962 59.0487 115.899 58.6335 115.844 58.2118C115.72 57.3078 115.576 56.3942 115.416 55.4901C115.745 56.7072 116.036 57.9371 116.263 59.1861C116.509 60.5725 116.684 61.978 116.761 63.3996C116.841 64.8211 116.838 66.2522 116.748 67.6865C116.652 69.1208 116.474 70.5551 116.205 71.9798C116.065 72.689 115.911 73.4046 115.729 74.1041C115.544 74.7973 115.311 75.4778 114.902 76.024C114.796 76.1646 114.681 76.286 114.557 76.3978ZM117.547 71.3282C117.521 72.0789 117.432 72.8232 117.25 73.5419C117.071 74.2607 116.787 74.9475 116.387 75.548C116.189 75.8483 115.953 76.1262 115.691 76.3658C115.624 76.4265 115.557 76.4808 115.49 76.5383C115.419 76.5926 115.349 76.6469 115.279 76.6948C115.145 76.7907 114.991 76.861 114.835 76.9185C114.812 76.9248 114.787 76.9312 114.764 76.9376C114.784 76.9248 114.803 76.9089 114.822 76.8961L114.931 76.7907C115.078 76.6533 115.218 76.5064 115.333 76.3467C115.812 75.7046 116.058 74.9603 116.25 74.2415C116.435 73.5196 116.592 72.8008 116.732 72.0789C117.004 70.6318 117.189 69.1751 117.285 67.7185C117.358 66.5876 117.374 65.46 117.339 64.3387C117.515 66.6771 117.595 69.0154 117.547 71.3282Z" stroke="#003061" stroke-width="0.2" mask="url(#path-1-outside-1_3906_8185)"/>
                </svg>
            <?php endif; ?>
        </div>
        <div class="ft-highlights-details">
            <h2 class="tf-section-title">
            <?php echo !empty($meta['highlights-section-title']) ? esc_html($meta['highlights-section-title']) : esc_html__("Highlights","tourfic"); ?>
            </h2>
            <?php echo wp_kses_post($highlights); ?>
        </div>
    </div>
</div>
<!--Highlights End -->