/*!
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/function MarkerLabel_(marker,crossURL,handCursorURL){this.marker_=marker;this.handCursorURL_=marker.handCursorURL;this.labelDiv_=document.createElement("div");this.labelDiv_.style.cssText="position: absolute; overflow: hidden;";this.eventDiv_=document.createElement("div");this.eventDiv_.style.cssText=this.labelDiv_.style.cssText;this.eventDiv_.setAttribute("onselectstart","return false;");this.eventDiv_.setAttribute("ondragstart","return false;");this.crossDiv_=MarkerLabel_.getSharedCross(crossURL);}
MarkerLabel_.prototype=new google.maps.OverlayView();MarkerLabel_.getSharedCross=function(crossURL){var div;if(typeof MarkerLabel_.getSharedCross.crossDiv==="undefined"){div=document.createElement("img");div.style.cssText="position: absolute; z-index: 1000002; display: none;";div.style.marginLeft="-8px";div.style.marginTop="-9px";div.src=crossURL;MarkerLabel_.getSharedCross.crossDiv=div;}
    return MarkerLabel_.getSharedCross.crossDiv;};MarkerLabel_.prototype.onAdd=function(){var me=this;var cMouseIsDown=false;var cDraggingLabel=false;var cSavedZIndex;var cLatOffset,cLngOffset;var cIgnoreClick;var cRaiseEnabled;var cStartPosition;var cStartCenter;var cRaiseOffset=20;var cDraggingCursor="url("+this.handCursorURL_+")";var cAbortEvent=function(e){if(e.preventDefault){e.preventDefault();}
    e.cancelBubble=true;if(e.stopPropagation){e.stopPropagation();}};var cStopBounce=function(){me.marker_.setAnimation(null);};this.getPanes().overlayImage.appendChild(this.labelDiv_);this.getPanes().overlayMouseTarget.appendChild(this.eventDiv_);if(typeof MarkerLabel_.getSharedCross.processed==="undefined"){this.getPanes().overlayImage.appendChild(this.crossDiv_);MarkerLabel_.getSharedCross.processed=true;}
    this.listeners_=[google.maps.event.addDomListener(this.eventDiv_,"mouseover",function(e){me.labelDiv_.classList.add("hover");if(me.marker_.getDraggable()||me.marker_.getClickable()){this.style.cursor="pointer";google.maps.event.trigger(me.marker_,"mouseover",e);}}),google.maps.event.addDomListener(this.eventDiv_,"mouseout",function(e){me.labelDiv_.classList.remove("hover");if((me.marker_.getDraggable()||me.marker_.getClickable())&&!cDraggingLabel){this.style.cursor=me.marker_.getCursor();google.maps.event.trigger(me.marker_,"mouseout",e);}}),google.maps.event.addDomListener(this.eventDiv_,"mousedown",function(e){cDraggingLabel=false;if(me.marker_.getDraggable()){cMouseIsDown=true;this.style.cursor=cDraggingCursor;}
        if(me.marker_.getDraggable()||me.marker_.getClickable()){google.maps.event.trigger(me.marker_,"mousedown",e);cAbortEvent(e);}}),google.maps.event.addDomListener(document,"mouseup",function(mEvent){var position;if(cMouseIsDown){cMouseIsDown=false;me.eventDiv_.style.cursor="pointer";google.maps.event.trigger(me.marker_,"mouseup",mEvent);}
        if(cDraggingLabel){if(cRaiseEnabled){position=me.getProjection().fromLatLngToDivPixel(me.marker_.getPosition());position.y+=cRaiseOffset;me.marker_.setPosition(me.getProjection().fromDivPixelToLatLng(position));try{me.marker_.setAnimation(google.maps.Animation.BOUNCE);setTimeout(cStopBounce,1406);}catch(e){}}
            me.crossDiv_.style.display="none";me.marker_.setZIndex(cSavedZIndex);cIgnoreClick=true;cDraggingLabel=false;mEvent.latLng=me.marker_.getPosition();google.maps.event.trigger(me.marker_,"dragend",mEvent);}}),google.maps.event.addListener(me.marker_.getMap(),"mousemove",function(mEvent){var position;if(cMouseIsDown){if(cDraggingLabel){mEvent.latLng=new google.maps.LatLng(mEvent.latLng.lat()-cLatOffset,mEvent.latLng.lng()-cLngOffset);position=me.getProjection().fromLatLngToDivPixel(mEvent.latLng);if(cRaiseEnabled){me.crossDiv_.style.left=position.x+"px";me.crossDiv_.style.top=position.y+"px";me.crossDiv_.style.display="";position.y-=cRaiseOffset;}
        me.marker_.setPosition(me.getProjection().fromDivPixelToLatLng(position));if(cRaiseEnabled){me.eventDiv_.style.top=(position.y+cRaiseOffset)+"px";}
        google.maps.event.trigger(me.marker_,"drag",mEvent);}else{cLatOffset=mEvent.latLng.lat()-me.marker_.getPosition().lat();cLngOffset=mEvent.latLng.lng()-me.marker_.getPosition().lng();cSavedZIndex=me.marker_.getZIndex();cStartPosition=me.marker_.getPosition();cStartCenter=me.marker_.getMap().getCenter();cRaiseEnabled=me.marker_.get("raiseOnDrag");cDraggingLabel=true;me.marker_.setZIndex(1000000);mEvent.latLng=me.marker_.getPosition();google.maps.event.trigger(me.marker_,"dragstart",mEvent);}}}),google.maps.event.addDomListener(document,"keydown",function(e){if(cDraggingLabel){if(e.keyCode===27){cRaiseEnabled=false;me.marker_.setPosition(cStartPosition);me.marker_.getMap().setCenter(cStartCenter);google.maps.event.trigger(document,"mouseup",e);}}}),google.maps.event.addDomListener(this.eventDiv_,"click",function(e){if(me.marker_.getDraggable()||me.marker_.getClickable()){if(cIgnoreClick){cIgnoreClick=false;}else{google.maps.event.trigger(me.marker_,"click",e);cAbortEvent(e);}}}),google.maps.event.addDomListener(this.eventDiv_,"dblclick",function(e){if(me.marker_.getDraggable()||me.marker_.getClickable()){google.maps.event.trigger(me.marker_,"dblclick",e);cAbortEvent(e);}}),google.maps.event.addListener(this.marker_,"dragstart",function(mEvent){if(!cDraggingLabel){cRaiseEnabled=this.get("raiseOnDrag");}}),google.maps.event.addListener(this.marker_,"drag",function(mEvent){if(!cDraggingLabel){if(cRaiseEnabled){me.setPosition(cRaiseOffset);me.labelDiv_.style.zIndex=1000000+(this.get("labelInBackground")?-1:+1);}}}),google.maps.event.addListener(this.marker_,"dragend",function(mEvent){if(!cDraggingLabel){if(cRaiseEnabled){me.setPosition(0);}}}),google.maps.event.addListener(this.marker_,"position_changed",function(){me.setPosition();}),google.maps.event.addListener(this.marker_,"zindex_changed",function(){me.setZIndex();}),google.maps.event.addListener(this.marker_,"visible_changed",function(){me.setVisible();}),google.maps.event.addListener(this.marker_,"labelvisible_changed",function(){me.setVisible();}),google.maps.event.addListener(this.marker_,"title_changed",function(){me.setTitle();}),google.maps.event.addListener(this.marker_,"labelcontent_changed",function(){me.setContent();}),google.maps.event.addListener(this.marker_,"labelanchor_changed",function(){me.setAnchor();}),google.maps.event.addListener(this.marker_,"labelclass_changed",function(){me.setStyles();}),google.maps.event.addListener(this.marker_,"labelstyle_changed",function(){me.setStyles();})];};MarkerLabel_.prototype.onRemove=function(){var i;this.labelDiv_.parentNode.removeChild(this.labelDiv_);this.eventDiv_.parentNode.removeChild(this.eventDiv_);for(i=0;i<this.listeners_.length;i++){google.maps.event.removeListener(this.listeners_[i]);}};MarkerLabel_.prototype.draw=function(){this.setContent();this.setTitle();this.setStyles();};MarkerLabel_.prototype.setContent=function(){var content=this.marker_.get("labelContent");if(typeof content.nodeType==="undefined"){this.labelDiv_.innerHTML=content;this.eventDiv_.innerHTML=this.labelDiv_.innerHTML;}else{this.labelDiv_.innerHTML="";this.labelDiv_.appendChild(content);content=content.cloneNode(true);this.eventDiv_.appendChild(content);}};MarkerLabel_.prototype.setTitle=function(){this.eventDiv_.title=this.marker_.getTitle()||"";};MarkerLabel_.prototype.setStyles=function(){var i,labelStyle;this.labelDiv_.className=this.marker_.get("labelClass");this.eventDiv_.className=this.labelDiv_.className;this.labelDiv_.style.cssText="";this.eventDiv_.style.cssText="";labelStyle=this.marker_.get("labelStyle");for(i in labelStyle){if(labelStyle.hasOwnProperty(i)){this.labelDiv_.style[i]=labelStyle[i];this.eventDiv_.style[i]=labelStyle[i];}}
    this.setMandatoryStyles();};MarkerLabel_.prototype.setMandatoryStyles=function(){this.labelDiv_.style.position="absolute";this.labelDiv_.style.overflow="hidden";if(typeof this.labelDiv_.style.opacity!=="undefined"&&this.labelDiv_.style.opacity!==""){this.labelDiv_.style.filter="alpha(opacity="+(this.labelDiv_.style.opacity*100)+")";}
    this.eventDiv_.style.position=this.labelDiv_.style.position;this.eventDiv_.style.overflow=this.labelDiv_.style.overflow;this.eventDiv_.style.opacity=0.01;this.eventDiv_.style.filter="alpha(opacity=1)";this.setAnchor();this.setPosition();this.setVisible();};MarkerLabel_.prototype.setAnchor=function(){var anchor=this.marker_.get("labelAnchor");this.labelDiv_.style.marginLeft=-(this.labelDiv_.offsetWidth/2)+"px";this.labelDiv_.style.marginTop=-anchor.y+"px";this.eventDiv_.style.marginLeft=-(this.eventDiv_.offsetWidth/2)+"px";this.eventDiv_.style.marginTop=-anchor.y+"px";};MarkerLabel_.prototype.setPosition=function(yOffset){var position=this.getProjection().fromLatLngToDivPixel(this.marker_.getPosition());if(typeof yOffset==="undefined"){yOffset=0;}
    this.labelDiv_.style.left=Math.round(position.x)+"px";this.labelDiv_.style.top=Math.round(position.y-yOffset)+"px";this.eventDiv_.style.left=this.labelDiv_.style.left;this.eventDiv_.style.top=this.labelDiv_.style.top;this.setZIndex();};MarkerLabel_.prototype.setZIndex=function(){var zAdjust=(this.marker_.get("labelInBackground")?-1:+1);if(typeof this.marker_.getZIndex()==="undefined"){this.labelDiv_.style.zIndex=parseInt(this.labelDiv_.style.top,10)+zAdjust;this.eventDiv_.style.zIndex=this.labelDiv_.style.zIndex;}else{this.labelDiv_.style.zIndex=this.marker_.getZIndex()+zAdjust;this.eventDiv_.style.zIndex=this.labelDiv_.style.zIndex;}};MarkerLabel_.prototype.setVisible=function(){if(this.marker_.get("labelVisible")){this.labelDiv_.style.display=this.marker_.getVisible()?"block":"none";}else{this.labelDiv_.style.display="none";}
    this.eventDiv_.style.display=this.labelDiv_.style.display;};function prepareOptionsForMarkerWithLabel(opt_options){opt_options=opt_options||{};opt_options.labelContent=opt_options.labelContent||"";opt_options.labelAnchor=opt_options.labelAnchor||new google.maps.Point(0,0);opt_options.labelClass=opt_options.labelClass||"markerLabels";opt_options.labelStyle=opt_options.labelStyle||{};opt_options.labelInBackground=opt_options.labelInBackground||false;if(typeof opt_options.labelVisible==="undefined"){opt_options.labelVisible=true;}
    if(typeof opt_options.raiseOnDrag==="undefined"){opt_options.raiseOnDrag=true;}
    if(typeof opt_options.clickable==="undefined"){opt_options.clickable=true;}
    if(typeof opt_options.draggable==="undefined"){opt_options.draggable=false;}
    if(typeof opt_options.optimized==="undefined"){opt_options.optimized=false;}
    opt_options.crossImage=opt_options.crossImage||"http"+(document.location.protocol==="https:"?"s":"")+"://maps.gstatic.com/intl/en_us/mapfiles/drag_cross_67_16.png";opt_options.handCursor=opt_options.handCursor||"http"+(document.location.protocol==="https:"?"s":"")+"://maps.gstatic.com/intl/en_us/mapfiles/closedhand_8_8.cur";opt_options.optimized=false;return opt_options;}
function MarkerWithLabel(opt_options){opt_options=prepareOptionsForMarkerWithLabel(opt_options);this.label=new MarkerLabel_(this,opt_options.crossImage,opt_options.handCursor);google.maps.Marker.apply(this,arguments);}
MarkerWithLabel.prototype=new google.maps.Marker();MarkerWithLabel.prototype.setMap=function(theMap){google.maps.Marker.prototype.setMap.apply(this,arguments);this.label.setMap(theMap);};