<?php
/**
 * Shortcode module
 *
 * @package Top_Ten
 */

namespace WebberZone\Top_Ten\Frontend;

if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Admin Columns Class.
 *
 * @since 3.3.0
 */
class Shortcodes {

	/**
	 * Constructor class.
	 *
	 * @since 3.3.0
	 */
	public function __construct() {
		add_shortcode( 'tptn_list', array( __CLASS__, 'tptn_list' ) );
		add_shortcode( 'tptn_views', array( __CLASS__, 'tptn_views' ) );
	}

	/**
	 * Creates a shortcode [tptn_list limit="5" heading="1" daily="0"].
	 *
	 * @since 3.3.0
	 *
	 * @param   array  $atts       Shortcode attributes.
	 * @param   string $content    Content.
	 * @return  string  Formatted list of posts generated by tptn_pop_posts
	 */
	public static function tptn_list( $atts, $content = null ) { // phpcs:ignore Generic.CodeAnalysis.UnusedFunctionParameter.FoundAfterLastUsed
		global $tptn_settings;

		$wp_query_args = \WebberZone\Top_Ten\Util\Helpers::get_wp_query_arguments();

		$default_atts = array(
			'heading'         => 1,
			'daily'           => 0,
			'is_shortcode'    => 1,
			'offset'          => 0,
			'include_cat_ids' => '',
			'blog_id'         => get_current_blog_id(),
		);

		/**
		 * Filter the default shortcode attributes.
		 *
		 * @since 4.0.0
		 *
		 * @param array $default_atts Default shortcode attributes.
		 */
		$default_atts = apply_filters( 'tptn_shortcode_defaults', $default_atts );

		$atts = shortcode_atts(
			array_merge(
				$tptn_settings,
				$wp_query_args,
				$default_atts
			),
			$atts,
			'top-10'
		);

		return \WebberZone\Top_Ten\Frontend\Display::pop_posts( $atts );
	}

	/**
	 * Creates a shortcode [tptn_views daily="0"].
	 *
	 * @since 3.3.0
	 *
	 * @param   array  $atts           Shortcode attributes.
	 * @param   string $content        Content.
	 * @return  int  Views of the post
	 */
	public static function tptn_views( $atts, $content = null ) { // phpcs:ignore Generic.CodeAnalysis.UnusedFunctionParameter.FoundAfterLastUsed
		$a = shortcode_atts(
			array(
				'daily'         => '0',
				'count'         => 'total',
				'format_number' => true,
				'post_id'       => get_the_ID(),
			),
			$atts
		);

		// If daily is explicitly set to 1, then pass daily, else pass count.
		$count = $a['daily'] ? 'daily' : $a['count'];

		return \WebberZone\Top_Ten\Counter::get_post_count_only( $a['post_id'], $count, 0, array( 'format_number' => $a['format_number'] ) );
	}
}
