<?php
/**
 * Pro Designs and Plugins Feed
 *
 * @package Timeline and History Slider
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>
<div class="wrap wpostahs-wrap">
	<style type="text/css">
		.wpos-pro-box .hndle{background-color:#0073AA; color:#fff;}
		.wpos-pro-box.postbox{background:#dbf0fa none repeat scroll 0 0; border:1px solid #0073aa; color:#191e23;}
		.postbox-container .wpos-list li:before{font-family: dashicons; content: "\f139"; font-size:20px; color: #0073aa; vertical-align: middle;}
		.wpostahs-wrap .wpos-button-full{display:block; text-align:center; box-shadow:none; border-radius:0;}
		.wpostahs-shortcode-preview{background-color: #e7e7e7; font-weight: bold; padding: 2px 5px; display: inline-block; margin:0 0 2px 0;}
		.upgrade-to-pro{font-size:18px; text-align:center; margin-bottom:15px;}
		.wpos-copy-clipboard{-webkit-touch-callout: all; -webkit-user-select: all; -khtml-user-select: all; -moz-user-select: all; -ms-user-select: all; user-select: all;}
		.wpos-new-feature{ font-size: 10px; margin-left:2px; color: #fff; font-weight: bold; background-color: #03aa29; padding:1px 4px; font-style: normal; }
		.button-orange{background: #ff2700 !important;border-color: #ff2700 !important; font-weight: 600;}
	</style>

	<h2><?php esc_html_e( 'How It Works', 'timeline-and-history-slider' ); ?></h2>
	<div class="post-box-container">
		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-2">
				<!--How it workd HTML -->
				<div id="post-body-content">
					<div class="meta-box-sortables">
						
						<div class="postbox">
							<div class="postbox-header">
								<h2 class="hndle">
									<span><?php esc_html_e( 'Need Support & Solutions?', 'timeline-and-history-slider' ); ?></span>
								</h2>
							</div>
							<div class="inside">
								<table class="form-table">
									<tbody>
										<tr>
											<td>
												<p><?php esc_html_e('Get Designs, Optimization, Security, Backup, Migration Solutions @ one stop.', 'timeline-and-history-slider'); ?></p> <br/>
												<a class="button button-primary button-orange" href="<?php echo esc_url(WPOSTAHS_PLUGIN_LINK_UNLOCK); ?>" target="_blank"><?php esc_html_e('Upgrade To PRO', 'timeline-and-history-slider'); ?></a>
											</td>
										</tr>
									</tbody>
								</table>
							</div><!-- .inside -->
						</div><!-- #general -->

						<div class="postbox">
							<div class="postbox-header">
								<h2 class="hndle">
									<span><?php esc_html_e( 'How It Works - Display and shortcode', 'timeline-and-history-slider' ); ?></span>
								</h2>
							</div>
							<div class="inside">
								<table class="form-table">
									<tbody>
										<tr>
											<th>
												<label><?php esc_html_e('Geeting Started with Timeline and History Slider', 'timeline-and-history-slider'); ?>:</label>
											</th>
											<td>
												<ul>
													<li><?php esc_html_e('Step-1. Go to "Timeline Slider --> Add slide tab".', 'timeline-and-history-slider'); ?></li>
													<li><?php esc_html_e('Step-2. Add Album title, description and featured image and Publish.', 'timeline-and-history-slider'); ?></li>
													<li><?php esc_html_e('Step-3. Also you can display multiple timeline with category shortcode. Just go to "Timeline Slider --> category" and create the category. ', 'timeline-and-history-slider'); ?></li>
													<li><?php esc_html_e('Step-4. Asign the timeline post to respective category and use the category shortcode to display', 'timeline-and-history-slider'); ?></li>
												</ul>
											</td>
										</tr>

										<tr>
											<th>
												<label><?php esc_html_e('How Shortcode Works', 'timeline-and-history-slider'); ?>:</label>
											</th>
											<td>
												<ul>
													<li><?php esc_html_e('Step-1. Create a page like Timeline OR Post Timeline.', 'timeline-and-history-slider'); ?></li>
													<li><?php esc_html_e('Step-2. Put below shortcode as per your need.', 'timeline-and-history-slider'); ?></li>
												</ul>
											</td>
										</tr>

										<tr>
											<th>
												<label><?php esc_html_e('All Shortcodes', 'timeline-and-history-slider'); ?>:</label>
											</th>
											<td>
												<span class="wpos-copy-clipboard wpostahs-shortcode-preview">[th-slider]</span> – <?php esc_html_e('Timeline Slider Shortcode', 'timeline-and-history-slider'); ?>
											</td>
										</tr>

										<tr>
											<th>
												<label><?php esc_html_e('Documentation', 'timeline-and-history-slider'); ?>:</label>
											</th>
											<td>
												<a class="button button-primary" href="https://docs.essentialplugin.com/timeline-and-history-slider/" target="_blank"><?php esc_html_e('Check Documentation', 'timeline-and-history-slider'); ?></a>
											</td>
										</tr>
									</tbody>
								</table>
							</div><!-- .inside -->
						</div><!-- #general -->

						<div class="postbox">
							<div class="postbox-header">
								<h2 class="hndle">
									<span><?php esc_html_e( 'Gutenberg Support', 'timeline-and-history-slider' ); ?></span>
								</h2>
							</div>
							<div class="inside">
								<table class="form-table">
									<tbody>
										<tr>
											<th>
												<label><?php esc_html_e('How it Work', 'timeline-and-history-slider'); ?>:</label>
											</th>
											<td>
												<ul>
													<li><?php esc_html_e('Step-1. Go to the Gutenberg editor of your page.', 'timeline-and-history-slider'); ?></li>
													<li><?php esc_html_e('Step-2. Search "Timeline Slider" keyword in the gutenberg block list.', 'timeline-and-history-slider'); ?></li>
													<li><?php esc_html_e('Step-3. Add any block of Timeline Slider and you will find its relative options on the right end side.', 'timeline-and-history-slider'); ?></li>
												</ul>
											</td>
										</tr>											
									</tbody>
								</table>
							</div><!-- .inside -->
						</div><!-- .postbox -->

						<div class="postbox">
							<div class="postbox-header">
								<h2 class="hndle">
									<span><?php esc_html_e( 'Help to improve this plugin!', 'timeline-and-history-slider' ); ?></span>
								</h2>
							</div>
							<div class="inside">
								<p><?php esc_html_e('Enjoyed this plugin? You can help by rate this plugin ', 'timeline-and-history-slider'); ?><a href="https://wordpress.org/support/plugin/timeline-and-history-slider/reviews/" target="_blank"><?php esc_html_e('5 stars!', 'timeline-and-history-slider'); ?></a></p>
							</div><!-- .inside -->
						</div><!-- #general -->
					</div><!-- .meta-box-sortables -->
				</div><!-- #post-body-content -->

				<!--Upgrad to Pro HTML -->
				<div id="postbox-container-1" class="postbox-container">

					<div class="meta-box-sortables">
						<div class="postbox wpos-pro-box">
							<h3 class="hndle">
								<span><?php esc_html_e( 'Upgrate to Pro', 'timeline-and-history-slider' ); ?></span>
							</h3>
							<div class="inside">
								<ul class="wpos-list">
									<li><?php esc_html_e( '12+ cool designs', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Create unlimited timeline stories inside your WordPress website or blog.', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Use via 2 Shortcodes and adding 12+ Designs', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Vertical and Horizontal Timeline', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Also work with WordPress POST', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Timeline Category Management – Add stories in specific category.', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Timeline Stories Content Format – Add font awesome icon to display timeline stories format.', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Timeline Scrolling Navigation – Quickly and easily navigate your timeline with a beautiful scrolling navigation inside your timeline.', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Mobile Compatibility View', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Gutenberg Block Supports.', 'timeline-and-history-slider'); ?></li>
									<li><?php esc_html_e( 'WPBakery Page Builder Supports', 'timeline-and-history-slider'); ?></li>
									<li><?php esc_html_e( 'Elementor, Beaver and SiteOrigin Page Builder Support.', 'timeline-and-history-slider'); ?> <span class="wpos-new-feature">New</span></li>
									<li><?php esc_html_e( 'Divi Page Builder Native Support.', 'timeline-and-history-slider'); ?> <span class="wpos-new-feature">New</span></li>
									<li><?php esc_html_e( 'Fusion Page Builder (Avada) native support.', 'timeline-and-history-slider'); ?> <span class="wpos-new-feature">New</span></li>
									<li><?php esc_html_e( 'WP Templating Features', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Custom CSS', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( 'Fully responsive', 'timeline-and-history-slider' ); ?></li>
									<li><?php esc_html_e( '100% Multi language', 'timeline-and-history-slider' ); ?></li>
								</ul>
								<div class="upgrade-to-pro"><?php esc_html_e( 'Gain access to ', 'timeline-and-history-slider' ); ?><strong><?php esc_html_e('Timeline and History slider', 'timeline-and-history-slider'); ?></strong></div>
								<a class="button button-primary wpos-button-full button-orange" href="<?php echo esc_url(WPOSTAHS_PLUGIN_LINK_UNLOCK); ?>" target="_blank"><?php esc_html_e('Upgrade To PRO', 'timeline-and-history-slider'); ?></a>
							</div><!-- .inside -->
						</div><!-- #general -->
					</div><!-- .meta-box-sortables -->
				</div><!-- #post-container-1 -->
			</div><!-- #post-body -->
		</div><!-- #poststuff -->
	</div>
</div>