<?php

return array(
	array(
		'name' => 'popup_show_on_toggle',
		'title' => __('Show Popup', 'themify-popup'),
		'description' => '',
		'type' => 'radio',
		'enable_toggle' => true,
		'meta' => array(
			array('value' => 'all-pages', 'name' => __('Entire Site', 'themify-popup'), 'selected' => true),
			array('value' => 'specific-pages', 'name' => __('Specific Pages','themify-popup')),
		),
		'default' => 'all-pages',
	),
	array(
		'name' 		=> 'popup_show',
		'title' 	=> '',
		'description' => '',
		'type' 		=> 'assignments',
		'exclude_post_types' => array( 'themify_popup' ),
		'toggle' => array( 'specific-pages-toggle' ),
	),
	array(
		'name' => 'popup_show_to',
		'title' => 'Guests or Logged-in',
		'type' => 'dropdown',
		'meta' => array(
			array( 'value' => '', 'name' => __( 'Show to both users and guest visitors', 'themify-popup' ) ),
			array( 'value' => 'guest', 'name' => __( 'Show only to guest visitors', 'themify-popup' ) ),
			array( 'value' => 'user', 'name' => __( 'Show only to logged-in users', 'themify-popup' ) ),
		),
		'default' => '',
	),
	array(
		'name' 		=> 'popup_no_date_limit',
		'title' 	=> __('Schedule Popup', 'themify-popup'),
		'label' 	=> __('Display popup at certain date/time', 'themify-popup'),
		'description' => '',
		'type' 		=> 'checkbox',
	),
	array(
		'name' 		=> 'popup_start_at',
		'title' 	=> __('Start at', 'themify-popup'),
		'description' => '',
		'type' 		=> 'date',
		'meta'		=> array(
			'default' => '',
			'pick' => __( 'Pick Date', 'themify-popup' ),
			'close' => __( 'Done', 'themify-popup' ),
			'clear' => __( 'Clear Date', 'themify-popup' ),
			'time_format' => 'HH:mm:ss',
			'date_format' => 'yy-mm-dd',
			'timeseparator' => ' ',
			'required' => true
		),
	),
	array(
		'name' 		=> 'popup_end_at',
		'title' 	=> __('End at', 'themify-popup'),
		'description' => __('Start and End Date fields are required', 'themify-popup'),
		'type' 		=> 'date',
		'meta'		=> array(
			'default' => '',
			'pick' => __( 'Pick Date', 'themify-popup' ),
			'close' => __( 'Done', 'themify-popup' ),
			'clear' => __( 'Clear Date', 'themify-popup' ),
			'time_format' => 'HH:mm:ss',
			'date_format' => 'yy-mm-dd',
			'timeseparator' => ' ',
			'required' => true
		)
	),
	array(
		'name' => 'popup_trigger',
		'title' => __('Trigger Popup', 'themify-popup'),
		'description' => '',
		'type' => 'radio',
		'enable_toggle' => true,
		'meta' => array(
			array('value' => 'timedelay', 'name' => __('Time Delay','themify-popup'), 'selected' => true),
			array('value' => 'exit', 'name' => __('Exit Intent','themify-popup')),
			array('value' => 'pageview', 'name' => __('Page Viewed','themify-popup')),
			array('value' => 'scroll', 'name' => __('Scroll Position','themify-popup')),
			array('value' => 'manual', 'name' => __('Manual Launch','themify-popup')),
		),
		'default_selected' => '',
		'default' => 'timedelay',
	),
	array(
		'name' => 'popup_manual_description',
		'type' => 'post_id_info',
		'description' => __( 'To insert manual launch popup button, use the Popup generator button on WordPress visual editor.', 'themify-popup' ),
		'toggle' => array( 'manual-toggle' ),
		'title' => '&nbsp;',
	),
	array(
		'name' => 'popup_trigger_time_delay',
		'title' => __('Time Delay', 'themify-popup'),
		'description' => '',
		'type' => 'textbox',
		'meta' => array('size' => 'small'),
		'before' => '',
		'after' => __(' Seconds', 'themify-popup'),
		'toggle' => array( 'timedelay-toggle' ),
		'default' => 5
	),
	array(
		'type' => 'multi',
		'name' => 'popup_scroll_position',
		'title' => __('Scroll Position', 'themify-popup'),
		'meta' => array(
			'fields' => array(
				array(
					'name' => 'popup_trigger_scroll_position',
					'title' => __('Scroll Position', 'themify-popup'),
					'description' => '',
					'type' => 'textbox',
					'meta' => array('size' => 'small'),
				),
				array(
					'name' => 'popup_trigger_scroll_on',
					'title' => '',
					'type' => 'dropdown',
					'meta' => array(
						array( 'value' => 'px', 'name' => __( 'Pixels', 'themify-popup' ) ),
						array( 'value' => '%', 'name' => __( 'Percentage of screen', 'themify-popup' ) ),
					),
					'default' => 'px',
				),
			),
			'before' => '',
			'after' => '',
			'separator' => ''
		),
		'toggle' => array( 'scroll-toggle' )
	),
	array(
		'name' => 'popup_style',
		'title' => __('Popup Style', 'themify-popup'),
		'description' => '',
		'type' => 'radio',
		'enable_toggle' => true,
		'meta' => array(
			array('value' => 'classic', 'name' => __('Classic','themify-popup'), 'selected' => true),
			array('value' => 'slide-out', 'name' => __('Slide Out','themify-popup')),
			array('value' => 'fullscreen', 'name' => __('Fullscreen','themify-popup')),
		),
		'default_selected' => '',
		'default' => 'classic',
	),
	array(
		'name' => 'popup_slide_out_position',
		'title' => __( 'Position', 'themify-popup' ),
		'type' => 'dropdown',
		'meta' => array(
			array( 'value' => 'bottom-right', 'name' => __( 'Bottom Right', 'themify-popup' ) ),
			array( 'value' => 'bottom-left', 'name' => __( 'Bottom Left', 'themify-popup' ) ),
			array( 'value' => 'bottom-center', 'name' => __( 'Bottom Center', 'themify-popup' ) ),
			array( 'value' => 'top-right', 'name' => __( 'Top Right', 'themify-popup' ) ),
			array( 'value' => 'top-left', 'name' => __( 'Top Left', 'themify-popup' ) ),
			array( 'value' => 'top-center', 'name' => __( 'Top Center', 'themify-popup' ) ),
			array( 'value' => 'center-right', 'name' => __( 'Centered Right', 'themify-popup' ) ),
			array( 'value' => 'center-left', 'name' => __( 'Centered Left', 'themify-popup' ) ),
		),
		'toggle' => array( 'slide-out-toggle' ),
		'default' => 'bottom-right',
	),
	array(
		'name' => 'popup_classic_position',
		'title' => __( 'Position', 'themify-popup' ),
		'type' => 'dropdown',
		'meta' => array(
			array( 'value' => 'center-center', 'name' => __( 'Center', 'themify-popup' ) ),
			array( 'value' => 'bottom-right', 'name' => __( 'Bottom Right', 'themify-popup' ) ),
			array( 'value' => 'bottom-left', 'name' => __( 'Bottom Left', 'themify-popup' ) ),
			array( 'value' => 'bottom-center', 'name' => __( 'Bottom Center', 'themify-popup' ) ),
			array( 'value' => 'top-right', 'name' => __( 'Top Right', 'themify-popup' ) ),
			array( 'value' => 'top-left', 'name' => __( 'Top Left', 'themify-popup' ) ),
			array( 'value' => 'top-center', 'name' => __( 'Top Center', 'themify-popup' ) ),
			array( 'value' => 'center-right', 'name' => __( 'Centered Right', 'themify-popup' ) ),
			array( 'value' => 'center-left', 'name' => __( 'Centered Left', 'themify-popup' ) ),
		),
		'toggle' => array( 'classic-toggle' ),
		'default' => 'center-center',
	),
	array(
		'type' => 'multi',
		'name' => 'popup_dimensions',
		'title' => __('Popup Dimension', 'themify-popup'),
		'meta' => array(
			'fields' => array(
				array(
					'name' => 'popup_width',
					'description' => '',
					'type' => 'textbox',
					'meta' => array('size' => 'small')
				),
				array(
					'name' => 'popup_width_unit',
					'label' => __('width', 'themify-popup'),
					'title' => '',
					'type' => 'dropdown',
					'meta' => array(
						array( 'value' => 'px', 'name' => __( 'px', 'themify-popup' ) ),
						array( 'value' => '%', 'name' => __( '%', 'themify-popup' ) ),
						array( 'value' => 'em', 'name' => __( 'em', 'themify-popup' ) ),
					),
					'default' => 'px',
					'after' => '<br>',
				),
				array(
					'name' => 'popup_height',
					'type' => 'textbox',
					'meta' => array( 'size' => 'small' )
				),
				array(
					'name' => 'popup_height_unit',
					'label' => __('height', 'themify-popup'),
					'title' => '',
					'type' => 'dropdown',
					'meta' => array(
						array( 'value' => 'px', 'name' => __( 'px', 'themify-popup' ) ),
						array( 'value' => '%', 'name' => __( '%', 'themify-popup' ) ),
					),
					'default' => 'px',
					'after' => '<br>',
				),
				array(
					'name' 		=> 'popup_auto_height',
					'title' 	=> '',
					'label' 	=> __('Auto Height', 'themify-popup'),
					'description' => '',
					'type' 		=> 'checkbox',
				),
			),
			'before' => '',
			'after' => '',
			'separator' => ''
		),
		'toggle' => array( 'classic-toggle', 'slide-out-toggle' )
	),
	array(
		'name' => 'popup_overlay_color',
		'title' => __('Overlay Color', 'announcement-bar'),
		'description' => '',
		'type' => 'color',
		'meta' => array( 'default' => null ),
		'toggle' => array( 'classic-toggle' ),
		'format' => 'rgba',
	),
	array(
		'name' => 'popup_animation',
		'title' => __( 'Open Animation', 'themify-popup' ),
		'type' => 'dropdown',
		'meta' => array(
			array( 'value' => 'bounce', 'name' => __( 'bounce', 'themify-popup' ) ),
			array( 'value' => 'flash', 'name' => __( 'flash', 'themify-popup' ) ),
			array( 'value' => 'pulse', 'name' => __( 'pulse', 'themify-popup' ) ),
			array( 'value' => 'rubberBand', 'name' => __( 'rubberBand', 'themify-popup' ) ),
			array( 'value' => 'shake', 'name' => __( 'shake', 'themify-popup' ) ),
			array( 'value' => 'swing', 'name' => __( 'swing', 'themify-popup' ) ),
			array( 'value' => 'tada', 'name' => __( 'tada', 'themify-popup' ) ),
			array( 'value' => 'wobble', 'name' => __( 'wobble', 'themify-popup' ) ),
			array( 'value' => 'jello', 'name' => __( 'jello', 'themify-popup' ) ),
			array( 'value' => 'bounceIn', 'name' => __( 'bounceIn', 'themify-popup' ) ),
			array( 'value' => 'bounceInDown', 'name' => __( 'bounceInDown', 'themify-popup' ) ),
			array( 'value' => 'bounceInLeft', 'name' => __( 'bounceInLeft', 'themify-popup' ) ),
			array( 'value' => 'bounceInRight', 'name' => __( 'bounceInRight', 'themify-popup' ) ),
			array( 'value' => 'bounceInUp', 'name' => __( 'bounceInUp', 'themify-popup' ) ),
			array( 'value' => 'fadeIn', 'name' => __( 'fadeIn', 'themify-popup' ) ),
			array( 'value' => 'fadeInDown', 'name' => __( 'fadeInDown', 'themify-popup' ) ),
			array( 'value' => 'fadeInDownBig', 'name' => __( 'fadeInDownBig', 'themify-popup' ) ),
			array( 'value' => 'fadeInLeft', 'name' => __( 'fadeInLeft', 'themify-popup' ) ),
			array( 'value' => 'fadeInLeftBig', 'name' => __( 'fadeInLeftBig', 'themify-popup' ) ),
			array( 'value' => 'fadeInRight', 'name' => __( 'fadeInRight', 'themify-popup' ) ),
			array( 'value' => 'fadeInRightBig', 'name' => __( 'fadeInRightBig', 'themify-popup' ) ),
			array( 'value' => 'fadeInUp', 'name' => __( 'fadeInUp', 'themify-popup' ) ),
			array( 'value' => 'fadeInUpBig', 'name' => __( 'fadeInUpBig', 'themify-popup' ) ),
			array('value' => 'lightSpeedIn', 'name' => __('lightSpeedIn', 'themify-popup')),
			array('value' => 'lightSpeedOut', 'name' => __('lightSpeedOut', 'themify-popup')),
			array('value' => 'rotateIn', 'name' => __('rotateIn', 'themify-popup')),
			array('value' => 'rotateInDownLeft', 'name' => __('rotateInDownLeft', 'themify-popup')),
			array('value' => 'rotateInDownRight', 'name' => __('rotateInDownRight', 'themify-popup')),
			array('value' => 'rotateInUpLeft', 'name' => __('rotateInUpLeft', 'themify-popup')),
			array('value' => 'rotateInUpRight', 'name' => __('rotateInUpRight', 'themify-popup')),
			array('value' => 'zoomIn', 'name' => __('zoomIn', 'themify-popup')),
			array('value' => 'zoomInDown', 'name' => __('zoomInDown', 'themify-popup')),
			array('value' => 'zoomInLeft', 'name' => __('zoomInLeft', 'themify-popup')),
			array('value' => 'zoomInRight', 'name' => __('zoomInRight', 'themify-popup')),
			array('value' => 'zoomInUp', 'name' => __('zoomInUp', 'themify-popup')),
			array('value' => 'slideInDown', 'name' => __('slideInDown', 'themify-popup')),
			array('value' => 'slideInLeft', 'name' => __('slideInLeft', 'themify-popup')),
			array('value' => 'slideInRight', 'name' => __('slideInRight', 'themify-popup')),
			array('value' => 'slideInUp', 'name' => __('slideInUp', 'themify-popup')),
			array('value' => 'none', 'name' => __('None', 'themify-popup')),
		),
		'default' => 'bounce'
	),
	array(
		'name' => 'popup_animation_exit',
		'title' => __( 'Exit Animation', 'themify-popup' ),
		'type' => 'dropdown',
		'meta' => array(
			array( 'value' => 'fadeOut', 'name' => __( 'fadeOut', 'themify-popup' ) ),
			array( 'value' => 'fadeOutDown', 'name' => __( 'fadeOutDown', 'themify-popup' ) ),
			array( 'value' => 'fadeOutDownBig', 'name' => __( 'fadeOutDownBig', 'themify-popup' ) ),
			array( 'value' => 'fadeOutLeft', 'name' => __( 'fadeOutLeft', 'themify-popup' ) ),
			array( 'value' => 'fadeOutLeftBig', 'name' => __( 'fadeOutLeftBig', 'themify-popup' ) ),
			array( 'value' => 'fadeOutRight', 'name' => __( 'fadeOutRight', 'themify-popup' ) ),
			array( 'value' => 'fadeOutRightBig', 'name' => __( 'fadeOutRightBig', 'themify-popup' ) ),
			array( 'value' => 'fadeOutUp', 'name' => __( 'fadeOutUp', 'themify-popup' ) ),
			array( 'value' => 'fadeOutUpBig', 'name' => __( 'fadeOutUpBig', 'themify-popup' ) ),
			array( 'value' => 'bounceOut', 'name' => __( 'bounceOut', 'themify-popup' ) ),
			array( 'value' => 'bounceOutDown', 'name' => __( 'bounceOutDown', 'themify-popup' ) ),
			array( 'value' => 'bounceOutLeft', 'name' => __( 'bounceOutLeft', 'themify-popup' ) ),
			array( 'value' => 'bounceOutRight', 'name' => __( 'bounceOutRight', 'themify-popup' ) ),
			array( 'value' => 'bounceOutUp', 'name' => __( 'bounceOutUp', 'themify-popup' ) ),
			array( 'value' => 'lightSpeedOut', 'name' => __( 'lightSpeedOut', 'themify-popup' ) ),
			array( 'value' => 'rotateOut', 'name' => __( 'rotateOut', 'themify-popup' ) ),
			array( 'value' => 'rotateOutDownLeft', 'name' => __( 'rotateOutDownLeft', 'themify-popup' ) ),
			array( 'value' => 'rotateOutDownRight', 'name' => __( 'rotateOutDownRight', 'themify-popup' ) ),
			array( 'value' => 'rotateOutUpLeft', 'name' => __( 'rotateOutUpLeft', 'themify-popup' ) ),
			array( 'value' => 'rotateOutUpRight', 'name' => __( 'rotateOutUpRight', 'themify-popup' ) ),
			array( 'value' => 'slideOutUp', 'name' => __( 'slideOutUp', 'themify-popup' ) ),
			array( 'value' => 'slideOutDown', 'name' => __( 'slideOutDown', 'themify-popup' ) ),
			array( 'value' => 'slideOutLeft', 'name' => __( 'slideOutLeft', 'themify-popup' ) ),
			array( 'value' => 'slideOutRight', 'name' => __( 'slideOutRight', 'themify-popup' ) ),
			array( 'value' => 'zoomOut', 'name' => __( 'zoomOut', 'themify-popup' ) ),
			array( 'value' => 'zoomOutDown', 'name' => __( 'zoomOutDown', 'themify-popup' ) ),
			array( 'value' => 'zoomOutLeft', 'name' => __( 'zoomOutLeft', 'themify-popup' ) ),
			array( 'value' => 'zoomOutRight', 'name' => __( 'zoomOutRight', 'themify-popup' ) ),
			array( 'value' => 'zoomOutUp', 'name' => __( 'zoomOutUp', 'themify-popup' ) ),
			array( 'value' => 'rollOut', 'name' => __( 'rollOut', 'themify-popup' ) ),
			array( 'value' => 'none', 'name' => __( 'None', 'themify-popup' ) ),
		),
		'default' => 'fadeOut'
	),
	array(
		'name' 		=> 'popup_limit_count',
		'title' 	=> __( 'Display Limit', 'themify-popup' ),
		'label' 	=> '&nbsp;',
		'before' => __( 'Show the popup only ', 'themify-popup' ),
		'after' => __( ' times.', 'themify-popup' ),
		'type' 		=> 'textbox',
		'toggle' => array( 'timedelay-toggle', 'exit-toggle', 'pageview-toggle', 'scroll-toggle' ),
		'meta' => array('size' => 'small')
	),
	array(
		'name' => 'popup_cookie_expiration',
		'title' => '',
		'before' => __('Reset the counter after ', 'themify-popup'),
		'after' => __( ' days. (Default: 1 day)', 'themify-popup' ),
		'type' => 'textbox',
		'meta' => array('size' => 'small')
	),
	array(
		'name' => 'popup_page_view',
		'title' => __('Page Count', 'themify-popup'),
		'after' => __( ' Display popup only after [n] page views.', 'themify-popup' ),
		'type' => 'textbox',
		'toggle' => array( 'timedelay-toggle', 'exit-toggle', 'pageview-toggle', 'scroll-toggle' ),
		'meta' => array( 'size' => 'small' ),
	),
	array(
		'name' 		=> 'popup_auto_close',
		'title' 	=> __('Auto Close', 'themify-popup'),
		'label' => __('Auto close popup', 'themify-popup'),
		'description' => '',
		'type' 		=> 'checkbox',
	),
	array(
		'name' => 'popup_auto_close_delay',
		'title' => '',
		'before' => __('Close popup after ', 'themify-popup'),
		'after' => __( ' Seconds', 'themify-popup' ),
		'type' => 'textbox',
		'meta' => array('size' => 'small'),
		'default' => 5
	),
	array(
		'name' 		=> 'popup_mobile_disable',
		'title' 	=> __('Display On', 'themify-popup'),
		'description' => '',
		'type' 		=> 'dropdown',
		'meta' => array(
			array( 'value' => '', 'name' => __( 'All Devices', 'themify-popup' ) ),
			array( 'value' => 'on', 'name' => __( 'Only Desktop', 'themify-popup' ) ),
			array( 'value' => 'mob', 'name' => __( 'Only Mobile', 'themify-popup' ) ),
		),
	),
	array(
		'name' 		=> 'popup_overlay_as_close',
		'title' 	=> __('Overlay As Close', 'themify-popup'),
		'label' => __('Allow clicking the popup overlay to close', 'themify-popup'),
		'description' => '',
		'type' 		=> 'checkbox',
		'toggle' => array( 'classic-toggle' )
	),
);