<?php
/***************************************************************************
 *
 *  ----------------------------------------------------------------------
 *                      DO NOT EDIT THIS FILE
 *  ----------------------------------------------------------------------
 * 
 *                       Copyright (C) Themify
 * 
 *  ----------------------------------------------------------------------
 *
 ***************************************************************************/

defined( 'ABSPATH' ) || exit;

// Initialize actions

$themify_ajax_actions = array(
    'import_settings',
    'plupload',
    'get_404_pages',
    'save',
    'reset_settings',
    'add_link_field',
    'media_lib_browse',
    'clear_all_webp',
    'clear_all_menu',
    'clear_all_concate',
    'clear_all_html',
    'clear_gfonts',
    'search_autocomplete',
    'ajax_load_more',
    'required_plugins_modal',
    'news_widget',
    'activate_plugin',
    'update_license',
    'upload_json'
);
foreach($themify_ajax_actions as $action){
    add_action('wp_ajax_themify_' . $action, 'themify_' . $action);
}

//Show 404 page in autocomplete
function themify_get_404_pages(){
    if ( ! empty( $_POST['term'] ) && current_user_can( 'manage_options' ) ) {
        $args = array(
            'sort_order' => 'asc',
            'sort_column' => 'post_title',
            'post_type' => 'page',
            's'=>  sanitize_text_field($_POST['term']),
            'no_found_rows'=>true,
            'ignore_sticky_posts'=>true,
            'cache_results'=>false,
            'update_post_term_cache'=>false,
            'update_post_meta_cache'=>false,
            'post_status' => 'publish',
            'posts_per_page' => 15
        );
        add_filter( 'posts_search', 'themify_posts_where', 10, 2 );
        $terms = new WP_Query($args);
        $items = array();
        if($terms->have_posts()){
            while ($terms->have_posts()){
                $terms->the_post();
                $items[] = array('value'=>  get_the_ID(),'label'=>  get_the_title());
            }
        }
        echo wp_json_encode($items);
    }
    wp_die();
}

//Search only by post title
function themify_posts_where($search,$wp_query ){       
    if ( ! empty( $search ) && ! empty( $wp_query->query_vars['search_terms'] ) ) {
        global $wpdb;

        $q = $wp_query->query_vars;
        $n = ! empty( $q['exact'] ) ? '' : '%';

        $search = array();
        $search[] = $wpdb->prepare( "$wpdb->posts.post_title LIKE %s", $wpdb->esc_like( implode(' ',$q['search_terms']) ) . $n );

        if ( ! is_user_logged_in() )
            $search[] = "$wpdb->posts.post_password = ''";

        $search = ' AND ' . implode( ' AND ', $search );
    }
    return $search;
}

/**
 * Handles theme settings import via file
 */
function themify_import_settings() {
    if ( ! current_user_can( 'manage_options' ) ) {
        die;
    }
    check_ajax_referer( 'themify_import_settings' );

    if ( ! empty( $_POST['data'] ) ) {
        $data = stripslashes( $_POST['data'] );
        $data = is_serialized( $data ) ? unserialize( $data, [ 'allowed_classes' => false ] ) : json_decode( $data, true );
        if ( ! empty( $data ) ) {
            themify_set_data( $data );
        }
    }

    wp_send_json_success();
}

/**
 * AJAX - Plupload execution routines
 * @since 1.2.2
 * @package themify
 */
function themify_plupload() {
    if( ! current_user_can( 'upload_files' ) ) {
        die;
    }

    $imgid = $_POST['imgid'];
    check_ajax_referer( $imgid . 'themify-plupload' );
    /** Decide whether to send this image to Media. @var String */
    $add_to_media_library = isset( $_POST['tomedia'] ) ? $_POST['tomedia'] : false;
    /** If post ID is set, uploaded image will be attached to it. @var String */
    $postid = isset( $_POST['topost'] )? $_POST['topost'] : '';
 
    /** Handle file upload storing file|url|type. @var Array */
    $file = wp_handle_upload($_FILES[$imgid . 'async-upload'], array('test_form' => true, 'action' => 'themify_plupload'));
    
    // if $file returns error, return it and exit the function
    if ( isset( $file['error'] ) && ! empty( $file['error'] ) ) {
        wp_send_json_error( $file['error'] );
    }

    $type = $_POST['type'];
    $allowed_extensions = [
        'image' => [ 'jpg', 'jpeg', 'gif', 'png', 'ico', 'svg' ],
        'audio' => [ 'mp3', 'm4a', 'ogg', 'wav', 'wma' ],
        'video' => [ 'mp4', 'm4v', 'webm', 'ogv', 'wmv', 'flv' ],
        'font'  => [ 'woff', 'woff2', 'ttf', 'otf', 'svg', 'eot' ]
    ];

    // let's see if it's a valid file type
    $extension = pathinfo( $file['file'], PATHINFO_EXTENSION );
    if ( ! in_array( $extension, $allowed_extensions[ $type ], true ) ) {
        Themify_Filesystem::delete( $file['file'], 'f' );
        wp_send_json_error( __( 'Invalid file type.', 'themify' ) );
    }

    //Image Upload routines
    if( 'tomedia' === $add_to_media_library ){
        
        // Insert into Media Library
        // Set up options array to add this file as an attachment
        $attachment = array(
            'post_mime_type' => sanitize_mime_type($file['type']),
            'post_title' => str_replace('-', ' ', sanitize_file_name(pathinfo($file['file'], PATHINFO_FILENAME))),
            'post_status' => 'inherit'
        );
        
        if( $postid ){
            $attach_id = wp_insert_attachment( $attachment, $file['file'], $postid );
        } else {
            $attach_id = wp_insert_attachment( $attachment, $file['file'] );
        }
        $file['id'] = $attach_id;

        // Common attachment procedures
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        $attach_data = wp_generate_attachment_metadata( $attach_id, $file['file'] );
        wp_update_attachment_metadata($attach_id, $attach_data);

        if( $postid ) {
            
            $full = wp_get_attachment_image_src( $attach_id, 'full' );

            update_post_meta($postid, $_POST['fields'], $full[0]);
            update_post_meta($postid, '_'.$_POST['fields'] . '_attach_id', $attach_id);             
        }

        /* Return URL for the image field in meta box */
        if ( $type === 'image' ) {
            $thumb = wp_get_attachment_image_src( $attach_id, 'thumbnail' );
            $file['thumb'] = $thumb[0];
        }
    }

    $file['type'] = $extension;
    wp_send_json_success( $file );
}

/**
 * AJAX - Save user settings
 * @since 1.1.3
 * @package themify
 */
function themify_save(){
    check_ajax_referer( 'tf_nonce', 'nonce' );
    if ( ! current_user_can( 'manage_options' ) ) {
        die;
    }

    $previous_data = themify_get_data();
    $temp = themify_normalize_save_data( $_POST['data'] );
    unset($temp['tmp_cache_network'],$temp['tmp_cache_concte_network'],$temp['tmp_regenerate_all_css']);
    themify_set_data( $temp );
    _e('Your settings were saved', 'themify');

    if (
        Themify_Enqueue_Assets::$mobileMenuActive !== intval( $temp['setting-mobile_menu_trigger_point'] )
        || ( isset( $previous_data['skin'] ) && $previous_data['skin'] !== $temp['skin'])
        || ( isset( $previous_data['setting-header_design'] ) && $previous_data['setting-header_design'] !== $temp['setting-header_design'])
        || ( isset( $previous_data['setting-exclude_menu_navigation'] ) && $previous_data['setting-exclude_menu_navigation'] !== $temp['setting-exclude_menu_navigation'])
    ) {
        Themify_Enqueue_Assets::clearConcateCss();
    }

    /* clear webP image cache when changing image quality */
    if ( (empty( $previous_data['setting-gf'] ) &&  !empty($temp['setting-gf']))  || (!empty( $previous_data['setting-gf'] ) &&  empty($temp['setting-gf']))) {
        Themify_Storage::deleteByPrefix('tf_fg_css_');
    }
    /* clear google fonts cache*/

    if ( class_exists( 'Themify_Builder_Stylesheet',false ) ) {
        $breakpoints=themify_get_breakpoints('all',true);
        foreach ( $breakpoints as $bp=>$v ) {
            if ( isset( $previous_data["setting-customizer_responsive_design_{$bp}"] ) && $previous_data["setting-customizer_responsive_design_{$bp}"] !== $temp["setting-customizer_responsive_design_{$bp}"] ) {
                Themify_Builder_Stylesheet::regenerate_css_files();
                break;
            }
        }
    }
    unset($previous_data);
    if(themify_get_server()==='nginx'){
        if(empty($temp['setting-webp'])){
            Themify_Enqueue_Assets::removeWebp();
        }
    }
    else{
            $isDev=!empty($temp['setting-dev-mode']);
            $gzip=$isDev?true:empty($temp['setting-cache_gzip']);
            $browser=$isDev?true:empty($temp['setting-cache_browser']);
            Themify_Enqueue_Assets::rewrite_htaccess($gzip,empty($temp['setting-webp']),$browser);
    }
    TFCache::remove_cache();
    if(empty($temp['setting-dev-mode'])){
        TFCache::create_config($temp);
    }
    else{
        TFCache::disable_cache();
    }
    TFCache::clear_3rd_plugins_cache();

    do_action( 'themify_settings_save' );

    wp_die();
}

function themify_normalize_save_data($data){
    $data = explode('&', $data);
    $temp = array();
    foreach($data as $a){
        $v = explode('=', $a);
        $temp[$v[0]] = urldecode( str_replace('+',' ',preg_replace_callback('/%([0-9a-f]{2})/i', 'themify_save_replace_cb', urlencode($v[1]))) );
    }

    /* cleanup Hook Content data, remove empty hooks */
    if ( ! empty( $temp['setting-hooks_field_ids'] ) ) {
        $ids = json_decode( $temp['setting-hooks_field_ids'] );
        if ( ! empty( $ids ) ) {
            $new_ids = [];
            foreach ( $ids as $id ) {
                if ( empty( $temp["setting-hooks-{$id}-code"] ) ) {
                    unset( $temp["setting-hooks-{$id}-code"], $temp["setting-hooks-{$id}-location"], $temp["setting-hooks-{$id}-r"], $temp["setting-hooks-{$id}-visibility"] );
                } else {
                    $new_ids[] = $id;
                }
            }
            $temp['setting-hooks_field_ids'] = json_encode( $new_ids );
        }
    }

    return $temp;
}

/**
 * Replace callback for preg_replace_callback used in themify_save().
 * 
 * @since 2.2.5
 * 
 * @param array $matches 0 complete match 1 first match enclosed in (...)
 * 
 * @return string One character specified by ascii.
 */
function themify_save_replace_cb( $matches ) {
    // "chr(hexdec('\\1'))"
    return chr( hexdec( $matches[1] ) );
}

/**
 * AJAX - Reset Settings
 * @since 1.1.3
 * @package themify
 */
function themify_reset_settings(){
    check_ajax_referer( 'tf_nonce', 'nonce' );
    if ( ! current_user_can( 'manage_options' ) ) {
        die;
    }

    $temp_data = themify_normalize_save_data($_POST['data']);
    $temp = array();
    foreach($temp_data as $key => $val){
        // Don't reset if it's not a setting or the # of social links or a social link or the Hook Contents
        if(strpos($key, 'setting') === false || strpos($key, 'hooks') || strpos($key, 'link_field_ids') || strpos($key, 'themify-link') || strpos($key, 'custom_css')){
            $temp[$key] = $val;
        }
    }
        $temp['setting-script_minification'] = 'disable';
    print_r(themify_set_data($temp));
    die();
}

function themify_add_link_field(){
    check_ajax_referer( 'tf_nonce', 'nonce' );
    if ( ! current_user_can( 'manage_options' ) ) {
        die;
    }
    
    if( isset($_POST['fid']) ) {
        $hash = $_POST['fid'];
        $type = isset( $_POST['type'] )? $_POST['type'] : 'image-icon';
        echo themify_add_link_template( 'themify-link-'.$hash, array(), true, $type);
        wp_die();
    }
}

/**
 * Set image from wp library
 * @since 1.2.9
 * @package themify
 */
function themify_media_lib_browse() {
    if ( ! wp_verify_nonce( $_POST['media_lib_nonce'], 'media_lib_nonce' ) ) die(-1);
    if ( ! current_user_can( 'upload_files' ) ) {
        die;
    }

    $file = array();
    $postid = $_POST['post_id'];
    $attach_id = $_POST['attach_id'];

    $full = wp_get_attachment_image_src( $attach_id, 'full' );
    if( $_POST['featured'] ){
        //Set the featured image for the post
        set_post_thumbnail($postid, $attach_id);
    }
    update_post_meta($postid, $_POST['field_name'], $full[0]);
    update_post_meta($postid, '_'.$_POST['field_name'] . '_attach_id', $attach_id);

    $thumb = wp_get_attachment_image_src( $attach_id, 'thumbnail' );

    //Return URL for the image field in meta box
    $file['thumb'] = $thumb[0];

    echo json_encode($file);

    exit();
}


function themify_clear_all_webp(){
    check_ajax_referer('tf_nonce', 'nonce');
    if ( ! current_user_can( 'manage_options' ) ) {
        die;
    }

    wp_send_json_success(Themify_Enqueue_Assets::removeWebp());
}

function themify_clear_all_concate(){
    check_ajax_referer('tf_nonce', 'nonce');
    if ( ! current_user_can( 'manage_options' ) ) {
        die;
    }

        $type=false;
        if(is_multisite()){
        if(!empty($_POST['all'])){
        $type='all';
        }
        else{
        $data = themify_normalize_save_data($_POST['data']);
        if(!empty($data['tmp_cache_concte_network'])){
                    $type='all';
        }
        $data=null;
        }
    }
    Themify_Enqueue_Assets::clearConcateCss($type);
    wp_send_json_success();
}

function themify_clear_all_menu(){
    check_ajax_referer('tf_nonce', 'nonce');
    if ( ! current_user_can( 'manage_options' ) ) {
        die;
    }

    TFCache::remove_cache();
        TFCache::clear_3rd_plugins_cache();
    themify_clear_menu_cache();
    die('1');
}

function themify_clear_all_html(){
    check_ajax_referer('tf_nonce', 'nonce');
    if ( ! current_user_can( 'manage_options' ) ) {
        die;
    }
    $type='blog';
    if(is_multisite()){
        $data = themify_normalize_save_data($_POST['data']);
        if(!empty($data['tmp_cache_network'])){
            $type='all';
        }
        $data=null;
    }
    TFCache::remove_cache($type);
    die('1');
}
function themify_clear_gfonts(){
    check_ajax_referer('tf_nonce', 'nonce');
    if ( ! current_user_can( 'manage_options' ) ) {
        die;
    }

    Themify_Storage::deleteByPrefix('tf_fg_css_');
    wp_send_json_success();
}
add_action('wp_ajax_nopriv_themify_search_autocomplete','themify_search_autocomplete');
function themify_search_autocomplete(){
    if(!empty($_POST['s'])){
        $s  = sanitize_text_field($_POST['s']);
        if(!empty($s)){
            global $query,$found_types;
            if(!empty($_POST['post_type'])){
                $post_types  = array(sanitize_text_field($_POST['post_type']));
            }else{
                if(true===themify_is_woocommerce_active() && 'product' === themify_get( 'setting-search_post_type','all',true )){
                    $post_types = array('product');
                }else{
                    $post_types = Themify_Builder_Model::get_post_types();
                    unset($post_types['attachment']);
                    $post_types=array_keys($post_types);
                }
            }
            $query_args = array(
                'post_type'=>$post_types,
                'post_status'=>'publish',
                'posts_per_page'=>22,
                's'=>$s
            );

            $query_args = apply_filters('themify_search_args',$query_args);
            wp_reset_postdata();
            $query = new WP_Query( $query_args );
            $found_types=array();
            while ( $query->have_posts() ){
                $query->the_post();
                $post_type = get_post_type();
                if (($key = array_search($post_type, $query_args['post_type'])) !== false) {
                    unset($query_args['post_type'][$key]);
                    $found_types[]=$post_type;
                }
                if(empty($query_args['post_type'])){
                    break;
                }
            }
            $query->rewind_posts();

            // SKU Search Addition.
            if (function_exists('wc_get_products') && in_array('product', $post_types)) {
                $sku_products = wc_get_products([
                    'limit' => 22,
                    'status' => 'publish',
                    'sku' => $s,
                ]);
                if (!empty($sku_products)) {
                    $sku_ids = array();
                    foreach ($sku_products as $sku_product) {
                        $sku_ids[] = $sku_product->get_id();
                    }
                    // Merge with existing query results
                    $existing_ids = $query->posts ? wp_list_pluck($query->posts, 'ID') : array();
                    $all_ids = array_unique(array_merge($existing_ids, $sku_ids));
                    // Re-query to get all posts in correct order
                    if (!empty($all_ids)) {
                        $query = new WP_Query(array(
                            'post_type' => $post_types,
                            'post_status' => 'publish',
                            'post__in' => $all_ids,
                            'orderby' => 'post__in',
                            'posts_per_page' => 22
                        ));
                        // Update found_types for all post types present in the results
                        foreach ($query->posts as $post) {
                            $type = get_post_type($post);
                            if (!in_array($type, $found_types)) {
                                $found_types[] = $type;
                            }
                        }
                    }
                }
            }

            ob_start();
            include( THEMIFY_DIR.'/includes/search-box-result.php' );
            ob_end_flush();
        }
    }
    wp_die();
}

/*Load More Ajax - Used for module ajax load more*/
if(!function_exists('themify_ajax_load_more')){
    function themify_ajax_load_more(){
        if(!empty($_POST['module']) && !empty($_POST['id'])){
            $builder_id=(int)($_POST['id']);
            $mod_id=str_replace('tb_','',$_POST['module']);
            $data = Themify_Builder::get_builder_modules_list( (int)$_POST['id'] );
            if ( ! empty( $data ) ) {
                foreach ( $data as $module ) {
                    if ( isset( $module['element_id'], $module['mod_settings'] ) && $module['element_id'] === $mod_id ) {
                        $mod_setting = $module;
                        break;
                    }
                }
            }
            if(!empty($mod_setting)){
                if ( class_exists( 'Themify_Hooks', false ) ) {
                    Themify_Hooks::hooks_setup();
                }
                global $paged;
                $paged=(int)$_POST['page'];
                $paged=$paged<1?1:$paged;
                if(themify_is_themify_theme() && is_file(THEME_DIR.'/theme-options.php')){
                    require_once( THEME_DIR.'/theme-options.php' );
                    global $themify;
                    if(isset($themify) && method_exists($themify,'template_redirect')){
                        $themify->template_redirect();
                    }
                }
                Themify_Builder_Component_Module::template($mod_setting, $builder_id);
            }
        }
        wp_die();
    }
    // Ajax filter actions
    add_action('wp_ajax_nopriv_themify_ajax_load_more','themify_ajax_load_more');
}


function themify_required_plugins_modal() {
    check_ajax_referer( 'tf_nonce', 'nonce' );
    if(!current_user_can('manage_options')){
    wp_send_json_error(__( 'You are not allowed to import data.','themify' ));
    }
    $required_plugins = !empty($_POST['plugins'])?sanitize_text_field($_POST['plugins']):'';
    $result=array('plugins'=>array());
    if( ! empty( $required_plugins )) {
    $required_plugins =  explode( ',', $required_plugins );
    $all_plugins = get_plugins();
    $can_install=current_user_can( 'install_plugins' ) ;
    $themify_updater = class_exists('Themify_Updater',false)?Themify_Updater::get_instance():null;
    foreach($required_plugins as $plugin){
        $plugin=trim($plugin);
        $plugin_info = themify_get_known_plugin_info($plugin);
        if($plugin_info!==false){
        if(isset($all_plugins[$plugin_info['path']])){
            if(is_plugin_active( $plugin_info['path'] )){
            $plugin_info['active']=1;
            }
            elseif(current_user_can( 'activate_plugin', $plugin )){
            $valid= function_exists('validate_plugin_requirements')?validate_plugin_requirements($plugin_info['path']):true;
            if(is_wp_error( $valid )){
                $plugin_info['error']=$valid->get_error_message();
            }
            else{
                $plugin_info['active']=0;
            }
            }
            else{
            $plugin_info['error']=__( 'You are not allowed to activate this plugin.','themify' );
            }
        }
        elseif($can_install===true){
            $plugin_info['install']=$themify_updater===null || $themify_updater->has_error() || !empty($plugin_info['wp_hosted']) || $themify_updater->has_access( $plugin )?1:'buy';
        }
        else{
            $plugin_info['error']= __( 'You are not allowed to install plugins on this site.' ,'themify' );
               
        }
        unset($plugin_info['desc'],$plugin_info['image'],$plugin_info['path'],$plugin_info['wp_hosted']);
        $result['plugins'][$plugin]=$plugin_info;
        }
        else{
        $result['plugins'][$plugin]=array(
            'error'=> __( 'Unknown plugin.','themify' ),
            'name'=>$plugin
        );
        }
    }
    unset($required_plugins,$all_plugins,$can_install);
    }
    $result['labels']=array(
    'head'=>__( 'This demo requires these plugins/addons:', 'themify' ),
    'import_warning'=>__( 'Proceed import without the required addons/plugins might show incomplete/missing content.', 'themify' ),
    'proceed_import'=> __( 'Proceed Import', 'themify' ),
    'erase'=>__( 'Erase ALL previously imported demo content', 'themify' ),
    'modify'=> __( 'Keep modified posts/pages', 'themify' ),
    'builder_img'=>__('Import Builder layout images (will take longer)','themify'),
    'install'=>__( 'Install', 'themify' ),
    'activate'=>__( 'Activate', 'themify' ),
    'buy'=>__( 'Buy', 'themify' ),
    'note'=>__('WARNING: Importing the demo content will override your Themify settings, menu and widget settings. It will also add the content (posts, pages, featured images, widgets, menus, etc.) to your site as per our demo setup. It is recommend to do on a fresh/development site.','themify'),
    'plugins'=>array(
        'activate_done'=>__('%plugin% successfully activated','themify'),
        'activate_fail'=>__('Failed to activate %plugin%: %error%','themify'),
        'install_fail'=>__('Failed to install %plugin%: %error%','themify'),
        'install_done'=>__('%plugin% successfully installed','themify'),
        'install'=>__('Installing %plugin%','themify'),
        'activate'=>__('Activating %plugin%','themify'),
    )
    );
    $result['has_demo']=Themify_Import_Helper::has_demo_content();
    wp_send_json_success($result);
}

/**
 * Install or Activate plugin for skin demo import and themify updater
 */
function themify_activate_plugin() {
    check_ajax_referer( 'tf_nonce', 'nonce' );
    $err='';
    if(!empty($_POST['plugin']) && current_user_can( 'edit_theme_options' ) ){
        $plugin=sanitize_key($_POST['plugin']);
        $plugin_info = themify_get_known_plugin_info($plugin);
        if($plugin_info!==false){
            $allPlugins= get_plugins();
            if(isset($allPlugins[$plugin_info['path']])){
                unset($allPlugins);
                if(!is_plugin_active( $plugin_info['path'] )){
                    if(current_user_can( 'activate_plugin', $plugin )){
                        $result =activate_plugin($plugin_info['path'],false,false);
                        if(is_wp_error($result)){
                            $err=$result->get_error_message();
                        }
                    }
                    else{
                        $err=__( 'You are not allowed to activate this plugin.','themify' );
                    }
                }
            }
            elseif(current_user_can( 'install_plugins' )){
                $isFree=!empty($plugin_info['wp_hosted']);
                if($isFree===false){
                    if($plugin==='themify-updater'){
                        if(!empty( $_FILES['data'] ) && is_file($_FILES['data']['tmp_name'] )){
                            require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
                            $updgrader=new Plugin_Upgrader();
                            $result=$updgrader->install($_FILES['data']['tmp_name'],array('overwrite_package'=>true));
                            if($result===true){
                                $result =activate_plugin($plugin_info['path'],false,false);
                                if(is_wp_error($result)){
                                    $err=$result->get_error_message();
                                }
                            }
                            else{
                                $err= is_wp_error($result)?$result->get_error_message():__('Themify Updater installation failed','themify');
                            }
                        }
                        else{
                            $err=array('install_updater'=>1);
                        }
                        }
                        else{
                            if(!class_exists('Themify_Updater',false)){
                                $updater=themify_get_known_plugin_info('themify-updater');
                                if(isset($allPlugins[$updater['path']]) && !is_plugin_active( $updater['path'] )){
                                    $result =activate_plugin($updater['path'],false,false);
                                    if(is_wp_error($result)){
                                        $err=$result->get_error_message();
                                    }
                                    elseif(!class_exists('Themify_Updater',false) && function_exists('themify_updater_init')){//plugins_loaded event already fired
                                        themify_updater_init();
                                    }
                                }
                                unset($updater);
                            }
                            unset($allPlugins);
                            if($err===''){
                                $themify_updater = class_exists('Themify_Updater',false)?Themify_Updater::get_instance():null;
                                if($themify_updater && method_exists($themify_updater, 'get_versions')){
                                    $versions = $themify_updater->get_versions();
                                    $isFree=!empty($versions)?$versions->has_attribute($plugin, 'wp_hosted'):false;
                                    unset($versions);
                                }
                                else{
                                    $themify_updater=null;
                                }
                            }
                        }
                    }
                    if($err==='' && $plugin!=='themify-updater'){
                        if($isFree===true){
                            $_POST['slug']=$plugin;
                            $_REQUEST['_ajax_nonce']=wp_create_nonce( 'updates' );
                            wp_ajax_install_plugin();
                        }
                        elseif(empty($themify_updater)){
                            $err=array('install_updater'=>1);
                        }
                        else{
                            if($themify_updater->has_error()){
                                $err=array('check_license'=>1,'errorMessage'=>sprintf(__('A valid membership is required to install %s','themify'),$plugin_info['name']));
                            }
                            elseif(!$themify_updater->has_access( $plugin )){
                                $err=array('buy'=>1,'errorMessage'=>sprintf(__('Your membership/license does not include %s','themify'),$plugin_info['name']),'url'=>$plugin_info['page']);
                            }
                            else{
                                $nonce=wp_create_nonce( 'install-plugin_'. str_replace('-plugin', '', $plugin) );
                                $installUrl= add_query_arg(array('action'=>'install-plugin','plugin'=>$plugin,'_wpnonce'=>$nonce),self_admin_url( 'update.php' ));
                                wp_send_json_success(array('install_plugin_url'=>$installUrl));
                            }

                        }
                        unset($themify_updater,$plugin_info);
                    }
            }
            else{
                $err=__( 'You are not allowed to install plugins on this site.','themify' );
            }
            if($err===''){
                wp_send_json_success();
            }
        }
        else{
            $err=__('Unknown Plugin.','themify');
        }
    }
    wp_send_json_error($err);
}

/**
 * Handle the display of the Themify News admin dashboard widget
 *
 * Hooked to wp_ajax_themify_news_widget
 */
function themify_news_widget() {
    ob_start();
    wp_widget_rss_output( 'https://themify.me/blog/feed', array(
        'title'         => esc_html__( 'Themify News', 'themify' ),
        'items'         => 4,
        'show_summary'  => 1,
        'show_author'   => 0,
        'show_date'     => 1
    ) );
    $cache_key = 'themify_news_dashboard_widget';
    Themify_Storage::set( $cache_key, ob_get_flush(), 12 * HOUR_IN_SECONDS ); // Default lifetime in cache of 12 hours (same as the feeds)
    wp_die();
}


/**
 * Handle the upload json file
 */
function themify_upload_json(){
    check_ajax_referer( 'tf_nonce', 'nonce' );
    if (!empty($_POST['file'])) {
        if (!current_user_can('upload_files')) {
            $error = __('You aren`t allowed to upload file', 'themify');
        } else {
            if ( isset( $_POST['data'] ) ) {
                $data = stripslashes_deep( $_POST['data'] );
            }
            elseif ( isset( $_FILES['data'] ) ) {
                $data = file_get_contents( $_FILES['data']['tmp_name'] );
            }
            if(!empty($data)){
                global $wpdb;
                $slug = sanitize_file_name(pathinfo( $_POST['file'],PATHINFO_FILENAME));
                $filename= $slug.'.json';
                $sql= sprintf('post_name="%1$s" OR post_name="%1$s-1" OR post_name="%1$s-2" OR post_name="%1$s-3"',esc_sql($slug));
                $query = $wpdb->get_row("SELECT ID FROM {$wpdb->prefix}posts WHERE ({$sql}) AND post_type='attachment' LIMIT 1" );
                $attach_id=!empty($query) ? $query->ID : null;
                if($attach_id!==null) {
                    $duplicate = get_attached_file($attach_id);
                    if(!$duplicate ||!is_file($duplicate) || sha1_file($duplicate)!==sha1($data)){
                        if($duplicate && !is_file($duplicate)){
                            wp_delete_attachment($attach_id);
                        }
                        $attach_id=null;
                    }
                    unset($duplicate);
                }
                unset($query,$sql);
                if(empty($attach_id)){
                    $tmp = trailingslashit(sys_get_temp_dir()).$filename;
                    if(file_put_contents($tmp,$data)){
                        $file = array(
                            'size'     => filesize($tmp),
                            'name'=> $filename,
                            'error'=>0,
                            'tmp_name' => $tmp
                        );
                        $title=!empty($_POST['title'])?sanitize_textarea_field($_POST['title']):'';
                        $attach_id=media_handle_sideload( $file, 0,$title,array(
                            'post_mime_type'=>'application/json',
                            'post_name'=>$slug
                        ) );
                        if(is_wp_error($attach_id)){
                            $error=$attach_id->get_error_message();
                            $attach_id=null;
                            if(is_file($tmp)){
                                unlink($tmp);
                            }
                        }
                        unset($tmp,$file);
                    }else{
                        $error = __('Can`t write tmp file', 'themify');
                    }
                }
                if(!empty($attach_id)){
                    wp_send_json_success(wp_get_attachment_url($attach_id));
                }
            }else{
                $error = __('Upload data is corrupted', 'themify');
            }
        }
        wp_send_json_error($error);
    }
}

function themify_update_license() {
    check_ajax_referer( 'tf_nonce', 'nonce' );
    if(current_user_can( 'manage_options' )){
        $themify_updater = Themify_Updater::get_instance();
        $result = $themify_updater->menu_p(true);
        if(true === $result){
            $theme = wp_get_theme();
            $theme = is_child_theme() ? $theme->parent() : $theme;
            ob_start();
            $themify_updater->themify_reinstall_theme( $theme->stylesheet );
            $result = array('html'=>ob_get_clean());
            wp_send_json_success($result);
        }
        else{
            $msg = $result===false?__('Invalid license key. Please enter your Themify username and a valid license key.','themify'):
                __('You need the latest Themify Updater plugin for this feature. Please update your Themify Updater plugin.','themify');

            wp_send_json_error($msg);
        }
    }
}
